/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.database.model.CreateDbHomeFromDatabaseDetails;
import com.oracle.bmc.database.model.DataCollectionOptions;
import com.oracle.bmc.database.model.DbSystemOptions;
import com.oracle.bmc.database.model.LaunchDbSystemBase;
import com.oracle.bmc.http.internal.BmcEnum;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="source")
@JsonFilter(value="explicitlySetFilter")
public final class LaunchDbSystemFromDatabaseDetails
extends LaunchDbSystemBase {
    @JsonProperty(value="dbHome")
    private final CreateDbHomeFromDatabaseDetails dbHome;
    @JsonProperty(value="databaseEdition")
    private final DatabaseEdition databaseEdition;
    @JsonProperty(value="diskRedundancy")
    private final DiskRedundancy diskRedundancy;
    @JsonProperty(value="licenseModel")
    private final LicenseModel licenseModel;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public LaunchDbSystemFromDatabaseDetails(String compartmentId, List<String> faultDomains, String displayName, String availabilityDomain, String subnetId, String backupSubnetId, List<String> nsgIds, List<String> backupNetworkNsgIds, String shape, String timeZone, DbSystemOptions dbSystemOptions, LaunchDbSystemBase.StorageVolumePerformanceMode storageVolumePerformanceMode, Boolean sparseDiskgroup, List<String> sshPublicKeys, String hostname, String domain, Integer cpuCoreCount, String clusterName, Integer dataStoragePercentage, Integer initialDataStorageSizeInGB, String kmsKeyId, String kmsKeyVersionId, Integer nodeCount, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags, String privateIp, DataCollectionOptions dataCollectionOptions, CreateDbHomeFromDatabaseDetails dbHome, DatabaseEdition databaseEdition, DiskRedundancy diskRedundancy, LicenseModel licenseModel) {
        super(compartmentId, faultDomains, displayName, availabilityDomain, subnetId, backupSubnetId, nsgIds, backupNetworkNsgIds, shape, timeZone, dbSystemOptions, storageVolumePerformanceMode, sparseDiskgroup, sshPublicKeys, hostname, domain, cpuCoreCount, clusterName, dataStoragePercentage, initialDataStorageSizeInGB, kmsKeyId, kmsKeyVersionId, nodeCount, freeformTags, definedTags, privateIp, dataCollectionOptions);
        this.dbHome = dbHome;
        this.databaseEdition = databaseEdition;
        this.diskRedundancy = diskRedundancy;
        this.licenseModel = licenseModel;
    }

    public CreateDbHomeFromDatabaseDetails getDbHome() {
        return this.dbHome;
    }

    public DatabaseEdition getDatabaseEdition() {
        return this.databaseEdition;
    }

    public DiskRedundancy getDiskRedundancy() {
        return this.diskRedundancy;
    }

    public LicenseModel getLicenseModel() {
        return this.licenseModel;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("LaunchDbSystemFromDatabaseDetails(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", dbHome=").append(String.valueOf((Object)this.dbHome));
        sb.append(", databaseEdition=").append(String.valueOf((Object)this.databaseEdition));
        sb.append(", diskRedundancy=").append(String.valueOf((Object)this.diskRedundancy));
        sb.append(", licenseModel=").append(String.valueOf((Object)this.licenseModel));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LaunchDbSystemFromDatabaseDetails)) {
            return false;
        }
        LaunchDbSystemFromDatabaseDetails other = (LaunchDbSystemFromDatabaseDetails)((Object)o);
        return Objects.equals((Object)this.dbHome, (Object)other.dbHome) && Objects.equals((Object)this.databaseEdition, (Object)other.databaseEdition) && Objects.equals((Object)this.diskRedundancy, (Object)other.diskRedundancy) && Objects.equals((Object)this.licenseModel, (Object)other.licenseModel) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.dbHome == null ? 43 : this.dbHome.hashCode());
        result = result * 59 + (this.databaseEdition == null ? 43 : this.databaseEdition.hashCode());
        result = result * 59 + (this.diskRedundancy == null ? 43 : this.diskRedundancy.hashCode());
        result = result * 59 + (this.licenseModel == null ? 43 : this.licenseModel.hashCode());
        return result;
    }

    public static enum LicenseModel implements BmcEnum
    {
        LicenseIncluded("LICENSE_INCLUDED"),
        BringYourOwnLicense("BRING_YOUR_OWN_LICENSE");

        private final String value;
        private static Map<String, LicenseModel> map;

        private LicenseModel(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LicenseModel create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid LicenseModel: " + key);
        }

        static {
            map = new HashMap<String, LicenseModel>();
            for (LicenseModel v : LicenseModel.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum DiskRedundancy implements BmcEnum
    {
        High("HIGH"),
        Normal("NORMAL");

        private final String value;
        private static Map<String, DiskRedundancy> map;

        private DiskRedundancy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static DiskRedundancy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid DiskRedundancy: " + key);
        }

        static {
            map = new HashMap<String, DiskRedundancy>();
            for (DiskRedundancy v : DiskRedundancy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum DatabaseEdition implements BmcEnum
    {
        StandardEdition("STANDARD_EDITION"),
        EnterpriseEdition("ENTERPRISE_EDITION"),
        EnterpriseEditionHighPerformance("ENTERPRISE_EDITION_HIGH_PERFORMANCE"),
        EnterpriseEditionExtremePerformance("ENTERPRISE_EDITION_EXTREME_PERFORMANCE");

        private final String value;
        private static Map<String, DatabaseEdition> map;

        private DatabaseEdition(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static DatabaseEdition create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid DatabaseEdition: " + key);
        }

        static {
            map = new HashMap<String, DatabaseEdition>();
            for (DatabaseEdition v : DatabaseEdition.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="faultDomains")
        private List<String> faultDomains;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="availabilityDomain")
        private String availabilityDomain;
        @JsonProperty(value="subnetId")
        private String subnetId;
        @JsonProperty(value="backupSubnetId")
        private String backupSubnetId;
        @JsonProperty(value="nsgIds")
        private List<String> nsgIds;
        @JsonProperty(value="backupNetworkNsgIds")
        private List<String> backupNetworkNsgIds;
        @JsonProperty(value="shape")
        private String shape;
        @JsonProperty(value="timeZone")
        private String timeZone;
        @JsonProperty(value="dbSystemOptions")
        private DbSystemOptions dbSystemOptions;
        @JsonProperty(value="storageVolumePerformanceMode")
        private LaunchDbSystemBase.StorageVolumePerformanceMode storageVolumePerformanceMode;
        @JsonProperty(value="sparseDiskgroup")
        private Boolean sparseDiskgroup;
        @JsonProperty(value="sshPublicKeys")
        private List<String> sshPublicKeys;
        @JsonProperty(value="hostname")
        private String hostname;
        @JsonProperty(value="domain")
        private String domain;
        @JsonProperty(value="cpuCoreCount")
        private Integer cpuCoreCount;
        @JsonProperty(value="clusterName")
        private String clusterName;
        @JsonProperty(value="dataStoragePercentage")
        private Integer dataStoragePercentage;
        @JsonProperty(value="initialDataStorageSizeInGB")
        private Integer initialDataStorageSizeInGB;
        @JsonProperty(value="kmsKeyId")
        private String kmsKeyId;
        @JsonProperty(value="kmsKeyVersionId")
        private String kmsKeyVersionId;
        @JsonProperty(value="nodeCount")
        private Integer nodeCount;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="privateIp")
        private String privateIp;
        @JsonProperty(value="dataCollectionOptions")
        private DataCollectionOptions dataCollectionOptions;
        @JsonProperty(value="dbHome")
        private CreateDbHomeFromDatabaseDetails dbHome;
        @JsonProperty(value="databaseEdition")
        private DatabaseEdition databaseEdition;
        @JsonProperty(value="diskRedundancy")
        private DiskRedundancy diskRedundancy;
        @JsonProperty(value="licenseModel")
        private LicenseModel licenseModel;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder faultDomains(List<String> faultDomains) {
            this.faultDomains = faultDomains;
            this.__explicitlySet__.add("faultDomains");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder availabilityDomain(String availabilityDomain) {
            this.availabilityDomain = availabilityDomain;
            this.__explicitlySet__.add("availabilityDomain");
            return this;
        }

        public Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            this.__explicitlySet__.add("subnetId");
            return this;
        }

        public Builder backupSubnetId(String backupSubnetId) {
            this.backupSubnetId = backupSubnetId;
            this.__explicitlySet__.add("backupSubnetId");
            return this;
        }

        public Builder nsgIds(List<String> nsgIds) {
            this.nsgIds = nsgIds;
            this.__explicitlySet__.add("nsgIds");
            return this;
        }

        public Builder backupNetworkNsgIds(List<String> backupNetworkNsgIds) {
            this.backupNetworkNsgIds = backupNetworkNsgIds;
            this.__explicitlySet__.add("backupNetworkNsgIds");
            return this;
        }

        public Builder shape(String shape) {
            this.shape = shape;
            this.__explicitlySet__.add("shape");
            return this;
        }

        public Builder timeZone(String timeZone) {
            this.timeZone = timeZone;
            this.__explicitlySet__.add("timeZone");
            return this;
        }

        public Builder dbSystemOptions(DbSystemOptions dbSystemOptions) {
            this.dbSystemOptions = dbSystemOptions;
            this.__explicitlySet__.add("dbSystemOptions");
            return this;
        }

        public Builder storageVolumePerformanceMode(LaunchDbSystemBase.StorageVolumePerformanceMode storageVolumePerformanceMode) {
            this.storageVolumePerformanceMode = storageVolumePerformanceMode;
            this.__explicitlySet__.add("storageVolumePerformanceMode");
            return this;
        }

        public Builder sparseDiskgroup(Boolean sparseDiskgroup) {
            this.sparseDiskgroup = sparseDiskgroup;
            this.__explicitlySet__.add("sparseDiskgroup");
            return this;
        }

        public Builder sshPublicKeys(List<String> sshPublicKeys) {
            this.sshPublicKeys = sshPublicKeys;
            this.__explicitlySet__.add("sshPublicKeys");
            return this;
        }

        public Builder hostname(String hostname) {
            this.hostname = hostname;
            this.__explicitlySet__.add("hostname");
            return this;
        }

        public Builder domain(String domain) {
            this.domain = domain;
            this.__explicitlySet__.add("domain");
            return this;
        }

        public Builder cpuCoreCount(Integer cpuCoreCount) {
            this.cpuCoreCount = cpuCoreCount;
            this.__explicitlySet__.add("cpuCoreCount");
            return this;
        }

        public Builder clusterName(String clusterName) {
            this.clusterName = clusterName;
            this.__explicitlySet__.add("clusterName");
            return this;
        }

        public Builder dataStoragePercentage(Integer dataStoragePercentage) {
            this.dataStoragePercentage = dataStoragePercentage;
            this.__explicitlySet__.add("dataStoragePercentage");
            return this;
        }

        public Builder initialDataStorageSizeInGB(Integer initialDataStorageSizeInGB) {
            this.initialDataStorageSizeInGB = initialDataStorageSizeInGB;
            this.__explicitlySet__.add("initialDataStorageSizeInGB");
            return this;
        }

        public Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            this.__explicitlySet__.add("kmsKeyId");
            return this;
        }

        public Builder kmsKeyVersionId(String kmsKeyVersionId) {
            this.kmsKeyVersionId = kmsKeyVersionId;
            this.__explicitlySet__.add("kmsKeyVersionId");
            return this;
        }

        public Builder nodeCount(Integer nodeCount) {
            this.nodeCount = nodeCount;
            this.__explicitlySet__.add("nodeCount");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder privateIp(String privateIp) {
            this.privateIp = privateIp;
            this.__explicitlySet__.add("privateIp");
            return this;
        }

        public Builder dataCollectionOptions(DataCollectionOptions dataCollectionOptions) {
            this.dataCollectionOptions = dataCollectionOptions;
            this.__explicitlySet__.add("dataCollectionOptions");
            return this;
        }

        public Builder dbHome(CreateDbHomeFromDatabaseDetails dbHome) {
            this.dbHome = dbHome;
            this.__explicitlySet__.add("dbHome");
            return this;
        }

        public Builder databaseEdition(DatabaseEdition databaseEdition) {
            this.databaseEdition = databaseEdition;
            this.__explicitlySet__.add("databaseEdition");
            return this;
        }

        public Builder diskRedundancy(DiskRedundancy diskRedundancy) {
            this.diskRedundancy = diskRedundancy;
            this.__explicitlySet__.add("diskRedundancy");
            return this;
        }

        public Builder licenseModel(LicenseModel licenseModel) {
            this.licenseModel = licenseModel;
            this.__explicitlySet__.add("licenseModel");
            return this;
        }

        public LaunchDbSystemFromDatabaseDetails build() {
            LaunchDbSystemFromDatabaseDetails model = new LaunchDbSystemFromDatabaseDetails(this.compartmentId, this.faultDomains, this.displayName, this.availabilityDomain, this.subnetId, this.backupSubnetId, this.nsgIds, this.backupNetworkNsgIds, this.shape, this.timeZone, this.dbSystemOptions, this.storageVolumePerformanceMode, this.sparseDiskgroup, this.sshPublicKeys, this.hostname, this.domain, this.cpuCoreCount, this.clusterName, this.dataStoragePercentage, this.initialDataStorageSizeInGB, this.kmsKeyId, this.kmsKeyVersionId, this.nodeCount, this.freeformTags, this.definedTags, this.privateIp, this.dataCollectionOptions, this.dbHome, this.databaseEdition, this.diskRedundancy, this.licenseModel);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(LaunchDbSystemFromDatabaseDetails model) {
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("faultDomains")) {
                this.faultDomains(model.getFaultDomains());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("availabilityDomain")) {
                this.availabilityDomain(model.getAvailabilityDomain());
            }
            if (model.wasPropertyExplicitlySet("subnetId")) {
                this.subnetId(model.getSubnetId());
            }
            if (model.wasPropertyExplicitlySet("backupSubnetId")) {
                this.backupSubnetId(model.getBackupSubnetId());
            }
            if (model.wasPropertyExplicitlySet("nsgIds")) {
                this.nsgIds(model.getNsgIds());
            }
            if (model.wasPropertyExplicitlySet("backupNetworkNsgIds")) {
                this.backupNetworkNsgIds(model.getBackupNetworkNsgIds());
            }
            if (model.wasPropertyExplicitlySet("shape")) {
                this.shape(model.getShape());
            }
            if (model.wasPropertyExplicitlySet("timeZone")) {
                this.timeZone(model.getTimeZone());
            }
            if (model.wasPropertyExplicitlySet("dbSystemOptions")) {
                this.dbSystemOptions(model.getDbSystemOptions());
            }
            if (model.wasPropertyExplicitlySet("storageVolumePerformanceMode")) {
                this.storageVolumePerformanceMode(model.getStorageVolumePerformanceMode());
            }
            if (model.wasPropertyExplicitlySet("sparseDiskgroup")) {
                this.sparseDiskgroup(model.getSparseDiskgroup());
            }
            if (model.wasPropertyExplicitlySet("sshPublicKeys")) {
                this.sshPublicKeys(model.getSshPublicKeys());
            }
            if (model.wasPropertyExplicitlySet("hostname")) {
                this.hostname(model.getHostname());
            }
            if (model.wasPropertyExplicitlySet("domain")) {
                this.domain(model.getDomain());
            }
            if (model.wasPropertyExplicitlySet("cpuCoreCount")) {
                this.cpuCoreCount(model.getCpuCoreCount());
            }
            if (model.wasPropertyExplicitlySet("clusterName")) {
                this.clusterName(model.getClusterName());
            }
            if (model.wasPropertyExplicitlySet("dataStoragePercentage")) {
                this.dataStoragePercentage(model.getDataStoragePercentage());
            }
            if (model.wasPropertyExplicitlySet("initialDataStorageSizeInGB")) {
                this.initialDataStorageSizeInGB(model.getInitialDataStorageSizeInGB());
            }
            if (model.wasPropertyExplicitlySet("kmsKeyId")) {
                this.kmsKeyId(model.getKmsKeyId());
            }
            if (model.wasPropertyExplicitlySet("kmsKeyVersionId")) {
                this.kmsKeyVersionId(model.getKmsKeyVersionId());
            }
            if (model.wasPropertyExplicitlySet("nodeCount")) {
                this.nodeCount(model.getNodeCount());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("privateIp")) {
                this.privateIp(model.getPrivateIp());
            }
            if (model.wasPropertyExplicitlySet("dataCollectionOptions")) {
                this.dataCollectionOptions(model.getDataCollectionOptions());
            }
            if (model.wasPropertyExplicitlySet("dbHome")) {
                this.dbHome(model.getDbHome());
            }
            if (model.wasPropertyExplicitlySet("databaseEdition")) {
                this.databaseEdition(model.getDatabaseEdition());
            }
            if (model.wasPropertyExplicitlySet("diskRedundancy")) {
                this.diskRedundancy(model.getDiskRedundancy());
            }
            if (model.wasPropertyExplicitlySet("licenseModel")) {
                this.licenseModel(model.getLicenseModel());
            }
            return this;
        }
    }
}

