/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dashboard;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.List;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.dashboard.WidgetComponents;
import org.netbeans.spi.dashboard.DashboardDisplayer;
import org.netbeans.spi.dashboard.DashboardWidget;
import org.netbeans.spi.dashboard.WidgetElement;
import org.openide.util.Lookup;

final class WidgetPanel
extends JPanel {
    private final DashboardDisplayer displayer;
    private final DashboardDisplayer.WidgetReference widgetRef;
    private final DashboardWidget widget;
    private final Accessor accessor;
    private final Color titleColor;
    private String title;
    private List<WidgetElement> elements;

    private WidgetPanel(DashboardDisplayer displayer, DashboardDisplayer.WidgetReference widgetRef) {
        this.displayer = Objects.requireNonNull(displayer);
        this.widgetRef = Objects.requireNonNull(widgetRef);
        this.widget = widgetRef.widget();
        this.accessor = new Accessor();
        this.titleColor = null;
        this.setLayout(new BorderLayout());
        this.title = "";
        this.elements = List.of();
        this.attachWidget();
    }

    private void attachWidget() {
        this.widget.attach(this.accessor);
        this.reconfigure();
    }

    void notifyShowing() {
        this.widget.showing(this.accessor);
    }

    void notifyHidden() {
        this.widget.hidden(this.accessor);
    }

    private void reconfigure() {
        String newTitle = this.widget.title(this.accessor);
        List<WidgetElement> newElements = List.copyOf(this.widget.elements(this.accessor));
        if (!Objects.equals(this.title, newTitle) || !Objects.equals(this.elements, newElements)) {
            this.title = newTitle;
            this.elements = newElements;
            this.build();
        }
    }

    private void build() {
        this.removeAll();
        if (!this.title.isEmpty()) {
            JComponent titleComponent = WidgetComponents.titleComponentFor(this.title);
            if (this.titleColor != null) {
                titleComponent.setForeground(this.titleColor);
            }
            this.add((Component)titleComponent, "North");
        }
        JPanel container = new JPanel(new GridBagLayout());
        JScrollPane scrollPane = new JScrollPane(container, 20, 31);
        scrollPane.getVerticalScrollBar().setUnitIncrement(20);
        scrollPane.setBorder(BorderFactory.createEmptyBorder());
        scrollPane.setViewportBorder(BorderFactory.createEmptyBorder());
        this.add((Component)scrollPane, "Center");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        Insets defaultInsets = new Insets(2, 2, 2, 2);
        gbc.anchor = 18;
        for (int i = 0; i < this.elements.size(); ++i) {
            JComponent cmp = WidgetComponents.componentFor(this.elements.get(i));
            if (cmp == null) continue;
            if (cmp instanceof JTextComponent) {
                gbc.fill = 2;
                Font font = cmp.getFont();
                int space = font != null ? font.getSize() / 2 : 6;
                gbc.insets = new Insets(2, 2, space, 2);
            } else {
                gbc.fill = 0;
                gbc.insets = defaultInsets;
            }
            if (i == this.elements.size() - 1) {
                gbc.weighty = 1.0;
            }
            container.add((Component)cmp, gbc);
        }
        this.revalidate();
        this.repaint();
    }

    static WidgetPanel create(DashboardDisplayer displayer, DashboardDisplayer.WidgetReference widgetRef) {
        return new WidgetPanel(displayer, widgetRef);
    }

    private class Accessor
    implements DashboardDisplayer.Panel {
        private Accessor() {
        }

        public Lookup getLookup() {
            return WidgetPanel.this.displayer.getLookup();
        }

        @Override
        public String id() {
            return WidgetPanel.this.widgetRef.id();
        }

        @Override
        public void refresh() {
            EventQueue.invokeLater(WidgetPanel.this::reconfigure);
        }

        @Override
        public DashboardDisplayer.WidgetReference widgetReference() {
            return WidgetPanel.this.widgetRef;
        }
    }
}

