/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.verification;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.HintFix;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.csl.spi.support.CancelSupport;
import org.netbeans.modules.php.api.PhpVersion;
import org.netbeans.modules.php.editor.CodeUtils;
import org.netbeans.modules.php.editor.PredefinedSymbols;
import org.netbeans.modules.php.editor.model.FileScope;
import org.netbeans.modules.php.editor.model.impl.VariousUtils;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.Attribute;
import org.netbeans.modules.php.editor.parser.astnodes.AttributeDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.Attributed;
import org.netbeans.modules.php.editor.parser.astnodes.ClassDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.ClassInstanceCreation;
import org.netbeans.modules.php.editor.parser.astnodes.EnumDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.FieldsDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.InterfaceDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.TraitDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.visitors.DefaultVisitor;
import org.netbeans.modules.php.editor.verification.Bundle;
import org.netbeans.modules.php.editor.verification.HintErrorRule;
import org.netbeans.modules.php.editor.verification.PHPRuleContext;
import org.openide.filesystems.FileObject;

public class IncorrectDeprecatedAttributeHintError
extends HintErrorRule {
    private FileObject fileObject;

    public String getDisplayName() {
        return Bundle.IncorrectDeprecatedAttributeHintError_displayName();
    }

    @Override
    public void invoke(PHPRuleContext context, List<Hint> hints) {
        PHPParseResult phpParseResult = (PHPParseResult)context.parserResult;
        if (phpParseResult.getProgram() == null) {
            return;
        }
        FileScope fileScope = context.fileScope;
        this.fileObject = phpParseResult.getSnapshot().getSource().getFileObject();
        if (fileScope != null && this.fileObject != null && this.appliesTo(this.getPhpVersion())) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            CheckVisitor checkVisitor = new CheckVisitor(fileScope);
            phpParseResult.getProgram().accept(checkVisitor);
            this.addIncorrectAttributeHint(checkVisitor.getIncorrectTypeAttributes(), Bundle.IncorrectDeprecatedAttributeHintError_incorrect_deprecated_attribute_desc(PredefinedSymbols.Attributes.DEPRECATED.getName(), Bundle.IncorrectDeprecatedAttributeHintError_type()), hints);
            this.addIncorrectAttributeHint(checkVisitor.getIncorrectFieldAttributes(), Bundle.IncorrectDeprecatedAttributeHintError_incorrect_deprecated_attribute_desc(PredefinedSymbols.Attributes.DEPRECATED.getName(), Bundle.IncorrectDeprecatedAttributeHintError_field()), hints);
        }
    }

    protected PhpVersion getPhpVersion() {
        return CodeUtils.getPhpVersion(this.fileObject);
    }

    private boolean appliesTo(PhpVersion phpVersion) {
        return phpVersion.compareTo((Enum)PhpVersion.PHP_84) >= 0;
    }

    private void addIncorrectAttributeHint(List<AttributeDeclaration> attributeDeclarations, String description, List<Hint> hints) {
        for (AttributeDeclaration attributeDeclaration : attributeDeclarations) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            this.addHint(attributeDeclaration, description, hints);
        }
    }

    private void addHint(ASTNode node, String description, List<Hint> hints) {
        this.addHint(node, description, hints, Collections.emptyList());
    }

    private void addHint(ASTNode node, String description, List<Hint> hints, List<HintFix> fixes) {
        hints.add(new Hint((Rule)this, description, this.fileObject, new OffsetRange(node.getStartOffset(), node.getEndOffset()), fixes, 500));
    }

    private static final class CheckVisitor
    extends DefaultVisitor {
        private final FileScope fileScope;
        private final List<AttributeDeclaration> incorrectTypeAttributes = new ArrayList<AttributeDeclaration>();
        private final List<AttributeDeclaration> incorrectFieldAttributes = new ArrayList<AttributeDeclaration>();

        public CheckVisitor(FileScope fileScope) {
            this.fileScope = fileScope;
        }

        public List<AttributeDeclaration> getIncorrectTypeAttributes() {
            return Collections.unmodifiableList(this.incorrectTypeAttributes);
        }

        public List<AttributeDeclaration> getIncorrectFieldAttributes() {
            return Collections.unmodifiableList(this.incorrectFieldAttributes);
        }

        @Override
        public void visit(ClassDeclaration node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            if (node.isAttributed()) {
                this.checkAttributes(node);
            }
            super.visit(node);
        }

        @Override
        public void visit(InterfaceDeclaration node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            if (node.isAttributed()) {
                this.checkAttributes(node);
            }
            super.visit(node);
        }

        @Override
        public void visit(TraitDeclaration node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            if (node.isAttributed()) {
                this.checkAttributes(node);
            }
            super.visit(node);
        }

        @Override
        public void visit(EnumDeclaration node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            if (node.isAttributed()) {
                this.checkAttributes(node);
            }
            super.visit(node);
        }

        @Override
        public void visit(ClassInstanceCreation node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            if (node.isAnonymous() && node.isAttributed()) {
                this.checkAttributes(node);
            }
            super.visit(node);
        }

        @Override
        public void visit(FieldsDeclaration node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            if (node.isAttributed()) {
                this.checkAttributes(node);
            }
            super.visit(node);
        }

        private void checkAttributes(ASTNode node) {
            if (!(node instanceof Attributed)) {
                return;
            }
            for (Attribute attribute : ((Attributed)((Object)node)).getAttributes()) {
                if (CancelSupport.getDefault().isCancelled()) {
                    return;
                }
                this.checkAttribute(attribute, node);
            }
        }

        private void checkAttribute(Attribute attribute, ASTNode node) {
            for (AttributeDeclaration attributeDeclaration : attribute.getAttributeDeclarations()) {
                if (CancelSupport.getDefault().isCancelled()) {
                    return;
                }
                String attributeName = CodeUtils.extractQualifiedName(attributeDeclaration.getAttributeName());
                if (!VariousUtils.isPredefinedAttributeName(PredefinedSymbols.Attributes.DEPRECATED, attributeName, this.fileScope, attributeDeclaration.getStartOffset())) continue;
                this.addIncorrectAttribute(node, attributeDeclaration);
                break;
            }
        }

        private void addIncorrectAttribute(ASTNode node, AttributeDeclaration attributeDeclaration) {
            if (CodeUtils.isTypeDeclaration(node)) {
                this.incorrectTypeAttributes.add(attributeDeclaration);
            } else if (node instanceof FieldsDeclaration) {
                this.incorrectFieldAttributes.add(attributeDeclaration);
            } else assert (false) : "TypeDeclaration or FieldsDeclaration is expected, but got " + node.getClass().getName();
        }
    }
}

