/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.verification;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.BadLocationException;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.csl.api.Error;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.GroupUseStatementPart;
import org.netbeans.modules.php.editor.parser.astnodes.SingleUseStatementPart;
import org.netbeans.modules.php.editor.parser.astnodes.UseStatement;
import org.netbeans.modules.php.editor.parser.astnodes.visitors.DefaultVisitor;
import org.netbeans.modules.php.editor.verification.Bundle;
import org.netbeans.modules.php.editor.verification.PHPRuleContext;
import org.netbeans.modules.php.editor.verification.UnhandledErrorRule;
import org.netbeans.modules.php.editor.verification.VerificationError;
import org.openide.filesystems.FileObject;

public class EmptyGroupUseHintError
extends UnhandledErrorRule {
    private static final Logger LOGGER = Logger.getLogger(EmptyGroupUseHintError.class.getName());
    private static final Pattern GROUP_USE_PATTERN = Pattern.compile(".*\\{(.+)\\}", 32);

    public String getDisplayName() {
        return Bundle.EmptyGroupUseHintError_displayName();
    }

    @Override
    public void invoke(PHPRuleContext context, List<Error> result) {
        FileObject fileObject;
        PHPParseResult phpParseResult = (PHPParseResult)context.parserResult;
        if (phpParseResult.getProgram() != null && (fileObject = phpParseResult.getSnapshot().getSource().getFileObject()) != null) {
            CheckVisitor checkVisitor = new CheckVisitor(fileObject, context.doc);
            phpParseResult.getProgram().accept(checkVisitor);
            result.addAll(checkVisitor.getErrors());
        }
    }

    private static final class CheckVisitor
    extends DefaultVisitor {
        private final List<VerificationError> errors = new ArrayList<VerificationError>();
        private final FileObject fileObject;
        private final BaseDocument baseDocument;

        CheckVisitor(FileObject fileObject, BaseDocument baseDocument) {
            assert (fileObject != null);
            this.fileObject = fileObject;
            this.baseDocument = baseDocument;
        }

        List<VerificationError> getErrors() {
            return Collections.unmodifiableList(this.errors);
        }

        @Override
        public void visit(UseStatement statement) {
            super.visit(statement);
        }

        @Override
        public void visit(GroupUseStatementPart statementPart) {
            List<SingleUseStatementPart> items = statementPart.getItems();
            if (items.isEmpty()) {
                int startOffset = statementPart.getStartOffset();
                int endOffset = statementPart.getEndOffset();
                int length = endOffset - startOffset;
                if (length > 0) {
                    try {
                        String blockText;
                        String trimed;
                        String statementText = this.baseDocument.getText(startOffset, length);
                        Matcher matcher = GROUP_USE_PATTERN.matcher(statementText);
                        if (matcher.matches() && (trimed = (blockText = matcher.group(1)).trim()).length() > 0) {
                            return;
                        }
                    }
                    catch (BadLocationException ex) {
                        LOGGER.log(Level.FINE, null, ex);
                    }
                }
                this.createError(statementPart);
            }
        }

        private void createError(ASTNode node) {
            this.createError(node.getStartOffset(), node.getEndOffset());
        }

        private void createError(int startOffset, int endOffset) {
            this.errors.add(new EmptyGroupUse(this.fileObject, startOffset, endOffset));
        }
    }

    private static final class EmptyGroupUse
    extends VerificationError {
        private static final String KEY = "Php.Empty.Group.Use";

        EmptyGroupUse(FileObject fileObject, int startOffset, int endOffset) {
            super(fileObject, startOffset, endOffset);
        }

        public String getDisplayName() {
            return Bundle.EmptyGroupUse_displayName();
        }

        public String getDescription() {
            return Bundle.EmptyGroupUse_description();
        }

        public String getKey() {
            return KEY;
        }
    }
}

