/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.completion;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.php.editor.CodeUtils;
import org.netbeans.modules.php.editor.api.QualifiedName;
import org.netbeans.modules.php.editor.completion.LatteUtils;
import org.netbeans.modules.php.editor.model.Model;
import org.netbeans.modules.php.editor.model.ModelUtils;
import org.netbeans.modules.php.editor.model.TypeScope;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.editor.parser.astnodes.Assignment;
import org.netbeans.modules.php.editor.parser.astnodes.ClassDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.FieldAccess;
import org.netbeans.modules.php.editor.parser.astnodes.MethodDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.Variable;
import org.netbeans.modules.php.editor.parser.astnodes.VariableBase;
import org.netbeans.modules.php.editor.parser.astnodes.visitors.DefaultVisitor;
import org.netbeans.modules.php.spi.templates.completion.CompletionProvider;
import org.openide.filesystems.FileObject;

public class LatteVariableCompletionProvider
implements CompletionProvider {
    private static final Logger LOGGER = Logger.getLogger(LatteVariableCompletionProvider.class.getName());
    private static final String PRESENTER_CLASS_SUFFIX = "Presenter";
    private static final String ACTION_METHOD_PREFIX = "action";
    private static final String RENDER_METHOD_PREFIX = "render";
    private static final String STARTUP_METHOD = "startup";
    private static final String BEFORE_RENDER_METHOD = "beforeRender";
    private Set<String> result;
    private FileObject templateFile;
    private String variablePrefix;

    public Set<String> getItems(FileObject templateFile, String variablePrefix) {
        this.result = new HashSet<String>();
        if (LatteUtils.isView(templateFile)) {
            this.templateFile = templateFile;
            this.variablePrefix = variablePrefix;
            this.processTemplateFile(templateFile);
        }
        return this.result;
    }

    private void processTemplateFile(FileObject templateFile) {
        FileObject presenterFile = LatteUtils.getPresenterFile(templateFile);
        if (presenterFile != null) {
            try {
                this.parsePresenter(presenterFile);
            }
            catch (ParseException ex) {
                LOGGER.log(Level.FINE, null, ex);
            }
        }
    }

    private void parsePresenter(FileObject presenterFile) throws ParseException {
        ParserManager.parse(Collections.singleton(Source.create((FileObject)presenterFile)), (UserTask)new UserTask(){

            public void run(ResultIterator resultIterator) throws Exception {
                PHPParseResult parseResult = (PHPParseResult)resultIterator.getParserResult();
                PresenterVisitor presenterVisitor = new PresenterVisitor(LatteVariableCompletionProvider.this.templateFile);
                presenterVisitor.scan(parseResult.getProgram());
                for (MethodDeclaration methodToScan : presenterVisitor.getMethodsToScan()) {
                    VariableVisitor variableVisitor = new VariableVisitor(parseResult.getModel(), LatteVariableCompletionProvider.this.variablePrefix);
                    methodToScan.accept(variableVisitor);
                    LatteVariableCompletionProvider.this.result.addAll(variableVisitor.getVariables());
                }
            }
        });
    }

    private static String extractActionName(FileObject templateFile) {
        String result = templateFile.getName();
        if (result.contains(".")) {
            String[] parts = result.split("\\.");
            assert (parts.length > 1);
            result = parts[1];
        }
        return result;
    }

    private static final class VariableVisitor
    extends DefaultVisitor {
        private static final List<String> TEMPLATE_DISPATCHER_TYPES = new ArrayList<String>();
        private static final String VARIABLE_PREFIX = "$";
        private final Set<FieldAccess> fieldAccesses = new HashSet<FieldAccess>();
        private final Model model;
        private final String variablePrefix;

        public VariableVisitor(Model model, String variablePrefix) {
            this.model = model;
            this.variablePrefix = variablePrefix;
        }

        @Override
        public void visit(Assignment node) {
            VariableBase leftHandSide = node.getLeftHandSide();
            if (leftHandSide instanceof FieldAccess) {
                this.fieldAccesses.add((FieldAccess)leftHandSide);
            }
        }

        public Set<String> getVariables() {
            HashSet<String> result = new HashSet<String>();
            ArrayList<TypeScope> templateTypes = new ArrayList<TypeScope>();
            for (String templateDispatcherType : TEMPLATE_DISPATCHER_TYPES) {
                templateTypes.addAll(this.model.getIndexScope().findTypes(QualifiedName.create(templateDispatcherType)));
            }
            for (FieldAccess fieldAccess : this.fieldAccesses) {
                Variable field;
                String varName;
                Collection<? extends TypeScope> types = ModelUtils.resolveType(this.model, fieldAccess.getDispatcher(), false);
                TypeScope dispatcherType = ModelUtils.getFirst(types);
                if (!VariableVisitor.existsTemplateTypeAndDispatcherTypeMatches(dispatcherType, templateTypes) && !VariableVisitor.addAllPossibleVariables(templateTypes) || (varName = CodeUtils.extractVariableName(field = fieldAccess.getField())) == null) continue;
                String variableName = VARIABLE_PREFIX + varName;
                if (this.variablePrefix.length() != 0 && !variableName.toLowerCase().startsWith(this.variablePrefix.toLowerCase())) continue;
                result.add(variableName);
            }
            return result;
        }

        private static boolean existsTemplateTypeAndDispatcherTypeMatches(TypeScope dispatcherType, List<TypeScope> templateTypes) {
            return templateTypes != null && dispatcherType != null && VariableVisitor.isOfType(dispatcherType, templateTypes);
        }

        private static boolean isOfType(TypeScope dispatcherType, List<TypeScope> templateTypes) {
            boolean result = false;
            if (dispatcherType != null) {
                for (TypeScope templateType : templateTypes) {
                    if (!dispatcherType.isSubTypeOf(templateType) && !dispatcherType.equals(templateType)) continue;
                    result = true;
                    break;
                }
            }
            return result;
        }

        private static boolean addAllPossibleVariables(List<TypeScope> templateTypes) {
            return templateTypes == null || templateTypes.isEmpty();
        }

        static {
            TEMPLATE_DISPATCHER_TYPES.add("Nette\\Templating\\ITemplate");
            TEMPLATE_DISPATCHER_TYPES.add("Nette\\Application\\UI\\ITemplate");
        }
    }

    private static final class PresenterVisitor
    extends DefaultVisitor {
        private final String actionName;
        private Set<MethodDeclaration> methodsToScan = new HashSet<MethodDeclaration>();

        public PresenterVisitor(FileObject templateFile) {
            this.actionName = LatteVariableCompletionProvider.extractActionName(templateFile);
        }

        @Override
        public void visit(ClassDeclaration node) {
            if (CodeUtils.extractClassName(node).toLowerCase().endsWith(LatteVariableCompletionProvider.PRESENTER_CLASS_SUFFIX.toLowerCase())) {
                super.visit(node);
            }
        }

        @Override
        public void visit(MethodDeclaration node) {
            if (PresenterVisitor.isProperActionMethod(node, this.actionName) || PresenterVisitor.isProperRenderMethod(node, this.actionName) || PresenterVisitor.isStartupMethod(node) || PresenterVisitor.isBeforeRenderMethod(node)) {
                this.methodsToScan.add(node);
            }
        }

        private static boolean isProperActionMethod(MethodDeclaration node, String actionName) {
            return CodeUtils.extractMethodName(node).equalsIgnoreCase(LatteVariableCompletionProvider.ACTION_METHOD_PREFIX + actionName);
        }

        private static boolean isProperRenderMethod(MethodDeclaration node, String actionName) {
            return CodeUtils.extractMethodName(node).equalsIgnoreCase(LatteVariableCompletionProvider.RENDER_METHOD_PREFIX + actionName);
        }

        private static boolean isStartupMethod(MethodDeclaration node) {
            return CodeUtils.extractMethodName(node).equalsIgnoreCase(LatteVariableCompletionProvider.STARTUP_METHOD);
        }

        private static boolean isBeforeRenderMethod(MethodDeclaration node) {
            return CodeUtils.extractMethodName(node).equalsIgnoreCase(LatteVariableCompletionProvider.BEFORE_RENDER_METHOD);
        }

        public Set<MethodDeclaration> getMethodsToScan() {
            return new HashSet<MethodDeclaration>(this.methodsToScan);
        }
    }
}

