/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.unit;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import org.netbeans.api.db.explorer.ConnectionManager;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.j2ee.persistence.api.EntityClassScope;
import org.netbeans.modules.j2ee.persistence.dd.common.Properties;
import org.netbeans.modules.j2ee.persistence.dd.common.Property;
import org.netbeans.modules.j2ee.persistence.dd.persistence.model_3_2.PersistenceUnit;
import org.netbeans.modules.j2ee.persistence.provider.DefaultProvider;
import org.netbeans.modules.j2ee.persistence.provider.Provider;
import org.netbeans.modules.j2ee.persistence.provider.ProviderUtil;
import org.netbeans.modules.j2ee.persistence.spi.datasource.JPADataSource;
import org.netbeans.modules.j2ee.persistence.spi.datasource.JPADataSourcePopulator;
import org.netbeans.modules.j2ee.persistence.spi.datasource.JPADataSourceProvider;
import org.netbeans.modules.j2ee.persistence.unit.AddEntityDialog;
import org.netbeans.modules.j2ee.persistence.unit.PUDataObject;
import org.netbeans.modules.j2ee.persistence.unit.PersistenceValidator;
import org.netbeans.modules.j2ee.persistence.util.PersistenceProviderComboboxHelper;
import org.netbeans.modules.j2ee.persistence.wizard.Util;
import org.netbeans.modules.j2ee.persistence.wizard.library.PersistenceLibrarySupport;
import org.netbeans.modules.j2ee.persistence.wizard.unit.JdbcListCellRenderer;
import org.netbeans.modules.xml.multiview.Error;
import org.netbeans.modules.xml.multiview.ui.SectionInnerPanel;
import org.netbeans.modules.xml.multiview.ui.SectionView;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class PersistenceUnitPanel
extends SectionInnerPanel {
    private final org.netbeans.modules.j2ee.persistence.dd.common.PersistenceUnit persistenceUnit;
    private PUDataObject dObj;
    private Project project;
    private Boolean isContainerManaged;
    private boolean jpa2x = false;
    private final RequestProcessor RP = new RequestProcessor(PersistenceUnitPanel.class.getSimpleName(), 5);
    private final String[] validationModes = new String[]{"AUTO", "CALLBACK", "NONE"};
    private final String[] cachingTypes = new String[]{"ALL", "NONE", "ENABLE_SELECTIVE", "DISABLE_SELECTIVE", "UNSPECIFIED"};
    private JButton addClassButton;
    private ButtonGroup buttonGroup1;
    private ButtonGroup buttonGroup2;
    private ButtonGroup buttonGroup3;
    private JLabel cachingStrategyLabel;
    private JPanel cachingStrategyPanel;
    private JLabel datasourceLabel;
    private JRadioButton ddAll;
    private JRadioButton ddAuto;
    private JRadioButton ddCallBack;
    private JRadioButton ddCreate;
    private JRadioButton ddDefault;
    private JRadioButton ddDisableSelective;
    private JRadioButton ddDropCreate;
    private JRadioButton ddEnableSelective;
    private JRadioButton ddNoValidation;
    private JRadioButton ddNone;
    private JRadioButton ddUnknown;
    private JComboBox dsCombo;
    private JPanel entityClassesPanel;
    private JList entityList;
    private JScrollPane entityScrollPane;
    private JCheckBox includeAllEntities;
    private JLabel includeEntitiesLabel;
    private JComboBox jdbcComboBox;
    private JLabel jdbcLabel;
    private JCheckBox jtaCheckBox;
    private JComboBox libraryComboBox;
    private JLabel libraryLabel;
    private JLabel nameLabel;
    private JTextField nameTextField;
    private JComboBox providerCombo;
    private JLabel providerLabel;
    private JButton removeClassButton;
    private JLabel tableGenerationLabel;
    private JPanel tableGenerationPanel;
    private JLabel validationStrategyLabel;
    private JPanel validationStrategyPanel;

    public PersistenceUnitPanel(SectionView view, PUDataObject dObj, org.netbeans.modules.j2ee.persistence.dd.common.PersistenceUnit persistenceUnit) {
        super(view);
        this.dObj = dObj;
        this.jpa2x = Double.parseDouble("2.0") <= Double.parseDouble(dObj.getPersistence().getVersion());
        this.persistenceUnit = persistenceUnit;
        this.project = FileOwnerQuery.getOwner((FileObject)this.dObj.getPrimaryFile());
        assert (this.project != null) : "Could not resolve project for " + dObj.getPrimaryFile();
        this.initComponents();
        this.setVisiblePanel();
        this.nameTextField.setText(NbBundle.getMessage(PersistenceUnitPanel.class, (String)"LBL_Wait"));
        this.RP.post(() -> {
            this.isContainerManaged = ProviderUtil.getConnection(persistenceUnit) != null && PersistenceLibrarySupport.getLibrary(persistenceUnit) != null ? Boolean.valueOf(false) : (persistenceUnit.getJtaDataSource() != null || persistenceUnit.getNonJtaDataSource() != null ? Boolean.valueOf(true) : Boolean.valueOf(Util.isSupportedJavaEEVersion(this.project)));
            PersistenceProviderComboboxHelper comboHelper = new PersistenceProviderComboboxHelper(this.project);
            if (this.isContainerManaged.booleanValue()) {
                comboHelper.connect(this.providerCombo);
                ArrayList<Provider> providers = new ArrayList<Provider>();
                for (int i = 0; i < this.providerCombo.getItemCount(); ++i) {
                    Object obj = this.providerCombo.getItemAt(i);
                    if (!(obj instanceof Provider)) continue;
                    providers.add((Provider)obj);
                }
                Provider provider = ProviderUtil.getProvider(persistenceUnit, providers.toArray(new Provider[0]));
                this.providerCombo.setSelectedItem(provider);
            } else {
                comboHelper.connect(this.libraryComboBox);
                this.setSelectedLibrary();
            }
            this.setVisiblePanel();
            this.initIncludeAllEntities();
            this.initEntityList();
            this.initDataSource();
            if (this.jpa2x) {
                this.initCache();
                this.initValidation();
            }
            this.nameTextField.setText(persistenceUnit.getName());
            this.setTableGeneration();
            this.handleCmAmSelection();
            this.registerModifiers();
        });
    }

    private void registerModifiers() {
        if (this.isContainerManaged.booleanValue()) {
            this.addImmediateModifier(this.dsCombo);
            if (this.dsCombo.isEditable()) {
                this.addImmediateModifier((JTextComponent)this.dsCombo.getEditor().getEditorComponent());
            }
            this.addImmediateModifier(this.providerCombo);
            this.addImmediateModifier(this.jtaCheckBox);
        } else {
            this.addImmediateModifier(this.jdbcComboBox);
            this.addImmediateModifier(this.libraryComboBox);
        }
        this.addImmediateModifier(this.nameTextField);
        this.addImmediateModifier(this.ddDropCreate);
        this.addImmediateModifier(this.ddCreate);
        this.addImmediateModifier(this.ddUnknown);
        this.addImmediateModifier(this.includeAllEntities);
        if (this.jpa2x) {
            this.addImmediateModifier(this.ddAll);
            this.addImmediateModifier(this.ddNone);
            this.addImmediateModifier(this.ddEnableSelective);
            this.addImmediateModifier(this.ddDisableSelective);
            this.addImmediateModifier(this.ddDefault);
            this.addImmediateModifier(this.ddAuto);
            this.addImmediateModifier(this.ddNoValidation);
            this.addImmediateModifier(this.ddCallBack);
        }
    }

    private void setVisiblePanel() {
        if (this.isContainerManaged == null) {
            this.dsCombo.setVisible(false);
            this.jdbcComboBox.setEnabled(false);
            this.datasourceLabel.setVisible(false);
            this.providerCombo.setEnabled(false);
            this.libraryLabel.setVisible(false);
            this.libraryComboBox.setVisible(false);
            this.validationStrategyPanel.setVisible(false);
            this.validationStrategyLabel.setVisible(false);
            this.cachingStrategyPanel.setVisible(false);
            this.cachingStrategyLabel.setVisible(false);
            this.entityList.setEnabled(false);
            this.addClassButton.setEnabled(false);
            this.removeClassButton.setEnabled(false);
        } else {
            this.providerLabel.setVisible(this.isContainerManaged);
            this.providerCombo.setVisible(this.isContainerManaged);
            this.providerCombo.setEnabled(true);
            this.dsCombo.setVisible(this.isContainerManaged);
            this.datasourceLabel.setVisible(this.isContainerManaged);
            this.libraryLabel.setVisible(this.isContainerManaged == false);
            this.libraryComboBox.setVisible(this.isContainerManaged == false);
            this.jdbcComboBox.setVisible(this.isContainerManaged == false);
            this.jdbcComboBox.setEnabled(true);
            this.jdbcLabel.setVisible(this.isContainerManaged == false);
            this.validationStrategyPanel.setVisible(this.jpa2x);
            this.validationStrategyLabel.setVisible(this.jpa2x);
            this.cachingStrategyPanel.setVisible(this.jpa2x);
            this.cachingStrategyLabel.setVisible(this.jpa2x);
            this.entityList.setEnabled(true);
            this.addClassButton.setEnabled(true);
            this.removeClassButton.setEnabled(true);
        }
    }

    private void initCache() {
        String caching = "";
        if (this.persistenceUnit instanceof PersistenceUnit) {
            caching = ((PersistenceUnit)this.persistenceUnit).getSharedCacheMode();
        } else if (this.persistenceUnit instanceof org.netbeans.modules.j2ee.persistence.dd.persistence.model_3_1.PersistenceUnit) {
            caching = ((org.netbeans.modules.j2ee.persistence.dd.persistence.model_3_1.PersistenceUnit)this.persistenceUnit).getSharedCacheMode();
        } else if (this.persistenceUnit instanceof org.netbeans.modules.j2ee.persistence.dd.persistence.model_3_0.PersistenceUnit) {
            caching = ((org.netbeans.modules.j2ee.persistence.dd.persistence.model_3_0.PersistenceUnit)this.persistenceUnit).getSharedCacheMode();
        } else if (this.persistenceUnit instanceof org.netbeans.modules.j2ee.persistence.dd.persistence.model_2_2.PersistenceUnit) {
            caching = ((org.netbeans.modules.j2ee.persistence.dd.persistence.model_2_2.PersistenceUnit)this.persistenceUnit).getSharedCacheMode();
        } else if (this.persistenceUnit instanceof org.netbeans.modules.j2ee.persistence.dd.persistence.model_2_1.PersistenceUnit) {
            caching = ((org.netbeans.modules.j2ee.persistence.dd.persistence.model_2_1.PersistenceUnit)this.persistenceUnit).getSharedCacheMode();
        } else if (this.persistenceUnit instanceof org.netbeans.modules.j2ee.persistence.dd.persistence.model_2_0.PersistenceUnit) {
            caching = ((org.netbeans.modules.j2ee.persistence.dd.persistence.model_2_0.PersistenceUnit)this.persistenceUnit).getSharedCacheMode();
        }
        if (this.cachingTypes[0].equals(caching)) {
            this.ddAll.setSelected(true);
        } else if (this.cachingTypes[1].equals(caching)) {
            this.ddNone.setSelected(true);
        } else if (this.cachingTypes[2].equals(caching)) {
            this.ddEnableSelective.setSelected(true);
        } else if (this.cachingTypes[3].equals(caching)) {
            this.ddDisableSelective.setSelected(true);
        } else {
            this.ddDefault.setSelected(true);
        }
    }

    private void initValidation() {
        String validation = "";
        if (this.persistenceUnit instanceof PersistenceUnit) {
            validation = ((PersistenceUnit)this.persistenceUnit).getValidationMode();
        } else if (this.persistenceUnit instanceof org.netbeans.modules.j2ee.persistence.dd.persistence.model_3_1.PersistenceUnit) {
            validation = ((org.netbeans.modules.j2ee.persistence.dd.persistence.model_3_1.PersistenceUnit)this.persistenceUnit).getValidationMode();
        } else if (this.persistenceUnit instanceof org.netbeans.modules.j2ee.persistence.dd.persistence.model_3_0.PersistenceUnit) {
            validation = ((org.netbeans.modules.j2ee.persistence.dd.persistence.model_3_0.PersistenceUnit)this.persistenceUnit).getValidationMode();
        } else if (this.persistenceUnit instanceof org.netbeans.modules.j2ee.persistence.dd.persistence.model_2_2.PersistenceUnit) {
            validation = ((org.netbeans.modules.j2ee.persistence.dd.persistence.model_2_2.PersistenceUnit)this.persistenceUnit).getValidationMode();
        } else if (this.persistenceUnit instanceof org.netbeans.modules.j2ee.persistence.dd.persistence.model_2_1.PersistenceUnit) {
            validation = ((org.netbeans.modules.j2ee.persistence.dd.persistence.model_2_1.PersistenceUnit)this.persistenceUnit).getValidationMode();
        } else if (this.persistenceUnit instanceof org.netbeans.modules.j2ee.persistence.dd.persistence.model_2_0.PersistenceUnit) {
            validation = ((org.netbeans.modules.j2ee.persistence.dd.persistence.model_2_0.PersistenceUnit)this.persistenceUnit).getValidationMode();
        }
        if (this.validationModes[1].equals(validation)) {
            this.ddCallBack.setSelected(true);
        } else if (this.validationModes[2].equals(validation)) {
            this.ddNoValidation.setSelected(true);
        } else {
            this.ddAuto.setSelected(true);
        }
    }

    private void initDataSource() {
        this.jtaCheckBox.setEnabled(this.isContainerManaged);
        if (this.isContainerManaged.booleanValue() && ProviderUtil.isValidServerInstanceOrNone(this.project)) {
            String jtaDataSource = this.persistenceUnit.getJtaDataSource();
            String nonJtaDataSource = this.persistenceUnit.getNonJtaDataSource();
            JPADataSourcePopulator dsPopulator = (JPADataSourcePopulator)this.project.getLookup().lookup(JPADataSourcePopulator.class);
            if (dsPopulator != null) {
                if (SwingUtilities.isEventDispatchThread()) {
                    dsPopulator.connect(this.dsCombo);
                } else {
                    try {
                        SwingUtilities.invokeAndWait(() -> dsPopulator.connect(this.dsCombo));
                    }
                    catch (InterruptedException | InvocationTargetException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
                this.addModifier((JTextComponent)this.dsCombo.getEditor().getEditorComponent(), false);
            }
            String jndiName = jtaDataSource != null ? jtaDataSource : nonJtaDataSource;
            this.selectDatasource(jndiName);
            this.jtaCheckBox.setSelected(this.jtaCheckBox.isEnabled() && (this.persistenceUnit.getTransactionType() == null || this.persistenceUnit.getTransactionType().equals("JTA")));
            ArrayList<Provider> providers = new ArrayList<Provider>();
            for (int i = 0; i < this.providerCombo.getItemCount(); ++i) {
                Object obj = this.providerCombo.getItemAt(i);
                if (!(obj instanceof Provider)) continue;
                providers.add((Provider)obj);
            }
            Provider provider = ProviderUtil.getProvider(this.persistenceUnit, providers.toArray(new Provider[0]));
            this.providerCombo.setSelectedItem(provider);
        } else if (!this.isContainerManaged.booleanValue()) {
            this.initJdbcComboBox();
            this.setSelectedLibrary();
            this.jtaCheckBox.setSelected(false);
        }
    }

    private void initJdbcComboBox() {
        DatabaseConnection[] connections = ConnectionManager.getDefault().getConnections();
        for (int i = 0; i < connections.length; ++i) {
            this.jdbcComboBox.addItem(connections[i]);
        }
        this.setSelectedConnection();
    }

    private void initIncludeAllEntities() {
        boolean javaSE = Util.isJavaSE(this.project);
        boolean isNotContainer = !Util.isContainerManaged(this.project);
        this.includeAllEntities.setEnabled(!javaSE && !isNotContainer);
        this.includeAllEntities.setSelected(!javaSE && !isNotContainer && !this.persistenceUnit.isExcludeUnlistedClasses());
        this.includeAllEntities.setText(NbBundle.getMessage(PersistenceUnitPanel.class, (String)"LBL_IncludeAllEntities", (Object[])new Object[]{ProjectUtils.getInformation((Project)this.project).getDisplayName()}));
    }

    void initEntityList() {
        this.initEntityListControls();
        DefaultListModel<String> listedClassesModel = new DefaultListModel<String>();
        for (String elem : this.persistenceUnit.getClass2()) {
            listedClassesModel.addElement(elem);
        }
        this.entityList.setModel(listedClassesModel);
    }

    private void initEntityListControls() {
        boolean enable = !this.includeAllEntities.isSelected();
        this.entityList.setEnabled(enable);
        this.addClassButton.setEnabled(enable);
        this.removeClassButton.setEnabled(enable);
    }

    private void setSelectedLibrary() {
        ArrayList<Provider> providers = new ArrayList<Provider>();
        for (int i = 0; i < this.libraryComboBox.getItemCount(); ++i) {
            Object obj = this.libraryComboBox.getItemAt(i);
            if (!(obj instanceof Provider)) continue;
            providers.add((Provider)obj);
        }
        Provider selected = ProviderUtil.getProvider(this.persistenceUnit, providers.toArray(new Provider[0]));
        if (selected == null) {
            return;
        }
        for (int i = 0; i < this.libraryComboBox.getItemCount(); ++i) {
            Object item = this.libraryComboBox.getItemAt(i);
            Provider provider = (Provider)(item instanceof Provider ? item : null);
            if (provider == null || !provider.equals(selected)) continue;
            this.libraryComboBox.setSelectedIndex(i);
            break;
        }
    }

    private Provider getSelectedProvider() {
        Object selectedItem;
        Provider provider = null;
        provider = this.isContainerManaged != false ? (Provider)((selectedItem = this.providerCombo.getSelectedItem()) instanceof Provider ? selectedItem : null) : (Provider)((selectedItem = this.libraryComboBox.getSelectedItem()) instanceof Provider ? selectedItem : null);
        if (provider != null) {
            return provider;
        }
        return ProviderUtil.getProvider(this.persistenceUnit.getProvider(), this.project);
    }

    private void setTableGeneration() {
        Property tableGeneration;
        Provider provider = this.getSelectedProvider();
        Property property = tableGeneration = provider == null ? null : ProviderUtil.getProperty(this.persistenceUnit, provider.getTableGenerationPropertyName());
        if (tableGeneration != null) {
            if (provider.getTableGenerationCreateValue().equals(tableGeneration.getValue())) {
                this.ddCreate.setSelected(true);
            } else if (provider.getTableGenerationDropCreateValue().equals(tableGeneration.getValue())) {
                this.ddDropCreate.setSelected(true);
            }
        } else {
            this.ddUnknown.setSelected(true);
        }
        boolean toggle = provider == null ? false : provider.supportsTableGeneration();
        this.ddCreate.setEnabled(toggle);
        this.ddDropCreate.setEnabled(toggle);
        this.ddUnknown.setEnabled(toggle);
    }

    private void setSelectedConnection() {
        DatabaseConnection connection = ProviderUtil.getConnection(this.persistenceUnit);
        if (connection != null) {
            this.jdbcComboBox.setSelectedItem(connection);
        } else {
            Properties props = this.persistenceUnit.getProperties();
            if (props != null) {
                Property[] properties = props.getProperty2();
                String url = null;
                ArrayList<Provider> providers = new ArrayList<Provider>();
                JComboBox activeCB = this.providerCombo.isVisible() ? this.providerCombo : this.libraryComboBox;
                for (int i = 0; i < activeCB.getItemCount(); ++i) {
                    Object obj = activeCB.getItemAt(i);
                    if (!(obj instanceof Provider)) continue;
                    providers.add((Provider)obj);
                }
                Provider provider = ProviderUtil.getProvider(this.persistenceUnit, providers.toArray(new Provider[0]));
                for (int i = 0; i < properties.length; ++i) {
                    String key = properties[i].getName();
                    if (!provider.getJdbcUrl().equals(key)) continue;
                    url = properties[i].getValue();
                    break;
                }
                if (url == null) {
                    url = NbBundle.getMessage(PersistenceUnitPanel.class, (String)"LBL_CustomConnection");
                }
                this.jdbcComboBox.addItem(url);
                this.jdbcComboBox.setSelectedItem(url);
            }
        }
    }

    public void setValue(JComponent source, Object value) {
        if (source == this.nameTextField) {
            this.persistenceUnit.setName((String)value);
        } else if (source == this.dsCombo) {
            this.setDataSource();
        } else if (source == this.dsCombo.getEditor().getEditorComponent()) {
            this.setDataSource((String)value);
        } else if (source == this.jdbcComboBox) {
            if (value instanceof DatabaseConnection) {
                ProviderUtil.setDatabaseConnection(this.persistenceUnit, (DatabaseConnection)value);
            }
        } else if (source == this.libraryComboBox) {
            this.setProvider();
            this.setTableGeneration();
        } else if (this.providerCombo == source) {
            String prevProvider = this.persistenceUnit.getProvider();
            this.setProvider();
            this.setDataSource();
            String curProvider = this.persistenceUnit.getProvider();
            if (prevProvider != null && curProvider != null) {
                ProviderUtil.migrateProperties(prevProvider, curProvider, this.persistenceUnit);
            }
        } else if (source == this.ddCreate || source == this.ddDropCreate || source == this.ddUnknown) {
            ProviderUtil.setTableGeneration(this.persistenceUnit, this.getTableGeneration(), ProviderUtil.getProvider(this.persistenceUnit.getProvider(), this.project));
            ProviderUtil.normalizeIfPossible(this.project, this.persistenceUnit);
        } else if (source == this.includeAllEntities) {
            this.persistenceUnit.setExcludeUnlistedClasses(!this.includeAllEntities.isSelected());
        } else if (source == this.jtaCheckBox) {
            this.setDataSource();
        } else if (this.jpa2x) {
            String cType = "";
            String vMode = "";
            if (source == this.ddAll) {
                cType = this.cachingTypes[0];
            } else if (source == this.ddNone) {
                cType = this.cachingTypes[1];
            } else if (source == this.ddEnableSelective) {
                cType = this.cachingTypes[2];
            } else if (source == this.ddDisableSelective) {
                cType = this.cachingTypes[3];
            } else if (source == this.ddDefault) {
                cType = null;
            } else if (source == this.ddAuto) {
                vMode = null;
            } else if (source == this.ddCallBack) {
                vMode = this.validationModes[1];
            } else if (source == this.ddNoValidation) {
                vMode = this.validationModes[2];
            }
            if (!"".equals(cType)) {
                if (this.persistenceUnit instanceof PersistenceUnit) {
                    ((PersistenceUnit)this.persistenceUnit).setSharedCacheMode(cType);
                } else if (this.persistenceUnit instanceof org.netbeans.modules.j2ee.persistence.dd.persistence.model_3_1.PersistenceUnit) {
                    ((org.netbeans.modules.j2ee.persistence.dd.persistence.model_3_1.PersistenceUnit)this.persistenceUnit).setSharedCacheMode(cType);
                } else if (this.persistenceUnit instanceof org.netbeans.modules.j2ee.persistence.dd.persistence.model_3_0.PersistenceUnit) {
                    ((org.netbeans.modules.j2ee.persistence.dd.persistence.model_3_0.PersistenceUnit)this.persistenceUnit).setSharedCacheMode(cType);
                } else if (this.persistenceUnit instanceof org.netbeans.modules.j2ee.persistence.dd.persistence.model_2_2.PersistenceUnit) {
                    ((org.netbeans.modules.j2ee.persistence.dd.persistence.model_2_2.PersistenceUnit)this.persistenceUnit).setSharedCacheMode(cType);
                } else if (this.persistenceUnit instanceof org.netbeans.modules.j2ee.persistence.dd.persistence.model_2_1.PersistenceUnit) {
                    ((org.netbeans.modules.j2ee.persistence.dd.persistence.model_2_1.PersistenceUnit)this.persistenceUnit).setSharedCacheMode(cType);
                } else if (this.persistenceUnit instanceof org.netbeans.modules.j2ee.persistence.dd.persistence.model_2_0.PersistenceUnit) {
                    ((org.netbeans.modules.j2ee.persistence.dd.persistence.model_2_0.PersistenceUnit)this.persistenceUnit).setSharedCacheMode(cType);
                }
            } else if (!"".equals(vMode)) {
                if (this.persistenceUnit instanceof PersistenceUnit) {
                    ((PersistenceUnit)this.persistenceUnit).setValidationMode(vMode);
                } else if (this.persistenceUnit instanceof org.netbeans.modules.j2ee.persistence.dd.persistence.model_3_1.PersistenceUnit) {
                    ((org.netbeans.modules.j2ee.persistence.dd.persistence.model_3_1.PersistenceUnit)this.persistenceUnit).setValidationMode(vMode);
                } else if (this.persistenceUnit instanceof org.netbeans.modules.j2ee.persistence.dd.persistence.model_3_0.PersistenceUnit) {
                    ((org.netbeans.modules.j2ee.persistence.dd.persistence.model_3_0.PersistenceUnit)this.persistenceUnit).setValidationMode(vMode);
                } else if (this.persistenceUnit instanceof org.netbeans.modules.j2ee.persistence.dd.persistence.model_2_2.PersistenceUnit) {
                    ((org.netbeans.modules.j2ee.persistence.dd.persistence.model_2_2.PersistenceUnit)this.persistenceUnit).setValidationMode(vMode);
                } else if (this.persistenceUnit instanceof org.netbeans.modules.j2ee.persistence.dd.persistence.model_2_1.PersistenceUnit) {
                    ((org.netbeans.modules.j2ee.persistence.dd.persistence.model_2_1.PersistenceUnit)this.persistenceUnit).setValidationMode(vMode);
                } else if (this.persistenceUnit instanceof org.netbeans.modules.j2ee.persistence.dd.persistence.model_2_0.PersistenceUnit) {
                    ((org.netbeans.modules.j2ee.persistence.dd.persistence.model_2_0.PersistenceUnit)this.persistenceUnit).setValidationMode(vMode);
                }
            }
            ProviderUtil.normalizeIfPossible(this.project, this.persistenceUnit);
        }
        this.performValidation();
    }

    private void performValidation() {
        PersistenceValidator validator = new PersistenceValidator(this.dObj);
        List<Error> result = validator.validate();
        if (!result.isEmpty()) {
            this.getSectionView().getErrorPanel().setError(result.get(0));
        } else {
            this.getSectionView().getErrorPanel().clearError();
        }
    }

    private void setDataSource() {
        this.setDataSource(null);
    }

    private void setProvider() {
        String tableGeneration = this.getTableGeneration();
        if (this.isContainerManaged.booleanValue() && this.providerCombo.getSelectedItem() instanceof Provider) {
            Provider provider = (Provider)this.providerCombo.getSelectedItem();
            ProviderUtil.removeProviderProperties(this.persistenceUnit);
            if (!(provider instanceof DefaultProvider)) {
                this.persistenceUnit.setProvider(provider.getProviderClass());
                ProviderUtil.setTableGeneration(this.persistenceUnit, tableGeneration, provider);
                this.setTableGeneration();
            }
            ProviderUtil.normalizeIfPossible(this.project, this.persistenceUnit);
        } else if (this.libraryComboBox.getSelectedItem() instanceof Provider) {
            Provider provider = (Provider)this.libraryComboBox.getSelectedItem();
            ProviderUtil.removeProviderProperties(this.persistenceUnit);
            if (!(provider instanceof DefaultProvider)) {
                ProviderUtil.setProvider(this.persistenceUnit, provider, this.getSelectedConnection(), this.getTableGeneration());
                ProviderUtil.setTableGeneration(this.persistenceUnit, tableGeneration, provider);
            }
        }
    }

    private void setDataSource(String name) {
        String jndiName = name;
        if (jndiName == null) {
            JPADataSource jpaDS;
            int itemIndex = this.dsCombo.getSelectedIndex();
            Object item = this.dsCombo.getSelectedItem();
            JPADataSourceProvider dsProvider = (JPADataSourceProvider)this.project.getLookup().lookup(JPADataSourceProvider.class);
            JPADataSource jPADataSource = jpaDS = dsProvider != null ? dsProvider.toJPADataSource(item) : null;
            if (jpaDS != null) {
                jndiName = jpaDS.getJndiName();
            } else if (itemIndex == -1 && item != null) {
                jndiName = item.toString();
            }
        }
        if (jndiName == null) {
            return;
        }
        if (this.isJta()) {
            String old;
            String string = old = this.persistenceUnit.getJtaDataSource() == null ? "" : this.persistenceUnit.getJtaDataSource();
            if (!old.equals(jndiName)) {
                this.persistenceUnit.setJtaDataSource(jndiName);
            }
            this.persistenceUnit.setNonJtaDataSource(null);
            this.persistenceUnit.setTransactionType("JTA");
        } else {
            String old;
            String string = old = this.persistenceUnit.getNonJtaDataSource() == null ? "" : this.persistenceUnit.getNonJtaDataSource();
            if (!old.equals(jndiName)) {
                this.persistenceUnit.setNonJtaDataSource(jndiName);
            }
            this.persistenceUnit.setJtaDataSource(null);
            this.persistenceUnit.setTransactionType("RESOURCE_LOCAL");
        }
    }

    private boolean isJta() {
        return this.jtaCheckBox.isEnabled() && this.jtaCheckBox.isSelected();
    }

    private String getTableGeneration() {
        if (this.ddCreate.isSelected()) {
            return "tableGenerationCreate";
        }
        if (this.ddDropCreate.isSelected()) {
            return "tableGenerationDropCreate";
        }
        return "tableGenerationUnknown";
    }

    private DatabaseConnection getSelectedConnection() {
        DatabaseConnection connection = null;
        if (this.jdbcComboBox.getSelectedItem() instanceof DatabaseConnection) {
            connection = (DatabaseConnection)this.jdbcComboBox.getSelectedItem();
        }
        return connection;
    }

    public void rollbackValue(JTextComponent source) {
        if (this.nameTextField == source) {
            this.nameTextField.setText(this.persistenceUnit.getName());
        } else if (this.dsCombo.getEditor().getEditorComponent() == source) {
            String jndiName = this.isJta() ? this.persistenceUnit.getJtaDataSource() : this.persistenceUnit.getNonJtaDataSource();
            this.selectDatasource(jndiName);
        }
    }

    private void selectDatasource(String jndiName) {
        Object item = this.findDatasource(jndiName);
        this.dsCombo.setSelectedItem(item);
        if (this.dsCombo.getEditor() != null) {
            this.dsCombo.configureEditor(this.dsCombo.getEditor(), item);
        }
    }

    private Object findDatasource(String jndiName) {
        if (jndiName != null) {
            int nItems = this.dsCombo.getItemCount();
            for (int i = 0; i < nItems; ++i) {
                Object item = this.dsCombo.getItemAt(i);
                if (!(item instanceof JPADataSource) || !jndiName.equals(((JPADataSource)item).getJndiName())) continue;
                return (JPADataSource)item;
            }
        }
        return jndiName;
    }

    protected void startUIChange() {
        this.dObj.setChangedFromUI(true);
    }

    protected void endUIChange() {
        this.dObj.modelUpdatedFromUI();
        this.dObj.setChangedFromUI(false);
    }

    public void linkButtonPressed(Object ddBean, String ddProperty) {
    }

    public JComponent getErrorComponent(String errorId) {
        if ("name".equals(errorId)) {
            return this.nameTextField;
        }
        return null;
    }

    private void handleCmAmSelection() {
        boolean isCm = this.isContainerManaged;
        this.datasourceLabel.setEnabled(isCm);
        this.dsCombo.setEnabled(isCm);
        this.jtaCheckBox.setEnabled(isCm);
        this.libraryLabel.setEnabled(!isCm);
        this.libraryComboBox.setEnabled(!isCm);
        this.jdbcLabel.setEnabled(!isCm);
        this.jdbcComboBox.setEnabled(!isCm);
        this.setTableGeneration();
    }

    private void initComponents() {
        this.buttonGroup2 = new ButtonGroup();
        this.buttonGroup1 = new ButtonGroup();
        this.buttonGroup3 = new ButtonGroup();
        this.nameLabel = new JLabel();
        this.libraryLabel = new JLabel();
        this.jdbcLabel = new JLabel();
        this.datasourceLabel = new JLabel();
        this.jtaCheckBox = new JCheckBox();
        this.dsCombo = new JComboBox();
        this.providerCombo = new JComboBox();
        this.providerLabel = new JLabel();
        this.libraryComboBox = new JComboBox();
        this.jdbcComboBox = new JComboBox();
        this.nameTextField = new JTextField();
        this.tableGenerationLabel = new JLabel();
        this.tableGenerationPanel = new JPanel();
        this.ddCreate = new JRadioButton();
        this.ddDropCreate = new JRadioButton();
        this.ddUnknown = new JRadioButton();
        this.includeAllEntities = new JCheckBox();
        this.entityClassesPanel = new JPanel();
        this.entityScrollPane = new JScrollPane();
        this.entityList = new JList();
        this.addClassButton = new JButton();
        this.removeClassButton = new JButton();
        this.includeEntitiesLabel = new JLabel();
        this.cachingStrategyLabel = new JLabel();
        this.cachingStrategyPanel = new JPanel();
        this.ddAll = new JRadioButton();
        this.ddNone = new JRadioButton();
        this.ddEnableSelective = new JRadioButton();
        this.ddDisableSelective = new JRadioButton();
        this.ddDefault = new JRadioButton();
        this.validationStrategyLabel = new JLabel();
        this.validationStrategyPanel = new JPanel();
        this.ddAuto = new JRadioButton();
        this.ddCallBack = new JRadioButton();
        this.ddNoValidation = new JRadioButton();
        this.setMinimumSize(new Dimension(400, 360));
        this.setPreferredSize(new Dimension(654, 471));
        this.setLayout(new GridBagLayout());
        this.nameLabel.setText(NbBundle.getMessage(PersistenceUnitPanel.class, (String)"LBL_UnitName"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(11, 11, 0, 11);
        this.add(this.nameLabel, gridBagConstraints);
        this.libraryLabel.setText(NbBundle.getMessage(PersistenceUnitPanel.class, (String)"LBL_PersistenceLibrary"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(11, 11, 0, 11);
        this.add(this.libraryLabel, gridBagConstraints);
        this.jdbcLabel.setText(NbBundle.getMessage(PersistenceUnitPanel.class, (String)"LBL_JdbcConnection"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(11, 11, 0, 11);
        this.add(this.jdbcLabel, gridBagConstraints);
        this.datasourceLabel.setText(NbBundle.getMessage(PersistenceUnitPanel.class, (String)"LBL_DatasourceName"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(11, 11, 0, 11);
        this.add(this.datasourceLabel, gridBagConstraints);
        this.jtaCheckBox.setSelected(true);
        this.jtaCheckBox.setText(NbBundle.getMessage(PersistenceUnitPanel.class, (String)"LBL_JTA"));
        this.jtaCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(11, 11, 0, 11);
        this.add(this.jtaCheckBox, gridBagConstraints);
        this.dsCombo.setEditable(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(11, 11, 0, 11);
        this.add(this.dsCombo, gridBagConstraints);
        this.providerCombo.setModel(new DefaultComboBoxModel<String>(new String[]{" "}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(11, 11, 0, 11);
        this.add(this.providerCombo, gridBagConstraints);
        ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/j2ee/persistence/wizard/unit/Bundle");
        this.providerLabel.setText(bundle.getString("LBL_Provider"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(11, 11, 0, 11);
        this.add(this.providerLabel, gridBagConstraints);
        this.libraryComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PersistenceUnitPanel.this.libraryComboBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(11, 11, 0, 11);
        this.add(this.libraryComboBox, gridBagConstraints);
        this.jdbcComboBox.setRenderer(new JdbcListCellRenderer());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(11, 11, 0, 11);
        this.add(this.jdbcComboBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(11, 11, 0, 11);
        this.add(this.nameTextField, gridBagConstraints);
        ResourceBundle bundle1 = ResourceBundle.getBundle("org/netbeans/modules/j2ee/persistence/unit/Bundle");
        this.tableGenerationLabel.setText(bundle1.getString("LBL_TableGeneration"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(11, 11, 0, 11);
        this.add(this.tableGenerationLabel, gridBagConstraints);
        this.tableGenerationPanel.setMinimumSize(new Dimension(100, 25));
        this.tableGenerationPanel.setOpaque(false);
        this.tableGenerationPanel.setLayout(new FlowLayout(0));
        this.buttonGroup2.add(this.ddCreate);
        this.ddCreate.setText(bundle1.getString("LBL_Create"));
        this.ddCreate.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.tableGenerationPanel.add(this.ddCreate);
        this.buttonGroup2.add(this.ddDropCreate);
        this.ddDropCreate.setText(bundle1.getString("LBL_DropCreate"));
        this.ddDropCreate.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.tableGenerationPanel.add(this.ddDropCreate);
        this.buttonGroup2.add(this.ddUnknown);
        this.ddUnknown.setText(bundle1.getString("LBL_None"));
        this.ddUnknown.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.tableGenerationPanel.add(this.ddUnknown);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(11, 11, 0, 11);
        this.add(this.tableGenerationPanel, gridBagConstraints);
        this.includeAllEntities.setText(bundle1.getString("LBL_IncludeAllEntities"));
        this.includeAllEntities.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.includeAllEntities.setContentAreaFilled(false);
        this.includeAllEntities.setMinimumSize(new Dimension(100, 15));
        this.includeAllEntities.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PersistenceUnitPanel.this.includeAllEntitiesActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(11, 11, 0, 11);
        this.add(this.includeAllEntities, gridBagConstraints);
        this.entityClassesPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.entityClassesPanel.setOpaque(false);
        this.entityClassesPanel.setLayout(new GridBagLayout());
        this.entityScrollPane.setMinimumSize(new Dimension(50, 25));
        this.entityScrollPane.setViewportView(this.entityList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 11);
        this.entityClassesPanel.add((Component)this.entityScrollPane, gridBagConstraints);
        this.addClassButton.setText(bundle1.getString("LBL_AddClasses"));
        this.addClassButton.setMargin(new Insets(0, 10, 0, 10));
        this.addClassButton.setMaximumSize(new Dimension(287, 29));
        this.addClassButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PersistenceUnitPanel.this.addClassButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        this.entityClassesPanel.add((Component)this.addClassButton, gridBagConstraints);
        this.removeClassButton.setText(bundle1.getString("LBL_RemoveClass"));
        this.removeClassButton.setMargin(new Insets(0, 10, 0, 10));
        this.removeClassButton.setMaximumSize(new Dimension(284, 29));
        this.removeClassButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PersistenceUnitPanel.this.removeClassButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        this.entityClassesPanel.add((Component)this.removeClassButton, gridBagConstraints);
        this.includeEntitiesLabel.setText(bundle1.getString("LBL_IncludeEntityClasses"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        this.entityClassesPanel.add((Component)this.includeEntitiesLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(11, 11, 11, 11);
        this.add(this.entityClassesPanel, gridBagConstraints);
        this.cachingStrategyLabel.setText(bundle1.getString("LBL_CachingStrategy"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(11, 11, 0, 11);
        this.add(this.cachingStrategyLabel, gridBagConstraints);
        this.cachingStrategyPanel.setMinimumSize(new Dimension(100, 25));
        this.cachingStrategyPanel.setOpaque(false);
        this.cachingStrategyPanel.setLayout(new FlowLayout(0));
        this.buttonGroup1.add(this.ddAll);
        this.ddAll.setText(bundle1.getString("LBL_All"));
        this.ddAll.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cachingStrategyPanel.add(this.ddAll);
        this.buttonGroup1.add(this.ddNone);
        this.ddNone.setText(bundle1.getString("LBL_None"));
        this.ddNone.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cachingStrategyPanel.add(this.ddNone);
        this.buttonGroup1.add(this.ddEnableSelective);
        this.ddEnableSelective.setText(bundle1.getString("LBL_EnableSelective"));
        this.ddEnableSelective.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cachingStrategyPanel.add(this.ddEnableSelective);
        this.buttonGroup1.add(this.ddDisableSelective);
        this.ddDisableSelective.setText(NbBundle.getMessage(PersistenceUnitPanel.class, (String)"LBL_DisableSelective"));
        this.ddDisableSelective.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cachingStrategyPanel.add(this.ddDisableSelective);
        this.buttonGroup1.add(this.ddDefault);
        this.ddDefault.setText(NbBundle.getMessage(PersistenceUnitPanel.class, (String)"LBL_Default"));
        this.ddDefault.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cachingStrategyPanel.add(this.ddDefault);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(11, 11, 0, 11);
        this.add(this.cachingStrategyPanel, gridBagConstraints);
        this.validationStrategyLabel.setText(bundle1.getString("LBL_ValidationStrategy"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(11, 11, 0, 11);
        this.add(this.validationStrategyLabel, gridBagConstraints);
        this.validationStrategyPanel.setMinimumSize(new Dimension(100, 25));
        this.validationStrategyPanel.setOpaque(false);
        this.validationStrategyPanel.setLayout(new FlowLayout(0));
        this.buttonGroup3.add(this.ddAuto);
        this.ddAuto.setSelected(true);
        this.ddAuto.setText(bundle1.getString("LBL_Auto"));
        this.ddAuto.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.validationStrategyPanel.add(this.ddAuto);
        this.buttonGroup3.add(this.ddCallBack);
        this.ddCallBack.setText(bundle1.getString("LBL_CallBack"));
        this.ddCallBack.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.validationStrategyPanel.add(this.ddCallBack);
        this.buttonGroup3.add(this.ddNoValidation);
        this.ddNoValidation.setText(bundle1.getString("LBL_None"));
        this.ddNoValidation.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.validationStrategyPanel.add(this.ddNoValidation);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(11, 11, 0, 11);
        this.add(this.validationStrategyPanel, gridBagConstraints);
    }

    private void removeClassButtonActionPerformed(ActionEvent evt) {
        Object[] values;
        for (Object value : values = this.entityList.getSelectedValues()) {
            this.dObj.removeClass(this.persistenceUnit, (String)value, true);
            ((DefaultListModel)this.entityList.getModel()).removeElement(value);
        }
    }

    private void addClassButtonActionPerformed(ActionEvent evt) {
        EntityClassScope entityClassScope = EntityClassScope.getEntityClassScope((FileObject)this.dObj.getPrimaryFile());
        if (entityClassScope == null) {
            return;
        }
        String[] existingClassNames = this.persistenceUnit.getClass2();
        HashSet<String> ignoreClassNames = new HashSet<String>(Arrays.asList(existingClassNames));
        List<String> addedClassNames = AddEntityDialog.open(entityClassScope, ignoreClassNames);
        for (String entityClass : addedClassNames) {
            if (!this.dObj.addClass(this.persistenceUnit, entityClass, true)) continue;
            ((DefaultListModel)this.entityList.getModel()).addElement(entityClass);
        }
    }

    private void libraryComboBoxActionPerformed(ActionEvent evt) {
    }

    private void includeAllEntitiesActionPerformed(ActionEvent evt) {
        this.initEntityListControls();
    }
}

