/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.devops.responses;

import com.oracle.bmc.devops.model.RepositoryObject;
import com.oracle.bmc.responses.BmcResponse;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class GetObjectResponse
extends BmcResponse {
    private String opcRequestId;
    private String etag;
    private RepositoryObject repositoryObject;

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getEtag() {
        return this.etag;
    }

    public RepositoryObject getRepositoryObject() {
        return this.repositoryObject;
    }

    @ConstructorProperties(value={"__httpStatusCode__", "headers", "opcRequestId", "etag", "repositoryObject"})
    private GetObjectResponse(int __httpStatusCode__, Map<String, List<String>> headers, String opcRequestId, String etag, RepositoryObject repositoryObject) {
        super(__httpStatusCode__, headers);
        this.opcRequestId = opcRequestId;
        this.etag = etag;
        this.repositoryObject = repositoryObject;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",etag=").append(String.valueOf(this.etag));
        sb.append(",repositoryObject=").append(String.valueOf((Object)this.repositoryObject));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetObjectResponse)) {
            return false;
        }
        GetObjectResponse other = (GetObjectResponse)((Object)o);
        return super.equals(o) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.etag, other.etag) && Objects.equals((Object)this.repositoryObject, (Object)other.repositoryObject);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.etag == null ? 43 : this.etag.hashCode());
        result = result * 59 + (this.repositoryObject == null ? 43 : this.repositoryObject.hashCode());
        return result;
    }

    public static class Builder
    implements BmcResponse.Builder<GetObjectResponse> {
        private int __httpStatusCode__;
        private Map<String, List<String>> headers;
        private String opcRequestId;
        private String etag;
        private RepositoryObject repositoryObject;

        public Builder __httpStatusCode__(int __httpStatusCode__) {
            this.__httpStatusCode__ = __httpStatusCode__;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            this.headers = headers;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder repositoryObject(RepositoryObject repositoryObject) {
            this.repositoryObject = repositoryObject;
            return this;
        }

        public Builder copy(GetObjectResponse o) {
            this.__httpStatusCode__(o.get__httpStatusCode__());
            this.headers(o.getHeaders());
            this.opcRequestId(o.getOpcRequestId());
            this.etag(o.getEtag());
            this.repositoryObject(o.getRepositoryObject());
            return this;
        }

        public GetObjectResponse build() {
            return new GetObjectResponse(this.__httpStatusCode__, this.headers, this.opcRequestId, this.etag, this.repositoryObject);
        }
    }
}

