/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.devops.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.devops.model.DeployStageExecutionProgress;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class DeploymentExecutionProgress
extends ExplicitlySetBmcModel {
    @JsonProperty(value="timeStarted")
    private final Date timeStarted;
    @JsonProperty(value="timeFinished")
    private final Date timeFinished;
    @JsonProperty(value="deployStageExecutionProgress")
    private final Map<String, DeployStageExecutionProgress> deployStageExecutionProgress;

    @Deprecated
    @ConstructorProperties(value={"timeStarted", "timeFinished", "deployStageExecutionProgress"})
    public DeploymentExecutionProgress(Date timeStarted, Date timeFinished, Map<String, DeployStageExecutionProgress> deployStageExecutionProgress) {
        this.timeStarted = timeStarted;
        this.timeFinished = timeFinished;
        this.deployStageExecutionProgress = deployStageExecutionProgress;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Date getTimeStarted() {
        return this.timeStarted;
    }

    public Date getTimeFinished() {
        return this.timeFinished;
    }

    public Map<String, DeployStageExecutionProgress> getDeployStageExecutionProgress() {
        return this.deployStageExecutionProgress;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("DeploymentExecutionProgress(");
        sb.append("super=").append(super.toString());
        sb.append("timeStarted=").append(String.valueOf(this.timeStarted));
        sb.append(", timeFinished=").append(String.valueOf(this.timeFinished));
        sb.append(", deployStageExecutionProgress=").append(String.valueOf(this.deployStageExecutionProgress));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DeploymentExecutionProgress)) {
            return false;
        }
        DeploymentExecutionProgress other = (DeploymentExecutionProgress)((Object)o);
        return Objects.equals(this.timeStarted, other.timeStarted) && Objects.equals(this.timeFinished, other.timeFinished) && Objects.equals(this.deployStageExecutionProgress, other.deployStageExecutionProgress) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.timeStarted == null ? 43 : this.timeStarted.hashCode());
        result = result * 59 + (this.timeFinished == null ? 43 : this.timeFinished.hashCode());
        result = result * 59 + (this.deployStageExecutionProgress == null ? 43 : this.deployStageExecutionProgress.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="timeStarted")
        private Date timeStarted;
        @JsonProperty(value="timeFinished")
        private Date timeFinished;
        @JsonProperty(value="deployStageExecutionProgress")
        private Map<String, DeployStageExecutionProgress> deployStageExecutionProgress;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder timeStarted(Date timeStarted) {
            this.timeStarted = timeStarted;
            this.__explicitlySet__.add("timeStarted");
            return this;
        }

        public Builder timeFinished(Date timeFinished) {
            this.timeFinished = timeFinished;
            this.__explicitlySet__.add("timeFinished");
            return this;
        }

        public Builder deployStageExecutionProgress(Map<String, DeployStageExecutionProgress> deployStageExecutionProgress) {
            this.deployStageExecutionProgress = deployStageExecutionProgress;
            this.__explicitlySet__.add("deployStageExecutionProgress");
            return this;
        }

        public DeploymentExecutionProgress build() {
            DeploymentExecutionProgress model = new DeploymentExecutionProgress(this.timeStarted, this.timeFinished, this.deployStageExecutionProgress);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(DeploymentExecutionProgress model) {
            if (model.wasPropertyExplicitlySet("timeStarted")) {
                this.timeStarted(model.getTimeStarted());
            }
            if (model.wasPropertyExplicitlySet("timeFinished")) {
                this.timeFinished(model.getTimeFinished());
            }
            if (model.wasPropertyExplicitlySet("deployStageExecutionProgress")) {
                this.deployStageExecutionProgress(model.getDeployStageExecutionProgress());
            }
            return this;
        }
    }
}

