/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.devops;

import com.oracle.bmc.devops.Devops;
import com.oracle.bmc.devops.model.BuildPipelineStageSummary;
import com.oracle.bmc.devops.model.BuildPipelineSummary;
import com.oracle.bmc.devops.model.BuildRunSummary;
import com.oracle.bmc.devops.model.ConnectionSummary;
import com.oracle.bmc.devops.model.DeployArtifactSummary;
import com.oracle.bmc.devops.model.DeployEnvironmentSummary;
import com.oracle.bmc.devops.model.DeployPipelineSummary;
import com.oracle.bmc.devops.model.DeployStageSummary;
import com.oracle.bmc.devops.model.DeploymentSummary;
import com.oracle.bmc.devops.model.DiffSummary;
import com.oracle.bmc.devops.model.ProjectSummary;
import com.oracle.bmc.devops.model.RepositoryAuthorSummary;
import com.oracle.bmc.devops.model.RepositoryCommitSummary;
import com.oracle.bmc.devops.model.RepositoryMirrorRecordSummary;
import com.oracle.bmc.devops.model.RepositoryPathSummary;
import com.oracle.bmc.devops.model.RepositoryRefSummary;
import com.oracle.bmc.devops.model.RepositorySummary;
import com.oracle.bmc.devops.model.TriggerSummary;
import com.oracle.bmc.devops.model.WorkRequestError;
import com.oracle.bmc.devops.model.WorkRequestLogEntry;
import com.oracle.bmc.devops.model.WorkRequestSummary;
import com.oracle.bmc.devops.requests.ListAuthorsRequest;
import com.oracle.bmc.devops.requests.ListBuildPipelineStagesRequest;
import com.oracle.bmc.devops.requests.ListBuildPipelinesRequest;
import com.oracle.bmc.devops.requests.ListBuildRunsRequest;
import com.oracle.bmc.devops.requests.ListCommitDiffsRequest;
import com.oracle.bmc.devops.requests.ListCommitsRequest;
import com.oracle.bmc.devops.requests.ListConnectionsRequest;
import com.oracle.bmc.devops.requests.ListDeployArtifactsRequest;
import com.oracle.bmc.devops.requests.ListDeployEnvironmentsRequest;
import com.oracle.bmc.devops.requests.ListDeployPipelinesRequest;
import com.oracle.bmc.devops.requests.ListDeployStagesRequest;
import com.oracle.bmc.devops.requests.ListDeploymentsRequest;
import com.oracle.bmc.devops.requests.ListMirrorRecordsRequest;
import com.oracle.bmc.devops.requests.ListPathsRequest;
import com.oracle.bmc.devops.requests.ListProjectsRequest;
import com.oracle.bmc.devops.requests.ListRefsRequest;
import com.oracle.bmc.devops.requests.ListRepositoriesRequest;
import com.oracle.bmc.devops.requests.ListTriggersRequest;
import com.oracle.bmc.devops.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.devops.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.devops.requests.ListWorkRequestsRequest;
import com.oracle.bmc.devops.responses.ListAuthorsResponse;
import com.oracle.bmc.devops.responses.ListBuildPipelineStagesResponse;
import com.oracle.bmc.devops.responses.ListBuildPipelinesResponse;
import com.oracle.bmc.devops.responses.ListBuildRunsResponse;
import com.oracle.bmc.devops.responses.ListCommitDiffsResponse;
import com.oracle.bmc.devops.responses.ListCommitsResponse;
import com.oracle.bmc.devops.responses.ListConnectionsResponse;
import com.oracle.bmc.devops.responses.ListDeployArtifactsResponse;
import com.oracle.bmc.devops.responses.ListDeployEnvironmentsResponse;
import com.oracle.bmc.devops.responses.ListDeployPipelinesResponse;
import com.oracle.bmc.devops.responses.ListDeployStagesResponse;
import com.oracle.bmc.devops.responses.ListDeploymentsResponse;
import com.oracle.bmc.devops.responses.ListMirrorRecordsResponse;
import com.oracle.bmc.devops.responses.ListPathsResponse;
import com.oracle.bmc.devops.responses.ListProjectsResponse;
import com.oracle.bmc.devops.responses.ListRefsResponse;
import com.oracle.bmc.devops.responses.ListRepositoriesResponse;
import com.oracle.bmc.devops.responses.ListTriggersResponse;
import com.oracle.bmc.devops.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.devops.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.devops.responses.ListWorkRequestsResponse;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;

public class DevopsPaginators {
    private final Devops client;

    public DevopsPaginators(Devops client) {
        this.client = client;
    }

    public Iterable<ListAuthorsResponse> listAuthorsResponseIterator(final ListAuthorsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListAuthorsRequest.Builder>(){

            @Override
            public ListAuthorsRequest.Builder get() {
                return ListAuthorsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListAuthorsResponse, String>(){

            @Override
            public String apply(ListAuthorsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListAuthorsRequest.Builder>, ListAuthorsRequest>(){

            @Override
            public ListAuthorsRequest apply(RequestBuilderAndToken<ListAuthorsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListAuthorsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListAuthorsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListAuthorsRequest, ListAuthorsResponse>(){

            @Override
            public ListAuthorsResponse apply(ListAuthorsRequest request) {
                return DevopsPaginators.this.client.listAuthors(request);
            }
        });
    }

    public Iterable<RepositoryAuthorSummary> listAuthorsRecordIterator(final ListAuthorsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListAuthorsRequest.Builder>(){

            @Override
            public ListAuthorsRequest.Builder get() {
                return ListAuthorsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListAuthorsResponse, String>(){

            @Override
            public String apply(ListAuthorsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListAuthorsRequest.Builder>, ListAuthorsRequest>(){

            @Override
            public ListAuthorsRequest apply(RequestBuilderAndToken<ListAuthorsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListAuthorsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListAuthorsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListAuthorsRequest, ListAuthorsResponse>(){

            @Override
            public ListAuthorsResponse apply(ListAuthorsRequest request) {
                return DevopsPaginators.this.client.listAuthors(request);
            }
        }, (Function)new Function<ListAuthorsResponse, List<RepositoryAuthorSummary>>(){

            @Override
            public List<RepositoryAuthorSummary> apply(ListAuthorsResponse response) {
                return response.getRepositoryAuthorCollection().getItems();
            }
        });
    }

    public Iterable<ListBuildPipelineStagesResponse> listBuildPipelineStagesResponseIterator(final ListBuildPipelineStagesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListBuildPipelineStagesRequest.Builder>(){

            @Override
            public ListBuildPipelineStagesRequest.Builder get() {
                return ListBuildPipelineStagesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListBuildPipelineStagesResponse, String>(){

            @Override
            public String apply(ListBuildPipelineStagesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListBuildPipelineStagesRequest.Builder>, ListBuildPipelineStagesRequest>(){

            @Override
            public ListBuildPipelineStagesRequest apply(RequestBuilderAndToken<ListBuildPipelineStagesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListBuildPipelineStagesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListBuildPipelineStagesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListBuildPipelineStagesRequest, ListBuildPipelineStagesResponse>(){

            @Override
            public ListBuildPipelineStagesResponse apply(ListBuildPipelineStagesRequest request) {
                return DevopsPaginators.this.client.listBuildPipelineStages(request);
            }
        });
    }

    public Iterable<BuildPipelineStageSummary> listBuildPipelineStagesRecordIterator(final ListBuildPipelineStagesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListBuildPipelineStagesRequest.Builder>(){

            @Override
            public ListBuildPipelineStagesRequest.Builder get() {
                return ListBuildPipelineStagesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListBuildPipelineStagesResponse, String>(){

            @Override
            public String apply(ListBuildPipelineStagesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListBuildPipelineStagesRequest.Builder>, ListBuildPipelineStagesRequest>(){

            @Override
            public ListBuildPipelineStagesRequest apply(RequestBuilderAndToken<ListBuildPipelineStagesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListBuildPipelineStagesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListBuildPipelineStagesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListBuildPipelineStagesRequest, ListBuildPipelineStagesResponse>(){

            @Override
            public ListBuildPipelineStagesResponse apply(ListBuildPipelineStagesRequest request) {
                return DevopsPaginators.this.client.listBuildPipelineStages(request);
            }
        }, (Function)new Function<ListBuildPipelineStagesResponse, List<BuildPipelineStageSummary>>(){

            @Override
            public List<BuildPipelineStageSummary> apply(ListBuildPipelineStagesResponse response) {
                return response.getBuildPipelineStageCollection().getItems();
            }
        });
    }

    public Iterable<ListBuildPipelinesResponse> listBuildPipelinesResponseIterator(final ListBuildPipelinesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListBuildPipelinesRequest.Builder>(){

            @Override
            public ListBuildPipelinesRequest.Builder get() {
                return ListBuildPipelinesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListBuildPipelinesResponse, String>(){

            @Override
            public String apply(ListBuildPipelinesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListBuildPipelinesRequest.Builder>, ListBuildPipelinesRequest>(){

            @Override
            public ListBuildPipelinesRequest apply(RequestBuilderAndToken<ListBuildPipelinesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListBuildPipelinesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListBuildPipelinesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListBuildPipelinesRequest, ListBuildPipelinesResponse>(){

            @Override
            public ListBuildPipelinesResponse apply(ListBuildPipelinesRequest request) {
                return DevopsPaginators.this.client.listBuildPipelines(request);
            }
        });
    }

    public Iterable<BuildPipelineSummary> listBuildPipelinesRecordIterator(final ListBuildPipelinesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListBuildPipelinesRequest.Builder>(){

            @Override
            public ListBuildPipelinesRequest.Builder get() {
                return ListBuildPipelinesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListBuildPipelinesResponse, String>(){

            @Override
            public String apply(ListBuildPipelinesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListBuildPipelinesRequest.Builder>, ListBuildPipelinesRequest>(){

            @Override
            public ListBuildPipelinesRequest apply(RequestBuilderAndToken<ListBuildPipelinesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListBuildPipelinesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListBuildPipelinesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListBuildPipelinesRequest, ListBuildPipelinesResponse>(){

            @Override
            public ListBuildPipelinesResponse apply(ListBuildPipelinesRequest request) {
                return DevopsPaginators.this.client.listBuildPipelines(request);
            }
        }, (Function)new Function<ListBuildPipelinesResponse, List<BuildPipelineSummary>>(){

            @Override
            public List<BuildPipelineSummary> apply(ListBuildPipelinesResponse response) {
                return response.getBuildPipelineCollection().getItems();
            }
        });
    }

    public Iterable<ListBuildRunsResponse> listBuildRunsResponseIterator(final ListBuildRunsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListBuildRunsRequest.Builder>(){

            @Override
            public ListBuildRunsRequest.Builder get() {
                return ListBuildRunsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListBuildRunsResponse, String>(){

            @Override
            public String apply(ListBuildRunsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListBuildRunsRequest.Builder>, ListBuildRunsRequest>(){

            @Override
            public ListBuildRunsRequest apply(RequestBuilderAndToken<ListBuildRunsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListBuildRunsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListBuildRunsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListBuildRunsRequest, ListBuildRunsResponse>(){

            @Override
            public ListBuildRunsResponse apply(ListBuildRunsRequest request) {
                return DevopsPaginators.this.client.listBuildRuns(request);
            }
        });
    }

    public Iterable<BuildRunSummary> listBuildRunsRecordIterator(final ListBuildRunsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListBuildRunsRequest.Builder>(){

            @Override
            public ListBuildRunsRequest.Builder get() {
                return ListBuildRunsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListBuildRunsResponse, String>(){

            @Override
            public String apply(ListBuildRunsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListBuildRunsRequest.Builder>, ListBuildRunsRequest>(){

            @Override
            public ListBuildRunsRequest apply(RequestBuilderAndToken<ListBuildRunsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListBuildRunsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListBuildRunsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListBuildRunsRequest, ListBuildRunsResponse>(){

            @Override
            public ListBuildRunsResponse apply(ListBuildRunsRequest request) {
                return DevopsPaginators.this.client.listBuildRuns(request);
            }
        }, (Function)new Function<ListBuildRunsResponse, List<BuildRunSummary>>(){

            @Override
            public List<BuildRunSummary> apply(ListBuildRunsResponse response) {
                return response.getBuildRunSummaryCollection().getItems();
            }
        });
    }

    public Iterable<ListCommitDiffsResponse> listCommitDiffsResponseIterator(final ListCommitDiffsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListCommitDiffsRequest.Builder>(){

            @Override
            public ListCommitDiffsRequest.Builder get() {
                return ListCommitDiffsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListCommitDiffsResponse, String>(){

            @Override
            public String apply(ListCommitDiffsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListCommitDiffsRequest.Builder>, ListCommitDiffsRequest>(){

            @Override
            public ListCommitDiffsRequest apply(RequestBuilderAndToken<ListCommitDiffsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListCommitDiffsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListCommitDiffsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListCommitDiffsRequest, ListCommitDiffsResponse>(){

            @Override
            public ListCommitDiffsResponse apply(ListCommitDiffsRequest request) {
                return DevopsPaginators.this.client.listCommitDiffs(request);
            }
        });
    }

    public Iterable<DiffSummary> listCommitDiffsRecordIterator(final ListCommitDiffsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListCommitDiffsRequest.Builder>(){

            @Override
            public ListCommitDiffsRequest.Builder get() {
                return ListCommitDiffsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListCommitDiffsResponse, String>(){

            @Override
            public String apply(ListCommitDiffsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListCommitDiffsRequest.Builder>, ListCommitDiffsRequest>(){

            @Override
            public ListCommitDiffsRequest apply(RequestBuilderAndToken<ListCommitDiffsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListCommitDiffsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListCommitDiffsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListCommitDiffsRequest, ListCommitDiffsResponse>(){

            @Override
            public ListCommitDiffsResponse apply(ListCommitDiffsRequest request) {
                return DevopsPaginators.this.client.listCommitDiffs(request);
            }
        }, (Function)new Function<ListCommitDiffsResponse, List<DiffSummary>>(){

            @Override
            public List<DiffSummary> apply(ListCommitDiffsResponse response) {
                return response.getDiffCollection().getItems();
            }
        });
    }

    public Iterable<ListCommitsResponse> listCommitsResponseIterator(final ListCommitsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListCommitsRequest.Builder>(){

            @Override
            public ListCommitsRequest.Builder get() {
                return ListCommitsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListCommitsResponse, String>(){

            @Override
            public String apply(ListCommitsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListCommitsRequest.Builder>, ListCommitsRequest>(){

            @Override
            public ListCommitsRequest apply(RequestBuilderAndToken<ListCommitsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListCommitsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListCommitsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListCommitsRequest, ListCommitsResponse>(){

            @Override
            public ListCommitsResponse apply(ListCommitsRequest request) {
                return DevopsPaginators.this.client.listCommits(request);
            }
        });
    }

    public Iterable<RepositoryCommitSummary> listCommitsRecordIterator(final ListCommitsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListCommitsRequest.Builder>(){

            @Override
            public ListCommitsRequest.Builder get() {
                return ListCommitsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListCommitsResponse, String>(){

            @Override
            public String apply(ListCommitsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListCommitsRequest.Builder>, ListCommitsRequest>(){

            @Override
            public ListCommitsRequest apply(RequestBuilderAndToken<ListCommitsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListCommitsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListCommitsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListCommitsRequest, ListCommitsResponse>(){

            @Override
            public ListCommitsResponse apply(ListCommitsRequest request) {
                return DevopsPaginators.this.client.listCommits(request);
            }
        }, (Function)new Function<ListCommitsResponse, List<RepositoryCommitSummary>>(){

            @Override
            public List<RepositoryCommitSummary> apply(ListCommitsResponse response) {
                return response.getRepositoryCommitCollection().getItems();
            }
        });
    }

    public Iterable<ListConnectionsResponse> listConnectionsResponseIterator(final ListConnectionsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListConnectionsRequest.Builder>(){

            @Override
            public ListConnectionsRequest.Builder get() {
                return ListConnectionsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListConnectionsResponse, String>(){

            @Override
            public String apply(ListConnectionsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListConnectionsRequest.Builder>, ListConnectionsRequest>(){

            @Override
            public ListConnectionsRequest apply(RequestBuilderAndToken<ListConnectionsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListConnectionsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListConnectionsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListConnectionsRequest, ListConnectionsResponse>(){

            @Override
            public ListConnectionsResponse apply(ListConnectionsRequest request) {
                return DevopsPaginators.this.client.listConnections(request);
            }
        });
    }

    public Iterable<ConnectionSummary> listConnectionsRecordIterator(final ListConnectionsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListConnectionsRequest.Builder>(){

            @Override
            public ListConnectionsRequest.Builder get() {
                return ListConnectionsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListConnectionsResponse, String>(){

            @Override
            public String apply(ListConnectionsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListConnectionsRequest.Builder>, ListConnectionsRequest>(){

            @Override
            public ListConnectionsRequest apply(RequestBuilderAndToken<ListConnectionsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListConnectionsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListConnectionsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListConnectionsRequest, ListConnectionsResponse>(){

            @Override
            public ListConnectionsResponse apply(ListConnectionsRequest request) {
                return DevopsPaginators.this.client.listConnections(request);
            }
        }, (Function)new Function<ListConnectionsResponse, List<ConnectionSummary>>(){

            @Override
            public List<ConnectionSummary> apply(ListConnectionsResponse response) {
                return response.getConnectionCollection().getItems();
            }
        });
    }

    public Iterable<ListDeployArtifactsResponse> listDeployArtifactsResponseIterator(final ListDeployArtifactsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListDeployArtifactsRequest.Builder>(){

            @Override
            public ListDeployArtifactsRequest.Builder get() {
                return ListDeployArtifactsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListDeployArtifactsResponse, String>(){

            @Override
            public String apply(ListDeployArtifactsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListDeployArtifactsRequest.Builder>, ListDeployArtifactsRequest>(){

            @Override
            public ListDeployArtifactsRequest apply(RequestBuilderAndToken<ListDeployArtifactsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListDeployArtifactsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListDeployArtifactsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListDeployArtifactsRequest, ListDeployArtifactsResponse>(){

            @Override
            public ListDeployArtifactsResponse apply(ListDeployArtifactsRequest request) {
                return DevopsPaginators.this.client.listDeployArtifacts(request);
            }
        });
    }

    public Iterable<DeployArtifactSummary> listDeployArtifactsRecordIterator(final ListDeployArtifactsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListDeployArtifactsRequest.Builder>(){

            @Override
            public ListDeployArtifactsRequest.Builder get() {
                return ListDeployArtifactsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListDeployArtifactsResponse, String>(){

            @Override
            public String apply(ListDeployArtifactsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListDeployArtifactsRequest.Builder>, ListDeployArtifactsRequest>(){

            @Override
            public ListDeployArtifactsRequest apply(RequestBuilderAndToken<ListDeployArtifactsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListDeployArtifactsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListDeployArtifactsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListDeployArtifactsRequest, ListDeployArtifactsResponse>(){

            @Override
            public ListDeployArtifactsResponse apply(ListDeployArtifactsRequest request) {
                return DevopsPaginators.this.client.listDeployArtifacts(request);
            }
        }, (Function)new Function<ListDeployArtifactsResponse, List<DeployArtifactSummary>>(){

            @Override
            public List<DeployArtifactSummary> apply(ListDeployArtifactsResponse response) {
                return response.getDeployArtifactCollection().getItems();
            }
        });
    }

    public Iterable<ListDeployEnvironmentsResponse> listDeployEnvironmentsResponseIterator(final ListDeployEnvironmentsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListDeployEnvironmentsRequest.Builder>(){

            @Override
            public ListDeployEnvironmentsRequest.Builder get() {
                return ListDeployEnvironmentsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListDeployEnvironmentsResponse, String>(){

            @Override
            public String apply(ListDeployEnvironmentsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListDeployEnvironmentsRequest.Builder>, ListDeployEnvironmentsRequest>(){

            @Override
            public ListDeployEnvironmentsRequest apply(RequestBuilderAndToken<ListDeployEnvironmentsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListDeployEnvironmentsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListDeployEnvironmentsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListDeployEnvironmentsRequest, ListDeployEnvironmentsResponse>(){

            @Override
            public ListDeployEnvironmentsResponse apply(ListDeployEnvironmentsRequest request) {
                return DevopsPaginators.this.client.listDeployEnvironments(request);
            }
        });
    }

    public Iterable<DeployEnvironmentSummary> listDeployEnvironmentsRecordIterator(final ListDeployEnvironmentsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListDeployEnvironmentsRequest.Builder>(){

            @Override
            public ListDeployEnvironmentsRequest.Builder get() {
                return ListDeployEnvironmentsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListDeployEnvironmentsResponse, String>(){

            @Override
            public String apply(ListDeployEnvironmentsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListDeployEnvironmentsRequest.Builder>, ListDeployEnvironmentsRequest>(){

            @Override
            public ListDeployEnvironmentsRequest apply(RequestBuilderAndToken<ListDeployEnvironmentsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListDeployEnvironmentsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListDeployEnvironmentsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListDeployEnvironmentsRequest, ListDeployEnvironmentsResponse>(){

            @Override
            public ListDeployEnvironmentsResponse apply(ListDeployEnvironmentsRequest request) {
                return DevopsPaginators.this.client.listDeployEnvironments(request);
            }
        }, (Function)new Function<ListDeployEnvironmentsResponse, List<DeployEnvironmentSummary>>(){

            @Override
            public List<DeployEnvironmentSummary> apply(ListDeployEnvironmentsResponse response) {
                return response.getDeployEnvironmentCollection().getItems();
            }
        });
    }

    public Iterable<ListDeployPipelinesResponse> listDeployPipelinesResponseIterator(final ListDeployPipelinesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListDeployPipelinesRequest.Builder>(){

            @Override
            public ListDeployPipelinesRequest.Builder get() {
                return ListDeployPipelinesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListDeployPipelinesResponse, String>(){

            @Override
            public String apply(ListDeployPipelinesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListDeployPipelinesRequest.Builder>, ListDeployPipelinesRequest>(){

            @Override
            public ListDeployPipelinesRequest apply(RequestBuilderAndToken<ListDeployPipelinesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListDeployPipelinesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListDeployPipelinesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListDeployPipelinesRequest, ListDeployPipelinesResponse>(){

            @Override
            public ListDeployPipelinesResponse apply(ListDeployPipelinesRequest request) {
                return DevopsPaginators.this.client.listDeployPipelines(request);
            }
        });
    }

    public Iterable<DeployPipelineSummary> listDeployPipelinesRecordIterator(final ListDeployPipelinesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListDeployPipelinesRequest.Builder>(){

            @Override
            public ListDeployPipelinesRequest.Builder get() {
                return ListDeployPipelinesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListDeployPipelinesResponse, String>(){

            @Override
            public String apply(ListDeployPipelinesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListDeployPipelinesRequest.Builder>, ListDeployPipelinesRequest>(){

            @Override
            public ListDeployPipelinesRequest apply(RequestBuilderAndToken<ListDeployPipelinesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListDeployPipelinesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListDeployPipelinesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListDeployPipelinesRequest, ListDeployPipelinesResponse>(){

            @Override
            public ListDeployPipelinesResponse apply(ListDeployPipelinesRequest request) {
                return DevopsPaginators.this.client.listDeployPipelines(request);
            }
        }, (Function)new Function<ListDeployPipelinesResponse, List<DeployPipelineSummary>>(){

            @Override
            public List<DeployPipelineSummary> apply(ListDeployPipelinesResponse response) {
                return response.getDeployPipelineCollection().getItems();
            }
        });
    }

    public Iterable<ListDeployStagesResponse> listDeployStagesResponseIterator(final ListDeployStagesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListDeployStagesRequest.Builder>(){

            @Override
            public ListDeployStagesRequest.Builder get() {
                return ListDeployStagesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListDeployStagesResponse, String>(){

            @Override
            public String apply(ListDeployStagesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListDeployStagesRequest.Builder>, ListDeployStagesRequest>(){

            @Override
            public ListDeployStagesRequest apply(RequestBuilderAndToken<ListDeployStagesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListDeployStagesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListDeployStagesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListDeployStagesRequest, ListDeployStagesResponse>(){

            @Override
            public ListDeployStagesResponse apply(ListDeployStagesRequest request) {
                return DevopsPaginators.this.client.listDeployStages(request);
            }
        });
    }

    public Iterable<DeployStageSummary> listDeployStagesRecordIterator(final ListDeployStagesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListDeployStagesRequest.Builder>(){

            @Override
            public ListDeployStagesRequest.Builder get() {
                return ListDeployStagesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListDeployStagesResponse, String>(){

            @Override
            public String apply(ListDeployStagesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListDeployStagesRequest.Builder>, ListDeployStagesRequest>(){

            @Override
            public ListDeployStagesRequest apply(RequestBuilderAndToken<ListDeployStagesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListDeployStagesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListDeployStagesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListDeployStagesRequest, ListDeployStagesResponse>(){

            @Override
            public ListDeployStagesResponse apply(ListDeployStagesRequest request) {
                return DevopsPaginators.this.client.listDeployStages(request);
            }
        }, (Function)new Function<ListDeployStagesResponse, List<DeployStageSummary>>(){

            @Override
            public List<DeployStageSummary> apply(ListDeployStagesResponse response) {
                return response.getDeployStageCollection().getItems();
            }
        });
    }

    public Iterable<ListDeploymentsResponse> listDeploymentsResponseIterator(final ListDeploymentsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListDeploymentsRequest.Builder>(){

            @Override
            public ListDeploymentsRequest.Builder get() {
                return ListDeploymentsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListDeploymentsResponse, String>(){

            @Override
            public String apply(ListDeploymentsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListDeploymentsRequest.Builder>, ListDeploymentsRequest>(){

            @Override
            public ListDeploymentsRequest apply(RequestBuilderAndToken<ListDeploymentsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListDeploymentsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListDeploymentsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListDeploymentsRequest, ListDeploymentsResponse>(){

            @Override
            public ListDeploymentsResponse apply(ListDeploymentsRequest request) {
                return DevopsPaginators.this.client.listDeployments(request);
            }
        });
    }

    public Iterable<DeploymentSummary> listDeploymentsRecordIterator(final ListDeploymentsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListDeploymentsRequest.Builder>(){

            @Override
            public ListDeploymentsRequest.Builder get() {
                return ListDeploymentsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListDeploymentsResponse, String>(){

            @Override
            public String apply(ListDeploymentsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListDeploymentsRequest.Builder>, ListDeploymentsRequest>(){

            @Override
            public ListDeploymentsRequest apply(RequestBuilderAndToken<ListDeploymentsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListDeploymentsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListDeploymentsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListDeploymentsRequest, ListDeploymentsResponse>(){

            @Override
            public ListDeploymentsResponse apply(ListDeploymentsRequest request) {
                return DevopsPaginators.this.client.listDeployments(request);
            }
        }, (Function)new Function<ListDeploymentsResponse, List<DeploymentSummary>>(){

            @Override
            public List<DeploymentSummary> apply(ListDeploymentsResponse response) {
                return response.getDeploymentCollection().getItems();
            }
        });
    }

    public Iterable<ListMirrorRecordsResponse> listMirrorRecordsResponseIterator(final ListMirrorRecordsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListMirrorRecordsRequest.Builder>(){

            @Override
            public ListMirrorRecordsRequest.Builder get() {
                return ListMirrorRecordsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListMirrorRecordsResponse, String>(){

            @Override
            public String apply(ListMirrorRecordsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListMirrorRecordsRequest.Builder>, ListMirrorRecordsRequest>(){

            @Override
            public ListMirrorRecordsRequest apply(RequestBuilderAndToken<ListMirrorRecordsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListMirrorRecordsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListMirrorRecordsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListMirrorRecordsRequest, ListMirrorRecordsResponse>(){

            @Override
            public ListMirrorRecordsResponse apply(ListMirrorRecordsRequest request) {
                return DevopsPaginators.this.client.listMirrorRecords(request);
            }
        });
    }

    public Iterable<RepositoryMirrorRecordSummary> listMirrorRecordsRecordIterator(final ListMirrorRecordsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListMirrorRecordsRequest.Builder>(){

            @Override
            public ListMirrorRecordsRequest.Builder get() {
                return ListMirrorRecordsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListMirrorRecordsResponse, String>(){

            @Override
            public String apply(ListMirrorRecordsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListMirrorRecordsRequest.Builder>, ListMirrorRecordsRequest>(){

            @Override
            public ListMirrorRecordsRequest apply(RequestBuilderAndToken<ListMirrorRecordsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListMirrorRecordsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListMirrorRecordsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListMirrorRecordsRequest, ListMirrorRecordsResponse>(){

            @Override
            public ListMirrorRecordsResponse apply(ListMirrorRecordsRequest request) {
                return DevopsPaginators.this.client.listMirrorRecords(request);
            }
        }, (Function)new Function<ListMirrorRecordsResponse, List<RepositoryMirrorRecordSummary>>(){

            @Override
            public List<RepositoryMirrorRecordSummary> apply(ListMirrorRecordsResponse response) {
                return response.getRepositoryMirrorRecordCollection().getItems();
            }
        });
    }

    public Iterable<ListPathsResponse> listPathsResponseIterator(final ListPathsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListPathsRequest.Builder>(){

            @Override
            public ListPathsRequest.Builder get() {
                return ListPathsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListPathsResponse, String>(){

            @Override
            public String apply(ListPathsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListPathsRequest.Builder>, ListPathsRequest>(){

            @Override
            public ListPathsRequest apply(RequestBuilderAndToken<ListPathsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListPathsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListPathsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListPathsRequest, ListPathsResponse>(){

            @Override
            public ListPathsResponse apply(ListPathsRequest request) {
                return DevopsPaginators.this.client.listPaths(request);
            }
        });
    }

    public Iterable<RepositoryPathSummary> listPathsRecordIterator(final ListPathsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListPathsRequest.Builder>(){

            @Override
            public ListPathsRequest.Builder get() {
                return ListPathsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListPathsResponse, String>(){

            @Override
            public String apply(ListPathsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListPathsRequest.Builder>, ListPathsRequest>(){

            @Override
            public ListPathsRequest apply(RequestBuilderAndToken<ListPathsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListPathsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListPathsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListPathsRequest, ListPathsResponse>(){

            @Override
            public ListPathsResponse apply(ListPathsRequest request) {
                return DevopsPaginators.this.client.listPaths(request);
            }
        }, (Function)new Function<ListPathsResponse, List<RepositoryPathSummary>>(){

            @Override
            public List<RepositoryPathSummary> apply(ListPathsResponse response) {
                return response.getRepositoryPathCollection().getItems();
            }
        });
    }

    public Iterable<ListProjectsResponse> listProjectsResponseIterator(final ListProjectsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListProjectsRequest.Builder>(){

            @Override
            public ListProjectsRequest.Builder get() {
                return ListProjectsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListProjectsResponse, String>(){

            @Override
            public String apply(ListProjectsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListProjectsRequest.Builder>, ListProjectsRequest>(){

            @Override
            public ListProjectsRequest apply(RequestBuilderAndToken<ListProjectsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListProjectsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListProjectsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListProjectsRequest, ListProjectsResponse>(){

            @Override
            public ListProjectsResponse apply(ListProjectsRequest request) {
                return DevopsPaginators.this.client.listProjects(request);
            }
        });
    }

    public Iterable<ProjectSummary> listProjectsRecordIterator(final ListProjectsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListProjectsRequest.Builder>(){

            @Override
            public ListProjectsRequest.Builder get() {
                return ListProjectsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListProjectsResponse, String>(){

            @Override
            public String apply(ListProjectsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListProjectsRequest.Builder>, ListProjectsRequest>(){

            @Override
            public ListProjectsRequest apply(RequestBuilderAndToken<ListProjectsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListProjectsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListProjectsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListProjectsRequest, ListProjectsResponse>(){

            @Override
            public ListProjectsResponse apply(ListProjectsRequest request) {
                return DevopsPaginators.this.client.listProjects(request);
            }
        }, (Function)new Function<ListProjectsResponse, List<ProjectSummary>>(){

            @Override
            public List<ProjectSummary> apply(ListProjectsResponse response) {
                return response.getProjectCollection().getItems();
            }
        });
    }

    public Iterable<ListRefsResponse> listRefsResponseIterator(final ListRefsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListRefsRequest.Builder>(){

            @Override
            public ListRefsRequest.Builder get() {
                return ListRefsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListRefsResponse, String>(){

            @Override
            public String apply(ListRefsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListRefsRequest.Builder>, ListRefsRequest>(){

            @Override
            public ListRefsRequest apply(RequestBuilderAndToken<ListRefsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListRefsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListRefsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListRefsRequest, ListRefsResponse>(){

            @Override
            public ListRefsResponse apply(ListRefsRequest request) {
                return DevopsPaginators.this.client.listRefs(request);
            }
        });
    }

    public Iterable<RepositoryRefSummary> listRefsRecordIterator(final ListRefsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListRefsRequest.Builder>(){

            @Override
            public ListRefsRequest.Builder get() {
                return ListRefsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListRefsResponse, String>(){

            @Override
            public String apply(ListRefsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListRefsRequest.Builder>, ListRefsRequest>(){

            @Override
            public ListRefsRequest apply(RequestBuilderAndToken<ListRefsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListRefsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListRefsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListRefsRequest, ListRefsResponse>(){

            @Override
            public ListRefsResponse apply(ListRefsRequest request) {
                return DevopsPaginators.this.client.listRefs(request);
            }
        }, (Function)new Function<ListRefsResponse, List<RepositoryRefSummary>>(){

            @Override
            public List<RepositoryRefSummary> apply(ListRefsResponse response) {
                return response.getRepositoryRefCollection().getItems();
            }
        });
    }

    public Iterable<ListRepositoriesResponse> listRepositoriesResponseIterator(final ListRepositoriesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListRepositoriesRequest.Builder>(){

            @Override
            public ListRepositoriesRequest.Builder get() {
                return ListRepositoriesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListRepositoriesResponse, String>(){

            @Override
            public String apply(ListRepositoriesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListRepositoriesRequest.Builder>, ListRepositoriesRequest>(){

            @Override
            public ListRepositoriesRequest apply(RequestBuilderAndToken<ListRepositoriesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListRepositoriesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListRepositoriesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListRepositoriesRequest, ListRepositoriesResponse>(){

            @Override
            public ListRepositoriesResponse apply(ListRepositoriesRequest request) {
                return DevopsPaginators.this.client.listRepositories(request);
            }
        });
    }

    public Iterable<RepositorySummary> listRepositoriesRecordIterator(final ListRepositoriesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListRepositoriesRequest.Builder>(){

            @Override
            public ListRepositoriesRequest.Builder get() {
                return ListRepositoriesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListRepositoriesResponse, String>(){

            @Override
            public String apply(ListRepositoriesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListRepositoriesRequest.Builder>, ListRepositoriesRequest>(){

            @Override
            public ListRepositoriesRequest apply(RequestBuilderAndToken<ListRepositoriesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListRepositoriesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListRepositoriesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListRepositoriesRequest, ListRepositoriesResponse>(){

            @Override
            public ListRepositoriesResponse apply(ListRepositoriesRequest request) {
                return DevopsPaginators.this.client.listRepositories(request);
            }
        }, (Function)new Function<ListRepositoriesResponse, List<RepositorySummary>>(){

            @Override
            public List<RepositorySummary> apply(ListRepositoriesResponse response) {
                return response.getRepositoryCollection().getItems();
            }
        });
    }

    public Iterable<ListTriggersResponse> listTriggersResponseIterator(final ListTriggersRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListTriggersRequest.Builder>(){

            @Override
            public ListTriggersRequest.Builder get() {
                return ListTriggersRequest.builder().copy(request);
            }
        }, (Function)new Function<ListTriggersResponse, String>(){

            @Override
            public String apply(ListTriggersResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListTriggersRequest.Builder>, ListTriggersRequest>(){

            @Override
            public ListTriggersRequest apply(RequestBuilderAndToken<ListTriggersRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListTriggersRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListTriggersRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListTriggersRequest, ListTriggersResponse>(){

            @Override
            public ListTriggersResponse apply(ListTriggersRequest request) {
                return DevopsPaginators.this.client.listTriggers(request);
            }
        });
    }

    public Iterable<TriggerSummary> listTriggersRecordIterator(final ListTriggersRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListTriggersRequest.Builder>(){

            @Override
            public ListTriggersRequest.Builder get() {
                return ListTriggersRequest.builder().copy(request);
            }
        }, (Function)new Function<ListTriggersResponse, String>(){

            @Override
            public String apply(ListTriggersResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListTriggersRequest.Builder>, ListTriggersRequest>(){

            @Override
            public ListTriggersRequest apply(RequestBuilderAndToken<ListTriggersRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListTriggersRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListTriggersRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListTriggersRequest, ListTriggersResponse>(){

            @Override
            public ListTriggersResponse apply(ListTriggersRequest request) {
                return DevopsPaginators.this.client.listTriggers(request);
            }
        }, (Function)new Function<ListTriggersResponse, List<TriggerSummary>>(){

            @Override
            public List<TriggerSummary> apply(ListTriggersResponse response) {
                return response.getTriggerCollection().getItems();
            }
        });
    }

    public Iterable<ListWorkRequestErrorsResponse> listWorkRequestErrorsResponseIterator(final ListWorkRequestErrorsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWorkRequestErrorsRequest.Builder>(){

            @Override
            public ListWorkRequestErrorsRequest.Builder get() {
                return ListWorkRequestErrorsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestErrorsResponse, String>(){

            @Override
            public String apply(ListWorkRequestErrorsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder>, ListWorkRequestErrorsRequest>(){

            @Override
            public ListWorkRequestErrorsRequest apply(RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse>(){

            @Override
            public ListWorkRequestErrorsResponse apply(ListWorkRequestErrorsRequest request) {
                return DevopsPaginators.this.client.listWorkRequestErrors(request);
            }
        });
    }

    public Iterable<WorkRequestError> listWorkRequestErrorsRecordIterator(final ListWorkRequestErrorsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWorkRequestErrorsRequest.Builder>(){

            @Override
            public ListWorkRequestErrorsRequest.Builder get() {
                return ListWorkRequestErrorsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestErrorsResponse, String>(){

            @Override
            public String apply(ListWorkRequestErrorsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder>, ListWorkRequestErrorsRequest>(){

            @Override
            public ListWorkRequestErrorsRequest apply(RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse>(){

            @Override
            public ListWorkRequestErrorsResponse apply(ListWorkRequestErrorsRequest request) {
                return DevopsPaginators.this.client.listWorkRequestErrors(request);
            }
        }, (Function)new Function<ListWorkRequestErrorsResponse, List<WorkRequestError>>(){

            @Override
            public List<WorkRequestError> apply(ListWorkRequestErrorsResponse response) {
                return response.getWorkRequestErrorCollection().getItems();
            }
        });
    }

    public Iterable<ListWorkRequestLogsResponse> listWorkRequestLogsResponseIterator(final ListWorkRequestLogsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWorkRequestLogsRequest.Builder>(){

            @Override
            public ListWorkRequestLogsRequest.Builder get() {
                return ListWorkRequestLogsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestLogsResponse, String>(){

            @Override
            public String apply(ListWorkRequestLogsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder>, ListWorkRequestLogsRequest>(){

            @Override
            public ListWorkRequestLogsRequest apply(RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse>(){

            @Override
            public ListWorkRequestLogsResponse apply(ListWorkRequestLogsRequest request) {
                return DevopsPaginators.this.client.listWorkRequestLogs(request);
            }
        });
    }

    public Iterable<WorkRequestLogEntry> listWorkRequestLogsRecordIterator(final ListWorkRequestLogsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWorkRequestLogsRequest.Builder>(){

            @Override
            public ListWorkRequestLogsRequest.Builder get() {
                return ListWorkRequestLogsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestLogsResponse, String>(){

            @Override
            public String apply(ListWorkRequestLogsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder>, ListWorkRequestLogsRequest>(){

            @Override
            public ListWorkRequestLogsRequest apply(RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse>(){

            @Override
            public ListWorkRequestLogsResponse apply(ListWorkRequestLogsRequest request) {
                return DevopsPaginators.this.client.listWorkRequestLogs(request);
            }
        }, (Function)new Function<ListWorkRequestLogsResponse, List<WorkRequestLogEntry>>(){

            @Override
            public List<WorkRequestLogEntry> apply(ListWorkRequestLogsResponse response) {
                return response.getWorkRequestLogEntryCollection().getItems();
            }
        });
    }

    public Iterable<ListWorkRequestsResponse> listWorkRequestsResponseIterator(final ListWorkRequestsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWorkRequestsRequest.Builder>(){

            @Override
            public ListWorkRequestsRequest.Builder get() {
                return ListWorkRequestsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, String>(){

            @Override
            public String apply(ListWorkRequestsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestsRequest.Builder>, ListWorkRequestsRequest>(){

            @Override
            public ListWorkRequestsRequest apply(RequestBuilderAndToken<ListWorkRequestsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestsRequest, ListWorkRequestsResponse>(){

            @Override
            public ListWorkRequestsResponse apply(ListWorkRequestsRequest request) {
                return DevopsPaginators.this.client.listWorkRequests(request);
            }
        });
    }

    public Iterable<WorkRequestSummary> listWorkRequestsRecordIterator(final ListWorkRequestsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWorkRequestsRequest.Builder>(){

            @Override
            public ListWorkRequestsRequest.Builder get() {
                return ListWorkRequestsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, String>(){

            @Override
            public String apply(ListWorkRequestsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestsRequest.Builder>, ListWorkRequestsRequest>(){

            @Override
            public ListWorkRequestsRequest apply(RequestBuilderAndToken<ListWorkRequestsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestsRequest, ListWorkRequestsResponse>(){

            @Override
            public ListWorkRequestsResponse apply(ListWorkRequestsRequest request) {
                return DevopsPaginators.this.client.listWorkRequests(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, List<WorkRequestSummary>>(){

            @Override
            public List<WorkRequestSummary> apply(ListWorkRequestsResponse response) {
                return response.getWorkRequestCollection().getItems();
            }
        });
    }
}

