/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.util.sequence.builder;

import com.vladsch.flexmark.util.misc.DelimitedBuilder;
import com.vladsch.flexmark.util.sequence.Range;
import com.vladsch.flexmark.util.sequence.SequenceUtils;
import com.vladsch.flexmark.util.sequence.builder.ISegmentBuilder;
import com.vladsch.flexmark.util.sequence.builder.Seg;
import com.vladsch.flexmark.util.sequence.builder.SegmentStats;
import java.util.Arrays;
import java.util.Iterator;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SegmentBuilderBase<S extends SegmentBuilderBase<S>>
implements ISegmentBuilder<S> {
    public static final int MIN_PART_CAPACITY = 8;
    public static final int[] EMPTY_PARTS = new int[0];
    @NotNull
    protected int[] parts = EMPTY_PARTS;
    protected int partsSize = 0;
    protected int anchorsSize = 0;
    protected int startOffset = Range.NULL.getStart();
    protected int endOffset = Range.NULL.getEnd();
    protected int length = 0;
    protected final SegmentStats stats;
    protected final SegmentStats textStats;
    protected final int options;
    protected final StringBuilder text = new StringBuilder();
    protected int immutableOffset = 0;

    private static int[] ensureCapacity(@NotNull int[] prev, int size) {
        assert (size >= 0);
        int prevSize = prev.length / 2;
        if (prevSize <= size) {
            int nextSize = Math.max(8, Math.max(prevSize + prevSize >> 1, size));
            return Arrays.copyOf(prev, nextSize * 2);
        }
        return prev;
    }

    private void ensureCapacity(int size) {
        this.parts = SegmentBuilderBase.ensureCapacity(this.parts, size + 1);
    }

    public void trimToSize() {
        if (this.parts.length > this.partsSize) {
            this.parts = Arrays.copyOf(this.parts, this.partsSize * 2);
        }
    }

    protected SegmentBuilderBase() {
        this(F_INCLUDE_ANCHORS);
    }

    protected SegmentBuilderBase(int options) {
        this.options = options & (F_INCLUDE_ANCHORS | F_TRACK_FIRST256);
        this.stats = new SegmentStats((options & F_TRACK_FIRST256) != 0);
        this.textStats = new SegmentStats((options & F_TRACK_FIRST256) != 0);
    }

    @Override
    public int getStartOffset() {
        return this.startOffset <= this.endOffset ? this.startOffset : -1;
    }

    public boolean needStartOffset() {
        return this.getStartOffsetIfNeeded() != -1;
    }

    public int getStartOffsetIfNeeded() {
        int startOffset = this.getStartOffset();
        Seg seg = this.getSegOrNull(0);
        return startOffset != -1 && seg != null && seg.isBase() && startOffset != seg.getStart() ? startOffset : -1;
    }

    @Override
    public int getEndOffset() {
        return this.endOffset >= this.startOffset ? this.endOffset : -1;
    }

    public boolean needEndOffset() {
        return this.getEndOffsetIfNeeded() != -1;
    }

    public int getEndOffsetIfNeeded() {
        int endOffset = this.getEndOffset();
        Seg seg = this.getSegOrNull(this.partsSize - 1);
        return endOffset != -1 && seg != null && seg.isBase() && endOffset != seg.getEnd() ? endOffset : -1;
    }

    @Override
    public boolean isEmpty() {
        return this.length == 0;
    }

    @Override
    public boolean isBaseSubSequenceRange() {
        return this.getBaseSubSequenceRange() != null;
    }

    @Override
    @Nullable
    public Range getBaseSubSequenceRange() {
        if (this.partsSize == 1 && !this.haveDanglingText()) {
            Seg seg = this.getSeg(this.partsSize - 1);
            if (seg.length() != 0 && this.anchorsSize == 1) {
                seg = this.getSeg(this.partsSize - 2);
            }
            if (seg.isBase() && seg.getStart() == this.startOffset && seg.getEnd() == this.endOffset) {
                return seg.getRange();
            }
        }
        return null;
    }

    @Override
    public boolean haveOffsets() {
        return this.startOffset <= this.endOffset;
    }

    @Override
    public int size() {
        return this.partsSize + (this.haveDanglingText() ? 1 : 0);
    }

    @Override
    public CharSequence getText() {
        return this.text;
    }

    @Override
    public int noAnchorsSize() {
        return this.size() - this.anchorsSize;
    }

    private int computeLength() {
        int length = 0;
        int iMax = this.partsSize;
        for (int i = 0; i < iMax; ++i) {
            Seg part = this.getSeg(i);
            length += part.length();
        }
        if (this.haveDanglingText()) {
            length += this.text.length() - this.immutableOffset;
        }
        return length;
    }

    @Override
    public int length() {
        assert (this.length == this.computeLength()) : "length:" + this.length + " != computeLength(): " + this.computeLength();
        return this.length;
    }

    public SegmentStats getStats() {
        return this.stats;
    }

    @Override
    public boolean isTrackTextFirst256() {
        return this.stats.isTrackTextFirst256();
    }

    @Override
    public int getTextLength() {
        return this.stats.getTextLength();
    }

    @Override
    public int getTextSegments() {
        return this.stats.getTextSegments();
    }

    @Override
    public int getTextSpaceLength() {
        return this.stats.getTextSpaceLength();
    }

    @Override
    public int getTextSpaceSegments() {
        return this.stats.getTextSpaceSegments();
    }

    @Override
    public int getTextFirst256Length() {
        return this.stats.getTextFirst256Length();
    }

    @Override
    public int getTextFirst256Segments() {
        return this.stats.getTextFirst256Segments();
    }

    @Override
    @NotNull
    public Iterator<Object> iterator() {
        return new PartsIterator(this);
    }

    @Override
    @NotNull
    public Iterable<Seg> getSegments() {
        return new SegIterable(this);
    }

    @Override
    public int getOptions() {
        return this.options;
    }

    @Override
    public boolean isIncludeAnchors() {
        return (this.options & F_INCLUDE_ANCHORS) != 0;
    }

    @Override
    public int getSpan() {
        return this.startOffset > this.endOffset ? -1 : this.endOffset - this.startOffset;
    }

    @Nullable
    private Seg getSegOrNull(int index) {
        int i = index * 2;
        return i + 1 >= this.parts.length ? null : Seg.segOf(this.parts[i], this.parts[i + 1]);
    }

    @NotNull
    private Seg getSeg(int index) {
        int i = index * 2;
        return i + 1 >= this.parts.length ? Seg.NULL : Seg.segOf(this.parts[i], this.parts[i + 1]);
    }

    @NotNull
    public Object getPart(int index) {
        Seg seg;
        if (index == this.partsSize && this.haveDanglingText()) {
            return this.text.subSequence(this.immutableOffset, this.text.length());
        }
        int i = index * 2;
        Seg seg2 = seg = i + 1 >= this.parts.length ? Seg.NULL : Seg.segOf(this.parts[i], this.parts[i + 1]);
        return seg.isBase() ? seg.getRange() : (seg.isText() ? this.text.subSequence(seg.getTextStart(), seg.getTextEnd()) : Range.NULL);
    }

    @NotNull
    Seg getSegPart(int index) {
        if (index == this.partsSize && this.haveDanglingText()) {
            return Seg.textOf(this.immutableOffset, this.text.length(), this.textStats.isTextFirst256(), this.textStats.isRepeatedText());
        }
        int i = index * 2;
        return i + 1 >= this.parts.length ? Seg.NULL : Seg.segOf(this.parts[i], this.parts[i + 1]);
    }

    private void setSegEnd(int index, int endOffset) {
        int i = index * 2;
        assert (i + 1 < this.parts.length);
        if (this.parts[i] == endOffset) {
            if (this.parts[i] != this.parts[i + 1]) {
                ++this.anchorsSize;
            }
        } else if (this.parts[i] == this.parts[i + 1]) {
            --this.anchorsSize;
        }
        this.parts[i + 1] = endOffset;
    }

    private void addSeg(int startOffset, int endOffset) {
        this.ensureCapacity(this.partsSize);
        int i = this.partsSize * 2;
        this.parts[i] = startOffset;
        this.parts[i + 1] = endOffset;
        ++this.partsSize;
        if (startOffset == endOffset) {
            ++this.anchorsSize;
        }
    }

    @Nullable
    private Seg lastSegOrNull() {
        return this.partsSize == 0 ? null : this.getSegOrNull(this.partsSize - 1);
    }

    protected boolean haveDanglingText() {
        return this.text.length() > this.immutableOffset;
    }

    protected Object[] optimizeText(@NotNull Object[] parts) {
        return parts;
    }

    protected Object[] handleOverlap(@NotNull Object[] parts) {
        Range lastSeg = (Range)parts[0];
        CharSequence text = (CharSequence)parts[1];
        Range range = (Range)parts[2];
        assert (!lastSeg.isNull() && lastSeg.getEnd() > range.getStart());
        if (lastSeg.getEnd() < range.getEnd()) {
            if (text.length() > 0) {
                parts[2] = Range.of(lastSeg.getEnd(), range.getEnd());
            } else {
                parts[0] = lastSeg.withEnd(range.getEnd());
                parts[2] = Range.NULL;
            }
        } else {
            parts[2] = Range.NULL;
        }
        return parts;
    }

    private void processParts(int segStart, int segEnd, boolean resolveOverlap, boolean nullNextRange, @NotNull Function<Object[], Object[]> transform) {
        Range prevRange;
        assert (segStart >= 0 && segEnd >= 0 && segStart <= segEnd);
        CharSequence text = this.text.subSequence(this.immutableOffset, this.text.length());
        assert (resolveOverlap || text.length() > 0);
        Seg lastSeg = this.lastSegOrNull();
        Range range = prevRange = lastSeg == null || !lastSeg.isBase() ? Range.NULL : lastSeg.getRange();
        if (!this.isIncludeAnchors() && this.haveOffsets() && (prevRange.isNull() || prevRange.getEnd() < this.endOffset)) {
            prevRange = Range.emptyOf(this.endOffset);
        }
        if (!this.haveOffsets()) {
            this.startOffset = segStart;
        }
        if (!resolveOverlap) {
            this.endOffset = Math.max(this.endOffset, segEnd);
        }
        Object[] parts = new Object[]{prevRange, text, nullNextRange ? Range.NULL : Range.of(segStart, segEnd)};
        Object[] originalParts = (Object[])parts.clone();
        Object[] optimizedText = transform.apply(parts);
        assert (optimizedText.length > 0);
        if (Arrays.equals(optimizedText, originalParts)) {
            assert (!resolveOverlap);
            if (segEnd > segStart || this.isIncludeAnchors()) {
                if (text.length() > 0) {
                    this.commitText();
                }
                this.length += segEnd - segStart;
                this.addSeg(segStart, segEnd);
            }
        } else {
            this.textStats.commitText();
            this.stats.commitText();
            this.stats.remove(this.textStats);
            this.textStats.clear();
            this.length -= text.length();
            this.text.delete(this.immutableOffset, this.text.length());
            if (lastSeg != null && lastSeg.isBase()) {
                this.length -= lastSeg.length();
                --this.partsSize;
                if (lastSeg.length() == 0) {
                    --this.anchorsSize;
                }
            }
            int iMax = optimizedText.length;
            int optStartOffset = Integer.MAX_VALUE;
            int optEndOffset = Integer.MIN_VALUE;
            for (int i = 0; i < iMax; ++i) {
                Object oPart = optimizedText[i];
                if (oPart instanceof CharSequence) {
                    CharSequence optText = (CharSequence)oPart;
                    if (optText.length() <= 0) continue;
                    this.addText(optText);
                    continue;
                }
                if (oPart instanceof Range) {
                    if (!((Range)oPart).isNotNull()) continue;
                    int optRangeStart = ((Range)oPart).getStart();
                    int optRangeEnd = ((Range)oPart).getEnd();
                    assert (optRangeStart >= 0 && optRangeEnd >= 0 && optRangeStart <= optRangeEnd);
                    if (optStartOffset == Integer.MAX_VALUE) {
                        optStartOffset = optRangeStart;
                    }
                    if (optRangeStart < optEndOffset) {
                        throw new IllegalStateException(String.format("Accumulated range [%d, %d) overlaps Transformed Range[%d]: [%d, %d)", optStartOffset, optEndOffset, i, optRangeStart, optRangeEnd));
                    }
                    optEndOffset = Math.max(optEndOffset, optRangeEnd);
                    boolean haveDanglingText = this.haveDanglingText();
                    if (haveDanglingText && resolveOverlap) {
                        this.processParts(optRangeStart, optRangeEnd, false, false, this::optimizeText);
                        continue;
                    }
                    this.startOffset = Math.min(this.startOffset, optRangeStart);
                    this.endOffset = Math.max(this.endOffset, optRangeEnd);
                    if (optRangeStart == optRangeEnd && !this.isIncludeAnchors()) continue;
                    if (haveDanglingText) {
                        this.commitText();
                    }
                    this.length += optRangeEnd - optRangeStart;
                    this.addSeg(optRangeStart, optRangeEnd);
                    continue;
                }
                if (oPart == null) continue;
                throw new IllegalStateException("Invalid optimized part type " + oPart.getClass());
            }
        }
    }

    private void commitText() {
        this.addSeg(Seg.getTextStart(this.immutableOffset, this.textStats.isTextFirst256()), Seg.getTextEnd(this.text.length(), this.textStats.isRepeatedText()));
        this.immutableOffset = this.text.length();
        this.stats.commitText();
        this.textStats.clear();
    }

    private void addText(CharSequence optText) {
        this.length += optText.length();
        this.text.append(optText);
        this.stats.addText(optText);
        this.textStats.addText(optText);
    }

    @Override
    @NotNull
    public S appendAnchor(int offset) {
        return (S)this.append(offset, offset);
    }

    @Override
    @NotNull
    public S append(@NotNull Range range) {
        return (S)this.append(range.getStart(), range.getEnd());
    }

    @Override
    @NotNull
    public S append(int startOffset, int endOffset) {
        if (endOffset < 0 || startOffset > endOffset) {
            return (S)this;
        }
        int rangeSpan = endOffset - startOffset;
        if (!(rangeSpan != 0 || this.isIncludeAnchors() && startOffset >= this.endOffset)) {
            if (startOffset >= this.endOffset) {
                if (this.haveDanglingText()) {
                    this.processParts(startOffset, endOffset, false, false, this::optimizeText);
                } else {
                    if (!this.haveOffsets()) {
                        this.startOffset = startOffset;
                    }
                    this.endOffset = startOffset;
                }
            }
            return (S)this;
        }
        if (this.endOffset > startOffset) {
            this.processParts(startOffset, endOffset, true, false, this::handleOverlap);
        } else if (this.endOffset == startOffset) {
            if (this.haveDanglingText()) {
                this.processParts(startOffset, endOffset, false, false, this::optimizeText);
            } else {
                this.endOffset = endOffset;
                this.length += rangeSpan;
                if (this.partsSize == 0) {
                    this.addSeg(startOffset, endOffset);
                } else {
                    this.setSegEnd(this.partsSize - 1, endOffset);
                }
            }
        } else if (this.haveDanglingText()) {
            this.processParts(startOffset, endOffset, false, false, this::optimizeText);
        } else {
            if (!this.haveOffsets()) {
                this.startOffset = startOffset;
            }
            this.endOffset = endOffset;
            this.length += rangeSpan;
            this.addSeg(startOffset, endOffset);
        }
        return (S)this;
    }

    @Override
    @NotNull
    public S append(@NotNull CharSequence text) {
        int length = text.length();
        if (length != 0) {
            this.stats.addText(text);
            this.textStats.addText(text);
            this.text.append(text);
            this.length += length;
        }
        return (S)this;
    }

    @NotNull
    public S append(char c) {
        this.stats.addText(c);
        this.textStats.addText(c);
        this.text.append(c);
        ++this.length;
        return (S)this;
    }

    @NotNull
    public S append(char c, int repeat) {
        if (repeat > 0) {
            this.stats.addText(c, repeat);
            this.textStats.addText(c, repeat);
            this.length += repeat;
            while (repeat-- > 0) {
                this.text.append(c);
            }
        }
        return (S)this;
    }

    @NotNull
    public String toString(@NotNull CharSequence chars, @NotNull CharSequence rangePrefix, @NotNull CharSequence rangeSuffix, @NotNull Function<CharSequence, CharSequence> textMapper) {
        if (this.endOffset > chars.length()) {
            throw new IllegalArgumentException("baseSequence length() must be at least " + this.endOffset + ", got: " + chars.length());
        }
        if (this.haveDanglingText() && this.haveOffsets()) {
            this.processParts(this.endOffset, this.endOffset, false, true, this::optimizeText);
        }
        StringBuilder out = new StringBuilder();
        int iMax = this.partsSize;
        for (int i = 0; i < iMax; ++i) {
            Seg part = this.getSeg(i);
            if (!part.isBase()) {
                out.append(textMapper.apply(this.text.subSequence(part.getTextStart(), part.getTextEnd())));
                continue;
            }
            out.append(rangePrefix).append(textMapper.apply(chars.subSequence(part.getStart(), part.getEnd()))).append(rangeSuffix);
        }
        if (this.haveDanglingText()) {
            out.append(textMapper.apply(this.text.subSequence(this.immutableOffset, this.text.length())));
        }
        return out.toString();
    }

    @Override
    @NotNull
    public String toStringWithRangesVisibleWhitespace(@NotNull CharSequence chars) {
        return this.toString(chars, "\u27e6", "\u27e7", SequenceUtils::toVisibleWhitespaceString);
    }

    @Override
    @NotNull
    public String toStringWithRanges(@NotNull CharSequence chars) {
        return this.toString(chars, "\u27e6", "\u27e7", Function.identity());
    }

    @Override
    @NotNull
    public String toString(@NotNull CharSequence chars) {
        return this.toString(chars, "", "", Function.identity());
    }

    public String toStringPrep() {
        if (this.haveDanglingText() && this.haveOffsets()) {
            this.processParts(this.endOffset, this.endOffset, false, true, this::optimizeText);
        }
        return this.toString();
    }

    public String toString() {
        DelimitedBuilder sb = new DelimitedBuilder(", ");
        sb.append(this.getClass().getSimpleName()).append("{");
        if (this.haveOffsets()) {
            sb.append("[").append(this.startOffset).mark().append(this.endOffset).unmark().append(")").mark();
        } else {
            sb.append("NULL").mark();
        }
        SegmentStats committedStats = this.stats.committedCopy();
        sb.append((Object)committedStats).mark().append("l=").append(this.length).mark().append("sz=").append(this.size()).mark().append("na=").append(this.noAnchorsSize());
        if (this.size() > 0) {
            sb.append(": ");
        }
        int iMax = this.partsSize;
        for (int i = 0; i < iMax; ++i) {
            Seg part = this.getSeg(i);
            sb.append(part.toString(this.text)).mark();
        }
        if (this.haveDanglingText()) {
            Seg part = Seg.textOf(this.immutableOffset, this.text.length(), this.textStats.isTextFirst256(), this.textStats.isRepeatedText());
            sb.append(part.toString(this.text)).mark();
        }
        sb.unmark().append(" }");
        return sb.toString();
    }

    static class SegIterator
    implements Iterator<Seg> {
        final SegmentBuilderBase<?> builder;
        int nextIndex;

        public SegIterator(SegmentBuilderBase<?> builder) {
            this.builder = builder;
        }

        @Override
        public boolean hasNext() {
            return this.nextIndex < this.builder.size();
        }

        @Override
        public Seg next() {
            return this.builder.getSegPart(this.nextIndex++);
        }
    }

    static class SegIterable
    implements Iterable<Seg> {
        final SegmentBuilderBase<?> builder;

        public SegIterable(SegmentBuilderBase<?> builder) {
            this.builder = builder;
        }

        @Override
        @NotNull
        public Iterator<Seg> iterator() {
            return new SegIterator(this.builder);
        }
    }

    static class PartsIterator
    implements Iterator<Object> {
        final SegmentBuilderBase<?> builder;
        int nextIndex;

        public PartsIterator(SegmentBuilderBase<?> builder) {
            this.builder = builder;
        }

        @Override
        public boolean hasNext() {
            return this.nextIndex < this.builder.size();
        }

        @Override
        public Object next() {
            return this.builder.getPart(this.nextIndex++);
        }
    }
}

