/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.execute.navigator;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Image;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Set;
import javax.swing.Action;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.gradle.FavoriteTaskManager;
import org.netbeans.modules.gradle.api.GradleBaseProject;
import org.netbeans.modules.gradle.api.GradleTask;
import org.netbeans.modules.gradle.api.NbGradleProject;
import org.netbeans.modules.gradle.execute.navigator.Bundle;
import org.netbeans.modules.gradle.nodes.TaskNode;
import org.netbeans.modules.gradle.spi.Utils;
import org.netbeans.modules.gradle.spi.nodes.NodeUtils;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.BeanTreeView;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;
import org.openide.util.lookup.Lookups;

public class TasksPanel
extends JPanel
implements ExplorerManager.Provider {
    private static final String GRADLE_ICON = "org/netbeans/modules/gradle/resources/gradle.png";
    private final transient ExplorerManager manager = new ExplorerManager();
    private final BeanTreeView treeView;
    private NbGradleProject current;
    private Project currentP;
    private final PropertyChangeListener pchadapter = evt -> {
        if ("ProjectInfo".equals(evt.getPropertyName())) {
            RequestProcessor.getDefault().post(() -> this.update(this.currentP));
        }
    };

    public TasksPanel() {
        this.treeView = new BeanTreeView();
        this.setLayout(new BorderLayout());
        this.add((Component)this.treeView, "Center");
        this.treeView.setSelectionMode(1);
    }

    public ExplorerManager getExplorerManager() {
        return this.manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void navigate(DataObject d) {
        NbGradleProject n = null;
        FileObject f = d.getPrimaryFile();
        if (!f.isFolder()) {
            f = f.getParent();
        }
        Project p = null;
        try {
            p = ProjectManager.getDefault().findProject(f);
            if (p != null) {
                n = NbGradleProject.get(p);
            }
        }
        catch (IOException | IllegalArgumentException exception) {
            // empty catch block
        }
        TasksPanel tasksPanel = this;
        synchronized (tasksPanel) {
            if (this.current != null) {
                this.current.removePropertyChangeListener(this.pchadapter);
            }
            if (n == null) {
                this.release();
                return;
            }
            this.current = n;
            this.currentP = p;
            this.current.addPropertyChangeListener(this.pchadapter);
        }
        RequestProcessor.getDefault().post(() -> this.update(this.currentP));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(Project updateP) {
        TasksPanel tasksPanel = this;
        synchronized (tasksPanel) {
            if (updateP != this.currentP) {
                return;
            }
            if (updateP == null) {
                return;
            }
        }
        GradleBaseProject prj = GradleBaseProject.get(updateP);
        if (prj != null) {
            Children.Array taskGroups = new Children.Array();
            ArrayList<String> glist = new ArrayList<String>(prj.getTaskGroups());
            glist.remove("<private>");
            glist.sort(String.CASE_INSENSITIVE_ORDER);
            for (String group : glist) {
                taskGroups.add(new Node[]{new TaskGroupNode(group, prj, updateP)});
            }
            taskGroups.add(new Node[]{new TaskGroupNode("<private>", prj, updateP)});
            AbstractNode tasksNode = new AbstractNode((Children)taskGroups, Lookups.singleton((Object)updateP)){

                public Action[] getActions(boolean context) {
                    return new Action[0];
                }
            };
            tasksNode.setName("tasks");
            tasksNode.setDisplayName(Bundle.LBL_Tasks(ProjectUtils.getInformation((Project)updateP).getDisplayName()));
            tasksNode.setIconBaseWithExtension(GRADLE_ICON);
            AbstractNode favoritesNode = new AbstractNode((Children)new FavoritesChildren()){

                public Action[] getActions(boolean context) {
                    return new Action[0];
                }
            };
            favoritesNode.setName("favorites");
            favoritesNode.setDisplayName(Bundle.LBL_Favorites());
            favoritesNode.setIconBaseWithExtension(GRADLE_ICON);
            Children.Array rootKids = new Children.Array();
            rootKids.add(new Node[]{favoritesNode, tasksNode});
            SwingUtilities.invokeLater(() -> this.lambda$update$3((Children)rootKids));
            return;
        }
        SwingUtilities.invokeLater(() -> {
            this.treeView.setRootVisible(false);
            this.manager.setRootContext(TasksPanel.createEmptyNode());
        });
    }

    synchronized void release() {
        if (this.current != null) {
            this.current.removePropertyChangeListener(this.pchadapter);
        }
        this.current = null;
        this.currentP = null;
        SwingUtilities.invokeLater(() -> {
            this.treeView.setRootVisible(false);
            this.manager.setRootContext(TasksPanel.createEmptyNode());
        });
    }

    private static Node createEmptyNode() {
        return new AbstractNode(Children.LEAF);
    }

    private FavoriteTaskManager getFavoriteTaskManager() {
        Project p = this.currentP;
        return p != null ? (FavoriteTaskManager)p.getLookup().lookup(FavoriteTaskManager.class) : null;
    }

    private /* synthetic */ void lambda$update$3(Children rootKids) {
        this.treeView.setScrollsOnExpand(false);
        this.treeView.setRootVisible(false);
        this.manager.setRootContext((Node)new AbstractNode(rootKids));
        this.treeView.expandAll();
        this.treeView.setScrollsOnExpand(true);
    }

    private class TaskGroupNode
    extends AbstractNode {
        public TaskGroupNode(String group, GradleBaseProject project, Project genericProject) {
            super((Children)new TaskGroupChildren(group, project, genericProject), Lookup.EMPTY);
            this.setName(group);
            String displayName = "<private>".equals(group) ? Bundle.LBL_PrivateTasks() : Utils.capitalize(group);
            this.setDisplayName(displayName);
        }

        public Image getOpenedIcon(int type) {
            return this.getIcon(true);
        }

        public Image getIcon(int type) {
            return this.getIcon(false);
        }

        private Image getIcon(boolean opened) {
            return NodeUtils.getTreeFolderIcon(opened);
        }

        public Action[] getActions(boolean context) {
            return new Action[0];
        }
    }

    private class FavoritesChildren
    extends Children.Keys<GradleTask> {
        private final ChangeListener listener;

        public FavoritesChildren() {
            assert (TasksPanel.this.currentP != null);
            FavoriteTaskManager fvm = TasksPanel.this.getFavoriteTaskManager();
            this.listener = e -> {
                Set<GradleTask> favs = fvm.getFavoriteTasks();
                this.setKeys(favs);
            };
            fvm.addChangeListener(WeakListeners.change((ChangeListener)this.listener, (Object)fvm));
            this.setKeys(fvm.getFavoriteTasks());
        }

        protected Node[] createNodes(GradleTask key) {
            Node[] nodeArray;
            if (TasksPanel.this.currentP != null) {
                Node[] nodeArray2 = new Node[1];
                nodeArray = nodeArray2;
                nodeArray2[0] = new TaskNode(TasksPanel.this.currentP, key);
            } else {
                nodeArray = new Node[]{};
            }
            return nodeArray;
        }
    }

    private class TaskGroupChildren
    extends Children.Keys<GradleTask> {
        final Project genericProject;

        public TaskGroupChildren(String group, GradleBaseProject project, Project genericProject) {
            this.genericProject = genericProject;
            ArrayList<GradleTask> keys = new ArrayList<GradleTask>(project.getTasks(group));
            keys.sort(Comparator.comparing(GradleTask::getName, String.CASE_INSENSITIVE_ORDER));
            this.setKeys(keys);
        }

        protected Node[] createNodes(GradleTask key) {
            return new Node[]{new TaskNode(this.genericProject, key)};
        }
    }
}

