/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.customizer;

import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.EditorKit;
import org.netbeans.api.project.Project;
import org.netbeans.modules.gradle.actions.CustomActionRegistrationSupport;
import org.netbeans.modules.gradle.api.execute.ActionMapping;
import org.netbeans.modules.gradle.api.execute.GradleExecConfiguration;
import org.netbeans.modules.gradle.configurations.ConfigurationSnapshot;
import org.netbeans.modules.gradle.customizer.Bundle;
import org.netbeans.modules.gradle.customizer.CustomActionMapping;
import org.netbeans.modules.gradle.execute.ConfigurableActionProvider;
import org.netbeans.modules.gradle.spi.actions.ProjectActionMappingProvider;
import org.netbeans.spi.project.ActionProvider;
import org.openide.awt.Mnemonics;
import org.openide.text.CloneableEditorSupport;
import org.openide.util.NbBundle;

public class BuildActionsCustomizer
extends JPanel {
    public static final String GRADLE_PROJECT_PROPERTY = "gradle-project";
    private static final String CUSTOM_ACTION = Bundle.TXT_CUSTOM();
    private static final String CARD_NOSELECT = "empty";
    private static final String CARD_DETAILS = "details";
    private static final String CARD_DISABLED = "disabled";
    final Project project;
    final ConfigurationSnapshot configSnapshot;
    final DefaultComboBoxModel<GradleExecConfiguration> configModel = new DefaultComboBoxModel();
    final DefaultListModel<CustomActionMapping> customActionsModel = new DefaultListModel();
    final DefaultComboBoxModel<String> availableActionsModel = new DefaultComboBoxModel();
    final CustomActionRegistrationSupport actionRegistry;
    final DocumentListener applyListener = new DocumentListener(){

        @Override
        public void insertUpdate(DocumentEvent e) {
            BuildActionsCustomizer.this.apply();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            BuildActionsCustomizer.this.apply();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            BuildActionsCustomizer.this.apply();
        }
    };
    private volatile boolean autoApply;
    private boolean comboReady;
    private JButton btRemove;
    private JButton btnDisableAction;
    private JButton btnRemove2;
    private JButton btnRestore;
    private JComboBox<String> cbAdd;
    private JComboBox<GradleExecConfiguration> cbConfiguration;
    private JComboBox<String> cbReloadRule;
    private JCheckBox cbRepeatable;
    private JPanel disabledPanel;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JSeparator jSeparator1;
    private JLabel lbActions;
    private JLabel lbArgs;
    private JLabel lbConfiguration;
    private JLabel lbLabel;
    private JLabel lbName;
    private JLabel lbNoAction;
    private JLabel lbReloadHints;
    private JLabel lbReloadRule;
    private JLabel lbTitle;
    private JList<CustomActionMapping> lsActions;
    private JPanel pnDetails;
    private JPanel pnDetailsPanel;
    private JEditorPane taArgs;
    private JTextField tfLabel;
    private JTextField tfName;
    private static Map<String, ConfigData> actionConfigMap = new HashMap<String, ConfigData>();

    public BuildActionsCustomizer(Project project, ConfigurationSnapshot snapshot) {
        this.project = project;
        this.configSnapshot = snapshot;
        this.initComponents();
        this.actionRegistry = new CustomActionRegistrationSupport(project);
        this.lsActions.setCellRenderer(new MyListCellRenderer());
        this.tfLabel.getDocument().addDocumentListener(this.applyListener);
        EditorKit kit = CloneableEditorSupport.getEditorKit((String)"text/x-gradle-cli");
        this.taArgs.setEditorKit(kit);
        this.taArgs.getDocument().putProperty(GRADLE_PROJECT_PROPERTY, project);
        this.taArgs.getDocument().addDocumentListener(this.applyListener);
        this.initDefaultModels();
        this.comboReady = true;
        this.cbConfiguration.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component c = super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                if (!(value instanceof GradleExecConfiguration) || !(c instanceof JLabel)) {
                    return c;
                }
                JLabel l = (JLabel)c;
                GradleExecConfiguration conf = (GradleExecConfiguration)value;
                l.setText(conf.getDisplayName());
                if (conf.equals(BuildActionsCustomizer.this.configSnapshot.getActiveConfiguration())) {
                    l.setFont(l.getFont().deriveFont(1));
                }
                return c;
            }
        });
        this.cbConfiguration.setModel(this.configModel);
        this.cbConfiguration.addActionListener(this::configurationChanged);
        this.btRemove.setEnabled(this.getSelectedMapping() != null);
    }

    private void configurationChanged(ActionEvent e) {
        if (!this.comboReady) {
            return;
        }
        GradleExecConfiguration cfg = (GradleExecConfiguration)this.cbConfiguration.getSelectedItem();
        if (cfg == null) {
            this.cbConfiguration.setSelectedItem(this.configSnapshot.getActiveConfiguration());
            return;
        }
        this.actionRegistry.setActiveConfiguration(cfg);
        this.initDefaultModels();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initDefaultModels() {
        boolean saved = this.comboReady;
        try {
            this.comboReady = false;
            ActionProvider actionProvider = (ActionProvider)this.project.getLookup().lookup(ActionProvider.class);
            TreeSet<String> allAvailableActions = new TreeSet<String>(Arrays.asList(actionProvider.getSupportedActions()));
            this.customActionsModel.removeAllElements();
            this.actionRegistry.getCustomActions().forEach(mapping -> this.customActionsModel.addElement((CustomActionMapping)mapping));
            this.availableActionsModel.removeAllElements();
            this.availableActionsModel.addElement(CUSTOM_ACTION);
            for (String action : allAvailableActions) {
                if (this.actionRegistry.getCustomAction(action) != null) continue;
                this.availableActionsModel.addElement(action);
            }
        }
        finally {
            this.comboReady = saved;
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.updateConfigurations();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateConfigurations() {
        boolean saved = this.comboReady;
        GradleExecConfiguration toSelect = null;
        try {
            this.comboReady = false;
            GradleExecConfiguration cur = (GradleExecConfiguration)this.configModel.getSelectedItem();
            GradleExecConfiguration act = this.configSnapshot.getActiveConfiguration();
            this.configModel.removeAllElements();
            for (GradleExecConfiguration c : this.configSnapshot.getConfigurations()) {
                this.configModel.addElement(c);
                if (cur != null) {
                    if (!c.equals(cur)) continue;
                    toSelect = c;
                    continue;
                }
                if (!c.equals(act)) continue;
                toSelect = act;
            }
        }
        finally {
            this.comboReady = saved;
        }
        if (toSelect == null) {
            toSelect = this.configSnapshot.getActiveConfiguration();
        }
        this.configModel.setSelectedItem(toSelect);
    }

    private void initComponents() {
        this.lbTitle = new JLabel();
        this.lbConfiguration = new JLabel();
        this.cbConfiguration = new JComboBox();
        this.jSeparator1 = new JSeparator();
        this.lbActions = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.lsActions = new JList();
        this.jLabel1 = new JLabel();
        this.cbAdd = new JComboBox();
        this.pnDetailsPanel = new JPanel();
        this.pnDetails = new JPanel();
        this.lbName = new JLabel();
        this.lbLabel = new JLabel();
        this.tfName = new JTextField();
        this.tfLabel = new JTextField();
        this.lbArgs = new JLabel();
        this.btRemove = new JButton();
        this.lbReloadRule = new JLabel();
        this.cbReloadRule = new JComboBox();
        this.cbRepeatable = new JCheckBox();
        this.jScrollPane3 = new JScrollPane();
        this.taArgs = new JEditorPane();
        this.lbReloadHints = new JLabel();
        this.btnDisableAction = new JButton();
        this.lbNoAction = new JLabel();
        this.disabledPanel = new JPanel();
        this.jLabel2 = new JLabel();
        this.btnRestore = new JButton();
        this.btnRemove2 = new JButton();
        Mnemonics.setLocalizedText((JLabel)this.lbTitle, (String)NbBundle.getMessage(BuildActionsCustomizer.class, (String)"BuildActionsCustomizer.lbTitle.text"));
        Mnemonics.setLocalizedText((JLabel)this.lbConfiguration, (String)NbBundle.getMessage(BuildActionsCustomizer.class, (String)"BuildActionsCustomizer.lbConfiguration.text"));
        Mnemonics.setLocalizedText((JLabel)this.lbActions, (String)NbBundle.getMessage(BuildActionsCustomizer.class, (String)"BuildActionsCustomizer.lbActions.text"));
        this.lsActions.setModel(this.customActionsModel);
        this.lsActions.setSelectionMode(0);
        this.lsActions.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                BuildActionsCustomizer.this.lsActionsValueChanged(evt);
            }
        });
        this.jScrollPane2.setViewportView(this.lsActions);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(BuildActionsCustomizer.class, (String)"BuildActionsCustomizer.jLabel1.text"));
        this.cbAdd.setModel(this.availableActionsModel);
        this.cbAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BuildActionsCustomizer.this.cbAddActionPerformed(evt);
            }
        });
        this.pnDetailsPanel.setLayout(new CardLayout());
        this.pnDetails.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        Mnemonics.setLocalizedText((JLabel)this.lbName, (String)NbBundle.getMessage(BuildActionsCustomizer.class, (String)"BuildActionsCustomizer.lbName.text"));
        Mnemonics.setLocalizedText((JLabel)this.lbLabel, (String)NbBundle.getMessage(BuildActionsCustomizer.class, (String)"BuildActionsCustomizer.lbLabel.text"));
        this.tfName.setEditable(false);
        this.tfName.setEnabled(false);
        this.tfLabel.setEnabled(false);
        Mnemonics.setLocalizedText((JLabel)this.lbArgs, (String)NbBundle.getMessage(BuildActionsCustomizer.class, (String)"BuildActionsCustomizer.lbArgs.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.btRemove, (String)NbBundle.getMessage(BuildActionsCustomizer.class, (String)"BuildActionsCustomizer.btRemove.text"));
        this.btRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BuildActionsCustomizer.this.btRemoveActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.lbReloadRule, (String)NbBundle.getMessage(BuildActionsCustomizer.class, (String)"BuildActionsCustomizer.lbReloadRule.text"));
        this.cbReloadRule.setModel(new DefaultComboBoxModel<String>(new String[]{"NEVER", "DEFAULT", "ALWAYS", "ALWAYS_ONLINE"}));
        this.cbReloadRule.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                BuildActionsCustomizer.this.cbReloadRuleItemStateChanged(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.cbRepeatable, (String)NbBundle.getMessage(BuildActionsCustomizer.class, (String)"BuildActionsCustomizer.cbRepeatable.text"));
        this.cbRepeatable.setToolTipText(NbBundle.getMessage(BuildActionsCustomizer.class, (String)"BuildActionsCustomizer.cbRepeatable.toolTipText"));
        this.cbRepeatable.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                BuildActionsCustomizer.this.cbRepeatableStateChanged(evt);
            }
        });
        this.taArgs.setContentType("text/x-gradle-cli");
        this.jScrollPane3.setViewportView(this.taArgs);
        this.lbReloadHints.setFont(new Font("Dialog", 0, 12));
        this.lbReloadHints.setHorizontalAlignment(2);
        Mnemonics.setLocalizedText((JLabel)this.lbReloadHints, (String)NbBundle.getMessage(BuildActionsCustomizer.class, (String)"BuildActionsCustomizer.lbReloadHints.text"));
        this.lbReloadHints.setVerticalAlignment(1);
        this.lbReloadHints.setEnabled(false);
        Mnemonics.setLocalizedText((AbstractButton)this.btnDisableAction, (String)NbBundle.getMessage(BuildActionsCustomizer.class, (String)"BuildActionsCustomizer.btnDisableAction.text"));
        this.btnDisableAction.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BuildActionsCustomizer.this.btnDisableActionActionPerformed(evt);
            }
        });
        GroupLayout pnDetailsLayout = new GroupLayout(this.pnDetails);
        this.pnDetails.setLayout(pnDetailsLayout);
        pnDetailsLayout.setHorizontalGroup(pnDetailsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnDetailsLayout.createSequentialGroup().addGroup(pnDetailsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, pnDetailsLayout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.btnDisableAction).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btRemove)).addGroup(pnDetailsLayout.createSequentialGroup().addContainerGap().addGroup(pnDetailsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnDetailsLayout.createSequentialGroup().addGroup(pnDetailsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lbName).addComponent(this.lbLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pnDetailsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.tfLabel).addComponent(this.tfName))).addGroup(pnDetailsLayout.createSequentialGroup().addComponent(this.lbReloadRule).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.cbReloadRule, -2, 138, -2).addGap(18, 18, 18).addComponent(this.cbRepeatable, -1, 150, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, pnDetailsLayout.createSequentialGroup().addGap(6, 6, 6).addComponent(this.jScrollPane3)).addGroup(pnDetailsLayout.createSequentialGroup().addComponent(this.lbArgs).addGap(0, 0, Short.MAX_VALUE)))).addComponent(this.lbReloadHints, GroupLayout.Alignment.TRAILING, -2, 0, Short.MAX_VALUE)).addContainerGap()));
        pnDetailsLayout.setVerticalGroup(pnDetailsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnDetailsLayout.createSequentialGroup().addContainerGap().addGroup(pnDetailsLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lbName).addComponent(this.tfName, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pnDetailsLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lbLabel).addComponent(this.tfLabel, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.lbArgs).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane3, -2, 78, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(pnDetailsLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lbReloadRule).addComponent(this.cbReloadRule, -2, -1, -2).addComponent(this.cbRepeatable)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lbReloadHints, -2, 122, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(pnDetailsLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btRemove).addComponent(this.btnDisableAction)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pnDetailsPanel.add((Component)this.pnDetails, CARD_DETAILS);
        this.lbNoAction.setHorizontalAlignment(0);
        Mnemonics.setLocalizedText((JLabel)this.lbNoAction, (String)NbBundle.getMessage(BuildActionsCustomizer.class, (String)"BuildActionsCustomizer.lbNoAction.text"));
        this.pnDetailsPanel.add((Component)this.lbNoAction, CARD_NOSELECT);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(BuildActionsCustomizer.class, (String)"BuildActionsCustomizer.jLabel2.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.btnRestore, (String)NbBundle.getMessage(BuildActionsCustomizer.class, (String)"BuildActionsCustomizer.btnRestore.text"));
        this.btnRestore.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BuildActionsCustomizer.this.btnRestoreActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.btnRemove2, (String)NbBundle.getMessage(BuildActionsCustomizer.class, (String)"BuildActionsCustomizer.btnRemove2.text"));
        this.btnRemove2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BuildActionsCustomizer.this.btnRemove2ActionPerformed(evt);
            }
        });
        GroupLayout disabledPanelLayout = new GroupLayout(this.disabledPanel);
        this.disabledPanel.setLayout(disabledPanelLayout);
        disabledPanelLayout.setHorizontalGroup(disabledPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(disabledPanelLayout.createSequentialGroup().addContainerGap().addGroup(disabledPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(disabledPanelLayout.createSequentialGroup().addComponent(this.jLabel2).addGap(0, 121, Short.MAX_VALUE)).addGroup(disabledPanelLayout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.btnRestore).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnRemove2))).addContainerGap()));
        disabledPanelLayout.setVerticalGroup(disabledPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(disabledPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(disabledPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.btnRemove2).addComponent(this.btnRestore)).addContainerGap(321, Short.MAX_VALUE)));
        this.pnDetailsPanel.add((Component)this.disabledPanel, CARD_DISABLED);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSeparator1).addComponent(this.lbTitle, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane2, -2, 170, -2).addComponent(this.lbActions)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.pnDetailsPanel, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1, -2, 125, -2).addGap(18, 18, 18).addComponent(this.cbAdd, 0, -1, Short.MAX_VALUE)))).addGroup(layout.createSequentialGroup().addComponent(this.lbConfiguration).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.cbConfiguration, 0, -1, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(8, 8, 8).addComponent(this.lbTitle).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lbConfiguration, -2, 21, -2).addComponent(this.cbConfiguration, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jSeparator1, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lbActions).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cbAdd, -2, -1, -2).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pnDetailsPanel, -2, 0, Short.MAX_VALUE)).addComponent(this.jScrollPane2, -1, 414, Short.MAX_VALUE)).addContainerGap()));
    }

    private void lsActionsValueChanged(ListSelectionEvent evt) {
        CardLayout cardLayout = (CardLayout)this.pnDetailsPanel.getLayout();
        CustomActionMapping mapping = this.getSelectedMapping();
        this.autoApply = false;
        if (mapping != null) {
            if (ActionMapping.isDisabled(mapping)) {
                cardLayout.show(this.pnDetailsPanel, CARD_DISABLED);
            } else {
                cardLayout.show(this.pnDetailsPanel, CARD_DETAILS);
                this.updateActionProperties(mapping);
            }
        } else {
            cardLayout.show(this.pnDetailsPanel, CARD_NOSELECT);
        }
    }

    private void updateActionProperties(ActionMapping mapping) {
        this.tfName.setText(mapping.getName());
        this.tfLabel.setText(mapping.getDisplayName());
        this.tfLabel.setEnabled(mapping.getName().startsWith("custom-"));
        this.taArgs.setText(mapping.getArgs());
        this.cbReloadRule.setSelectedItem(mapping.getReloadRule().name());
        this.cbRepeatable.setSelected(mapping.isRepeatable());
        this.autoApply = true;
        GradleExecConfiguration cfg = (GradleExecConfiguration)this.cbConfiguration.getSelectedItem();
        this.btnDisableAction.setEnabled(!cfg.isDefault());
        this.btRemove.setEnabled(this.getSelectedMapping() != null);
    }

    private void btRemoveActionPerformed(ActionEvent evt) {
        CustomActionMapping mapping = this.getSelectedMapping();
        this.customActionsModel.removeElement(mapping);
        this.actionRegistry.unregisterCustomAction(mapping.getName());
        String action = mapping.getName();
        if (!action.startsWith("custom-")) {
            ArrayList<String> items = new ArrayList<String>();
            for (int i = 1; i < this.availableActionsModel.getSize(); ++i) {
                items.add(this.availableActionsModel.getElementAt(i));
            }
            items.add(action);
            Collections.sort(items);
            int idx = items.indexOf(action);
            this.availableActionsModel.insertElementAt(action, idx + 1);
        }
    }

    private void apply() {
        if (this.autoApply) {
            CustomActionMapping mapping = this.getSelectedMapping();
            if (mapping.getName().startsWith("custom-")) {
                mapping.setDisplayName(this.tfLabel.getText());
            }
            mapping.setArgs(this.taArgs.getText());
            mapping.setReloadRule(ActionMapping.ReloadRule.valueOf(this.cbReloadRule.getSelectedItem().toString()));
            mapping.setRepeatable(this.cbRepeatable.isSelected());
            this.actionRegistry.registerCustomAction(mapping);
            this.lsActions.repaint();
        }
    }

    private void cbRepeatableStateChanged(ChangeEvent evt) {
        this.apply();
    }

    private void cbReloadRuleItemStateChanged(ItemEvent evt) {
        this.apply();
    }

    private void cbAddActionPerformed(ActionEvent evt) {
        if (!this.comboReady) {
            return;
        }
        String action = this.availableActionsModel.getElementAt(this.cbAdd.getSelectedIndex());
        if (action != CUSTOM_ACTION) {
            this.availableActionsModel.removeElement(action);
        } else {
            action = this.actionRegistry.findNewCustonActionId();
        }
        GradleExecConfiguration cfg = (GradleExecConfiguration)this.cbConfiguration.getSelectedItem();
        String cfgId = cfg != null ? cfg.getId() : "%%DEFAULT%%";
        ProjectActionMappingProvider mappingProvider = ((ConfigurableActionProvider)this.project.getLookup().lookup(ConfigurableActionProvider.class)).findActionProvider(cfgId);
        ActionMapping defaultMapping = mappingProvider.findMapping(action);
        if (defaultMapping == null) {
            defaultMapping = ((ProjectActionMappingProvider)this.project.getLookup().lookup(ProjectActionMappingProvider.class)).findMapping(action);
        }
        CustomActionMapping mapping = defaultMapping != null ? new CustomActionMapping(defaultMapping, action) : new CustomActionMapping(action);
        this.customActionsModel.addElement(mapping);
        this.actionRegistry.registerCustomAction(mapping);
        this.lsActions.setSelectedIndex(this.customActionsModel.indexOf(mapping));
        this.cbAdd.setSelectedIndex(0);
    }

    private ActionMapping findBuiltinConfiguration(String actionId) {
        ActionMapping m;
        GradleExecConfiguration cfg = this.configSnapshot.getActiveConfiguration();
        ConfigurableActionProvider cap = (ConfigurableActionProvider)this.project.getLookup().lookup(ConfigurableActionProvider.class);
        if (!cfg.isDefault() && !ActionMapping.isDisabled(m = cap.findDefaultMapping(cfg.getId(), actionId))) {
            return m;
        }
        return cap.findDefaultMapping("%%DEFAULT%%", actionId);
    }

    private void btnRestoreActionPerformed(ActionEvent evt) {
        CustomActionMapping mapping = this.getSelectedMapping();
        ActionMapping original = this.findBuiltinConfiguration(mapping.getName());
        if (original != null) {
            int index = this.customActionsModel.indexOf(mapping = new CustomActionMapping(original, mapping.getName()));
            if (index == -1) {
                return;
            }
            this.customActionsModel.removeElement(mapping);
            this.actionRegistry.unregisterCustomAction(mapping.getName());
            this.customActionsModel.add(index, mapping);
            this.actionRegistry.registerCustomAction(mapping);
            this.lsActions.setSelectedIndex(index);
        } else {
            String action = mapping.getName();
            if (!action.startsWith("custom-")) {
                this.availableActionsModel.addElement(action);
            }
        }
    }

    private void btnDisableActionActionPerformed(ActionEvent evt) {
        CustomActionMapping mapping = this.getSelectedMapping();
        if (ActionMapping.isDisabled(mapping)) {
            return;
        }
        mapping.setArgs(null);
        mapping.setReloadRule(ActionMapping.ReloadRule.NEVER);
        this.actionRegistry.registerCustomAction(mapping);
        CardLayout cardLayout = (CardLayout)this.pnDetailsPanel.getLayout();
        cardLayout.show(this.pnDetailsPanel, CARD_DISABLED);
    }

    private void btnRemove2ActionPerformed(ActionEvent evt) {
        this.btRemoveActionPerformed(evt);
    }

    private CustomActionMapping getSelectedMapping() {
        int index = this.lsActions.getSelectedIndex();
        return index >= 0 ? this.customActionsModel.elementAt(index) : null;
    }

    void save() {
        this.actionRegistry.saveAndReportErrors();
    }

    static class MyListCellRenderer
    extends DefaultListCellRenderer {
        MyListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel label = (JLabel)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            if (value instanceof CustomActionMapping) {
                CustomActionMapping mapping = (CustomActionMapping)value;
                Object displayName = mapping.getDisplayName();
                if (mapping.getArgs().contains("${input:")) {
                    displayName = (String)displayName + "...";
                }
                label.setText((String)(mapping.isChanged() ? "<html><b>" + (String)displayName + "</b>" : displayName));
            }
            return label;
        }
    }

    static class ConfigData {
        final DefaultListModel<CustomActionMapping> customActionsModel = new DefaultListModel();
        final DefaultComboBoxModel<String> availableActionsModel = new DefaultComboBoxModel();

        ConfigData() {
        }
    }
}

