/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.configurations;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.netbeans.api.project.Project;
import org.netbeans.modules.gradle.api.execute.GradleExecConfiguration;
import org.netbeans.modules.gradle.execute.GradleExecAccessor;
import org.netbeans.modules.gradle.execute.ProjectConfigurationSupport;
import org.netbeans.modules.gradle.execute.ProjectConfigurationUpdater;
import org.openide.util.Lookup;

public class ConfigurationSnapshot {
    private static final String USER_PREFIX = "user-";
    private final ProjectConfigurationUpdater updater;
    private Set<String> fixedIds = Collections.emptySet();
    private List<GradleExecConfiguration> configurations = Collections.emptyList();
    private Set<String> changedConfigs = Collections.emptySet();
    private Set<String> sharedConfigs = Collections.emptySet();
    private boolean defaultIsOverriden;
    private boolean modified;
    private Set<GradleExecConfiguration> fixedOverrides = Collections.emptySet();
    private GradleExecConfiguration activeConfiguration;
    private static final Map<Lookup, ConfigurationSnapshot> projectSnapshots = new HashMap<Lookup, ConfigurationSnapshot>();

    public ConfigurationSnapshot(ProjectConfigurationUpdater updater) {
        this.updater = updater;
        this.reload();
    }

    public GradleExecConfiguration getActiveConfiguration() {
        return this.activeConfiguration;
    }

    public void setActiveConfiguration(GradleExecConfiguration ac) {
        for (GradleExecConfiguration c : this.configurations) {
            if ((!c.isDefault() || ac != null) && !c.equals(ac)) continue;
            this.activeConfiguration = c;
            return;
        }
    }

    public boolean isOverriden(GradleExecConfiguration cfg) {
        return this.fixedOverrides.contains(cfg);
    }

    private void reload() {
        Collection<GradleExecConfiguration> shared = this.updater.getSharedConfigurations();
        Collection<GradleExecConfiguration> nonshared = this.updater.getPrivateConfigurations();
        this.changedConfigs = new HashSet<String>();
        this.sharedConfigs = new HashSet<String>();
        this.fixedIds = this.updater.getFixedConfigurations().stream().map(GradleExecConfiguration::getId).collect(Collectors.toSet());
        GradleExecConfiguration defConfig = null;
        this.configurations = new ArrayList<GradleExecConfiguration>();
        for (GradleExecConfiguration gradleExecConfiguration : this.updater.getConfigurations()) {
            this.configurations.add(GradleExecAccessor.instance().copy(gradleExecConfiguration));
            if (gradleExecConfiguration.isDefault()) {
                defConfig = gradleExecConfiguration;
            }
            if (!shared.contains(gradleExecConfiguration) && !gradleExecConfiguration.isDefault()) continue;
            this.sharedConfigs.add(gradleExecConfiguration.getId());
        }
        this.fixedOverrides = new HashSet<GradleExecConfiguration>();
        this.fixedOverrides.addAll(shared);
        this.fixedOverrides.addAll(nonshared);
        this.fixedOverrides.retainAll(this.updater.getFixedConfigurations());
        this.defaultIsOverriden = shared.contains(defConfig) || nonshared.contains(defConfig);
        this.modified = false;
        this.setActiveConfiguration(this.activeConfiguration);
    }

    public boolean isModified() {
        return this.modified;
    }

    public List<GradleExecConfiguration> getConfigurations() {
        return this.configurations;
    }

    public GradleExecConfiguration createNew(String id) {
        int maxId = -1;
        for (GradleExecConfiguration c : this.configurations) {
            if (c.getId().equalsIgnoreCase(id)) {
                throw new IllegalArgumentException();
            }
            if (!c.getId().startsWith(USER_PREFIX)) continue;
            try {
                maxId = Math.max(maxId, Integer.parseInt(c.getId().substring(USER_PREFIX.length())));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        maxId = maxId < 1 ? 1 : ++maxId;
        return GradleExecAccessor.instance().create((String)(id != null ? id : USER_PREFIX + maxId), null, null, null);
    }

    public void add(GradleExecConfiguration c) {
        for (GradleExecConfiguration e : this.configurations) {
            if (!e.getId().equals(c.getId())) continue;
            throw new IllegalArgumentException("ID exists");
        }
        this.configurations.add(c);
        this.changedConfigs.add(c.getId());
        this.modified = true;
    }

    public boolean isFixed(GradleExecConfiguration c) {
        return this.fixedIds.contains(c.getId());
    }

    public void removeConfiguration(GradleExecConfiguration c) {
        if (this.configurations.remove(c)) {
            this.changedConfigs.remove(c.getId());
            this.sharedConfigs.remove(c.getId());
            this.modified = true;
        }
    }

    public void setShared(GradleExecConfiguration c, boolean shared) {
        if (this.isShared(c) == shared) {
            return;
        }
        if (shared) {
            this.sharedConfigs.add(c.getId());
        } else {
            this.sharedConfigs.remove(c.getId());
        }
        this.changedConfigs.add(c.getId());
        this.modified = true;
    }

    public boolean isShared(GradleExecConfiguration c) {
        return this.sharedConfigs.contains(c.getId());
    }

    public boolean updateConfiguration(GradleExecConfiguration c, String dispName, Map<String, String> properties, String args) {
        boolean ch;
        boolean bl = ch = !Objects.equals(dispName, c.getName()) || !Objects.equals(properties, c.getProjectProperties()) || !Objects.equals(args, c.getCommandLineArgs());
        if (ch) {
            GradleExecAccessor.instance().update(c, dispName, properties, args);
            this.changedConfigs.add(c.getId());
            this.modified = true;
        }
        return ch;
    }

    public static ConfigurationSnapshot createSnapshot(ProjectConfigurationUpdater updater) {
        ConfigurationSnapshot sn = new ConfigurationSnapshot(updater);
        return sn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConfigurationSnapshot forProject(Lookup context, Project project, Consumer<Runnable> unregisterHook) {
        ConfigurationSnapshot snap;
        Map<Lookup, ConfigurationSnapshot> map = projectSnapshots;
        synchronized (map) {
            snap = projectSnapshots.get(context);
            if (snap != null) {
                return snap;
            }
            GradleExecConfiguration active = ProjectConfigurationSupport.getEffectiveConfiguration(project, context);
            ProjectConfigurationUpdater upd = (ProjectConfigurationUpdater)project.getLookup().lookup(ProjectConfigurationUpdater.class);
            snap = ConfigurationSnapshot.createSnapshot(upd);
            snap.setActiveConfiguration(active);
            projectSnapshots.put(context, snap);
        }
        unregisterHook.accept(() -> ConfigurationSnapshot.removeSnapshot(context));
        return snap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeSnapshot(Lookup context) {
        Map<Lookup, ConfigurationSnapshot> map = projectSnapshots;
        synchronized (map) {
            projectSnapshots.remove(context);
        }
    }

    public void save() throws IOException {
        if (!this.isModified()) {
            return;
        }
        ArrayList<GradleExecConfiguration> sharedConfigsToSave = new ArrayList<GradleExecConfiguration>();
        ArrayList<GradleExecConfiguration> privateConfigsToSave = new ArrayList<GradleExecConfiguration>();
        for (GradleExecConfiguration cfg : this.configurations) {
            boolean shouldOverride;
            if (this.fixedIds.contains(cfg.getId()) && !(shouldOverride = this.fixedOverrides.contains(cfg) || this.changedConfigs.contains(cfg.getId()))) continue;
            if (this.isShared(cfg)) {
                sharedConfigsToSave.add(cfg);
                continue;
            }
            privateConfigsToSave.add(cfg);
        }
        this.updater.setConfigurations(sharedConfigsToSave, privateConfigsToSave);
        this.reload();
    }

    public GradleExecConfiguration revert(GradleExecConfiguration cfg) {
        if (!this.isOverriden(cfg)) {
            return cfg;
        }
        int idx = this.configurations.indexOf(cfg);
        if (idx == -1) {
            return cfg;
        }
        GradleExecConfiguration found = null;
        for (GradleExecConfiguration orig : this.updater.getFixedConfigurations()) {
            if (!orig.getId().equals(cfg.getId())) continue;
            found = orig;
            break;
        }
        if (found == null) {
            return cfg;
        }
        this.changedConfigs.remove(cfg.getId());
        this.sharedConfigs.remove(cfg.getId());
        this.fixedOverrides.remove(cfg);
        GradleExecConfiguration copyOfOrig = GradleExecAccessor.instance().copy(found);
        this.configurations.set(idx, copyOfOrig);
        this.modified = true;
        return copyOfOrig;
    }
}

