/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.fish.payara.jakarta.transformer;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.apache.maven.artifact.versioning.ComparableVersion;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.fish.payara.jakarta.transformer.TransformerWizardPanel;
import org.netbeans.modules.maven.api.archetype.Archetype;
import org.netbeans.modules.maven.api.execute.RunConfig;
import org.netbeans.modules.maven.api.execute.RunUtils;
import org.netbeans.modules.maven.execute.ModelRunConfig;
import org.netbeans.modules.maven.execute.model.NetbeansActionMapping;
import org.netbeans.modules.maven.indexer.api.NBVersionInfo;
import org.netbeans.modules.maven.indexer.api.RepositoryQueries;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.execution.ExecutorTask;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public final class TransformerWizardIterator
implements WizardDescriptor.BackgroundInstantiatingIterator<WizardDescriptor> {
    private int index;
    private WizardDescriptor.Panel<WizardDescriptor>[] panels;
    private WizardDescriptor wizardDescriptor;
    static final Archetype TRANSFORMER_ARCHETYPE = new Archetype();

    public static TransformerWizardIterator createWebAppIterator() {
        return new TransformerWizardIterator();
    }

    private WizardDescriptor.Panel<WizardDescriptor>[] createPanels() {
        return new WizardDescriptor.Panel[]{new TransformerWizardPanel()};
    }

    private String[] createSteps() {
        return new String[]{NbBundle.getMessage(TransformerWizardIterator.class, (String)"LBL_CreateProjectStep")};
    }

    public Set<FileObject> instantiate() throws IOException {
        LinkedHashSet<FileObject> resultSet = new LinkedHashSet<FileObject>();
        String target = (String)this.wizardDescriptor.getProperty("targetSelected");
        String source = (String)this.wizardDescriptor.getProperty("sourceSelected");
        boolean override = (Boolean)this.wizardDescriptor.getProperty("override");
        NotifyDescriptor.Message notifyDescriptorTarget = new NotifyDescriptor.Message((Object)"The selected target folder is not valid, please try again with a valid folder.", 0);
        NotifyDescriptor.Message notifyDescriptorSource = new NotifyDescriptor.Message((Object)"The selected source is not valid, please try again with a valid source folder or file.", 0);
        if (target != null && !target.isEmpty() && source != null && !source.isEmpty()) {
            File targetFile = new File(target);
            File sourceFile = new File(source);
            if (!sourceFile.exists()) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)notifyDescriptorSource);
            }
            if (sourceFile.exists() && sourceFile.isDirectory() && targetFile.isDirectory()) {
                return this.transformFolderToNewDirectory(resultSet, target, source);
            }
            if (sourceFile.exists() && sourceFile.isDirectory() && !targetFile.exists()) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)notifyDescriptorTarget);
            }
            if (sourceFile.exists() && sourceFile.isFile() && targetFile.isDirectory()) {
                this.transformFileToNewDirectory(target, source);
            } else if (sourceFile.exists() && sourceFile.isFile() && !targetFile.exists()) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)notifyDescriptorTarget);
            }
        }
        if (source != null && override) {
            File sourceFile = new File(source);
            if (!sourceFile.exists()) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)notifyDescriptorSource);
            }
            if (sourceFile.exists() && sourceFile.isDirectory()) {
                return this.transformFolderOnSameLocation(resultSet, source);
            }
            if (sourceFile.exists() && sourceFile.isFile()) {
                this.transformFileOnSameLocation(source);
            }
        }
        return Collections.emptySet();
    }

    public void transformFileOnSameLocation(String source) throws IOException {
        Project project;
        ExecutorTask task;
        FileObject p;
        File fileSource = new File(source);
        File parentDirectory = new File(fileSource.getParent());
        String pomFilePath = parentDirectory.getAbsolutePath() + File.separator + "pom.xml";
        File pomFile = new File(pomFilePath);
        if (parentDirectory.exists() && parentDirectory.isDirectory()) {
            FileObject directoryObject = FileUtil.toFileObject((File)parentDirectory);
            if (!pomFile.exists()) {
                this.copyTempPomFile(directoryObject);
            }
        }
        if ((p = FileUtil.toFileObject((File)parentDirectory)) != null && (task = this.callMavenProcess(source, source, project = ProjectManager.getDefault().findProject(p))) != null) {
            task.waitFinished();
            if (pomFile.exists()) {
                pomFile.delete();
            }
        }
    }

    public Set<FileObject> transformFolderOnSameLocation(Set<FileObject> resultSet, String source) throws IOException {
        Project project;
        ExecutorTask task;
        File directory = new File(source);
        String pomFilePath = directory.getAbsolutePath() + File.separator + "pom.xml";
        File pomFile = new File(pomFilePath);
        FileObject directoryObject = FileUtil.toFileObject((File)directory);
        resultSet.add(directoryObject);
        ProjectChooser.setProjectsFolder((File)directory);
        if (!pomFile.exists()) {
            this.copyTempPomFile(directoryObject);
        }
        if (directoryObject != null && (task = this.callMavenProcess(source, source, project = ProjectManager.getDefault().findProject(directoryObject))) != null) {
            task.waitFinished();
        }
        this.showJakartaAdviseDialog();
        return resultSet;
    }

    public void transformFileToNewDirectory(String targetFolder, String sourceFolder) throws IOException {
        File directoryFile = this.createTargetDirectory(targetFolder);
        FileObject directoryObject = FileUtil.toFileObject((File)directoryFile);
        String pomFilePath = directoryFile.getAbsolutePath() + File.separator + "pom.xml";
        File pomFile = new File(pomFilePath);
        this.copyTempPomFile(directoryObject);
        File sourceFile = new File(sourceFolder);
        FileObject sourceToMove = FileUtil.toFileObject((File)sourceFile);
        String name = sourceFile.getName();
        if (name.contains(".")) {
            String[] parts = name.split("\\.");
            name = parts[0];
        }
        FileUtil.copyFile((FileObject)sourceToMove, (FileObject)directoryObject, (String)name);
        FileObject p = FileUtil.toFileObject((File)directoryFile);
        if (p != null) {
            Project project = ProjectManager.getDefault().findProject(p);
            String directoryName = directoryFile.getPath() + File.separator + sourceFile.getName();
            ExecutorTask task = this.callMavenProcess(directoryName, directoryName, project);
            if (task != null) {
                task.waitFinished();
                if (pomFile.exists()) {
                    pomFile.delete();
                }
            }
        }
    }

    public Set<FileObject> transformFolderToNewDirectory(Set<FileObject> resultSet, String targetFolder, String sourceFolder) throws IOException {
        File directoryFile = this.createTargetDirectory(targetFolder);
        File tempDirectory = this.createTempDirectory(targetFolder);
        FileObject directoryObject = FileUtil.toFileObject((File)directoryFile);
        FileObject tempObject = FileUtil.toFileObject((File)tempDirectory);
        this.copyTempPomFile(tempObject);
        resultSet.add(directoryObject);
        File parent = directoryFile.getParentFile();
        if (parent != null && parent.exists()) {
            ProjectChooser.setProjectsFolder((File)parent);
        }
        String pomFilePath = tempDirectory.getAbsolutePath() + File.separator + "pom.xml";
        File pomFile = new File(pomFilePath);
        FileObject p = FileUtil.toFileObject((File)tempDirectory);
        if (p != null) {
            Project project = ProjectManager.getDefault().findProject(p);
            ExecutorTask task = this.callMavenProcess(sourceFolder, directoryFile.getPath(), project);
            if (task != null) {
                task.waitFinished();
                if (pomFile.exists()) {
                    pomFile.delete();
                }
                if (tempDirectory.exists()) {
                    tempDirectory.delete();
                }
            }
        }
        this.showJakartaAdviseDialog();
        return resultSet;
    }

    public ExecutorTask callMavenProcess(String source, String target, Project project) {
        NetbeansActionMapping mapping = new NetbeansActionMapping();
        ArrayList<String> goals = new ArrayList<String>();
        goals.add(this.getLastTransformerVersionOfPlugin(TRANSFORMER_ARCHETYPE));
        mapping.setGoals(goals);
        mapping.setActionName("Transform source");
        mapping.addProperty("selectedSource", source);
        mapping.addProperty("selectedTarget", target);
        ModelRunConfig rc = new ModelRunConfig(project, mapping, mapping.getActionName(), null, Lookup.EMPTY, false);
        return RunUtils.run((RunConfig)rc);
    }

    public void showJakartaAdviseDialog() {
        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)"After transforming application you should need to apply pom configuration files manually. The suggested dependencies for Jakarta EE 10 are:\n\n <dependency>\n \t \t <groupId>jakarta.platform</groupId>\n \t \t <artifactId>jakarta.jakartaee-api</artifactId>\n \t \t <version>10.0.0</version>\n \t \t <scope>provided</scope>\n</dependency> \n\n or \n\n <dependency>\n \t \t <groupId>jakarta.platform</groupId>\n \t \t <artifactId>jakarta.jakartaee-web-api</artifactId>\n \t \t <version>10.0.0</version>\n \t \t <scope>provided</scope>\n </dependency>"));
    }

    public void copyTempPomFile(FileObject directoryObject) throws IOException {
        try (InputStream s = TransformerWizardIterator.class.getResourceAsStream("pom.txt");){
            FileObject fo = FileUtil.createData((FileObject)directoryObject, (String)"pom.xml");
            TransformerWizardIterator.writeFile(s, fo);
        }
    }

    public File createTargetDirectory(String targetFolder) {
        File fileTargetFolder = new File(targetFolder + File.separator + "jakartaee-transformed-sample");
        File directoryFile = FileUtil.normalizeFile((File)fileTargetFolder);
        directoryFile.mkdirs();
        return directoryFile;
    }

    public File createTempDirectory(String targetFolder) {
        File fileTargetFolder = new File(targetFolder + File.separator + "temp");
        File tempFile = FileUtil.normalizeFile((File)fileTargetFolder);
        tempFile.mkdirs();
        return tempFile;
    }

    private String getLastTransformerVersionOfPlugin(Archetype archetype) {
        RepositoryQueries.Result versionsResult = RepositoryQueries.getVersionsResult((String)archetype.getGroupId(), (String)archetype.getArtifactId(), null);
        List results = versionsResult.getResults();
        for (NBVersionInfo result : results) {
            String lastVersion = result.getVersion();
            if (lastVersion.contains("SNAPSHOT")) continue;
            if (new ComparableVersion(lastVersion).compareTo(new ComparableVersion(archetype.getVersion())) > 0) {
                archetype.setVersion(lastVersion);
            }
            return archetype.getGroupId() + ":" + archetype.getArtifactId() + ":" + archetype.getVersion() + ":" + "run";
        }
        return archetype.getGroupId() + ":" + archetype.getArtifactId() + ":" + archetype.getVersion() + ":" + "run";
    }

    public void initialize(WizardDescriptor wiz) {
        this.wizardDescriptor = wiz;
        this.index = 0;
        this.panels = this.createPanels();
        String[] steps = this.createSteps();
        for (int i = 0; i < this.panels.length; ++i) {
            Component c = this.panels[i].getComponent();
            if (steps[i] == null) {
                steps[i] = c.getName();
            }
            if (!(c instanceof JComponent)) continue;
            JComponent jc = (JComponent)c;
            jc.putClientProperty("WizardPanel_contentSelectedIndex", i);
            jc.putClientProperty("WizardPanel_contentData", steps);
        }
        this.wizardDescriptor.putProperty("WizardPanel_image", (Object)ImageUtilities.loadImage((String)"org/netbeans/modules/fish/payara/jakarta/transformer/BannerJakarta.png", (boolean)true));
    }

    public void uninitialize(WizardDescriptor wiz) {
        if (this.wizardDescriptor != null) {
            this.wizardDescriptor.putProperty("targetSelected", null);
            this.wizardDescriptor.putProperty("sourceSelected", null);
            this.wizardDescriptor = null;
        }
        this.panels = null;
    }

    public String name() {
        return MessageFormat.format("{0} of {1}", this.index + 1, this.panels.length);
    }

    public boolean hasNext() {
        return this.index < this.panels.length - 1;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public WizardDescriptor.Panel<WizardDescriptor> current() {
        return this.panels[this.index];
    }

    public final void addChangeListener(ChangeListener l) {
    }

    public final void removeChangeListener(ChangeListener l) {
    }

    private static void writeFile(InputStream str, FileObject fo) throws IOException {
        try (OutputStream out = fo.getOutputStream();){
            FileUtil.copy((InputStream)str, (OutputStream)out);
        }
    }

    static {
        TRANSFORMER_ARCHETYPE.setGroupId("fish.payara.transformer");
        TRANSFORMER_ARCHETYPE.setVersion("0.2.13");
        TRANSFORMER_ARCHETYPE.setArtifactId("fish.payara.transformer.maven");
    }
}

