/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.v8debug;

import java.util.HashSet;
import java.util.Set;
import org.netbeans.lib.v8debug.PropertyLong;
import org.netbeans.lib.v8debug.vars.ReferencedValue;
import org.netbeans.lib.v8debug.vars.V8Value;

public final class V8Script
extends V8Value {
    private final String name;
    private final long id;
    private final long lineOffset;
    private final long columnOffset;
    private final long lineCount;
    private final Object data;
    private final String source;
    private final String sourceStart;
    private final PropertyLong sourceLength;
    private final ReferencedValue context;
    private final Type scriptType;
    private final CompilationType compilationType;
    private final ReferencedValue evalFromScript;
    private final EvalFromLocation evalFromLocation;

    public V8Script(long handle, String name, long id, long lineOffset, long columnOffset, long lineCount, Object data, String source, String sourceStart, Long sourceLength, ReferencedValue context, String text, Type scriptType, CompilationType compilationType, ReferencedValue evalFromScript, EvalFromLocation evalFromLocation) {
        super(handle, V8Value.Type.Script, text);
        this.name = name;
        this.id = id;
        this.lineOffset = lineOffset;
        this.columnOffset = columnOffset;
        this.lineCount = lineCount;
        this.data = data;
        this.source = source;
        this.sourceStart = sourceStart;
        this.sourceLength = new PropertyLong(sourceLength);
        this.context = context;
        this.scriptType = scriptType;
        this.compilationType = compilationType;
        this.evalFromScript = evalFromScript;
        this.evalFromLocation = evalFromLocation;
    }

    public String getName() {
        return this.name;
    }

    public long getId() {
        return this.id;
    }

    public long getLineOffset() {
        return this.lineOffset;
    }

    public long getColumnOffset() {
        return this.columnOffset;
    }

    public long getLineCount() {
        return this.lineCount;
    }

    public Object getData() {
        return this.data;
    }

    public String getSource() {
        return this.source;
    }

    public String getSourceStart() {
        return this.sourceStart;
    }

    public PropertyLong getSourceLength() {
        return this.sourceLength;
    }

    public ReferencedValue getContext() {
        return this.context;
    }

    public Type getScriptType() {
        return this.scriptType;
    }

    public CompilationType getCompilationType() {
        return this.compilationType;
    }

    public ReferencedValue getEvalFromScript() {
        return this.evalFromScript;
    }

    public EvalFromLocation getEvalFromLocation() {
        return this.evalFromLocation;
    }

    public static enum Type {
        NATIVE,
        EXTENSION,
        NORMAL;


        public static Type valueOf(int i) {
            if (i >= Type.values().length) {
                return null;
            }
            return Type.values()[i];
        }
    }

    public static enum CompilationType {
        API,
        EVAL;


        public static CompilationType valueOf(int i) {
            return CompilationType.values()[i];
        }
    }

    public static final class EvalFromLocation {
        private final long line;
        private final long column;

        public EvalFromLocation(long line, long column) {
            this.line = line;
            this.column = column;
        }

        public long getLine() {
            return this.line;
        }

        public long getColumn() {
            return this.column;
        }
    }

    public static final class Types {
        private final int type;

        public Types(int type) {
            this.type = type;
        }

        public Types(boolean isNative, boolean isExtension, boolean isNormal) {
            this.type = (isNative ? 1 : 0) | (isExtension ? 2 : 0) | (isNormal ? 4 : 0);
        }

        public int getIntTypes() {
            return this.type;
        }

        public Set<Type> getTypes() {
            HashSet<Type> types = new HashSet<Type>();
            for (Type t : Type.values()) {
                if ((this.type & 1 << t.ordinal()) == 0) continue;
                types.add(t);
            }
            return types;
        }
    }
}

