/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.artifacts.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.artifacts.model.UpdateContainerConfigurationDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class UpdateContainerConfigurationRequest
extends BmcRequest<UpdateContainerConfigurationDetails> {
    private String compartmentId;
    private UpdateContainerConfigurationDetails updateContainerConfigurationDetails;
    private String ifMatch;
    private String opcRequestId;

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public UpdateContainerConfigurationDetails getUpdateContainerConfigurationDetails() {
        return this.updateContainerConfigurationDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public UpdateContainerConfigurationDetails getBody$() {
        return this.updateContainerConfigurationDetails;
    }

    public Builder toBuilder() {
        return new Builder().compartmentId(this.compartmentId).updateContainerConfigurationDetails(this.updateContainerConfigurationDetails).ifMatch(this.ifMatch).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(",updateContainerConfigurationDetails=").append(String.valueOf((Object)this.updateContainerConfigurationDetails));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateContainerConfigurationRequest)) {
            return false;
        }
        UpdateContainerConfigurationRequest other = (UpdateContainerConfigurationRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals((Object)this.updateContainerConfigurationDetails, (Object)other.updateContainerConfigurationDetails) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.updateContainerConfigurationDetails == null ? 43 : this.updateContainerConfigurationDetails.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdateContainerConfigurationRequest, UpdateContainerConfigurationDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String compartmentId = null;
        private UpdateContainerConfigurationDetails updateContainerConfigurationDetails = null;
        private String ifMatch = null;
        private String opcRequestId = null;

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder updateContainerConfigurationDetails(UpdateContainerConfigurationDetails updateContainerConfigurationDetails) {
            this.updateContainerConfigurationDetails = updateContainerConfigurationDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateContainerConfigurationRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.updateContainerConfigurationDetails(o.getUpdateContainerConfigurationDetails());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateContainerConfigurationRequest build() {
            UpdateContainerConfigurationRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdateContainerConfigurationDetails body) {
            this.updateContainerConfigurationDetails(body);
            return this;
        }

        public UpdateContainerConfigurationRequest buildWithoutInvocationCallback() {
            UpdateContainerConfigurationRequest request = new UpdateContainerConfigurationRequest();
            request.compartmentId = this.compartmentId;
            request.updateContainerConfigurationDetails = this.updateContainerConfigurationDetails;
            request.ifMatch = this.ifMatch;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

