/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.payara.tooling.server.parser;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.netbeans.modules.payara.tooling.logging.Logger;
import org.netbeans.modules.payara.tooling.server.parser.HttpData;
import org.netbeans.modules.payara.tooling.server.parser.TargetConfigReader;
import org.netbeans.modules.payara.tooling.server.parser.TreeParser;
import org.netbeans.modules.payara.tooling.server.parser.XMLReader;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class HttpListenerReader
extends TargetConfigReader
implements XMLReader {
    private static final Logger LOGGER = new Logger(HttpListenerReader.class);
    public static final String DEFAULT_PATH = "/domain/configs/config/http-service/http-listener";
    private String path;
    private Map<String, HttpData> result;

    public HttpListenerReader(String targetConfigName) {
        this(DEFAULT_PATH, targetConfigName);
    }

    public HttpListenerReader(String path, String targetConfigName) {
        super(targetConfigName);
        this.path = path;
        this.result = new HashMap<String, HttpData>();
    }

    @Override
    public void readAttributes(String qname, Attributes attributes) throws SAXException {
        String METHOD = "readAttributes";
        if (readData) {
            try {
                String id = attributes.getValue("id");
                if (id != null && id.length() > 0) {
                    int port = Integer.parseInt(attributes.getValue("port"));
                    boolean secure = Boolean.TRUE.toString().equals(attributes.getValue("security-enabled"));
                    boolean enabled = !Boolean.FALSE.toString().equals(attributes.getValue("enabled"));
                    LOGGER.log(Level.INFO, "readAttributes", "port", new Object[]{Integer.toString(port), Boolean.toString(enabled), Boolean.toString(secure)});
                    if (enabled) {
                        HttpData data = new HttpData(id, port, secure);
                        LOGGER.log(Level.INFO, "readAttributes", "add", data);
                        this.result.put(id, data);
                    }
                } else {
                    LOGGER.log(Level.INFO, "readAttributes", "noName");
                }
            }
            catch (NumberFormatException ex) {
                LOGGER.log(Level.SEVERE, "readAttributes", "numberFormat", ex);
            }
        }
    }

    @Override
    public List<TreeParser.Path> getPathsToListen() {
        LinkedList<TreeParser.Path> paths = new LinkedList<TreeParser.Path>();
        paths.add(new TreeParser.Path(this.path, this));
        paths.add(new TreeParser.Path("/domain/configs/config", new TargetConfigReader.TargetConfigMarker(this)));
        return paths;
    }

    public Map<String, HttpData> getResult() {
        return this.result;
    }
}

