/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.emoji.internal;

import com.vladsch.flexmark.ext.emoji.internal.EmojiReference;
import java.io.File;
import java.util.HashMap;

public class EmojiShortcuts {
    public static final String gitHubUrlPrefix = "https://github.githubassets.com/images/icons/emoji/";
    private static final HashMap<String, EmojiReference.Emoji> emojiShortcuts = new HashMap();
    private static final HashMap<String, EmojiReference.Emoji> emojiURIs = new HashMap();
    private static final HashMap<EmojiReference.Emoji, String> emojiUnicodeChars = new HashMap();

    public static synchronized String getUnicodeChars(EmojiReference.Emoji emoji) {
        if (emoji == null || emoji.unicodeChars == null) {
            return null;
        }
        String value = emojiUnicodeChars.get(emoji);
        if (value == null) {
            String[] unicodePoints = emoji.unicodeChars.replace("U+", "").split(" ");
            StringBuilder sb = new StringBuilder(16);
            for (String unicodePoint : unicodePoints) {
                sb.appendCodePoint(Integer.parseInt(unicodePoint, 16));
            }
            value = sb.toString();
            emojiUnicodeChars.put(emoji, value);
        }
        return value;
    }

    public static String extractFileName(String emojiURI) {
        String fileName = new File(emojiURI).getName();
        int pos = fileName.indexOf(".png");
        if (pos >= 0) {
            fileName = fileName.substring(0, pos);
        }
        return fileName;
    }

    public static HashMap<String, EmojiReference.Emoji> getEmojiShortcuts() {
        EmojiShortcuts.updateEmojiShortcuts();
        return emojiShortcuts;
    }

    public static HashMap<String, EmojiReference.Emoji> getEmojiURIs() {
        EmojiShortcuts.updateEmojiShortcuts();
        return emojiURIs;
    }

    public static EmojiReference.Emoji getEmojiFromShortcut(String shortcut) {
        EmojiShortcuts.updateEmojiShortcuts();
        return emojiShortcuts.get(shortcut);
    }

    public static EmojiReference.Emoji getEmojiFromURI(String imageURI) {
        EmojiShortcuts.updateEmojiURIs();
        return emojiURIs.get(EmojiShortcuts.extractFileName(imageURI));
    }

    private static synchronized void updateEmojiShortcuts() {
        if (emojiShortcuts.isEmpty()) {
            for (EmojiReference.Emoji emoji : EmojiReference.getEmojiList()) {
                if (emoji.shortcut == null) continue;
                emojiShortcuts.put(emoji.shortcut, emoji);
            }
        }
    }

    private static synchronized void updateEmojiURIs() {
        if (emojiURIs.isEmpty()) {
            for (EmojiReference.Emoji emoji : EmojiReference.getEmojiList()) {
                if (emoji.emojiCheatSheetFile != null) {
                    emojiURIs.put(EmojiShortcuts.extractFileName(emoji.emojiCheatSheetFile), emoji);
                }
                if (emoji.githubFile != null) {
                    emojiURIs.put(EmojiShortcuts.extractFileName(emoji.githubFile), emoji);
                }
                if (emoji.unicodeSampleFile == null) continue;
                emojiURIs.put(EmojiShortcuts.extractFileName(emoji.unicodeSampleFile), emoji);
            }
        }
    }
}

