/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.lsp.client.debugger.models;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.netbeans.modules.lsp.client.debugger.DAPDebugger;
import org.netbeans.modules.lsp.client.debugger.DAPFrame;
import org.netbeans.modules.lsp.client.debugger.DAPVariable;
import org.netbeans.modules.lsp.client.debugger.models.Bundle;
import org.netbeans.modules.lsp.client.debugger.models.CurrentFrameTracker;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.NodeModel;
import org.netbeans.spi.viewmodel.TableModel;
import org.netbeans.spi.viewmodel.TreeModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;

public final class VariablesModel
extends CurrentFrameTracker
implements TreeModel,
NodeModel,
TableModel {
    private static final String LOCAL = "org/netbeans/modules/debugger/resources/localsView/LocalVariable";
    private static final Object[] NO_VARS = new Object[]{Bundle.CTL_VariablesModel_noVars()};
    private final DAPDebugger debugger;
    private final List<ModelListener> listeners = new CopyOnWriteArrayList<ModelListener>();

    public VariablesModel(ContextProvider contextProvider) {
        super(contextProvider);
        this.debugger = (DAPDebugger)contextProvider.lookupFirst(null, DAPDebugger.class);
    }

    public Object getRoot() {
        return "Root";
    }

    public Object[] getChildren(Object parent, int from, int to) throws UnknownTypeException {
        DAPVariable parentVar;
        if (parent == "Root") {
            parentVar = null;
        } else if (parent instanceof DAPVariable) {
            parentVar = (DAPVariable)parent;
        } else {
            throw new UnknownTypeException(parent);
        }
        DAPFrame frame = this.getCurrentFrame();
        if (frame != null) {
            if (parentVar == null) {
                try {
                    return this.debugger.getFrameVariables(frame).get().toArray();
                }
                catch (Throwable t) {
                    return new Object[]{t.getLocalizedMessage()};
                }
            }
            return parentVar.getChildren(from, to);
        }
        return NO_VARS;
    }

    public boolean isLeaf(Object node) throws UnknownTypeException {
        if (node == "Root") {
            return false;
        }
        if (node instanceof String) {
            return true;
        }
        if (node instanceof DAPVariable) {
            return ((DAPVariable)node).getTotalChildren() == 0;
        }
        throw new UnknownTypeException(node);
    }

    public int getChildrenCount(Object node) throws UnknownTypeException {
        if (node == "Root") {
            return Integer.MAX_VALUE;
        }
        if (node instanceof DAPVariable) {
            return ((DAPVariable)node).getTotalChildren();
        }
        throw new UnknownTypeException(node);
    }

    public void addModelListener(ModelListener l) {
        this.listeners.add(l);
    }

    public void removeModelListener(ModelListener l) {
        this.listeners.remove(l);
    }

    public String getDisplayName(Object node) throws UnknownTypeException {
        if (node instanceof String) {
            return (String)node;
        }
        if (node instanceof DAPVariable) {
            return ((DAPVariable)node).getName();
        }
        throw new UnknownTypeException(node);
    }

    public String getIconBase(Object node) throws UnknownTypeException {
        if (node instanceof DAPVariable) {
            return LOCAL;
        }
        if (node instanceof String) {
            return null;
        }
        throw new UnknownTypeException(node);
    }

    public String getShortDescription(Object node) throws UnknownTypeException {
        if (node instanceof String) {
            return null;
        }
        throw new UnknownTypeException(node);
    }

    public Object getValueAt(Object node, String columnID) throws UnknownTypeException {
        if (columnID.equals("LocalsValue") && node instanceof DAPVariable) {
            return ((DAPVariable)node).getValue();
        }
        if (columnID.equals("LocalsType") && node instanceof DAPVariable) {
            return ((DAPVariable)node).getType();
        }
        if (node instanceof String) {
            return "";
        }
        throw new UnknownTypeException(node);
    }

    public boolean isReadOnly(Object node, String columnID) throws UnknownTypeException {
        if (node instanceof String && columnID.equals("LocalsValue")) {
            return true;
        }
        throw new UnknownTypeException(node);
    }

    public void setValueAt(Object node, String columnID, Object value) throws UnknownTypeException {
        throw new UnknownTypeException(node);
    }

    void fireChanges() {
        ModelEvent.TreeChanged event = new ModelEvent.TreeChanged((Object)this);
        for (ModelListener l : this.listeners) {
            l.modelChanged((ModelEvent)event);
        }
    }

    @Override
    protected void frameChanged() {
        this.fireChanges();
    }
}

