/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.lsp.client.bindings;

import java.util.Collection;
import java.util.Iterator;
import java.util.logging.Level;
import javax.swing.Action;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.netbeans.api.actions.Openable;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.lsp.StructureElement;
import org.netbeans.modules.lsp.client.bindings.AbstractNavigatorPanel;
import org.netbeans.modules.lsp.client.bindings.Icons;
import org.netbeans.spi.lsp.StructureProvider;
import org.openide.awt.Actions;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.LineCookie;
import org.openide.filesystems.FileObject;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.text.Line;
import org.openide.text.NbDocument;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

final class LspStructureNavigatorPanel
extends AbstractNavigatorPanel<StructureElement> {
    static final LspStructureNavigatorPanel INSTANCE = new LspStructureNavigatorPanel();
    private static final RequestProcessor BACKGROUND = new RequestProcessor(LspStructureNavigatorPanel.class);
    private RequestProcessor.Task reparseTask;

    LspStructureNavigatorPanel() {
    }

    @Override
    void addBackgroundTask(FileObject fo) {
        this.removeBackgroundTask(fo);
        this.reparseTask = BACKGROUND.post(() -> this.refreshStructure(fo));
    }

    @Override
    void removeBackgroundTask(FileObject fo) {
        if (this.reparseTask != null) {
            this.reparseTask.cancel();
        }
    }

    void refreshStructure(FileObject fo) {
        Iterator iterator;
        StyledDocument doc;
        LOG.log(Level.INFO, "panelActivated: {0}", fo);
        EditorCookie ec = (EditorCookie)fo.getLookup().lookup(EditorCookie.class);
        if (ec != null && (doc = ec.getDocument()) != null && (iterator = MimeLookup.getLookup((String)fo.getMIMEType()).lookupAll(StructureProvider.class).iterator()).hasNext()) {
            StructureProvider sp = (StructureProvider)iterator.next();
            this.setKeys(sp.getStructure((Document)doc));
            return;
        }
    }

    @Override
    Node[] createNodes(FileObject fo, StructureElement key) {
        return new Node[]{new StructureElementNode(key, fo)};
    }

    private static final class StructureElementNode
    extends AbstractNode {
        private final FileObject fo;

        StructureElementNode(StructureElement e, FileObject fo) {
            this(e, fo, new InstanceContent());
        }

        private StructureElementNode(StructureElement e, FileObject fo, InstanceContent ic) {
            super(StructureElementChildren.childrenFor(e.getChildren(), fo), (Lookup)new AbstractLookup((AbstractLookup.Content)ic));
            this.fo = fo;
            this.setName(e.getName());
            this.setShortDescription(e.getDetail());
            this.setIconBaseWithExtension(Icons.getSymbolIconBase(e.getKind()));
            Openable open = () -> {
                StyledDocument doc;
                EditorCookie ec = (EditorCookie)fo.getLookup().lookup(EditorCookie.class);
                if (ec != null && (doc = ec.getDocument()) != null) {
                    Line at;
                    int lineNumber = NbDocument.findLineNumber((StyledDocument)doc, (int)e.getSelectionStartOffset());
                    LineCookie lines = (LineCookie)fo.getLookup().lookup(LineCookie.class);
                    if (lines != null && (at = lines.getLineSet().getOriginal(lineNumber)) != null) {
                        at.show(Line.ShowOpenType.OPEN, Line.ShowVisibilityType.FOCUS);
                    }
                }
            };
            ic.add((Object)open);
        }

        public Action getPreferredAction() {
            return Actions.forID((String)"System", (String)"org.openide.actions.OpenAction");
        }
    }

    private static final class StructureElementChildren
    extends Children.Keys<StructureElement> {
        private final FileObject fo;

        StructureElementChildren(FileObject fo) {
            this.fo = fo;
        }

        static Children childrenFor(Collection<? extends StructureElement> elements, FileObject fo) {
            if (elements == null) {
                return Children.LEAF;
            }
            StructureElementChildren ch = new StructureElementChildren(fo);
            ch.setKeys(elements);
            return ch;
        }

        protected Node[] createNodes(StructureElement key) {
            return new Node[]{new StructureElementNode(key, this.fo)};
        }
    }
}

