/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.lsp.client.bindings;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.netbeans.modules.lsp.client.bindings.Bundle;
import org.netbeans.spi.navigator.NavigatorPanel;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.BeanTreeView;
import org.openide.filesystems.FileObject;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;

abstract class AbstractNavigatorPanel<K>
extends Children.Keys<K>
implements NavigatorPanel,
LookupListener {
    static final Logger LOG = Logger.getLogger(AbstractNavigatorPanel.class.getName());
    private final ExplorerManager manager = new ExplorerManager();
    private View view;
    private Lookup.Result<FileObject> result;
    private FileObject file;

    public AbstractNavigatorPanel() {
        this.manager.setRootContext((Node)new AbstractNode((Children)this));
    }

    abstract void addBackgroundTask(FileObject var1);

    abstract void removeBackgroundTask(FileObject var1);

    abstract Node[] createNodes(FileObject var1, K var2);

    protected final Node[] createNodes(K key) {
        return this.createNodes(this.file, key);
    }

    final boolean isCurrentFile(FileObject fo) {
        return Objects.equals(this.file, fo);
    }

    final void expandAll() {
        SwingUtilities.invokeLater(this.view::expandAll);
    }

    public final String getDisplayName() {
        return Bundle.DN_Symbols();
    }

    public final String getDisplayHint() {
        return "symbols";
    }

    public final JComponent getComponent() {
        if (this.view == null) {
            this.view = new View();
        }
        return this.view;
    }

    public final void panelActivated(Lookup context) {
        this.result = context.lookupResult(FileObject.class);
        this.result.addLookupListener((LookupListener)this);
        this.updateFile();
    }

    public final void panelDeactivated() {
        this.result.removeLookupListener((LookupListener)this);
        this.result = null;
        this.updateFile();
    }

    private void updateFile() {
        if (this.file != null) {
            this.removeBackgroundTask(this.file);
            this.setKeys(Collections.emptyList());
            this.file = null;
        }
        List files = this.result != null ? this.result.allInstances() : Collections.emptyList();
        FileObject fileObject = this.file = files.isEmpty() ? null : (FileObject)files.iterator().next();
        if (this.file != null) {
            this.addBackgroundTask(this.file);
        }
    }

    public final Lookup getLookup() {
        return Lookup.EMPTY;
    }

    public final void resultChanged(LookupEvent arg0) {
        this.updateFile();
    }

    private class View
    extends JPanel
    implements ExplorerManager.Provider {
        private final BeanTreeView internalView;

        public View() {
            this.setLayout(new BorderLayout());
            this.internalView = new BeanTreeView();
            this.add((Component)this.internalView, "Center");
            this.internalView.setRootVisible(false);
        }

        public ExplorerManager getExplorerManager() {
            return AbstractNavigatorPanel.this.manager;
        }

        public void expandAll() {
            boolean scrollsOnExpand = this.internalView.getScrollsOnExpand();
            this.internalView.setScrollsOnExpand(false);
            this.internalView.expandAll();
            this.internalView.setScrollsOnExpand(scrollsOnExpand);
        }
    }
}

