/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tomcat5.deploy;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.deploy.model.DeployableObject;
import javax.enterprise.deploy.shared.DConfigBeanVersionType;
import javax.enterprise.deploy.shared.ModuleType;
import javax.enterprise.deploy.spi.DeploymentConfiguration;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.exceptions.DConfigBeanVersionUnsupportedException;
import javax.enterprise.deploy.spi.exceptions.InvalidModuleException;
import javax.enterprise.deploy.spi.exceptions.TargetException;
import javax.enterprise.deploy.spi.status.ProgressObject;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.jpda.AttachingDICookie;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.extexecution.ExternalProcessSupport;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.netbeans.modules.j2ee.deployment.plugins.api.ServerDebugInfo;
import org.netbeans.modules.tomcat5.TomEEWarListener;
import org.netbeans.modules.tomcat5.TomcatFactory;
import org.netbeans.modules.tomcat5.config.gen.Server;
import org.netbeans.modules.tomcat5.deploy.TomcatManagerConfig;
import org.netbeans.modules.tomcat5.deploy.TomcatManagerImpl;
import org.netbeans.modules.tomcat5.deploy.TomcatModule;
import org.netbeans.modules.tomcat5.deploy.TomcatTarget;
import org.netbeans.modules.tomcat5.j2ee.TomcatPlatformImpl;
import org.netbeans.modules.tomcat5.optional.StartTomcat;
import org.netbeans.modules.tomcat5.progress.MultiProgressObjectWrapper;
import org.netbeans.modules.tomcat5.util.LogManager;
import org.netbeans.modules.tomcat5.util.TomcatInstallUtil;
import org.netbeans.modules.tomcat5.util.TomcatProperties;
import org.netbeans.modules.tomcat5.util.Utils;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class TomcatManager
implements DeploymentManager {
    public static final String KEY_UUID = "NB_EXEC_TOMCAT_START_PROCESS_UUID";
    private static final Logger LOGGER = Logger.getLogger(TomcatManager.class.getName());
    static final int ENUM_AVAILABLE = 0;
    static final int ENUM_RUNNING = 1;
    static final int ENUM_NONRUNNING = 2;
    public static final String PROP_BUNDLED_TOMCAT = "is_it_bundled_tomcat";
    private final boolean connected;
    private final String uri;
    private StartTomcat startTomcat;
    private Process process;
    private TomcatManagerConfig tomcatManagerConfig;
    private final LogManager logManager = new LogManager(this);
    private TomcatPlatformImpl tomcatPlatform;
    private final TomcatProperties tp;
    private final TomcatVersion tomcatVersion;
    private boolean tomEEChecked;
    private TomEEWarListener tomEEWarListener;
    private TomEEVersion tomEEVersion;
    private TomEEType tomEEType;
    private final InstanceProperties ip;
    private boolean needsRestart;
    private boolean misconfiguredProxy;

    public TomcatManager(boolean conn, String uri, TomcatVersion tomcatVersion) throws IllegalArgumentException {
        LOGGER.log(Level.FINE, "Creating connected TomcatManager uri={0}", uri);
        this.connected = conn;
        this.tomcatVersion = tomcatVersion;
        this.uri = uri;
        this.ip = InstanceProperties.getInstanceProperties((String)this.getUri());
        assert (this.ip != null);
        this.tp = new TomcatProperties(this);
    }

    public InstanceProperties getInstanceProperties() {
        return this.ip;
    }

    public boolean isBundledTomcat() {
        if (this.ip == null) {
            return false;
        }
        String val = this.ip.getProperty(PROP_BUNDLED_TOMCAT);
        return val != null ? Boolean.valueOf(val) : false;
    }

    public TomcatProperties getTomcatProperties() {
        return this.tp;
    }

    public synchronized void setNeedsRestart(boolean needsRestart) {
        this.needsRestart = needsRestart;
    }

    public synchronized boolean getNeedsRestart() {
        return this.needsRestart;
    }

    public synchronized boolean isMisconfiguredProxy() {
        return this.misconfiguredProxy;
    }

    public synchronized void setMisconfiguredProxy(boolean misconfiguredProxy) {
        this.misconfiguredProxy = misconfiguredProxy;
    }

    public boolean isRunning(boolean checkResponse) {
        return this.isRunning(this.tp.getRunningCheckTimeout(), checkResponse);
    }

    public boolean isRunning(int timeout, boolean checkResponse) {
        block4: {
            Process proc = this.getTomcatProcess();
            if (proc != null) {
                try {
                    proc.exitValue();
                    return false;
                }
                catch (IllegalThreadStateException e) {
                    if (checkResponse) break block4;
                    return true;
                }
            }
        }
        if (checkResponse) {
            return Utils.pingTomcat(this.getServerPort(), timeout, this.getServerHeader(), this.getPlainUri());
        }
        return false;
    }

    public String getUri() {
        switch (this.tomcatVersion) {
            case TOMCAT_110: {
                return "tomcat110:" + this.uri;
            }
            case TOMCAT_101: {
                return "tomcat101:" + this.uri;
            }
            case TOMCAT_100: {
                return "tomcat100:" + this.uri;
            }
            case TOMCAT_90: {
                return "tomcat90:" + this.uri;
            }
            case TOMCAT_80: {
                return "tomcat80:" + this.uri;
            }
            case TOMCAT_70: {
                return "tomcat70:" + this.uri;
            }
            case TOMCAT_60: {
                return "tomcat60:" + this.uri;
            }
            case TOMCAT_55: {
                return "tomcat55:" + this.uri;
            }
        }
        return "tomcat:" + this.uri;
    }

    public String getPlainUri() {
        if (this.tomcatVersion.isAtLeast(TomcatVersion.TOMCAT_70)) {
            return "http://" + this.tp.getHost() + ":" + this.getCurrentServerPort() + "/manager/text/";
        }
        return "http://" + this.tp.getHost() + ":" + this.getCurrentServerPort() + "/manager/";
    }

    public String getServerUri() {
        return "http://" + this.tp.getHost() + ":" + this.getCurrentServerPort();
    }

    public String getCatalinaWork() {
        TomcatManagerConfig tmConfig = this.getTomcatManagerConfig();
        String engineName = tmConfig.getEngineElement().getAttributeValue("name");
        String hostName = tmConfig.getHostElement().getAttributeValue("name");
        StringBuilder catWork = new StringBuilder(this.tp.getCatalinaDir().toString());
        catWork.append("/work/").append(engineName).append("/").append(hostName);
        return catWork.toString();
    }

    public void ensureCatalinaBaseReady() {
        String[] files;
        File baseDir = this.tp.getCatalinaBase();
        if (baseDir != null && ((files = baseDir.list()) == null || files.length == 0)) {
            FileObject parentFileObject;
            File parentDir;
            this.createBaseDir(baseDir, this.tp.getCatalinaHome());
            if (FileUtil.toFileObject((File)baseDir) == null && (parentDir = baseDir.getParentFile()) != null && (parentFileObject = FileUtil.toFileObject((File)parentDir)) != null) {
                parentFileObject.refresh();
            }
        }
    }

    public StartTomcat getStartTomcat() {
        return this.startTomcat;
    }

    public void setStartTomcat(StartTomcat st) {
        this.startTomcat = st;
    }

    public boolean isDebugged() {
        ServerDebugInfo sdi = null;
        Session[] sessions = DebuggerManager.getDebuggerManager().getSessions();
        sdi = this.getStartTomcat().getDebugInfo(null);
        if (sdi == null) {
            LOGGER.log(Level.INFO, "DebuggerInfo cannot be found for: {0}", this.toString());
        }
        for (int i = 0; i < sessions.length; ++i) {
            Object o;
            Session s = sessions[i];
            if (s == null || (o = s.lookupFirst(null, AttachingDICookie.class)) == null) continue;
            AttachingDICookie attCookie = (AttachingDICookie)o;
            if (!(sdi.getTransport().equals("dt_shmem") ? attCookie.getSharedMemoryName().equalsIgnoreCase(sdi.getShmemName()) : attCookie.getHostName().equalsIgnoreCase(sdi.getHost()) && attCookie.getPortNumber() == sdi.getPort())) continue;
            return true;
        }
        return false;
    }

    public boolean isSuspended() {
        Session[] sessions = DebuggerManager.getDebuggerManager().getSessions();
        ServerDebugInfo sdi = this.getStartTomcat().getDebugInfo(null);
        if (sdi == null) {
            LOGGER.log(Level.INFO, "DebuggerInfo cannot be found for: {0}", this.toString());
        }
        for (int i = 0; i < sessions.length; ++i) {
            String host;
            JPDADebugger jpda;
            Object d;
            String shmem;
            Object o;
            Session s = sessions[i];
            if (s == null || (o = s.lookupFirst(null, AttachingDICookie.class)) == null) continue;
            AttachingDICookie attCookie = (AttachingDICookie)o;
            if (!(sdi.getTransport().equals("dt_shmem") ? (shmem = attCookie.getSharedMemoryName()) != null && shmem.equalsIgnoreCase(sdi.getShmemName()) && (d = s.lookupFirst(null, JPDADebugger.class)) != null && (jpda = (JPDADebugger)d).getState() == 3 : (host = attCookie.getHostName()) != null && host.equalsIgnoreCase(sdi.getHost()) && attCookie.getPortNumber() == sdi.getPort() && (d = s.lookupFirst(null, JPDADebugger.class)) != null && (jpda = (JPDADebugger)d).getState() == 3)) continue;
            return true;
        }
        return false;
    }

    public boolean isAboveTomcat70() {
        return this.tomcatVersion.isAtLeast(TomcatVersion.TOMCAT_70);
    }

    public boolean isTomcat110() {
        return this.tomcatVersion == TomcatVersion.TOMCAT_110;
    }

    public boolean isTomcat101() {
        return this.tomcatVersion == TomcatVersion.TOMCAT_101;
    }

    public boolean isTomcat100() {
        return this.tomcatVersion == TomcatVersion.TOMCAT_100;
    }

    public boolean isTomcat90() {
        return this.tomcatVersion == TomcatVersion.TOMCAT_90;
    }

    public boolean isTomcat80() {
        return this.tomcatVersion == TomcatVersion.TOMCAT_80;
    }

    public boolean isTomcat70() {
        return this.tomcatVersion == TomcatVersion.TOMCAT_70;
    }

    public boolean isTomcat60() {
        return this.tomcatVersion == TomcatVersion.TOMCAT_60;
    }

    public boolean isTomcat55() {
        return this.tomcatVersion == TomcatVersion.TOMCAT_55;
    }

    public boolean isTomcat50() {
        return this.tomcatVersion == TomcatVersion.TOMCAT_50;
    }

    public synchronized boolean isTomEE() {
        this.loadTomEEInfo();
        return this.tomEEVersion != null;
    }

    public synchronized boolean isTomEEJaxRS() {
        switch (this.tomEEType) {
            case TOMEE_PLUME: 
            case TOMEE_PLUS: 
            case TOMEE_MICROPROFILE: 
            case TOMEE_WEBPROFILE: 
            case TOMEE_JAXRS: {
                return true;
            }
        }
        return false;
    }

    public boolean isTomEE10() {
        return this.tomEEVersion == TomEEVersion.TOMEE_100;
    }

    public boolean isTomEE9() {
        return this.tomEEVersion == TomEEVersion.TOMEE_90;
    }

    public boolean isTomEE8() {
        return this.tomEEVersion == TomEEVersion.TOMEE_80;
    }

    public boolean isTomEEplume() {
        return this.tomEEType == TomEEType.TOMEE_PLUME;
    }

    public boolean isJpa30() {
        return this.isTomEE9();
    }

    public boolean isJpa31() {
        return this.isTomEE10();
    }

    public boolean isJpa32() {
        return false;
    }

    public boolean isJpa22() {
        return this.isTomEE8();
    }

    public boolean isJpa21() {
        return this.tomEEVersion.isAtLeast(TomEEVersion.TOMEE_70) && !this.isTomEE9();
    }

    public boolean isJpa20() {
        return this.tomEEVersion.isAtLeast(TomEEVersion.TOMEE_15) && !this.isTomEE9();
    }

    public boolean isJpa10() {
        return this.isJpa20();
    }

    public String libFolder() {
        return this.tomcatVersion.isAtLeast(TomcatVersion.TOMCAT_60) ? "lib" : "common/lib";
    }

    public TomcatVersion getTomcatVersion() {
        return this.tomcatVersion;
    }

    public synchronized TomEEVersion getTomEEVersion() {
        this.loadTomEEInfo();
        return this.tomEEVersion;
    }

    public synchronized TomEEType getTomEEType() {
        this.loadTomEEInfo();
        return this.tomEEType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadTomEEInfo() {
        boolean fireListener = false;
        TomcatManager tomcatManager = this;
        synchronized (tomcatManager) {
            if (this.tomEEChecked) {
                return;
            }
            assert (this.tomEEWarListener == null);
            this.tomEEChecked = true;
            this.tomEEVersion = TomcatFactory.getTomEEVersion(this.tp.getCatalinaHome(), this.tp.getCatalinaBase());
            TomEEType tomEEType = this.tomEEType = this.tomEEVersion == null ? null : TomcatFactory.getTomEEType(this.tp.getCatalinaHome(), this.tp.getCatalinaBase());
            if (this.tomEEVersion == null) {
                this.tomEEWarListener = new TomEEWarListener(this.tp, (version, type) -> {
                    TomcatManager tomcatManager = this;
                    synchronized (tomcatManager) {
                        this.tomEEVersion = version;
                        this.tomEEType = type;
                    }
                    this.getTomcatPlatform().notifyLibrariesChanged();
                });
                File listenFile = this.tp.getCatalinaBase() != null ? new File(this.tp.getCatalinaBase(), "webapps") : new File(this.tp.getCatalinaHome(), "webapps");
                FileUtil.addFileChangeListener((FileChangeListener)this.tomEEWarListener, (File)listenFile);
                fireListener = true;
            }
            LOGGER.log(Level.INFO, "TomEE version {0}, type {1}", new Object[]{this.tomEEVersion, this.tomEEType});
        }
        if (fireListener) {
            this.tomEEWarListener.checkAndRefresh();
        }
    }

    public DeploymentConfiguration createConfiguration(DeployableObject deplObj) throws InvalidModuleException {
        throw new RuntimeException("This should never be called");
    }

    public Locale getCurrentLocale() {
        return Locale.getDefault();
    }

    public Locale getDefaultLocale() {
        return Locale.getDefault();
    }

    public Locale[] getSupportedLocales() {
        return Locale.getAvailableLocales();
    }

    public boolean isLocaleSupported(Locale locale) {
        if (locale == null) {
            return false;
        }
        Locale[] supLocales = this.getSupportedLocales();
        for (int i = 0; i < supLocales.length; ++i) {
            if (!locale.equals(supLocales[i])) continue;
            return true;
        }
        return false;
    }

    public TargetModuleID[] getAvailableModules(ModuleType moduleType, Target[] targetList) throws TargetException, IllegalStateException {
        return this.modules(0, moduleType, targetList);
    }

    public TargetModuleID[] getNonRunningModules(ModuleType moduleType, Target[] targetList) throws TargetException, IllegalStateException {
        return this.modules(2, moduleType, targetList);
    }

    public TargetModuleID[] getRunningModules(ModuleType moduleType, Target[] targetList) throws TargetException, IllegalStateException {
        return this.modules(1, moduleType, targetList);
    }

    public Target[] getTargets() throws IllegalStateException {
        if (!this.isConnected()) {
            throw new IllegalStateException("TomcatManager.getTargets called on disconnected instance");
        }
        return new TomcatTarget[]{new TomcatTarget(this.uri, "Tomcat at " + this.uri, this.getServerUri())};
    }

    public DConfigBeanVersionType getDConfigBeanVersion() {
        return null;
    }

    public void setDConfigBeanVersion(DConfigBeanVersionType version) throws DConfigBeanVersionUnsupportedException {
        if (!DConfigBeanVersionType.V1_3_1.equals(version)) {
            throw new DConfigBeanVersionUnsupportedException("unsupported version");
        }
    }

    public boolean isDConfigBeanVersionSupported(DConfigBeanVersionType version) {
        return DConfigBeanVersionType.V1_3_1.equals(version);
    }

    public boolean isRedeploySupported() {
        return false;
    }

    public ProgressObject redeploy(TargetModuleID[] targetModuleID, InputStream inputStream, InputStream inputStream2) throws UnsupportedOperationException, IllegalStateException {
        throw new UnsupportedOperationException("TomcatManager.redeploy not supported yet.");
    }

    public ProgressObject redeploy(TargetModuleID[] tmID, File file, File file2) throws UnsupportedOperationException, IllegalStateException {
        throw new UnsupportedOperationException("TomcatManager.redeploy not supported yet.");
    }

    public void release() {
    }

    public void setLocale(Locale locale) throws UnsupportedOperationException {
    }

    public ProgressObject start(TargetModuleID[] tmID) throws IllegalStateException {
        if (!this.isConnected()) {
            throw new IllegalStateException("TomcatManager.start called on disconnected instance");
        }
        if (tmID.length != 1 || !(tmID[0] instanceof TomcatModule)) {
            throw new IllegalStateException("TomcatManager.start invalid TargetModuleID passed");
        }
        TomcatManagerImpl impl = new TomcatManagerImpl(this);
        impl.start((TomcatModule)tmID[0]);
        return impl;
    }

    public ProgressObject stop(TargetModuleID[] tmID) throws IllegalStateException {
        if (!this.isConnected()) {
            throw new IllegalStateException("TomcatManager.stop called on disconnected instance");
        }
        if (tmID.length != 1 || !(tmID[0] instanceof TomcatModule)) {
            throw new IllegalStateException("TomcatManager.stop invalid TargetModuleID passed");
        }
        TomcatManagerImpl impl = new TomcatManagerImpl(this);
        impl.stop((TomcatModule)tmID[0]);
        return impl;
    }

    public ProgressObject undeploy(TargetModuleID[] tmID) throws IllegalStateException {
        if (!this.isConnected()) {
            throw new IllegalStateException("TomcatManager.undeploy called on disconnected instance");
        }
        if (tmID == null) {
            throw new NullPointerException("TomcatManager.undeploy the tmID argument must not be null.");
        }
        if (tmID.length == 0) {
            throw new IllegalArgumentException("TomcatManager.undeploy at least one TargetModuleID object must be passed.");
        }
        for (int i = 0; i < tmID.length; ++i) {
            if (tmID[i] instanceof TomcatModule) continue;
            throw new IllegalStateException("TomcatManager.undeploy invalid TargetModuleID passed: " + tmID[i].getClass().getName());
        }
        ProgressObject[] tmImpls = new TomcatManagerImpl[tmID.length];
        for (int i = 0; i < tmID.length; ++i) {
            tmImpls[i] = new TomcatManagerImpl(this);
        }
        MultiProgressObjectWrapper po = new MultiProgressObjectWrapper(tmImpls);
        for (int i = 0; i < tmID.length; ++i) {
            TomcatModule tm = (TomcatModule)tmID[i];
            if ("/manager".equals(tm.getPath())) {
                String msg = NbBundle.getMessage(TomcatModule.class, (String)"MSG_CannotUndeployManager");
                throw new IllegalStateException(msg);
            }
            tmImpls[i].remove(tm);
        }
        return po;
    }

    public ProgressObject distribute(Target[] targets, InputStream is, InputStream deplPlan) throws IllegalStateException {
        if (!this.isConnected()) {
            throw new IllegalStateException("TomcatManager.distribute called on disconnected instance");
        }
        LOGGER.log(Level.FINE, "TomcatManager.distribute streams");
        TomcatManagerImpl impl = new TomcatManagerImpl(this);
        impl.deploy(targets[0], is, deplPlan);
        return impl;
    }

    public ProgressObject distribute(Target[] targets, File moduleArchive, File deplPlan) throws IllegalStateException {
        if (!this.isConnected()) {
            throw new IllegalStateException("TomcatManager.distribute called on disconnected instance");
        }
        LOGGER.log(Level.FINE, "TomcatManager.distribute archive={0}, plan={1}", new Object[]{moduleArchive.getPath(), deplPlan.getPath()});
        TomcatManagerImpl impl = new TomcatManagerImpl(this);
        impl.install(targets[0], moduleArchive, deplPlan);
        return impl;
    }

    public ProgressObject distribute(Target[] target, ModuleType moduleType, InputStream inputStream, InputStream inputStream0) throws IllegalStateException {
        return this.distribute(target, inputStream, inputStream0);
    }

    private TargetModuleID[] modules(int state, ModuleType moduleType, Target[] targetList) throws TargetException, IllegalStateException {
        if (!this.isConnected()) {
            throw new IllegalStateException("TomcatManager.modules called on disconnected instance");
        }
        if (targetList.length != 1) {
            throw new TargetException("TomcatManager.modules supports only one target");
        }
        if (!ModuleType.WAR.equals(moduleType)) {
            return new TargetModuleID[0];
        }
        TomcatManagerImpl impl = new TomcatManagerImpl(this);
        return impl.list(targetList[0], state);
    }

    public boolean isConnected() {
        return this.connected;
    }

    public String toString() {
        return "Tomcat manager [" + this.uri + ", home " + this.tp.getCatalinaHome() + ", base " + this.tp.getCatalinaBase() + (this.connected ? "conneceted" : "disconnected") + "]";
    }

    public void setServerPort(int port) {
        this.ensureCatalinaBaseReady();
        if (TomcatInstallUtil.setServerPort(port, this.tp.getServerXml())) {
            this.tp.setServerPort(port);
        }
    }

    public void setShutdownPort(int port) {
        this.ensureCatalinaBaseReady();
        if (TomcatInstallUtil.setShutdownPort(port, this.tp.getServerXml())) {
            this.tp.setShutdownPort(port);
        }
    }

    public int getCurrentServerPort() {
        if (this.startTomcat != null && this.isRunning(false)) {
            return this.startTomcat.getCurrentServerPort();
        }
        return this.getServerPort();
    }

    public int getServerPort() {
        this.ensureConnectionInfoUptodate();
        return this.tp.getServerPort();
    }

    public int getShutdownPort() {
        this.ensureConnectionInfoUptodate();
        return this.tp.getShutdownPort();
    }

    public String getServerHeader() {
        this.ensureConnectionInfoUptodate();
        return this.tp.getServerHeader();
    }

    private void ensureConnectionInfoUptodate() {
        File serverXml = this.tp.getServerXml();
        long timestamp = -1L;
        if (serverXml.exists() && (timestamp = serverXml.lastModified()) > this.tp.getTimestamp()) {
            try {
                if (this.isBundledTomcat() && !new File(this.tp.getCatalinaBase(), "conf/server.xml").exists()) {
                    this.tp.setTimestamp(timestamp);
                    this.tp.setServerPort(8084);
                    this.tp.setShutdownPort(8025);
                    return;
                }
                Server server = Server.createGraph(serverXml);
                this.tp.setTimestamp(timestamp);
                this.tp.setServerPort(Integer.parseInt(TomcatInstallUtil.getPort(server)));
                this.tp.setShutdownPort(Integer.parseInt(TomcatInstallUtil.getShutdownPort(server)));
                this.tp.setServerHeader(TomcatInstallUtil.getServerHeader(server));
            }
            catch (IOException | RuntimeException ioe) {
                LOGGER.log(Level.INFO, null, ioe);
            }
        }
    }

    public Server getRoot() {
        try {
            return Server.createGraph(this.tp.getServerXml());
        }
        catch (IOException e) {
            LOGGER.log(Level.FINE, null, e);
            return null;
        }
        catch (RuntimeException e) {
            LOGGER.log(Level.INFO, null, e);
            return null;
        }
    }

    public File createBaseDir(File baseDir, File homeDir) {
        File targetFolder;
        if (!baseDir.isAbsolute()) {
            baseDir = new File(System.getProperty("netbeans.user") + System.getProperty("file.separator") + baseDir);
            targetFolder = new File(System.getProperty("netbeans.user"));
        } else {
            targetFolder = baseDir.getParentFile();
        }
        try {
            File tomee;
            if (targetFolder == null) {
                LOGGER.log(Level.INFO, "Cannot find parent folder for base dir {0}", baseDir.getPath());
                return null;
            }
            File baseDirFO = new File(targetFolder, baseDir.getName());
            baseDirFO.mkdir();
            String[] subdirs = new String[]{"conf", "conf/Catalina", "conf/Catalina/localhost", "logs", "work", "temp", "webapps", "conf/conf.d"};
            for (int i = 0; i < subdirs.length; ++i) {
                File dest = new File(baseDirFO, subdirs[i]);
                dest.mkdirs();
            }
            String ADMIN_XML = "conf/Catalina/localhost/admin.xml";
            String[] files = new String[]{"conf/catalina.policy", "conf/catalina.properties", "conf/logging.properties", "conf/server.xml", "conf/tomcat-users.xml", "conf/web.xml", "conf/Catalina/localhost/admin.xml", "conf/Catalina/localhost/manager.xml", "conf/system.properties", "conf/tomee.xml", "conf/conf.d/hsql.properties"};
            boolean[] userReadOnly = new boolean[]{false, false, false, false, true, false, false, false, false, false, false};
            String[] patternFrom = new String[]{null, null, null, null, "</tomcat-users>", null, "docBase=\"../server/webapps/admin\"", this.isTomcat50() || this.isTomcat55() ? "docBase=\"../server/webapps/manager\"" : null, null, null, null};
            String passwd = null;
            if (this.isBundledTomcat() && "ide_manager".equals(passwd = this.tp.getPassword())) {
                passwd = Utils.generatePassword(8);
                this.tp.setPassword(passwd);
            }
            String usersString = null;
            if (passwd != null) {
                usersString = this.isAboveTomcat70() ? "<user username=\"ide\" password=\"" + passwd + "\" roles=\"manager-script,admin\"/>\n</tomcat-users>" : "<user username=\"ide\" password=\"" + passwd + "\" roles=\"manager,admin\"/>\n</tomcat-users>";
            }
            String[] patternTo = new String[]{null, null, null, null, usersString, null, "docBase=\"${catalina.home}/server/webapps/admin\"", this.isTomcat50() || this.isTomcat55() ? "docBase=\"${catalina.home}/server/webapps/manager\"" : null, null, null, null};
            for (int i = 0; i < files.length; ++i) {
                int slash = files[i].lastIndexOf("/");
                String sfolder = files[i].substring(0, slash);
                File fromDir = new File(homeDir, sfolder);
                File toDir = new File(baseDir, sfolder);
                File targetFile = new File(toDir, files[i].substring(slash + 1));
                if (patternTo[i] == null) {
                    File fileToCopy = new File(homeDir, files[i]);
                    if (!fileToCopy.exists()) {
                        LOGGER.log(Level.INFO, "Cannot copy file {0} to the Tomcat base dir, since it does not exist.", fileToCopy.getAbsolutePath());
                        continue;
                    }
                    try (FileInputStream is = new FileInputStream(fileToCopy);
                         FileOutputStream os = new FileOutputStream(targetFile);){
                        FileUtil.copy((InputStream)is, (OutputStream)os);
                    }
                    catch (IOException ioe) {
                        LOGGER.log(Level.INFO, null, ioe);
                    }
                } else if (!(this.copyAndPatch(new File(fromDir, files[i].substring(slash + 1)), targetFile, patternFrom[i], patternTo[i]) || "conf/Catalina/localhost/admin.xml".equals(files[i]) && !new File(fromDir, files[i].substring(slash + 1)).exists())) {
                    LOGGER.log(Level.INFO, "Cannot create config file {0}", files[i]);
                    continue;
                }
                if (!userReadOnly[i]) continue;
                if (targetFile.setReadable(false, false)) {
                    targetFile.setReadable(true);
                }
                if (!targetFile.setWritable(false, false)) continue;
                targetFile.setWritable(true);
            }
            if (new File(homeDir, "webapps/ROOT").exists()) {
                this.writeToFile(new File(baseDir, "conf/Catalina/localhost/ROOT.xml"), "<Context path=\"\" docBase=\"${catalina.home}/webapps/ROOT\"/>\n");
            }
            if (!this.isTomcat50() && !this.isTomcat55() && new File(homeDir, "webapps/manager").exists()) {
                this.writeToFile(new File(baseDir, "conf/Catalina/localhost/manager.xml"), "<Context docBase=\"${catalina.home}/webapps/manager\" antiResourceLocking=\"false\" privileged=\"true\"/>\n");
            }
            if (this.isTomEE() && (tomee = TomcatFactory.getTomEEWebAppJar(homeDir)) != null) {
                File folder = tomee.getParentFile().getParentFile();
                assert (folder != null);
                this.writeToFile(new File(baseDir, "conf/Catalina/localhost/" + folder.getName() + ".xml"), "<Context path=\"" + folder.getName() + "\" docBase=\"${catalina.home}/webapps/" + folder.getName() + "\"/>\n");
            }
            if (this.isBundledTomcat()) {
                TomcatInstallUtil.patchCatalinaProperties(new File(baseDir, "conf/catalina.properties"));
                TomcatInstallUtil.createNBLibDirectory(baseDir);
            }
        }
        catch (IOException ioe) {
            LOGGER.log(Level.INFO, null, ioe);
            return null;
        }
        if (this.isBundledTomcat()) {
            TomcatInstallUtil.patchBundledServerXml(new File(baseDir, "conf/server.xml"));
        }
        return baseDir;
    }

    private void writeToFile(File file, String data) throws IOException {
        try (BufferedWriter bw = new BufferedWriter(new FileWriter(file));){
            bw.write(data);
        }
    }

    private boolean copyAndPatch(File src, File dst, String from, String to) {
        if (!src.exists()) {
            return false;
        }
        try (BufferedReader r = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(src), StandardCharsets.UTF_8));
             BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(dst), StandardCharsets.UTF_8));){
            int len;
            StringBuilder sb = new StringBuilder();
            char[] BUFFER = new char[4096];
            while ((len = r.read(BUFFER)) != -1) {
                sb.append(BUFFER, 0, len);
            }
            int idx = sb.toString().indexOf(from);
            if (idx >= 0) {
                sb.replace(idx, idx + from.length(), to);
            } else {
                LOGGER.log(Level.INFO, "Pattern {0} not found in {1}", new Object[]{from, src.getPath()});
            }
            out.write(sb.toString());
        }
        catch (IOException ioe) {
            LOGGER.log(Level.INFO, null, ioe);
            return false;
        }
        return true;
    }

    public void openLog(TargetModuleID module) {
        TomcatModule tomcatModule = null;
        if (module instanceof TomcatModule) {
            tomcatModule = (TomcatModule)module;
        } else {
            try {
                TargetModuleID[] tomMod = this.getRunningModules(ModuleType.WAR, new Target[]{module.getTarget()});
                for (int i = 0; i < tomMod.length; ++i) {
                    if (!module.getModuleID().equals(tomMod[i].getModuleID())) continue;
                    tomcatModule = (TomcatModule)tomMod[i];
                    break;
                }
            }
            catch (TargetException te) {
                LOGGER.log(Level.INFO, null, te);
            }
        }
        if (tomcatModule != null && this.logManager.hasContextLogger(tomcatModule)) {
            this.logManager.openContextLog(tomcatModule);
        } else {
            this.logManager.openSharedContextLog();
        }
    }

    public synchronized TomcatManagerConfig getTomcatManagerConfig() {
        if (this.tomcatManagerConfig == null) {
            this.tomcatManagerConfig = new TomcatManagerConfig(this.tp.getServerXml());
        }
        return this.tomcatManagerConfig;
    }

    public LogManager logManager() {
        return this.logManager;
    }

    public synchronized void setTomcatProcess(Process p) {
        this.process = p;
    }

    public synchronized Process getTomcatProcess() {
        return this.process;
    }

    public void terminate() {
        Process proc = this.getTomcatProcess();
        if (proc != null) {
            HashMap<String, String> env = new HashMap<String, String>();
            env.put(KEY_UUID, this.uri);
            ExternalProcessSupport.destroy((Process)this.process, env);
        }
    }

    public synchronized TomcatPlatformImpl getTomcatPlatform() {
        if (this.tomcatPlatform == null) {
            this.tomcatPlatform = new TomcatPlatformImpl(this);
        }
        return this.tomcatPlatform;
    }

    public static enum TomcatVersion {
        TOMCAT_50(50),
        TOMCAT_55(55),
        TOMCAT_60(60),
        TOMCAT_70(70),
        TOMCAT_80(80),
        TOMCAT_90(90),
        TOMCAT_100(100),
        TOMCAT_101(101),
        TOMCAT_110(110);

        private final int version;

        private TomcatVersion(int version) {
            this.version = version;
        }

        public int version() {
            return this.version;
        }

        public boolean isAtLeast(TomcatVersion tv) {
            int comparisonResult = this.compareTo(tv);
            return comparisonResult >= 0;
        }
    }

    public static enum TomEEVersion {
        TOMEE_15(15),
        TOMEE_16(16),
        TOMEE_17(17),
        TOMEE_70(70),
        TOMEE_71(71),
        TOMEE_80(80),
        TOMEE_90(90),
        TOMEE_100(100);

        private final int version;

        private TomEEVersion(int version) {
            this.version = version;
        }

        public int version() {
            return this.version;
        }

        public boolean isAtLeast(TomEEVersion teev) {
            int comparisonResult = this.compareTo(teev);
            return comparisonResult >= 0;
        }
    }

    public static enum TomEEType {
        TOMEE_OPENEJB,
        TOMEE_WEBPROFILE,
        TOMEE_JAXRS,
        TOMEE_MICROPROFILE,
        TOMEE_PLUS,
        TOMEE_PLUME;

    }
}

