/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tomcat5;

import java.io.File;
import org.netbeans.modules.tomcat5.TomcatFactory;
import org.netbeans.modules.tomcat5.deploy.TomcatManager;
import org.netbeans.modules.tomcat5.util.TomcatProperties;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileRenameEvent;

public class TomEEWarListener
implements FileChangeListener {
    private final TomcatProperties tp;
    private final RefreshHook refresh;
    private File currentTomEEJar;

    public TomEEWarListener(TomcatProperties tp, RefreshHook refresh) {
        this.tp = tp;
        this.refresh = refresh;
    }

    public void fileFolderCreated(FileEvent fe) {
        this.checkAndRefresh();
    }

    public void fileDataCreated(FileEvent fe) {
        this.checkAndRefresh();
    }

    public void fileChanged(FileEvent fe) {
        this.checkAndRefresh();
    }

    public void fileDeleted(FileEvent fe) {
        this.checkAndRefresh();
    }

    public void fileRenamed(FileRenameEvent fe) {
        this.checkAndRefresh();
    }

    public void fileAttributeChanged(FileAttributeEvent fe) {
    }

    public void checkAndRefresh() {
        File jar = TomcatFactory.getTomEEWebAppJar(this.tp.getCatalinaHome(), this.tp.getCatalinaBase());
        if (!(this.currentTomEEJar == jar || this.currentTomEEJar != null && this.currentTomEEJar.equals(jar))) {
            this.currentTomEEJar = jar;
            TomcatManager.TomEEVersion version = TomcatFactory.getTomEEVersion(jar);
            TomcatManager.TomEEType type = version == null ? null : TomcatFactory.getTomEEType(jar.getParentFile());
            this.refresh.refresh(version, type);
        }
    }

    public static interface RefreshHook {
        public void refresh(TomcatManager.TomEEVersion var1, TomcatManager.TomEEType var2);
    }
}

