/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.parsing.lucene;

import java.io.File;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.lucene.store.Lock;
import org.apache.lucene.store.LockFactory;
import org.apache.lucene.store.LockObtainFailedException;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.openide.util.Exceptions;

class RecordOwnerLockFactory
extends LockFactory {
    private final Map<String, RecordOwnerLock> locks = new HashMap<String, RecordOwnerLock>();

    RecordOwnerLockFactory() throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Lock makeLock(String lockName) {
        Map<String, RecordOwnerLock> map = this.locks;
        synchronized (map) {
            RecordOwnerLock res = this.locks.get(lockName);
            if (res == null) {
                res = new RecordOwnerLock();
                this.locks.put(lockName, res);
            }
            return res;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearLock(String lockName) throws IOException {
        Map<String, RecordOwnerLock> map = this.locks;
        synchronized (map) {
            RecordOwnerLock lock = this.locks.remove(lockName);
            if (lock != null) {
                lock.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean hasLocks() {
        Map<String, RecordOwnerLock> map = this.locks;
        synchronized (map) {
            boolean res = false;
            for (RecordOwnerLock lock : this.locks.values()) {
                res |= lock.isLocked();
            }
            return res;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Collection<? extends Lock> forceClearLocks() {
        Map<String, RecordOwnerLock> map = this.locks;
        synchronized (map) {
            ArrayDeque<RecordOwnerLock> locked = new ArrayDeque<RecordOwnerLock>();
            Iterator<RecordOwnerLock> it = this.locks.values().iterator();
            while (it.hasNext()) {
                RecordOwnerLock lock = it.next();
                if (!lock.isLocked()) continue;
                it.remove();
                locked.offer(lock);
            }
            return locked;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(((Object)((Object)this)).getClass().getSimpleName());
        sb.append('[');
        Map<String, RecordOwnerLock> map = this.locks;
        synchronized (map) {
            boolean first = true;
            for (Map.Entry<String, RecordOwnerLock> e : this.locks.entrySet()) {
                if (!first) {
                    sb.append('\n');
                } else {
                    first = false;
                }
                sb.append("name: ").append(e.getKey()).append("->").append((Object)e.getValue());
            }
        }
        sb.append("]\n");
        return sb.toString();
    }

    static <T extends Exception> T annotateException(@NonNull T e, @NullAllowed File indexDir, @NullAllowed Map<Thread, StackTraceElement[]> threads) {
        return RecordOwnerLockFactory.annotateException(e, indexDir, threads, null);
    }

    private static <T extends Exception> T annotateException(@NonNull T e, @NullAllowed File indexDir, @NullAllowed Map<Thread, StackTraceElement[]> threads, @NullAllowed LockFactory lockFactory) {
        StringBuilder message = new StringBuilder();
        if (indexDir != null) {
            File[] children = indexDir.listFiles();
            if (children == null) {
                message.append("Non existing index folder");
            } else {
                for (File c : children) {
                    message.append(c.getName()).append(" f: ").append(c.isFile()).append(" r: ").append(c.canRead()).append(" w: ").append(c.canWrite()).append("\n");
                }
            }
        }
        if (threads != null) {
            Thread ct = Thread.currentThread();
            message.append("current thread: ").append(ct).append('(').append(ct.getId()).append(')');
            message.append("threads: \n");
            RecordOwnerLockFactory.stackTraces(threads, message);
        }
        if (lockFactory != null) {
            message.append("lockFactory: ").append(lockFactory);
        }
        return (T)((Exception)Exceptions.attachMessage(e, (String)message.toString()));
    }

    private static void stackTraces(@NonNull Map<Thread, StackTraceElement[]> traces, @NonNull StringBuilder sb) {
        for (Map.Entry<Thread, StackTraceElement[]> entry : traces.entrySet()) {
            Thread t = entry.getKey();
            sb.append(t).append('(').append(t.getId()).append(")\n");
            RecordOwnerLockFactory.stackTrace(entry.getValue(), sb);
        }
    }

    private static void stackTrace(@NonNull StackTraceElement[] stack, @NonNull StringBuilder sb) {
        for (StackTraceElement se : stack) {
            sb.append('\t').append(se).append('\n');
        }
    }

    private final class RecordOwnerLock
    extends Lock {
        private Thread owner;
        private Exception caller;

        private RecordOwnerLock() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean obtain() {
            Map map = RecordOwnerLockFactory.this.locks;
            synchronized (map) {
                if (this.owner == null) {
                    this.owner = Thread.currentThread();
                    this.caller = new Exception();
                    return true;
                }
                return false;
            }
        }

        public boolean obtain(long lockWaitTimeout) throws LockObtainFailedException, IOException {
            try {
                return super.obtain(lockWaitTimeout);
            }
            catch (LockObtainFailedException e) {
                throw (LockObtainFailedException)((Object)RecordOwnerLockFactory.annotateException((Exception)((Object)e), null, Thread.getAllStackTraces(), RecordOwnerLockFactory.this));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void release() {
            Map map = RecordOwnerLockFactory.this.locks;
            synchronized (map) {
                this.owner = null;
                this.caller = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isLocked() {
            Map map = RecordOwnerLockFactory.this.locks;
            synchronized (map) {
                return this.owner != null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            Map map = RecordOwnerLockFactory.this.locks;
            synchronized (map) {
                StringBuilder sb = new StringBuilder();
                sb.append(((Object)((Object)this)).getClass().getSimpleName());
                sb.append("owned by:[");
                sb.append(this.owner);
                sb.append('(').append(this.owner == null ? -1L : this.owner.getId()).append(')');
                sb.append("created from:\n");
                RecordOwnerLockFactory.stackTrace(this.caller == null ? new StackTraceElement[]{} : this.caller.getStackTrace(), sb);
                return sb.toString();
            }
        }
    }
}

