/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.projectimport.eclipse.core;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.logging.Logger;
import org.netbeans.modules.projectimport.eclipse.core.DotClassPath;
import org.netbeans.modules.projectimport.eclipse.core.DotClassPathParser;
import org.netbeans.modules.projectimport.eclipse.core.EclipseProject;
import org.netbeans.modules.projectimport.eclipse.core.Link;
import org.netbeans.modules.projectimport.eclipse.core.ProjectImporterException;
import org.netbeans.modules.projectimport.eclipse.core.ProjectParser;
import org.netbeans.modules.projectimport.eclipse.core.Workspace;
import org.netbeans.modules.projectimport.eclipse.core.WorkspaceFactory;

public final class ProjectFactory {
    private static final Logger logger = Logger.getLogger(ProjectFactory.class.getName());
    private static ProjectFactory instance = new ProjectFactory();

    private ProjectFactory() {
    }

    public static ProjectFactory getInstance() {
        return instance;
    }

    public EclipseProject load(File projectDir) throws ProjectImporterException {
        return this.load(projectDir, projectDir.getParentFile());
    }

    public EclipseProject load(File projectDir, File workspaceDir) throws ProjectImporterException {
        Workspace workspace = null;
        if (workspaceDir != null) {
            workspace = WorkspaceFactory.getInstance().load(workspaceDir);
        }
        return this.load(projectDir, workspace);
    }

    private EclipseProject load(File projectDir, Workspace workspace) throws ProjectImporterException {
        EclipseProject project;
        if (workspace != null && (project = workspace.getProjectByProjectDir(projectDir)) != null) {
            return project;
        }
        project = EclipseProject.createProject(projectDir);
        if (project != null) {
            project.setWorkspace(workspace);
            this.loadDotProject(project);
            this.loadDotClassPath(project);
        }
        return project;
    }

    void loadDotProject(EclipseProject project) throws ProjectImporterException {
        logger.finest("Loading .project for project: " + project.getDirectory().getAbsolutePath());
        try {
            HashSet<String> natures = new HashSet<String>();
            ArrayList<Link> links = new ArrayList<Link>();
            HashSet<Workspace.Variable> variables = new HashSet();
            if (project.getWorkspace() != null) {
                variables = project.getWorkspace().getResourcesVariables();
            }
            String projName = ProjectParser.parse(project.getProjectFile(), natures, links, variables);
            project.setNatures(natures);
            project.setName(projName);
            project.setFacets(ProjectParser.readProjectFacets(project.getDirectory(), natures));
            project.setLinks(links);
        }
        catch (IOException ex) {
            throw new ProjectImporterException(ex);
        }
    }

    void loadDotClassPath(EclipseProject project) throws ProjectImporterException {
        assert (project.getNatures() != null);
        logger.finest("Loading .classpath for project: " + project.getDirectory().getAbsolutePath());
        try {
            DotClassPath dotClassPath = project.getClassPathFile() != null ? DotClassPathParser.parse(project.getClassPathFile(), project.getLinks()) : DotClassPathParser.empty();
            project.setClassPath(dotClassPath);
        }
        catch (IOException ex) {
            throw new ProjectImporterException(ex);
        }
    }
}

