/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.projectimport.eclipse.core;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.projectimport.eclipse.core.EclipseProject;
import org.netbeans.modules.projectimport.eclipse.core.EclipseProjectReference;
import org.netbeans.modules.projectimport.eclipse.core.JavaPlatformSupport;
import org.netbeans.modules.projectimport.eclipse.core.Util;
import org.netbeans.modules.projectimport.eclipse.core.spi.ProjectImportModel;
import org.netbeans.modules.projectimport.eclipse.core.spi.ProjectTypeUpdater;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileUtil;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;

final class Importer {
    private static final Logger logger = Logger.getLogger(Importer.class.getName());
    private final List<EclipseProject> eclProjects;
    private final String destination;
    private final List<Project> nbProjects;
    private int nOfProcessed;
    private String progressInfo;
    private List<String> warnings = new ArrayList<String>();
    private Task task = null;
    private List<WizardDescriptor.Panel<WizardDescriptor>> extraPanels;

    Importer(List<EclipseProject> eclProjects, String destination, List<WizardDescriptor.Panel<WizardDescriptor>> extraPanels) {
        this.eclProjects = eclProjects;
        this.destination = destination;
        this.nbProjects = new ArrayList<Project>();
        this.extraPanels = extraPanels;
    }

    void startImporting() {
        this.task = RequestProcessor.getDefault().post(new Runnable(){

            @Override
            public void run() {
                for (EclipseProject eclPrj : Importer.this.eclProjects) {
                    Project p = Importer.this.importProject(eclPrj, Importer.this.warnings);
                    if (p == null) continue;
                    Importer.this.nbProjects.add(p);
                }
            }
        });
    }

    int getNOfProcessed() {
        return this.nOfProcessed;
    }

    String getProgressInfo() {
        return this.progressInfo;
    }

    boolean isDone() {
        return this.task != null && this.task.isFinished();
    }

    List<String> getWarnings() {
        return this.warnings;
    }

    Project[] getProjects() {
        return this.nbProjects.toArray(new Project[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Project importProject(final EclipseProject eclProject, final List<String> importProblems) {
        assert (eclProject != null) : "Eclipse project cannot be null";
        final ArrayList<String> projectImportProblems = new ArrayList<String>();
        projectImportProblems.addAll(eclProject.getImportProblems());
        try {
            Boolean res = (Boolean)ProjectManager.mutex().writeAccess((Mutex.Action)new Mutex.Action<Boolean>(){

                public Boolean run() {
                    try {
                        Importer.this.importProjectStage0(eclProject, projectImportProblems);
                    }
                    catch (Throwable ex) {
                        logger.log(Level.SEVERE, "import of Eclipse project " + eclProject.getDirectory().getPath() + " failed", ex);
                        projectImportProblems.add(NbBundle.getMessage(Importer.class, (String)"MSG_ImportFailed", (Object)ex.getMessage()));
                        return Boolean.FALSE;
                    }
                    return Boolean.TRUE;
                }
            });
            if (!res.booleanValue()) {
                Project project = null;
                return project;
            }
            Project project = (Project)ProjectManager.mutex().writeAccess((Mutex.Action)new Mutex.Action<Project>(){

                public Project run() {
                    try {
                        return Importer.this.importProjectStage1(eclProject, importProblems, projectImportProblems);
                    }
                    catch (Throwable ex) {
                        logger.log(Level.SEVERE, "import of Eclipse project " + eclProject.getDirectory().getPath() + " failed", ex);
                        projectImportProblems.add(NbBundle.getMessage(Importer.class, (String)"MSG_ImportFailed", (Object)ex.getMessage()));
                        return null;
                    }
                }
            });
            return project;
        }
        finally {
            if (projectImportProblems.size() > 0) {
                importProblems.add(NbBundle.getMessage(Importer.class, (String)"MSG_ImportResults", (Object)eclProject.getName()));
                for (String s : projectImportProblems) {
                    importProblems.add(" " + s);
                }
            }
        }
    }

    private void importProjectStage0(EclipseProject eclProject, List<String> projectImportProblems) throws IOException {
        eclProject.resolveContainers(projectImportProblems, true);
        eclProject.setupEnvironmentVariables(projectImportProblems);
        eclProject.removeInvalidSourceRoots(projectImportProblems);
    }

    private Project importProjectStage1(EclipseProject eclProject, List<String> importProblems, List<String> projectImportProblems) throws IOException {
        Project p;
        ++this.nOfProcessed;
        this.progressInfo = NbBundle.getMessage(Importer.class, (String)"MSG_Progress_ProcessingProject", (Object)eclProject.getName());
        Project alreadyImported = null;
        File dest = this.destination == null ? eclProject.getDirectory() : FileUtil.normalizeFile((File)new File(this.destination, eclProject.getDirectory().getName()));
        if (dest.exists()) {
            alreadyImported = ProjectManager.getDefault().findProject(FileUtil.toFileObject((File)dest));
        }
        ProjectImportModel model = new ProjectImportModel(eclProject, dest, JavaPlatformSupport.getJavaPlatformSupport().getJavaPlatform(eclProject, projectImportProblems), this.nbProjects, this.extraPanels);
        if (alreadyImported != null) {
            p = alreadyImported;
            projectImportProblems.add(NbBundle.getMessage(Importer.class, (String)"MSG_AlreadyImportedProjectFound"));
        } else {
            if (!eclProject.isImportSupported()) {
                importProblems.add(NbBundle.getMessage(Importer.class, (String)"MSG_UnknownProject"));
                return null;
            }
            p = eclProject.getProjectTypeFactory().createProject(model, projectImportProblems);
            if (p != null && eclProject.getProjectTypeFactory() instanceof ProjectTypeUpdater) {
                ProjectTypeUpdater updater = (ProjectTypeUpdater)eclProject.getProjectTypeFactory();
                String key = updater.calculateKey(model);
                EclipseProjectReference ref = new EclipseProjectReference(p, eclProject.getDirectory().getAbsolutePath(), eclProject.getWorkspace() != null ? eclProject.getWorkspace().getDirectory().getAbsolutePath() : null, 0L, key);
                EclipseProjectReference.write(p, ref);
                ProjectManager.getDefault().saveProject(p);
            }
            if (p != null) {
                Util.logUsage(Importer.class, "USG_PROJECT_ECLIPSE_IMPORT", eclProject.getProjectTypeFactory().getProjectTypeName(), eclProject.getWorkspace() != null ? "true" : "false", this.destination == null ? "true" : "false", projectImportProblems.size());
            }
        }
        return p;
    }

    private void logWarning(String message) {
        this.logWarning(message, false);
    }

    private void logWarning(String message, boolean isGUIWarning) {
        if (isGUIWarning) {
            this.warnings.add(message);
        }
        logger.warning(message);
    }
}

