/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javafx2.editor.codegen;

import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.Scope;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.javafx2.editor.codegen.AddFxPropertyConfig;
import org.netbeans.modules.javafx2.editor.codegen.GeneratorUtils;

public class AddJavaFXPropertyMaker {
    private WorkingCopy javac;
    private Scope scope;
    private TreeMaker make;
    private AddFxPropertyConfig config;
    private String getterMethod;
    private boolean hasGet;

    public AddJavaFXPropertyMaker(WorkingCopy javac, Scope scope, TreeMaker make, AddFxPropertyConfig config) {
        this.javac = javac;
        this.scope = scope;
        this.make = make;
        this.config = config;
    }

    private MethodTree createGetter(ModifiersTree mods, TypeMirror valueType) {
        StringBuilder getterName = GeneratorUtils.getCapitalizedName(this.config.getName());
        getterName.insert(0, valueType.getKind() == TypeKind.BOOLEAN ? "is" : "get");
        ReturnTree returnTree = this.make.Return((ExpressionTree)this.make.MethodInvocation(Collections.emptyList(), (ExpressionTree)this.make.MemberSelect((ExpressionTree)this.make.Identifier((CharSequence)this.config.getName()), (CharSequence)(this.hasGet ? "get" : "getValue")), Collections.emptyList()));
        BlockTree getterBody = this.make.Block(Collections.singletonList(returnTree), false);
        Tree valueTree = valueType.getKind() == TypeKind.DECLARED ? this.make.QualIdent(((DeclaredType)valueType).asElement()) : (valueType.getKind().isPrimitive() ? this.make.PrimitiveType(valueType.getKind()) : this.make.Identifier((CharSequence)valueType.toString()));
        MethodTree getter = this.make.Method(mods, (CharSequence)getterName, valueTree, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), getterBody, null);
        return getter;
    }

    private MethodTree createSetter(ModifiersTree mods, TypeMirror valueType) {
        StringBuilder getterName = GeneratorUtils.getCapitalizedName(this.config.getName());
        getterName.insert(0, "set");
        Tree valueTree = valueType.getKind() == TypeKind.DECLARED ? this.make.QualIdent(((DeclaredType)valueType).asElement()) : (valueType.getKind().isPrimitive() ? this.make.PrimitiveType(valueType.getKind()) : this.make.Identifier((CharSequence)valueType.toString()));
        ExpressionStatementTree statement = this.make.ExpressionStatement((ExpressionTree)this.make.MethodInvocation(Collections.emptyList(), (ExpressionTree)this.make.MemberSelect((ExpressionTree)this.make.Identifier((CharSequence)this.config.getName()), (CharSequence)(this.hasGet ? "set" : "setValue")), Collections.singletonList(this.make.Identifier((CharSequence)"value"))));
        BlockTree getterBody = this.make.Block(Collections.singletonList(statement), false);
        VariableTree var = this.make.Variable(this.make.Modifiers(EnumSet.noneOf(Modifier.class)), (CharSequence)"value", valueTree, null);
        MethodTree getter = this.make.Method(mods, (CharSequence)getterName, (Tree)this.make.PrimitiveType(TypeKind.VOID), Collections.emptyList(), Collections.singletonList(var), Collections.emptyList(), getterBody, null);
        return getter;
    }

    private MethodTree createProperty(ModifiersTree mods, DeclaredType selectedType, ExecutableElement wrapperMethod) {
        String getterName = this.config.getName() + "Property";
        ExpressionTree expression = wrapperMethod == null ? this.make.Identifier((CharSequence)this.config.getName()) : this.make.MethodInvocation(Collections.emptyList(), (ExpressionTree)this.make.MemberSelect((ExpressionTree)this.make.Identifier((CharSequence)this.config.getName()), (CharSequence)wrapperMethod.getSimpleName()), Collections.emptyList());
        ReturnTree returnTree = this.make.Return(expression);
        BlockTree getterBody = this.make.Block(Collections.singletonList(returnTree), false);
        MethodTree getter = this.make.Method(mods, (CharSequence)getterName, (Tree)(selectedType == null ? this.make.Identifier((CharSequence)this.config.getPropertyType()) : this.make.QualIdent(selectedType.asElement())), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), getterBody, null);
        return getter;
    }

    public List<Tree> createMembers() {
        VariableTree field;
        DeclaredType implementationType;
        Elements elements = this.javac.getElements();
        TypeElement readOnlyProperty = elements.getTypeElement("javafx.beans.property.ReadOnlyProperty");
        TypeElement property = elements.getTypeElement("javafx.beans.property.Property");
        if (readOnlyProperty == null || property == null) {
            return null;
        }
        String type = this.config.getPropertyType();
        TreeUtilities treeUtilities = this.javac.getTreeUtilities();
        DeclaredType selectedType = (DeclaredType)treeUtilities.parseType(type, this.scope.getEnclosingClass());
        if (selectedType == null || selectedType.getKind() == TypeKind.ERROR) {
            selectedType = (DeclaredType)treeUtilities.parseType("javafx.beans.property." + type, this.scope.getEnclosingClass());
        }
        TypeMirror valueType = this.findValueType(selectedType);
        String implTypeDef = this.config.getImplementationType();
        int diamond = implTypeDef.indexOf("<>");
        if (diamond > -1) {
            implTypeDef = implTypeDef.substring(0, diamond);
        }
        if ((implementationType = (DeclaredType)treeUtilities.parseType(implTypeDef, this.scope.getEnclosingClass())) == null || implementationType.getKind() == TypeKind.ERROR) {
            implementationType = (DeclaredType)treeUtilities.parseType("javafx.beans.property." + implTypeDef, this.scope.getEnclosingClass());
        }
        ExpressionTree implTypeTree = diamond != -1 ? (ExpressionTree)((Object)this.make.ParameterizedType(this.make.Type((TypeMirror)implementationType), Collections.emptyList())) : this.getTypeTree(implementationType);
        boolean writable = this.config.getGenerate() == AddFxPropertyConfig.GENERATE.WRITABLE;
        ModifiersTree mods = this.createMods();
        ExecutableElement wrapperMethod = null;
        if (writable || implementationType == null) {
            field = this.createField(selectedType, implTypeTree);
        } else {
            List<ExecutableElement> methods = ElementFilter.methodsIn(this.javac.getElements().getAllMembers((TypeElement)implementationType.asElement()));
            for (ExecutableElement executableElement : methods) {
                DeclaredType declaredType;
                if (selectedType != null && this.javac.getTypes().isSubtype(executableElement.getReturnType(), selectedType)) {
                    wrapperMethod = executableElement;
                    break;
                }
                if (executableElement.getReturnType().getKind() != TypeKind.DECLARED || !(declaredType = (DeclaredType)executableElement.getReturnType()).asElement().getSimpleName().contentEquals(this.config.getPropertyType())) continue;
                wrapperMethod = executableElement;
                break;
            }
            field = wrapperMethod != null ? this.createField(implementationType, implTypeTree) : this.createField(selectedType, implTypeTree);
        }
        MethodTree getter = this.createGetter(mods, valueType);
        MethodTree setter = null;
        if (writable) {
            setter = this.createSetter(mods, valueType);
        }
        MethodTree methodTree = this.createProperty(mods, selectedType, wrapperMethod);
        return writable ? Arrays.asList(field, getter, setter, methodTree) : Arrays.asList(field, getter, methodTree);
    }

    private VariableTree createField(DeclaredType selectedType, ExpressionTree implementationType) {
        String initializer = this.config.getInitializer();
        NewClassTree newClass = this.make.NewClass(null, Collections.emptyList(), implementationType, Collections.singletonList(this.make.Identifier((CharSequence)initializer)), null);
        VariableTree property = this.make.Variable(this.make.Modifiers(EnumSet.of(Modifier.PRIVATE, Modifier.FINAL)), (CharSequence)this.config.getName(), (Tree)this.getTypeTree(selectedType), (ExpressionTree)newClass);
        return property;
    }

    private ModifiersTree createMods() {
        ModifiersTree mods;
        AddFxPropertyConfig.ACCESS access = this.config.getAccess();
        switch (access) {
            case PACKAGE: {
                mods = this.make.Modifiers(EnumSet.noneOf(Modifier.class));
                break;
            }
            case PRIVATE: {
                mods = this.make.Modifiers(EnumSet.of(Modifier.PRIVATE));
                break;
            }
            case PROTECTED: {
                mods = this.make.Modifiers(EnumSet.of(Modifier.PROTECTED));
                break;
            }
            default: {
                mods = this.make.Modifiers(EnumSet.of(Modifier.PUBLIC));
            }
        }
        return mods;
    }

    private TypeMirror findValueType(TypeMirror selectedType) {
        Types types = this.javac.getTypes();
        TypeMirror valueType = null;
        if (selectedType != null && selectedType.getKind() == TypeKind.DECLARED) {
            DeclaredType declaredType = (DeclaredType)selectedType;
            List<ExecutableElement> methods = ElementFilter.methodsIn(this.javac.getElements().getAllMembers((TypeElement)declaredType.asElement()));
            for (ExecutableElement executableElement : methods) {
                ExecutableType member;
                if (executableElement.getSimpleName().contentEquals("get") && executableElement.getParameters().isEmpty()) {
                    this.hasGet = true;
                    member = (ExecutableType)types.asMemberOf(declaredType, executableElement);
                    valueType = member.getReturnType();
                    break;
                }
                if (!executableElement.getSimpleName().contentEquals("getValue") || !executableElement.getParameters().isEmpty()) continue;
                this.hasGet = false;
                member = (ExecutableType)types.asMemberOf(declaredType, executableElement);
                valueType = member.getReturnType();
            }
        }
        if (valueType == null) {
            valueType = this.javac.getElements().getTypeElement(Object.class.getName()).asType();
        }
        return valueType;
    }

    private ExpressionTree getTypeTree(DeclaredType type) {
        ExpressionTree ident = this.make.QualIdent(type.asElement());
        List<? extends TypeMirror> arguments = type.getTypeArguments();
        ArrayList<Tree> newArguments = new ArrayList<Tree>(arguments.size());
        for (TypeMirror typeMirror : arguments) {
            newArguments.add(this.make.Type(typeMirror));
        }
        if (!newArguments.isEmpty()) {
            ident = (ExpressionTree)((Object)this.make.ParameterizedType((Tree)ident, newArguments));
        }
        return ident;
    }
}

