/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.spi;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.Tree;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.lang.model.element.Element;
import javax.lang.model.type.TypeKind;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.java.RefactoringUtils;
import org.netbeans.modules.refactoring.java.api.JavaRefactoringUtils;
import org.netbeans.modules.refactoring.java.plugins.FindVisitor;
import org.netbeans.modules.refactoring.java.plugins.JavaPluginUtils;
import org.netbeans.modules.refactoring.java.spi.DiffElement;
import org.netbeans.modules.refactoring.java.spi.RefactoringVisitor;
import org.netbeans.modules.refactoring.java.spi.ToPhaseException;
import org.netbeans.modules.refactoring.java.spi.hooks.JavaModificationResult;
import org.netbeans.modules.refactoring.spi.ModificationResult;
import org.netbeans.modules.refactoring.spi.ProgressProviderAdapter;
import org.netbeans.modules.refactoring.spi.RefactoringCommit;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.spi.RefactoringPlugin;
import org.netbeans.modules.refactoring.spi.Transaction;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public abstract class JavaRefactoringPlugin
extends ProgressProviderAdapter
implements RefactoringPlugin {
    @Deprecated
    protected volatile boolean cancelRequest = false;
    protected final AtomicBoolean cancelRequested = new AtomicBoolean();
    private volatile CancellableTask currentTask;
    private WorkingTask workingTask = new WorkingTask();
    private static final ClassPath EMPTY_PATH = ClassPathSupport.createClassPath((URL[])new URL[0]);

    public static Transaction createTransaction(@NonNull Collection<org.netbeans.api.java.source.ModificationResult> modifications) {
        return new RefactoringCommit(JavaRefactoringPlugin.createJavaModifications(modifications));
    }

    private static Collection<ModificationResult> createJavaModifications(Collection<org.netbeans.api.java.source.ModificationResult> modifications) {
        LinkedList<ModificationResult> result = new LinkedList<ModificationResult>();
        for (org.netbeans.api.java.source.ModificationResult r : modifications) {
            result.add(new JavaModificationResult(r));
        }
        return result;
    }

    protected Problem preCheck(CompilationController javac) throws IOException {
        return null;
    }

    protected Problem checkParameters(CompilationController javac) throws IOException {
        return null;
    }

    protected Problem fastCheckParameters(CompilationController javac) throws IOException {
        return null;
    }

    protected abstract JavaSource getJavaSource(Phase var1);

    public Problem preCheck() {
        this.cancelRequest = false;
        this.cancelRequested.set(false);
        return this.workingTask.run(Phase.PRECHECK);
    }

    public Problem checkParameters() {
        return this.workingTask.run(Phase.CHECKPARAMETERS);
    }

    public Problem fastCheckParameters() {
        return this.workingTask.run(Phase.FASTCHECKPARAMETERS);
    }

    public void cancelRequest() {
        this.cancelRequest = true;
        this.cancelRequested.set(true);
        if (this.currentTask != null) {
            this.currentTask.cancel();
        }
    }

    protected ClasspathInfo getClasspathInfo(AbstractRefactoring refactoring) {
        ClasspathInfo cpInfo = (ClasspathInfo)refactoring.getContext().lookup(ClasspathInfo.class);
        if (cpInfo == null) {
            Collection handles = refactoring.getRefactoringSource().lookupAll(TreePathHandle.class);
            cpInfo = !handles.isEmpty() ? RefactoringUtils.getClasspathInfoFor(handles.toArray(new TreePathHandle[0])) : JavaRefactoringUtils.getClasspathInfoFor(new FileObject[]{null});
            refactoring.getContext().add((Object)cpInfo);
        }
        return cpInfo;
    }

    protected static Problem createProblem(Problem result, boolean isFatal, String message) {
        Problem problem = new Problem(isFatal, message);
        return JavaPluginUtils.chainProblems(result, problem);
    }

    protected static Problem isElementAvail(TreePathHandle e, CompilationInfo info) {
        String elName;
        if (e == null) {
            return new Problem(true, NbBundle.getMessage(FindVisitor.class, (String)"DSC_ElNotAvail"));
        }
        Element el = e.resolveElement(info);
        String string = elName = el != null ? el.getSimpleName().toString() : null;
        if (el == null || el.asType().getKind() == TypeKind.ERROR || "<error>".equals(elName)) {
            return new Problem(true, NbBundle.getMessage(FindVisitor.class, (String)"DSC_ElementNotResolved"));
        }
        if ("this".equals(elName) || "super".equals(elName)) {
            return new Problem(true, NbBundle.getMessage(FindVisitor.class, (String)"ERR_CannotRefactorThis", (Object)el.getSimpleName()));
        }
        return null;
    }

    private Map<FileObject, List<FileObject>> groupByRoot(Set<FileObject> sourceFiles) {
        LinkedHashMap<FileObject, List<FileObject>> result = new LinkedHashMap<FileObject, List<FileObject>>();
        for (FileObject file : sourceFiles) {
            List<Object> subr;
            FileObject root;
            if (this.cancelRequested.get()) {
                return Collections.emptyMap();
            }
            ClassPath cp = ClassPath.getClassPath((FileObject)file, (String)"classpath/source");
            if (cp != null) {
                root = cp.findOwnerRoot(file);
                if (root == null) continue;
                subr = (List)result.get(root);
                if (subr == null) {
                    subr = new LinkedList();
                    result.put(root, subr);
                }
                subr.add(file);
                continue;
            }
            root = FileUtil.getArchiveFile((FileObject)file);
            if (root == null) continue;
            subr = (LinkedList<FileObject>)result.get(root);
            if (subr == null) {
                subr = new LinkedList<FileObject>();
                result.put(root, subr);
            }
            subr.add(file);
        }
        return result;
    }

    protected final Collection<org.netbeans.api.java.source.ModificationResult> processFiles(Set<FileObject> files, CancellableTask<WorkingCopy> task) throws IOException {
        return this.processFiles(files, task, null);
    }

    protected final Collection<org.netbeans.api.java.source.ModificationResult> processFiles(Set<FileObject> files, CancellableTask<WorkingCopy> task, ClasspathInfo info) throws IOException {
        return this.processFiles(files, task, info, true);
    }

    protected final void queryFiles(Set<FileObject> files, CancellableTask<? extends CompilationController> task) throws IOException {
        this.queryFiles(files, task, null);
    }

    protected final void queryFiles(Set<FileObject> files, CancellableTask<? extends CompilationController> task, ClasspathInfo info) throws IOException {
        this.processFiles(files, task, info, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<org.netbeans.api.java.source.ModificationResult> processFiles(Set<FileObject> sourceFiles, CancellableTask<? extends CompilationController> task, ClasspathInfo info, boolean modification) throws IOException {
        this.currentTask = task;
        LinkedList<org.netbeans.api.java.source.ModificationResult> results = new LinkedList<org.netbeans.api.java.source.ModificationResult>();
        try {
            Map<FileObject, List<FileObject>> work = this.groupByRoot(sourceFiles);
            this.processFiles(work, info, modification, results, task);
        }
        finally {
            this.currentTask = null;
        }
        return results;
    }

    private void processFiles(Map<FileObject, List<FileObject>> work, ClasspathInfo info, boolean modification, Collection<org.netbeans.api.java.source.ModificationResult> results, CancellableTask<? extends CompilationController> task) throws IOException, IllegalArgumentException {
        for (Map.Entry<FileObject, List<FileObject>> entry : work.entrySet()) {
            if (this.cancelRequested.get()) {
                results.clear();
                return;
            }
            FileObject root = entry.getKey();
            if (info == null) {
                ClassPath srcPath;
                ClassPath executePath;
                ClassPath moduleCompilePath;
                ClassPath moduleClassPath;
                ClassPath compilePath;
                ClassPath moduleBootPath;
                ClassPath bootPath = ClassPath.getClassPath((FileObject)root, (String)"classpath/boot");
                if (bootPath == null) {
                    bootPath = JavaPlatformManager.getDefault().getDefaultPlatform().getBootstrapLibraries();
                }
                if ((moduleBootPath = ClassPath.getClassPath((FileObject)root, (String)"modules/boot")) == null) {
                    moduleBootPath = EMPTY_PATH;
                }
                if ((compilePath = ClassPath.getClassPath((FileObject)root, (String)"classpath/compile")) == null) {
                    compilePath = EMPTY_PATH;
                }
                if ((moduleClassPath = ClassPath.getClassPath((FileObject)root, (String)"modules/classpath")) == null) {
                    moduleClassPath = EMPTY_PATH;
                }
                if ((moduleCompilePath = ClassPath.getClassPath((FileObject)root, (String)"modules/compile")) == null) {
                    moduleCompilePath = EMPTY_PATH;
                }
                if ((executePath = ClassPath.getClassPath((FileObject)root, (String)"classpath/execute")) == null) {
                    executePath = EMPTY_PATH;
                }
                if ((srcPath = ClassPath.getClassPath((FileObject)root, (String)"classpath/source")) == null) {
                    srcPath = EMPTY_PATH;
                }
                info = new ClasspathInfo.Builder(bootPath).setModuleBootPath(moduleBootPath).setClassPath(ClassPathSupport.createProxyClassPath((ClassPath[])new ClassPath[]{compilePath, executePath})).setModuleClassPath(moduleClassPath).setModuleCompilePath(moduleCompilePath).setSourcePath(srcPath).build();
            }
            ArrayList<FileObject> augmentedFiles = new ArrayList<FileObject>((Collection)entry.getValue());
            FileObject fake = FileUtil.createMemoryFileSystem().getRoot().createData("Fake.java");
            if (!augmentedFiles.stream().anyMatch(fo -> SourceUtils.isClassFile((FileObject)fo))) {
                augmentedFiles.add(fake);
            }
            JavaSource javaSource = JavaSource.create((ClasspathInfo)info, augmentedFiles);
            if (modification) {
                results.add(javaSource.runModificationTask(cc -> {
                    if (cc.getFileObject() == fake) {
                        return;
                    }
                    task.run(cc);
                }));
                continue;
            }
            javaSource.runUserActionTask(cc -> {
                if (cc.getFileObject() == fake) {
                    return;
                }
                this.currentTask.run(cc);
            }, true);
        }
    }

    protected final Problem createAndAddElements(Set<FileObject> files, CancellableTask<WorkingCopy> task, RefactoringElementsBag elements, AbstractRefactoring refactoring, ClasspathInfo info) {
        try {
            Collection<org.netbeans.api.java.source.ModificationResult> results = this.processFiles(files, task, info);
            elements.registerTransaction(JavaRefactoringPlugin.createTransaction(results));
            for (org.netbeans.api.java.source.ModificationResult result : results) {
                for (FileObject jfo : result.getModifiedFileObjects()) {
                    for (ModificationResult.Difference dif : result.getDifferences(jfo)) {
                        elements.add(refactoring, (RefactoringElementImplementation)DiffElement.create(dif, jfo, result));
                    }
                }
            }
        }
        catch (IOException e) {
            return this.createProblemAndLog(null, e);
        }
        return null;
    }

    protected final Problem createAndAddElements(Set<FileObject> files, CancellableTask<WorkingCopy> task, RefactoringElementsBag elements, AbstractRefactoring refactoring) {
        return this.createAndAddElements(files, task, elements, refactoring, null);
    }

    protected final Problem createProblemAndLog(Problem p, Throwable t) {
        Problem newProblem;
        Throwable cause = t.getCause();
        if (cause != null && (cause.getClass().getName().equals("org.netbeans.api.java.source.JavaSource$InsufficientMemoryException") || cause.getCause() != null && cause.getCause().getClass().getName().equals("org.netbeans.api.java.source.JavaSource$InsufficientMemoryException"))) {
            newProblem = new Problem(true, NbBundle.getMessage(JavaRefactoringPlugin.class, (String)"ERR_OutOfMemory"));
        } else {
            String msg = NbBundle.getMessage(JavaRefactoringPlugin.class, (String)"ERR_ExceptionThrown", (Object)t.toString());
            newProblem = new Problem(true, msg);
        }
        Exceptions.printStackTrace((Throwable)t);
        if (p == null) {
            return newProblem;
        }
        Problem problem = p;
        while (problem.getNext() != null) {
            problem = problem.getNext();
        }
        problem.setNext(newProblem);
        return p;
    }

    private class WorkingTask
    implements Task<CompilationController> {
        private Phase whatRun;
        private Problem problem;

        private WorkingTask() {
        }

        private Problem run(Phase s) {
            this.whatRun = s;
            this.problem = null;
            JavaSource js = JavaRefactoringPlugin.this.getJavaSource(s);
            if (js == null) {
                return null;
            }
            try {
                js.runUserActionTask((Task)this, true);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
            return this.problem;
        }

        public void run(CompilationController javac) throws Exception {
            switch (this.whatRun) {
                case PRECHECK: {
                    this.problem = JavaRefactoringPlugin.this.preCheck(javac);
                    break;
                }
                case CHECKPARAMETERS: {
                    this.problem = JavaRefactoringPlugin.this.checkParameters(javac);
                    break;
                }
                case FASTCHECKPARAMETERS: {
                    this.problem = JavaRefactoringPlugin.this.fastCheckParameters(javac);
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
    }

    protected static enum Phase {
        PRECHECK,
        FASTCHECKPARAMETERS,
        CHECKPARAMETERS,
        PREPARE;

    }

    protected class TransformTask
    implements CancellableTask<WorkingCopy> {
        private RefactoringVisitor visitor;
        private TreePathHandle treePathHandle;

        public TransformTask(RefactoringVisitor visitor, TreePathHandle searchedItem) {
            this.visitor = visitor;
            this.treePathHandle = searchedItem;
        }

        public void cancel() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(WorkingCopy compiler) throws IOException {
            try {
                try {
                    this.visitor.setWorkingCopy(compiler);
                }
                catch (ToPhaseException e) {
                    JavaRefactoringPlugin.this.fireProgressListenerStep();
                    return;
                }
                CompilationUnitTree cu = compiler.getCompilationUnit();
                if (cu == null) {
                    ErrorManager.getDefault().log(65536, "compiler.getCompilationUnit() is null " + compiler);
                    return;
                }
                Element el = null;
                if (this.treePathHandle != null && (el = this.treePathHandle.resolveElement((CompilationInfo)compiler)) == null) {
                    ErrorManager.getDefault().log(16, "Cannot resolve " + this.treePathHandle + "in " + compiler.getFileObject().getPath());
                    return;
                }
                this.visitor.scan((Tree)compiler.getCompilationUnit(), el);
            }
            finally {
                JavaRefactoringPlugin.this.fireProgressListenerStep();
            }
        }
    }
}

