/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.dependency;

import java.util.Collections;
import java.util.List;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.modules.project.dependency.ArtifactSpec;
import org.netbeans.modules.project.dependency.ProjectSpec;
import org.netbeans.modules.project.dependency.Scope;

public final class Dependency {
    private final ArtifactSpec artifact;
    private final ProjectSpec project;
    private final List<Dependency> children;
    private final Scope scope;
    private Dependency parent;
    final Object data;

    Dependency(ProjectSpec project, ArtifactSpec artifact, List<Dependency> children, Scope scope, Object data) {
        this.project = project;
        this.artifact = artifact;
        this.children = children;
        this.scope = scope;
        this.data = data;
    }

    @CheckForNull
    public ArtifactSpec getArtifact() {
        return this.artifact;
    }

    public List<Dependency> getChildren() {
        return this.children;
    }

    @CheckForNull
    public ProjectSpec getProject() {
        return this.project;
    }

    public Scope getScope() {
        return this.scope;
    }

    public Object getProjectData() {
        return this.data;
    }

    public String toString() {
        return this.getArtifact() + "[" + this.scope + "]";
    }

    @CheckForNull
    public Dependency getParent() {
        return this.parent;
    }

    private static Dependency assignParent(Dependency d) {
        d.getChildren().forEach(c -> {
            c.parent = d;
        });
        return d;
    }

    public static Dependency make(ArtifactSpec spec, Scope scope) {
        return Dependency.create(spec, scope, Collections.emptyList(), null);
    }

    public static Dependency create(ArtifactSpec artifact, Scope scope, List<Dependency> children, Object data) {
        return Dependency.assignParent(new Dependency(null, artifact, children, scope, data));
    }

    public static Dependency create(ProjectSpec project, ArtifactSpec artifact, Scope scope, List<Dependency> children, Object data) {
        return Dependency.assignParent(new Dependency(project, artifact, children, scope, data));
    }

    public static interface Filter {
        public boolean accept(Scope var1, ArtifactSpec var2);
    }
}

