/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.keyring.gnome;

import com.sun.jna.Pointer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.SuppressWarnings;
import org.netbeans.modules.keyring.gnome.GnomeKeyringLibrary;
import org.netbeans.modules.keyring.impl.KeyringSupport;
import org.netbeans.spi.keyring.KeyringProvider;

public class GnomeProvider
implements KeyringProvider {
    private static final Logger LOG = Logger.getLogger(GnomeProvider.class.getName());
    private static final String KEY = "key";
    private static String[] ERRORS = new String[]{"OK", "DENIED", "NO_KEYRING_DAEMON", "ALREADY_UNLOCKED", "NO_SUCH_KEYRING", "BAD_ARGUMENTS", "IO_ERROR", "CANCELLED", "KEYRING_ALREADY_EXISTS", "NO_MATCH"};

    public boolean enabled() {
        if (Boolean.getBoolean("netbeans.keyring.no.native")) {
            LOG.fine("native keyring integration disabled");
            return false;
        }
        String appName = KeyringSupport.getAppName();
        try {
            GnomeKeyringLibrary.LIBRARY.g_set_application_name(appName);
            if (!GnomeKeyringLibrary.LIBRARY.gnome_keyring_is_available()) {
                return false;
            }
            this.read("NoNeXiStEnT");
            return true;
        }
        catch (Throwable t) {
            LOG.log(Level.FINE, null, t);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressWarnings(value={"PZLA_PREFER_ZERO_LENGTH_ARRAYS"})
    public char[] read(String key) {
        Pointer[] found = new Pointer[1];
        Pointer attributes = GnomeKeyringLibrary.LIBRARY.g_array_new(0, 0, GnomeKeyringLibrary.GnomeKeyringAttribute_SIZE);
        try {
            GnomeKeyringLibrary.LIBRARY.gnome_keyring_attribute_list_append_string(attributes, KEY, key);
            GnomeProvider.error(GnomeKeyringLibrary.LIBRARY.gnome_keyring_find_items_sync(0, attributes, found));
        }
        finally {
            GnomeKeyringLibrary.LIBRARY.gnome_keyring_attribute_list_free(attributes);
        }
        if (found[0] != null) {
            try {
                if (GnomeKeyringLibrary.LIBRARY.g_list_length(found[0]) > 0) {
                    GnomeKeyringLibrary.GnomeKeyringFound result = GnomeKeyringLibrary.LIBRARY.g_list_nth_data(found[0], 0);
                    if (result != null) {
                        if (result.secret != null) {
                            char[] cArray = result.secret.toCharArray();
                            return cArray;
                        }
                        LOG.warning("#183670: GnomeKeyringFound.secret == null");
                        this.delete(key);
                    } else {
                        LOG.warning("#183670: GList<GnomeKeyringFound>[0].result == null");
                    }
                }
            }
            finally {
                GnomeKeyringLibrary.LIBRARY.gnome_keyring_found_list_free(found[0]);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(String key, char[] password, String description) {
        Pointer attributes = GnomeKeyringLibrary.LIBRARY.g_array_new(0, 0, GnomeKeyringLibrary.GnomeKeyringAttribute_SIZE);
        try {
            GnomeKeyringLibrary.LIBRARY.gnome_keyring_attribute_list_append_string(attributes, KEY, key);
            int[] item_id = new int[1];
            GnomeProvider.error(GnomeKeyringLibrary.LIBRARY.gnome_keyring_item_create_sync(null, 0, description != null ? description : key, attributes, new String(password), true, item_id));
        }
        finally {
            GnomeKeyringLibrary.LIBRARY.gnome_keyring_attribute_list_free(attributes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(String key) {
        int id;
        Pointer[] found = new Pointer[1];
        Pointer attributes = GnomeKeyringLibrary.LIBRARY.g_array_new(0, 0, GnomeKeyringLibrary.GnomeKeyringAttribute_SIZE);
        try {
            GnomeKeyringLibrary.LIBRARY.gnome_keyring_attribute_list_append_string(attributes, KEY, key);
            GnomeProvider.error(GnomeKeyringLibrary.LIBRARY.gnome_keyring_find_items_sync(0, attributes, found));
        }
        finally {
            GnomeKeyringLibrary.LIBRARY.gnome_keyring_attribute_list_free(attributes);
        }
        if (found[0] == null) {
            return;
        }
        try {
            if (GnomeKeyringLibrary.LIBRARY.g_list_length(found[0]) > 0) {
                GnomeKeyringLibrary.GnomeKeyringFound result = GnomeKeyringLibrary.LIBRARY.g_list_nth_data(found[0], 0);
                id = result.item_id;
            } else {
                id = 0;
            }
        }
        finally {
            GnomeKeyringLibrary.LIBRARY.gnome_keyring_found_list_free(found[0]);
        }
        if (id > 0) {
            if ("SunOS".equals(System.getProperty("os.name")) && "5.10".equals(System.getProperty("os.version"))) {
                this.save(key, new char[0], null);
            } else {
                GnomeProvider.error(GnomeKeyringLibrary.LIBRARY.gnome_keyring_item_delete_sync(null, id));
            }
        }
    }

    private static void error(int code) {
        if (code != 0 && code != 9) {
            LOG.log(Level.WARNING, "gnome-keyring error: {0}", ERRORS[code]);
        }
    }
}

