/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.util;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.ExactMath;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.api.strings.TruffleStringBuilderUTF16;
import com.oracle.truffle.js.nodes.access.EnumerableOwnPropertyNamesNode;
import com.oracle.truffle.js.nodes.access.IsObjectNode;
import com.oracle.truffle.js.nodes.binary.JSIdenticalNode;
import com.oracle.truffle.js.nodes.cast.JSToIntegerOrInfinityNode;
import com.oracle.truffle.js.nodes.cast.JSToIntegerThrowOnInfinityNode;
import com.oracle.truffle.js.nodes.cast.JSToIntegerWithoutRoundingNode;
import com.oracle.truffle.js.nodes.cast.JSToNumberNode;
import com.oracle.truffle.js.nodes.cast.JSToStringNode;
import com.oracle.truffle.js.nodes.temporal.TemporalCalendarDateFromFieldsNode;
import com.oracle.truffle.js.nodes.temporal.TemporalCalendarGetterNode;
import com.oracle.truffle.js.nodes.temporal.TemporalDurationAddNode;
import com.oracle.truffle.js.nodes.temporal.TemporalGetOptionNode;
import com.oracle.truffle.js.nodes.temporal.TemporalRoundDurationNode;
import com.oracle.truffle.js.nodes.temporal.ToTemporalCalendarNode;
import com.oracle.truffle.js.nodes.temporal.ToTemporalTimeZoneNode;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.Boundaries;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.Strings;
import com.oracle.truffle.js.runtime.builtins.JSDate;
import com.oracle.truffle.js.runtime.builtins.JSOrdinary;
import com.oracle.truffle.js.runtime.builtins.intl.JSDateTimeFormat;
import com.oracle.truffle.js.runtime.builtins.temporal.CalendarMethodsRecord;
import com.oracle.truffle.js.runtime.builtins.temporal.ISODateRecord;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalCalendar;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalCalendarObject;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalDateTimeRecord;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalDuration;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalDurationObject;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalDurationRecord;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalInstant;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalInstantObject;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalParserRecord;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainDate;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainDateObject;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainDateTime;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainDateTimeObject;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainMonthDayObject;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainTimeObject;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainYearMonthObject;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPrecisionRecord;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalTimeZone;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalTimeZoneObject;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalTimeZoneRecord;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalZonedDateTime;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalZonedDateTimeObject;
import com.oracle.truffle.js.runtime.builtins.temporal.NanosecondsToDaysResult;
import com.oracle.truffle.js.runtime.builtins.temporal.ParseISODateTimeResult;
import com.oracle.truffle.js.runtime.builtins.temporal.TimeDurationRecord;
import com.oracle.truffle.js.runtime.builtins.temporal.TimeRecord;
import com.oracle.truffle.js.runtime.builtins.temporal.TimeZoneMethodsRecord;
import com.oracle.truffle.js.runtime.objects.IteratorRecord;
import com.oracle.truffle.js.runtime.objects.JSAttributes;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.JSObjectUtil;
import com.oracle.truffle.js.runtime.objects.Undefined;
import com.oracle.truffle.js.runtime.util.TemporalConstants;
import com.oracle.truffle.js.runtime.util.TemporalErrors;
import com.oracle.truffle.js.runtime.util.TemporalParser;
import com.oracle.truffle.js.runtime.util.UnmodifiableArrayList;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.zone.ZoneOffsetTransition;
import java.time.zone.ZoneRules;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.OptionalLong;
import java.util.Set;
import java.util.function.Function;

public final class TemporalUtil {
    private static final Function<Object, Object> toIntegerThrowOnInfinity = TemporalUtil::toIntegerThrowOnInfinity;
    private static final Function<Object, Object> toPositiveInteger = TemporalUtil::toPositiveInteger;
    private static final Function<Object, Object> toString = JSRuntime::toString;
    public static final Set<TruffleString> pluralUnits = Set.of(TemporalConstants.YEARS, TemporalConstants.MONTHS, TemporalConstants.WEEKS, TemporalConstants.DAYS, TemporalConstants.HOURS, TemporalConstants.MINUTES, TemporalConstants.SECONDS, TemporalConstants.MILLISECONDS, TemporalConstants.MICROSECONDS, TemporalConstants.NANOSECONDS);
    public static final Map<TruffleString, TruffleString> pluralToSingular = Map.ofEntries(Map.entry(TemporalConstants.YEARS, TemporalConstants.YEAR), Map.entry(TemporalConstants.MONTHS, TemporalConstants.MONTH), Map.entry(TemporalConstants.WEEKS, TemporalConstants.WEEK), Map.entry(TemporalConstants.DAYS, TemporalConstants.DAY), Map.entry(TemporalConstants.HOURS, TemporalConstants.HOUR), Map.entry(TemporalConstants.MINUTES, TemporalConstants.MINUTE), Map.entry(TemporalConstants.SECONDS, TemporalConstants.SECOND), Map.entry(TemporalConstants.MILLISECONDS, TemporalConstants.MILLISECOND), Map.entry(TemporalConstants.MICROSECONDS, TemporalConstants.MICROSECOND), Map.entry(TemporalConstants.NANOSECONDS, TemporalConstants.NANOSECOND));
    private static final Map<TruffleString, Function<Object, Object>> temporalFieldConversion = Map.ofEntries(Map.entry(TemporalConstants.YEAR, toIntegerThrowOnInfinity), Map.entry(TemporalConstants.MONTH, toPositiveInteger), Map.entry(TemporalConstants.MONTH_CODE, toString), Map.entry(TemporalConstants.DAY, toPositiveInteger), Map.entry(TemporalConstants.HOUR, toIntegerThrowOnInfinity), Map.entry(TemporalConstants.MINUTE, toIntegerThrowOnInfinity), Map.entry(TemporalConstants.SECOND, toIntegerThrowOnInfinity), Map.entry(TemporalConstants.MILLISECOND, toIntegerThrowOnInfinity), Map.entry(TemporalConstants.MICROSECOND, toIntegerThrowOnInfinity), Map.entry(TemporalConstants.NANOSECOND, toIntegerThrowOnInfinity), Map.entry(TemporalConstants.OFFSET, toString), Map.entry(TemporalConstants.ERA, toString), Map.entry(TemporalConstants.ERA_YEAR, toIntegerThrowOnInfinity));
    public static final Map<TruffleString, Object> temporalFieldDefaults = Map.ofEntries(Map.entry(TemporalConstants.YEAR, Undefined.instance), Map.entry(TemporalConstants.MONTH, Undefined.instance), Map.entry(TemporalConstants.MONTH_CODE, Undefined.instance), Map.entry(TemporalConstants.DAY, Undefined.instance), Map.entry(TemporalConstants.HOUR, 0), Map.entry(TemporalConstants.MINUTE, 0), Map.entry(TemporalConstants.SECOND, 0), Map.entry(TemporalConstants.MILLISECOND, 0), Map.entry(TemporalConstants.MICROSECOND, 0), Map.entry(TemporalConstants.NANOSECOND, 0), Map.entry(TemporalConstants.YEARS, 0), Map.entry(TemporalConstants.MONTHS, 0), Map.entry(TemporalConstants.WEEKS, 0), Map.entry(TemporalConstants.DAYS, 0), Map.entry(TemporalConstants.HOURS, 0), Map.entry(TemporalConstants.MINUTES, 0), Map.entry(TemporalConstants.SECONDS, 0), Map.entry(TemporalConstants.MILLISECONDS, 0), Map.entry(TemporalConstants.MICROSECONDS, 0), Map.entry(TemporalConstants.NANOSECONDS, 0), Map.entry(TemporalConstants.OFFSET, Undefined.instance), Map.entry(TemporalConstants.ERA, Undefined.instance), Map.entry(TemporalConstants.ERA_YEAR, Undefined.instance));
    public static final List<TruffleString> listEmpty = List.of();
    public static final List<TruffleString> listYMWD = List.of(TemporalConstants.YEAR, TemporalConstants.MONTH, TemporalConstants.WEEK, TemporalConstants.DAY);
    public static final List<TruffleString> listPluralYMWD = List.of(TemporalConstants.YEARS, TemporalConstants.MONTHS, TemporalConstants.WEEKS, TemporalConstants.DAYS);
    public static final List<TruffleString> listYMW = List.of(TemporalConstants.YEAR, TemporalConstants.MONTH, TemporalConstants.WEEK);
    public static final List<TruffleString> listYMWDH = List.of(TemporalConstants.YEAR, TemporalConstants.MONTH, TemporalConstants.WEEK, TemporalConstants.DAY, TemporalConstants.HOUR);
    public static final List<TruffleString> listTime = List.of(TemporalConstants.HOUR, TemporalConstants.MINUTE, TemporalConstants.SECOND, TemporalConstants.MILLISECOND, TemporalConstants.MICROSECOND, TemporalConstants.NANOSECOND);
    public static final List<TruffleString> listDMMCY = List.of(TemporalConstants.DAY, TemporalConstants.MONTH, TemporalConstants.MONTH_CODE, TemporalConstants.YEAR);
    public static final List<TruffleString> listMMCY = List.of(TemporalConstants.MONTH, TemporalConstants.MONTH_CODE, TemporalConstants.YEAR);
    public static final List<TruffleString> listMCY = List.of(TemporalConstants.MONTH_CODE, TemporalConstants.YEAR);
    public static final List<TruffleString> listDMC = List.of(TemporalConstants.DAY, TemporalConstants.MONTH_CODE);
    public static final List<TruffleString> listYD = List.of(TemporalConstants.YEAR, TemporalConstants.DAY);
    public static final List<TruffleString> listY = List.of(TemporalConstants.YEAR);
    public static final List<TruffleString> listD = List.of(TemporalConstants.DAY);
    public static final List<TruffleString> listWDHMSMMN = List.of(TemporalConstants.WEEK, TemporalConstants.DAY, TemporalConstants.HOUR, TemporalConstants.MINUTE, TemporalConstants.SECOND, TemporalConstants.MILLISECOND, TemporalConstants.MICROSECOND, TemporalConstants.NANOSECOND);
    public static final List<TruffleString> listAllDateTime = List.of(TemporalConstants.YEARS, TemporalConstants.YEAR, TemporalConstants.MONTHS, TemporalConstants.MONTH, TemporalConstants.WEEKS, TemporalConstants.WEEK, TemporalConstants.DAYS, TemporalConstants.DAY, TemporalConstants.HOURS, TemporalConstants.HOUR, TemporalConstants.MINUTES, TemporalConstants.MINUTE, TemporalConstants.SECONDS, TemporalConstants.SECOND, TemporalConstants.MILLISECONDS, TemporalConstants.MILLISECOND, TemporalConstants.MICROSECONDS, TemporalConstants.MICROSECOND, TemporalConstants.NANOSECONDS, TemporalConstants.NANOSECOND);
    public static final List<TruffleString> listAllDateTimeAuto = List.of(TemporalConstants.AUTO, TemporalConstants.YEARS, TemporalConstants.YEAR, TemporalConstants.MONTHS, TemporalConstants.MONTH, TemporalConstants.WEEKS, TemporalConstants.WEEK, TemporalConstants.DAYS, TemporalConstants.DAY, TemporalConstants.HOURS, TemporalConstants.HOUR, TemporalConstants.MINUTES, TemporalConstants.MINUTE, TemporalConstants.SECONDS, TemporalConstants.SECOND, TemporalConstants.MILLISECONDS, TemporalConstants.MILLISECOND, TemporalConstants.MICROSECONDS, TemporalConstants.MICROSECOND, TemporalConstants.NANOSECONDS, TemporalConstants.NANOSECOND);
    public static final List<TruffleString> listDHMMMMMNSY = List.of(TemporalConstants.DAY, TemporalConstants.HOUR, TemporalConstants.MICROSECOND, TemporalConstants.MILLISECOND, TemporalConstants.MINUTE, TemporalConstants.MONTH, TemporalConstants.MONTH_CODE, TemporalConstants.NANOSECOND, TemporalConstants.SECOND, TemporalConstants.YEAR);
    public static final List<TruffleString> listAuto = List.of(TemporalConstants.AUTO);
    public static final List<TruffleString> listAutoNever = List.of(TemporalConstants.AUTO, TemporalConstants.NEVER);
    public static final List<TruffleString> listAutoAlwaysNever = List.of(TemporalConstants.AUTO, TemporalConstants.ALWAYS, TemporalConstants.NEVER);
    public static final List<TruffleString> listConstrainReject = List.of(TemporalConstants.CONSTRAIN, TemporalConstants.REJECT);
    public static final List<TruffleString> listTimeZone = List.of(TemporalConstants.TIME_ZONE);
    public static final List<TruffleString> listTimeZoneOffset = List.of(TemporalConstants.TIME_ZONE, TemporalConstants.OFFSET);
    public static final List<TruffleString> listRoundingMode = List.of(TemporalConstants.CEIL, TemporalConstants.FLOOR, TemporalConstants.EXPAND, TemporalConstants.TRUNC, TemporalConstants.HALF_FLOOR, TemporalConstants.HALF_CEIL, TemporalConstants.HALF_EXPAND, TemporalConstants.HALF_TRUNC, TemporalConstants.HALF_EVEN);
    public static final List<TruffleString> listOffset = List.of(TemporalConstants.PREFER, TemporalConstants.USE, TemporalConstants.IGNORE, TemporalConstants.REJECT);
    public static final List<TruffleString> listDisambiguation = List.of(TemporalConstants.COMPATIBLE, TemporalConstants.EARLIER, TemporalConstants.LATER, TemporalConstants.REJECT);
    public static final TruffleString[] TIME_LIKE_PROPERTIES = new TruffleString[]{TemporalConstants.HOUR, TemporalConstants.MICROSECOND, TemporalConstants.MILLISECOND, TemporalConstants.MINUTE, TemporalConstants.NANOSECOND, TemporalConstants.SECOND};
    public static final UnitPlural[] DURATION_PROPERTIES = new UnitPlural[]{UnitPlural.DAYS, UnitPlural.HOURS, UnitPlural.MICROSECONDS, UnitPlural.MILLISECONDS, UnitPlural.MINUTES, UnitPlural.MONTHS, UnitPlural.NANOSECONDS, UnitPlural.SECONDS, UnitPlural.WEEKS, UnitPlural.YEARS};
    private static final BigInt upperEpochNSLimit = new BigInt(BigInteger.valueOf(86400L).multiply(BigInteger.valueOf(10L).pow(17)));
    private static final BigInt lowerEpochNSLimit = upperEpochNSLimit.negate();
    private static final BigInteger isoTimeUpperBound = new BigInteger("8640000086400000000000");
    private static final BigInteger isoTimeLowerBound = isoTimeUpperBound.negate();
    private static final int isoTimeBoundYears = 270000;
    private static final int ISO_DATE_MAX_UTC_OFFSET_DAYS = 100000000;
    private static final BigInteger BI_8_64_13 = BigInteger.valueOf(86400000000000L);
    public static final BigInteger BI_36_10_POW_11 = BigInteger.valueOf(3600000000000L);
    public static final BigInteger BI_6_10_POW_10 = BigInteger.valueOf(60000000000L);
    public static final BigInteger BI_10_POW_9 = BigInteger.valueOf(1000000000L);
    public static final BigInteger BI_10_POW_6 = BigInteger.valueOf(1000000L);
    public static final BigInteger BI_1000 = BigInteger.valueOf(1000L);
    public static final BigInteger BI_24 = BigInteger.valueOf(24L);
    public static final BigInteger BI_60 = BigInteger.valueOf(60L);
    public static final BigDecimal BD_10 = BigDecimal.valueOf(10L);
    public static final BigDecimal BD_60 = BigDecimal.valueOf(60L);
    public static final BigDecimal BD_1000 = BigDecimal.valueOf(1000L);
    public static final BigDecimal BD_10_POW_M_3 = new BigDecimal("0.001");
    public static final BigDecimal BD_10_POW_M_6 = new BigDecimal("0.000001");
    public static final BigDecimal BD_10_POW_M_9 = new BigDecimal("0.000000001");
    public static final char UNICODE_MINUS_SIGN = '\u2212';
    public static final MathContext mc_20_floor = new MathContext(20, java.math.RoundingMode.FLOOR);
    public static final TruffleString FRACTIONAL_SECOND_DIGITS = Strings.constant("fractionalSecondDigits");
    public static final TruffleString ZEROS = Strings.constant("000000000");
    public static final TruffleString OFFSET_ZERO = Strings.constant("+00:00");
    public static final TruffleString CALENDAR_NAME = Strings.constant("calendarName");
    public static final TruffleString BRACKET_U_CA_EQUALS = Strings.constant("[u-ca=");
    public static final TruffleString GET_OFFSET_NANOSECONDS_FOR = Strings.constant("getOffsetNanosecondsFor");
    public static final TruffleString YEAR_MONTH_FROM_FIELDS = Strings.constant("yearMonthFromFields");
    public static final TruffleString MONTH_DAY_FROM_FIELDS = Strings.constant("monthDayFromFields");
    public static final TruffleString GET_POSSIBLE_INSTANTS_FOR = Strings.constant("getPossibleInstantsFor");
    public static final int HOURS_PER_DAY = 24;
    public static final int MINUTES_PER_HOUR = 60;
    public static final int SECONDS_PER_MINUTE = 60;
    public static final double MS_PER_DAY = 8.64E7;
    public static final double NS_PER_DAY = 8.64E13;
    public static final int SINCE = -1;
    public static final int UNTIL = 1;
    public static final int SUBTRACT = -1;
    public static final int ADD = 1;

    public static double defaultNumberOptions(Object value, double minimum, double maximum, double fallback, JSToNumberNode toNumber) {
        if (value == Undefined.instance) {
            return fallback;
        }
        double numberValue = JSRuntime.doubleValue(toNumber.executeNumber(value));
        if (Double.isNaN(numberValue) || numberValue < minimum || numberValue > maximum || Double.isInfinite(numberValue) && Double.isInfinite(maximum)) {
            throw Errors.createRangeError("Numeric value out of range.");
        }
        return Math.floor(numberValue);
    }

    public static double getNumberOption(JSDynamicObject options, TruffleString property, double minimum, double maximum, double fallback, IsObjectNode isObject, JSToNumberNode numberNode) {
        assert (isObject.executeBoolean((Object)options));
        Object value = JSObject.get(options, property);
        return TemporalUtil.defaultNumberOptions(value, minimum, maximum, fallback, numberNode);
    }

    public static Object getStringOrNumberOption(JSDynamicObject options, TruffleString property, List<TruffleString> stringValues, double minimum, double maximum, Object fallback, JSToStringNode toStringNode, TemporalGetOptionNode getOptionNode) {
        assert (JSRuntime.isObject((Object)options));
        Object value = getOptionNode.execute(options, property, OptionType.NUMBER_AND_STRING, null, fallback);
        if (value instanceof Number) {
            double numberValue = JSRuntime.doubleValue((Number)value);
            if (Double.isNaN(numberValue) || numberValue < minimum || numberValue > maximum) {
                throw Errors.createRangeError("Numeric value out of range.");
            }
            return Math.floor(numberValue);
        }
        value = toStringNode.executeString(value);
        if (stringValues != null && !Boundaries.listContainsUnchecked(stringValues, value)) {
            throw Errors.createRangeError("Given string value is not in string values");
        }
        return value;
    }

    public static double toTemporalRoundingIncrement(JSDynamicObject options, Double dividend, boolean inclusive, IsObjectNode isObject, JSToNumberNode toNumber) {
        double maximum;
        double dDividend = Double.NaN;
        if (dividend == null) {
            maximum = Double.POSITIVE_INFINITY;
        } else {
            dDividend = JSRuntime.doubleValue(dividend);
            maximum = inclusive ? dDividend : (dDividend > 1.0 ? dDividend - 1.0 : 1.0);
        }
        double increment = TemporalUtil.getNumberOption(options, TemporalConstants.ROUNDING_INCREMENT, 1.0, maximum, 1.0, isObject, toNumber);
        if (dividend != null && dDividend % increment != 0.0) {
            throw Errors.createRangeError("Increment out of range.");
        }
        return increment;
    }

    public static JSTemporalPrecisionRecord toSecondsStringPrecision(JSDynamicObject options, JSToStringNode toStringNode, TemporalGetOptionNode getOptionNode, TruffleString.EqualNode equalNode) {
        Unit smallestUnit = TemporalUtil.toSmallestTemporalUnit(options, listYMWDH, null, getOptionNode, equalNode);
        if (Unit.MINUTE == smallestUnit) {
            return JSTemporalPrecisionRecord.create(TemporalConstants.MINUTE, Unit.MINUTE, 1.0);
        }
        if (Unit.SECOND == smallestUnit) {
            return JSTemporalPrecisionRecord.create(0, Unit.SECOND, 1.0);
        }
        if (Unit.MILLISECOND == smallestUnit) {
            return JSTemporalPrecisionRecord.create(3, Unit.MILLISECOND, 1.0);
        }
        if (Unit.MICROSECOND == smallestUnit) {
            return JSTemporalPrecisionRecord.create(6, Unit.MICROSECOND, 1.0);
        }
        if (Unit.NANOSECOND == smallestUnit) {
            return JSTemporalPrecisionRecord.create(9, Unit.NANOSECOND, 1.0);
        }
        assert (smallestUnit == Unit.EMPTY);
        Object digits = TemporalUtil.getStringOrNumberOption(options, FRACTIONAL_SECOND_DIGITS, listAuto, 0.0, 9.0, TemporalConstants.AUTO, toStringNode, getOptionNode);
        if (Boundaries.equals(digits, TemporalConstants.AUTO)) {
            return JSTemporalPrecisionRecord.create(TemporalConstants.AUTO, Unit.NANOSECOND, 1.0);
        }
        int iDigit = JSRuntime.intValue((Number)digits);
        if (iDigit == 0) {
            return JSTemporalPrecisionRecord.create(0, Unit.SECOND, 1.0);
        }
        if (iDigit == 1 || iDigit == 2 || iDigit == 3) {
            return JSTemporalPrecisionRecord.create(digits, Unit.MILLISECOND, Math.pow(10.0, 3L - TemporalUtil.toLong(digits)));
        }
        if (iDigit == 4 || iDigit == 5 || iDigit == 6) {
            return JSTemporalPrecisionRecord.create(digits, Unit.MICROSECOND, Math.pow(10.0, 6L - TemporalUtil.toLong(digits)));
        }
        assert (iDigit == 7 || iDigit == 8 || iDigit == 9);
        return JSTemporalPrecisionRecord.create(digits, Unit.NANOSECOND, Math.pow(10.0, 9L - TemporalUtil.toLong(digits)));
    }

    @CompilerDirectives.TruffleBoundary
    private static long toLong(Object digits) {
        if (digits instanceof Number) {
            return ((Number)digits).longValue();
        }
        return JSRuntime.toNumber(digits).longValue();
    }

    public static Unit toSmallestTemporalUnit(JSDynamicObject normalizedOptions, List<TruffleString> disallowedUnits, TruffleString fallback, TemporalGetOptionNode getOptionNode, TruffleString.EqualNode equalNode) {
        TruffleString smallestUnit = (TruffleString)getOptionNode.execute(normalizedOptions, TemporalConstants.SMALLEST_UNIT, OptionType.STRING, listAllDateTime, fallback);
        if (smallestUnit != null && Boundaries.setContains(pluralUnits, smallestUnit)) {
            smallestUnit = Boundaries.mapGet(pluralToSingular, smallestUnit);
        }
        if (smallestUnit != null && Boundaries.listContains(disallowedUnits, smallestUnit)) {
            throw Errors.createRangeError("Smallest unit not allowed.");
        }
        return TemporalUtil.toUnit(smallestUnit, equalNode);
    }

    @CompilerDirectives.TruffleBoundary
    public static ParseISODateTimeResult parseTemporalRelativeToString(TruffleString isoString) {
        if (!new TemporalParser(isoString).isTemporalDateTimeString()) {
            throw TemporalErrors.createRangeErrorInvalidRelativeToString();
        }
        return TemporalUtil.parseISODateTime(isoString, false, false);
    }

    @CompilerDirectives.TruffleBoundary
    public static JSTemporalDateTimeRecord parseTemporalMonthDayString(TruffleString string) {
        JSTemporalParserRecord rec = new TemporalParser(string).parseMonthDay();
        if (rec != null) {
            int d;
            if (rec.getZ()) {
                throw TemporalErrors.createRangeErrorUnexpectedUTCDesignator();
            }
            if (rec.getYear() == 0L && (Strings.indexOf(string, TemporalConstants.MINUS_000000) >= 0 || Strings.indexOf(string, TemporalConstants.UNICODE_MINUS_SIGN_000000) >= 0)) {
                throw TemporalErrors.createRangeErrorInvalidPlainDateTime();
            }
            int y = rec.getYear() == Long.MIN_VALUE ? Integer.MIN_VALUE : TemporalUtil.ltoi(rec.getYear());
            int m = rec.getMonth() == Long.MIN_VALUE ? 1 : TemporalUtil.ltoi(rec.getMonth());
            int n = d = rec.getDay() == Long.MIN_VALUE ? 1 : TemporalUtil.ltoi(rec.getDay());
            if (!TemporalUtil.isValidISODate(y, m, d)) {
                throw TemporalErrors.createRangeErrorDateOutsideRange();
            }
            return JSTemporalDateTimeRecord.createCalendar(y, m, d, 0, 0, 0, 0, 0, 0, rec.getCalendar());
        }
        throw Errors.createRangeError("cannot parse MonthDay");
    }

    private static ParseISODateTimeResult parseISODateTime(TruffleString string) {
        return TemporalUtil.parseISODateTime(string, false, false);
    }

    @CompilerDirectives.TruffleBoundary
    private static ParseISODateTimeResult parseISODateTime(TruffleString string, boolean failWithUTCDesignator, boolean timeExpected) {
        JSTemporalParserRecord rec = new TemporalParser(string).parseISODateTime();
        if (rec != null) {
            if (failWithUTCDesignator && rec.getZ()) {
                throw TemporalErrors.createRangeErrorUnexpectedUTCDesignator();
            }
            if (timeExpected && rec.getHour() == Long.MIN_VALUE) {
                throw Errors.createRangeError("cannot parse the ISO date time string");
            }
            return TemporalUtil.parseISODateTimeIntl(string, rec);
        }
        throw Errors.createRangeError("cannot parse the ISO date time string");
    }

    private static ParseISODateTimeResult parseISODateTimeIntl(TruffleString string, JSTemporalParserRecord rec) {
        TruffleString fraction = rec.getFraction();
        fraction = fraction == null ? ZEROS : Strings.concat(fraction, ZEROS);
        if (rec.getYear() == 0L && (Strings.indexOf(string, TemporalConstants.MINUS_000000) >= 0 || Strings.indexOf(string, TemporalConstants.UNICODE_MINUS_SIGN_000000) >= 0)) {
            throw TemporalErrors.createRangeErrorInvalidPlainDateTime();
        }
        int y = rec.getYear() == Long.MIN_VALUE ? 0 : TemporalUtil.ltoi(rec.getYear());
        int m = rec.getMonth() == Long.MIN_VALUE ? 1 : TemporalUtil.ltoi(rec.getMonth());
        int d = rec.getDay() == Long.MIN_VALUE ? 1 : TemporalUtil.ltoi(rec.getDay());
        int h = rec.getHour() == Long.MIN_VALUE ? 0 : TemporalUtil.ltoi(rec.getHour());
        int min = rec.getMinute() == Long.MIN_VALUE ? 0 : TemporalUtil.ltoi(rec.getMinute());
        int s = rec.getSecond() == Long.MIN_VALUE ? 0 : TemporalUtil.ltoi(rec.getSecond());
        int ms = 0;
        int mus = 0;
        int ns = 0;
        try {
            ms = (int)Strings.parseLong(Strings.lazySubstring(fraction, 0, 3));
            mus = (int)Strings.parseLong(Strings.lazySubstring(fraction, 3, 3));
            ns = (int)Strings.parseLong(Strings.lazySubstring(fraction, 6, 3));
        }
        catch (TruffleString.NumberFormatException e) {
            throw CompilerDirectives.shouldNotReachHere((Throwable)e);
        }
        if (s == 60) {
            s = 59;
        }
        if (!TemporalUtil.isValidISODate(y, m, d)) {
            throw TemporalErrors.createRangeErrorDateOutsideRange();
        }
        if (!TemporalUtil.isValidTime(h, min, s, ms, mus, ns)) {
            throw TemporalErrors.createRangeErrorTimeOutsideRange();
        }
        JSTemporalTimeZoneRecord timeZoneResult = JSTemporalTimeZoneRecord.create(rec.getZ(), rec.getTimeZoneUTCOffsetName(), rec.getTimeZoneIdentifier());
        return new ParseISODateTimeResult(y, m, d, h, min, s, ms, mus, ns, rec.getCalendar(), timeZoneResult);
    }

    public static void validateTemporalUnitRange(Unit largestUnit, Unit smallestUnit) {
        boolean error = false;
        switch (smallestUnit.ordinal()) {
            case 2: {
                if (largestUnit == Unit.YEAR) break;
                error = true;
                break;
            }
            case 3: {
                if (largestUnit == Unit.YEAR || largestUnit == Unit.MONTH) break;
                error = true;
                break;
            }
            case 4: {
                if (largestUnit == Unit.YEAR || largestUnit == Unit.MONTH || largestUnit == Unit.WEEK) break;
                error = true;
                break;
            }
            case 5: {
                if (largestUnit == Unit.YEAR || largestUnit == Unit.MONTH || largestUnit == Unit.WEEK || largestUnit == Unit.DAY) break;
                error = true;
                break;
            }
            case 6: {
                if (largestUnit == Unit.YEAR || largestUnit == Unit.MONTH || largestUnit == Unit.WEEK || largestUnit == Unit.DAY || largestUnit == Unit.HOUR) break;
                error = true;
                break;
            }
            case 7: {
                if (largestUnit != Unit.SECOND && largestUnit != Unit.MILLISECOND && largestUnit != Unit.MICROSECOND && largestUnit != Unit.NANOSECOND) break;
                error = true;
                break;
            }
            case 8: {
                if (largestUnit != Unit.MILLISECOND && largestUnit != Unit.MICROSECOND && largestUnit != Unit.NANOSECOND) break;
                error = true;
                break;
            }
            case 9: {
                if (largestUnit != Unit.MICROSECOND && largestUnit != Unit.NANOSECOND) break;
                error = true;
                break;
            }
            case 10: {
                if (largestUnit != Unit.NANOSECOND) break;
                error = true;
            }
        }
        if (error) {
            throw TemporalErrors.createRangeErrorSmallestUnitOutOfRange();
        }
    }

    public static Double maximumTemporalDurationRoundingIncrement(Unit unit) {
        if (unit == Unit.YEAR || unit == Unit.MONTH || unit == Unit.WEEK || unit == Unit.DAY) {
            return null;
        }
        if (unit == Unit.HOUR) {
            return 24.0;
        }
        if (unit == Unit.MINUTE || unit == Unit.SECOND) {
            return 60.0;
        }
        assert (unit == Unit.MILLISECOND || unit == Unit.MICROSECOND || unit == Unit.NANOSECOND);
        return 1000.0;
    }

    @CompilerDirectives.TruffleBoundary
    public static TruffleString formatSecondsStringPart(long second, long millisecond, long microsecond, long nanosecond, Object precision) {
        if (precision.equals(TemporalConstants.MINUTE)) {
            return Strings.EMPTY_STRING;
        }
        TruffleString secondString = Strings.concat(Strings.COLON, TemporalUtil.toZeroPaddedDecimalString(second, 2));
        long fraction = millisecond * 1000000L + microsecond * 1000L + nanosecond;
        TruffleString fractionString = Strings.EMPTY_STRING;
        if (precision.equals(TemporalConstants.AUTO)) {
            if (fraction == 0L) {
                return secondString;
            }
            fractionString = Strings.concatAll(fractionString, TemporalUtil.toZeroPaddedDecimalString(millisecond, 3), TemporalUtil.toZeroPaddedDecimalString(microsecond, 3), TemporalUtil.toZeroPaddedDecimalString(nanosecond, 3));
            fractionString = TemporalUtil.longestSubstring(fractionString);
        } else {
            if (precision.equals(0)) {
                return secondString;
            }
            fractionString = Strings.concatAll(fractionString, TemporalUtil.toZeroPaddedDecimalString(millisecond, 3), TemporalUtil.toZeroPaddedDecimalString(microsecond, 3), TemporalUtil.toZeroPaddedDecimalString(nanosecond, 3));
            fractionString = Strings.lazySubstring(fractionString, 0, (int)TemporalUtil.toLong(precision));
        }
        return Strings.concatAll(secondString, Strings.DOT, fractionString);
    }

    private static TruffleString longestSubstring(TruffleString str) {
        int length;
        for (length = Strings.length(str); length > 0 && Strings.charAt(str, length - 1) == '0'; --length) {
        }
        if (length == 0) {
            return Strings.EMPTY_STRING;
        }
        if (length == Strings.length(str)) {
            return str;
        }
        assert (Strings.length(str) <= 9);
        return Strings.lazySubstring(str, 0, length);
    }

    public static int nonNegativeModulo(double x, int y) {
        assert (y > 0) : y;
        int result = (int)(x % (double)y);
        if (result < 0) {
            result += y;
        }
        return result;
    }

    public static int nonNegativeModulo(long x, int y) {
        assert (y > 0) : y;
        int result = (int)(x % (long)y);
        if (result < 0) {
            result += y;
        }
        return result;
    }

    public static int nonNegativeModulo(int x, int y) {
        assert (y > 0) : y;
        int result = x % y;
        if (result < 0) {
            result += y;
        }
        return result;
    }

    public static int constrainToRange(int value, int minimum, int maximum) {
        return Math.min(Math.max(value, minimum), maximum);
    }

    public static UnsignedRoundingMode getUnsignedRoundingMode(RoundingMode roundingMode, boolean isNegative) {
        switch (roundingMode.ordinal()) {
            case 1: {
                return isNegative ? UnsignedRoundingMode.ZERO : UnsignedRoundingMode.INFINITY;
            }
            case 2: {
                return isNegative ? UnsignedRoundingMode.INFINITY : UnsignedRoundingMode.ZERO;
            }
            case 3: {
                return UnsignedRoundingMode.INFINITY;
            }
            case 4: {
                return UnsignedRoundingMode.ZERO;
            }
            case 9: {
                return isNegative ? UnsignedRoundingMode.HALF_ZERO : UnsignedRoundingMode.HALF_INFINITY;
            }
            case 8: {
                return isNegative ? UnsignedRoundingMode.HALF_INFINITY : UnsignedRoundingMode.HALF_ZERO;
            }
            case 5: {
                return UnsignedRoundingMode.HALF_INFINITY;
            }
            case 6: {
                return UnsignedRoundingMode.HALF_ZERO;
            }
            case 7: {
                return UnsignedRoundingMode.HALF_EVEN;
            }
        }
        return UnsignedRoundingMode.EMPTY;
    }

    public static double applyUnsignedRoundingMode(double x, double r1, double r2, UnsignedRoundingMode urm) {
        if (x == r1) {
            return r1;
        }
        assert (r1 <= x && x <= r2);
        assert (urm != UnsignedRoundingMode.EMPTY);
        if (urm == UnsignedRoundingMode.ZERO) {
            return r1;
        }
        if (urm == UnsignedRoundingMode.INFINITY) {
            return r2;
        }
        double d1 = x - r1;
        double d2 = r2 - x;
        if (d1 < d2) {
            return r1;
        }
        if (d2 < d1) {
            return r2;
        }
        assert (d1 == d2);
        if (urm == UnsignedRoundingMode.HALF_ZERO) {
            return r1;
        }
        if (urm == UnsignedRoundingMode.HALF_INFINITY) {
            return r2;
        }
        assert (urm == UnsignedRoundingMode.HALF_EVEN);
        double cardinality = r1 / (r2 - r1) % 2.0;
        if (cardinality == 0.0) {
            return r1;
        }
        return r2;
    }

    @CompilerDirectives.TruffleBoundary
    public static double roundNumberToIncrement(double x, double increment, RoundingMode roundingMode) {
        boolean isNegative;
        assert (JSRuntime.isIntegralNumber(increment)) : increment;
        double quotient = x / increment;
        if (quotient < 0.0) {
            isNegative = true;
            quotient = -quotient;
        } else {
            isNegative = false;
        }
        UnsignedRoundingMode unsignedRoundingMode = TemporalUtil.getUnsignedRoundingMode(roundingMode, isNegative);
        double r1 = Math.floor(quotient);
        double r2 = r1 + 1.0;
        double rounded = TemporalUtil.applyUnsignedRoundingMode(quotient, r1, r2, unsignedRoundingMode);
        if (isNegative) {
            rounded = -rounded;
        }
        return rounded * increment;
    }

    @CompilerDirectives.TruffleBoundary
    public static BigInteger roundNumberToIncrementAsIfPositive(BigDecimal x, BigDecimal increment, RoundingMode roundingMode) {
        return TemporalUtil.roundNumberToIncrementAsIfPositiveAsBigDecimal(x, increment, roundingMode).toBigInteger();
    }

    private static BigDecimal roundNumberToIncrementAsIfPositiveAsBigDecimal(BigDecimal x, BigDecimal increment, RoundingMode roundingMode) {
        BigDecimal[] divRes = x.divideAndRemainder(increment);
        BigDecimal quotient = divRes[0];
        BigDecimal remainder = divRes[1];
        int sign = remainder.signum();
        if (sign == 0) {
            return x;
        }
        UnsignedRoundingMode unsignedRoundingMode = TemporalUtil.getUnsignedRoundingMode(roundingMode, false);
        BigDecimal r1 = sign < 0 ? quotient.subtract(BigDecimal.ONE) : quotient;
        BigDecimal r2 = sign >= 0 ? quotient.add(BigDecimal.ONE) : quotient;
        int half = TemporalUtil.compareHalf(remainder, increment);
        BigDecimal rounded = switch (unsignedRoundingMode.ordinal()) {
            case 1 -> r1;
            case 2 -> r2;
            case 4 -> {
                if (half <= 0) {
                    yield r1;
                }
                yield r2;
            }
            case 3 -> {
                if (half < 0) {
                    yield r1;
                }
                yield r2;
            }
            case 5 -> {
                if (half < 0) {
                    yield r1;
                }
                if (half > 0) {
                    yield r2;
                }
                if (TemporalUtil.isEven(r1)) {
                    yield r1;
                }
                yield r2;
            }
            default -> throw Errors.shouldNotReachHereUnexpectedValue((Object)unsignedRoundingMode);
        };
        return rounded.multiply(increment);
    }

    private static int compareHalf(BigDecimal remainder, BigDecimal divisor) {
        return remainder.multiply(BigDecimal.valueOf(2L)).abs().compareTo(divisor.abs());
    }

    private static boolean isEven(BigDecimal value) {
        return !value.toBigInteger().testBit(0);
    }

    @CompilerDirectives.TruffleBoundary
    public static TruffleString parseTemporalCalendarString(TruffleString string) {
        JSTemporalParserRecord rec = new TemporalParser(string).parseCalendarString();
        if (rec == null) {
            throw Errors.createRangeError("cannot parse Calendar");
        }
        TruffleString id = rec.getCalendar();
        if (id == null) {
            return TemporalConstants.ISO8601;
        }
        return id;
    }

    public static double toPositiveInteger(Object value) {
        double result = JSRuntime.doubleValue(TemporalUtil.toIntegerThrowOnInfinity(value));
        if (result <= 0.0) {
            throw Errors.createRangeError("positive value expected");
        }
        return result;
    }

    public static int toPositiveIntegerConstrainInt(Object value, JSToIntegerThrowOnInfinityNode toIntegerThrowOnInfinityNode, Node node, InlinedBranchProfile errorBranch) {
        int integer = toIntegerThrowOnInfinityNode.executeIntOrThrow(value);
        if (integer <= 0) {
            errorBranch.enter(node);
            throw Errors.createRangeError("positive value expected");
        }
        return integer;
    }

    @CompilerDirectives.TruffleBoundary
    public static JSObject prepareTemporalFields(JSContext ctx, JSDynamicObject fields, List<TruffleString> fieldNames, List<TruffleString> requiredFields) {
        JSObject result = JSOrdinary.createWithNullPrototype(ctx);
        for (TruffleString property : fieldNames) {
            Object value = JSObject.get(fields, property);
            assert (value != null);
            if (value == Undefined.instance) {
                if (requiredFields.contains(property)) {
                    throw TemporalErrors.createTypeErrorPropertyRequired(property);
                }
                if (temporalFieldDefaults.containsKey(property)) {
                    value = temporalFieldDefaults.get(property);
                }
            } else if (temporalFieldConversion.containsKey(property)) {
                Function<Object, Object> conversion = temporalFieldConversion.get(property);
                value = conversion.apply(value);
            }
            TemporalUtil.createDataPropertyOrThrow(ctx, result, property, value);
        }
        return result;
    }

    @CompilerDirectives.TruffleBoundary
    public static JSObject preparePartialTemporalFields(JSContext ctx, JSDynamicObject fields, List<TruffleString> fieldNames) {
        JSObject result = JSOrdinary.createWithNullPrototype(ctx);
        boolean any = false;
        for (TruffleString property : fieldNames) {
            Object value = JSObject.get(fields, property);
            assert (value != null);
            if (value != Undefined.instance) {
                any = true;
                if (temporalFieldConversion.containsKey(property)) {
                    Function<Object, Object> conversion = temporalFieldConversion.get(property);
                    value = conversion.apply(value);
                }
            }
            TemporalUtil.createDataPropertyOrThrow(ctx, result, property, value);
        }
        if (!any) {
            throw Errors.createTypeError("Given dateTime like object has no relevant properties.");
        }
        return result;
    }

    public static ISOYearMonthRecord regulateISOYearMonth(int year, int month, Overflow overflow) {
        assert (Overflow.CONSTRAIN == overflow || Overflow.REJECT == overflow);
        if (Overflow.CONSTRAIN == overflow) {
            return TemporalUtil.constrainISOYearMonth(year, month);
        }
        assert (Overflow.REJECT == overflow);
        if (!TemporalUtil.isValidISOMonth(month)) {
            throw Errors.createRangeError("validation of year and month failed");
        }
        return new ISOYearMonthRecord(year, month);
    }

    private static boolean isValidISOMonth(int month) {
        return 1 <= month && month <= 12;
    }

    private static ISOYearMonthRecord constrainISOYearMonth(int year, int month) {
        int monthPrepared = TemporalUtil.constrainToRange(month, 1, 12);
        return new ISOYearMonthRecord(TemporalUtil.ltoi(year), monthPrepared);
    }

    public static long toISODayOfWeek(int year, int month, int day) {
        int weekDay;
        int m = month - 2;
        if (m == -1) {
            m = 11;
        } else if (m == 0) {
            m = 12;
        }
        int c = Math.floorDiv(year, 100);
        int y = Math.floorMod(year, 100);
        if (m == 11 || m == 12) {
            --y;
        }
        if ((weekDay = Math.floorMod((long)day + (long)Math.floor(2.6 * (double)m - 0.2) - (long)(2 * c) + (long)y + (long)Math.floorDiv(y, 4) + (long)Math.floorDiv(c, 4), 7)) == 0) {
            return 7L;
        }
        return weekDay;
    }

    public static int toISODayOfYear(int year, int month, int day) {
        int days = 0;
        for (int m = 1; m < month; ++m) {
            days += TemporalUtil.isoDaysInMonth(year, m);
        }
        return days + day;
    }

    public static long toISOWeekOfYear(int year, int month, int day) {
        long doy = TemporalUtil.toISODayOfYear(year, month, day);
        long dow = TemporalUtil.toISODayOfWeek(year, month, day);
        long doj = TemporalUtil.toISODayOfWeek(year, 1, 1);
        long week = Math.floorDiv(doy - dow + 10L, 7);
        if (week < 1L) {
            if (doj == 5L || doj == 6L && TemporalUtil.isISOLeapYear(year - 1)) {
                return 53L;
            }
            return 52L;
        }
        if (week == 53L && (long)TemporalUtil.isoDaysInYear(year) - doy < 4L - dow) {
            return 1L;
        }
        return week;
    }

    public static boolean isISOLeapYear(int year) {
        return year % 4 == 0 && (year % 100 != 0 || year % 400 == 0);
    }

    public static int isoDaysInYear(int year) {
        if (TemporalUtil.isISOLeapYear(year)) {
            return 366;
        }
        return 365;
    }

    public static int isoDaysInMonth(int year, int month) {
        assert (month >= 1 && month <= 12);
        if (month == 1 || month == 3 || month == 5 || month == 7 || month == 8 || month == 10 || month == 12) {
            return 31;
        }
        if (month == 4 || month == 6 || month == 9 || month == 11) {
            return 30;
        }
        if (TemporalUtil.isISOLeapYear(year)) {
            return 29;
        }
        return 28;
    }

    public static ISODateRecord balanceISOYearMonth(int year, int month) {
        if (year == Integer.MAX_VALUE || year == Integer.MIN_VALUE || month == Integer.MAX_VALUE || month == Integer.MIN_VALUE) {
            throw Errors.createRangeError("value out of range");
        }
        int yearPrepared = (int)((double)year + Math.floor(((double)month - 1.0) / 12.0));
        int monthPrepared = TemporalUtil.nonNegativeModulo(month - 1, 12) + 1;
        return new ISODateRecord(yearPrepared, monthPrepared, 0);
    }

    public static ISODateRecord balanceISOYearMonth(double year, double month) {
        assert (JSRuntime.isIntegralNumber(year)) : year;
        assert (JSRuntime.isIntegralNumber(month)) : month;
        double yearPrepared = year + Math.floor((month - 1.0) / 12.0);
        int monthPrepared = TemporalUtil.nonNegativeModulo(month - 1.0, 12) + 1;
        return new ISODateRecord((int)yearPrepared, monthPrepared, 0);
    }

    @CompilerDirectives.TruffleBoundary
    public static boolean isBuiltinCalendar(TruffleString id) {
        return id.equals((Object)TemporalConstants.ISO8601) || id.equals((Object)TemporalConstants.GREGORY) || id.equals((Object)TemporalConstants.JAPANESE);
    }

    public static JSTemporalCalendarObject getISO8601Calendar(JSContext ctx, JSRealm realm) {
        return TemporalUtil.getBuiltinCalendar(TemporalConstants.ISO8601, ctx, realm);
    }

    public static JSTemporalCalendarObject getBuiltinCalendar(TruffleString id, JSContext ctx, JSRealm realm) {
        assert (TemporalUtil.isBuiltinCalendar(id)) : id;
        return JSTemporalCalendar.create(ctx, realm, id);
    }

    @CompilerDirectives.TruffleBoundary
    public static List<TruffleString> iterableToListOfTypeString(JSDynamicObject items) {
        IteratorRecord iter = JSRuntime.getIterator((Object)items);
        ArrayList<TruffleString> values = new ArrayList<TruffleString>();
        Object next = Boolean.TRUE;
        while (next != Boolean.FALSE) {
            next = JSRuntime.iteratorStep(iter);
            if (next == Boolean.FALSE) continue;
            Object nextValue = JSRuntime.iteratorValue(next);
            if (!Strings.isTString(nextValue)) {
                JSRuntime.iteratorClose(iter.getIterator());
                throw Errors.createTypeError("string expected");
            }
            TruffleString str = JSRuntime.toString(nextValue);
            values.add(str);
        }
        return values;
    }

    @CompilerDirectives.TruffleBoundary
    public static JSTemporalDateTimeRecord parseTemporalDateTimeString(TruffleString string) {
        JSTemporalParserRecord rec = new TemporalParser(string).parseCalendarDateTime();
        if (rec == null) {
            throw Errors.createRangeError("cannot parse the date string");
        }
        if (rec.getZ()) {
            throw TemporalErrors.createRangeErrorUnexpectedUTCDesignator();
        }
        ParseISODateTimeResult result = TemporalUtil.parseISODateTime(string, true, false);
        return result;
    }

    @CompilerDirectives.TruffleBoundary
    public static JSTemporalDateTimeRecord parseTemporalDateString(TruffleString string) {
        JSTemporalDateTimeRecord rec = TemporalUtil.parseTemporalDateTimeString(string);
        return JSTemporalDateTimeRecord.createCalendar(rec.getYear(), rec.getMonth(), rec.getDay(), 0, 0, 0, 0, 0, 0, rec.getCalendar());
    }

    @CompilerDirectives.TruffleBoundary
    public static JSTemporalDateTimeRecord parseTemporalTimeString(TruffleString string) {
        ParseISODateTimeResult result = TemporalUtil.parseISODateTime(string, true, true);
        if (result.hasCalendar()) {
            return JSTemporalDateTimeRecord.createCalendar(0, 0, 0, result.getHour(), result.getMinute(), result.getSecond(), result.getMillisecond(), result.getMicrosecond(), result.getNanosecond(), result.getCalendar());
        }
        return JSTemporalDateTimeRecord.create(0, 0, 0, result.getHour(), result.getMinute(), result.getSecond(), result.getMillisecond(), result.getMicrosecond(), result.getNanosecond());
    }

    @CompilerDirectives.TruffleBoundary
    public static TruffleString buildISOMonthCode(int month) {
        TruffleString numberPart = Strings.fromInt(month);
        assert (1 <= Strings.length(numberPart) && Strings.length(numberPart) <= 2);
        return Strings.concat(Strings.length(numberPart) >= 2 ? Strings.UC_M : Strings.UC_M0, numberPart);
    }

    public static JSTemporalTimeZoneObject createTemporalTimeZone(JSContext ctx, JSRealm realm, TruffleString identifier) {
        return TemporalUtil.createTemporalTimeZone(ctx, realm, ctx.getTemporalTimeZoneFactory().getPrototype(realm), identifier);
    }

    public static JSTemporalTimeZoneObject createTemporalTimeZone(JSContext ctx, JSRealm realm, JSDynamicObject proto, TruffleString identifier) {
        BigInt offsetNs;
        TruffleString newIdentifier = identifier;
        try {
            long result = TemporalUtil.parseTimeZoneOffsetString(identifier);
            newIdentifier = TemporalUtil.formatTimeZoneOffsetString(result);
            offsetNs = BigInt.valueOf(result);
        }
        catch (Exception ex) {
            assert (TemporalUtil.canonicalizeTimeZoneName(identifier).equals((Object)identifier));
            offsetNs = null;
        }
        return JSTemporalTimeZone.create(ctx, realm, proto, offsetNs, newIdentifier);
    }

    public static TruffleString canonicalizeTimeZoneName(TruffleString timeZone) {
        assert (TemporalUtil.isValidTimeZoneName(timeZone));
        return Strings.fromJavaString(JSDateTimeFormat.canonicalizeTimeZoneName(timeZone));
    }

    public static boolean isValidTimeZoneName(TruffleString timeZone) {
        return JSDateTimeFormat.canonicalizeTimeZoneName(timeZone) != null;
    }

    @CompilerDirectives.TruffleBoundary
    public static double getDouble(JSDynamicObject ob, TruffleString key, double defaultValue) {
        Object value = JSObject.get(ob, key);
        if (value == Undefined.instance) {
            return defaultValue;
        }
        Number n = (Number)value;
        return n.longValue();
    }

    public static boolean isoDateTimeWithinLimits(int year, int month, int day, int hour, int minute, int second, int millisecond, int microsecond, int nanosecond) {
        if (-270000 <= year && year <= 270000) {
            assert (TemporalUtil.isoDateTimeWithinLimitsExact(year, month, day, hour, minute, second, millisecond, microsecond, nanosecond));
            return true;
        }
        if (year >= -999999999 && year <= 999999999) {
            return TemporalUtil.isoDateTimeWithinLimitsExact(year, month, day, hour, minute, second, millisecond, microsecond, nanosecond);
        }
        return false;
    }

    @CompilerDirectives.TruffleBoundary
    private static boolean isoDateTimeWithinLimitsExact(int year, int month, int day, int hour, int minute, int second, int millisecond, int microsecond, int nanosecond) {
        BigInteger ns = TemporalUtil.getUTCEpochNanoseconds(year, month, day, hour, minute, second, millisecond, microsecond, nanosecond);
        return ns.compareTo(isoTimeLowerBound) > 0 && ns.compareTo(isoTimeUpperBound) < 0;
    }

    public static BigInteger getUTCEpochNanoseconds(int year, int month, int day, int hour, int minute, int second, int millisecond, int microsecond, int nanosecond) {
        assert (TemporalUtil.isValidISODate(year, month, day)) : List.of(Integer.valueOf(year), Integer.valueOf(month), Integer.valueOf(day));
        assert (TemporalUtil.isValidTime(hour, minute, second, millisecond, microsecond, nanosecond));
        long date = TemporalUtil.isoDateToEpochDays(year, month - 1, day);
        long time = hour * 3600000 + minute * 60000 + second * 1000 + millisecond;
        BigInteger ms = BigInteger.valueOf(date).multiply(BigInteger.valueOf(86400000L)).add(BigInteger.valueOf(time));
        BigInteger epochNanoseconds = ms.multiply(BI_10_POW_6).add(BigInteger.valueOf(microsecond * 1000)).add(BigInteger.valueOf(nanosecond));
        return epochNanoseconds;
    }

    public static Overflow toTemporalOverflow(JSDynamicObject options, TemporalGetOptionNode getOptionNode) {
        if (options == Undefined.instance) {
            return Overflow.CONSTRAIN;
        }
        TruffleString result = (TruffleString)getOptionNode.execute(options, TemporalConstants.OVERFLOW, OptionType.STRING, listConstrainReject, TemporalConstants.CONSTRAIN);
        return TemporalUtil.toOverflow(result);
    }

    @CompilerDirectives.TruffleBoundary
    private static Overflow toOverflow(TruffleString result) {
        if (TemporalConstants.CONSTRAIN.equals((Object)result)) {
            return Overflow.CONSTRAIN;
        }
        if (TemporalConstants.REJECT.equals((Object)result)) {
            return Overflow.REJECT;
        }
        CompilerDirectives.transferToInterpreter();
        throw Errors.shouldNotReachHere("unknown overflow type: " + String.valueOf(result));
    }

    public static JSTemporalDateTimeRecord interpretTemporalDateTimeFields(JSDynamicObject calendar, JSDynamicObject fields, JSDynamicObject options, TemporalGetOptionNode getOptionNode, TemporalCalendarDateFromFieldsNode dateFromFieldsNode) {
        JSTemporalDateTimeRecord timeResult = TemporalUtil.toTemporalTimeRecord(fields);
        JSTemporalPlainDateObject date = dateFromFieldsNode.execute(calendar, fields, (Object)options);
        Overflow overflow = TemporalUtil.toTemporalOverflow(options, getOptionNode);
        JSTemporalDurationRecord timeResult2 = TemporalUtil.regulateTime(timeResult.getHour(), timeResult.getMinute(), timeResult.getSecond(), timeResult.getMillisecond(), timeResult.getMicrosecond(), timeResult.getNanosecond(), overflow);
        return JSTemporalDateTimeRecord.create(date.getYear(), date.getMonth(), date.getDay(), TemporalUtil.dtoi(timeResult2.getHours()), TemporalUtil.dtoi(timeResult2.getMinutes()), TemporalUtil.dtoi(timeResult2.getSeconds()), TemporalUtil.dtoi(timeResult2.getMilliseconds()), TemporalUtil.dtoi(timeResult2.getMicroseconds()), TemporalUtil.dtoi(timeResult2.getNanoseconds()));
    }

    public static JSTemporalDurationRecord regulateTime(int hours, int minutes, int seconds, int milliseconds, int microseconds, int nanoseconds, Overflow overflow) {
        assert (overflow == Overflow.CONSTRAIN || overflow == Overflow.REJECT);
        if (overflow == Overflow.CONSTRAIN) {
            return TemporalUtil.constrainTime(hours, minutes, seconds, milliseconds, microseconds, nanoseconds);
        }
        if (!TemporalUtil.isValidTime(hours, minutes, seconds, milliseconds, microseconds, nanoseconds)) {
            throw Errors.createRangeError("Given time outside the range.");
        }
        return JSTemporalDurationRecord.create(0.0, 0.0, 0.0, hours, minutes, seconds, milliseconds, microseconds, nanoseconds);
    }

    public static JSTemporalDurationRecord constrainTime(int hours, int minutes, int seconds, int milliseconds, int microseconds, int nanoseconds) {
        return JSTemporalDurationRecord.create(0.0, 0.0, 0.0, TemporalUtil.constrainToRange(hours, 0, 23), TemporalUtil.constrainToRange(minutes, 0, 59), TemporalUtil.constrainToRange(seconds, 0, 59), TemporalUtil.constrainToRange(milliseconds, 0, 999), TemporalUtil.constrainToRange(microseconds, 0, 999), TemporalUtil.constrainToRange(nanoseconds, 0, 999));
    }

    public static JSTemporalDateTimeRecord toTemporalTimeRecord(JSDynamicObject temporalTimeLike) {
        boolean any = false;
        int hour = 0;
        int minute = 0;
        int second = 0;
        int millisecond = 0;
        int microsecond = 0;
        int nanosecond = 0;
        for (TruffleString property : TIME_LIKE_PROPERTIES) {
            Object val = JSObject.get(temporalTimeLike, property);
            int iVal = 0;
            if (val == Undefined.instance) {
                iVal = 0;
            } else {
                any = true;
                iVal = JSRuntime.intValue(TemporalUtil.toIntegerThrowOnInfinity(val));
            }
            if (TemporalConstants.HOUR.equals((Object)property)) {
                hour = iVal;
                continue;
            }
            if (TemporalConstants.MINUTE.equals((Object)property)) {
                minute = iVal;
                continue;
            }
            if (TemporalConstants.SECOND.equals((Object)property)) {
                second = iVal;
                continue;
            }
            if (TemporalConstants.MILLISECOND.equals((Object)property)) {
                millisecond = iVal;
                continue;
            }
            if (TemporalConstants.MICROSECOND.equals((Object)property)) {
                microsecond = iVal;
                continue;
            }
            if (!TemporalConstants.NANOSECOND.equals((Object)property)) continue;
            nanosecond = iVal;
        }
        if (!any) {
            throw Errors.createTypeError("at least one time-like field expected");
        }
        return JSTemporalDateTimeRecord.create(0, 0, 0, hour, minute, second, millisecond, microsecond, nanosecond);
    }

    public static Number toIntegerThrowOnInfinity(Object value) {
        Number integer = TemporalUtil.toIntegerOrInfinity(value);
        if (Double.isInfinite(JSRuntime.doubleValue(integer))) {
            throw Errors.createRangeError("value outside bounds");
        }
        return integer;
    }

    public static double toIntegerWithoutRounding(Object argument) {
        Number number = JSRuntime.toNumber(argument);
        double dNumber = JSRuntime.doubleValue(number);
        if (Double.isNaN(dNumber) || dNumber == 0.0) {
            return 0.0;
        }
        if (!JSRuntime.isIntegralNumber(dNumber)) {
            throw Errors.createRangeError("value expected to be integer");
        }
        return dNumber;
    }

    @CompilerDirectives.TruffleBoundary
    public static Number toIntegerOrInfinity(Object value) {
        Number number = JSRuntime.toNumber(value);
        double d = number.doubleValue();
        if (d == 0.0 || Double.isNaN(d)) {
            return 0L;
        }
        if (Double.isInfinite(d)) {
            return d;
        }
        return number;
    }

    public static JSTemporalPlainDateObject calendarDateAdd(CalendarMethodsRecord calendarRec, JSDynamicObject date, JSDynamicObject duration) {
        return TemporalUtil.calendarDateAdd(calendarRec, date, duration, Undefined.instance);
    }

    public static JSTemporalPlainDateObject calendarDateAdd(CalendarMethodsRecord calendarRec, JSDynamicObject date, JSDynamicObject duration, JSDynamicObject options) {
        Object dateAddPrepared = calendarRec.dateAdd();
        if (dateAddPrepared == Undefined.instance) {
            dateAddPrepared = JSObject.getMethod(calendarRec.receiver(), TemporalConstants.DATE_ADD);
        }
        Object addedDate = JSRuntime.call(dateAddPrepared, (Object)calendarRec.receiver(), new Object[]{date, duration, options});
        return TemporalUtil.requireTemporalDate(addedDate);
    }

    public static JSTemporalDurationObject calendarDateUntil(CalendarMethodsRecord calendarRec, JSDynamicObject one, JSDynamicObject two, JSDynamicObject options) {
        Object dateUntilPrepared = calendarRec.dateUntil();
        if (dateUntilPrepared == Undefined.instance) {
            dateUntilPrepared = JSObject.getMethod(calendarRec.receiver(), TemporalConstants.DATE_UNTIL);
        }
        Object date = JSRuntime.call(dateUntilPrepared, (Object)calendarRec.receiver(), new Object[]{one, two, options});
        return TemporalUtil.requireTemporalDuration(date);
    }

    @CompilerDirectives.TruffleBoundary
    public static BigInt roundTemporalInstant(BigInt ns, double increment, Unit unit, RoundingMode roundingMode) {
        assert (JSRuntime.isIntegralNumber(increment)) : increment;
        BigDecimal incrementNs = BigDecimal.valueOf(increment);
        if (Unit.HOUR == unit) {
            incrementNs = incrementNs.multiply(BigDecimal.valueOf(3600000000000L));
        } else if (Unit.MINUTE == unit) {
            incrementNs = incrementNs.multiply(BigDecimal.valueOf(60000000000L));
        } else if (Unit.SECOND == unit) {
            incrementNs = incrementNs.multiply(BigDecimal.valueOf(1000000000L));
        } else if (Unit.MILLISECOND == unit) {
            incrementNs = incrementNs.multiply(BigDecimal.valueOf(1000000L));
        } else if (Unit.MICROSECOND == unit) {
            incrementNs = incrementNs.multiply(BigDecimal.valueOf(1000L));
        } else {
            assert (Unit.NANOSECOND == unit) : unit;
            if (incrementNs.compareTo(BigDecimal.ONE) == 0) {
                return ns;
            }
        }
        BigDecimal x = new BigDecimal(ns.bigIntegerValue());
        return BigInt.fromBigInteger(TemporalUtil.roundNumberToIncrementAsIfPositive(x, incrementNs, roundingMode));
    }

    public static ISODateRecord regulateISODate(int year, int monthParam, int dayParam, Overflow overflow) {
        assert (overflow == Overflow.CONSTRAIN || overflow == Overflow.REJECT);
        int month = monthParam;
        int day = dayParam;
        if (overflow == Overflow.REJECT) {
            if (!TemporalUtil.isValidISODate(year, month, day)) {
                throw TemporalErrors.createRangeErrorDateOutsideRange();
            }
        } else {
            assert (overflow == Overflow.CONSTRAIN);
            month = TemporalUtil.constrainToRange(month, 1, 12);
            day = TemporalUtil.constrainToRange(day, 1, TemporalUtil.isoDaysInMonth(year, month));
        }
        return new ISODateRecord(year, month, day);
    }

    @CompilerDirectives.TruffleBoundary
    public static long isoDateToEpochDays(int year, int month, int date) {
        assert (year >= -999999999 && year <= 999999999) : year;
        int resolvedYear = year + month / 12;
        int resolvedMonth = month % 12;
        if (resolvedMonth < 0) {
            resolvedMonth += 12;
        }
        long t = LocalDate.of(resolvedYear, resolvedMonth + 1, 1).atStartOfDay().toInstant(ZoneOffset.UTC).toEpochMilli();
        return Math.floorDiv(t, 86400000) + (long)date - 1L;
    }

    @CompilerDirectives.TruffleBoundary
    public static ISODateRecord balanceISODate(int year, int month, int day) {
        if (year < -999999999 || year > 999999999 || Math.abs(day) > 100000000) {
            throw Errors.createRangeError("Date outside of supported range");
        }
        long epochDays = TemporalUtil.isoDateToEpochDays(year, month - 1, day);
        long ms = epochDays * 86400000L;
        return new ISODateRecord(JSDate.yearFromTime(ms), JSDate.monthFromTime(ms) + 1, JSDate.dateFromTime(ms));
    }

    @CompilerDirectives.TruffleBoundary
    public static ISODateRecord balanceISODate(double year, int month, double day) {
        return TemporalUtil.balanceISODate((int)year, month, (int)day);
    }

    @CompilerDirectives.TruffleBoundary
    public static ISODateRecord addISODate(int year, int month, int day, int years, int months, int weeks, int daysP, Overflow overflow) {
        assert (overflow == Overflow.CONSTRAIN || overflow == Overflow.REJECT);
        int days = daysP;
        ISODateRecord intermediateYM = TemporalUtil.balanceISOYearMonth(year + years, month + months);
        ISODateRecord intermediate = TemporalUtil.regulateISODate(intermediateYM.year(), intermediateYM.month(), day, overflow);
        int d = TemporalUtil.add(intermediate.day(), days += 7 * weeks, overflow);
        intermediate = TemporalUtil.balanceISODate(intermediate.year(), intermediate.month(), d);
        return TemporalUtil.regulateISODate(intermediate.year(), intermediate.month(), intermediate.day(), overflow);
    }

    @CompilerDirectives.TruffleBoundary
    public static ISODateRecord addISODate(int year, int month, int day, double years, double months, double weeks, double daysP, Overflow overflow) {
        assert (overflow == Overflow.CONSTRAIN || overflow == Overflow.REJECT);
        double days = daysP;
        ISODateRecord intermediateYM = TemporalUtil.balanceISOYearMonth((double)year + years, (double)month + months);
        ISODateRecord intermediate = TemporalUtil.regulateISODate(intermediateYM.year(), intermediateYM.month(), day, overflow);
        intermediate = TemporalUtil.balanceISODate((double)intermediate.year(), intermediate.month(), (double)intermediate.day() + (days += 7.0 * weeks));
        return TemporalUtil.regulateISODate(intermediate.year(), intermediate.month(), intermediate.day(), overflow);
    }

    public static int compareISODate(int y1, int m1, int d1, int y2, int m2, int d2) {
        if (y1 > y2) {
            return 1;
        }
        if (y1 < y2) {
            return -1;
        }
        if (m1 > m2) {
            return 1;
        }
        if (m1 < m2) {
            return -1;
        }
        if (d1 > d2) {
            return 1;
        }
        if (d1 < d2) {
            return -1;
        }
        return 0;
    }

    public static JSTemporalPlainDateObject requireTemporalDate(Object obj, Node node, InlinedBranchProfile errorBranch) {
        if (!(obj instanceof JSTemporalPlainDateObject)) {
            errorBranch.enter(node);
            throw TemporalErrors.createTypeErrorTemporalPlainDateExpected();
        }
        return (JSTemporalPlainDateObject)((Object)obj);
    }

    public static JSTemporalPlainDateObject requireTemporalDate(Object obj) {
        if (!(obj instanceof JSTemporalPlainDateObject)) {
            throw TemporalErrors.createTypeErrorTemporalPlainDateExpected();
        }
        return (JSTemporalPlainDateObject)((Object)obj);
    }

    public static JSTemporalDurationObject requireTemporalDuration(Object obj) {
        if (!(obj instanceof JSTemporalDurationObject)) {
            throw TemporalErrors.createTypeErrorTemporalDurationExpected();
        }
        return (JSTemporalDurationObject)((Object)obj);
    }

    public static boolean isTemporalZonedDateTime(Object obj) {
        return JSTemporalZonedDateTime.isJSTemporalZonedDateTime(obj);
    }

    public static ShowCalendar toShowCalendarOption(JSDynamicObject options, TemporalGetOptionNode getOptionNode, TruffleString.EqualNode equalNode) {
        return TemporalUtil.toShowCalendar((TruffleString)getOptionNode.execute(options, CALENDAR_NAME, OptionType.STRING, listAutoAlwaysNever, TemporalConstants.AUTO), equalNode);
    }

    @CompilerDirectives.TruffleBoundary
    public static TruffleString toZeroPaddedDecimalString(long number, int digits) {
        TruffleString decimalStr = Strings.fromLong(number);
        int length = Strings.length(decimalStr);
        if (length < digits) {
            TruffleStringBuilderUTF16 sb = TruffleStringBuilderUTF16.createUTF16((int)digits);
            for (int i = length; i < digits; ++i) {
                Strings.builderAppend(sb, '0');
            }
            Strings.builderAppend(sb, decimalStr);
            return Strings.builderToString(sb);
        }
        return decimalStr;
    }

    @CompilerDirectives.TruffleBoundary
    public static TruffleString padISOYear(int year) {
        if (0 <= year && year <= 9999) {
            return TemporalUtil.toZeroPaddedDecimalString(year, 4);
        }
        TruffleString sign = year > 0 ? Strings.SYMBOL_PLUS : Strings.SYMBOL_MINUS;
        int y = Math.abs(year);
        return Strings.concat(sign, TemporalUtil.toZeroPaddedDecimalString(y, 6));
    }

    @CompilerDirectives.TruffleBoundary
    public static TruffleString formatCalendarAnnotation(TruffleString id, ShowCalendar showCalendar) {
        if (ShowCalendar.NEVER == showCalendar) {
            return Strings.EMPTY_STRING;
        }
        if (ShowCalendar.AUTO == showCalendar && TemporalConstants.ISO8601.equals((Object)id)) {
            return Strings.EMPTY_STRING;
        }
        return Strings.concatAll(BRACKET_U_CA_EQUALS, id, Strings.BRACKET_CLOSE);
    }

    public static RoundingMode negateTemporalRoundingMode(RoundingMode roundingMode) {
        return switch (roundingMode.ordinal()) {
            case 1 -> RoundingMode.FLOOR;
            case 2 -> RoundingMode.CEIL;
            case 8 -> RoundingMode.HALF_CEIL;
            case 9 -> RoundingMode.HALF_FLOOR;
            default -> roundingMode;
        };
    }

    public static boolean calendarEquals(JSDynamicObject one, JSDynamicObject two, JSToStringNode toStringNode) {
        if (one == two) {
            return true;
        }
        return Boundaries.equals(toStringNode.executeString((Object)one), toStringNode.executeString((Object)two));
    }

    public static void rejectTemporalCalendarType(JSDynamicObject obj, Node node, InlinedBranchProfile errorBranch) {
        if (obj instanceof JSTemporalPlainDateObject || obj instanceof JSTemporalPlainDateTimeObject || obj instanceof JSTemporalPlainMonthDayObject || obj instanceof JSTemporalPlainTimeObject || obj instanceof JSTemporalPlainYearMonthObject || TemporalUtil.isTemporalZonedDateTime((Object)obj)) {
            errorBranch.enter(node);
            throw Errors.createTypeError("rejecting calendar types");
        }
    }

    public static JSDynamicObject calendarMergeFields(JSContext ctx, JSRealm realm, JSDynamicObject calendar, JSDynamicObject fields, JSDynamicObject additionalFields, EnumerableOwnPropertyNamesNode namesNode, Node node, InlinedBranchProfile errorBranch) {
        Object mergeFields = JSObject.getMethod(calendar, TemporalConstants.MERGE_FIELDS);
        if (mergeFields == Undefined.instance) {
            return TemporalUtil.defaultMergeFields(ctx, realm, fields, additionalFields, namesNode);
        }
        Object result = JSRuntime.call(mergeFields, (Object)calendar, new Object[]{fields, additionalFields});
        if (!JSRuntime.isObject(result)) {
            throw TemporalErrors.createTypeErrorObjectExpected();
        }
        return TemporalUtil.toJSDynamicObject(result, node, errorBranch);
    }

    @CompilerDirectives.TruffleBoundary
    public static JSDynamicObject defaultMergeFields(JSContext ctx, JSRealm realm, JSDynamicObject fields, JSDynamicObject additionalFields, EnumerableOwnPropertyNamesNode namesNode) {
        JSObject merged = JSOrdinary.create(ctx, realm);
        UnmodifiableArrayList<? extends Object> originalKeys = namesNode.execute((Object)fields);
        for (Object object : originalKeys) {
            Object propValue;
            if (TemporalConstants.MONTH.equals(object) || TemporalConstants.MONTH_CODE.equals(object) || (propValue = JSObject.get(fields, object)) == Undefined.instance) continue;
            TemporalUtil.createDataPropertyOrThrow(ctx, merged, JSRuntime.toString(object), propValue);
        }
        boolean hasMonthOrMonthCode = false;
        UnmodifiableArrayList<? extends Object> unmodifiableArrayList = namesNode.execute((Object)additionalFields);
        for (Object object : unmodifiableArrayList) {
            Object propValue = JSObject.get(additionalFields, object);
            if (propValue == Undefined.instance) continue;
            TemporalUtil.createDataPropertyOrThrow(ctx, merged, JSRuntime.toString(object), propValue);
            if (!TemporalConstants.MONTH.equals(object) && !TemporalConstants.MONTH_CODE.equals(object)) continue;
            hasMonthOrMonthCode = true;
        }
        if (!hasMonthOrMonthCode) {
            Object object;
            Object month = JSObject.get(fields, TemporalConstants.MONTH);
            if (month != Undefined.instance) {
                TemporalUtil.createDataPropertyOrThrow(ctx, merged, TemporalConstants.MONTH, month);
            }
            if ((object = JSObject.get(fields, TemporalConstants.MONTH_CODE)) != Undefined.instance) {
                TemporalUtil.createDataPropertyOrThrow(ctx, merged, TemporalConstants.MONTH_CODE, object);
            }
        }
        return merged;
    }

    public static void createDataPropertyOrThrow(JSContext ctx, JSDynamicObject obj, TruffleString key, Object value) {
        JSObjectUtil.defineDataProperty(ctx, obj, key, value, JSAttributes.configurableEnumerableWritable());
    }

    @CompilerDirectives.TruffleBoundary
    public static List<TruffleString> listJoinRemoveDuplicates(List<TruffleString> first, List<TruffleString> second) {
        ArrayList<TruffleString> newList = new ArrayList<TruffleString>(first.size() + second.size());
        newList.addAll(first);
        for (TruffleString elem : second) {
            if (first.contains(elem)) continue;
            newList.add(elem);
        }
        return newList;
    }

    public static Unit largerOfTwoTemporalUnits(Unit a, Unit b) {
        if (Unit.YEAR == a || Unit.YEAR == b) {
            return Unit.YEAR;
        }
        if (Unit.MONTH == a || Unit.MONTH == b) {
            return Unit.MONTH;
        }
        if (Unit.WEEK == a || Unit.WEEK == b) {
            return Unit.WEEK;
        }
        if (Unit.DAY == a || Unit.DAY == b) {
            return Unit.DAY;
        }
        if (Unit.HOUR == a || Unit.HOUR == b) {
            return Unit.HOUR;
        }
        if (Unit.MINUTE == a || Unit.MINUTE == b) {
            return Unit.MINUTE;
        }
        if (Unit.SECOND == a || Unit.SECOND == b) {
            return Unit.SECOND;
        }
        if (Unit.MILLISECOND == a || Unit.MILLISECOND == b) {
            return Unit.MILLISECOND;
        }
        if (Unit.MICROSECOND == a || Unit.MICROSECOND == b) {
            return Unit.MICROSECOND;
        }
        return Unit.NANOSECOND;
    }

    @CompilerDirectives.TruffleBoundary
    public static JSTemporalDurationRecord differenceISODateTime(JSContext ctx, JSRealm realm, EnumerableOwnPropertyNamesNode namesNode, int y1, int mon1, int d1, int h1, int min1, int s1, int ms1, int mus1, int ns1, int y2, int mon2, int d2, int h2, int min2, int s2, int ms2, int mus2, int ns2, CalendarMethodsRecord calendarRec, Unit largestUnit, JSDynamicObject options) {
        assert (options != null);
        TimeDurationRecord timeDifference = TemporalUtil.differenceTime(h1, min1, s1, ms1, mus1, ns1, h2, min2, s2, ms2, mus2, ns2);
        int timeSign = TemporalUtil.durationSign(0.0, 0.0, 0.0, timeDifference.days(), timeDifference.hours(), timeDifference.minutes(), timeDifference.seconds(), timeDifference.milliseconds(), timeDifference.microseconds(), timeDifference.nanoseconds());
        int dateSign = TemporalUtil.compareISODate(y2, mon2, d2, y1, mon1, d1);
        ISODateRecord balanceResult = TemporalUtil.balanceISODate(y1, mon1, d1 + TemporalUtil.dtoi(timeDifference.days()));
        if (timeSign == -dateSign) {
            balanceResult = TemporalUtil.balanceISODate(balanceResult.year(), balanceResult.month(), balanceResult.day() - timeSign);
            timeDifference = TemporalUtil.balanceTimeDuration(-timeSign, timeDifference.hours(), timeDifference.minutes(), timeDifference.seconds(), timeDifference.milliseconds(), timeDifference.microseconds(), timeDifference.nanoseconds(), largestUnit);
        }
        JSTemporalPlainDateObject date1 = JSTemporalPlainDate.create(ctx, realm, balanceResult.year(), balanceResult.month(), balanceResult.day(), calendarRec.receiver(), null, InlinedBranchProfile.getUncached());
        JSTemporalPlainDateObject date2 = JSTemporalPlainDate.create(ctx, realm, y2, mon2, d2, calendarRec.receiver(), null, InlinedBranchProfile.getUncached());
        Unit dateLargestUnit = TemporalUtil.largerOfTwoTemporalUnits(Unit.DAY, largestUnit);
        JSDynamicObject untilOptions = TemporalUtil.mergeLargestUnitOption(ctx, namesNode, options, dateLargestUnit);
        JSTemporalDurationObject dateDifference = TemporalUtil.calendarDateUntil(calendarRec, date1, date2, untilOptions);
        TimeDurationRecord result = TemporalUtil.balanceTimeDuration(dateDifference.getDays(), timeDifference.hours(), timeDifference.minutes(), timeDifference.seconds(), timeDifference.milliseconds(), timeDifference.microseconds(), timeDifference.nanoseconds(), largestUnit);
        return JSTemporalDurationRecord.createWeeks(dateDifference.getYears(), dateDifference.getMonths(), dateDifference.getWeeks(), result.days(), result.hours(), result.minutes(), result.seconds(), result.milliseconds(), result.microseconds(), result.nanoseconds());
    }

    @CompilerDirectives.TruffleBoundary
    public static JSDynamicObject mergeLargestUnitOption(JSContext ctx, EnumerableOwnPropertyNamesNode namesNode, JSDynamicObject options, Unit largestUnit) {
        JSObject merged = JSOrdinary.createWithNullPrototype(ctx);
        UnmodifiableArrayList<? extends Object> keys = namesNode.execute((Object)options);
        for (Object object : keys) {
            if (!(object instanceof TruffleString)) continue;
            TruffleString key = (TruffleString)object;
            Object propValue = JSObject.get(options, key);
            TemporalUtil.createDataPropertyOrThrow(ctx, merged, key, propValue);
        }
        TemporalUtil.createDataPropertyOrThrow(ctx, merged, TemporalConstants.LARGEST_UNIT, largestUnit.toTruffleString());
        return merged;
    }

    public static int durationSign(double years, double months, double weeks, double days, double hours, double minutes, double seconds, double milliseconds, double microseconds, double nanoseconds) {
        if (years < 0.0) {
            return -1;
        }
        if (years > 0.0) {
            return 1;
        }
        if (months < 0.0) {
            return -1;
        }
        if (months > 0.0) {
            return 1;
        }
        if (weeks < 0.0) {
            return -1;
        }
        if (weeks > 0.0) {
            return 1;
        }
        if (days < 0.0) {
            return -1;
        }
        if (days > 0.0) {
            return 1;
        }
        if (hours < 0.0) {
            return -1;
        }
        if (hours > 0.0) {
            return 1;
        }
        if (minutes < 0.0) {
            return -1;
        }
        if (minutes > 0.0) {
            return 1;
        }
        if (seconds < 0.0) {
            return -1;
        }
        if (seconds > 0.0) {
            return 1;
        }
        if (milliseconds < 0.0) {
            return -1;
        }
        if (milliseconds > 0.0) {
            return 1;
        }
        if (microseconds < 0.0) {
            return -1;
        }
        if (microseconds > 0.0) {
            return 1;
        }
        if (nanoseconds < 0.0) {
            return -1;
        }
        if (nanoseconds > 0.0) {
            return 1;
        }
        return 0;
    }

    @CompilerDirectives.TruffleBoundary
    public static void rejectDurationSign(double years, double months, double weeks, double days, double hours, double minutes, double seconds, double milliseconds, double microseconds, double nanoseconds) {
        long sign = TemporalUtil.durationSign(years, months, weeks, days, hours, minutes, seconds, milliseconds, microseconds, nanoseconds);
        if (years < 0.0 && sign > 0L) {
            throw Errors.createRangeError("Years is negative but it should be positive.");
        }
        if (years > 0.0 && sign < 0L) {
            throw Errors.createRangeError("Years is positive but it should be negative.");
        }
        if (months < 0.0 && sign > 0L) {
            throw Errors.createRangeError("Months is negative but it should be positive.");
        }
        if (months > 0.0 && sign < 0L) {
            throw Errors.createRangeError("Months is positive but it should be negative.");
        }
        if (weeks < 0.0 && sign > 0L) {
            throw Errors.createRangeError("Weeks is negative but it should be positive.");
        }
        if (weeks > 0.0 && sign < 0L) {
            throw Errors.createRangeError("Weeks is positive but it should be negative.");
        }
        if (days < 0.0 && sign > 0L) {
            throw Errors.createRangeError("Days is negative but it should be positive.");
        }
        if (days > 0.0 && sign < 0L) {
            throw Errors.createRangeError("Days is positive but it should be negative.");
        }
        if (hours < 0.0 && sign > 0L) {
            throw Errors.createRangeError("Hours is negative but it should be positive.");
        }
        if (hours > 0.0 && sign < 0L) {
            throw Errors.createRangeError("Hours is positive but it should be negative.");
        }
        if (minutes < 0.0 && sign > 0L) {
            throw Errors.createRangeError("Minutes is negative but it should be positive.");
        }
        if (minutes > 0.0 && sign < 0L) {
            throw Errors.createRangeError("Minutes is positive but it should be negative.");
        }
        if (seconds < 0.0 && sign > 0L) {
            throw Errors.createRangeError("Seconds is negative but it should be positive.");
        }
        if (seconds > 0.0 && sign < 0L) {
            throw Errors.createRangeError("Seconds is positive but it should be negative.");
        }
        if (milliseconds < 0.0 && sign > 0L) {
            throw Errors.createRangeError("Milliseconds is negative but it should be positive.");
        }
        if (milliseconds > 0.0 && sign < 0L) {
            throw Errors.createRangeError("Milliseconds is positive but it should be negative.");
        }
        if (microseconds < 0.0 && sign > 0L) {
            throw Errors.createRangeError("Microseconds is negative but it should be positive.");
        }
        if (microseconds > 0.0 && sign < 0L) {
            throw Errors.createRangeError("Microseconds is positive but it should be negative.");
        }
        if (nanoseconds < 0.0 && sign > 0L) {
            throw Errors.createRangeError("Nanoseconds is negative but it should be positive.");
        }
        if (nanoseconds > 0.0 && sign < 0L) {
            throw Errors.createRangeError("Nanoseconds is positive but it should be negative.");
        }
    }

    public static TimeDurationRecord balanceTimeDuration(BigInt nanoseconds, Unit largestUnit) {
        TimeDurationRecord result = TemporalUtil.balancePossiblyInfiniteTimeDuration(nanoseconds, largestUnit);
        if (result.isOverflow()) {
            throw Errors.createRangeError("Time is infinite");
        }
        return result;
    }

    public static TimeDurationRecord balanceTimeDuration(double days, double hours, double minutes, double seconds, double milliseconds, double microseconds, double nanoseconds, Unit largestUnit) {
        TimeDurationRecord result = TemporalUtil.balancePossiblyInfiniteTimeDuration(days, hours, minutes, seconds, milliseconds, microseconds, nanoseconds, largestUnit);
        if (result.isOverflow()) {
            throw Errors.createRangeError("Time is infinite");
        }
        return result;
    }

    @CompilerDirectives.TruffleBoundary
    public static TimeDurationRecord balancePossiblyInfiniteTimeDuration(double days, double hours, double minutes, double seconds, double milliseconds, double microseconds, double nanoseconds, Unit largestUnit) {
        BigInt ns = TemporalUtil.totalDurationNanoseconds(days, hours, minutes, seconds, milliseconds, microseconds, nanoseconds);
        return TemporalUtil.balancePossiblyInfiniteTimeDuration(ns, largestUnit);
    }

    @CompilerDirectives.TruffleBoundary
    private static TimeDurationRecord balancePossiblyInfiniteTimeDuration(BigInt nanoseconds, Unit largestUnit) {
        BigInteger ns = nanoseconds.bigIntegerValue();
        BigInteger d = BigInteger.ZERO;
        BigInteger h = BigInteger.ZERO;
        BigInteger min = BigInteger.ZERO;
        BigInteger s = BigInteger.ZERO;
        BigInteger ms = BigInteger.ZERO;
        BigInteger us = BigInteger.ZERO;
        double sign = ns.signum() < 0 ? -1.0 : 1.0;
        ns = ns.abs();
        switch (largestUnit.ordinal()) {
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                BigInteger[] qr = ns.divideAndRemainder(BI_1000);
                us = qr[0];
                ns = qr[1];
                qr = us.divideAndRemainder(BI_1000);
                ms = qr[0];
                us = qr[1];
                qr = ms.divideAndRemainder(BI_1000);
                s = qr[0];
                ms = qr[1];
                qr = s.divideAndRemainder(BI_60);
                min = qr[0];
                s = qr[1];
                qr = min.divideAndRemainder(BI_60);
                h = qr[0];
                min = qr[1];
                qr = h.divideAndRemainder(BI_24);
                d = qr[0];
                h = qr[1];
                break;
            }
            case 6: {
                BigInteger[] qr = ns.divideAndRemainder(BI_1000);
                us = qr[0];
                ns = qr[1];
                qr = us.divideAndRemainder(BI_1000);
                ms = qr[0];
                us = qr[1];
                qr = ms.divideAndRemainder(BI_1000);
                s = qr[0];
                ms = qr[1];
                qr = s.divideAndRemainder(BI_60);
                min = qr[0];
                s = qr[1];
                qr = min.divideAndRemainder(BI_60);
                h = qr[0];
                min = qr[1];
                break;
            }
            case 7: {
                BigInteger[] qr = ns.divideAndRemainder(BI_1000);
                us = qr[0];
                ns = qr[1];
                qr = us.divideAndRemainder(BI_1000);
                ms = qr[0];
                us = qr[1];
                qr = ms.divideAndRemainder(BI_1000);
                s = qr[0];
                ms = qr[1];
                qr = s.divideAndRemainder(BI_60);
                min = qr[0];
                s = qr[1];
                break;
            }
            case 8: {
                BigInteger[] qr = ns.divideAndRemainder(BI_1000);
                us = qr[0];
                ns = qr[1];
                qr = us.divideAndRemainder(BI_1000);
                ms = qr[0];
                us = qr[1];
                qr = ms.divideAndRemainder(BI_1000);
                s = qr[0];
                ms = qr[1];
                break;
            }
            case 9: {
                BigInteger[] qr = ns.divideAndRemainder(BI_1000);
                us = qr[0];
                ns = qr[1];
                qr = us.divideAndRemainder(BI_1000);
                ms = qr[0];
                us = qr[1];
                break;
            }
            case 10: {
                BigInteger[] qr = ns.divideAndRemainder(BI_1000);
                us = qr[0];
                ns = qr[1];
                break;
            }
            case 11: {
                break;
            }
            default: {
                throw Errors.shouldNotReachHereUnexpectedValue((Object)largestUnit);
            }
        }
        return new TimeDurationRecord(d.doubleValue() * sign, h.doubleValue() * sign, min.doubleValue() * sign, s.doubleValue() * sign, ms.doubleValue() * sign, us.doubleValue() * sign, ns.doubleValue() * sign);
    }

    public static TimeDurationRecord balanceTimeDurationRelative(double days, double hours, double minutes, double seconds, double milliseconds, double microseconds, double nanoseconds, Unit largestUnit, JSTemporalZonedDateTimeObject zonedRelativeTo, TimeZoneMethodsRecord timeZoneRec, JSTemporalPlainDateTimeObject precalculatedPlainDateTimeOpt, JSContext context, JSRealm realm) {
        TimeDurationRecord result = TemporalUtil.balancePossiblyInfiniteTimeDurationRelative(days, hours, minutes, seconds, milliseconds, microseconds, nanoseconds, largestUnit, zonedRelativeTo, timeZoneRec, precalculatedPlainDateTimeOpt, context, realm);
        double overflow = result.getOverflow();
        if (Double.isInfinite(overflow)) {
            throw Errors.createRangeError("Time is infinite");
        }
        return result;
    }

    @CompilerDirectives.TruffleBoundary
    public static TimeDurationRecord balancePossiblyInfiniteTimeDurationRelative(double days, double hours, double minutes, double seconds, double milliseconds, double microseconds, double nanoseconds, Unit largestUnit, JSTemporalZonedDateTimeObject zonedRelativeTo, TimeZoneMethodsRecord timeZoneRec, JSTemporalPlainDateTimeObject precalculatedPlainDateTimeOpt, JSContext context, JSRealm realm) {
        double balancedDays;
        BigInt endNs;
        BigInt nanosecondsToBalance;
        JSTemporalPlainDateTimeObject precalculatedPlainDateTime = precalculatedPlainDateTimeOpt;
        BigInt intermediateNs = zonedRelativeTo.getNanoseconds();
        JSTemporalInstantObject startInstant = JSTemporalInstant.create(context, realm, intermediateNs);
        if (days != 0.0) {
            if (precalculatedPlainDateTime == null) {
                JSTemporalCalendarObject iso8601Calendar = TemporalUtil.getISO8601Calendar(context, realm);
                precalculatedPlainDateTime = TemporalUtil.builtinTimeZoneGetPlainDateTimeFor(context, realm, timeZoneRec, startInstant, iso8601Calendar);
            }
            AddDaysToZonedDateTimeResult intermediateResult = TemporalUtil.addDaysToZonedDateTime(context, realm, startInstant, precalculatedPlainDateTime, timeZoneRec, TemporalUtil.dtoi(days));
            intermediateNs = intermediateResult.epochNanoseconds();
        }
        if ((nanosecondsToBalance = (endNs = TemporalUtil.addInstant(intermediateNs, hours, minutes, seconds, milliseconds, microseconds, nanoseconds)).subtract(zonedRelativeTo.getNanoseconds())).compareTo(BigInt.ZERO) == 0) {
            return new TimeDurationRecord(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        }
        Unit largestTimeUnit = largestUnit;
        switch (largestUnit.ordinal()) {
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                NanosecondsToDaysResult result;
                if (precalculatedPlainDateTime == null) {
                    JSTemporalCalendarObject iso8601Calendar = TemporalUtil.getISO8601Calendar(context, realm);
                    precalculatedPlainDateTime = TemporalUtil.builtinTimeZoneGetPlainDateTimeFor(context, realm, timeZoneRec, startInstant, iso8601Calendar);
                }
                if (Double.isInfinite(balancedDays = (result = TemporalUtil.nanosecondsToDays(context, realm, nanosecondsToBalance, zonedRelativeTo, timeZoneRec, precalculatedPlainDateTime)).days().doubleValue())) {
                    return new TimeDurationRecord(balancedDays, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
                }
                nanosecondsToBalance = BigInt.fromBigInteger(result.nanoseconds());
                largestTimeUnit = Unit.HOUR;
                break;
            }
            default: {
                balancedDays = 0.0;
            }
        }
        TimeDurationRecord balanceResult = TemporalUtil.balancePossiblyInfiniteTimeDuration(nanosecondsToBalance, largestTimeUnit);
        if (balanceResult.isOverflow()) {
            return balanceResult;
        }
        return new TimeDurationRecord(balancedDays, balanceResult.hours(), balanceResult.minutes(), balanceResult.seconds(), balanceResult.milliseconds(), balanceResult.microseconds(), balanceResult.nanoseconds());
    }

    public static JSDynamicObject toDynamicObject(Object obj) {
        if (obj instanceof JSDynamicObject) {
            return (JSDynamicObject)((Object)obj);
        }
        throw Errors.createTypeErrorNotAnObject(obj);
    }

    public static JSDynamicObject toJSDynamicObject(Object item, Node node, InlinedBranchProfile errorBranch) {
        if (item instanceof JSDynamicObject) {
            return (JSDynamicObject)((Object)item);
        }
        errorBranch.enter(node);
        throw Errors.createTypeError("Interop types not supported in Temporal");
    }

    public static JSTemporalDurationRecord differenceZonedDateTime(JSContext ctx, JSRealm realm, EnumerableOwnPropertyNamesNode namesNode, BigInt ns1, BigInt ns2, TimeZoneMethodsRecord timeZone, CalendarMethodsRecord calendar, Unit largestUnit, JSTemporalPlainDateTimeObject precalculatedPlainDateTime) {
        return TemporalUtil.differenceZonedDateTime(ctx, realm, namesNode, ns1, ns2, timeZone, calendar, largestUnit, precalculatedPlainDateTime, Undefined.instance);
    }

    public static JSTemporalDurationRecord differenceZonedDateTime(JSContext ctx, JSRealm realm, EnumerableOwnPropertyNamesNode namesNode, BigInt ns1, BigInt ns2, TimeZoneMethodsRecord timeZoneRec, CalendarMethodsRecord calendarRec, Unit largestUnit, JSTemporalPlainDateTimeObject precalculatedPlainDateTime, JSDynamicObject options) {
        if (ns1.equals(ns2)) {
            return JSTemporalDurationRecord.createWeeks(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        }
        JSTemporalInstantObject startInstant = JSTemporalInstant.create(ctx, realm, ns1);
        JSTemporalPlainDateTimeObject startDateTime = TemporalUtil.builtinTimeZoneGetPlainDateTimeFor(ctx, realm, timeZoneRec, startInstant, calendarRec.receiver());
        JSTemporalInstantObject endInstant = JSTemporalInstant.create(ctx, realm, ns2);
        JSTemporalPlainDateTimeObject endDateTime = TemporalUtil.builtinTimeZoneGetPlainDateTimeFor(ctx, realm, timeZoneRec, endInstant, calendarRec.receiver());
        JSTemporalDurationRecord dateDifference = TemporalUtil.differenceISODateTime(ctx, realm, namesNode, startDateTime.getYear(), startDateTime.getMonth(), startDateTime.getDay(), startDateTime.getHour(), startDateTime.getMinute(), startDateTime.getSecond(), startDateTime.getMillisecond(), startDateTime.getMicrosecond(), startDateTime.getNanosecond(), endDateTime.getYear(), endDateTime.getMonth(), endDateTime.getDay(), endDateTime.getHour(), endDateTime.getMinute(), endDateTime.getSecond(), endDateTime.getMillisecond(), endDateTime.getMicrosecond(), endDateTime.getNanosecond(), calendarRec, largestUnit, options);
        BigInt intermediateNs = TemporalUtil.addZonedDateTime(ctx, realm, ns1, timeZoneRec, calendarRec, TemporalUtil.dtol(dateDifference.getYears()), TemporalUtil.dtol(dateDifference.getMonths()), TemporalUtil.dtol(dateDifference.getWeeks()), 0L, 0L, 0L, 0L, 0L, 0L, 0L, precalculatedPlainDateTime);
        BigInt timeRemainderNs = ns2.subtract(intermediateNs);
        JSTemporalZonedDateTimeObject intermediate = JSTemporalZonedDateTime.create(ctx, realm, intermediateNs, timeZoneRec.receiver(), calendarRec.receiver());
        NanosecondsToDaysResult result = TemporalUtil.nanosecondsToDays(ctx, realm, timeRemainderNs, intermediate, timeZoneRec);
        TimeDurationRecord timeDifference = TemporalUtil.balanceTimeDuration(BigInt.fromBigInteger(result.nanoseconds()), Unit.HOUR);
        return JSTemporalDurationRecord.createWeeks(dateDifference.getYears(), dateDifference.getMonths(), dateDifference.getWeeks(), TemporalUtil.bitod(result.days()), timeDifference.hours(), timeDifference.minutes(), timeDifference.seconds(), timeDifference.milliseconds(), timeDifference.microseconds(), timeDifference.nanoseconds());
    }

    public static boolean isValidDuration(double years, double months, double weeks, double days, double hours, double minutes, double seconds, double milliseconds, double microseconds, double nanoseconds) {
        int sign = TemporalUtil.durationSign(years, months, weeks, days, hours, minutes, seconds, milliseconds, microseconds, nanoseconds);
        if (years < 0.0 && sign > 0) {
            return false;
        }
        if (years > 0.0 && sign < 0) {
            return false;
        }
        if (months < 0.0 && sign > 0) {
            return false;
        }
        if (months > 0.0 && sign < 0) {
            return false;
        }
        if (weeks < 0.0 && sign > 0) {
            return false;
        }
        if (weeks > 0.0 && sign < 0) {
            return false;
        }
        if (days < 0.0 && sign > 0) {
            return false;
        }
        if (days > 0.0 && sign < 0) {
            return false;
        }
        if (hours < 0.0 && sign > 0) {
            return false;
        }
        if (hours > 0.0 && sign < 0) {
            return false;
        }
        if (minutes < 0.0 && sign > 0) {
            return false;
        }
        if (minutes > 0.0 && sign < 0) {
            return false;
        }
        if (seconds < 0.0 && sign > 0) {
            return false;
        }
        if (seconds > 0.0 && sign < 0) {
            return false;
        }
        if (milliseconds < 0.0 && sign > 0) {
            return false;
        }
        if (milliseconds > 0.0 && sign < 0) {
            return false;
        }
        if (microseconds < 0.0 && sign > 0) {
            return false;
        }
        if (microseconds > 0.0 && sign < 0) {
            return false;
        }
        if (nanoseconds < 0.0 && sign > 0) {
            return false;
        }
        return !(nanoseconds > 0.0) || sign >= 0;
    }

    public static Unit defaultTemporalLargestUnit(double years, double months, double weeks, double days, double hours, double minutes, double seconds, double milliseconds, double microseconds) {
        if (years != 0.0) {
            return Unit.YEAR;
        }
        if (months != 0.0) {
            return Unit.MONTH;
        }
        if (weeks != 0.0) {
            return Unit.WEEK;
        }
        if (days != 0.0) {
            return Unit.DAY;
        }
        if (hours != 0.0) {
            return Unit.HOUR;
        }
        if (minutes != 0.0) {
            return Unit.MINUTE;
        }
        if (seconds != 0.0) {
            return Unit.SECOND;
        }
        if (milliseconds != 0.0) {
            return Unit.MILLISECOND;
        }
        if (microseconds != 0.0) {
            return Unit.MICROSECOND;
        }
        return Unit.NANOSECOND;
    }

    public static JSDynamicObject toPartialDuration(Object temporalDurationLike, JSContext ctx, IsObjectNode isObjectNode, JSToIntegerWithoutRoundingNode toInt, Node node, InlinedBranchProfile errorBranch) {
        if (!isObjectNode.executeBoolean(temporalDurationLike)) {
            errorBranch.enter(node);
            throw Errors.createTypeError("Given duration like is not a object.");
        }
        JSDynamicObject temporalDurationLikeObj = TemporalUtil.toJSDynamicObject(temporalDurationLike, node, errorBranch);
        JSRealm realm = JSRealm.get(null);
        JSObject result = JSOrdinary.create(ctx, realm);
        boolean any = false;
        for (UnitPlural unit : DURATION_PROPERTIES) {
            Object value = JSObject.get(temporalDurationLikeObj, unit.toTruffleString());
            if (value == Undefined.instance) continue;
            any = true;
            JSObjectUtil.putDataProperty(result, unit.toTruffleString(), toInt.executeDouble(value));
        }
        if (!any) {
            errorBranch.enter(node);
            throw Errors.createTypeError("Given duration like object has no duration properties.");
        }
        return result;
    }

    @CompilerDirectives.TruffleBoundary
    public static double roundDurationCalculateFractionalSeconds(double seconds, double milliseconds, double microseconds, double nanoseconds) {
        assert (JSRuntime.isIntegralNumber(seconds) && JSRuntime.isIntegralNumber(milliseconds) && JSRuntime.isIntegralNumber(microseconds) && JSRuntime.isIntegralNumber(nanoseconds));
        BigDecimal part1 = BigDecimal.valueOf(nanoseconds).multiply(BD_10_POW_M_9);
        BigDecimal part2 = BigDecimal.valueOf(microseconds).multiply(BD_10_POW_M_6);
        BigDecimal part3 = BigDecimal.valueOf(milliseconds).multiply(BD_10_POW_M_3);
        return part1.add(part2).add(part3).add(BigDecimal.valueOf(seconds)).doubleValue();
    }

    public static NanosecondsToDaysResult nanosecondsToDays(JSContext ctx, JSRealm realm, BigInt nanoseconds, JSTemporalZonedDateTimeObject zonedRelativeTo, TimeZoneMethodsRecord timeZoneRec) {
        return TemporalUtil.nanosecondsToDays(ctx, realm, nanoseconds, zonedRelativeTo, timeZoneRec, null);
    }

    @CompilerDirectives.TruffleBoundary
    public static NanosecondsToDaysResult nanosecondsToDays(JSContext ctx, JSRealm realm, BigInt nanosecondsParam, JSTemporalZonedDateTimeObject zonedRelativeTo, TimeZoneMethodsRecord timeZoneRec, JSTemporalPlainDateTimeObject precalculatedPlainDateTimeOpt) {
        BigInteger nanoseconds = nanosecondsParam.bigIntegerValue();
        int sign = nanoseconds.signum();
        BigInteger signBI = BigInteger.valueOf(sign);
        BigInteger dayLengthNs = BI_8_64_13;
        if (sign == 0) {
            return new NanosecondsToDaysResult(BigInteger.ZERO, BigInteger.ZERO, dayLengthNs);
        }
        if (!TemporalUtil.isTemporalZonedDateTime((Object)zonedRelativeTo)) {
            BigInteger val = nanoseconds.divide(dayLengthNs);
            BigInteger val2 = nanoseconds.abs().mod(dayLengthNs).multiply(signBI);
            return new NanosecondsToDaysResult(val, val2, dayLengthNs);
        }
        BigInt startNs = zonedRelativeTo.getNanoseconds();
        JSTemporalInstantObject startInstant = JSTemporalInstant.create(ctx, realm, startNs);
        JSTemporalCalendarObject iso8601 = TemporalUtil.getISO8601Calendar(ctx, realm);
        JSTemporalPlainDateTimeObject startDateTime = precalculatedPlainDateTimeOpt != null ? precalculatedPlainDateTimeOpt : TemporalUtil.builtinTimeZoneGetPlainDateTimeFor(ctx, realm, timeZoneRec, startInstant, iso8601);
        BigInt endNs = startNs.add(nanosecondsParam);
        JSTemporalInstantObject endInstant = JSTemporalInstant.create(ctx, realm, endNs);
        JSTemporalPlainDateTimeObject endDateTime = TemporalUtil.builtinTimeZoneGetPlainDateTimeFor(ctx, realm, timeZoneRec, endInstant, iso8601);
        JSTemporalPlainDateObject date1 = JSTemporalPlainDate.create(ctx, realm, startDateTime.getYear(), startDateTime.getMonth(), startDateTime.getDay(), iso8601, null, InlinedBranchProfile.getUncached());
        JSTemporalPlainDateObject date2 = JSTemporalPlainDate.create(ctx, realm, endDateTime.getYear(), endDateTime.getMonth(), endDateTime.getDay(), iso8601, null, InlinedBranchProfile.getUncached());
        int days = (int)TemporalUtil.daysUntil(date1, date2);
        AddDaysToZonedDateTimeResult relativeResult = TemporalUtil.addDaysToZonedDateTime(ctx, realm, startInstant, startDateTime, timeZoneRec, days);
        if (sign == 1) {
            while (days > 0 && relativeResult.epochNanoseconds().compareTo(endNs) > 0) {
                relativeResult = TemporalUtil.addDaysToZonedDateTime(ctx, realm, startInstant, startDateTime, timeZoneRec, --days);
            }
        }
        nanoseconds = endNs.subtract(relativeResult.epochNanoseconds()).bigIntegerValue();
        boolean done = false;
        while (!done) {
            AddDaysToZonedDateTimeResult oneDayFarther = TemporalUtil.addDaysToZonedDateTime(ctx, realm, relativeResult.instant(), relativeResult.dateTime(), timeZoneRec, sign);
            dayLengthNs = oneDayFarther.epochNanoseconds().subtract(relativeResult.epochNanoseconds()).bigIntegerValue();
            if (nanoseconds.subtract(dayLengthNs).multiply(signBI).compareTo(BigInteger.ZERO) >= 0) {
                nanoseconds = nanoseconds.subtract(dayLengthNs);
                relativeResult = oneDayFarther;
                days += sign;
                continue;
            }
            done = true;
        }
        if (days < 0 && sign == 1 || days > 0 && sign == -1) {
            throw Errors.createRangeError("NanosecondsToDays returned invalid days");
        }
        if (nanoseconds.signum() < 0) {
            assert (sign == -1) : sign;
        } else if (nanoseconds.signum() > 0 && sign == -1) {
            throw Errors.createRangeError("NanosecondsToDays returned invalid nanoseconds");
        }
        assert (nanoseconds.abs().compareTo(dayLengthNs.abs()) < 0);
        return new NanosecondsToDaysResult(BigInteger.valueOf(days), nanoseconds, dayLengthNs.abs());
    }

    public static AddDaysToZonedDateTimeResult addDaysToZonedDateTime(JSContext ctx, JSRealm realm, JSTemporalInstantObject instant, JSTemporalPlainDateTimeObject dateTime, TimeZoneMethodsRecord timeZoneRec, int days) {
        return TemporalUtil.addDaysToZonedDateTime(ctx, realm, instant, dateTime, timeZoneRec, days, Overflow.CONSTRAIN);
    }

    public static AddDaysToZonedDateTimeResult addDaysToZonedDateTime(JSContext ctx, JSRealm realm, JSTemporalInstantObject instant, JSTemporalPlainDateTimeObject dateTime, TimeZoneMethodsRecord timeZoneRec, int days, Overflow overflow) {
        if (days == 0) {
            return new AddDaysToZonedDateTimeResult(instant.getNanoseconds(), instant, dateTime);
        }
        ISODateRecord addedDate = TemporalUtil.addISODate(dateTime.getYear(), dateTime.getMonth(), dateTime.getDay(), 0, 0, 0, days, overflow);
        JSTemporalPlainDateTimeObject dateTimeResult = JSTemporalPlainDateTime.create(ctx, realm, addedDate.year(), addedDate.month(), addedDate.day(), dateTime.getHour(), dateTime.getMinute(), dateTime.getSecond(), dateTime.getMillisecond(), dateTime.getMicrosecond(), dateTime.getNanosecond(), dateTime.getCalendar());
        JSTemporalInstantObject instantResult = TemporalUtil.builtinTimeZoneGetInstantFor(ctx, realm, timeZoneRec, dateTimeResult, Disambiguation.COMPATIBLE);
        return new AddDaysToZonedDateTimeResult(instantResult.getNanoseconds(), instant, dateTimeResult);
    }

    public static JSTemporalDurationRecord adjustRoundedDurationDays(JSContext ctx, JSRealm realm, TemporalDurationAddNode durationAddNode, TemporalRoundDurationNode roundDurationNode, double years, double months, double weeks, double days, double hours, double minutes, double seconds, double milliseconds, double microseconds, double nanoseconds, double increment, Unit unit, RoundingMode roundingMode, JSTemporalZonedDateTimeObject zonedRelativeTo, CalendarMethodsRecord calendarRec, TimeZoneMethodsRecord timeZoneRec, JSTemporalPlainDateTimeObject precalculatedPlainDateTime) {
        JSTemporalPlainDateTimeObject dayStartDateTime;
        if (zonedRelativeTo == null || unit == Unit.YEAR || unit == Unit.MONTH || unit == Unit.WEEK || unit == Unit.DAY || unit == Unit.NANOSECOND && increment == 1.0) {
            return JSTemporalDurationRecord.createWeeks(years, months, weeks, days, hours, minutes, seconds, milliseconds, microseconds, nanoseconds);
        }
        long timeRemainderNs = TemporalUtil.totalDurationNanoseconds(0.0, hours, minutes, seconds, milliseconds, microseconds, nanoseconds).longValue();
        int direction = Long.signum(timeRemainderNs);
        BigInt dayStart = TemporalUtil.addZonedDateTime(ctx, realm, zonedRelativeTo.getNanoseconds(), timeZoneRec, calendarRec, TemporalUtil.dtol(years), TemporalUtil.dtol(months), TemporalUtil.dtol(weeks), TemporalUtil.dtol(days), 0L, 0L, 0L, 0L, 0L, 0L, precalculatedPlainDateTime);
        JSTemporalInstantObject dayStartInstant = JSTemporalInstant.create(ctx, realm, dayStart);
        AddDaysToZonedDateTimeResult dayEnd = TemporalUtil.addDaysToZonedDateTime(ctx, realm, dayStartInstant, dayStartDateTime = TemporalUtil.builtinTimeZoneGetPlainDateTimeFor(ctx, realm, timeZoneRec, dayStartInstant, calendarRec.receiver()), timeZoneRec, direction);
        long dayLengthNs = TemporalUtil.bigIntToLong(dayEnd.epochNanoseconds().subtract(dayStart));
        long oneDayLess = timeRemainderNs - dayLengthNs;
        if (oneDayLess * (long)direction < 0L) {
            return JSTemporalDurationRecord.createWeeks(years, months, weeks, days, hours, minutes, seconds, milliseconds, microseconds, nanoseconds);
        }
        JSTemporalDurationRecord add = durationAddNode.execute(TemporalUtil.dtol(years), TemporalUtil.dtol(months), TemporalUtil.dtol(weeks), TemporalUtil.dtol(days), 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, direction, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, zonedRelativeTo, calendarRec, timeZoneRec, precalculatedPlainDateTime);
        JSTemporalDurationRecord atd = roundDurationNode.execute(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, oneDayLess, increment, unit, roundingMode);
        TimeDurationRecord btd = TemporalUtil.balanceTimeDuration(0.0, atd.getHours(), atd.getMinutes(), atd.getSeconds(), atd.getMilliseconds(), atd.getMicroseconds(), atd.getNanoseconds(), Unit.HOUR);
        return JSTemporalDurationRecord.createWeeks(add.getYears(), add.getMonths(), add.getWeeks(), add.getDays(), btd.hours(), btd.minutes(), btd.seconds(), btd.milliseconds(), btd.microseconds(), btd.nanoseconds());
    }

    private static BigInteger dtobi(double d) {
        return new BigDecimal(d).toBigInteger();
    }

    @CompilerDirectives.TruffleBoundary
    public static BigInt totalDurationNanoseconds(double days, double hours, double minutes, double seconds, double milliseconds, double microseconds, double nanoseconds) {
        BigInteger d = TemporalUtil.dtobi(days).multiply(BI_24);
        BigInteger h = TemporalUtil.dtobi(hours).add(d);
        BigInteger min = TemporalUtil.dtobi(minutes).add(h.multiply(BI_60));
        BigInteger s = TemporalUtil.dtobi(seconds).add(min.multiply(BI_60));
        BigInteger ms = TemporalUtil.dtobi(milliseconds).add(s.multiply(BI_1000));
        BigInteger us = TemporalUtil.dtobi(microseconds).add(ms.multiply(BI_1000));
        BigInteger ns = TemporalUtil.dtobi(nanoseconds).add(us.multiply(BI_1000));
        return BigInt.fromBigInteger(ns);
    }

    @CompilerDirectives.TruffleBoundary
    public static long daysUntil(JSTemporalPlainDateObject earlier, JSTemporalPlainDateObject later) {
        double epochDays1 = JSDate.makeDay(earlier.getYear(), earlier.getMonth() - 1, earlier.getDay());
        assert (Double.isFinite(epochDays1));
        double epochDays2 = JSDate.makeDay(later.getYear(), later.getMonth() - 1, later.getDay());
        assert (Double.isFinite(epochDays2));
        return TemporalUtil.dtol(epochDays2 - epochDays1);
    }

    public static TimeDurationRecord differenceTime(int h1, int min1, int s1, int ms1, int mus1, int ns1, int h2, int min2, int s2, int ms2, int mus2, int ns2) {
        int hours = h2 - h1;
        int minutes = min2 - min1;
        int seconds = s2 - s1;
        int milliseconds = ms2 - ms1;
        int microseconds = mus2 - mus1;
        int nanoseconds = ns2 - ns1;
        int sign = TemporalUtil.durationSign(0.0, 0.0, 0.0, 0.0, hours, minutes, seconds, milliseconds, microseconds, nanoseconds);
        TimeRecord bt = TemporalUtil.balanceTime(hours * sign, minutes * sign, seconds * sign, milliseconds * sign, microseconds * sign, nanoseconds * sign);
        return new TimeDurationRecord(bt.days() * (double)sign, bt.hour() * sign, bt.minute() * sign, bt.second() * sign, bt.millisecond() * sign, bt.microsecond() * sign, bt.nanosecond() * sign);
    }

    public static TimeRecord roundTime(int hours, int minutes, int seconds, int milliseconds, int microseconds, int nanoseconds, double increment, Unit unit, RoundingMode roundingMode, Long dayLengthNsParam) {
        double quantity;
        double fractionalSecond = (double)nanoseconds / 1.0E9 + (double)microseconds / 1000000.0 + (double)milliseconds / 1000.0 + (double)seconds;
        if (unit == Unit.DAY) {
            long dayLengthNs = dayLengthNsParam == null ? 86300000000000L : dayLengthNsParam;
            quantity = (double)(((((hours * 60 + minutes) * 60 + seconds) * 1000 + milliseconds) * 1000 + microseconds) * 1000 + nanoseconds) / (double)dayLengthNs;
        } else if (unit == Unit.HOUR) {
            quantity = (fractionalSecond / 60.0 + (double)minutes) / 60.0 + (double)hours;
        } else if (unit == Unit.MINUTE) {
            quantity = fractionalSecond / 60.0 + (double)minutes;
        } else if (unit == Unit.SECOND) {
            quantity = fractionalSecond;
        } else if (unit == Unit.MILLISECOND) {
            quantity = (double)nanoseconds / 1000000.0 + (double)microseconds / 1000.0 + (double)milliseconds;
        } else if (unit == Unit.MICROSECOND) {
            quantity = (double)nanoseconds / 1000.0 + (double)microseconds;
        } else {
            assert (unit == Unit.NANOSECOND);
            quantity = nanoseconds;
        }
        long result = TemporalUtil.dtol(TemporalUtil.roundNumberToIncrement(quantity, increment, roundingMode));
        if (unit == Unit.DAY) {
            return new TimeRecord(result, 0, 0, 0, 0, 0, 0);
        }
        if (unit == Unit.HOUR) {
            return TemporalUtil.balanceTime(result, 0L, 0L, 0L, 0L, 0L);
        }
        if (unit == Unit.MINUTE) {
            return TemporalUtil.balanceTime(hours, result, 0L, 0L, 0L, 0L);
        }
        if (unit == Unit.SECOND) {
            return TemporalUtil.balanceTime(hours, minutes, result, 0L, 0L, 0L);
        }
        if (unit == Unit.MILLISECOND) {
            return TemporalUtil.balanceTime(hours, minutes, seconds, result, 0L, 0L);
        }
        if (unit == Unit.MICROSECOND) {
            return TemporalUtil.balanceTime(hours, minutes, seconds, milliseconds, result, 0L);
        }
        assert (unit == Unit.NANOSECOND);
        return TemporalUtil.balanceTime(hours, minutes, seconds, milliseconds, microseconds, result);
    }

    public static TimeRecord balanceTimeDouble(double h, double min, double sec, double mils, double mics, double ns, Node node, InlinedBranchProfile errorBranch) {
        if (h == Double.POSITIVE_INFINITY || h == Double.NEGATIVE_INFINITY || min == Double.POSITIVE_INFINITY || min == Double.NEGATIVE_INFINITY || sec == Double.POSITIVE_INFINITY || sec == Double.NEGATIVE_INFINITY || mils == Double.POSITIVE_INFINITY || mils == Double.NEGATIVE_INFINITY || mics == Double.POSITIVE_INFINITY || mics == Double.NEGATIVE_INFINITY || ns == Double.POSITIVE_INFINITY || ns == Double.NEGATIVE_INFINITY) {
            errorBranch.enter(node);
            throw Errors.createRangeError("Time is infinite");
        }
        double microseconds = mics;
        double milliseconds = mils;
        double nanoseconds = ns;
        double seconds = sec;
        double minutes = min;
        double hours = h;
        microseconds += Math.floor(nanoseconds / 1000.0);
        nanoseconds = TemporalUtil.nonNegativeModulo(nanoseconds, 1000);
        milliseconds += Math.floor(microseconds / 1000.0);
        microseconds = TemporalUtil.nonNegativeModulo(microseconds, 1000);
        seconds += Math.floor(milliseconds / 1000.0);
        milliseconds = TemporalUtil.nonNegativeModulo(milliseconds, 1000);
        minutes += Math.floor(seconds / 60.0);
        seconds = TemporalUtil.nonNegativeModulo(seconds, 60);
        hours += Math.floor(minutes / 60.0);
        minutes = TemporalUtil.nonNegativeModulo(minutes, 60);
        double days = Math.floor(hours / 24.0);
        hours = TemporalUtil.nonNegativeModulo(hours, 24);
        return new TimeRecord(days, (int)hours, (int)minutes, (int)seconds, (int)milliseconds, (int)microseconds, (int)nanoseconds);
    }

    public static TimeRecord balanceTime(long h, long min, long sec, long mils, long mics, long ns) {
        long microseconds = mics;
        long milliseconds = mils;
        long nanoseconds = ns;
        long seconds = sec;
        long minutes = min;
        long hours = h;
        microseconds += Math.floorDiv(nanoseconds, 1000);
        nanoseconds = TemporalUtil.nonNegativeModulo(nanoseconds, 1000);
        milliseconds += Math.floorDiv(microseconds, 1000);
        microseconds = TemporalUtil.nonNegativeModulo(microseconds, 1000);
        seconds += Math.floorDiv(milliseconds, 1000);
        milliseconds = TemporalUtil.nonNegativeModulo(milliseconds, 1000);
        minutes += Math.floorDiv(seconds, 60);
        seconds = TemporalUtil.nonNegativeModulo(seconds, 60);
        hours += Math.floorDiv(minutes, 60);
        minutes = TemporalUtil.nonNegativeModulo(minutes, 60);
        long days = Math.floorDiv(hours, 24);
        hours = TemporalUtil.nonNegativeModulo(hours, 24);
        return new TimeRecord(days, (int)hours, (int)minutes, (int)seconds, (int)milliseconds, (int)microseconds, (int)nanoseconds);
    }

    public static int compareTemporalTime(int h1, int min1, int s1, int ms1, int mus1, int ns1, int h2, int min2, int s2, int ms2, int mus2, int ns2) {
        if (h1 > h2) {
            return 1;
        }
        if (h1 < h2) {
            return -1;
        }
        if (min1 > min2) {
            return 1;
        }
        if (min1 < min2) {
            return -1;
        }
        if (s1 > s2) {
            return 1;
        }
        if (s1 < s2) {
            return -1;
        }
        if (ms1 > ms2) {
            return 1;
        }
        if (ms1 < ms2) {
            return -1;
        }
        if (mus1 > mus2) {
            return 1;
        }
        if (mus1 < mus2) {
            return -1;
        }
        if (ns1 > ns2) {
            return 1;
        }
        if (ns1 < ns2) {
            return -1;
        }
        return 0;
    }

    public static TimeRecord addTimeDouble(int hour, int minute, int second, int millisecond, int microsecond, double nanosecond, double hours, double minutes, double seconds, double milliseconds, double microseconds, double nanoseconds, Node node, InlinedBranchProfile errorBranch) {
        return TemporalUtil.balanceTimeDouble((double)hour + hours, (double)minute + minutes, (double)second + seconds, (double)millisecond + milliseconds, (double)microsecond + microseconds, nanosecond + nanoseconds, node, errorBranch);
    }

    public static JSTemporalDurationRecord roundISODateTime(int year, int month, int day, int hour, int minute, int second, int millisecond, int microsecond, int nanosecond, double increment, Unit unit, RoundingMode roundingMode, Long dayLength) {
        TimeRecord rt = TemporalUtil.roundTime(hour, minute, second, millisecond, microsecond, nanosecond, increment, unit, roundingMode, dayLength);
        ISODateRecord br = TemporalUtil.balanceISODate(year, month, day + TemporalUtil.dtoi(rt.days()));
        return JSTemporalDurationRecord.create(br.year(), br.month(), br.day(), rt.hour(), rt.minute(), rt.second(), rt.millisecond(), rt.microsecond(), rt.nanosecond());
    }

    public static double toTemporalDateTimeRoundingIncrement(JSDynamicObject options, Unit smallestUnit, IsObjectNode isObject, JSToNumberNode toNumber) {
        int maximum = 0;
        if (Unit.DAY == smallestUnit) {
            maximum = 1;
        } else if (Unit.HOUR == smallestUnit) {
            maximum = 24;
        } else if (Unit.MINUTE == smallestUnit || Unit.SECOND == smallestUnit) {
            maximum = 60;
        } else {
            assert (Unit.MILLISECOND == smallestUnit || Unit.MICROSECOND == smallestUnit || Unit.NANOSECOND == smallestUnit);
            maximum = 1000;
        }
        return TemporalUtil.toTemporalRoundingIncrement(options, Double.valueOf(maximum), false, isObject, toNumber);
    }

    public static boolean isValidTime(int hours, int minutes, int seconds, int milliseconds, int microseconds, int nanoseconds) {
        if (hours < 0 || hours > 23) {
            return false;
        }
        if (minutes < 0 || minutes > 59) {
            return false;
        }
        if (seconds < 0 || seconds > 59) {
            return false;
        }
        if (milliseconds < 0 || milliseconds > 999) {
            return false;
        }
        if (microseconds < 0 || microseconds > 999) {
            return false;
        }
        return nanoseconds >= 0 && nanoseconds <= 999;
    }

    public static boolean isValidISODate(int year, int month, int day) {
        if (month < 1 || month > 12) {
            return false;
        }
        return day >= 1 && day <= TemporalUtil.isoDaysInMonth(year, month);
    }

    public static JSTemporalPlainDateTimeObject systemDateTime(Object temporalTimeZoneLike, Object calendarLike, JSContext ctx, JSRealm realm, ToTemporalCalendarNode toTemporalCalendar, ToTemporalTimeZoneNode toTemporalTimeZone) {
        JSDynamicObject timeZone = temporalTimeZoneLike == Undefined.instance ? TemporalUtil.systemTimeZone(ctx, realm) : toTemporalTimeZone.execute(temporalTimeZoneLike);
        JSDynamicObject calendar = toTemporalCalendar.execute(calendarLike);
        JSTemporalInstantObject instant = TemporalUtil.systemInstant(ctx, realm);
        TimeZoneMethodsRecord timeZoneRec = TemporalUtil.createTimeZoneMethodsRecordOnlyGetOffsetNanosecondsFor(timeZone);
        return TemporalUtil.builtinTimeZoneGetPlainDateTimeFor(ctx, realm, timeZoneRec, instant, calendar);
    }

    @CompilerDirectives.TruffleBoundary
    public static JSTemporalPlainDateTimeObject builtinTimeZoneGetPlainDateTimeFor(JSContext ctx, JSRealm realm, TimeZoneMethodsRecord timeZoneRec, JSTemporalInstantObject instant, JSDynamicObject calendar) {
        long offsetNanoseconds = TemporalUtil.getOffsetNanosecondsFor(timeZoneRec, instant);
        return TemporalUtil.builtinTimeZoneGetPlainDateTimeFor(ctx, realm, instant, calendar, offsetNanoseconds);
    }

    @CompilerDirectives.TruffleBoundary
    public static JSTemporalPlainDateTimeObject builtinTimeZoneGetPlainDateTimeFor(JSContext ctx, JSRealm realm, JSTemporalInstantObject instant, JSDynamicObject calendar, long precalculatedOffsetNanoseconds) {
        long offsetNanoseconds = precalculatedOffsetNanoseconds;
        assert ((double)Math.abs(offsetNanoseconds) < 8.64E13) : offsetNanoseconds;
        JSTemporalDateTimeRecord result = TemporalUtil.getISOPartsFromEpoch(instant.getNanoseconds());
        JSTemporalDateTimeRecord result2 = TemporalUtil.balanceISODateTime(result.getYear(), result.getMonth(), result.getDay(), result.getHour(), result.getMinute(), result.getSecond(), result.getMillisecond(), result.getMicrosecond(), (long)result.getNanosecond() + offsetNanoseconds);
        return JSTemporalPlainDateTime.create(ctx, realm, result2.getYear(), result2.getMonth(), result2.getDay(), result2.getHour(), result2.getMinute(), result2.getSecond(), result2.getMillisecond(), result2.getMicrosecond(), result2.getNanosecond(), calendar);
    }

    public static JSTemporalDateTimeRecord balanceISODateTime(int year, int month, int day, int hour, int minute, int second, int millisecond, int microsecond, long nanosecond) {
        TimeRecord bt = TemporalUtil.balanceTime(hour, minute, second, millisecond, microsecond, nanosecond);
        ISODateRecord bd = TemporalUtil.balanceISODate(year, month, day + (int)bt.days());
        return JSTemporalDateTimeRecord.create(bd.year(), bd.month(), bd.day(), bt.hour(), bt.minute(), bt.second(), bt.millisecond(), bt.microsecond(), bt.nanosecond());
    }

    @CompilerDirectives.TruffleBoundary
    public static JSTemporalDateTimeRecord getISOPartsFromEpoch(BigInt epochNanoseconds) {
        long epochMilliseconds;
        long remainderNs;
        if (epochNanoseconds.fitsInLong()) {
            remainderNs = epochNanoseconds.longValue() % 1000000L;
            epochMilliseconds = (epochNanoseconds.longValue() - remainderNs) / 1000000L;
        } else {
            BigInteger[] result = epochNanoseconds.bigIntegerValue().divideAndRemainder(BI_10_POW_6);
            remainderNs = result[1].longValue();
            epochMilliseconds = result[0].longValue();
        }
        int year = JSDate.yearFromTime(epochMilliseconds);
        int month = JSDate.monthFromTime(epochMilliseconds) + 1;
        int day = JSDate.dateFromTime(epochMilliseconds);
        int hour = JSDate.hourFromTime(epochMilliseconds);
        int minute = JSDate.minFromTime(epochMilliseconds);
        int second = JSDate.secFromTime(epochMilliseconds);
        int millisecond = JSDate.msFromTime(epochMilliseconds);
        int microsecond = (int)(remainderNs / 1000L % 1000L);
        int nanosecond = (int)(remainderNs % 1000L);
        return JSTemporalDateTimeRecord.create(year, month, day, hour, minute, second, millisecond, microsecond, nanosecond);
    }

    @CompilerDirectives.TruffleBoundary
    public static long getOffsetNanosecondsFor(TimeZoneMethodsRecord timeZoneRec, JSDynamicObject instant) {
        assert (timeZoneRec.getOffsetNanosecondsFor() != null);
        Object getOffsetNanosecondsFor = timeZoneRec.getOffsetNanosecondsFor();
        Object offsetNanoseconds = JSRuntime.call(getOffsetNanosecondsFor, (Object)timeZoneRec.receiver(), new Object[]{instant});
        if (!JSRuntime.isNumber(offsetNanoseconds)) {
            throw Errors.createTypeError("Number expected");
        }
        if (offsetNanoseconds instanceof Integer) {
            Integer intValue = (Integer)offsetNanoseconds;
            return intValue.intValue();
        }
        double nanos = ((Number)offsetNanoseconds).doubleValue();
        if (!JSRuntime.isInteger(nanos) || Math.abs(nanos) >= 8.64E13) {
            throw Errors.createRangeError("out-of-range Number");
        }
        return (long)nanos;
    }

    public static JSTemporalZonedDateTimeObject systemZonedDateTime(Object temporalTimeZoneLike, Object calendarLike, JSContext ctx, JSRealm realm, ToTemporalCalendarNode toTemporalCalendar, ToTemporalTimeZoneNode toTemporalTimeZone) {
        JSDynamicObject timeZone = temporalTimeZoneLike == Undefined.instance ? TemporalUtil.systemTimeZone(ctx, realm) : toTemporalTimeZone.execute(temporalTimeZoneLike);
        JSDynamicObject calendar = toTemporalCalendar.execute(calendarLike);
        BigInt ns = TemporalUtil.systemUTCEpochNanoseconds();
        return JSTemporalZonedDateTime.create(ctx, realm, ns, timeZone, calendar);
    }

    public static JSTemporalInstantObject systemInstant(JSContext ctx, JSRealm realm) {
        BigInt ns = TemporalUtil.systemUTCEpochNanoseconds();
        return JSTemporalInstant.create(ctx, realm, ns);
    }

    @CompilerDirectives.TruffleBoundary
    public static BigInt systemUTCEpochNanoseconds() {
        JSRealm realm = JSRealm.get(null);
        BigInt ns = BigInt.valueOf(realm.nanoTimeWallClock());
        assert (ns.compareTo(upperEpochNSLimit) <= 0 && ns.compareTo(lowerEpochNSLimit) >= 0);
        return ns;
    }

    public static JSTemporalTimeZoneObject systemTimeZone(JSContext ctx, JSRealm realm) {
        TruffleString identifier = TemporalUtil.defaultTimeZone();
        return TemporalUtil.createTemporalTimeZone(ctx, realm, identifier);
    }

    public static TruffleString defaultTimeZone() {
        return TemporalConstants.UTC;
    }

    public static boolean isTemporalInstant(Object obj) {
        return JSTemporalInstant.isJSTemporalInstant(obj);
    }

    public static int compareEpochNanoseconds(BigInt one, BigInt two) {
        return one.compareTo(two);
    }

    @CompilerDirectives.TruffleBoundary
    public static boolean isValidEpochNanoseconds(BigInt nanoseconds) {
        if (nanoseconds == null) {
            return true;
        }
        return nanoseconds.compareTo(lowerEpochNSLimit) >= 0 && nanoseconds.compareTo(upperEpochNSLimit) <= 0;
    }

    @CompilerDirectives.TruffleBoundary
    public static BigInt addInstant(BigInt epochNanoseconds, double hours, double minutes, double seconds, double milliseconds, double microseconds, double nanoseconds) {
        return TemporalUtil.addInstant(epochNanoseconds, TemporalUtil.dtol(hours), TemporalUtil.dtol(minutes), TemporalUtil.dtol(seconds), TemporalUtil.dtol(milliseconds), TemporalUtil.dtol(microseconds), BigInteger.valueOf(TemporalUtil.dtol(nanoseconds)));
    }

    @CompilerDirectives.TruffleBoundary
    public static BigInt addInstant(BigInt epochNanoseconds, long hours, long minutes, long seconds, long milliseconds, long microseconds, BigInteger nanoseconds) {
        BigInteger res = epochNanoseconds.bigIntegerValue().add(nanoseconds);
        res = res.add(BigInteger.valueOf(microseconds).multiply(BI_1000));
        res = res.add(BigInteger.valueOf(milliseconds).multiply(BI_10_POW_6));
        res = res.add(BigInteger.valueOf(seconds).multiply(BI_10_POW_9));
        res = res.add(BigInteger.valueOf(minutes).multiply(BI_6_10_POW_10));
        BigInt result = new BigInt(res = res.add(BigInteger.valueOf(hours).multiply(BI_36_10_POW_11)));
        if (!TemporalUtil.isValidEpochNanoseconds(result)) {
            throw TemporalErrors.createRangeErrorInvalidNanoseconds();
        }
        return result;
    }

    @CompilerDirectives.TruffleBoundary
    public static TimeDurationRecord differenceInstant(BigInt ns1, BigInt ns2, double roundingIncrement, Unit smallestUnit, Unit largestUnit, RoundingMode roundingMode, TemporalRoundDurationNode roundDuration) {
        BigInteger difference = ns2.subtract(ns1).bigIntegerValue();
        int nanoseconds = difference.remainder(BI_1000).intValue();
        int microseconds = difference.divide(BI_1000).remainder(BI_1000).intValue();
        int milliseconds = difference.divide(BI_10_POW_6).remainder(BI_1000).intValue();
        long seconds = difference.divide(BI_10_POW_9).longValue();
        if (smallestUnit == Unit.NANOSECOND && roundingIncrement == 1.0) {
            return TemporalUtil.balanceTimeDuration(0.0, 0.0, 0.0, seconds, milliseconds, microseconds, nanoseconds, largestUnit);
        }
        JSTemporalDurationRecord roundResult = roundDuration.execute(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, seconds, milliseconds, microseconds, nanoseconds, roundingIncrement, smallestUnit, roundingMode);
        return TemporalUtil.balanceTimeDuration(0.0, roundResult.getHours(), roundResult.getMinutes(), roundResult.getSeconds(), roundResult.getMilliseconds(), roundResult.getMicroseconds(), roundResult.getNanoseconds(), largestUnit);
    }

    @CompilerDirectives.TruffleBoundary
    public static TruffleString temporalInstantToString(JSContext ctx, JSRealm realm, JSTemporalInstantObject instant, JSDynamicObject timeZone, Object precision) {
        JSDynamicObject outputTimeZone = timeZone;
        if (outputTimeZone == Undefined.instance) {
            outputTimeZone = TemporalUtil.createTemporalTimeZone(ctx, realm, TemporalConstants.UTC);
        }
        JSTemporalCalendarObject isoCalendar = TemporalUtil.getISO8601Calendar(ctx, realm);
        TimeZoneMethodsRecord timeZoneRec = TemporalUtil.createTimeZoneMethodsRecordOnlyGetOffsetNanosecondsFor(outputTimeZone);
        JSTemporalPlainDateTimeObject dateTime = TemporalUtil.builtinTimeZoneGetPlainDateTimeFor(ctx, realm, timeZoneRec, instant, isoCalendar);
        TruffleString dateTimeString = JSTemporalPlainDateTime.temporalDateTimeToString(dateTime.getYear(), dateTime.getMonth(), dateTime.getDay(), dateTime.getHour(), dateTime.getMinute(), dateTime.getSecond(), dateTime.getMillisecond(), dateTime.getMicrosecond(), dateTime.getNanosecond(), Undefined.instance, precision, ShowCalendar.NEVER);
        TruffleString timeZoneString = null;
        if (timeZone == Undefined.instance) {
            timeZoneString = Strings.UC_Z;
        } else {
            long offsetNs = TemporalUtil.getOffsetNanosecondsFor(timeZoneRec, instant);
            timeZoneString = TemporalUtil.formatISOTimeZoneOffsetString(offsetNs);
        }
        return Strings.concat(dateTimeString, timeZoneString);
    }

    public static TimeZoneMethodsRecord createTimeZoneMethodsRecordOnlyGetOffsetNanosecondsFor(JSDynamicObject outputTimeZone) {
        return new TimeZoneMethodsRecord(outputTimeZone, JSObject.getMethod(outputTimeZone, GET_OFFSET_NANOSECONDS_FOR), null);
    }

    public static TruffleString builtinTimeZoneGetOffsetStringFor(TimeZoneMethodsRecord timeZoneRec, JSDynamicObject instant) {
        long offsetNanoseconds = TemporalUtil.getOffsetNanosecondsFor(timeZoneRec, instant);
        return TemporalUtil.formatTimeZoneOffsetString(offsetNanoseconds);
    }

    @CompilerDirectives.TruffleBoundary
    public static TruffleString formatTimeZoneOffsetString(long offsetNanosecondsParam) {
        TruffleString sign = offsetNanosecondsParam >= 0L ? Strings.SYMBOL_PLUS : Strings.SYMBOL_MINUS;
        long offsetNanoseconds = Math.abs(offsetNanosecondsParam);
        long nanoseconds = offsetNanoseconds % 1000000000L;
        double s1 = Math.floor((double)offsetNanoseconds / 1.0E9) % 60.0;
        double m1 = Math.floor((double)offsetNanoseconds / 6.0E10) % 60.0;
        double h1 = Math.floor((double)offsetNanoseconds / 3.6E12);
        long seconds = (long)s1;
        long minutes = (long)m1;
        long hours = (long)h1;
        TruffleString h = TemporalUtil.toZeroPaddedDecimalString(hours, 2);
        TruffleString m = TemporalUtil.toZeroPaddedDecimalString(minutes, 2);
        TruffleString s = TemporalUtil.toZeroPaddedDecimalString(seconds, 2);
        TruffleString post = Strings.EMPTY_STRING;
        if (nanoseconds != 0L) {
            TruffleString fraction = TemporalUtil.longestSubstring(TemporalUtil.toZeroPaddedDecimalString(nanoseconds, 9));
            post = Strings.concatAll(Strings.COLON, s, Strings.DOT, fraction);
        } else if (seconds != 0L) {
            post = Strings.concat(Strings.COLON, s);
        }
        return Strings.concatAll(sign, h, Strings.COLON, m, post);
    }

    @CompilerDirectives.TruffleBoundary
    public static long parseTimeZoneOffsetString(TruffleString string) {
        long nanoseconds;
        JSTemporalParserRecord rec = new TemporalParser(string).parseTimeZoneNumericUTCOffset();
        if (rec == null) {
            throw Errors.createRangeError("TemporalTimeZoneNumericUTCOffset expected");
        }
        if (rec.getOffsetFraction() == null) {
            nanoseconds = 0L;
        } else {
            TruffleString fraction = Strings.concat(rec.getOffsetFraction(), ZEROS);
            fraction = Strings.lazySubstring(fraction, 0, 9);
            try {
                nanoseconds = Strings.parseLong(fraction, 10);
            }
            catch (TruffleString.NumberFormatException e) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e);
            }
        }
        TruffleString signS = rec.getOffsetSign();
        int sign = Strings.SYMBOL_MINUS.equals((Object)signS) || Strings.UNICODE_MINUS_SIGN.equals((Object)signS) ? -1 : 1;
        long hours = rec.getOffsetHour() == Long.MIN_VALUE ? 0L : rec.getOffsetHour();
        long minutes = rec.getOffsetMinute() == Long.MIN_VALUE ? 0L : rec.getOffsetMinute();
        long seconds = rec.getOffsetSecond() == Long.MIN_VALUE ? 0L : rec.getOffsetSecond();
        return (long)sign * (((hours * 60L + minutes) * 60L + seconds) * 1000000000L + nanoseconds);
    }

    public static JSTemporalTimeZoneRecord parseTemporalTimeZoneString(TruffleString string) {
        return TemporalUtil.parseTemporalTimeZoneString(string, false);
    }

    @CompilerDirectives.TruffleBoundary
    private static JSTemporalTimeZoneRecord parseTemporalTimeZoneString(TruffleString string, boolean offsetRequired) {
        JSTemporalParserRecord rec = new TemporalParser(string).parseTimeZoneString();
        if (rec == null) {
            throw Errors.createRangeError("TemporalTimeZoneString expected");
        }
        if (offsetRequired && rec.getOffsetHour() == Long.MIN_VALUE && !rec.getZ()) {
            throw TemporalErrors.createRangeErrorTimeZoneOffsetExpected();
        }
        TruffleString name = rec.getTimeZoneIANAName();
        TruffleString offsetString = rec.getTimeZoneNumericUTCOffset();
        if (rec.getZ()) {
            return JSTemporalTimeZoneRecord.create(true, null, name);
        }
        return JSTemporalTimeZoneRecord.create(false, offsetString, name);
    }

    public static Disambiguation toTemporalDisambiguation(JSDynamicObject options, TemporalGetOptionNode getOptionNode, TruffleString.EqualNode equalNode) {
        if (options == Undefined.instance) {
            return Disambiguation.COMPATIBLE;
        }
        return TemporalUtil.toDisambiguation((TruffleString)getOptionNode.execute(options, TemporalConstants.DISAMBIGUATION, OptionType.STRING, listDisambiguation, TemporalConstants.COMPATIBLE), equalNode);
    }

    public static OffsetOption toTemporalOffset(JSDynamicObject options, TruffleString fallback, TemporalGetOptionNode getOptionNode, TruffleString.EqualNode equalNode) {
        TruffleString result = fallback;
        if (options != Undefined.instance) {
            result = (TruffleString)getOptionNode.execute(options, TemporalConstants.OFFSET, OptionType.STRING, listOffset, fallback);
        }
        return TemporalUtil.toOffsetOption(result, equalNode);
    }

    public static TruffleString toShowTimeZoneNameOption(JSDynamicObject options, TemporalGetOptionNode getOptionNode) {
        return (TruffleString)getOptionNode.execute(options, TemporalConstants.TIME_ZONE_NAME, OptionType.STRING, listAutoNever, TemporalConstants.AUTO);
    }

    public static TruffleString toShowOffsetOption(JSDynamicObject options, TemporalGetOptionNode getOptionNode) {
        return (TruffleString)getOptionNode.execute(options, TemporalConstants.OFFSET, OptionType.STRING, listAutoNever, TemporalConstants.AUTO);
    }

    public static TruffleString temporalZonedDateTimeToString(JSContext ctx, JSRealm realm, JSDynamicObject zonedDateTime, Object precision, ShowCalendar showCalendar, TruffleString showTimeZone, TruffleString showOffset) {
        return TemporalUtil.temporalZonedDateTimeToString(ctx, realm, zonedDateTime, precision, showCalendar, showTimeZone, showOffset, null, Unit.EMPTY, RoundingMode.EMPTY);
    }

    public static JSTemporalDateTimeRecord addDateTime(JSContext ctx, JSRealm realm, int year, int month, int day, int hour, int minute, int second, int millisecond, int microsecond, double nanosecond, CalendarMethodsRecord calendarRec, double years, double months, double weeks, double days, double hours, double minutes, double seconds, double milliseconds, double microseconds, double nanoseconds, JSDynamicObject options, Node node, InlinedBranchProfile errorBranch) {
        TimeRecord timeResult = TemporalUtil.addTimeDouble(hour, minute, second, millisecond, microsecond, nanosecond, hours, minutes, seconds, milliseconds, microseconds, nanoseconds, node, errorBranch);
        JSTemporalPlainDateObject datePart = JSTemporalPlainDate.create(ctx, realm, year, month, day, calendarRec.receiver(), node, errorBranch);
        JSTemporalDurationObject dateDuration = JSTemporalDuration.createTemporalDuration(ctx, realm, years, months, weeks, days + timeResult.days(), 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, node, errorBranch);
        JSTemporalPlainDateObject addedDate = TemporalUtil.calendarDateAdd(calendarRec, datePart, dateDuration, options);
        return JSTemporalDateTimeRecord.create(addedDate.getYear(), addedDate.getMonth(), addedDate.getDay(), timeResult.hour(), timeResult.minute(), timeResult.second(), timeResult.millisecond(), timeResult.microsecond(), timeResult.nanosecond());
    }

    public static int compareISODateTime(int year, int month, int day, int hours, int minutes, int seconds, int milliseconds, int microseconds, int nanoseconds, int year2, int month2, int day2, int hours2, int minutes2, int seconds2, int milliseconds2, int microseconds2, int nanoseconds2) {
        int date = TemporalUtil.compareISODate(year, month, day, year2, month2, day2);
        if (date == 0) {
            return TemporalUtil.compareTemporalTime(hours, minutes, seconds, milliseconds, microseconds, nanoseconds, hours2, minutes2, seconds2, milliseconds2, microseconds2, nanoseconds2);
        }
        return date;
    }

    @CompilerDirectives.TruffleBoundary
    public static JSTemporalDateTimeRecord parseTemporalYearMonthString(TruffleString string) {
        JSTemporalParserRecord rec = new TemporalParser(string).parseYearMonth();
        if (rec != null) {
            if (rec.getZ()) {
                throw TemporalErrors.createRangeErrorUnexpectedUTCDesignator();
            }
            if (rec.getYear() == 0L && (Strings.indexOf(string, TemporalConstants.MINUS_000000) >= 0 || Strings.indexOf(string, TemporalConstants.UNICODE_MINUS_SIGN_000000) >= 0)) {
                throw TemporalErrors.createRangeErrorInvalidPlainDateTime();
            }
            int y = rec.getYear() == Long.MIN_VALUE ? 0 : TemporalUtil.ltoi(rec.getYear());
            int m = rec.getMonth() == Long.MIN_VALUE ? 0 : TemporalUtil.ltoi(rec.getMonth());
            int d = rec.getDay() == Long.MIN_VALUE ? 1 : TemporalUtil.ltoi(rec.getDay());
            return JSTemporalDateTimeRecord.createCalendar(y, m, d, 0, 0, 0, 0, 0, 0, rec.getCalendar());
        }
        throw Errors.createRangeError("cannot parse YearMonth");
    }

    @CompilerDirectives.TruffleBoundary
    public static TruffleString temporalZonedDateTimeToString(JSContext ctx, JSRealm realm, JSDynamicObject zonedDateTimeParam, Object precision, ShowCalendar showCalendar, TruffleString showTimeZone, TruffleString showOffset, Double incrementParam, Unit unitParam, RoundingMode roundingModeParam) {
        assert (TemporalUtil.isTemporalZonedDateTime((Object)zonedDateTimeParam));
        assert (unitParam != null && roundingModeParam != null);
        JSTemporalZonedDateTimeObject zonedDateTime = (JSTemporalZonedDateTimeObject)zonedDateTimeParam;
        double increment = incrementParam == null ? 1.0 : incrementParam;
        Unit unit = unitParam == Unit.EMPTY ? Unit.NANOSECOND : unitParam;
        RoundingMode roundingMode = roundingModeParam == RoundingMode.EMPTY ? RoundingMode.TRUNC : roundingModeParam;
        BigInt ns = TemporalUtil.roundTemporalInstant(zonedDateTime.getNanoseconds(), (long)increment, unit, roundingMode);
        JSDynamicObject timeZone = zonedDateTime.getTimeZone();
        JSTemporalInstantObject instant = JSTemporalInstant.create(ctx, realm, ns);
        JSTemporalCalendarObject isoCalendar = TemporalUtil.getISO8601Calendar(ctx, realm);
        TimeZoneMethodsRecord timeZoneRec = TemporalUtil.createTimeZoneMethodsRecordOnlyGetOffsetNanosecondsFor(zonedDateTime.getTimeZone());
        long offsetNanoseconds = TemporalUtil.getOffsetNanosecondsFor(timeZoneRec, instant);
        JSTemporalPlainDateTimeObject temporalDateTime = TemporalUtil.builtinTimeZoneGetPlainDateTimeFor(ctx, realm, instant, isoCalendar, offsetNanoseconds);
        TruffleString dateTimeString = JSTemporalPlainDateTime.temporalDateTimeToString(temporalDateTime.getYear(), temporalDateTime.getMonth(), temporalDateTime.getDay(), temporalDateTime.getHour(), temporalDateTime.getMinute(), temporalDateTime.getSecond(), temporalDateTime.getMillisecond(), temporalDateTime.getMicrosecond(), temporalDateTime.getNanosecond(), isoCalendar, precision, ShowCalendar.NEVER);
        TruffleString offsetString = null;
        TruffleString timeZoneString = null;
        offsetString = TemporalConstants.NEVER.equals((Object)showOffset) ? Strings.EMPTY_STRING : TemporalUtil.formatISOTimeZoneOffsetString(offsetNanoseconds);
        if (TemporalConstants.NEVER.equals((Object)showTimeZone)) {
            timeZoneString = Strings.EMPTY_STRING;
        } else {
            TruffleString timeZoneID = JSRuntime.toString(timeZone);
            timeZoneString = Strings.addBrackets(timeZoneID);
        }
        TruffleString calendarID = JSRuntime.toString(zonedDateTime.getCalendar());
        TruffleString calendarString = TemporalUtil.formatCalendarAnnotation(calendarID, showCalendar);
        return Strings.concatAll(dateTimeString, offsetString, timeZoneString, calendarString);
    }

    @CompilerDirectives.TruffleBoundary
    private static TruffleString formatISOTimeZoneOffsetString(long offsetNs) {
        long offsetNanoseconds = TemporalUtil.dtol(TemporalUtil.roundNumberToIncrement(offsetNs, 6.0E10, RoundingMode.HALF_EXPAND));
        TruffleString sign = Strings.EMPTY_STRING;
        sign = offsetNanoseconds >= 0L ? Strings.SYMBOL_PLUS : Strings.SYMBOL_MINUS;
        offsetNanoseconds = Math.abs(offsetNanoseconds);
        long minutes = offsetNanoseconds / 60000000000L % 60L;
        long hours = (long)Math.floor(offsetNanoseconds / 3600000000000L);
        TruffleString h = TemporalUtil.toZeroPaddedDecimalString(hours, 2);
        TruffleString m = TemporalUtil.toZeroPaddedDecimalString(minutes, 2);
        return Strings.concatAll(sign, h, Strings.COLON, m);
    }

    @CompilerDirectives.TruffleBoundary
    public static ParseISODateTimeResult parseTemporalZonedDateTimeString(TruffleString string) {
        if (!new TemporalParser(string).isTemporalZonedDateTimeString()) {
            throw Errors.createRangeError("cannot be parsed as TemporalZonedDateTimeString");
        }
        try {
            return TemporalUtil.parseISODateTime(string);
        }
        catch (Exception ex) {
            throw Errors.createRangeError("cannot be parsed as TemporalZonedDateTimeString");
        }
    }

    @CompilerDirectives.TruffleBoundary
    public static BigInt parseTemporalInstant(TruffleString string) {
        long offsetNanoseconds;
        ParseISODateTimeResult result = TemporalUtil.parseTemporalInstantString(string);
        TruffleString offsetString = result.getTimeZoneResult().getOffsetString();
        assert (offsetString != null);
        BigInteger utc = TemporalUtil.getUTCEpochNanoseconds(result.getYear(), result.getMonth(), result.getDay(), result.getHour(), result.getMinute(), result.getSecond(), result.getMillisecond(), result.getMicrosecond(), result.getNanosecond());
        BigInt instant = new BigInt(utc.subtract(BigInteger.valueOf(offsetNanoseconds = TemporalUtil.parseTimeZoneOffsetString(offsetString))));
        if (!TemporalUtil.isValidEpochNanoseconds(instant)) {
            throw TemporalErrors.createRangeErrorInvalidNanoseconds();
        }
        return instant;
    }

    @CompilerDirectives.TruffleBoundary
    private static ParseISODateTimeResult parseTemporalInstantString(TruffleString string) {
        try {
            ParseISODateTimeResult result = TemporalUtil.parseISODateTime(string);
            JSTemporalTimeZoneRecord timeZoneResult = TemporalUtil.parseTemporalTimeZoneString(string, true);
            TruffleString offsetString = timeZoneResult.getOffsetString();
            if (timeZoneResult.isZ()) {
                offsetString = OFFSET_ZERO;
            }
            assert (offsetString != null);
            return result.withTimeZoneResult(JSTemporalTimeZoneRecord.create(timeZoneResult.isZ(), offsetString, timeZoneResult.getName()));
        }
        catch (Exception ex) {
            throw Errors.createRangeError("Instant cannot be parsed");
        }
    }

    @CompilerDirectives.TruffleBoundary
    public static JSTemporalInstantObject builtinTimeZoneGetInstantFor(JSContext ctx, JSRealm realm, TimeZoneMethodsRecord timeZoneRec, JSTemporalPlainDateTimeObject dateTime, Disambiguation disambiguation) {
        List<JSTemporalInstantObject> possibleInstants = TemporalUtil.getPossibleInstantsFor(timeZoneRec, dateTime);
        return TemporalUtil.disambiguatePossibleInstants(ctx, realm, possibleInstants, timeZoneRec, dateTime, disambiguation);
    }

    @CompilerDirectives.TruffleBoundary
    public static JSTemporalInstantObject disambiguatePossibleInstants(JSContext ctx, JSRealm realm, List<JSTemporalInstantObject> possibleInstants, TimeZoneMethodsRecord timeZoneRec, JSTemporalPlainDateTimeObject dateTime, Disambiguation disambiguation) {
        int n = possibleInstants.size();
        if (n == 1) {
            return possibleInstants.get(0);
        }
        if (n != 0) {
            if (Disambiguation.EARLIER == disambiguation || Disambiguation.COMPATIBLE == disambiguation) {
                return possibleInstants.get(0);
            }
            if (Disambiguation.LATER == disambiguation) {
                return possibleInstants.get(n - 1);
            }
            assert (Disambiguation.REJECT == disambiguation);
            throw Errors.createRangeError("invalid disambiguation");
        }
        assert (n == 0);
        if (Disambiguation.REJECT == disambiguation) {
            throw Errors.createRangeError("disambiguation failed");
        }
        BigInteger epochNanoseconds = TemporalUtil.getUTCEpochNanoseconds(dateTime.getYear(), dateTime.getMonth(), dateTime.getDay(), dateTime.getHour(), dateTime.getMinute(), dateTime.getSecond(), dateTime.getMillisecond(), dateTime.getMicrosecond(), dateTime.getNanosecond());
        JSTemporalInstantObject dayBefore = JSTemporalInstant.create(ctx, realm, new BigInt(epochNanoseconds.subtract(BI_8_64_13)));
        JSTemporalInstantObject dayAfter = JSTemporalInstant.create(ctx, realm, new BigInt(epochNanoseconds.add(BI_8_64_13)));
        long offsetBefore = TemporalUtil.getOffsetNanosecondsFor(timeZoneRec, dayBefore);
        long offsetAfter = TemporalUtil.getOffsetNanosecondsFor(timeZoneRec, dayAfter);
        long nanoseconds = offsetAfter - offsetBefore;
        if (Disambiguation.EARLIER == disambiguation) {
            TimeRecord earlierTime = TemporalUtil.addTimeDouble(dateTime.getHour(), dateTime.getMinute(), dateTime.getSecond(), dateTime.getMillisecond(), dateTime.getMicrosecond(), dateTime.getNanosecond(), 0.0, 0.0, 0.0, 0.0, 0.0, -nanoseconds, null, InlinedBranchProfile.getUncached());
            ISODateRecord earlierDate = TemporalUtil.addISODate(dateTime.getYear(), dateTime.getMonth(), dateTime.getDay(), 0, 0, 0, TemporalUtil.dtoi(earlierTime.days()), Overflow.CONSTRAIN);
            JSTemporalPlainDateTimeObject earlierDateTime = JSTemporalPlainDateTime.create(ctx, realm, earlierDate.year(), earlierDate.month(), earlierDate.day(), earlierTime.hour(), earlierTime.minute(), earlierTime.second(), earlierTime.millisecond(), earlierTime.microsecond(), earlierTime.nanosecond(), dateTime.getCalendar(), null, InlinedBranchProfile.getUncached());
            List<JSTemporalInstantObject> possibleInstants2 = TemporalUtil.getPossibleInstantsFor(timeZoneRec, earlierDateTime);
            if (possibleInstants2.size() == 0) {
                throw Errors.createRangeError("nothing found");
            }
            return possibleInstants2.get(0);
        }
        assert (Disambiguation.LATER == disambiguation || Disambiguation.COMPATIBLE == disambiguation);
        TimeRecord laterTime = TemporalUtil.addTimeDouble(dateTime.getHour(), dateTime.getMinute(), dateTime.getSecond(), dateTime.getMillisecond(), dateTime.getMicrosecond(), dateTime.getNanosecond(), 0.0, 0.0, 0.0, 0.0, 0.0, nanoseconds, null, InlinedBranchProfile.getUncached());
        ISODateRecord laterDate = TemporalUtil.addISODate(dateTime.getYear(), dateTime.getMonth(), dateTime.getDay(), 0, 0, 0, TemporalUtil.dtoi(laterTime.days()), Overflow.CONSTRAIN);
        JSTemporalPlainDateTimeObject laterDateTime = JSTemporalPlainDateTime.create(ctx, realm, laterDate.year(), laterDate.month(), laterDate.day(), laterTime.hour(), laterTime.minute(), laterTime.second(), laterTime.millisecond(), laterTime.microsecond(), laterTime.nanosecond(), dateTime.getCalendar(), null, InlinedBranchProfile.getUncached());
        List<JSTemporalInstantObject> possibleInstants2 = TemporalUtil.getPossibleInstantsFor(timeZoneRec, laterDateTime);
        n = possibleInstants2.size();
        if (n == 0) {
            throw Errors.createRangeError("nothing found");
        }
        return possibleInstants2.get(n - 1);
    }

    @CompilerDirectives.TruffleBoundary
    public static BigInt interpretISODateTimeOffset(JSContext ctx, JSRealm realm, int year, int month, int day, int hour, int minute, int second, int millisecond, int microsecond, int nanosecond, OffsetBehaviour offsetBehaviour, Object offsetNanosecondsParam, TimeZoneMethodsRecord timeZoneRec, Disambiguation disambiguation, OffsetOption offsetOption, MatchBehaviour matchBehaviour) {
        double offsetNs = offsetNanosecondsParam == null || offsetNanosecondsParam == Undefined.instance ? Double.NaN : ((Number)offsetNanosecondsParam).doubleValue();
        JSTemporalCalendarObject calendar = TemporalUtil.getISO8601Calendar(ctx, realm);
        JSTemporalPlainDateTimeObject dateTime = JSTemporalPlainDateTime.create(ctx, realm, year, month, day, hour, minute, second, millisecond, microsecond, nanosecond, calendar);
        if (offsetBehaviour == OffsetBehaviour.WALL || OffsetOption.IGNORE == offsetOption) {
            JSTemporalInstantObject instant = TemporalUtil.builtinTimeZoneGetInstantFor(ctx, realm, timeZoneRec, dateTime, disambiguation);
            return instant.getNanoseconds();
        }
        if (offsetBehaviour == OffsetBehaviour.EXACT || OffsetOption.USE == offsetOption) {
            BigInteger epochNanoseconds = TemporalUtil.getUTCEpochNanoseconds(year, month, day, hour, minute, second, millisecond, microsecond, nanosecond);
            return new BigInt(epochNanoseconds.subtract(BigInteger.valueOf((long)offsetNs)));
        }
        assert (offsetBehaviour == OffsetBehaviour.OPTION);
        assert (OffsetOption.PREFER == offsetOption || OffsetOption.REJECT == offsetOption);
        List<JSTemporalInstantObject> possibleInstants = TemporalUtil.getPossibleInstantsFor(timeZoneRec, dateTime);
        for (JSTemporalInstantObject candidate : possibleInstants) {
            long roundedCandidateNanoseconds;
            long candidateNanoseconds = TemporalUtil.getOffsetNanosecondsFor(timeZoneRec, candidate);
            if ((double)candidateNanoseconds == offsetNs) {
                return candidate.getNanoseconds();
            }
            if (matchBehaviour != MatchBehaviour.MATCH_MINUTES || (double)(roundedCandidateNanoseconds = TemporalUtil.dtol(TemporalUtil.roundNumberToIncrement(candidateNanoseconds, 6.0E10, RoundingMode.HALF_EXPAND))) != offsetNs) continue;
            return candidate.getNanoseconds();
        }
        if (OffsetOption.REJECT == offsetOption) {
            throw Errors.createRangeError("cannot interpret DateTime offset");
        }
        JSTemporalInstantObject instant = TemporalUtil.builtinTimeZoneGetInstantFor(ctx, realm, timeZoneRec, dateTime, disambiguation);
        return instant.getNanoseconds();
    }

    @CompilerDirectives.TruffleBoundary
    public static BigInt addZonedDateTime(JSContext ctx, JSRealm realm, BigInt epochNanoseconds, TimeZoneMethodsRecord timeZoneRec, CalendarMethodsRecord calendarRec, long years, long months, long weeks, long days, long hours, long minutes, long seconds, long milliseconds, long microseconds, long nanoseconds, JSTemporalPlainDateTimeObject precalculatedPlainDateTime) {
        return TemporalUtil.addZonedDateTime(ctx, realm, epochNanoseconds, timeZoneRec, calendarRec, years, months, weeks, days, hours, minutes, seconds, milliseconds, microseconds, BigInteger.valueOf(nanoseconds), precalculatedPlainDateTime, Undefined.instance);
    }

    @CompilerDirectives.TruffleBoundary
    public static BigInt addZonedDateTime(JSContext ctx, JSRealm realm, BigInt epochNanoseconds, TimeZoneMethodsRecord timeZoneRec, CalendarMethodsRecord calendarRec, long years, long months, long weeks, long days, long hours, long minutes, long seconds, long milliseconds, long microseconds, BigInteger nanoseconds, JSTemporalPlainDateTimeObject precalculatedPlainDateTime, JSDynamicObject options) {
        if (years == 0L && months == 0L && weeks == 0L && days == 0L) {
            return TemporalUtil.addInstant(epochNanoseconds, hours, minutes, seconds, milliseconds, microseconds, nanoseconds);
        }
        JSTemporalInstantObject instant = JSTemporalInstant.create(ctx, realm, epochNanoseconds);
        JSTemporalPlainDateTimeObject temporalDateTime = precalculatedPlainDateTime != null ? precalculatedPlainDateTime : TemporalUtil.builtinTimeZoneGetPlainDateTimeFor(ctx, realm, timeZoneRec, instant, calendarRec.receiver());
        JSTemporalPlainDateObject datePart = JSTemporalPlainDate.create(ctx, realm, temporalDateTime.getYear(), temporalDateTime.getMonth(), temporalDateTime.getDay(), calendarRec.receiver(), null, InlinedBranchProfile.getUncached());
        JSTemporalDurationObject dateDuration = JSTemporalDuration.createTemporalDuration(ctx, realm, years, months, weeks, days, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, null, null);
        JSTemporalPlainDateObject addedDate = TemporalUtil.calendarDateAdd(calendarRec, datePart, dateDuration, options);
        JSTemporalPlainDateTimeObject intermediateDateTime = JSTemporalPlainDateTime.create(ctx, realm, addedDate.getYear(), addedDate.getMonth(), addedDate.getDay(), temporalDateTime.getHour(), temporalDateTime.getMinute(), temporalDateTime.getSecond(), temporalDateTime.getMillisecond(), temporalDateTime.getMicrosecond(), temporalDateTime.getNanosecond(), calendarRec.receiver());
        JSTemporalInstantObject intermediateInstant = TemporalUtil.builtinTimeZoneGetInstantFor(ctx, realm, timeZoneRec, intermediateDateTime, Disambiguation.COMPATIBLE);
        return TemporalUtil.addInstant(intermediateInstant.getNanoseconds(), hours, minutes, seconds, milliseconds, microseconds, nanoseconds);
    }

    public static JSTemporalZonedDateTimeObject moveRelativeZonedDateTime(JSContext ctx, JSRealm realm, JSTemporalZonedDateTimeObject zdt, CalendarMethodsRecord calendarRec, TimeZoneMethodsRecord timeZoneRec, long years, long months, long weeks, long days, JSTemporalPlainDateTimeObject precalculatedPlainDateTime) {
        BigInt intermediateNs = TemporalUtil.addZonedDateTime(ctx, realm, zdt.getNanoseconds(), timeZoneRec, calendarRec, years, months, weeks, days, 0L, 0L, 0L, 0L, 0L, 0L, precalculatedPlainDateTime);
        return JSTemporalZonedDateTime.create(ctx, realm, intermediateNs, zdt.getTimeZone(), zdt.getCalendar());
    }

    public static boolean timeZoneEquals(JSDynamicObject tz1, JSDynamicObject tz2, JSToStringNode toStringNode) {
        if (tz1 == tz2) {
            return true;
        }
        TruffleString s1 = toStringNode.executeString((Object)tz1);
        TruffleString s2 = toStringNode.executeString((Object)tz2);
        return Boundaries.equals(s1, s2);
    }

    public static JSDynamicObject consolidateCalendars(JSDynamicObject one, JSDynamicObject two, JSToStringNode toStringNode) {
        if (one == two) {
            return two;
        }
        TruffleString s1 = toStringNode.executeString((Object)one);
        TruffleString s2 = toStringNode.executeString((Object)two);
        return TemporalUtil.consolidateCalendarsIntl(one, two, s1, s2);
    }

    @CompilerDirectives.TruffleBoundary
    private static JSDynamicObject consolidateCalendarsIntl(JSDynamicObject one, JSDynamicObject two, TruffleString s1, TruffleString s2) {
        if (s1.equals((Object)s2)) {
            return two;
        }
        if (TemporalConstants.ISO8601.equals((Object)s1)) {
            return two;
        }
        if (TemporalConstants.ISO8601.equals((Object)s2)) {
            return one;
        }
        throw Errors.createRangeError("cannot consolidate calendars");
    }

    private static List<JSTemporalInstantObject> getPossibleInstantsFor(TimeZoneMethodsRecord timeZoneRec, JSDynamicObject dateTime) {
        assert (timeZoneRec.getPossibleInstantsFor() != null);
        JSDynamicObject possibleInstants = TemporalUtil.toDynamicObject(JSRuntime.call(timeZoneRec.getPossibleInstantsFor(), (Object)timeZoneRec.receiver(), new Object[]{dateTime}));
        IteratorRecord iteratorRecord = JSRuntime.getIterator((Object)possibleInstants);
        ArrayList<JSTemporalInstantObject> list = new ArrayList<JSTemporalInstantObject>();
        Object next = true;
        while (next != Boolean.FALSE) {
            next = JSRuntime.iteratorStep(iteratorRecord);
            if (next == Boolean.FALSE) continue;
            Object nextValue = JSRuntime.iteratorValue(next);
            if (!TemporalUtil.isTemporalInstant(nextValue)) {
                JSRuntime.iteratorClose((Object)possibleInstants);
                throw Errors.createTypeError("unexpected value");
            }
            list.add((JSTemporalInstantObject)((Object)nextValue));
        }
        return list;
    }

    @CompilerDirectives.TruffleBoundary
    public static List<BigInt> getIANATimeZoneEpochValue(TruffleString identifier, long isoYear, long isoMonth, long isoDay, long hours, long minutes, long seconds, long milliseconds, long microseconds, long nanoseconds) {
        ArrayList<BigInt> list;
        block2: {
            list = new ArrayList<BigInt>();
            try {
                ZoneId zoneId = ZoneId.of(Strings.toJavaString(identifier));
                long fractions = milliseconds * 1000000L + microseconds * 1000L + nanoseconds;
                ZonedDateTime zdt = ZonedDateTime.of((int)isoYear, (int)isoMonth, (int)isoDay, (int)hours, (int)minutes, (int)seconds, (int)fractions, zoneId);
                list.add(BigInt.valueOf(zdt.toEpochSecond() * 1000000000L + fractions));
            }
            catch (Exception ex) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
        return list;
    }

    @CompilerDirectives.TruffleBoundary
    public static double getIANATimeZoneOffsetNanoseconds(BigInt nanoseconds, TruffleString identifier) {
        try {
            Instant instant = Instant.ofEpochSecond(0L, nanoseconds.longValue());
            ZoneId zoneId = ZoneId.of(Strings.toJavaString(identifier));
            ZoneRules zoneRule = zoneId.getRules();
            ZoneOffset offset = zoneRule.getOffset(instant);
            return (double)offset.getTotalSeconds() * 1.0E9;
        }
        catch (Exception ex) {
            assert (false);
            return -9.223372036854776E18;
        }
    }

    @CompilerDirectives.TruffleBoundary
    public static OptionalLong getIANATimeZoneNextTransition(BigInt nanoseconds, TruffleString identifier) {
        try {
            BigInteger[] sec = nanoseconds.bigIntegerValue().divideAndRemainder(BI_10_POW_9);
            Instant instant = Instant.ofEpochSecond(sec[0].longValue(), sec[1].longValue());
            ZoneId zoneId = ZoneId.of(Strings.toJavaString(identifier));
            ZoneRules zoneRule = zoneId.getRules();
            ZoneOffsetTransition nextTransition = zoneRule.nextTransition(instant);
            if (nextTransition == null) {
                return OptionalLong.empty();
            }
            return OptionalLong.of(nextTransition.toEpochSecond() * 1000000000L);
        }
        catch (Exception ex) {
            assert (false);
            return OptionalLong.of(Long.MIN_VALUE);
        }
    }

    @CompilerDirectives.TruffleBoundary
    public static OptionalLong getIANATimeZonePreviousTransition(BigInt nanoseconds, TruffleString identifier) {
        try {
            BigInteger[] sec = nanoseconds.bigIntegerValue().divideAndRemainder(BI_10_POW_9);
            Instant instant = Instant.ofEpochSecond(sec[0].longValue(), sec[1].longValue());
            ZoneId zoneId = ZoneId.of(Strings.toJavaString(identifier));
            ZoneRules zoneRule = zoneId.getRules();
            ZoneOffsetTransition previousTransition = zoneRule.previousTransition(instant);
            if (previousTransition == null) {
                return OptionalLong.empty();
            }
            return OptionalLong.of(previousTransition.toEpochSecond() * 1000000000L);
        }
        catch (Exception ex) {
            assert (false);
            return OptionalLong.empty();
        }
    }

    @CompilerDirectives.TruffleBoundary
    public static boolean canParseAsTimeZoneNumericUTCOffset(TruffleString string) {
        try {
            JSTemporalParserRecord rec = new TemporalParser(string).parseTimeZoneNumericUTCOffset();
            return rec != null;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static boolean isoYearMonthWithinLimits(int year, int month) {
        if (year < -271821 || year > 275760) {
            return false;
        }
        if (year == -271821 && month < 4) {
            return false;
        }
        return year != 275760 || month <= 9;
    }

    public static Number calendarYear(TemporalCalendarGetterNode getterNode, JSDynamicObject calendar, JSDynamicObject dateLike) {
        return getterNode.executeInteger(calendar, dateLike, TemporalConstants.YEAR);
    }

    public static Number calendarMonth(TemporalCalendarGetterNode getterNode, JSDynamicObject calendar, JSDynamicObject dateLike) {
        return getterNode.executeInteger(calendar, dateLike, TemporalConstants.MONTH);
    }

    public static TruffleString calendarMonthCode(TemporalCalendarGetterNode getterNode, JSDynamicObject calendar, JSDynamicObject dateLike) {
        return getterNode.executeString(calendar, dateLike, TemporalConstants.MONTH_CODE);
    }

    public static Number calendarDay(TemporalCalendarGetterNode getterNode, JSDynamicObject calendar, JSDynamicObject dateLike) {
        return getterNode.executeInteger(calendar, dateLike, TemporalConstants.DAY);
    }

    public static Object calendarDayOfWeek(TemporalCalendarGetterNode getterNode, JSDynamicObject calendar, JSDynamicObject dateLike) {
        return getterNode.execute(calendar, dateLike, TemporalConstants.DAY_OF_WEEK);
    }

    public static Object calendarDayOfYear(TemporalCalendarGetterNode getterNode, JSDynamicObject calendar, JSDynamicObject dateLike) {
        return getterNode.execute(calendar, dateLike, TemporalConstants.DAY_OF_YEAR);
    }

    public static Object calendarWeekOfYear(TemporalCalendarGetterNode getterNode, JSDynamicObject calendar, JSDynamicObject dateLike) {
        return getterNode.execute(calendar, dateLike, TemporalConstants.WEEK_OF_YEAR);
    }

    public static Object calendarDaysInWeek(TemporalCalendarGetterNode getterNode, JSDynamicObject calendar, JSDynamicObject dateLike) {
        return getterNode.execute(calendar, dateLike, TemporalConstants.DAYS_IN_WEEK);
    }

    public static Object calendarDaysInMonth(TemporalCalendarGetterNode getterNode, JSDynamicObject calendar, JSDynamicObject dateLike) {
        return getterNode.execute(calendar, dateLike, TemporalConstants.DAYS_IN_MONTH);
    }

    public static Object calendarDaysInYear(TemporalCalendarGetterNode getterNode, JSDynamicObject calendar, JSDynamicObject dateLike) {
        return getterNode.execute(calendar, dateLike, TemporalConstants.DAYS_IN_YEAR);
    }

    public static Object calendarMonthsInYear(TemporalCalendarGetterNode getterNode, JSDynamicObject calendar, JSDynamicObject dateLike) {
        return getterNode.execute(calendar, dateLike, TemporalConstants.MONTHS_IN_YEAR);
    }

    public static Object calendarInLeapYear(TemporalCalendarGetterNode getterNode, JSDynamicObject calendar, JSDynamicObject dateLike) {
        return getterNode.execute(calendar, dateLike, TemporalConstants.IN_LEAP_YEAR);
    }

    public static Object resolveISOMonth(JSContext ctx, JSDynamicObject fields, JSToIntegerOrInfinityNode toIntegerOrInfinity, JSIdenticalNode identicalNode) {
        double m1;
        Object month = JSObject.get(fields, TemporalConstants.MONTH);
        Object monthCode = JSObject.get(fields, TemporalConstants.MONTH_CODE);
        if (monthCode == Undefined.instance) {
            if (month == Undefined.instance) {
                throw Errors.createTypeError("No month or month code present.");
            }
            return month;
        }
        assert (monthCode instanceof TruffleString);
        int monthLength = Strings.length((TruffleString)monthCode);
        if (monthLength != 3) {
            throw Errors.createRangeError("Month code should be in 3 character code.");
        }
        TruffleString numberPart = Strings.substring(ctx, (TruffleString)monthCode, 1);
        double numberPart2 = JSRuntime.doubleValue(toIntegerOrInfinity.executeNumber(numberPart));
        if (Double.isNaN(numberPart2)) {
            throw Errors.createRangeError("The last character of the monthCode should be a number.");
        }
        if (numberPart2 < 1.0 || numberPart2 > 12.0) {
            throw Errors.createRangeError("monthCode out of bounds");
        }
        double d = m1 = month == Undefined.instance ? -1.0 : JSRuntime.doubleValue(toIntegerOrInfinity.executeNumber(month));
        if (month != Undefined.instance && m1 != numberPart2) {
            throw Errors.createRangeError("Month does not equal the month code.");
        }
        if (!identicalNode.executeBoolean(monthCode, TemporalUtil.buildISOMonthCode((int)numberPart2))) {
            throw Errors.createRangeError("Not same value");
        }
        return (long)numberPart2;
    }

    public static ISODateRecord isoDateFromFields(JSDynamicObject fields, JSDynamicObject options, JSContext ctx, IsObjectNode isObject, TemporalGetOptionNode getOptionNode, JSToIntegerOrInfinityNode toIntOrInfinityNode, JSIdenticalNode identicalNode) {
        assert (isObject.executeBoolean((Object)fields));
        Overflow overflow = TemporalUtil.toTemporalOverflow(options, getOptionNode);
        JSObject preparedFields = TemporalUtil.prepareTemporalFields(ctx, fields, listDMMCY, listYD);
        Object year = JSObject.get((JSDynamicObject)preparedFields, TemporalConstants.YEAR);
        Object month = TemporalUtil.resolveISOMonth(ctx, preparedFields, toIntOrInfinityNode, identicalNode);
        Object day = JSObject.get((JSDynamicObject)preparedFields, TemporalConstants.DAY);
        return TemporalUtil.regulateISODate(TemporalUtil.dtoi(JSRuntime.doubleValue(toIntOrInfinityNode.executeNumber(year))), TemporalUtil.dtoi(JSRuntime.doubleValue(toIntOrInfinityNode.executeNumber(month))), TemporalUtil.dtoi(JSRuntime.doubleValue(toIntOrInfinityNode.executeNumber(day))), overflow);
    }

    public static ISODateRecord isoYearMonthFromFields(JSDynamicObject fields, JSDynamicObject options, JSContext ctx, IsObjectNode isObject, TemporalGetOptionNode getOptionNode, JSToIntegerOrInfinityNode toIntOrInfinityNode, JSIdenticalNode identicalNode) {
        assert (isObject.executeBoolean((Object)fields));
        Overflow overflow = TemporalUtil.toTemporalOverflow(options, getOptionNode);
        JSObject preparedFields = TemporalUtil.prepareTemporalFields(ctx, fields, listMMCY, listY);
        Object year = JSObject.get((JSDynamicObject)preparedFields, TemporalConstants.YEAR);
        Object month = TemporalUtil.resolveISOMonth(ctx, preparedFields, toIntOrInfinityNode, identicalNode);
        ISOYearMonthRecord result = TemporalUtil.regulateISOYearMonth(TemporalUtil.dtoi(JSRuntime.doubleValue(toIntOrInfinityNode.executeNumber(year))), TemporalUtil.dtoi(JSRuntime.doubleValue(toIntOrInfinityNode.executeNumber(month))), overflow);
        return new ISODateRecord(result.year(), result.month(), 1);
    }

    public static ISODateRecord isoMonthDayFromFields(JSDynamicObject fields, JSDynamicObject options, JSContext ctx, IsObjectNode isObject, TemporalGetOptionNode getOptionNode, JSToIntegerOrInfinityNode toIntOrInfinityNode, JSIdenticalNode identicalNode) {
        assert (isObject.executeBoolean((Object)fields));
        Overflow overflow = TemporalUtil.toTemporalOverflow(options, getOptionNode);
        JSObject preparedFields = TemporalUtil.prepareTemporalFields(ctx, fields, listDMMCY, listD);
        Object month = JSObject.get((JSDynamicObject)preparedFields, TemporalConstants.MONTH);
        Object monthCode = JSObject.get((JSDynamicObject)preparedFields, TemporalConstants.MONTH_CODE);
        Object year = JSObject.get((JSDynamicObject)preparedFields, TemporalConstants.YEAR);
        if (month != Undefined.instance && monthCode == Undefined.instance && year == Undefined.instance) {
            throw Errors.createTypeError("A year or a month code should be present.");
        }
        month = TemporalUtil.resolveISOMonth(ctx, preparedFields, toIntOrInfinityNode, identicalNode);
        Object day = JSObject.get((JSDynamicObject)preparedFields, TemporalConstants.DAY);
        int referenceISOYear = 1972;
        ISODateRecord result = monthCode == Undefined.instance ? TemporalUtil.regulateISODate(TemporalUtil.dtoi(JSRuntime.doubleValue(toIntOrInfinityNode.executeNumber(year))), TemporalUtil.dtoi(JSRuntime.doubleValue(toIntOrInfinityNode.executeNumber(month))), TemporalUtil.dtoi(JSRuntime.doubleValue(toIntOrInfinityNode.executeNumber(day))), overflow) : TemporalUtil.regulateISODate(referenceISOYear, TemporalUtil.dtoi(JSRuntime.doubleValue(toIntOrInfinityNode.executeNumber(month))), TemporalUtil.dtoi(JSRuntime.doubleValue(toIntOrInfinityNode.executeNumber(day))), overflow);
        return new ISODateRecord(referenceISOYear, result.month(), result.day());
    }

    public static JSTemporalDurationRecord createDurationRecord(double years, double months, double weeks, double days, double hours, double minutes, double seconds, double milliseconds, double microseconds, double nanoseconds) {
        if (!TemporalUtil.isValidDuration(years, months, weeks, days, hours, minutes, seconds, milliseconds, microseconds, nanoseconds)) {
            throw TemporalErrors.createTypeErrorDurationOutsideRange();
        }
        return JSTemporalDurationRecord.createWeeks(years, months, weeks, days, hours, minutes, seconds, milliseconds, microseconds, nanoseconds);
    }

    public static long dtol(double d) {
        assert (JSRuntime.doubleIsRepresentableAsLong(d));
        return (long)d;
    }

    public static int dtoi(double d) {
        if (d == 0.0) {
            return 0;
        }
        assert (JSRuntime.doubleIsRepresentableAsInt(d));
        return (int)d;
    }

    @CompilerDirectives.TruffleBoundary
    public static long dtol(double d, boolean failOnError) {
        if (failOnError && !JSRuntime.doubleIsRepresentableAsLong(d)) {
            throw Errors.createRangeError("value out of range");
        }
        return (long)d;
    }

    @CompilerDirectives.TruffleBoundary
    public static int ltoi(long l) {
        if (!JSRuntime.longIsRepresentableAsInt(l)) {
            throw Errors.createRangeError("value out of range");
        }
        return (int)l;
    }

    @CompilerDirectives.TruffleBoundary
    public static int bitoi(BigInteger bi) {
        double value = bi.doubleValue();
        assert (Double.isFinite(value));
        assert (JSRuntime.doubleIsRepresentableAsInt(value));
        return bi.intValue();
    }

    @CompilerDirectives.TruffleBoundary
    public static double bitod(BigInteger bi) {
        double value = bi.doubleValue();
        assert (Double.isFinite(value));
        return value;
    }

    @CompilerDirectives.TruffleBoundary
    public static long bigIntToLong(BigInt val) {
        return val.longValueExact();
    }

    @CompilerDirectives.TruffleBoundary
    private static int add(int a, int b, Overflow overflow) {
        try {
            return Math.addExact(a, b);
        }
        catch (ArithmeticException ex) {
            if (overflow == Overflow.REJECT) {
                throw TemporalErrors.createRangeErrorDateOutsideRange();
            }
            assert (overflow == Overflow.CONSTRAIN);
            return Integer.MAX_VALUE;
        }
    }

    public static Unit toUnit(TruffleString unit, TruffleString.EqualNode equalNode) {
        if (unit == null) {
            return Unit.EMPTY;
        }
        if (equalNode.execute((AbstractTruffleString)unit, (AbstractTruffleString)TemporalConstants.YEAR, TruffleString.Encoding.UTF_16)) {
            return Unit.YEAR;
        }
        if (equalNode.execute((AbstractTruffleString)unit, (AbstractTruffleString)TemporalConstants.MONTH, TruffleString.Encoding.UTF_16)) {
            return Unit.MONTH;
        }
        if (equalNode.execute((AbstractTruffleString)unit, (AbstractTruffleString)TemporalConstants.WEEK, TruffleString.Encoding.UTF_16)) {
            return Unit.WEEK;
        }
        if (equalNode.execute((AbstractTruffleString)unit, (AbstractTruffleString)TemporalConstants.DAY, TruffleString.Encoding.UTF_16)) {
            return Unit.DAY;
        }
        if (equalNode.execute((AbstractTruffleString)unit, (AbstractTruffleString)TemporalConstants.HOUR, TruffleString.Encoding.UTF_16)) {
            return Unit.HOUR;
        }
        if (equalNode.execute((AbstractTruffleString)unit, (AbstractTruffleString)TemporalConstants.MINUTE, TruffleString.Encoding.UTF_16)) {
            return Unit.MINUTE;
        }
        if (equalNode.execute((AbstractTruffleString)unit, (AbstractTruffleString)TemporalConstants.SECOND, TruffleString.Encoding.UTF_16)) {
            return Unit.SECOND;
        }
        if (equalNode.execute((AbstractTruffleString)unit, (AbstractTruffleString)TemporalConstants.MILLISECOND, TruffleString.Encoding.UTF_16)) {
            return Unit.MILLISECOND;
        }
        if (equalNode.execute((AbstractTruffleString)unit, (AbstractTruffleString)TemporalConstants.MICROSECOND, TruffleString.Encoding.UTF_16)) {
            return Unit.MICROSECOND;
        }
        if (equalNode.execute((AbstractTruffleString)unit, (AbstractTruffleString)TemporalConstants.NANOSECOND, TruffleString.Encoding.UTF_16)) {
            return Unit.NANOSECOND;
        }
        if (equalNode.execute((AbstractTruffleString)unit, (AbstractTruffleString)TemporalConstants.AUTO, TruffleString.Encoding.UTF_16)) {
            return Unit.AUTO;
        }
        throw Errors.createTypeError("unexpected unit");
    }

    @CompilerDirectives.TruffleBoundary
    public static RoundingMode toRoundingMode(TruffleString mode, TruffleString.EqualNode equalNode) {
        if (mode == null) {
            return RoundingMode.EMPTY;
        }
        if (equalNode.execute((AbstractTruffleString)mode, (AbstractTruffleString)TemporalConstants.FLOOR, TruffleString.Encoding.UTF_16)) {
            return RoundingMode.FLOOR;
        }
        if (equalNode.execute((AbstractTruffleString)mode, (AbstractTruffleString)TemporalConstants.CEIL, TruffleString.Encoding.UTF_16)) {
            return RoundingMode.CEIL;
        }
        if (equalNode.execute((AbstractTruffleString)mode, (AbstractTruffleString)TemporalConstants.EXPAND, TruffleString.Encoding.UTF_16)) {
            return RoundingMode.EXPAND;
        }
        if (equalNode.execute((AbstractTruffleString)mode, (AbstractTruffleString)TemporalConstants.TRUNC, TruffleString.Encoding.UTF_16)) {
            return RoundingMode.TRUNC;
        }
        if (equalNode.execute((AbstractTruffleString)mode, (AbstractTruffleString)TemporalConstants.HALF_FLOOR, TruffleString.Encoding.UTF_16)) {
            return RoundingMode.HALF_FLOOR;
        }
        if (equalNode.execute((AbstractTruffleString)mode, (AbstractTruffleString)TemporalConstants.HALF_CEIL, TruffleString.Encoding.UTF_16)) {
            return RoundingMode.HALF_CEIL;
        }
        if (equalNode.execute((AbstractTruffleString)mode, (AbstractTruffleString)TemporalConstants.HALF_EXPAND, TruffleString.Encoding.UTF_16)) {
            return RoundingMode.HALF_EXPAND;
        }
        if (equalNode.execute((AbstractTruffleString)mode, (AbstractTruffleString)TemporalConstants.HALF_TRUNC, TruffleString.Encoding.UTF_16)) {
            return RoundingMode.HALF_TRUNC;
        }
        if (equalNode.execute((AbstractTruffleString)mode, (AbstractTruffleString)TemporalConstants.HALF_EVEN, TruffleString.Encoding.UTF_16)) {
            return RoundingMode.HALF_EVEN;
        }
        throw Errors.createTypeError("unexpected roundingMode");
    }

    @CompilerDirectives.TruffleBoundary
    public static Disambiguation toDisambiguation(TruffleString disambiguation, TruffleString.EqualNode equalNode) {
        if (equalNode.execute((AbstractTruffleString)disambiguation, (AbstractTruffleString)TemporalConstants.EARLIER, TruffleString.Encoding.UTF_16)) {
            return Disambiguation.EARLIER;
        }
        if (equalNode.execute((AbstractTruffleString)disambiguation, (AbstractTruffleString)TemporalConstants.LATER, TruffleString.Encoding.UTF_16)) {
            return Disambiguation.LATER;
        }
        if (equalNode.execute((AbstractTruffleString)disambiguation, (AbstractTruffleString)TemporalConstants.COMPATIBLE, TruffleString.Encoding.UTF_16)) {
            return Disambiguation.COMPATIBLE;
        }
        if (equalNode.execute((AbstractTruffleString)disambiguation, (AbstractTruffleString)TemporalConstants.REJECT, TruffleString.Encoding.UTF_16)) {
            return Disambiguation.REJECT;
        }
        throw Errors.createTypeError("unexpected disambiguation");
    }

    @CompilerDirectives.TruffleBoundary
    public static OffsetOption toOffsetOption(TruffleString offsetOption, TruffleString.EqualNode equalNode) {
        if (equalNode.execute((AbstractTruffleString)offsetOption, (AbstractTruffleString)TemporalConstants.USE, TruffleString.Encoding.UTF_16)) {
            return OffsetOption.USE;
        }
        if (equalNode.execute((AbstractTruffleString)offsetOption, (AbstractTruffleString)TemporalConstants.IGNORE, TruffleString.Encoding.UTF_16)) {
            return OffsetOption.IGNORE;
        }
        if (equalNode.execute((AbstractTruffleString)offsetOption, (AbstractTruffleString)TemporalConstants.PREFER, TruffleString.Encoding.UTF_16)) {
            return OffsetOption.PREFER;
        }
        if (equalNode.execute((AbstractTruffleString)offsetOption, (AbstractTruffleString)TemporalConstants.REJECT, TruffleString.Encoding.UTF_16)) {
            return OffsetOption.REJECT;
        }
        throw Errors.createTypeError("unexpected offsetOption");
    }

    @CompilerDirectives.TruffleBoundary
    public static ShowCalendar toShowCalendar(TruffleString showCalendar, TruffleString.EqualNode equalNode) {
        if (equalNode.execute((AbstractTruffleString)showCalendar, (AbstractTruffleString)TemporalConstants.AUTO, TruffleString.Encoding.UTF_16)) {
            return ShowCalendar.AUTO;
        }
        if (equalNode.execute((AbstractTruffleString)showCalendar, (AbstractTruffleString)TemporalConstants.NEVER, TruffleString.Encoding.UTF_16)) {
            return ShowCalendar.NEVER;
        }
        if (equalNode.execute((AbstractTruffleString)showCalendar, (AbstractTruffleString)TemporalConstants.ALWAYS, TruffleString.Encoding.UTF_16)) {
            return ShowCalendar.ALWAYS;
        }
        throw Errors.createTypeError("unexpected showCalendar");
    }

    public static double roundTowardsZero(double d) {
        return ExactMath.truncate((double)d);
    }

    public static enum OptionType {
        STRING,
        NUMBER,
        BOOLEAN,
        NUMBER_AND_STRING;


        public boolean allowsNumber() {
            return this == NUMBER || this == NUMBER_AND_STRING;
        }

        public boolean allowsString() {
            return this == STRING || this == NUMBER_AND_STRING;
        }

        public boolean allowsBoolean() {
            return this == BOOLEAN;
        }

        public OptionType getLast() {
            switch (this.ordinal()) {
                case 0: 
                case 3: {
                    return STRING;
                }
                case 1: {
                    return NUMBER;
                }
                case 2: {
                    return BOOLEAN;
                }
            }
            throw Errors.shouldNotReachHere();
        }
    }

    public static enum Unit {
        EMPTY(Strings.EMPTY_STRING),
        AUTO(TemporalConstants.AUTO),
        YEAR(TemporalConstants.YEAR),
        MONTH(TemporalConstants.MONTH),
        WEEK(TemporalConstants.WEEK),
        DAY(TemporalConstants.DAY),
        HOUR(TemporalConstants.HOUR),
        MINUTE(TemporalConstants.MINUTE),
        SECOND(TemporalConstants.SECOND),
        MILLISECOND(TemporalConstants.MILLISECOND),
        MICROSECOND(TemporalConstants.MICROSECOND),
        NANOSECOND(TemporalConstants.NANOSECOND);

        private final TruffleString name;

        private Unit(TruffleString name) {
            this.name = name;
        }

        public TruffleString toTruffleString() {
            return this.name;
        }
    }

    public static enum RoundingMode {
        EMPTY,
        CEIL,
        FLOOR,
        EXPAND,
        TRUNC,
        HALF_EXPAND,
        HALF_TRUNC,
        HALF_EVEN,
        HALF_FLOOR,
        HALF_CEIL;

    }

    public static enum UnsignedRoundingMode {
        EMPTY,
        ZERO,
        INFINITY,
        HALF_INFINITY,
        HALF_ZERO,
        HALF_EVEN;

    }

    public static enum Overflow {
        CONSTRAIN,
        REJECT;

    }

    public record ISOYearMonthRecord(int year, int month) {
    }

    public static enum ShowCalendar {
        AUTO,
        ALWAYS,
        NEVER;

    }

    public record AddDaysToZonedDateTimeResult(BigInt epochNanoseconds, JSTemporalInstantObject instant, JSTemporalPlainDateTimeObject dateTime) {
    }

    public static enum UnitPlural {
        YEARS(TemporalConstants.YEARS),
        MONTHS(TemporalConstants.MONTHS),
        WEEKS(TemporalConstants.WEEKS),
        DAYS(TemporalConstants.DAYS),
        HOURS(TemporalConstants.HOURS),
        MINUTES(TemporalConstants.MINUTES),
        SECONDS(TemporalConstants.SECONDS),
        MILLISECONDS(TemporalConstants.MILLISECONDS),
        MICROSECONDS(TemporalConstants.MICROSECONDS),
        NANOSECONDS(TemporalConstants.NANOSECONDS);

        private final TruffleString name;

        private UnitPlural(TruffleString name) {
            this.name = name;
        }

        public TruffleString toTruffleString() {
            return this.name;
        }
    }

    public static enum Disambiguation {
        EARLIER,
        LATER,
        COMPATIBLE,
        REJECT;

    }

    public static enum OffsetOption {
        USE,
        IGNORE,
        PREFER,
        REJECT;

    }

    public static enum OffsetBehaviour {
        OPTION,
        WALL,
        EXACT;

    }

    public static enum MatchBehaviour {
        MATCH_EXACTLY,
        MATCH_MINUTES;

    }
}

