/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.api.common.queries;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.event.ChangeListener;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.queries.BinaryForSourceQuery;
import org.netbeans.modules.java.api.common.SourceRoots;
import org.netbeans.spi.java.queries.BinaryForSourceQueryImplementation;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;
import org.openide.util.Utilities;

final class BinaryForSourceQueryImpl
implements BinaryForSourceQueryImplementation {
    private static final String PROP_GENERATED_SOURCES = "build.generated.sources.dir";
    private final Map<URL, BinaryForSourceQuery.Result> cache = new ConcurrentHashMap<URL, BinaryForSourceQuery.Result>();
    private final SourceRoots src;
    private final SourceRoots test;
    private final PropertyEvaluator eval;
    private final AntProjectHelper helper;
    private String[] sourceProps;
    private String[] testProps;

    BinaryForSourceQueryImpl(@NonNull SourceRoots src, @NonNull SourceRoots test, @NonNull AntProjectHelper helper, @NonNull PropertyEvaluator eval, @NonNull String[] sourceProps, @NonNull String[] testProps) {
        assert (src != null);
        assert (test != null);
        assert (helper != null);
        assert (eval != null);
        assert (sourceProps != null && sourceProps.length > 0);
        assert (testProps != null && testProps.length > 0);
        this.src = src;
        this.test = test;
        this.eval = eval;
        this.helper = helper;
        this.sourceProps = sourceProps;
        this.testProps = testProps;
    }

    @CheckForNull
    public BinaryForSourceQuery.Result findBinaryRoots(@NonNull URL sourceRoot) {
        String[] activeNames;
        assert (sourceRoot != null);
        BinaryForSourceQuery.Result result = this.cache.get(sourceRoot);
        if (result == null && (activeNames = this.getActivePropertyNames(sourceRoot)) != null) {
            result = new R(sourceRoot, activeNames);
            this.cache.put(sourceRoot, result);
        }
        return result;
    }

    @CheckForNull
    private String[] getActivePropertyNames(@NonNull URL sourceRoot) {
        for (URL root : this.src.getRootURLs()) {
            if (!root.equals(sourceRoot)) continue;
            return this.sourceProps;
        }
        for (URL root : this.test.getRootURLs()) {
            if (!root.equals(sourceRoot)) continue;
            return this.testProps;
        }
        String buildGeneratedDirS = this.eval.getProperty(PROP_GENERATED_SOURCES);
        if (buildGeneratedDirS != null) {
            String parent = Utilities.toURI((File)this.helper.resolveFile(buildGeneratedDirS)).toString();
            if (sourceRoot.toString().startsWith(parent)) {
                return this.sourceProps;
            }
        }
        return null;
    }

    class R
    implements BinaryForSourceQuery.Result,
    PropertyChangeListener {
        private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
        private final URL root;
        private volatile String[] activeNames;

        R(@NonNull URL root, String[] activeNames) {
            assert (root != null);
            assert (activeNames != null && activeNames.length > 0);
            this.root = root;
            this.activeNames = activeNames;
            BinaryForSourceQueryImpl.this.eval.addPropertyChangeListener((PropertyChangeListener)this);
            BinaryForSourceQueryImpl.this.src.addPropertyChangeListener(this);
            BinaryForSourceQueryImpl.this.test.addPropertyChangeListener(this);
        }

        @NonNull
        public URL[] getRoots() {
            String[] names = this.activeNames;
            if (names == null) {
                this.activeNames = names = BinaryForSourceQueryImpl.this.getActivePropertyNames(this.root);
            }
            if (names == null) {
                BinaryForSourceQueryImpl.this.cache.remove(this.root);
                return new URL[0];
            }
            ArrayList<URL> urls = new ArrayList<URL>();
            for (String propName : names) {
                URL url;
                String val = BinaryForSourceQueryImpl.this.eval.getProperty(propName);
                if (val == null || (url = FileUtil.urlForArchiveOrDir((File)BinaryForSourceQueryImpl.this.helper.resolveFile(val))) == null) continue;
                urls.add(url);
            }
            return urls.toArray(new URL[0]);
        }

        public void addChangeListener(@NonNull ChangeListener l) {
            assert (l != null);
            this.changeSupport.addChangeListener(l);
        }

        public void removeChangeListener(@NonNull ChangeListener l) {
            assert (l != null);
            this.changeSupport.removeChangeListener(l);
        }

        @Override
        public void propertyChange(@NonNull PropertyChangeEvent event) {
            String propName = event.getPropertyName();
            if (SourceRoots.PROP_ROOTS.equals(propName) || BinaryForSourceQueryImpl.PROP_GENERATED_SOURCES.equals(propName)) {
                this.activeNames = null;
            }
            this.changeSupport.fireChange();
        }
    }
}

