/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.api.common;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.java.api.common.Roots;
import org.netbeans.modules.java.api.common.ant.UpdateHelper;
import org.netbeans.modules.java.api.common.util.CommonModuleUtils;
import org.netbeans.spi.project.support.ant.AntProjectEvent;
import org.netbeans.spi.project.support.ant.AntProjectListener;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class SourceRoots
extends Roots {
    public static final String PROP_ROOT_PROPERTIES = SourceRoots.class.getName() + ".rootProperties";
    public static final String PROP_ROOTS = SourceRoots.class.getName() + ".roots";
    public static final String DEFAULT_SOURCE_LABEL = NbBundle.getMessage(SourceRoots.class, (String)"NAME_src.dir");
    public static final String DEFAULT_TEST_LABEL = NbBundle.getMessage(SourceRoots.class, (String)"NAME_test.src.dir");
    static final String REF_PREFIX = "${file.reference.";
    private static final Logger LOG = Logger.getLogger(SourceRoots.class.getName());
    final UpdateHelper helper;
    final PropertyEvaluator evaluator;
    final ReferenceHelper refHelper;
    final String projectConfigurationNamespace;
    final String elementName;
    final String newRootNameTemplate;
    final ProjectMetadataListener listener;
    final File projectDir;
    private List<String> sourceRootProperties;
    private List<String> sourceRootPathProperties;
    private List<String> sourceRootNames;
    private List<FileObject> sourceRoots;
    List<URL> sourceRootURLs;
    private final boolean isTest;

    public static SourceRoots create(UpdateHelper helper, PropertyEvaluator evaluator, ReferenceHelper refHelper, String projectConfigurationNamespace, String elementName, boolean isTest, String newRootNameTemplate) {
        Parameters.notNull((CharSequence)"helper", (Object)helper);
        Parameters.notNull((CharSequence)"evaluator", (Object)evaluator);
        Parameters.notNull((CharSequence)"refHelper", (Object)refHelper);
        Parameters.notNull((CharSequence)"projectConfigurationNamespace", (Object)projectConfigurationNamespace);
        Parameters.notNull((CharSequence)"elementName", (Object)elementName);
        Parameters.notNull((CharSequence)"newRootNameTemplate", (Object)newRootNameTemplate);
        return new SourceRoots(helper, evaluator, refHelper, projectConfigurationNamespace, elementName, "java", isTest, newRootNameTemplate);
    }

    SourceRoots(UpdateHelper helper, PropertyEvaluator evaluator, ReferenceHelper refHelper, String projectConfigurationNamespace, String elementName, String type, boolean isTest, String newRootNameTemplate) {
        super(true, true, type, isTest ? "test" : "main");
        assert (helper != null);
        assert (evaluator != null);
        assert (refHelper != null);
        assert (projectConfigurationNamespace != null);
        assert (elementName != null);
        assert (newRootNameTemplate != null);
        this.helper = helper;
        this.evaluator = evaluator;
        this.refHelper = refHelper;
        this.projectConfigurationNamespace = projectConfigurationNamespace;
        this.elementName = elementName;
        this.isTest = isTest;
        this.newRootNameTemplate = newRootNameTemplate;
        this.projectDir = FileUtil.toFile((FileObject)this.helper.getAntProjectHelper().getProjectDirectory());
        this.listener = new ProjectMetadataListener();
        this.evaluator.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.listener, (Object)this.evaluator));
        this.helper.getAntProjectHelper().addAntProjectListener((AntProjectListener)WeakListeners.create(AntProjectListener.class, (EventListener)this.listener, (Object)this.helper));
    }

    public String[] getRootNames() {
        return (String[])ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<String[]>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public String[] run() {
                SourceRoots sourceRoots = SourceRoots.this;
                synchronized (sourceRoots) {
                    if (SourceRoots.this.sourceRootNames == null) {
                        SourceRoots.this.readProjectMetadata();
                    }
                    return SourceRoots.this.sourceRootNames.toArray(new String[0]);
                }
            }
        });
    }

    @Override
    public String[] getRootDisplayNames() {
        return (String[])ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<String[]>(){

            public String[] run() {
                String[] props = SourceRoots.this.getRootProperties();
                String[] names = SourceRoots.this.getRootNames();
                String[] displayNames = new String[props.length];
                for (int i = 0; i < props.length; ++i) {
                    displayNames[i] = SourceRoots.this.getRootDisplayName(names[i], props[i]);
                }
                return displayNames;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getRootProperties() {
        SourceRoots sourceRoots = this;
        synchronized (sourceRoots) {
            if (this.sourceRootProperties != null) {
                return this.sourceRootProperties.toArray(new String[0]);
            }
        }
        return (String[])ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<String[]>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public String[] run() {
                SourceRoots sourceRoots = SourceRoots.this;
                synchronized (sourceRoots) {
                    if (SourceRoots.this.sourceRootProperties == null) {
                        SourceRoots.this.readProjectMetadata();
                    }
                    return SourceRoots.this.sourceRootProperties.toArray(new String[0]);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String[] getRootPathProperties() {
        SourceRoots sourceRoots = this;
        synchronized (sourceRoots) {
            if (this.sourceRootPathProperties != null) {
                return this.sourceRootPathProperties.toArray(new String[0]);
            }
        }
        return (String[])ProjectManager.mutex().readAccess(() -> {
            SourceRoots sourceRoots = this;
            synchronized (sourceRoots) {
                if (this.sourceRootPathProperties == null) {
                    this.readProjectMetadata();
                }
                return this.sourceRootPathProperties.toArray(new String[0]);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileObject[] getRoots() {
        SourceRoots sourceRoots = this;
        synchronized (sourceRoots) {
            if (this.sourceRoots != null && SourceRoots.validFiles(this.sourceRoots)) {
                return this.sourceRoots.toArray(new FileObject[0]);
            }
        }
        return (FileObject[])ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<FileObject[]>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public FileObject[] run() {
                SourceRoots sourceRoots = SourceRoots.this;
                synchronized (sourceRoots) {
                    if (SourceRoots.this.sourceRoots != null && SourceRoots.validFiles(SourceRoots.this.sourceRoots)) {
                        return SourceRoots.this.sourceRoots.toArray(new FileObject[0]);
                    }
                    URL[] rootURLs = SourceRoots.this.getRootURLs();
                    ArrayList<FileObject> result = new ArrayList<FileObject>(rootURLs.length);
                    for (URL url : rootURLs) {
                        FileObject f = URLMapper.findFileObject((URL)url);
                        if (f == null) continue;
                        if (FileUtil.isArchiveFile((FileObject)f)) {
                            f = FileUtil.getArchiveRoot((FileObject)f);
                        }
                        result.add(f);
                    }
                    SourceRoots.this.sourceRoots = Collections.unmodifiableList(result);
                    LOG.log(Level.FINE, "Instance ({0}) setting roots to: {1}", new Object[]{System.identityHashCode(SourceRoots.this), SourceRoots.this.sourceRoots});
                    return SourceRoots.this.sourceRoots.toArray(new FileObject[0]);
                }
            }
        });
    }

    public URL[] getRootURLs() {
        return this.getRootURLs(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URL[] getRootURLs(boolean removeInvalidRoots) {
        SourceRoots sourceRoots = this;
        synchronized (sourceRoots) {
            if (this.sourceRootURLs != null) {
                return this.sourceRootURLs.toArray(new URL[0]);
            }
        }
        return (URL[])ProjectManager.mutex().readAccess(() -> {
            SourceRoots sourceRoots = this;
            synchronized (sourceRoots) {
                if (this.sourceRootURLs == null) {
                    ArrayList result = new ArrayList();
                    String[] rootProperties = this.getRootProperties();
                    String[] rootPathProperties = this.getRootPathProperties();
                    assert (rootProperties.length == rootPathProperties.length);
                    for (int i = 0; i < rootProperties.length; ++i) {
                        String path;
                        String rootProperty = rootProperties[i];
                        String pathToRoot = this.evaluator.getProperty(rootProperty);
                        if (pathToRoot == null) continue;
                        File root = this.helper.getAntProjectHelper().resolveFile(pathToRoot);
                        ArrayList<File> files = new ArrayList<File>();
                        String string = path = rootPathProperties[i] != null ? this.evaluator.getProperty(rootPathProperties[i]) : null;
                        if (path == null || !root.isDirectory()) {
                            files.add(root);
                        } else {
                            for (String propElement : PropertyUtils.tokenizePath((String)path)) {
                                for (String string2 : CommonModuleUtils.parseSourcePathVariants(propElement)) {
                                    for (File file : root.listFiles()) {
                                        if (!file.isDirectory()) continue;
                                        files.add(new File(file, string2));
                                    }
                                    this.listener.add(root, true);
                                }
                            }
                        }
                        files.forEach(f -> {
                            try {
                                URL url = Utilities.toURI((File)f).toURL();
                                if (!f.exists()) {
                                    url = new URL(url.toExternalForm() + "/");
                                } else if (removeInvalidRoots && !f.isDirectory()) {
                                    return;
                                }
                                assert (url.toExternalForm().endsWith("/")) : "#90639 violation for " + url + "; " + f + " exists? " + f.exists() + " dir? " + f.isDirectory() + " file? " + f.isFile();
                                result.add(url);
                                this.listener.add((File)f, false);
                            }
                            catch (MalformedURLException e) {
                                Exceptions.printStackTrace((Throwable)e);
                            }
                        });
                    }
                    this.sourceRootURLs = Collections.unmodifiableList(result);
                }
                return this.sourceRootURLs.toArray(new URL[0]);
            }
        });
    }

    private Map<URL, String> getRootsToProps() {
        return (Map)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<Map<URL, String>>(){

            public Map<URL, String> run() {
                HashMap<URL, String> result = new HashMap<URL, String>();
                for (String srcProp : SourceRoots.this.getRootProperties()) {
                    String prop = SourceRoots.this.evaluator.getProperty(srcProp);
                    if (prop == null) continue;
                    File f = SourceRoots.this.helper.getAntProjectHelper().resolveFile(prop);
                    try {
                        URL url = Utilities.toURI((File)f).toURL();
                        if (!f.exists()) {
                            url = new URL(url.toExternalForm() + "/");
                        } else if (f.isFile()) continue;
                        assert (url.toExternalForm().endsWith("/")) : "#90639 violation for " + url + "; " + f + " exists? " + f.exists() + " dir? " + f.isDirectory() + " file? " + f.isFile();
                        result.put(url, srcProp);
                    }
                    catch (MalformedURLException e) {
                        Exceptions.printStackTrace((Throwable)e);
                    }
                }
                return result;
            }
        });
    }

    public void putRoots(final URL[] roots, final String[] labels) {
        ProjectManager.mutex().writeAccess(new Runnable(){

            @Override
            public void run() {
                Map oldRoots2props = SourceRoots.this.getRootsToProps();
                HashMap<URL, String> newRoots2lab = new HashMap<URL, String>();
                for (int i = 0; i < roots.length; ++i) {
                    newRoots2lab.put(roots[i], labels[i]);
                }
                Element cfgEl = SourceRoots.this.helper.getPrimaryConfigurationData(true);
                NodeList nl = cfgEl.getElementsByTagNameNS(SourceRoots.this.projectConfigurationNamespace, SourceRoots.this.elementName);
                if (nl.getLength() != 1) {
                    FileObject prjDir = SourceRoots.this.helper.getAntProjectHelper().getProjectDirectory();
                    FileObject projectXml = prjDir == null ? null : prjDir.getFileObject("nbproject/project.xml");
                    String content = null;
                    try {
                        content = projectXml == null ? null : projectXml.asText("UTF-8");
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    throw new IllegalArgumentException(String.format("Broken nbproject/project.xml, missing %s in %s namespace, content: %s.", SourceRoots.this.elementName, SourceRoots.this.projectConfigurationNamespace, content));
                }
                Element ownerElement = (Element)nl.item(0);
                NodeList rootsNodes = ownerElement.getElementsByTagNameNS(SourceRoots.this.projectConfigurationNamespace, "root");
                while (rootsNodes.getLength() > 0) {
                    Element root = (Element)rootsNodes.item(0);
                    ownerElement.removeChild(root);
                }
                List<URL> newRoots = Arrays.asList(roots);
                HashMap propsToRemove = new HashMap(oldRoots2props);
                propsToRemove.keySet().removeAll(newRoots);
                EditableProperties props = SourceRoots.this.helper.getProperties("nbproject/project.properties");
                HashSet<String> referencesToRemove = new HashSet<String>();
                for (String propToRemove : propsToRemove.values()) {
                    String propValue = props.getProperty(propToRemove);
                    if (propValue != null && propValue.startsWith(SourceRoots.REF_PREFIX)) {
                        referencesToRemove.add(propValue);
                    }
                    props.remove((Object)propToRemove);
                }
                SourceRoots.this.helper.putProperties("nbproject/project.properties", props);
                for (String referenceToRemove : referencesToRemove) {
                    if (SourceRoots.isUsed(referenceToRemove, props)) continue;
                    SourceRoots.this.refHelper.destroyReference(referenceToRemove);
                }
                Document doc = ownerElement.getOwnerDocument();
                oldRoots2props.keySet().retainAll(newRoots);
                for (URL newRoot : newRoots) {
                    String rootName = (String)oldRoots2props.get(newRoot);
                    if (rootName == null) {
                        String prjPath;
                        props = SourceRoots.this.helper.getProperties("nbproject/project.properties");
                        String[] names = newRoot.getPath().split("/");
                        rootName = MessageFormat.format(SourceRoots.this.newRootNameTemplate, names[names.length - 1], "");
                        int rootIndex = 1;
                        while (props.containsKey((Object)rootName)) {
                            rootName = MessageFormat.format(SourceRoots.this.newRootNameTemplate, names[names.length - 1], ++rootIndex);
                        }
                        File f = FileUtil.normalizeFile((File)Utilities.toFile((URI)URI.create(newRoot.toExternalForm())));
                        File projDir = FileUtil.toFile((FileObject)SourceRoots.this.helper.getAntProjectHelper().getProjectDirectory());
                        String path = f.getAbsolutePath();
                        if (path.startsWith(prjPath = projDir.getAbsolutePath() + File.separatorChar)) {
                            path = path.substring(prjPath.length());
                        } else {
                            path = SourceRoots.this.refHelper.createForeignFileReference(f, "java");
                            props = SourceRoots.this.helper.getProperties("nbproject/project.properties");
                        }
                        props.put(rootName, path);
                        SourceRoots.this.helper.putProperties("nbproject/project.properties", props);
                    }
                    Element newRootNode = doc.createElementNS(SourceRoots.this.projectConfigurationNamespace, "root");
                    newRootNode.setAttribute("id", rootName);
                    String label = (String)newRoots2lab.get(newRoot);
                    if (label != null && label.length() > 0 && !label.equals(SourceRoots.this.getRootDisplayName(null, rootName))) {
                        newRootNode.setAttribute("name", label);
                    }
                    ownerElement.appendChild(newRootNode);
                }
                SourceRoots.this.helper.putPrimaryConfigurationData(cfgEl, true);
            }
        });
    }

    public String getRootDisplayName(String rootName, String propName) {
        if (rootName == null || rootName.length() == 0) {
            if (this.isTest && "test.src.dir".equals(propName)) {
                rootName = DEFAULT_TEST_LABEL;
            } else if (!this.isTest && "src.dir".equals(propName)) {
                rootName = DEFAULT_SOURCE_LABEL;
            } else {
                String propValue = this.evaluator.getProperty(propName);
                File sourceRoot = propValue == null ? null : this.helper.getAntProjectHelper().resolveFile(propValue);
                rootName = this.createInitialDisplayName(sourceRoot);
            }
        }
        return rootName;
    }

    public String createInitialDisplayName(File sourceRoot) {
        String pdPath;
        String srPath;
        String rootName = sourceRoot != null ? ((srPath = sourceRoot.getAbsolutePath()).startsWith(pdPath = this.projectDir.getAbsolutePath() + File.separatorChar) ? srPath.substring(pdPath.length()) : sourceRoot.getAbsolutePath()) : (this.isTest ? DEFAULT_TEST_LABEL : DEFAULT_SOURCE_LABEL);
        return rootName;
    }

    public boolean isTest() {
        return this.isTest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetCache(boolean isXMLChange, String propName) {
        boolean fire = false;
        SourceRoots sourceRoots = this;
        synchronized (sourceRoots) {
            if (isXMLChange) {
                this.sourceRootProperties = null;
                this.sourceRootPathProperties = null;
                this.sourceRootNames = null;
                this.sourceRoots = null;
                this.sourceRootURLs = null;
                this.listener.removeFileListeners();
                fire = true;
                LOG.log(Level.FINE, "Instance ({0}) reseting cache due to project.xml change", System.identityHashCode(this));
            } else if (propName == null || this.sourceRootProperties != null && this.sourceRootProperties.contains(propName)) {
                this.sourceRoots = null;
                this.sourceRootURLs = null;
                this.listener.removeFileListeners();
                fire = true;
                LOG.log(Level.FINE, "Instance ({0}) reseting cache due to property change", System.identityHashCode(this));
            }
        }
        if (fire) {
            if (isXMLChange) {
                this.firePropertyChange(PROP_ROOT_PROPERTIES, null, null);
            }
            this.firePropertyChange(PROP_ROOTS, null, null);
        }
    }

    private void readProjectMetadata() {
        Element cfgEl = this.helper.getPrimaryConfigurationData(true);
        NodeList nl = cfgEl.getElementsByTagNameNS(this.projectConfigurationNamespace, this.elementName);
        assert (nl.getLength() == 0 || nl.getLength() == 1) : "Illegal project.xml";
        ArrayList<String> rootPaths = new ArrayList<String>();
        ArrayList<String> rootProps = new ArrayList<String>();
        ArrayList<String> rootNames = new ArrayList<String>();
        if (nl.getLength() == 1) {
            NodeList roots = ((Element)nl.item(0)).getElementsByTagNameNS(this.projectConfigurationNamespace, "root");
            for (int i = 0; i < roots.getLength(); ++i) {
                Element root = (Element)roots.item(i);
                String value = root.getAttribute("id");
                assert (value.length() > 0) : "Illegal project.xml";
                rootProps.add(value);
                value = root.hasAttribute("pathref") ? root.getAttribute("pathref") : null;
                rootPaths.add(value);
                value = root.getAttribute("name");
                rootNames.add(value);
            }
        }
        this.sourceRootPathProperties = Collections.unmodifiableList(rootPaths);
        this.sourceRootProperties = Collections.unmodifiableList(rootProps);
        this.sourceRootNames = Collections.unmodifiableList(rootNames);
    }

    private static boolean validFiles(@NonNull Iterable<? extends FileObject> files) {
        for (FileObject fileObject : files) {
            if (fileObject.isValid()) continue;
            return false;
        }
        return true;
    }

    static boolean isUsed(@NonNull String reference, @NonNull EditableProperties props) {
        for (Map.Entry e : props.entrySet()) {
            if (!((String)e.getValue()).contains(reference)) continue;
            return true;
        }
        return false;
    }

    class ProjectMetadataListener
    implements PropertyChangeListener,
    AntProjectListener,
    FileChangeListener {
        private final Set<File> files = new HashSet<File>();
        private final Set<File> moduleRoots = new HashSet<File>();

        ProjectMetadataListener() {
        }

        public void add(File f, boolean moduleRoot) {
            if (moduleRoot) {
                if (!this.moduleRoots.contains(f)) {
                    this.moduleRoots.add(f);
                    FileUtil.addFileChangeListener((FileChangeListener)this, (File)f);
                }
            } else if (!this.files.contains(f)) {
                this.files.add(f);
                FileUtil.addFileChangeListener((FileChangeListener)this, (File)f);
            }
        }

        public void removeFileListeners() {
            for (File f : this.files) {
                try {
                    FileUtil.removeFileChangeListener((FileChangeListener)this, (File)f);
                }
                catch (IllegalArgumentException iae) {
                    LOG.log(Level.FINE, null, iae);
                }
            }
            this.files.clear();
            for (File f : this.moduleRoots) {
                try {
                    FileUtil.removeFileChangeListener((FileChangeListener)this, (File)f);
                }
                catch (IllegalArgumentException iae) {
                    LOG.log(Level.FINE, null, iae);
                }
            }
            this.moduleRoots.clear();
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            SourceRoots.this.resetCache(false, evt.getPropertyName());
        }

        public void configurationXmlChanged(AntProjectEvent ev) {
            if ("nbproject/project.xml".equals(ev.getPath())) {
                SourceRoots.this.resetCache(true, null);
            }
        }

        public void propertiesChanged(AntProjectEvent ev) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fileFolderCreated(FileEvent fe) {
            FileObject parent = fe.getFile().getParent();
            if (parent != null) {
                File parentFile = FileUtil.toFile((FileObject)parent);
                assert (parentFile != null) : "Expecting ordinary folder: " + parent;
                SourceRoots sourceRoots = SourceRoots.this;
                synchronized (sourceRoots) {
                    if (this.files.contains(parentFile) && !this.moduleRoots.contains(parentFile)) {
                        return;
                    }
                }
            }
            SourceRoots.this.resetCache(false, null);
        }

        public void fileDeleted(FileEvent fe) {
            if (fe.getFile().isFolder()) {
                this.fileFolderCreated(fe);
            }
        }

        public void fileDataCreated(FileEvent fe) {
        }

        public void fileChanged(FileEvent fe) {
        }

        public void fileRenamed(FileRenameEvent fe) {
            if (fe.getFile().isFolder()) {
                this.fileFolderCreated((FileEvent)fe);
            }
        }

        public void fileAttributeChanged(FileAttributeEvent fe) {
        }
    }

    private static class RootInfo {
        private RootInfo() {
        }
    }
}

