/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticbeanstalk.model.transform;

import com.amazonaws.services.elasticbeanstalk.model.PlatformFilter;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;

public class PlatformFilterStaxUnmarshaller
implements Unmarshaller<PlatformFilter, StaxUnmarshallerContext> {
    private static PlatformFilterStaxUnmarshaller instance;

    public PlatformFilter unmarshall(StaxUnmarshallerContext context) throws Exception {
        PlatformFilter platformFilter = new PlatformFilter();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return platformFilter;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Type", targetDepth)) {
                    platformFilter.setType(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Operator", targetDepth)) {
                    platformFilter.setOperator(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Values", targetDepth)) {
                    platformFilter.withValues(new ArrayList<String>());
                    continue;
                }
                if (!context.testExpression("Values/member", targetDepth)) continue;
                platformFilter.withValues(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return platformFilter;
    }

    public static PlatformFilterStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new PlatformFilterStaxUnmarshaller();
        }
        return instance;
    }
}

