/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ddloaders.multiview;

import javax.swing.table.TableCellEditor;
import org.netbeans.modules.j2ee.dd.api.common.ResourceRef;
import org.netbeans.modules.j2ee.dd.api.ejb.Ejb;
import org.netbeans.modules.j2ee.ddloaders.multiview.InnerTableModel;
import org.netbeans.modules.j2ee.ddloaders.multiview.Utils;
import org.netbeans.modules.xml.multiview.XmlMultiViewDataSynchronizer;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;

public class ResourceReferencesTableModel
extends InnerTableModel {
    private Ejb ejb;
    private static final int COLUMN_AUTHENTICATION = 2;
    private static final int COLUMN_SHAREABLE = 3;
    private static final String[] COLUMN_NAMES = new String[]{Utils.getBundleMessage("LBL_Name"), Utils.getBundleMessage("LBL_ResourceType"), Utils.getBundleMessage("LBL_Authentication"), Utils.getBundleMessage("LBL_Shareable"), Utils.getBundleMessage("LBL_Description")};
    private static final int[] COLUMN_WIDTHS = new int[]{100, 200, 120, 80, 150};

    public ResourceReferencesTableModel(XmlMultiViewDataSynchronizer synchronizer, Ejb ejb) {
        super(synchronizer, COLUMN_NAMES, COLUMN_WIDTHS);
        this.ejb = ejb;
    }

    @Override
    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        ResourceRef resourceRef = this.ejb.getResourceRef(rowIndex);
        switch (columnIndex) {
            case 0: {
                resourceRef.setResRefName((String)value);
                break;
            }
            case 1: {
                resourceRef.setResType((String)value);
                break;
            }
            case 2: {
                resourceRef.setResAuth((String)value);
                break;
            }
            case 3: {
                resourceRef.setResSharingScope((String)value);
                break;
            }
            case 4: {
                resourceRef.setDescription((String)value);
            }
        }
        this.modelUpdatedFromUI();
        this.fireTableCellUpdated(rowIndex, columnIndex);
    }

    @Override
    public int getRowCount() {
        return this.ejb.getResourceRef().length;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        ResourceRef resourceRef = this.ejb.getResourceRef(rowIndex);
        switch (columnIndex) {
            case 0: {
                return resourceRef.getResRefName();
            }
            case 1: {
                return resourceRef.getResType();
            }
            case 2: {
                return resourceRef.getResAuth();
            }
            case 3: {
                return resourceRef.getResSharingScope();
            }
            case 4: {
                return resourceRef.getDefaultDescription();
            }
        }
        return null;
    }

    @Override
    public int addRow() {
        String text = Utils.getBundleMessage("LBL_ReferenceName_");
        String title = Utils.getBundleMessage("LBL_AddResourceReference");
        NotifyDescriptor.InputLine inputLine = new NotifyDescriptor.InputLine(text, title);
        DialogDisplayer.getDefault().notify((NotifyDescriptor)inputLine);
        String name = inputLine.getInputText();
        return this.addRow(name);
    }

    public int addRow(String name) {
        if (name != null && name.trim().length() > 0) {
            ResourceRef resourceRef = this.ejb.newResourceRef();
            resourceRef.setResRefName(name);
            this.ejb.addResourceRef(resourceRef);
            this.modelUpdatedFromUI();
        }
        int row = this.getRowCount() - 1;
        return row;
    }

    @Override
    public void removeRow(int row) {
        this.ejb.removeResourceRef(this.ejb.getResourceRef(row));
        this.modelUpdatedFromUI();
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex != 0;
    }

    @Override
    public TableCellEditor getTableCellEditor(int column) {
        if (column == 2) {
            return this.createComboBoxCellEditor(new Object[]{"Application", "Container"});
        }
        if (column == 3) {
            return this.createComboBoxCellEditor(new Object[]{"Shareable", "Unshareable"});
        }
        return null;
    }
}

