/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.shadowed.org.jline.reader.impl;

import java.util.Objects;
import org.graalvm.shadowed.org.jline.reader.MaskingCallback;

public final class SimpleMaskingCallback
implements MaskingCallback {
    private final Character mask;

    public SimpleMaskingCallback(Character mask) {
        this.mask = Objects.requireNonNull(mask, "mask must be a non null character");
    }

    @Override
    public String display(String line) {
        if (this.mask.equals(Character.valueOf('\u0000'))) {
            return "";
        }
        StringBuilder sb = new StringBuilder(line.length());
        int i = line.length();
        while (i-- > 0) {
            sb.append(this.mask.charValue());
        }
        return sb.toString();
    }

    @Override
    public String history(String line) {
        return null;
    }
}

