/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.maven.dependency;

import io.quarkus.maven.dependency.ArtifactKey;
import io.quarkus.maven.dependency.GACTV;

public interface ArtifactCoords {
    public static final String TYPE_JAR = "jar";
    public static final String TYPE_POM = "pom";
    public static final String DEFAULT_CLASSIFIER = "";

    public static ArtifactCoords fromString(String str) {
        return new GACTV(GACTV.split(str, new String[5]));
    }

    public static ArtifactCoords pom(String groupId, String artifactId, String version) {
        return new GACTV(groupId, artifactId, null, TYPE_POM, version);
    }

    public static ArtifactCoords jar(String groupId, String artifactId, String version) {
        return new GACTV(groupId, artifactId, null, TYPE_JAR, version);
    }

    public static ArtifactCoords jar(String groupId, String artifactId, String classifier, String version) {
        return new GACTV(groupId, artifactId, classifier, TYPE_JAR, version);
    }

    public static ArtifactCoords of(String groupId, String artifactId, String classifier, String type, String version) {
        return new GACTV(groupId, artifactId, classifier, type, version);
    }

    public String getGroupId();

    public String getArtifactId();

    public String getClassifier();

    public String getType();

    public String getVersion();

    public ArtifactKey getKey();

    default public boolean isJar() {
        return TYPE_JAR.equals(this.getType());
    }

    default public boolean isSnapshot() {
        return this.getVersion() != null && this.getVersion().endsWith("-SNAPSHOT");
    }

    default public String toGACTVString() {
        return this.getGroupId() + ":" + this.getArtifactId() + ":" + this.getClassifier() + ":" + this.getType() + ":" + this.getVersion();
    }

    default public String toCompactCoords() {
        StringBuilder b = new StringBuilder();
        b.append(this.getGroupId()).append(':').append(this.getArtifactId()).append(':');
        if (!this.getClassifier().isEmpty()) {
            b.append(this.getClassifier()).append(':');
        }
        if (!this.isJar()) {
            b.append(this.getType()).append(':');
        }
        b.append(this.getVersion());
        return b.toString();
    }
}

