/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.multimap.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.impl.InternalEntryFactory;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.functional.FunctionalMap;
import org.infinispan.functional.impl.FunctionalMapImpl;
import org.infinispan.functional.impl.ReadWriteMapImpl;
import org.infinispan.multimap.impl.BaseSetBucket;
import org.infinispan.multimap.impl.ScoredValue;
import org.infinispan.multimap.impl.SortedSetAddArgs;
import org.infinispan.multimap.impl.SortedSetBucket;
import org.infinispan.multimap.impl.SortedSetSubsetArgs;
import org.infinispan.multimap.impl.function.sortedset.AddManyFunction;
import org.infinispan.multimap.impl.function.sortedset.CountFunction;
import org.infinispan.multimap.impl.function.sortedset.IncrFunction;
import org.infinispan.multimap.impl.function.sortedset.IndexOfSortedSetFunction;
import org.infinispan.multimap.impl.function.sortedset.PopFunction;
import org.infinispan.multimap.impl.function.sortedset.RemoveManyFunction;
import org.infinispan.multimap.impl.function.sortedset.ScoreFunction;
import org.infinispan.multimap.impl.function.sortedset.SortedSetAggregateFunction;
import org.infinispan.multimap.impl.function.sortedset.SortedSetOperationType;
import org.infinispan.multimap.impl.function.sortedset.SortedSetRandomFunction;
import org.infinispan.multimap.impl.function.sortedset.SubsetFunction;
import org.infinispan.multimap.impl.internal.MultimapObjectWrapper;

public class EmbeddedMultimapSortedSetCache<K, V> {
    public static final String ERR_KEY_CAN_T_BE_NULL = "key can't be null";
    public static final String ERR_MIN_CAN_T_BE_NULL = "min can't be null";
    public static final String ERR_MAX_CAN_T_BE_NULL = "max can't be null";
    public static final String ERR_MEMBER_CAN_T_BE_NULL = "member can't be null";
    public static final String ERR_ARGS_CAN_T_BE_NULL = "args can't be null";
    public static final String ERR_ARGS_INDEXES_CAN_T_BE_NULL = "min and max indexes (from-to) can't be null";
    public static final String ERR_MEMBERS_CAN_T_BE_NULL = "members can't be null";
    public static final String ERR_SCORES_CAN_T_BE_NULL = "scores can't be null";
    protected final FunctionalMap.ReadWriteMap<K, SortedSetBucket<V>> readWriteMap;
    protected final AdvancedCache<K, SortedSetBucket<V>> cache;
    protected final InternalEntryFactory entryFactory;

    public EmbeddedMultimapSortedSetCache(Cache<K, SortedSetBucket<V>> cache) {
        this.cache = cache.getAdvancedCache();
        FunctionalMapImpl functionalMap = FunctionalMapImpl.create(this.cache);
        this.readWriteMap = ReadWriteMapImpl.create((FunctionalMapImpl)functionalMap);
        this.entryFactory = (InternalEntryFactory)ComponentRegistry.of(cache).getInternalEntryFactory().running();
    }

    public CompletionStage<Long> addMany(K key, Collection<ScoredValue<V>> scoredValues, SortedSetAddArgs args) {
        Objects.requireNonNull(key, ERR_KEY_CAN_T_BE_NULL);
        Objects.requireNonNull(scoredValues, ERR_SCORES_CAN_T_BE_NULL);
        Objects.requireNonNull(args, ERR_ARGS_CAN_T_BE_NULL);
        if (scoredValues.isEmpty() && !args.replace) {
            return CompletableFuture.completedFuture(0L);
        }
        return this.readWriteMap.eval(key, new AddManyFunction(scoredValues, args));
    }

    public CompletionStage<Double> incrementScore(K key, double score, V member, SortedSetAddArgs args) {
        Objects.requireNonNull(key, ERR_KEY_CAN_T_BE_NULL);
        Objects.requireNonNull(member, ERR_MEMBER_CAN_T_BE_NULL);
        Objects.requireNonNull(args, ERR_ARGS_CAN_T_BE_NULL);
        return this.readWriteMap.eval(key, new IncrFunction(score, member, args));
    }

    public CompletionStage<Long> size(K key) {
        Objects.requireNonNull(key, ERR_KEY_CAN_T_BE_NULL);
        return this.cache.getAsync(key).thenApply(b -> b == null ? 0L : b.size());
    }

    public CompletionStage<Collection<ScoredValue<V>>> get(K key) {
        Objects.requireNonNull(key, ERR_KEY_CAN_T_BE_NULL);
        return this.getEntry(key).thenApply(entry -> {
            if (entry != null) {
                return (Collection)entry.getValue();
            }
            return Set.of();
        });
    }

    public CompletionStage<CacheEntry<K, Collection<ScoredValue<V>>>> getEntry(K key) {
        Objects.requireNonNull(key, ERR_KEY_CAN_T_BE_NULL);
        return this.cache.getAdvancedCache().getCacheEntryAsync(key).thenApply(entry -> {
            if (entry == null) {
                return null;
            }
            return this.entryFactory.create(entry.getKey(), ((SortedSetBucket)entry.getValue()).toTreeSet(), entry.getMetadata());
        });
    }

    public CompletionStage<SortedSet<ScoredValue<V>>> getValue(K key) {
        Objects.requireNonNull(key, ERR_KEY_CAN_T_BE_NULL);
        return this.cache.getAsync(key).thenApply(b -> {
            if (b != null) {
                return b.getScoredEntries();
            }
            return null;
        });
    }

    public CompletionStage<List<ScoredValue<V>>> getValueAsList(K key) {
        Objects.requireNonNull(key, ERR_KEY_CAN_T_BE_NULL);
        return this.cache.getCacheEntryAsync(key).thenApply(b -> {
            if (b == null) {
                return null;
            }
            BaseSetBucket value = (BaseSetBucket)b.getValue();
            return value.getAsList();
        });
    }

    public CompletionStage<Set<MultimapObjectWrapper<V>>> getValuesSet(K key) {
        Objects.requireNonNull(key, ERR_KEY_CAN_T_BE_NULL);
        return this.cache.getCacheEntryAsync(key).thenApply(b -> {
            if (b == null) {
                return null;
            }
            BaseSetBucket value = (BaseSetBucket)b.getValue();
            return value.getAsSet().stream().map(ScoredValue::wrappedValue).collect(Collectors.toSet());
        });
    }

    public CompletionStage<Long> count(K key, double min, boolean includeMin, double max, boolean includeMax) {
        Objects.requireNonNull(key, ERR_KEY_CAN_T_BE_NULL);
        return this.readWriteMap.eval(key, new CountFunction(min, includeMin, max, includeMax, SortedSetOperationType.SCORE));
    }

    public CompletionStage<Long> count(K key, V min, boolean includeMin, V max, boolean includeMax) {
        Objects.requireNonNull(key, ERR_KEY_CAN_T_BE_NULL);
        return this.readWriteMap.eval(key, new CountFunction(min, includeMin, max, includeMax, SortedSetOperationType.LEX));
    }

    public CompletionStage<Collection<ScoredValue<V>>> pop(K key, boolean min, long count) {
        Objects.requireNonNull(key, ERR_KEY_CAN_T_BE_NULL);
        return this.readWriteMap.eval(key, new PopFunction(min, count));
    }

    public CompletionStage<Double> score(K key, V member) {
        Objects.requireNonNull(key, ERR_KEY_CAN_T_BE_NULL);
        Objects.requireNonNull(member, ERR_MEMBER_CAN_T_BE_NULL);
        return this.readWriteMap.eval(key, new ScoreFunction(Collections.singletonList(member))).thenApply(c -> {
            if (c == null || c.isEmpty()) {
                return null;
            }
            return (Double)c.get(0);
        });
    }

    public CompletionStage<List<Double>> scores(K key, List<V> members) {
        Objects.requireNonNull(key, ERR_KEY_CAN_T_BE_NULL);
        Objects.requireNonNull(members, ERR_MEMBERS_CAN_T_BE_NULL);
        return this.readWriteMap.eval(key, new ScoreFunction(members)).thenApply(c -> {
            if (c == null || c.isEmpty()) {
                return members.stream().map(m -> null).collect(Collectors.toList());
            }
            return c;
        });
    }

    public CompletionStage<Collection<ScoredValue<V>>> subsetByIndex(K key, SortedSetSubsetArgs<Long> args) {
        Objects.requireNonNull(key, ERR_KEY_CAN_T_BE_NULL);
        Objects.requireNonNull(args, ERR_ARGS_CAN_T_BE_NULL);
        Objects.requireNonNull(args.getStart(), ERR_ARGS_INDEXES_CAN_T_BE_NULL);
        Objects.requireNonNull(args.getStop(), ERR_ARGS_INDEXES_CAN_T_BE_NULL);
        return this.readWriteMap.eval(key, new SubsetFunction(args, SortedSetOperationType.INDEX));
    }

    public CompletionStage<Collection<ScoredValue<V>>> subsetByScore(K key, SortedSetSubsetArgs<Double> args) {
        Objects.requireNonNull(key, ERR_KEY_CAN_T_BE_NULL);
        Objects.requireNonNull(args, ERR_ARGS_CAN_T_BE_NULL);
        return this.readWriteMap.eval(key, new SubsetFunction(args, SortedSetOperationType.SCORE));
    }

    public CompletionStage<Collection<ScoredValue<V>>> subsetByLex(K key, SortedSetSubsetArgs<V> args) {
        Objects.requireNonNull(key, ERR_KEY_CAN_T_BE_NULL);
        Objects.requireNonNull(args, ERR_ARGS_CAN_T_BE_NULL);
        return this.readWriteMap.eval(key, new SubsetFunction(args, SortedSetOperationType.LEX));
    }

    public CompletionStage<SortedSetBucket.IndexValue> indexOf(K key, V member, boolean isRev) {
        Objects.requireNonNull(key, ERR_KEY_CAN_T_BE_NULL);
        Objects.requireNonNull(member, ERR_MEMBER_CAN_T_BE_NULL);
        return this.readWriteMap.eval(key, new IndexOfSortedSetFunction(member, isRev));
    }

    public CompletionStage<Collection<ScoredValue<V>>> union(K key, Collection<ScoredValue<V>> scoredValues, double weight, SortedSetBucket.AggregateFunction aggFunction) {
        Objects.requireNonNull(key, ERR_KEY_CAN_T_BE_NULL);
        SortedSetBucket.AggregateFunction agg = aggFunction == null ? SortedSetBucket.AggregateFunction.SUM : aggFunction;
        return this.readWriteMap.eval(key, new SortedSetAggregateFunction(SortedSetAggregateFunction.AggregateType.UNION, scoredValues, weight, agg));
    }

    public CompletionStage<Collection<ScoredValue<V>>> inter(K key, Collection<ScoredValue<V>> scoredValues, double weight, SortedSetBucket.AggregateFunction aggFunction) {
        Objects.requireNonNull(key, ERR_KEY_CAN_T_BE_NULL);
        SortedSetBucket.AggregateFunction agg = aggFunction == null ? SortedSetBucket.AggregateFunction.SUM : aggFunction;
        return this.readWriteMap.eval(key, new SortedSetAggregateFunction(SortedSetAggregateFunction.AggregateType.INTER, scoredValues, weight, agg));
    }

    public CompletionStage<Long> removeAll(K key, List<V> members) {
        Objects.requireNonNull(key, ERR_KEY_CAN_T_BE_NULL);
        Objects.requireNonNull(members, ERR_MEMBERS_CAN_T_BE_NULL);
        return this.readWriteMap.eval(key, new RemoveManyFunction(members, SortedSetOperationType.OTHER));
    }

    public CompletionStage<Long> removeAll(K key, Long min, Long max) {
        Objects.requireNonNull(min, ERR_MIN_CAN_T_BE_NULL);
        Objects.requireNonNull(max, ERR_MAX_CAN_T_BE_NULL);
        return this.removeAll(key, min, false, max, false, SortedSetOperationType.INDEX);
    }

    public CompletionStage<Long> removeAll(K key, Double min, boolean includeMin, Double max, boolean includeMax) {
        return this.removeAll(key, min, includeMin, max, includeMax, SortedSetOperationType.SCORE);
    }

    public CompletionStage<Long> removeAll(K key, V min, boolean includeMin, V max, boolean includeMax) {
        return this.removeAll(key, min, includeMin, max, includeMax, SortedSetOperationType.LEX);
    }

    private CompletionStage<Long> removeAll(K key, Object min, boolean includeMin, Object max, boolean includeMax, SortedSetOperationType subsetType) {
        Objects.requireNonNull(key, ERR_KEY_CAN_T_BE_NULL);
        ArrayList<Object> list = new ArrayList<Object>(2);
        list.add(min);
        list.add(max);
        return this.readWriteMap.eval(key, new RemoveManyFunction(list, includeMin, includeMax, subsetType));
    }

    public CompletionStage<List<ScoredValue<V>>> randomMembers(K key, int count) {
        Objects.requireNonNull(key, ERR_KEY_CAN_T_BE_NULL);
        return this.readWriteMap.eval(key, new SortedSetRandomFunction(count));
    }
}

