/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.mapping;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.hibernate.MappingException;
import org.hibernate.Remove;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.KeyValue;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.PersistentClassVisitor;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.SingleTableSubclass;
import org.hibernate.mapping.SoftDeletable;
import org.hibernate.mapping.Subclass;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.TableOwner;
import org.hibernate.mapping.Value;
import org.hibernate.persister.entity.EntityPersister;

public class RootClass
extends PersistentClass
implements TableOwner,
SoftDeletable {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(RootClass.class);
    @Deprecated(since="6.2")
    @Remove
    public static final String DEFAULT_IDENTIFIER_COLUMN_NAME = "id";
    @Deprecated(since="6.2")
    @Remove
    public static final String DEFAULT_DISCRIMINATOR_COLUMN_NAME = "class";
    private Property identifierProperty;
    private KeyValue identifier;
    private Property version;
    private boolean polymorphic;
    private String cacheConcurrencyStrategy;
    private String cacheRegionName;
    private boolean lazyPropertiesCacheable = true;
    private String naturalIdCacheRegionName;
    private Value discriminator;
    private boolean mutable = true;
    private boolean embeddedIdentifier;
    private boolean explicitPolymorphism;
    private Class<? extends EntityPersister> entityPersisterClass;
    private boolean forceDiscriminator;
    private boolean concreteProxy;
    private String where;
    private Table table;
    private boolean discriminatorInsertable = true;
    private int nextSubclassId;
    private Property declaredIdentifierProperty;
    private Property declaredVersion;
    private Column softDeleteColumn;

    public RootClass(MetadataBuildingContext buildingContext) {
        super(buildingContext);
    }

    @Override
    int nextSubclassId() {
        return ++this.nextSubclassId;
    }

    @Override
    public int getSubclassId() {
        return 0;
    }

    @Override
    public void setTable(Table table) {
        this.table = table;
    }

    @Override
    public Table getTable() {
        return this.table;
    }

    @Override
    public Property getIdentifierProperty() {
        return this.identifierProperty;
    }

    @Override
    public Property getDeclaredIdentifierProperty() {
        return this.declaredIdentifierProperty;
    }

    public void setDeclaredIdentifierProperty(Property declaredIdentifierProperty) {
        this.declaredIdentifierProperty = declaredIdentifierProperty;
    }

    @Override
    public KeyValue getIdentifier() {
        return this.identifier;
    }

    @Override
    public boolean hasIdentifierProperty() {
        return this.identifierProperty != null;
    }

    public boolean hasDiscriminator() {
        return this.discriminator != null;
    }

    @Override
    public Value getDiscriminator() {
        return this.discriminator;
    }

    @Override
    public boolean isInherited() {
        return false;
    }

    @Override
    public boolean isPolymorphic() {
        return this.polymorphic;
    }

    public void setPolymorphic(boolean polymorphic) {
        this.polymorphic = polymorphic;
    }

    @Override
    public RootClass getRootClass() {
        return this;
    }

    @Override
    public List<Property> getPropertyClosure() {
        return this.getProperties();
    }

    @Override
    public List<Table> getTableClosure() {
        return List.of(this.getTable());
    }

    @Override
    public List<KeyValue> getKeyClosure() {
        return List.of(this.getKey());
    }

    @Override
    public void addSubclass(Subclass subclass) throws MappingException {
        super.addSubclass(subclass);
        this.setPolymorphic(true);
    }

    @Override
    public boolean isExplicitPolymorphism() {
        return this.explicitPolymorphism;
    }

    @Override
    public Property getVersion() {
        return this.version;
    }

    @Override
    public Property getDeclaredVersion() {
        return this.declaredVersion;
    }

    public void setDeclaredVersion(Property declaredVersion) {
        this.declaredVersion = declaredVersion;
    }

    public void setVersion(Property version) {
        this.version = version;
    }

    @Override
    public boolean isVersioned() {
        return this.version != null;
    }

    @Override
    public boolean isMutable() {
        return this.mutable;
    }

    @Override
    public boolean hasEmbeddedIdentifier() {
        return this.embeddedIdentifier;
    }

    @Override
    public Class<? extends EntityPersister> getEntityPersisterClass() {
        return this.entityPersisterClass;
    }

    @Override
    public Table getRootTable() {
        return this.getTable();
    }

    @Override
    public void setEntityPersisterClass(Class<? extends EntityPersister> persister) {
        this.entityPersisterClass = persister;
    }

    @Override
    public PersistentClass getSuperclass() {
        return null;
    }

    @Override
    public KeyValue getKey() {
        return this.getIdentifier();
    }

    public void setDiscriminator(Value discriminator) {
        this.discriminator = discriminator;
    }

    public void setEmbeddedIdentifier(boolean embeddedIdentifier) {
        this.embeddedIdentifier = embeddedIdentifier;
    }

    public void setExplicitPolymorphism(boolean explicitPolymorphism) {
        this.explicitPolymorphism = explicitPolymorphism;
    }

    public void setIdentifier(KeyValue identifier) {
        this.identifier = identifier;
    }

    public void setIdentifierProperty(Property identifierProperty) {
        this.identifierProperty = identifierProperty;
        identifierProperty.setPersistentClass(this);
    }

    public void setMutable(boolean mutable) {
        this.mutable = mutable;
    }

    @Override
    public boolean isDiscriminatorInsertable() {
        return this.discriminatorInsertable;
    }

    public void setDiscriminatorInsertable(boolean insertable) {
        this.discriminatorInsertable = insertable;
    }

    @Override
    public boolean isForceDiscriminator() {
        return this.forceDiscriminator;
    }

    public void setForceDiscriminator(boolean forceDiscriminator) {
        this.forceDiscriminator = forceDiscriminator;
    }

    @Override
    public boolean isConcreteProxy() {
        return this.concreteProxy;
    }

    public void setConcreteProxy(boolean concreteProxy) {
        this.concreteProxy = concreteProxy;
    }

    @Override
    public String getWhere() {
        return this.where;
    }

    public void setWhere(String string) {
        this.where = string;
    }

    @Override
    public void validate(Metadata mapping) throws MappingException {
        super.validate(mapping);
        if (!this.getIdentifier().isValid(mapping)) {
            throw new MappingException("identifier mapping has wrong number of columns: " + this.getEntityName() + " type: " + this.getIdentifier().getType().getName());
        }
        this.checkCompositeIdentifier();
        this.checkTableDuplication();
    }

    private void checkTableDuplication() {
        if (this.hasSubclasses()) {
            HashSet<Table> tables = new HashSet<Table>();
            tables.add(this.getTable());
            for (Subclass subclass : this.getSubclasses()) {
                Table table;
                if (subclass instanceof SingleTableSubclass || tables.add(table = subclass.getTable())) continue;
                if (this.getDiscriminator() == null) {
                    throw new MappingException("Two different subclasses of '" + this.getEntityName() + "' map to the table '" + table.getName() + "' and the hierarchy has no discriminator column");
                }
                this.forceDiscriminator = true;
                break;
            }
        }
    }

    private void checkCompositeIdentifier() {
        Class<?> idClass;
        Component id;
        if (this.getIdentifier() instanceof Component && !(id = (Component)this.getIdentifier()).isDynamic() && (idClass = id.getComponentClass()) != null) {
            String idComponentClassName = idClass.getName();
            if (!ReflectHelper.overridesEquals(idClass)) {
                LOG.compositeIdClassDoesNotOverrideEquals(idComponentClassName);
            }
            if (!ReflectHelper.overridesHashCode(idClass)) {
                LOG.compositeIdClassDoesNotOverrideHashCode(idComponentClassName);
            }
        }
    }

    @Override
    public String getCacheConcurrencyStrategy() {
        return this.cacheConcurrencyStrategy;
    }

    public void setCacheConcurrencyStrategy(String cacheConcurrencyStrategy) {
        this.cacheConcurrencyStrategy = cacheConcurrencyStrategy;
    }

    public String getCacheRegionName() {
        return this.cacheRegionName == null ? this.getEntityName() : this.cacheRegionName;
    }

    public void setCacheRegionName(String cacheRegionName) {
        this.cacheRegionName = StringHelper.nullIfEmpty(cacheRegionName);
    }

    public boolean isLazyPropertiesCacheable() {
        return this.lazyPropertiesCacheable;
    }

    public void setLazyPropertiesCacheable(boolean lazyPropertiesCacheable) {
        this.lazyPropertiesCacheable = lazyPropertiesCacheable;
    }

    @Override
    public String getNaturalIdCacheRegionName() {
        return this.naturalIdCacheRegionName;
    }

    public void setNaturalIdCacheRegionName(String naturalIdCacheRegionName) {
        this.naturalIdCacheRegionName = naturalIdCacheRegionName;
    }

    @Override
    public boolean isJoinedSubclass() {
        return false;
    }

    @Override
    public Set<String> getSynchronizedTables() {
        return this.synchronizedTables;
    }

    public Set<Table> getIdentityTables() {
        HashSet<Table> tables = new HashSet<Table>();
        for (PersistentClass clazz : this.getSubclassClosure()) {
            if (clazz.isAbstract() != null && clazz.isAbstract().booleanValue()) continue;
            tables.add(clazz.getIdentityTable());
        }
        return tables;
    }

    @Override
    public void enableSoftDelete(Column indicatorColumn) {
        this.softDeleteColumn = indicatorColumn;
    }

    @Override
    public Column getSoftDeleteColumn() {
        return this.softDeleteColumn;
    }

    @Override
    public Object accept(PersistentClassVisitor mv) {
        return mv.accept(this);
    }
}

