/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oid4vc.issuance.credentialbuilder;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Map;
import org.keycloak.crypto.SignatureSignerContext;
import org.keycloak.protocol.oid4vc.issuance.credentialbuilder.CredentialBody;
import org.keycloak.sdjwt.SdJwt;
import org.keycloak.util.JsonSerialization;

public class SdJwtCredentialBody
implements CredentialBody {
    private static final String CNF_CLAIM = "cnf";
    private final SdJwt.Builder sdJwtBuilder;
    private final Map<String, Object> claimSet;

    public SdJwtCredentialBody(SdJwt.Builder sdJwtBuilder, Map<String, Object> claimSet) {
        this.sdJwtBuilder = sdJwtBuilder;
        this.claimSet = claimSet;
    }

    public void addCnfClaim(Object cnf) {
        this.claimSet.put(CNF_CLAIM, cnf);
    }

    public String sign(SignatureSignerContext signatureSignerContext) {
        JsonNode claimSet = JsonSerialization.mapper.valueToTree(this.claimSet);
        SdJwt sdJwt = this.sdJwtBuilder.withClaimSet(claimSet).withSigner(signatureSignerContext).build();
        return sdJwt.toSdJwtString();
    }
}

