/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.proxy;

import io.quarkus.deployment.util.ClassOutputUtil;
import io.quarkus.gizmo.ClassOutput;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

class InjectIntoClassloaderClassOutput
implements ClassOutput {
    private final ClassLoader classLoader;
    private final Method visibleDefineClassMethod;

    InjectIntoClassloaderClassOutput(ClassLoader classLoader) {
        this.classLoader = classLoader;
        try {
            this.visibleDefineClassMethod = classLoader.getClass().getDeclaredMethod("visibleDefineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE);
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new IllegalStateException("Unable to initialize InjectIntoClassloaderClassOutput - Incorrect classloader (" + String.valueOf(classLoader.getClass()) + ") usage detected");
        }
    }

    public void write(String name, byte[] data) {
        if (System.getProperty("dumpClass") != null) {
            ClassOutputUtil.dumpClass(name, data);
        }
        try {
            this.visibleDefineClassMethod.invoke((Object)this.classLoader, name.replace('/', '.'), data, 0, data.length);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }
}

