/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.builder;

import io.quarkus.builder.BuildChain;
import io.quarkus.builder.BuildProvider;
import io.quarkus.builder.BuildStep;
import io.quarkus.builder.BuildStepBuilder;
import io.quarkus.builder.ChainBuildException;
import io.quarkus.builder.Constraint;
import io.quarkus.builder.Consume;
import io.quarkus.builder.ConsumeFlag;
import io.quarkus.builder.FinalStep;
import io.quarkus.builder.ItemId;
import io.quarkus.builder.Produce;
import io.quarkus.builder.ProduceFlag;
import io.quarkus.builder.StepInfo;
import io.quarkus.builder.item.BuildItem;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.wildfly.common.Assert;

public final class BuildChainBuilder {
    private static final String GRAPH_OUTPUT = System.getProperty("quarkus.builder.graph-output");
    static final boolean LOG_CONFLICT_CAUSING = Boolean.getBoolean("quarkus.builder.log-conflict-cause");
    private final BuildStepBuilder finalStep;
    private final List<BuildProvider> providers = new ArrayList<BuildProvider>();
    private final Map<BuildStepBuilder, StackTraceElement[]> steps = new HashMap<BuildStepBuilder, StackTraceElement[]>();
    private final Set<ItemId> initialIds = new HashSet<ItemId>();
    private final Set<ItemId> finalIds = new HashSet<ItemId>();
    private ClassLoader classLoader = BuildChainBuilder.class.getClassLoader();
    private static final Pattern QUOTE_PATTERN = Pattern.compile("[\"]");

    BuildChainBuilder() {
        this.finalStep = this.addBuildStep(new FinalStep());
    }

    public BuildStepBuilder addBuildStep(BuildStep buildStep) {
        BuildStepBuilder buildStepBuilder = new BuildStepBuilder(this);
        buildStepBuilder.setBuildStep(buildStep);
        return buildStepBuilder;
    }

    public BuildStepBuilder addBuildStep() {
        return new BuildStepBuilder(this);
    }

    public BuildChainBuilder addInitial(Class<? extends BuildItem> type) {
        Assert.checkNotNullParam((String)"type", type);
        this.initialIds.add(new ItemId(type));
        return this;
    }

    public BuildChainBuilder loadProviders(ClassLoader classLoader) throws ChainBuildException {
        ServiceLoader<BuildProvider> serviceLoader = ServiceLoader.load(BuildProvider.class, classLoader);
        for (BuildProvider provider : serviceLoader) {
            provider.installInto(this);
        }
        return this;
    }

    public BuildChainBuilder addFinal(Class<? extends BuildItem> type) {
        Assert.checkNotNullParam((String)"type", type);
        this.finalIds.add(new ItemId(type));
        return this;
    }

    ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public BuildChain build() throws ChainBuildException {
        HashSet<BuildStepBuilder> included = new HashSet<BuildStepBuilder>();
        Map<BuildStepBuilder, Set<Produce>> dependencies = this.wireDependencies(included);
        this.detectCycles(included, dependencies);
        HashSet<StepInfo> startSteps = new HashSet<StepInfo>();
        Set<StepInfo> endSteps = this.buildAllSteps(included, dependencies, startSteps);
        BuildChainBuilder.outputGraph(startSteps, endSteps);
        return new BuildChain(startSteps, this, endSteps.size());
    }

    private Map<BuildStepBuilder, Set<Produce>> wireDependencies(Set<BuildStepBuilder> included) throws ChainBuildException {
        BuildStepBuilder stepBuilder;
        Map<ItemId, List<Produce>> allProduces = this.extractProducers();
        ArrayDeque<BuildStepBuilder> toAdd = new ArrayDeque<BuildStepBuilder>();
        for (ItemId finalId : this.finalIds) {
            this.addItem(allProduces, included, toAdd, finalId);
        }
        HashMap<BuildStepBuilder, Set<Produce>> dependencies = new HashMap<BuildStepBuilder, Set<Produce>>();
        while ((stepBuilder = (BuildStepBuilder)toAdd.pollFirst()) != null) {
            for (Map.Entry<ItemId, Consume> entry : stepBuilder.getConsumes().entrySet()) {
                Consume consume = entry.getValue();
                ItemId id = entry.getKey();
                if (!(consume.getFlags().contains(ConsumeFlag.OPTIONAL) || id.isMulti() || this.initialIds.contains(id) || allProduces.containsKey(id))) {
                    throw new ChainBuildException("No producers for required item " + String.valueOf(id));
                }
                this.addItem(allProduces, included, toAdd, id, dependencies.computeIfAbsent(stepBuilder, x -> new HashSet()));
            }
        }
        return dependencies;
    }

    private Map<ItemId, List<Produce>> extractProducers() throws ChainBuildException {
        HashMap<ItemId, List<Produce>> allProduces = new HashMap<ItemId, List<Produce>>();
        for (Map.Entry<BuildStepBuilder, StackTraceElement[]> stepEntry : this.steps.entrySet()) {
            BuildStepBuilder stepBuilder = stepEntry.getKey();
            Map<ItemId, Produce> stepProduces = stepBuilder.getProduces();
            for (Map.Entry<ItemId, Produce> entry : stepProduces.entrySet()) {
                ItemId id = entry.getKey();
                List list = allProduces.computeIfAbsent(id, x -> new ArrayList(2));
                Produce toBeAdded = entry.getValue();
                if (!id.isMulti() && toBeAdded.getConstraint() == Constraint.REAL) {
                    if (this.initialIds.contains(id)) {
                        String message = "Item " + String.valueOf(id) + " cannot be produced here (it is an initial resource) (" + String.valueOf(toBeAdded.getStepBuilder().getBuildStep()) + ").";
                        if (!LOG_CONFLICT_CAUSING) {
                            message = message + " Use -Dquarkus.builder.log-conflict-cause=true to see the full stacktrace.";
                        }
                        ChainBuildException cbe = new ChainBuildException(message);
                        cbe.setStackTrace(this.steps.get(toBeAdded.getStepBuilder()));
                        throw cbe;
                    }
                    boolean overridable = toBeAdded.isOverridable();
                    for (Produce produce : list) {
                        if (produce.getConstraint() != Constraint.REAL || produce.isOverridable() != overridable) continue;
                        String message = "This is the location of the conflicting producer (" + String.valueOf(toBeAdded.getStepBuilder().getBuildStep()) + ").";
                        if (!LOG_CONFLICT_CAUSING) {
                            message = message + " Use -Dquarkus.builder.log-conflict-cause=true to see the full stacktrace.";
                        }
                        Throwable cause = new Throwable(message);
                        cause.setStackTrace(this.steps.get(toBeAdded.getStepBuilder()));
                        ChainBuildException cbe = new ChainBuildException(String.format("Multiple %sproducers of item %s (%s)", overridable ? "overridable " : "", id, produce.getStepBuilder().getBuildStep()), cause);
                        cbe.setStackTrace(this.steps.get(produce.getStepBuilder()));
                        throw cbe;
                    }
                }
                list.add(toBeAdded);
            }
        }
        return allProduces;
    }

    private static void writeStep(BufferedWriter writer, HashSet<StepInfo> printed, StepInfo step) throws IOException {
        if (printed.add(step)) {
            String currentStepName = BuildChainBuilder.quoteString(step.getBuildStep().getId());
            Set<StepInfo> dependents = step.getDependents();
            if (!dependents.isEmpty()) {
                for (StepInfo dependent : dependents) {
                    String dependentName = BuildChainBuilder.quoteString(dependent.getBuildStep().getId());
                    writer.write("    ");
                    writer.write(dependentName);
                    writer.write(" -> ");
                    writer.write(currentStepName);
                    writer.newLine();
                }
                writer.newLine();
                for (StepInfo dependent : dependents) {
                    BuildChainBuilder.writeStep(writer, printed, dependent);
                }
            }
        }
    }

    private static String quoteString(String input) {
        Matcher matcher = QUOTE_PATTERN.matcher(input);
        StringBuilder sb = new StringBuilder();
        sb.append('\"');
        while (matcher.find()) {
            matcher.appendReplacement(sb, "\\" + matcher.group(0));
        }
        matcher.appendTail(sb);
        sb.append('\"');
        return sb.toString();
    }

    private void detectCycles(Set<BuildStepBuilder> builders, Map<BuildStepBuilder, Set<Produce>> dependencies) throws ChainBuildException {
        this.detectCycles(builders, new HashSet<BuildStepBuilder>(), new HashSet<BuildStepBuilder>(), dependencies, new ArrayDeque<Produce>());
    }

    private void detectCycles(Set<BuildStepBuilder> builders, Set<BuildStepBuilder> visited, Set<BuildStepBuilder> checked, Map<BuildStepBuilder, Set<Produce>> dependencies, Deque<Produce> producedPath) throws ChainBuildException {
        for (BuildStepBuilder builder : builders) {
            this.detectCycles(builder, visited, checked, dependencies, producedPath);
        }
    }

    private void cycleCheckProduce(Set<Produce> produceSet, Set<BuildStepBuilder> visited, Set<BuildStepBuilder> checked, Map<BuildStepBuilder, Set<Produce>> dependencies, Deque<Produce> producedPath) throws ChainBuildException {
        for (Produce produce : produceSet) {
            producedPath.add(produce);
            this.detectCycles(produce.getStepBuilder(), visited, checked, dependencies, producedPath);
            producedPath.removeLast();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void detectCycles(BuildStepBuilder builder, Set<BuildStepBuilder> visited, Set<BuildStepBuilder> checked, Map<BuildStepBuilder, Set<Produce>> dependencies, Deque<Produce> producedPath) throws ChainBuildException {
        if (!checked.contains(builder)) {
            if (!visited.add(builder)) {
                StringBuilder b = new StringBuilder("Cycle detected:\n\t\t   ");
                Iterator<Produce> itr = producedPath.descendingIterator();
                if (itr.hasNext()) {
                    Produce produce = itr.next();
                    do {
                        b.append(produce.getStepBuilder().getBuildStep());
                        ItemId itemId = produce.getItemId();
                        b.append(" produced ").append(itemId);
                        b.append("\n\t\tto ");
                    } while (itr.hasNext() && (produce = itr.next()).getStepBuilder() != builder);
                    b.append(builder.getBuildStep());
                }
                throw new ChainBuildException(b.toString());
            }
            try {
                Set<Produce> dependencySet = dependencies.getOrDefault(builder, Collections.emptySet());
                this.cycleCheckProduce(dependencySet, visited, checked, dependencies, producedPath);
            }
            finally {
                visited.remove(builder);
            }
        }
        checked.add(builder);
    }

    private void addItem(Map<ItemId, List<Produce>> allProduces, Set<BuildStepBuilder> included, ArrayDeque<BuildStepBuilder> toAdd, ItemId idToAdd) {
        this.addItem(allProduces, included, toAdd, idToAdd, null);
    }

    private void addItem(Map<ItemId, List<Produce>> allProduces, Set<BuildStepBuilder> included, ArrayDeque<BuildStepBuilder> toAdd, ItemId idToAdd, Set<Produce> dependencies) {
        boolean modified = BuildChainBuilder.produceItem(allProduces, included, toAdd, idToAdd, dependencies, false);
        if (!modified) {
            BuildChainBuilder.produceItem(allProduces, included, toAdd, idToAdd, dependencies, true);
        }
    }

    private static boolean produceItem(Map<ItemId, List<Produce>> allProduces, Set<BuildStepBuilder> included, ArrayDeque<BuildStepBuilder> toAdd, ItemId idToAdd, Set<Produce> dependencies, boolean overrideable) {
        boolean modified = false;
        for (Produce produce : allProduces.getOrDefault(idToAdd, Collections.emptyList())) {
            BuildStepBuilder stepBuilder = produce.getStepBuilder();
            if (overrideable != produce.getFlags().contains(ProduceFlag.OVERRIDABLE)) continue;
            if (!produce.getFlags().contains(ProduceFlag.WEAK) && included.add(stepBuilder)) {
                toAdd.addLast(stepBuilder);
            }
            if (dependencies != null) {
                dependencies.add(produce);
            }
            modified = true;
        }
        return modified;
    }

    private Set<StepInfo> buildAllSteps(Set<BuildStepBuilder> included, Map<BuildStepBuilder, Set<Produce>> dependencies, Set<StepInfo> startSteps) {
        Map<BuildStepBuilder, Set<BuildStepBuilder>> dependents = BuildChainBuilder.calculateDependents(dependencies);
        HashSet<StepInfo> endSteps = new HashSet<StepInfo>();
        HashMap<BuildStepBuilder, StepInfo> mappedSteps = new HashMap<BuildStepBuilder, StepInfo>();
        for (BuildStepBuilder builder : included) {
            this.buildOne(builder, included, mappedSteps, dependents, dependencies, startSteps, endSteps);
        }
        return endSteps;
    }

    private static Map<BuildStepBuilder, Set<BuildStepBuilder>> calculateDependents(Map<BuildStepBuilder, Set<Produce>> dependencies) {
        HashMap<BuildStepBuilder, Set<BuildStepBuilder>> dependents = new HashMap<BuildStepBuilder, Set<BuildStepBuilder>>();
        for (Map.Entry<BuildStepBuilder, Set<Produce>> entry : dependencies.entrySet()) {
            BuildStepBuilder dependent = entry.getKey();
            for (Produce produce : entry.getValue()) {
                dependents.computeIfAbsent(produce.getStepBuilder(), x -> new HashSet()).add(dependent);
            }
        }
        return dependents;
    }

    private StepInfo buildOne(BuildStepBuilder toBuild, Set<BuildStepBuilder> included, Map<BuildStepBuilder, StepInfo> mapped, Map<BuildStepBuilder, Set<BuildStepBuilder>> dependents, Map<BuildStepBuilder, Set<Produce>> dependencies, Set<StepInfo> startSteps, Set<StepInfo> endSteps) {
        if (mapped.containsKey(toBuild)) {
            return mapped.get(toBuild);
        }
        HashSet<StepInfo> dependentStepInfos = new HashSet<StepInfo>();
        Set dependentsOfThis = dependents.getOrDefault(toBuild, Collections.emptySet());
        for (BuildStepBuilder dependentBuilder : dependentsOfThis) {
            if (!included.contains(dependentBuilder)) continue;
            dependentStepInfos.add(this.buildOne(dependentBuilder, included, mapped, dependents, dependencies, startSteps, endSteps));
        }
        Set dependenciesOfThis = dependencies.getOrDefault(toBuild, Collections.emptySet());
        int includedDependencies = 0;
        HashSet<BuildStepBuilder> visited = new HashSet<BuildStepBuilder>();
        for (Object produce : dependenciesOfThis) {
            BuildStepBuilder stepBuilder = ((Produce)produce).getStepBuilder();
            if (!included.contains(stepBuilder) || !visited.add(stepBuilder)) continue;
            ++includedDependencies;
        }
        int includedDependents = 0;
        for (BuildStepBuilder dependent : dependentsOfThis) {
            if (!included.contains(dependent)) continue;
            ++includedDependents;
        }
        StepInfo stepInfo = new StepInfo(toBuild, includedDependencies, dependentStepInfos);
        mapped.put(toBuild, stepInfo);
        if (includedDependencies == 0) {
            startSteps.add(stepInfo);
        }
        if (includedDependents == 0) {
            endSteps.add(stepInfo);
        }
        return stepInfo;
    }

    void addProvider(BuildProvider provider) throws ChainBuildException {
        this.providers.add(provider);
        provider.installInto(this);
    }

    void addStep(BuildStepBuilder stepBuilder, StackTraceElement[] stackTrace) {
        if (stepBuilder.getBuildStep() == null) {
            throw new IllegalArgumentException("Null build step");
        }
        this.steps.put(stepBuilder, stackTrace);
    }

    List<BuildProvider> getProviders() {
        return this.providers;
    }

    Set<ItemId> getInitialIds() {
        return this.initialIds;
    }

    Set<ItemId> getFinalIds() {
        return this.finalIds;
    }

    private static void outputGraph(Set<StepInfo> startSteps, Set<StepInfo> endSteps) {
        if (GRAPH_OUTPUT != null && !GRAPH_OUTPUT.isEmpty()) {
            try (FileOutputStream fos = new FileOutputStream(GRAPH_OUTPUT);
                 OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, StandardCharsets.UTF_8);
                 BufferedWriter writer = new BufferedWriter(osw);){
                writer.write("digraph {");
                writer.newLine();
                writer.write("    node [shape=rectangle];");
                writer.newLine();
                writer.write("    rankdir=LR;");
                writer.newLine();
                writer.newLine();
                writer.write("    { rank = same; ");
                for (StepInfo startStep : startSteps) {
                    writer.write(BuildChainBuilder.quoteString(startStep.getBuildStep().getId()));
                    writer.write("; ");
                }
                writer.write("};");
                writer.newLine();
                writer.write("    { rank = same; ");
                for (StepInfo endStep : endSteps) {
                    if (startSteps.contains(endStep)) continue;
                    writer.write(BuildChainBuilder.quoteString(endStep.getBuildStep().getId()));
                    writer.write("; ");
                }
                writer.write("};");
                writer.newLine();
                writer.newLine();
                HashSet<StepInfo> printed = new HashSet<StepInfo>();
                for (StepInfo step : startSteps) {
                    BuildChainBuilder.writeStep(writer, printed, step);
                }
                writer.write("}");
                writer.newLine();
            }
            catch (IOException ioe) {
                throw new RuntimeException("Failed to write debug graph output", ioe);
            }
        }
    }
}

