/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.help.impl;

import com.sun.java.help.impl.HeaderParser;
import java.io.CharConversionException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URLConnection;

public final class XmlReader
extends Reader {
    private boolean closed;
    private InputStreamReader in;
    private InputStream raw;
    private byte[] buffer;
    private boolean isASCII;
    private boolean isLatin1;
    private int offset;
    private int length;
    private char nextChar;
    private int switchover;
    private String encodingAssigned;
    private static boolean debug = false;

    /*
     * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
     * Enabled aggressive block sorting
     */
    private XmlReader(InputStream inputStream) throws IOException {
        block16: {
            this.raw = inputStream;
            this.switchover = -1;
            this.buffer = new byte[8192];
            this.length = 0;
            this.offset = 0;
            this.isLatin1 = true;
            int n = this.read();
            switch (n) {
                case 0: {
                    n = this.read();
                    if (n == 60 && (n = this.read()) == 0 && (n = this.read()) == 63) {
                        this.setSwitchover("UnicodeBig");
                        return;
                    }
                    throw new UnsupportedEncodingException("UCS-4 (?)");
                }
                case 60: {
                    n = this.read();
                    switch (n) {
                        case 0: {
                            if (this.read() == 63 && this.read() == 0) {
                                this.setSwitchover("UnicodeLittle");
                                return;
                            }
                            throw new UnsupportedEncodingException("UCS-4");
                        }
                        case 63: {
                            if (this.read() == 120 && this.read() == 109 && this.read() == 108 && this.read() == 32) {
                                this.guessEncoding();
                                return;
                            }
                            break block16;
                        }
                        default: {
                            break block16;
                        }
                    }
                }
                case 254: {
                    n = this.read();
                    if (n == 255) {
                        this.setSwitchover("UnicodeBig");
                        this.offset = 2;
                        return;
                    }
                    break;
                }
                case 255: {
                    n = this.read();
                    if (n == 254) {
                        this.setSwitchover("UnicodeLittle");
                        this.offset = 2;
                        return;
                    }
                    break;
                }
                case -1: {
                    return;
                }
            }
        }
        this.setUTF8();
    }

    private XmlReader(InputStream inputStream, String string) throws IOException {
        this.buffer = new byte[8192];
        this.length = 0;
        this.raw = inputStream;
        if ("US-ASCII".equals(string)) {
            this.setASCII();
        } else if ("ISO-8859-1".equals(string)) {
            this.setLatin1();
        } else {
            if (!"UTF-8".equals(string)) {
                throw new UnsupportedEncodingException(string);
            }
            this.setUTF8();
        }
    }

    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        if (this.in != null) {
            this.in.close();
        } else {
            this.raw.close();
        }
        this.closed = true;
    }

    public static Reader createReader(InputStream inputStream) throws IOException {
        return new XmlReader(inputStream);
    }

    public static Reader createReader(InputStream inputStream, String string) throws IOException {
        if (string == null) {
            return new XmlReader(inputStream);
        }
        if ("UTF-16".equalsIgnoreCase(string) || "ISO-106460-UCS-2".equalsIgnoreCase(string)) {
            string = "Unicode";
        } else {
            if ("UTF-8".equalsIgnoreCase(string)) {
                return new XmlReader(inputStream, "UTF-8");
            }
            if ("EUC-JP".equalsIgnoreCase(string)) {
                string = "EUCJIS";
            } else {
                if (XmlReader.isAsciiName(string)) {
                    return new XmlReader(inputStream, "US-ASCII");
                }
                if (XmlReader.isLatinName(string)) {
                    return new XmlReader(inputStream, "ISO-8859-1");
                }
            }
        }
        return new InputStreamReader(inputStream, string);
    }

    public static Reader createReader(URLConnection uRLConnection) throws IOException {
        String string = XmlReader.getEncodingFromContentType(uRLConnection.getContentType());
        if (string == null) {
            return XmlReader.createReader(uRLConnection.getInputStream());
        }
        return XmlReader.createReader(uRLConnection.getInputStream(), string);
    }

    private static void debug(String string) {
        if (debug) {
            System.out.println("XmlReader: " + string);
        }
    }

    private void doSwitchover() throws IOException {
        if (this.offset != this.switchover) {
            throw new InternalError();
        }
        this.in = new InputStreamReader(this.raw, this.encodingAssigned);
        this.buffer = null;
        this.switchover = -1;
    }

    private static String getCharsetFromContentTypeParameters(String string) {
        String string2 = null;
        try {
            int n = string.indexOf(59);
            if (n > -1 && n < string.length() - 1) {
                string = string.substring(n + 1);
            }
            if (string.length() > 0) {
                HeaderParser headerParser = new HeaderParser(string);
                string2 = headerParser.findValue("charset");
                return string2;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (Exception exception) {
            System.err.println("Indexer.getCharsetFromContentTypeParameters failed on: " + string);
            exception.printStackTrace();
        }
        return string2;
    }

    public String getEncoding() {
        return this.encodingAssigned;
    }

    private static String getEncodingFromContentType(String string) {
        XmlReader.debug("type=" + string);
        if (string == null) {
            return null;
        }
        int n = string.indexOf(";");
        if (n > -1) {
            String string2 = string.substring(n);
            if ((string = string.substring(0, n).trim()).compareTo("text/xml") == 0) {
                return XmlReader.getCharsetFromContentTypeParameters(string2);
            }
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    private void guessEncoding() throws IOException {
        var2_1 = new StringBuffer();
        var3_2 = null;
        var4_3 = null;
        var5_4 = false;
        var6_5 = '\u0000';
        var7_6 = false;
        var8_7 = 0;
        block0: while (var8_7 < 100) {
            block22: {
                block23: {
                    var1_8 = this.read();
                    if (var1_8 == -1) {
                        this.setASCII();
                        return;
                    }
                    if (Character.isWhitespace((char)var1_8)) break block22;
                    if (var1_8 == 63) {
                        var7_6 = true;
                    } else if (var7_6) {
                        if (var1_8 == 62) break;
                        var7_6 = false;
                    }
                    if (var4_3 != null && var5_4) break block23;
                    if (var3_2 == null) {
                        if (!Character.isWhitespace((char)var1_8)) {
                            var3_2 = var2_1;
                            var2_1.setLength(0);
                            var2_1.append((char)var1_8);
                            var5_4 = false;
                        }
                    } else if (Character.isWhitespace((char)var1_8)) {
                        var4_3 = var3_2.toString();
                    } else if (var1_8 == 61) {
                        if (var4_3 == null) {
                            var4_3 = var3_2.toString();
                        }
                        var5_4 = true;
                        var3_2 = null;
                        var6_5 = '\u0000';
                    } else {
                        var3_2.append((char)var1_8);
                    }
                    break block22;
                }
                if (Character.isWhitespace((char)var1_8)) break block22;
                if (var1_8 != 34 && var1_8 != 39) ** GOTO lbl-1000
                if (var6_5 == '\u0000') {
                    var6_5 = (char)var1_8;
                    var2_1.setLength(0);
                } else if (var1_8 == var6_5) {
                    if ("encoding".equals(var4_3)) {
                        var9_9 = var2_1.toString();
                        var8_7 = 0;
                        while (var8_7 < var9_9.length()) {
                            var1_8 = var9_9.charAt(var8_7);
                            if (!(var1_8 >= 65 && var1_8 <= 90 || var1_8 >= 97 && var1_8 <= 122) && (var8_7 <= 0 || var1_8 != 45 && (var1_8 < 48 || var1_8 > 57) && var1_8 != 46 && var1_8 != 95)) break block0;
                            ++var8_7;
                        }
                        if (XmlReader.isAsciiName(var9_9)) {
                            this.setASCII();
                            return;
                        }
                        if (XmlReader.isLatinName(var9_9)) {
                            this.setLatin1();
                            return;
                        }
                        if ("UTF-8".equalsIgnoreCase(var9_9) || "UTF8".equalsIgnoreCase(var9_9)) break;
                        if ("EUC-JP".equalsIgnoreCase(var9_9)) {
                            var9_9 = "EUCJIS";
                        }
                        this.setSwitchover(var9_9);
                        return;
                    }
                    var4_3 = null;
                } else lbl-1000:
                // 2 sources

                {
                    var2_1.append((char)var1_8);
                }
            }
            ++var8_7;
        }
        this.setUTF8();
    }

    private static boolean isAsciiName(String string) {
        return "US-ASCII".equalsIgnoreCase(string) || "ASCII".equalsIgnoreCase(string);
    }

    private static boolean isLatinName(String string) {
        return "ISO-8859-1".equalsIgnoreCase(string) || "Latin1".equalsIgnoreCase(string) || "8859_1".equalsIgnoreCase(string);
    }

    public void mark(int n) throws IOException {
        if (this.in != null) {
            this.in.mark(n);
        }
    }

    public boolean markSupported() {
        return this.in != null && this.in.markSupported();
    }

    public int read() throws IOException {
        if (this.closed) {
            return -1;
        }
        if (this.switchover > 0 && this.offset == this.switchover) {
            this.doSwitchover();
        }
        if (this.in != null) {
            return this.in.read();
        }
        if (this.offset >= this.length) {
            if (this.encodingAssigned == null) {
                if (this.length == this.buffer.length) {
                    throw new InternalError("too much peekahead");
                }
                int n = this.raw.read(this.buffer, this.offset, 1);
                if (n <= 0) {
                    return -1;
                }
                this.length += n;
            } else {
                this.offset = 0;
                this.length = this.raw.read(this.buffer, 0, this.buffer.length);
                if (this.length <= 0) {
                    return -1;
                }
            }
        }
        if (this.isLatin1 || this.encodingAssigned == null) {
            return this.buffer[this.offset++] & 0xFF;
        }
        return this.utf8char();
    }

    public int read(char[] cArray, int n, int n2) throws IOException {
        int n3;
        if (this.closed) {
            return -1;
        }
        if (this.switchover > 0 && this.offset == this.switchover) {
            this.doSwitchover();
        }
        if (this.in != null) {
            return this.in.read(cArray, n, n2);
        }
        if (this.offset >= this.length) {
            this.offset = 0;
            this.length = this.raw.read(this.buffer, 0, this.buffer.length);
        }
        if (this.length <= 0) {
            return -1;
        }
        if (this.encodingAssigned == null || this.isLatin1) {
            n3 = 0;
            while (n3 < n2 && this.offset < this.length) {
                cArray[n++] = (char)(this.buffer[this.offset++] & 0xFF);
                ++n3;
            }
        } else {
            n3 = 0;
            while (n3 < n2 && this.offset < this.length) {
                cArray[n++] = this.utf8char();
                ++n3;
            }
        }
        return n3;
    }

    public boolean ready() throws IOException {
        if (this.in != null) {
            return this.in.ready();
        }
        return this.length > this.offset || this.raw.available() != 0;
    }

    public void reset() throws IOException {
        if (this.in != null) {
            this.in.reset();
        }
    }

    private void setASCII() {
        this.encodingAssigned = "US-ASCII";
        this.isASCII = true;
        this.isLatin1 = false;
        this.offset = 0;
    }

    private void setLatin1() {
        this.encodingAssigned = "ISO-8859-1";
        this.isASCII = false;
        this.isLatin1 = true;
        this.offset = 0;
    }

    private void setSwitchover(String string) throws IOException {
        this.switchover = this.offset;
        this.encodingAssigned = string;
        this.offset = 0;
    }

    private void setUTF8() {
        this.encodingAssigned = "UTF-8";
        this.isASCII = false;
        this.isLatin1 = false;
        this.offset = 0;
    }

    public long skip(long l) throws IOException {
        if (l < 0L) {
            return 0L;
        }
        if (this.in != null) {
            return this.in.skip(l);
        }
        long l2 = this.length - this.offset;
        if (l2 >= l) {
            this.offset += (int)l;
            return l;
        }
        this.offset = (int)((long)this.offset + l2);
        return l2 + this.raw.skip(l - l2);
    }

    private char utf8char() throws IOException {
        int n;
        int n2;
        char c;
        block12: {
            if (this.nextChar != '\u0000') {
                char c2 = this.nextChar;
                this.nextChar = '\u0000';
                return c2;
            }
            c = (char)this.buffer[this.offset];
            if ((c & 0x80) == 0) {
                ++this.offset;
                return c;
            }
            if (this.isASCII) {
                throw new CharConversionException("Not US-ASCII:  0x" + Integer.toHexString(c & 0xFF));
            }
            n2 = this.offset;
            try {
                if ((this.buffer[n2] & 0xE0) == 192) {
                    n = (this.buffer[n2++] & 0x1F) << 6;
                    c = (char)(n += this.buffer[n2++] & 0x3F);
                    n = 0;
                    break block12;
                }
                if ((this.buffer[n2] & 0xF0) == 224) {
                    n = (this.buffer[n2++] & 0xF) << 12;
                    n += (this.buffer[n2++] & 0x3F) << 6;
                    c = (char)(n += this.buffer[n2++] & 0x3F);
                    n = 0;
                    break block12;
                }
                if ((this.buffer[n2] & 0xF8) == 240) {
                    n = (this.buffer[n2++] & 7) << 18;
                    n += (this.buffer[n2++] & 0x3F) << 12;
                    n += (this.buffer[n2++] & 0x3F) << 6;
                    n += this.buffer[n2++] & 0x3F;
                    c = (char)(55296 + ((n -= 65536) >> 10));
                    n = 56320 + (n & 0x3FF);
                    break block12;
                }
                throw new CharConversionException("Illegal XML character 0x" + Integer.toHexString(this.buffer[this.offset] & 0xFF));
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                c = '\u0000';
                n = 0;
            }
        }
        if (n2 > this.length) {
            System.arraycopy(this.buffer, this.offset, this.buffer, 0, this.length - this.offset);
            this.length -= this.offset;
            this.offset = 0;
            n2 = this.raw.read(this.buffer, this.length, this.buffer.length - this.length);
            if (n2 < 0) {
                throw new CharConversionException("Partial UTF-8 char");
            }
            this.length += n2;
            return this.utf8char();
        }
        ++this.offset;
        while (this.offset < n2) {
            if ((this.buffer[this.offset] & 0xC0) != 128) {
                throw new CharConversionException("Malformed UTF-8 char");
            }
            ++this.offset;
        }
        this.nextChar = (char)n;
        return c;
    }
}

