/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.data.Preferences;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.spi.preferences.AbstractSetting;
import org.openstreetmap.josm.spi.preferences.IPreferences;
import org.openstreetmap.josm.spi.preferences.ListListSetting;
import org.openstreetmap.josm.spi.preferences.ListSetting;
import org.openstreetmap.josm.spi.preferences.MapListSetting;
import org.openstreetmap.josm.spi.preferences.Setting;
import org.openstreetmap.josm.spi.preferences.StringSetting;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Utils;

public final class PreferencesUtils {
    private static volatile StringBuilder summary = new StringBuilder();

    private PreferencesUtils() {
    }

    public static void log(String fmt, Object ... vars) {
        summary.append(String.format(fmt, vars));
    }

    public static void log(String s) {
        summary.append(s).append('\n');
    }

    public static void log(Exception e, String s) {
        summary.append(s).append(' ').append(Logging.getErrorMessage(e)).append('\n');
    }

    public static String getLog() {
        return summary.toString();
    }

    public static void resetLog() {
        summary = new StringBuilder();
    }

    public static void replacePreferences(Preferences fragment, Preferences mainpref) {
        for (Map.Entry<String, Setting<?>> entry : fragment.settingsMap.entrySet()) {
            mainpref.putSetting(entry.getKey(), entry.getValue());
        }
    }

    public static void appendPreferences(Preferences fragment, Preferences mainpref) {
        for (Map.Entry<String, Setting<?>> entry : fragment.settingsMap.entrySet()) {
            String key = entry.getKey();
            if (entry.getValue() instanceof StringSetting) {
                mainpref.putSetting(key, entry.getValue());
                continue;
            }
            if (entry.getValue() instanceof ListSetting) {
                ListSetting lSetting = (ListSetting)entry.getValue();
                List<String> newItems = PreferencesUtils.getList(mainpref, key, true);
                if (newItems == null) continue;
                for (String item : (List)lSetting.getValue()) {
                    if (newItems.contains(item)) continue;
                    newItems.add(item);
                }
                mainpref.putList(key, newItems);
                continue;
            }
            if (entry.getValue() instanceof ListListSetting) {
                ListListSetting llSetting = (ListListSetting)entry.getValue();
                List<List<String>> newLists = PreferencesUtils.getListOfLists(mainpref, key, true);
                if (newLists == null) continue;
                for (List list : (List)llSetting.getValue()) {
                    if (newLists.contains(list)) continue;
                    newLists.add(list);
                }
                mainpref.putListOfLists(key, newLists);
                continue;
            }
            if (!(entry.getValue() instanceof MapListSetting)) continue;
            MapListSetting mlSetting = (MapListSetting)entry.getValue();
            List<Map<String, String>> newMaps = PreferencesUtils.getListOfStructs(mainpref, key, true);
            if (newMaps == null) continue;
            for (Map map : (List)mlSetting.getValue()) {
                if (newMaps.contains(map)) continue;
                newMaps.add(map);
            }
            mainpref.putListOfMaps(entry.getKey(), newMaps);
        }
    }

    public static void deletePreferenceValues(Preferences fragment, Preferences mainpref) {
        for (Map.Entry<String, Setting<?>> entry : fragment.settingsMap.entrySet()) {
            String key = entry.getKey();
            if (entry.getValue() instanceof StringSetting) {
                StringSetting sSetting = (StringSetting)entry.getValue();
                if (!sSetting.equals(mainpref.settingsMap.get(key))) continue;
                mainpref.put(key, null);
                continue;
            }
            if (entry.getValue() instanceof ListSetting) {
                ListSetting lSetting = (ListSetting)entry.getValue();
                List<String> newItems = PreferencesUtils.getList(mainpref, key, true);
                if (newItems == null) continue;
                for (String item : (List)lSetting.getValue()) {
                    PreferencesUtils.log("Deleting preferences: from list %s: %s\n", key, item);
                    newItems.remove(item);
                }
                mainpref.putList(entry.getKey(), newItems);
                continue;
            }
            if (entry.getValue() instanceof ListListSetting) {
                ListListSetting llSetting = (ListListSetting)entry.getValue();
                List<List<String>> newLists = PreferencesUtils.getListOfLists(mainpref, key, true);
                if (newLists == null) continue;
                Iterator<List<String>> listIterator = newLists.iterator();
                while (listIterator.hasNext()) {
                    Collection list = listIterator.next();
                    for (Collection removeList : (List)llSetting.getValue()) {
                        if (!list.containsAll(removeList)) continue;
                        PreferencesUtils.log("Deleting preferences: list from lists %s: %s\n", key, list);
                        listIterator.remove();
                    }
                }
                mainpref.putListOfLists(key, newLists);
                continue;
            }
            if (!(entry.getValue() instanceof MapListSetting)) continue;
            MapListSetting mlSetting = (MapListSetting)entry.getValue();
            List<Map<String, String>> newMaps = PreferencesUtils.getListOfStructs(mainpref, key, true);
            if (newMaps == null) continue;
            Iterator<Map<String, String>> mapIterator = newMaps.iterator();
            while (mapIterator.hasNext()) {
                Map<String, String> map = mapIterator.next();
                for (Map removeMap : (List)mlSetting.getValue()) {
                    if (!map.entrySet().containsAll(removeMap.entrySet())) continue;
                    PreferencesUtils.log("Deleting preferences: deleting map from maps %s: %s\n", key, map);
                    mapIterator.remove();
                }
            }
            mainpref.putListOfMaps(entry.getKey(), newMaps);
        }
    }

    public static void deletePreferenceKeyByPattern(String pattern, Preferences pref) {
        Map<String, Setting<?>> allSettings = pref.getAllSettings();
        for (Map.Entry<String, Setting<?>> entry : allSettings.entrySet()) {
            String key = entry.getKey();
            if (!key.matches(pattern)) continue;
            PreferencesUtils.log("Deleting preferences: deleting key from preferences: " + key);
            pref.putSetting(key, null);
        }
    }

    public static void deletePreferenceKey(String key, Preferences pref) {
        Map<String, Setting<?>> allSettings = pref.getAllSettings();
        if (allSettings.containsKey(key)) {
            PreferencesUtils.log("Deleting preferences: deleting key from preferences: " + key);
            pref.putSetting(key, null);
        }
    }

    private static List<String> getList(Preferences mainpref, String key, boolean warnUnknownDefault) {
        ListSetting existing = Utils.cast(mainpref.settingsMap.get(key), ListSetting.class);
        ListSetting defaults = Utils.cast(mainpref.defaultsMap.get(key), ListSetting.class);
        if (existing == null && defaults == null) {
            if (warnUnknownDefault) {
                PreferencesUtils.defaultUnknownWarning(key);
            }
            return null;
        }
        if (existing != null) {
            return new ArrayList<String>((Collection)existing.getValue());
        }
        return defaults.getValue() == null ? null : new ArrayList((Collection)defaults.getValue());
    }

    private static List<List<String>> getListOfLists(Preferences mainpref, String key, boolean warnUnknownDefault) {
        ListListSetting existing = Utils.cast(mainpref.settingsMap.get(key), ListListSetting.class);
        ListListSetting defaults = Utils.cast(mainpref.defaultsMap.get(key), ListListSetting.class);
        if (existing == null && defaults == null) {
            if (warnUnknownDefault) {
                PreferencesUtils.defaultUnknownWarning(key);
            }
            return null;
        }
        if (existing != null) {
            return new ArrayList<List<String>>((Collection)existing.getValue());
        }
        return defaults.getValue() == null ? null : new ArrayList((Collection)defaults.getValue());
    }

    private static List<Map<String, String>> getListOfStructs(Preferences mainpref, String key, boolean warnUnknownDefault) {
        MapListSetting existing = Utils.cast(mainpref.settingsMap.get(key), MapListSetting.class);
        MapListSetting defaults = Utils.cast(mainpref.settingsMap.get(key), MapListSetting.class);
        if (existing == null && defaults == null) {
            if (warnUnknownDefault) {
                PreferencesUtils.defaultUnknownWarning(key);
            }
            return null;
        }
        if (existing != null) {
            return new ArrayList<Map<String, String>>((Collection)existing.getValue());
        }
        return defaults.getValue() == null ? null : new ArrayList((Collection)defaults.getValue());
    }

    private static void defaultUnknownWarning(String key) {
        PreferencesUtils.log("Warning: Unknown default value of %s , skipped\n", key);
        JOptionPane.showMessageDialog(MainApplication.getMainFrame(), I18n.tr("<html>Settings file asks to append preferences to <b>{0}</b>,<br/> but its default value is unknown at this moment.<br/> Please activate corresponding function manually and retry importing.", key), I18n.tr("Warning", new Object[0]), 2);
    }

    public static void showPrefs(Preferences tmpPref) {
        Logging.info("properties: " + tmpPref.settingsMap);
    }

    public static void modifyPreferencesByScript(ScriptEngine engine, Preferences tmpPref, String js) throws ScriptException {
        PreferencesUtils.loadPrefsToJS(engine, tmpPref, "API.pref", true);
        engine.eval(js);
        PreferencesUtils.readPrefsFromJS(engine, tmpPref, "API.pref");
    }

    public static void readPrefsFromJS(ScriptEngine engine, Preferences tmpPref, String varInJS) throws ScriptException {
        String finish = "stringMap = new java.util.TreeMap ;listMap =  new java.util.TreeMap ;listlistMap = new java.util.TreeMap ;listmapMap =  new java.util.TreeMap ;for (key in " + varInJS + ") {  val = " + varInJS + "[key];  type = typeof val == 'string' ? 'string' : val.type;  if (type == 'string') {    stringMap.put(key, val);  } else if (type == 'list') {    l = new java.util.ArrayList;    for (i=0; i<val.length; i++) {      l.add(java.lang.String.valueOf(val[i]));    }    listMap.put(key, l);  } else if (type == 'listlist') {    l = new java.util.ArrayList;    for (i=0; i<val.length; i++) {      list=val[i];      jlist=new java.util.ArrayList;      for (j=0; j<list.length; j++) {         jlist.add(java.lang.String.valueOf(list[j]));      }      l.add(jlist);    }    listlistMap.put(key, l);  } else if (type == 'listmap') {    l = new java.util.ArrayList;    for (i=0; i<val.length; i++) {      map=val[i];      jmap=new java.util.TreeMap;      for (var key2 in map) {         jmap.put(key2,java.lang.String.valueOf(map[key2]));      }      l.add(jmap);    }    listmapMap.put(key, l);  }  else {   " + PreferencesUtils.class.getName() + ".log('Unknown type:'+val.type+ '- use list, listlist or listmap'); }  }";
        engine.eval(finish);
        Map stringMap = (Map)engine.get("stringMap");
        Map listMap = (Map)engine.get("listMap");
        Map listlistMap = (Map)engine.get("listlistMap");
        Map listmapMap = (Map)engine.get("listmapMap");
        tmpPref.settingsMap.clear();
        HashMap<String, AbstractSetting> tmp = new HashMap<String, AbstractSetting>();
        for (Map.Entry e : stringMap.entrySet()) {
            tmp.put((String)e.getKey(), new StringSetting((String)e.getValue()));
        }
        for (Map.Entry e : listMap.entrySet()) {
            tmp.put((String)e.getKey(), new ListSetting((List)e.getValue()));
        }
        for (Map.Entry e : listlistMap.entrySet()) {
            List value = (List)e.getValue();
            tmp.put((String)e.getKey(), new ListListSetting(value));
        }
        for (Map.Entry e : listmapMap.entrySet()) {
            tmp.put((String)e.getKey(), new MapListSetting((List)e.getValue()));
        }
        for (Map.Entry e : tmp.entrySet()) {
            if (((Setting)e.getValue()).equals(tmpPref.defaultsMap.get(e.getKey()))) continue;
            tmpPref.settingsMap.put((String)e.getKey(), (Setting)e.getValue());
        }
    }

    public static void loadPrefsToJS(ScriptEngine engine, Preferences tmpPref, String whereToPutInJS, boolean includeDefaults) throws ScriptException {
        Setting<?> setting;
        TreeMap<String, String> stringMap = new TreeMap<String, String>();
        TreeMap<String, List> listMap = new TreeMap<String, List>();
        TreeMap<String, List> listlistMap = new TreeMap<String, List>();
        TreeMap<String, List> listmapMap = new TreeMap<String, List>();
        if (includeDefaults) {
            for (Map.Entry<String, Setting<?>> e2 : tmpPref.defaultsMap.entrySet()) {
                setting = e2.getValue();
                if (setting instanceof StringSetting) {
                    stringMap.put(e2.getKey(), (String)((StringSetting)setting).getValue());
                    continue;
                }
                if (setting instanceof ListSetting) {
                    listMap.put(e2.getKey(), (List)((ListSetting)setting).getValue());
                    continue;
                }
                if (setting instanceof ListListSetting) {
                    listlistMap.put(e2.getKey(), (List)((ListListSetting)setting).getValue());
                    continue;
                }
                if (!(setting instanceof MapListSetting)) continue;
                listmapMap.put(e2.getKey(), (List)((MapListSetting)setting).getValue());
            }
        }
        tmpPref.settingsMap.entrySet().removeIf(e -> ((Setting)e.getValue()).getValue() == null);
        for (Map.Entry<String, Setting<?>> e2 : tmpPref.settingsMap.entrySet()) {
            setting = e2.getValue();
            if (setting instanceof StringSetting) {
                stringMap.put(e2.getKey(), (String)((StringSetting)setting).getValue());
                continue;
            }
            if (setting instanceof ListSetting) {
                listMap.put(e2.getKey(), (List)((ListSetting)setting).getValue());
                continue;
            }
            if (setting instanceof ListListSetting) {
                listlistMap.put(e2.getKey(), (List)((ListListSetting)setting).getValue());
                continue;
            }
            if (!(setting instanceof MapListSetting)) continue;
            listmapMap.put(e2.getKey(), (List)((MapListSetting)setting).getValue());
        }
        engine.put("stringMap", stringMap);
        engine.put("listMap", listMap);
        engine.put("listlistMap", listlistMap);
        engine.put("listmapMap", listmapMap);
        String init = "function getJSList( javaList ) { var jsList; var i;  if (javaList == null) return null;jsList = [];  for (i = 0; i < javaList.size(); i++) {    jsList.push(String(list.get(i)));  }return jsList;}function getJSMap( javaMap ) { var jsMap; var it; var e;  if (javaMap == null) return null; jsMap = {}; for (it = javaMap.entrySet().iterator(); it.hasNext();) {    e = it.next();    jsMap[ String(e.getKey()) ] = String(e.getValue());   }  return jsMap;}for (it = stringMap.entrySet().iterator(); it.hasNext();) {  e = it.next();" + whereToPutInJS + "[String(e.getKey())] = String(e.getValue());}\nfor (it = listMap.entrySet().iterator(); it.hasNext();) {  e = it.next();  list = e.getValue();  jslist = getJSList(list);  jslist.type = 'list';" + whereToPutInJS + "[String(e.getKey())] = jslist;}\nfor (it = listlistMap.entrySet().iterator(); it.hasNext(); ) {  e = it.next();  listlist = e.getValue();  jslistlist = [];  for (it2 = listlist.iterator(); it2.hasNext(); ) {    list = it2.next();     jslistlist.push(getJSList(list));    }  jslistlist.type = 'listlist';" + whereToPutInJS + "[String(e.getKey())] = jslistlist;}\nfor (it = listmapMap.entrySet().iterator(); it.hasNext();) {  e = it.next();  listmap = e.getValue();  jslistmap = [];  for (it2 = listmap.iterator(); it2.hasNext();) {    map = it2.next();    jslistmap.push(getJSMap(map));    }  jslistmap.type = 'listmap';" + whereToPutInJS + "[String(e.getKey())] = jslistmap;}\n";
        engine.eval(init);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean getBoolean(IPreferences prefs, String key, String specName, boolean def) {
        IPreferences iPreferences = prefs;
        synchronized (iPreferences) {
            boolean generic = prefs.getBoolean(key, def);
            String skey = key + '.' + specName;
            String svalue = prefs.get(skey, null);
            if (svalue != null) {
                return Boolean.parseBoolean(svalue);
            }
            return generic;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getInteger(IPreferences prefs, String key, String specName, int def) {
        IPreferences iPreferences = prefs;
        synchronized (iPreferences) {
            String v = prefs.get(key + '.' + specName);
            if (v.isEmpty()) {
                v = prefs.get(key, Integer.toString(def));
            }
            if (v.isEmpty()) {
                return def;
            }
            try {
                return Integer.parseInt(v);
            }
            catch (NumberFormatException e) {
                Logging.trace(e);
                return def;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeFromList(IPreferences prefs, String key, String value) {
        IPreferences iPreferences = prefs;
        synchronized (iPreferences) {
            ArrayList<String> a = new ArrayList<String>(prefs.getList(key, Collections.emptyList()));
            a.remove(value);
            prefs.putList(key, a);
        }
    }

    public static boolean putListBounded(IPreferences prefs, String key, int maxsize, List<String> val) {
        ArrayList<String> newCollection = new ArrayList<String>(Math.min(maxsize, val.size()));
        for (String i : val) {
            if (newCollection.size() >= maxsize) break;
            newCollection.add(i);
        }
        return prefs.putList(key, newCollection);
    }
}

