/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.smali.dexlib2.writer.builder;

import com.android.tools.smali.dexlib2.iface.reference.FieldReference;
import com.android.tools.smali.dexlib2.immutable.reference.ImmutableFieldReference;
import com.android.tools.smali.dexlib2.writer.FieldSection;
import com.android.tools.smali.dexlib2.writer.builder.BaseBuilderPool;
import com.android.tools.smali.dexlib2.writer.builder.BuilderField;
import com.android.tools.smali.dexlib2.writer.builder.BuilderFieldReference;
import com.android.tools.smali.dexlib2.writer.builder.BuilderMapEntryCollection;
import com.android.tools.smali.dexlib2.writer.builder.BuilderStringPool;
import com.android.tools.smali.dexlib2.writer.builder.BuilderStringReference;
import com.android.tools.smali.dexlib2.writer.builder.BuilderTypePool;
import com.android.tools.smali.dexlib2.writer.builder.BuilderTypeReference;
import com.android.tools.smali.dexlib2.writer.builder.DexBuilder;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;

public class BuilderFieldPool
extends BaseBuilderPool
implements FieldSection<BuilderStringReference, BuilderTypeReference, BuilderFieldReference, BuilderField> {
    private final ConcurrentMap<FieldReference, BuilderFieldReference> internedItems = Maps.newConcurrentMap();

    public BuilderFieldPool(DexBuilder dexBuilder) {
        super(dexBuilder);
    }

    BuilderFieldReference internField(String definingClass, String name, String type) {
        ImmutableFieldReference fieldReference = new ImmutableFieldReference(definingClass, name, type);
        return this.internField(fieldReference);
    }

    public BuilderFieldReference internField(FieldReference fieldReference) {
        BuilderFieldReference ret = (BuilderFieldReference)this.internedItems.get(fieldReference);
        if (ret != null) {
            return ret;
        }
        BuilderFieldReference dexPoolFieldReference = new BuilderFieldReference(((BuilderTypePool)this.dexBuilder.typeSection).internType(fieldReference.getDefiningClass()), ((BuilderStringPool)this.dexBuilder.stringSection).internString(fieldReference.getName()), ((BuilderTypePool)this.dexBuilder.typeSection).internType(fieldReference.getType()));
        ret = this.internedItems.putIfAbsent(dexPoolFieldReference, dexPoolFieldReference);
        return ret == null ? dexPoolFieldReference : ret;
    }

    @Override
    public BuilderTypeReference getDefiningClass(BuilderFieldReference key) {
        return key.definingClass;
    }

    @Override
    public BuilderTypeReference getFieldType(BuilderFieldReference key) {
        return key.fieldType;
    }

    @Override
    public BuilderStringReference getName(BuilderFieldReference key) {
        return key.name;
    }

    @Override
    public int getFieldIndex(BuilderField builderField) {
        return builderField.fieldReference.getIndex();
    }

    @Override
    public int getItemIndex(BuilderFieldReference key) {
        return key.index;
    }

    @Override
    public Collection<? extends Map.Entry<? extends BuilderFieldReference, Integer>> getItems() {
        return new BuilderMapEntryCollection<BuilderFieldReference>(this.internedItems.values()){

            @Override
            protected int getValue(BuilderFieldReference key) {
                return key.index;
            }

            @Override
            protected int setValue(BuilderFieldReference key, int value) {
                int prev = key.index;
                key.index = value;
                return prev;
            }
        };
    }

    @Override
    public int getItemCount() {
        return this.internedItems.size();
    }
}

