;;; idlw-rinfo.el --- Routine Information for IDLWAVE
;; Copyright (c) 1999 Carsten Dominik
;; Copyright (c) 1999, 2000, 2001, 2002, 2003 Free Software Foundation

;; Author: J.D. Smith <jdsmith@as.arizona.edu>
;; Version: 5.1
;; Keywords: languages

;;; Commentary:

;; The constants which contain information about IDLs builtin
;; functions, procedures, system variables and class tags.  This
;; information is extracted automatically from the IDL documentation
;; and by talking to IDL.
;;
;; Created by get_html_rinfo on Thu Apr 24 08:56:16 2003
;; IDL version: 5.6
;; Number of files scanned:  2111
;; Number of routines found: 1460
;; Number of keywords found: 6586
;;
;; New versions of IDLWAVE, documentation, and more information
;; available from:
;;                 http://idlwave.org
;; 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;; Code:
(defconst idlwave-system-routines
  '(
    ("ANNOTATE" pro nil (system) "%s" ("A8.html" ("COLOR_INDICES" . 756628) ("DRAWABLE" . 756633) ("LOAD_FILE" . 756636) ("TEK_COLORS" . 756639) ("WINDOW" . 756642)))
    ("ARROW" pro nil (system) "%s, X0, Y0, X1, Y1" ("A11.html" ("COLOR" . 756673) ("DATA" . 756664) ("HSIZE" . 756670) ("HTHICK" . 756676) ("NORMALIZED" . 756667) ("SOLID" . 756679) ("THICK" . 756682)))
    ("AXIS" pro nil (system) "%s [, X [, Y [, Z]]]" ("A16.html" ("SAVE" . 986499) ("XAXIS" . 983775) ("XLOG" . 983760) ("YAXIS" . 983765) ("YLOG" . 983752) ("YNOZERO" . 158293) ("ZAXIS" . 983724) ("ZLOG")) ("graphkeyw2.html" ("CHARSIZE" . 266973) ("CHARTHICK" . 331668) ("COLOR" . 315952) ("DATA" . 315961) ("DEVICE" . 315977) ("FONT" . 331795) ("NODATA" . 316018) ("NOERASE" . 316024) ("NORMAL" . 315963) ("SUBTITLE" . 316057) ("T3D" . 315956) ("TICKLEN" . 332207) ("XCHARSIZE" . 331699) ("XGRIDSTYLE" . 332009) ("XMARGIN" . 332038) ("XMINOR" . 332061) ("XRANGE" . 332090) ("XSTYLE" . 332116) ("XTHICK" . 332298) ("XTICK_GET" . 332321) ("XTICKFORMAT" . 332347) ("XTICKINTERVAL" . 332463) ("XTICKLAYOUT" . 332488) ("XTICKLEN" . 332513) ("XTICKNAME" . 332536) ("XTICKS" . 332559) ("XTICKUNITS" . 332586) ("XTICKV" . 332628) ("XTITLE" . 316100) ("YCHARSIZE" . 331699) ("YGRIDSTYLE" . 332009) ("YMARGIN" . 332038) ("YMINOR" . 332061) ("YRANGE" . 332090) ("YSTYLE" . 332116) ("YTHICK" . 332298) ("YTICK_GET" . 332321) ("YTICKFORMAT" . 332347) ("YTICKINTERVAL" . 332463) ("YTICKLAYOUT" . 332488) ("YTICKLEN" . 332513) ("YTICKNAME" . 332536) ("YTICKS" . 332559) ("YTICKUNITS" . 332586) ("YTICKV" . 332628) ("YTITLE" . 316100) ("ZCHARSIZE" . 331699) ("ZGRIDSTYLE" . 332009) ("ZMARGIN" . 332038) ("ZMINOR" . 332061) ("ZRANGE" . 332090) ("ZSTYLE" . 332116) ("ZTHICK" . 332298) ("ZTICK_GET" . 332321) ("ZTICKFORMAT" . 332347) ("ZTICKINTERVAL" . 332463) ("ZTICKLAYOUT" . 332488) ("ZTICKLEN" . 332513) ("ZTICKNAME" . 332536) ("ZTICKS" . 332559) ("ZTICKUNITS" . 332586) ("ZTICKV" . 332628) ("ZTITLE" . 316100) ("ZVALUE" . 316102)))
    ("BAR_PLOT" pro nil (system) "%s, Values" ("B.html" ("BACKGROUND" . 756719) ("BARNAMES" . 756722) ("BAROFFSET" . 756725) ("BARSPACE" . 756728) ("BARWIDTH" . 756731) ("BASELINES" . 756734) ("BASERANGE" . 756737) ("COLORS" . 756740) ("OUTLINE" . 756743) ("OVERPLOT" . 756746) ("ROTATE" . 756749) ("TITLE" . 756752) ("XTITLE" . 756755) ("YTITLE" . 756758)))
    ("BLAS_AXPY" pro nil (system) "%s, Y, A, X [, D1, Loc1 [, D2, Range]]" ("B13.html"))
    ("BOX_CURSOR" pro nil (system) "%s, [ X0, Y0, NX, NY]" ("B15.html" ("FIXED_SIZE" . 756816) ("INIT" . 756813) ("MESSAGE" . 756819)))
    ("BREAK" pro nil (system) "%s" ("B16.html"))
    ("BREAKPOINT" pro nil (system) "%s [, File], Index" ("B17.html" ("AFTER" . 113854) ("CLEAR" . 675862) ("CONDITION" . 113859) ("DISABLE" . 907385) ("ENABLE" . 984755) ("ON_RECOMPILE" . 984772) ("ONCE" . 990987) ("SET" . 675866)))
    ("BYTEORDER" pro nil (system) "%s, Variable1, ..., Variablen" ("B21.html" ("DTOVAX" . 906658) ("DTOXDR" . 906876) ("FTOVAX" . 675911) ("FTOXDR" . 906884) ("HTONL" . 906665) ("HTONS" . 675913) ("L64SWAP" . 965960) ("LSWAP" . 675915) ("NTOHL" . 675917) ("NTOHS" . 675919) ("SSWAP" . 675921) ("SWAP_IF_BIG_ENDIAN" . 906711) ("SWAP_IF_LITTLE_ENDIAN" . 906720) ("VAXTOD" . 675923) ("VAXTOF" . 906693) ("XDRTOD" . 906679) ("XDRTOF" . 675925)) ("tpoolkeyw2.html" ("TPOOL_MAX_ELTS" . 333417) ("TPOOL_MIN_ELTS" . 333286) ("TPOOL_NOTHREAD" . 333289)))
    ("CALDAT" pro nil (system) "%s, Julian, Month [, Day [, Year [, Hour [, Minute [, Second]]]]]" ("C2.html"))
    ("CALENDAR" pro nil (system) "%s [[, Month] , Year]" ("C3.html"))
    ("CALL_METHOD" pro nil (system) "%s, Name, ObjRef, [, P1, ..., Pn]" ("C6.html"))
    ("CALL_PROCEDURE" pro nil (system) "%s, Name [, P1, ..., Pn]" ("C7.html"))
    ("CATCH" pro nil (system) "%s, [Variable]" ("C9.html" ("CANCEL" . 716974)))
    ("CD" pro nil (system) "%s [, Directory]" ("C10.html" ("CURRENT" . 676059)))
    ("CDF_ATTDELETE" pro nil (system) "%s, Id, Attribute [, EntryNum]" ("CDF-routines8.html" ("ZVARIABLE" . 1002456)))
    ("CDF_ATTGET" pro nil (system) "%s, Id, Attribute, EntryNum, Value" ("CDF-routines10.html" ("CDF_TYPE" . 1003937) ("ZVARIABLE" . 997078)))
    ("CDF_ATTINQ" pro nil (system) "%s, Id, Attribute, Name, Scope, MaxEntry [, MaxZEntry]" ("CDF-routines11.html"))
    ("CDF_ATTPUT" pro nil (system) "%s, Id, Attribute, EntryNum, Value" ("CDF-routines13.html" ("ZVARIABLE" . 997143)))
    ("CDF_ATTRENAME" pro nil (system) "%s, Id, OldAttr, NewName" ("CDF-routines14.html"))
    ("CDF_CLOSE" pro nil (system) "%s, Id" ("CDF-routines15.html"))
    ("CDF_COMPRESSION" pro nil (system) "%s, Id" ("CDF-routines16.html" ("GET_COMPRESSION" . 1019949) ("GET_GZIP_LEVEL" . 1019952) ("GET_VAR_COMPRESSION" . 1019955) ("GET_VAR_GZIP_LEVEL" . 1019957) ("SET_COMPRESSION" . 1019965) ("SET_GZIP_LEVEL" . 1020981) ("SET_VAR_COMPRESSION" . 1019968) ("SET_VAR_GZIP_LEVEL" . 1026491) ("VARIABLE" . 1026493) ("ZVARIABLE" . 1019982)))
    ("CDF_CONTROL" pro nil (system) "%s, Id" ("CDF-routines17.html" ("ATTRIBUTE" . 997198) ("GET_ATTR_INFO" . 997201) ("GET_CACHESIZE" . 997209) ("GET_COPYRIGHT" . 997212) ("GET_FILENAME" . 997215) ("GET_FORMAT" . 997218) ("GET_NEGTOPOSFP0_MODE" . 997226) ("GET_NUMATTRS" . 997229) ("GET_READONLY_MODE" . 997239) ("GET_RVAR_CACHESIZE" . 997236) ("GET_VAR_INFO" . 997242) ("GET_ZMODE" . 997259) ("GET_ZVAR_CACHESIZE" . 997266) ("SET_CACHESIZE" . 997269) ("SET_EXTENDRECS" . 997272) ("SET_INITIALRECS" . 997275) ("SET_NEGTOPOSFP0_MODE" . 997278) ("SET_PADVALUE" . 997281) ("SET_READONLY_MODE" . 997284) ("SET_RVAR_CACHESIZE" . 997287) ("SET_RVARS_CACHESIZE" . 997290) ("SET_ZMODE" . 997293) ("SET_ZVAR_CACHESIZE" . 997296) ("SET_ZVARS_CACHESIZE" . 997298) ("VARIABLE" . 997301) ("ZVARIABLE" . 997307)))
    ("CDF_DELETE" pro nil (system) "%s, Id" ("CDF-routines19.html"))
    ("CDF_DOC" pro nil (system) "%s, Id, Version, Release, Copyright" ("CDF-routines20.html" ("INCREMENT" . 997427)))
    ("CDF_EPOCH" pro nil (system) "%s, Epoch, Year [, Month, Day, Hour, Minute, Second, Milli]" ("CDF-routines22.html" ("BREAKDOWN_EPOCH" . 997509) ("COMPUTE_EPOCH" . 997512)))
    ("CDF_LIB_INFO" pro nil (system) "%s" ("CDF-routines26.html" ("COPYRIGHT" . 997623) ("INCREMENT" . 997626) ("RELEASE" . 997629) ("SUBINCREMENT" . 997632) ("VERSION" . 997635)))
    ("CDF_VARDELETE" pro nil (system) "%s, Id, Variable" ("CDF-routines30.html" ("ZVARIABLE" . 997776)))
    ("CDF_VARGET" pro nil (system) "%s, Id, Variable, Value" ("CDF-routines31.html" ("COUNT" . 997847) ("INTERVAL" . 997850) ("OFFSET" . 997853) ("REC_COUNT" . 997856) ("REC_INTERVAL" . 997859) ("REC_START" . 997862) ("STRING" . 997865) ("ZVARIABLE" . 997868)))
    ("CDF_VARGET1" pro nil (system) "%s, Id, Variable, Value" ("CDF-routines32.html" ("OFFSET" . 997909) ("REC_START" . 997912) ("STRING" . 997915) ("ZVARIABLE" . 997918)))
    ("CDF_VARPUT" pro nil (system) "%s, Id, Variable, Value" ("CDF-routines35.html" ("COUNT" . 998005) ("INTERVAL" . 998008) ("OFFSET" . 998011) ("REC_INTERVAL" . 998014) ("REC_START" . 998017) ("ZVARIABLE" . 998020)))
    ("CDF_VARRENAME" pro nil (system) "%s, Id, OldVariable, NewName" ("CDF-routines36.html" ("ZVARIABLE" . 998048)))
    ("CHOLDC" pro nil (system) "%s, A, P" ("C16.html" ("DOUBLE" . 50352)))
    ("CIR_3PNT" pro nil (system) "%s, X, Y, R, X0, Y0" ("C19.html"))
    ("CLOSE" pro nil (system) "%s[, Unit1, ..., Unitn]" ("C20.html" ("ALL" . 676122) ("EXIT_STATUS" . 1017312) ("FILE" . 1017618) ("FORCE" . 1017321)))
    ("COLOR_CONVERT" pro nil (system) "%s, I0, I1, I2, O0, O1, O2" ("C23.html" ("HLS_RGB" . 861671) ("HSV_RGB" . 861673) ("RGB_HLS" . 861669) ("RGB_HSV" . 676146)))
    ("CONSTRAINED_MIN" pro nil (system) "%s, X, Xbnd, Gbnd, Nobj, Gcomp, Inform" ("C36.html" ("EPSTOP" . 908210) ("ESPTOP") ("LIMSER" . 927415) ("MAXIMIZE" . 927406) ("NSTOP" . 975889) ("REPORT" . 942066) ("TITLE" . 927408)))
    ("CONTOUR" pro nil (system) "%s, Z [, X, Y]" ("C38.html" ("C_ANNOTATION" . 1023103) ("C_CHARSIZE" . 676279) ("C_CHARTHICK" . 905138) ("C_COLORS" . 676281) ("C_LABELS" . 676286) ("C_LINESTYLE" . 676292) ("C_ORIENTATION" . 676298) ("C_SPACING" . 676300) ("C_THICK" . 676302) ("CELL_FILL" . 892176) ("CLOSED" . 676304) ("DOWNHILL" . 676306) ("FILL" . 676308) ("FOLLOW" . 676311) ("IRREGULAR" . 879096) ("ISOTROPIC" . 676316) ("LEVELS" . 927695) ("MAX_VALUE" . 676323) ("MIN_VALUE" . 47033) ("NLEVELS" . 676325) ("OVERPLOT" . 861732) ("PATH_DATA_COORDS" . 879089) ("PATH_DOUBLE" . 1015046) ("PATH_FILENAME" . 676329) ("PATH_INFO" . 746342) ("PATH_XY" . 746343) ("TRIANGULATION" . 746344) ("XLOG" . 158329) ("YLOG" . 158344) ("ZAXIS" . 676344) ("ZLOG")) ("graphkeyw2.html" ("BACKGROUND" . 328424) ("CHARSIZE" . 266973) ("CHARTHICK" . 331668) ("CLIP" . 315949) ("COLOR" . 315952) ("DATA" . 315961) ("DEVICE" . 315977) ("FONT" . 331795) ("NOCLIP" . 323508) ("NODATA" . 316018) ("NOERASE" . 316024) ("NORMAL" . 315963) ("POSITION" . 316026) ("SUBTITLE" . 316057) ("T3D" . 315956) ("TICKLEN" . 332207) ("TITLE" . 332238) ("XCHARSIZE" . 331699) ("XGRIDSTYLE" . 332009) ("XMARGIN" . 332038) ("XMINOR" . 332061) ("XRANGE" . 332090) ("XSTYLE" . 332116) ("XTHICK" . 332298) ("XTICK_GET" . 332321) ("XTICKFORMAT" . 332347) ("XTICKINTERVAL" . 332463) ("XTICKLAYOUT" . 332488) ("XTICKLEN" . 332513) ("XTICKNAME" . 332536) ("XTICKS" . 332559) ("XTICKUNITS" . 332586) ("XTICKV" . 332628) ("XTITLE" . 316100) ("YCHARSIZE" . 331699) ("YGRIDSTYLE" . 332009) ("YMARGIN" . 332038) ("YMINOR" . 332061) ("YRANGE" . 332090) ("YSTYLE" . 332116) ("YTHICK" . 332298) ("YTICK_GET" . 332321) ("YTICKFORMAT" . 332347) ("YTICKINTERVAL" . 332463) ("YTICKLAYOUT" . 332488) ("YTICKLEN" . 332513) ("YTICKNAME" . 332536) ("YTICKS" . 332559) ("YTICKUNITS" . 332586) ("YTICKV" . 332628) ("YTITLE" . 316100) ("ZCHARSIZE" . 331699) ("ZGRIDSTYLE" . 332009) ("ZMARGIN" . 332038) ("ZMINOR" . 332061) ("ZRANGE" . 332090) ("ZSTYLE" . 332116) ("ZTHICK" . 332298) ("ZTICK_GET" . 332321) ("ZTICKFORMAT" . 332347) ("ZTICKINTERVAL" . 332463) ("ZTICKLAYOUT" . 332488) ("ZTICKLEN" . 332513) ("ZTICKNAME" . 332536) ("ZTICKS" . 332559) ("ZTICKUNITS" . 332586) ("ZTICKV" . 332628) ("ZTITLE" . 316100) ("ZVALUE" . 316102)))
    ("COPY_LUN" pro nil (system) "%s, FromUnit, ToUnit [, Num]" ("C42.html" ("EOF" . 1090923) ("LINES" . 1090926) ("TRANSFER_COUNT" . 1090928)))
    ("CPU" pro nil (system) "%s" ("C46.html" ("TPOOL_MAX_ELTS" . 1032362) ("TPOOL_MIN_ELTS" . 1032364) ("TPOOL_NTHREADS" . 1032366) ("VECTOR_ENABLE" . 1032368)))
    ("CREATE_VIEW" pro nil (system) "%s" ("C49.html" ("AX" . 756876) ("AY" . 756879) ("AZ" . 756882) ("PERSP" . 756885) ("RADIANS" . 756888) ("WINX" . 756891) ("WINY" . 756894) ("XMAX" . 756897) ("XMIN" . 756900) ("YMAX" . 756903) ("YMIN" . 756906) ("ZFAC" . 756909) ("ZMAX" . 756912) ("ZMIN" . 756915) ("ZOOM" . 756918)))
    ("CURSOR" pro nil (system) "%s, X, Y [, Wait]" ("C54.html" ("CHANGE" . 676458) ("DATA" . 676460) ("DEVICE" . 676464) ("DOWN" . 676462) ("NORMAL" . 676466) ("NOWAIT" . 676468) ("UP" . 676470) ("WAIT" . 676472)))
    ("CW_ANIMATE_GETP" pro nil (system) "%s, Widget, Pixmaps" ("C59.html" ("KILL_ANYWAY" . 853956)))
    ("CW_ANIMATE_LOAD" pro nil (system) "%s, Widget" ("C60.html" ("CYCLE" . 853989) ("FRAME" . 853992) ("IMAGE" . 853995) ("ORDER" . 853998) ("WINDOW" . 854001) ("XOFFSET" . 854006) ("YOFFSET" . 854009)))
    ("CW_ANIMATE_RUN" pro nil (system) "%s, Widget [, Rate{0 to 100}]" ("C61.html" ("NFRAMES" . 854045) ("STOP" . 854048)))
    ("CW_LIGHT_EDITOR_GET" pro nil (system) "%s, WidgetID" ("C72.html" ("DIRECTION_DISABLED" . 1001479) ("DRAG_" . 1001481) ("DRAG_EVENTS") ("HIDE_DISABLED" . 1001485) ("LIGHT" . 1001487) ("LOCATION_DISABLED" . 1001489) ("TYPE_DISABLED" . 1001491) ("XRANGE" . 1001493) ("XSIZE" . 1001495) ("YRANGE" . 1001497) ("YSIZE" . 1001499) ("ZRANGE" . 1001501)))
    ("CW_LIGHT_EDITOR_SET" pro nil (system) "%s, WidgetID" ("C73.html" ("DIRECTION_DISABLED" . 1001515) ("DRAG_" . 1001517) ("DRAG_EVENTS") ("HIDE_DISABLED" . 1001521) ("LIGHT" . 1001523) ("LOCATION_DISABLED" . 1001525) ("TYPE_DISABLED" . 1001527) ("XRANGE" . 1001529) ("XSIZE" . 1001531) ("YRANGE" . 1001533) ("YSIZE" . 1001535) ("ZRANGE" . 1001537)))
    ("CW_PALETTE_EDITOR_GET" pro nil (system) "%s, WidgetID" ("C76.html" ("ALPHA" . 1001551) ("HISTOGRAM" . 1001677)))
    ("CW_PALETTE_EDITOR_SET" pro nil (system) "%s, WidgetID" ("C77.html" ("ALPHA" . 1001567) ("HISTOGRAM" . 1001569)))
    ("DEFINE_KEY" pro nil (system) "%s, Key [, Value]" ("D5.html" ("BACK_CHARACTER" . 1001954) ("BACK_WORD" . 1001956) ("CONTROL" . 1001958) ("DELETE_CHARACTER" . 1001962) ("DELETE_CURRENT" . 1001964) ("DELETE_EOL" . 1001966) ("DELETE_LINE" . 1001968) ("DELETE_WORD" . 1001970) ("END_OF_FILE" . 1001974) ("END_OF_LINE" . 1001972) ("ENTER_LINE" . 1001976) ("ESCAPE" . 1001978) ("FORWARD_CHARACTER" . 1001984) ("FORWARD_WORD" . 1001986) ("INSERT_OVERSTRIKE_TOGGLE" . 1001988) ("MATCH_PREVIOUS" . 676503) ("NEXT_LINE" . 1002066) ("NOECHO" . 676505) ("PREVIOUS_LINE" . 1002076) ("RECALL" . 1002078) ("REDRAW" . 1002103) ("START_OF_LINE" . 1002105) ("TERMINATE" . 676507)))
    ("DEFINE_MSGBLK" pro nil (system) "%s, BlockName, ErrorNames, ErrorFormats" ("D6.html" ("IGNORE_DUPLICATE" . 991846) ("PREFIX" . 991848)))
    ("DEFINE_MSGBLK_FROM_FILE" pro nil (system) "%s, Filename" ("D7.html" ("BLOCK" . 991885) ("IGNORE_DUPLICATE" . 991890) ("PREFIX" . 991892) ("VERBOSE" . 991894)))
    ("DEFSYSV" pro nil (system) "%s, Name, Value [, Read_Only]" ("D9.html" ("EXISTS" . 676585)))
    ("DELVAR" pro nil (system) "%s, V1, ..., Vn" ("D10.html"))
    ("DEVICE" pro nil (system) "%s" ("D14.html" ("GET_PAGESIZE") ("S") ("SE") ("SW") ("W")) ("devices4.html" ("AVANTGARDE" . 482989) ("AVERAGE_LINES" . 144491) ("BINARY" . 144309) ("BITS_PER_PIXEL" . 144308) ("BKMAN" . 143940) ("BOLD" . 144497) ("BOOK" . 144499) ("BYPASS_TRANSLATION" . 144256) ("CLOSE" . 144712) ("CLOSE_DOCUMENT" . 451438) ("CLOSE_FILE" . 144158) ("COLOR" . 144479) ("COLORS" . 144313) ("COPY" . 143954) ("COURIER" . 144503) ("CURSOR_CROSSHAIR" . 144502) ("CURSOR_IMAGE" . 143934) ("CURSOR_MASK" . 144824) ("CURSOR_ORIGINAL" . 144828) ("CURSOR_STANDARD" . 144830) ("CURSOR_XY" . 143722) ("DECOMPOSED" . 144834) ("DEMI" . 143930) ("DIRECT_COLOR" . 145006) ("EJECT" . 143752) ("ENCAPSULATED" . 143751) ("ENCODING" . 144315) ("FILENAME" . 143748) ("FLOYD" . 144833) ("FONT_INDEX" . 143943) ("FONT_SIZE" . 144522) ("GET_CURRENT_FONT" . 144518) ("GET_DECOMPOSED" . 554681) ("GET_FONTNAMES" . 554610) ("GET_FONTNUM" . 144326) ("GET_GRAPHICS_FUNCTION" . 145007) ("GET_SCREEN_SIZE" . 149759) ("GET_VISUAL_DEPTH" . 452299) ("GET_VISUAL_NAME" . 551382) ("GET_WINDOW_POSITION" . 143947) ("GET_WRITE_MASK" . 143949) ("GIN_CHARS" . 143951) ("GLYPH_CACHE" . 499334) ("HELVETICA" . 144524) ("INCHES" . 144166) ("INDEX_COLOR" . 451483) ("ISOLATIN1" . 144322) ("ITALIC" . 143723) ("LANDSCAPE" . 606950) ("LANGUAGE_LEVEL" . 144167) ("LIGHT" . 618160) ("MEDIUM" . 144529) ("NARROW" . 417784) ("NCAR" . 144157) ("OBLIQUE" . 562813) ("OPTIMIZE" . 144405) ("ORDERED" . 143941) ("OUTPUT" . 144538) ("PALATINO" . 144366) ("PIXELS" . 144468) ("PLOT_TO" . 485584) ("PLOTTER_ON_OFF" . 144371) ("POLYFILL" . 144368) ("PORTRAIT" . 144170) ("PRE_DEPTH" . 144169) ("PRE_XSIZE" . 601831) ("PRE_YSIZE" . 597448) ("PREVIEW" . 601886) ("PRINT_FILE" . 556886) ("PSEUDO_COLOR" . 144688) ("RESET_STRING" . 144455) ("RESOLUTION" . 144473) ("RETAIN" . 144472) ("SCALE_FACTOR" . 144547) ("SCHOOLBOOK" . 144551) ("SET_CHARACTER_SIZE" . 486143) ("SET_COLORMAP" . 161043) ("SET_COLORS" . 486222) ("SET_FONT" . 499045) ("SET_GRAPHICS_FUNCTION" . 499029) ("SET_RESOLUTION" . 144941) ("SET_STRING" . 144466) ("SET_TRANSLATION" . 150093) ("SET_WRITE_MASK" . 143957) ("STATIC_COLOR" . 144842) ("STATIC_GRAY" . 144844) ("SYMBOL" . 144554) ("TEK4014" . 144553) ("TEK4100" . 144475) ("TEXT" . 144841) ("THRESHOLD" . 144376) ("TIMES" . 144557) ("TRANSLATION" . 144556) ("TRUE_COLOR" . 144849) ("TT_FONT" . 542703) ("TTY" . 144477) ("VT240" . 144174) ("VT241" . 144174) ("VT340" . 144532) ("VT341" . 144532) ("WINDOW_STATE" . 144546) ("XOFFSET" . 143719) ("XON_XOFF" . 144379) ("XSIZE" . 144540) ("YOFFSET" . 144175) ("YSIZE" . 144568) ("Z_BUFFERING" . 144512) ("ZAPFCHANCERY" . 144513) ("ZAPFDINGBATS" . 144515)))
    ("DFPMIN" pro nil (system) "%s, X, Gtol, Fmin, Func, Dfunc" ("D15.html" ("DOUBLE" . 50547) ("EPS" . 50550) ("ITER" . 50553) ("ITMAX" . 50556) ("STEPMAX" . 50559) ("TOLX" . 50562)))
    ("DISSOLVE" pro nil (system) "%s, Image" ("D26.html" ("DELAY" . 757174) ("ORDER" . 757177) ("SIZ" . 757180) ("X0" . 757184) ("Y0" . 757184)))
    ("DLM_LOAD" pro nil (system) "%s, DLMNameStr1 [, DLMNameStr2,..., DLMNameStrn]" ("D28.html"))
    ("DLM_REGISTER" pro nil (system) "%s, DLMDefFilePath1 [, DLMDefFilePath2, ..., DLMDefFilePathn]" ("D29.html"))
    ("DOC_LIBRARY" pro nil (system) "%s [, Name]" ("D30.html" ("DIRECTORY" . 1003439) ("MULTI" . 1003447) ("PRINT" . 42998)))
    ("DRAW_ROI" pro nil (system) "%s, oROI" ("D32.html" ("LINE_FILL" . 986287) ("SPACING" . 986289)) ("graphkeyw2.html" ("CLIP" . 315949) ("COLOR" . 315952) ("DATA" . 315961) ("DEVICE" . 315977) ("LINESTYLE" . 331728) ("NOCLIP" . 323508) ("NORMAL" . 315963) ("ORIENTATION" . 315964) ("PSYM" . 316038) ("SYMSIZE" . 316061) ("T3D" . 315956) ("THICK" . 316006)))
    ("EFONT" pro nil (system) "%s [, Init_Font]" ("E.html" ("BLOCK" . 921048) ("GROUP" . 988298)))
    ("EMPTY" pro nil (system) "%s" ("E5.html"))
    ("ENABLE_SYSRTN" pro nil (system) "%s [, Routines]" ("E6.html" ("DISABLE" . 986251) ("EXCLUSIVE" . 986253) ("FUNCTIONS" . 986256)))
    ("ERASE" pro nil (system) "%s [, Background_Color]" ("E8.html" ("CHANNEL" . 676712) ("COLOR" . 676714)))
    ("ERRPLOT" pro nil (system) "%s, [ X, ] Low, High" ("E13.html" ("WIDTH" . 757212)))
    ("EXIT" pro nil (system) "%s" ("E15.html" ("NO_CONFIRM" . 126978) ("STATUS" . 126983)))
    ("EXPAND" pro nil (system) "%s, A, Nx, Ny, Result" ("E17.html" ("FILLVAL" . 986579) ("MAXVAL" . 757253)))
    ("FILE_CHMOD" pro nil (system) "%s, File [, Mode]" ("F5.html" ("A_EXECUTE" . 882191) ("A_READ" . 882193) ("A_WRITE" . 882195) ("G_EXECUTE" . 882197) ("G_READ" . 882199) ("G_WRITE" . 882201) ("NOEXPAND_PATH" . 882956) ("O_EXECUTE" . 882203) ("O_READ" . 882205) ("O_WRITE" . 882207) ("SETGID" . 900602) ("SETUID" . 900604) ("STICKY_BIT" . 900606) ("U_EXECUTE" . 882209) ("U_READ" . 882211) ("U_WRITE" . 882213)))
    ("FILE_COPY" pro nil (system) "%s, SourcePath, DestPath" ("F6.html" ("ALLOW_SAME" . 906390) ("COPY_NAMED_PIPE" . 906392) ("COPY_SYMLINK" . 906394) ("FORCE" . 906396) ("NOEXPAND_PATH" . 906399) ("OVERWRITE" . 906404) ("RECURSIVE" . 906406) ("REQUIRE_DIRECTORY" . 906412) ("VERBOSE" . 906414)))
    ("FILE_DELETE" pro nil (system) "%s, File1 [,... Filen]" ("F7.html" ("ALLOW_NONEXISTENT" . 882944) ("NOEXPAND_PATH" . 906788) ("QUIET" . 906823) ("RECURSIVE" . 892369) ("VERBOSE" . 906799)))
    ("FILE_LINK" pro nil (system) "%s, SourcePath, DestPath" ("F11.html" ("ALLOW_SAME" . 906533) ("HARDLINK" . 906535) ("NOEXPAND_PATH" . 906537) ("VERBOSE" . 906542)))
    ("FILE_MKDIR" pro nil (system) "%s, File1 [,... FileN]" ("F12.html" ("NOEXPAND_PATH" . 882989)))
    ("FILE_MOVE" pro nil (system) "%s, SourcePath, DestPath" ("F13.html" ("ALLOW_SAME" . 906590) ("NOEXPAND_PATH" . 906592) ("OVERWRITE" . 906597) ("REQUIRE_DIRECTORY" . 906599) ("VERBOSE" . 906601)))
    ("FLICK" pro nil (system) "%s, A, B [, Rate]" ("F24.html"))
    ("FLOW3" pro nil (system) "%s, Vx, Vy, Vz" ("F27.html" ("ARROWSIZE" . 757304) ("BLOB" . 757307) ("LEN" . 757310) ("NSTEPS" . 757313) ("NVECS" . 757316) ("SX" . 757321) ("SY" . 757321) ("SZ" . 757321)))
    ("FLUSH" pro nil (system) "%s, Unit1, ..., Unitn" ("F29.html"))
    ("FREE_LUN" pro nil (system) "%s [, Unit1, ..., Unitn]" ("F33.html" ("EXIT_STATUS" . 875865) ("FORCE" . 875880)))
    ("FUNCT" pro nil (system) "%s, X, A, F [, Pder]" ("F36.html"))
    ("GAMMA_CT" pro nil (system) "%s, Gamma" ("G2.html" ("CURRENT" . 759174) ("INTENSITY" . 759177)))
    ("GET_LUN" pro nil (system) "%s, Unit" ("G10.html"))
    ("GRID_INPUT" pro nil (system) "%s, X, Y, F, X1, Y1, F1" ("G14.html" ("DEGREES" . 877045) ("DUPLICATES" . 877047) ("EPSILON" . 877086) ("EXCLUDE" . 877088) ("POLAR" . 877090) ("SPHERE" . 877092)))
    ("H5_CLOSE" pro nil (system) "%s" ("HDF5-routines9.html"))
    ("H5_OPEN" pro nil (system) "%s" ("HDF5-routines11.html"))
    ("H5A_CLOSE" pro nil (system) "%s, Attribute_id" ("HDF5-routines13.html"))
    ("H5D_CLOSE" pro nil (system) "%s, Dataset_id" ("HDF5-routines21.html"))
    ("H5F_CLOSE" pro nil (system) "%s, File_id" ("HDF5-routines27.html"))
    ("H5G_CLOSE" pro nil (system) "%s, Group_id" ("HDF5-routines30.html"))
    ("H5S_CLOSE" pro nil (system) "%s, Dataspace_id" ("HDF5-routines40.html"))
    ("H5S_OFFSET_SIMPLE" pro nil (system) "%s, Dataspace_id, Offset" ("HDF5-routines54.html"))
    ("H5S_SELECT_ALL" pro nil (system) "%s, Dataspace_id" ("HDF5-routines55.html"))
    ("H5S_SELECT_ELEMENTS" pro nil (system) "%s, Dataspace_id, Coordinates" ("HDF5-routines56.html" ("RESET" . 1149840)))
    ("H5S_SELECT_HYPERSLAB" pro nil (system) "%s, Dataspace_id, Start, Count" ("HDF5-routines57.html" ("BLOCK" . 1149884) ("RESET" . 1149886) ("STRIDE" . 1149888)))
    ("H5S_SELECT_NONE" pro nil (system) "%s, Dataspace_id" ("HDF5-routines58.html"))
    ("H5T_CLOSE" pro nil (system) "%s, Datatype_id" ("HDF5-routines60.html"))
    ("H_EQ_CT" pro nil (system) "%s [, Image]" ("H.html"))
    ("H_EQ_INT" pro nil (system) "%s [, Image]" ("H2.html"))
    ("HDF_AN_END" pro nil (system) "%s, an_id" ("HDF-routines12.html"))
    ("HDF_AN_ENDACCESS" pro nil (system) "%s, ann_id" ("HDF-routines13.html"))
    ("HDF_CLOSE" pro nil (system) "%s, FileHandle" ("HDF-routines24.html"))
    ("HDF_DELDD" pro nil (system) "%s, FileHandle, Tag, Ref" ("HDF-routines25.html"))
    ("HDF_DF24_ADDIMAGE" pro nil (system) "%s, Filename, Image" ("HDF-routines26.html" ("FORCE_BASELINE" . 1025840) ("JPEG" . 1025843) ("QUALITY" . 1025857) ("RLE" . 1025860)))
    ("HDF_DF24_GETIMAGE" pro nil (system) "%s, Filename, Image" ("HDF-routines27.html" ("LINE" . 996986) ("PIXEL" . 996989) ("PLANE" . 996992)))
    ("HDF_DF24_GETINFO" pro nil (system) "%s, Filename, Width, Height, Interlace" ("HDF-routines28.html"))
    ("HDF_DF24_READREF" pro nil (system) "%s, Filename, Refno" ("HDF-routines31.html"))
    ("HDF_DF24_RESTART" pro nil (system) "%s" ("HDF-routines32.html"))
    ("HDF_DFAN_ADDFDS" pro nil (system) "%s, Filename, Description" ("HDF-routines33.html"))
    ("HDF_DFAN_ADDFID" pro nil (system) "%s, Filename, Label" ("HDF-routines34.html"))
    ("HDF_DFAN_GETDESC" pro nil (system) "%s, Filename, Tag, Ref, Description" ("HDF-routines35.html" ("STRING" . 997205)))
    ("HDF_DFAN_GETFDS" pro nil (system) "%s, Filename, Description" ("HDF-routines36.html" ("FIRST" . 997250) ("STRING" . 997253)))
    ("HDF_DFAN_GETFID" pro nil (system) "%s, Filename, Label" ("HDF-routines37.html" ("FIRST" . 997305)))
    ("HDF_DFAN_GETLABEL" pro nil (system) "%s, Filename, Tag, Ref, Label" ("HDF-routines38.html"))
    ("HDF_DFAN_PUTDESC" pro nil (system) "%s, Filename, Tag, Ref, Description" ("HDF-routines41.html"))
    ("HDF_DFAN_PUTLABEL" pro nil (system) "%s, Filename, Tag, Ref, Label" ("HDF-routines42.html"))
    ("HDF_DFP_ADDPAL" pro nil (system) "%s, Filename, Palette" ("HDF-routines43.html"))
    ("HDF_DFP_GETPAL" pro nil (system) "%s, Filename, Palette" ("HDF-routines44.html"))
    ("HDF_DFP_PUTPAL" pro nil (system) "%s, Filename, Palette" ("HDF-routines47.html" ("DELETE" . 1016492) ("OVERWRITE" . 997545)))
    ("HDF_DFP_READREF" pro nil (system) "%s, Filename, Refno" ("HDF-routines48.html"))
    ("HDF_DFP_RESTART" pro nil (system) "%s" ("HDF-routines49.html"))
    ("HDF_DFP_WRITEREF" pro nil (system) "%s, Filename, Refno" ("HDF-routines50.html"))
    ("HDF_DFR8_ADDIMAGE" pro nil (system) "%s, Filename, Image" ("HDF-routines51.html" ("FORCE_BASELINE" . 997601) ("IMCOMP" . 1025489) ("JPEG" . 1025496) ("PALETTE" . 997604) ("QUALITY" . 997612) ("RLE" . 1025510)))
    ("HDF_DFR8_GETIMAGE" pro nil (system) "%s, Filename, Image [, Palette]" ("HDF-routines52.html"))
    ("HDF_DFR8_GETINFO" pro nil (system) "%s, Filename, Width, Height, Has_Palette" ("HDF-routines53.html"))
    ("HDF_DFR8_PUTIMAGE" pro nil (system) "%s, Filename, Image" ("HDF-routines56.html" ("FORCE_BASELINE" . 1025782) ("IMCOMP" . 1025788) ("JPEG" . 1025785) ("PALETTE" . 1025813) ("QUALITY" . 1025821) ("RLE" . 1025802)))
    ("HDF_DFR8_READREF" pro nil (system) "%s, Filename, Refno" ("HDF-routines57.html"))
    ("HDF_DFR8_RESTART" pro nil (system) "%s" ("HDF-routines58.html"))
    ("HDF_DFR8_SETPALETTE" pro nil (system) "%s, Palette" ("HDF-routines59.html"))
    ("HDF_DUPDD" pro nil (system) "%s, FileHandle, NewTag, NewRef, OldTag, OldRef" ("HDF-routines60.html"))
    ("HDF_GR_END" pro nil (system) "%s, gr_id" ("HDF-routines64.html"))
    ("HDF_GR_ENDACCESS" pro nil (system) "%s, ri_id" ("HDF-routines65.html"))
    ("HDF_LIB_INFO" pro nil (system) "%s, [FileHandle]" ("HDF-routines91.html" ("MAJOR" . 1031740) ("MINOR" . 1031746) ("RELEASE" . 1031752) ("VERSION" . 1031973)))
    ("HDF_SD_ADDDATA" pro nil (system) "%s, SDS_ID, Data" ("HDF-routines96.html" ("COUNT" . 1053602) ("NOREVERSE" . 1053605) ("START" . 1053608) ("STRIDE" . 1053611)))
    ("HDF_SD_ATTRINFO" pro nil (system) "%s, S_ID, Attr_Index" ("HDF-routines98.html" ("COUNT" . 1053698) ("DATA" . 1053701) ("HDF_TYPE" . 1053704) ("NAME" . 1053707) ("TYPE" . 1053710)))
    ("HDF_SD_ATTRSET" pro nil (system) "%s, S_ID, Attr_Name, Values [, Count]" ("HDF-routines99.html" ("BYTE" . 1053770) ("DFNT_CHAR8" . 1053773) ("DFNT_FLOAT32" . 1053776) ("DFNT_FLOAT64" . 1053779) ("DFNT_INT16" . 1053785) ("DFNT_INT32" . 1053788) ("DFNT_INT8" . 1053782) ("DFNT_UINT16" . 1053794) ("DFNT_UINT32" . 1053797) ("DFNT_UINT8" . 1053791) ("DOUBLE" . 1053800) ("FLOAT" . 1053803) ("INT" . 1053806) ("LONG" . 1053809) ("SHORT" . 1053812) ("STRING" . 1053815)))
    ("HDF_SD_DIMGET" pro nil (system) "%s, Dim_ID" ("HDF-routines101.html" ("COMPATIBILITY" . 1053946) ("COUNT" . 1053944) ("FORMAT" . 1053948) ("LABEL" . 1053950) ("NAME" . 1053952) ("NATTR" . 1053954) ("SCALE" . 1053956) ("TYPE" . 1053958) ("UNIT" . 1053960)))
    ("HDF_SD_DIMSET" pro nil (system) "%s, Dim_ID" ("HDF-routines103.html" ("BW_INCOMP" . 1054021) ("FORMAT" . 1054025) ("LABEL" . 1054027) ("NAME" . 1054029) ("SCALE" . 1054031) ("UNIT" . 1054033)))
    ("HDF_SD_END" pro nil (system) "%s, SD_ID" ("HDF-routines104.html"))
    ("HDF_SD_ENDACCESS" pro nil (system) "%s, SD_ID" ("HDF-routines105.html"))
    ("HDF_SD_FILEINFO" pro nil (system) "%s, SD_ID, Datasets, Attributes" ("HDF-routines106.html"))
    ("HDF_SD_GETDATA" pro nil (system) "%s, SDS_ID, Data" ("HDF-routines107.html" ("COUNT" . 1054195) ("NOREVERSE" . 1054198) ("START" . 1054201) ("STRIDE" . 1054204)))
    ("HDF_SD_GETINFO" pro nil (system) "%s, SDS_ID" ("HDF-routines108.html" ("CALDATA" . 1054234) ("COORDSYS" . 1054238) ("DIMS" . 1054241) ("FILL" . 1054244) ("FORMAT" . 1054247) ("HDF_TYPE" . 1054250) ("LABEL" . 1054253) ("NAME" . 1054256) ("NATTS" . 1054259) ("NDIMS" . 1054262) ("NOREVERSE" . 1054265) ("RANGE" . 1054268) ("TYPE" . 1054271) ("UNIT" . 1054274)))
    ("HDF_SD_SETCOMPRESS" pro nil (system) "%s, SDS_ID, comptype" ("HDF-routines114.html" ("EFFORT" . 1074118)))
    ("HDF_SD_SETEXTFILE" pro nil (system) "%s, SDS_ID, Filename" ("HDF-routines115.html" ("OFFSET" . 1054488)))
    ("HDF_SD_SETINFO" pro nil (system) "%s, SDS_ID" ("HDF-routines116.html" ("CALDATA" . 1054554) ("COORDSYS" . 1054551) ("FILL" . 1054536) ("FORMAT" . 1054539) ("LABEL" . 1054542) ("RANGE" . 1054545) ("UNIT" . 1054548)))
    ("HDF_UNPACKDATA" pro nil (system) "%s, packeddata, data1 [, data2 [, data3 [, data4 [, data5 [, data6 [, data7 [, data8]]]]]]]" ("HDF-routines118.html" ("HDF_ORDER" . 1042997) ("HDF_TYPE" . 1043000) ("NREC" . 1043003)))
    ("HDF_VD_ATTRINFO" pro nil (system) "%s, VData, FieldID, AttrID" ("HDF-routines121.html" ("COUNT" . 1109959) ("DATA" . 1109961) ("HDF_TYPE" . 1109963) ("NAME" . 1109965) ("TYPE" . 1109967)))
    ("HDF_VD_ATTRSET" pro nil (system) "%s, VData, FieldID, Attr_Name, Values [, Count]" ("HDF-routines122.html" ("BYTE" . 1110005) ("DFNT_CHAR8" . 1110007) ("DFNT_FLOAT32" . 1110009) ("DFNT_FLOAT64" . 1110011) ("DFNT_INT16" . 1110015) ("DFNT_INT32" . 1110017) ("DFNT_INT8" . 1110013) ("DFNT_UCHAR8" . 1110019) ("DFNT_UINT16" . 1110023) ("DFNT_UINT32" . 1110025) ("DFNT_UINT8" . 1110021) ("DOUBLE" . 1110027) ("FLOAT" . 1110029) ("INT" . 1110031) ("LONG" . 1110033) ("SHORT" . 1110035) ("STRING" . 1110037) ("UINT" . 1110039) ("ULONG" . 1110041)))
    ("HDF_VD_DETACH" pro nil (system) "%s, VData" ("HDF-routines123.html"))
    ("HDF_VD_FDEFINE" pro nil (system) "%s, VData, Fieldname" ("HDF-routines124.html" ("BYTE" . 999536) ("DLONG") ("DOUBLE" . 999539) ("DULONG") ("FLOAT" . 999542) ("INT" . 999545) ("LONG" . 999548) ("ORDER" . 999551) ("UINT") ("ULONG")))
    ("HDF_VD_GET" pro nil (system) "%s, VData" ("HDF-routines127.html" ("CLASS" . 999597) ("COUNT" . 999600) ("FIELDS" . 999603) ("INTERLACE" . 999606) ("NAME" . 999609) ("NFIELDS" . 999612) ("REF" . 999615) ("SIZE" . 999618) ("TAG" . 999621)))
    ("HDF_VD_GETINFO" pro nil (system) "%s, VData, Index" ("HDF-routines129.html" ("NAME" . 999666) ("ORDER" . 999669) ("SIZE" . 999672) ("TYPE" . 999675)))
    ("HDF_VD_INSERT" pro nil (system) "%s, VGroup, VData(or Vgroup)" ("HDF-routines130.html" ("POSITION")))
    ("HDF_VD_SEEK" pro nil (system) "%s, VData, Record" ("HDF-routines137.html"))
    ("HDF_VD_SETINFO" pro nil (system) "%s, VData" ("HDF-routines138.html" ("CLASS" . 999834) ("FULL_INTERLACE" . 999837) ("NAME" . 999840) ("NO_INTERLACE" . 999843)))
    ("HDF_VD_WRITE" pro nil (system) "%s, VData, Fields, Data" ("HDF-routines139.html" ("FULL_INTERLACE" . 999876) ("NO_INTERLACE" . 999879) ("NRECORDS" . 999882)))
    ("HDF_VG_ADDTR" pro nil (system) "%s, VGroup, Tag, Ref" ("HDF-routines140.html"))
    ("HDF_VG_DETACH" pro nil (system) "%s, VGroup" ("HDF-routines142.html"))
    ("HDF_VG_GETINFO" pro nil (system) "%s, VGroup" ("HDF-routines144.html" ("CLASS" . 1000002) ("NAME" . 1000005) ("NENTRIES" . 1000008) ("REF" . 1109613) ("TAG" . 1109591)))
    ("HDF_VG_GETTR" pro nil (system) "%s, VGroup, Index, Tags, Refs" ("HDF-routines146.html"))
    ("HDF_VG_GETTRS" pro nil (system) "%s, VGroup, Tags, Refs" ("HDF-routines147.html" ("MAXSIZE" . 1000064)))
    ("HDF_VG_INSERT" pro nil (system) "%s, VGroup, VData(or Vgroup)" ("HDF-routines149.html" ("POSITION")))
    ("HDF_VG_SETINFO" pro nil (system) "%s, VGroup" ("HDF-routines154.html" ("CLASS") ("CLASSNAME" . 1000182) ("NAME" . 1000184)))
    ("HEAP_FREE" pro nil (system) "%s, Var" ("H7.html" ("OBJ" . 877472) ("PTR" . 877474) ("VERBOSE" . 877477)))
    ("HEAP_GC" pro nil (system) "%s" ("H8.html" ("OBJ" . 871683) ("PTR" . 832713) ("VERBOSE" . 832717)))
    ("HELP" pro nil (system) "%s, Expression1, ..., Expressionn" ("H9.html" ("ALL_KEYS" . 677134) ("BREAKPOINTS" . 677136) ("BRIEF" . 870534) ("CALLS" . 870532) ("DEVICE" . 677140) ("DLM" . 677142) ("FILES" . 843801) ("FULL" . 832176) ("FUNCTIONS" . 870207) ("HEAP_VARIABLES" . 870621) ("KEYS" . 677144) ("LAST_MESSAGE" . 843755) ("MEMORY" . 677146) ("MESSAGES" . 677148) ("NAMES" . 843817) ("OBJECTS" . 832180) ("OUTPUT" . 832171) ("PROCEDURES" . 677150) ("RECALL_COMMANDS" . 870903) ("ROUTINES" . 869603) ("SHARED_MEMORY" . 880202) ("SOURCE_FILES" . 168290) ("STRUCTURES" . 677154) ("SYSTEM_VARIABLES" . 677156) ("TRACEBACK" . 677158)))
    ("HLS" pro nil (system) "%s, Litlo, Lithi, Satlo, Sathi, Hue, Loops [, Colr]" ("H14.html"))
    ("HSV" pro nil (system) "%s, Vlo, Vhi, Satlo, Sathi, Hue, Loops [, Colr]" ("H17.html"))
    ("IMAGE_CONT" pro nil (system) "%s, A" ("I5.html" ("ASPECT" . 757356) ("INTERP" . 757359) ("WINDOW_SCALE" . 757362)))
    ("IMAGE_STATISTICS" pro nil (system) "%s, Data" ("I6.html" ("COUNT" . 873572) ("DATA_SUM" . 873574) ("LABELED" . 873576) ("LUT" . 873582) ("MASK" . 873584) ("MAXIMUM" . 873586) ("MEAN" . 873588) ("MINIMUM" . 873590) ("STDDEV" . 873592) ("SUM_OF_SQUARES" . 873594) ("VARIANCE" . 873596) ("VECTOR" . 873598) ("WEIGHT_SUM" . 873600) ("WEIGHTED" . 873603)))
    ("INTERVAL_VOLUME" pro nil (system) "%s, Data, Value0, Value1, Outverts, Outconn" ("I15.html" ("AUXDATA_IN" . 877934) ("AUXDATA_OUT" . 877937) ("GEOM_XYZ" . 877940) ("TETRAHEDRA" . 877943)))
    ("ISOCONTOUR" pro nil (system) "%s, Values, Outverts, Outconn" ("I19.html" ("AUXDATA_IN" . 873707) ("AUXDATA_OUT" . 873709) ("C_LABEL_INTERVAL" . 873711) ("C_LABEL_SHOW" . 880877) ("C_VALUE" . 880888) ("DOUBLE" . 875352) ("FILL" . 873713) ("GEOMX" . 873715) ("GEOMY" . 873717) ("GEOMZ" . 873719) ("LEVEL_VALUES" . 873723) ("N_LEVELS" . 873725) ("OUT_LABEL_OFFSETS" . 873727) ("OUT_LABEL_POLYLINES" . 880899) ("OUT_LABEL_STRINGS" . 880914) ("OUTCONN_INDICES" . 880934) ("POLYGONS" . 873730)))
    ("ISOSURFACE" pro nil (system) "%s, Data, Value, Outverts, Outconn" ("I20.html" ("AUXDATA_IN" . 873750) ("AUXDATA_OUT" . 873753) ("GEOM_XYZ" . 873756) ("TETRAHEDRA" . 873759)))
    ("JOURNAL" pro nil (system) "%s [, Arg]" ("J.html"))
    ("LA_CHOLDC" pro nil (system) "%s, Array" ("L2.html" ("DOUBLE" . 969070) ("STATUS" . 969072) ("UPPER" . 969077)))
    ("LA_LUDC" pro nil (system) "%s, Array, Index" ("L16.html" ("DOUBLE" . 970769) ("STATUS" . 970771)))
    ("LA_SVD" pro nil (system) "%s, Array, W, U, V" ("L19.html" ("DIVIDE_CONQUER" . 971149) ("DOUBLE" . 971151) ("STATUS" . 971153)))
    ("LA_TRIDC" pro nil (system) "%s, AL, A, AU, U2, Index" ("L20.html" ("DOUBLE" . 971273) ("STATUS" . 971275)))
    ("LA_TRIQL" pro nil (system) "%s, D, E [, A]" ("L22.html" ("DOUBLE" . 971540) ("STATUS" . 971542)))
    ("LA_TRIRED" pro nil (system) "%s, Array, D, E" ("L23.html" ("DOUBLE" . 971643) ("UPPER" . 971645)))
    ("LINKIMAGE" pro nil (system) "%s, Name, Image [, Type [, Entry]]" ("L34.html" ("DEVICE" . 855619) ("FUNCT" . 855622) ("KEYWORDS" . 855625) ("MAX_ARGS" . 855628) ("MIN_ARGS" . 855632)))
    ("LIVE_CONTOUR" pro nil (system) "%s [, Z1,..., Z25]" ("L36.html" ("BUFFER" . 857168) ("DIMENSIONS" . 857171) ("DOUBLE" . 940837) ("DRAW_DIMENSIONS" . 857174) ("ERROR" . 857178) ("INDEXED_COLOR" . 857181) ("INSTANCING" . 894851) ("LOCATION" . 908845) ("MANAGE_STYLE" . 857188) ("NAME" . 865395) ("NO_DRAW" . 866862) ("NO_SELECTION") ("NO_STATUS" . 857191) ("NO_TOOLBAR" . 857194) ("PARENT_BASE" . 857197) ("PREFERENCE_FILE") ("REFERENCE_OUT" . 861053) ("RENDERER" . 894899) ("REPLACE" . 894896) ("STYLE" . 867081) ("TEMPLATE_FILE") ("TITLE" . 868778) ("TLB_LOCATION" . 857216) ("WINDOW_IN" . 857219) ("X_TICKNAME" . 857231) ("XINDEPENDENT" . 857222) ("XLOG" . 938766) ("XRANGE" . 857228) ("Y_TICKNAME" . 938703) ("YINDEPENDENT" . 938677) ("YLOG" . 938768) ("YRANGE" . 938693)))
    ("LIVE_CONTROL" pro nil (system) "%s, [Name]" ("L37.html" ("DIALOG" . 857262) ("ERROR" . 866193) ("NO_DRAW" . 869227) ("PROPERTIES" . 866196) ("SELECT") ("UPDATE_DATA" . 857271) ("WINDOW_IN" . 857273)))
    ("LIVE_DESTROY" pro nil (system) "%s, [Name1,..., Name25]" ("L38.html" ("ENVIRONMENT" . 857310) ("ERROR" . 918748) ("NO_DRAW" . 869386) ("PURGE" . 918750) ("WINDOW_IN" . 857313)))
    ("LIVE_EXPORT" pro nil (system) "%s" ("L39.html" ("APPEND" . 857333) ("COMPRESSION" . 918737) ("DIALOG" . 918736) ("DIMENSIONS" . 857336) ("ERROR" . 865774) ("FILENAME" . 865777) ("ORDER" . 857345) ("PROGRESSIVE" . 857348) ("QUALITY" . 857351) ("RESOLUTION" . 857354) ("TYPE" . 857357) ("UNITS" . 857360) ("VISUALIZATION_IN" . 857363) ("WINDOW_IN" . 857366)))
    ("LIVE_IMAGE" pro nil (system) "%s, Image" ("L40.html" ("BLUE" . 869489) ("BUFFER" . 857406) ("DIMENSIONS" . 857409) ("DRAW_DIMENSIONS" . 857412) ("ERROR" . 857416) ("GREEN" . 857419) ("INDEXED_COLOR" . 857422) ("INSTANCING" . 894938) ("LOCATION" . 894939) ("MANAGE_STYLE" . 857428) ("NAME" . 865414) ("NO_DRAW" . 869522) ("NO_SELECTION") ("NO_STATUS" . 857431) ("NO_TOOLBAR" . 857434) ("PARENT_BASE" . 857437) ("PREFERENCE_FILE") ("RED" . 857440) ("REFERENCE_OUT" . 861329) ("RENDERER" . 894987) ("REPLACE" . 894984) ("STYLE" . 868799) ("TEMPLATE_FILE") ("TITLE" . 868802) ("TLB_LOCATION" . 857455) ("WINDOW_IN" . 857458)))
    ("LIVE_INFO" pro nil (system) "%s, [Name]" ("L41.html" ("ERROR" . 857496) ("PROPERTIES" . 857499) ("WINDOW_IN" . 871830)))
    ("LIVE_LINE" pro nil (system) "%s" ("L42.html" ("ARROW_ANGLE" . 857560) ("ARROW_END" . 857563) ("ARROW_SIZE" . 857566) ("ARROW_START" . 857569) ("COLOR" . 857572) ("DIALOG" . 857608) ("DIMENSIONS" . 857611) ("ERROR" . 857614) ("HIDE" . 857617) ("LINESTYLE" . 857622) ("LOCATION" . 857631) ("NAME" . 857634) ("NO_DRAW" . 869731) ("NO_SELECTION") ("REFERENCE_OUT" . 861580) ("THICK" . 861706) ("VISUALIZATION_IN" . 857643) ("WINDOW_IN" . 857646)))
    ("LIVE_LOAD" pro nil (system) "%s" ("L43.html"))
    ("LIVE_OPLOT" pro nil (system) "%s, Yvector1 [,... , Yvector25]" ("L44.html" ("ERROR" . 857676) ("INDEPENDENT" . 857679) ("NAME" . 865429) ("NEW_AXES" . 875816) ("NO_DRAW" . 875820) ("NO_SELECTION") ("REFERENCE_OUT" . 869937) ("REPLACE" . 926011) ("SUBTYPE" . 865633) ("VISUALIZATION_IN" . 857689) ("WINDOW_IN" . 857693) ("X_TICKNAME" . 938712) ("XAXIS_IN" . 857699) ("Y_TICKNAME" . 938714) ("YAXIS_IN" . 938722)))
    ("LIVE_PLOT" pro nil (system) "%s, Yvector1 [, Yvector2,..., Yvector25]" ("L45.html" ("BUFFER" . 857740) ("DIMENSIONS" . 857743) ("DOUBLE" . 940846) ("DRAW_DIMENSIONS" . 857746) ("ERROR" . 857750) ("HISTOGRAM" . 860283) ("INDEPENDENT" . 857753) ("INDEXED_COLOR" . 857756) ("INSTANCING" . 894954) ("LINE" . 860286) ("LOCATION" . 857759) ("MANAGE_STYLE" . 857762) ("NAME" . 865443) ("NO_DRAW" . 869914) ("NO_SELECTION") ("NO_STATUS" . 869908) ("NO_TOOLBAR" . 857768) ("PARENT_BASE" . 857771) ("POLAR" . 886929) ("PREFERENCE_FILE") ("REFERENCE_OUT" . 861910) ("RENDERER" . 895003) ("REPLACE" . 895000) ("SCATTER" . 865661) ("STYLE" . 857783) ("TEMPLATE_FILE") ("TITLE" . 857786) ("TLB_LOCATION" . 857789) ("WINDOW_IN" . 857792) ("X_TICKNAME" . 938741) ("XLOG" . 938733) ("XRANGE" . 938737) ("Y_TICKNAME" . 938743) ("YLOG" . 938735) ("YRANGE" . 938739)))
    ("LIVE_PRINT" pro nil (system) "%s" ("L46.html" ("DIALOG" . 857843) ("ERROR" . 870023) ("WINDOW_IN" . 870008)))
    ("LIVE_RECT" pro nil (system) "%s" ("L47.html" ("COLOR" . 869624) ("DIALOG" . 857924) ("DIMENSIONS" . 857927) ("ERROR" . 870047) ("HIDE" . 870065) ("LINESTYLE" . 857938) ("LOCATION" . 857948) ("NAME" . 870084) ("NO_DRAW" . 870087) ("NO_SELECTION") ("REFERENCE_OUT" . 861968) ("THICK" . 867032) ("VISUALIZATION_IN" . 857960) ("WINDOW_IN" . 857963)))
    ("LIVE_SURFACE" pro nil (system) "%s, Data, Data2,..." ("L49.html" ("BUFFER" . 858545) ("DIMENSIONS" . 858548) ("DOUBLE" . 940853) ("DRAW_DIMENSIONS" . 858551) ("ERROR" . 858555) ("INDEXED_COLOR" . 858558) ("INSTANCING" . 894970) ("LOCATION" . 858561) ("MANAGE_STYLE" . 858564) ("NAME" . 865458) ("NO_DRAW" . 871145) ("NO_SELECTION") ("NO_STATUS" . 858567) ("NO_TOOLBAR" . 858570) ("PARENT_BASE" . 858573) ("PREFERENCE_FILE") ("REFERENCE_OUT" . 862043) ("RENDERER" . 895019) ("REPLACE" . 895016) ("STYLE" . 865680) ("TEMPLATE_FILE") ("TITLE" . 858588) ("TLB_LOCATION" . 858591) ("WINDOW_IN" . 858594) ("X_TICKNAME" . 938804) ("XINDEPENDENT" . 869011) ("XLOG" . 938796) ("XRANGE" . 938800) ("Y_TICKNAME" . 938806) ("YINDEPENDENT" . 938819) ("YLOG" . 938798) ("YRANGE" . 938802)))
    ("LIVE_TEXT" pro nil (system) "%s[, Text]" ("L50.html" ("ALIGNMENT" . 858647) ("COLOR" . 869666) ("DIALOG" . 858686) ("ENABLE_FORMATTING" . 871194) ("ERROR" . 858689) ("FONTNAME" . 858692) ("FONTSIZE" . 858695) ("HIDE" . 858698) ("LOCATION" . 858703) ("NAME" . 871208) ("NO_DRAW" . 871267) ("NO_SELECTION") ("REFERENCE_OUT" . 862098) ("TEXTANGLE" . 926175) ("VERTICAL_ALIGNMENT" . 936417) ("VISUALIZATION_IN" . 936415) ("WINDOW_IN" . 858718)))
    ("LOADCT" pro nil (system) "%s [, Table]" ("L56.html" ("BOTTOM" . 168327) ("FILE" . 759299) ("GET_NAMES" . 759305) ("NCOLORS" . 759308) ("SILENT" . 759311)))
    ("LUDC" pro nil (system) "%s, A, Index" ("L64.html" ("COLUMN" . 58718) ("DOUBLE" . 50959) ("INTERCHANGES" . 50962)))
    ("MAKE_DLL" pro nil (system) "%s, InputFiles [, OutputFile], ExportedRoutineNames" ("M4.html" ("CC" . 960457) ("COMPILE_DIRECTORY" . 960459) ("DLL_PATH" . 960461) ("EXPORTED_DATA" . 960463) ("EXTRA_CFLAGS" . 960465) ("EXTRA_LFLAGS" . 960467) ("INPUT_DIRECTORY" . 960469) ("LD" . 960471) ("NOCLEANUP" . 960473) ("OUTPUT_DIRECTORY" . 960502) ("REUSE_EXISTING" . 973081) ("SHOW_ALL_OUTPUT" . 960504) ("VERBOSE" . 960506)))
    ("MAP_CONTINENTS" pro nil (system) "%s" ("M6.html" ("COASTS" . 887528) ("COLOR" . 887531) ("CONTINENTS" . 957787) ("COUNTRIES" . 887534) ("FILL_CONTINENTS" . 887537) ("HIRES" . 887540) ("LIMIT" . 957885) ("MLINESTYLE" . 887544) ("MLINETHICK" . 887584) ("ORIENTATION" . 887588) ("RIVERS" . 887591) ("SPACING" . 887594) ("USA" . 887597)) ("graphkeyw2.html" ("T3D" . 315956) ("ZVALUE" . 316102)))
    ("MAP_GRID" pro nil (system) "%s" ("M7.html" ("BOX_AXES" . 919039) ("CHARSIZE" . 887636) ("CLIP_TEXT" . 919041) ("COLOR" . 887639) ("FILL_HORIZON" . 958045) ("GLINESTYLE" . 887642) ("GLINETHICK" . 887648) ("HORIZON" . 958090) ("INCREMENT" . 958092) ("LABEL" . 958064) ("LATALIGN" . 887654) ("LATDEL" . 887657) ("LATLAB" . 887660) ("LATNAMES" . 887663) ("LATS" . 887668) ("LONALIGN" . 887673) ("LONDEL" . 887676) ("LONLAB" . 887679) ("LONNAMES" . 887682) ("LONS" . 887687) ("NO_GRID" . 958111) ("ORIENTATION" . 887692)) ("graphkeyw2.html" ("T3D" . 315956) ("ZVALUE" . 316102)))
    ("MAP_PROJ_INFO" pro nil (system) "%s [, iproj]" ("M11.html" ("AZIMUTHAL" . 918995) ("CIRCLE" . 928077) ("CURRENT" . 918999) ("CYLINDRICAL" . 919001) ("LL_LIMITS" . 919003) ("NAME" . 919005) ("PROJ_NAMES" . 919007) ("UV_LIMITS" . 919011) ("UV_RANGE" . 928995)))
    ("MAP_SET" pro nil (system) "%s [, P0lat, P0lon, Rot]" ("M14.html" ("ADVANCE" . 887984) ("AITOFF" . 957265) ("ALBERS" . 887925) ("AZIMUTHAL" . 887931) ("CENTRAL_AZIMUTH" . 888123) ("CHARSIZE" . 887987) ("CLIP" . 887990) ("COLOR" . 887997) ("CON_COLOR" . 888003) ("CONIC" . 887934) ("CONTINENTS" . 888000) ("CYLINDRICAL" . 887940) ("E_CONTINENTS" . 888006) ("E_GRID" . 888009) ("E_HORIZON" . 888013) ("ELLIPSOID" . 888127) ("GLINESTYLE" . 888019) ("GLINETHICK" . 888025) ("GNOMIC" . 887943) ("GOODESHOMOLOSINE" . 918601) ("GRID" . 949681) ("HAMMER" . 887946) ("HIRES" . 888031) ("HORIZON" . 888034) ("ISOTROPIC" . 888134) ("LABEL" . 918537) ("LAMBERT" . 887950) ("LATALIGN" . 888043) ("LATDEL" . 888049) ("LATLAB" . 888046) ("LIMIT" . 888141) ("LONALIGN" . 888052) ("LONDEL" . 888055) ("LONLAB" . 888058) ("MERCATOR" . 887953) ("MILLER_CYLINDRICAL" . 887956) ("MLINESTYLE" . 888061) ("MLINETHICK" . 888101) ("MOLLWEIDE" . 887959) ("NAME" . 958229) ("NOBORDER" . 958173) ("NOERASE" . 888107) ("ORTHOGRAPHIC" . 887962) ("REVERSE" . 888110) ("ROBINSON" . 919362) ("SAT_P" . 888146) ("SATELLITE" . 887965) ("SCALE" . 958134) ("SINUSOIDAL" . 887971) ("STANDARD_PARALLELS" . 888156) ("STEREOGRAPHIC" . 887974) ("TITLE" . 958298) ("TRANSVERSE_MERCATOR" . 887977) ("USA" . 888113) ("XMARGIN" . 958356) ("YMARGIN" . 888119)) ("graphkeyw2.html" ("POSITION" . 316026) ("T3D" . 315956) ("ZVALUE" . 316102)))
    ("MESH_OBJ" pro nil (system) "%s, Type, Vertex_List, Polygon_List, Array1 [, Array2]" ("M28.html" ("CLOSED" . 888559) ("DEGREES" . 965212) ("P1" . 888562) ("P2") ("P3") ("P4") ("P5")))
    ("MESSAGE" pro nil (system) "%s, [Text]" ("M33.html" ("BLOCK" . 888669) ("CONTINUE" . 965245) ("INFORMATIONAL" . 888672) ("IOERROR" . 888676) ("LEVEL" . 965401) ("NAME" . 965353) ("NONAME" . 965554) ("NOPREFIX" . 888682) ("NOPRINT" . 888686) ("RESET" . 888689) ("TRACEBACK" . 888698)))
    ("MK_HTML_HELP" pro nil (system) "%s, Sources, Filename" ("M36.html" ("STRICT" . 888862) ("TITLE" . 888864) ("VERBOSE" . 888866)))
    ("MODIFYCT" pro nil (system) "%s, Itab, Name, R, G, B" ("M37.html" ("FILE" . 962516)))
    ("MPEG_CLOSE" pro nil (system) "%s, mpegID" ("M46.html"))
    ("MPEG_PUT" pro nil (system) "%s, mpegID" ("M48.html" ("COLOR" . 889108) ("FRAME" . 915949) ("IMAGE" . 889110) ("ORDER" . 889112) ("WINDOW" . 889114)))
    ("MPEG_SAVE" pro nil (system) "%s, mpegID" ("M49.html" ("FILENAME" . 889150)))
    ("MSG_CAT_CLOSE" pro nil (system) "%s, object" ("M50.html"))
    ("MSG_CAT_COMPILE" pro nil (system) "%s, input[, output]" ("M51.html" ("LOCALE_ALIAS" . 931405) ("MBCS" . 931409)))
    ("MULTI" pro nil (system) "%s, N" ("M53.html"))
    ("NCDF_ATTDEL" pro nil (system) "%s, Cdfid [, Varid]" ("NetCDF-routines11.html" ("GLOBAL" . 996962)))
    ("NCDF_ATTGET" pro nil (system) "%s, Cdfid [, Varid]" ("NetCDF-routines12.html" ("GLOBAL" . 996996)))
    ("NCDF_ATTPUT" pro nil (system) "%s, Cdfid [, Varid]" ("NetCDF-routines15.html" ("BYTE" . 997126) ("CHAR" . 997129) ("DOUBLE" . 997132) ("FLOAT" . 997135) ("GLOBAL" . 997116) ("LENGTH" . 997119) ("LONG" . 997138) ("SHORT" . 997141)))
    ("NCDF_ATTRENAME" pro nil (system) "%s, Cdfid [, Varid]" ("NetCDF-routines16.html" ("GLOBAL" . 997166)))
    ("NCDF_CLOSE" pro nil (system) "%s, Cdfid" ("NetCDF-routines17.html"))
    ("NCDF_CONTROL" pro nil (system) "%s, Cdfid" ("NetCDF-routines18.html" ("ABORT" . 997195) ("ENDEF" . 997198) ("FILL" . 997201) ("NOFILL" . 997237) ("NOVERBOSE" . 997240) ("OLDFILL" . 997243) ("REDEF" . 997247) ("SYNC" . 997250) ("VERBOSE" . 997253)))
    ("NCDF_DIMINQ" pro nil (system) "%s, Cdfid, Dimid, Name, Size" ("NetCDF-routines22.html"))
    ("NCDF_DIMRENAME" pro nil (system) "%s, Cdfid, Dimid, NewName" ("NetCDF-routines23.html"))
    ("NCDF_VARGET" pro nil (system) "%s, Cdfid, Varid, Value" ("NetCDF-routines28.html" ("COUNT" . 997494) ("OFFSET" . 997497) ("STRIDE" . 997500)))
    ("NCDF_VARGET1" pro nil (system) "%s, Cdfid, Varid, Value" ("NetCDF-routines29.html" ("OFFSET" . 997545)))
    ("NCDF_VARPUT" pro nil (system) "%s, Cdfid, Varid, Value" ("NetCDF-routines32.html" ("COUNT" . 997627) ("OFFSET" . 997630) ("STRIDE" . 997633)))
    ("NCDF_VARRENAME" pro nil (system) "%s, Cdfid, Varid, Name" ("NetCDF-routines33.html"))
    ("OBJ_DESTROY" pro nil (system) "%s, ObjRef [, Arg1, ..., Argn]" ("O2.html"))
    ("ON_ERROR" pro nil (system) "%s, N" ("O7.html"))
    ("ON_IOERROR" pro nil (system) "%s, Label" ("O8.html"))
    ("ONLINE_HELP" pro nil (system) "%s [, Value]" ("O9.html" ("BOOK" . 889642) ("CONTEXT" . 934178) ("FOLD_CASE" . 934187) ("FULL_PATH" . 932136) ("PAGE" . 934194) ("QUIT" . 932700) ("TOPICS" . 931860)))
    ("OPENR" pro nil (system) "%s, Unit, File" ("O10.html" ("APPEND" . 889709) ("BUFSIZE" . 889712) ("COMPRESS" . 928372) ("DELETE" . 928370) ("ERROR" . 889720) ("F77_UNFORMATTED" . 889729) ("GET_LUN" . 889739) ("MORE" . 889747) ("NOEXPAND_PATH" . 929441) ("RAWIO" . 934244) ("STDIO" . 930929) ("SWAP_ENDIAN" . 889764) ("SWAP_IF_BIG_ENDIAN" . 889767) ("SWAP_IF_LITTLE_ENDIAN" . 889770) ("VAX_FLOAT" . 889773) ("WIDTH" . 889787) ("XDR" . 889796)))
    ("OPENU" pro nil (system) "%s, Unit, File" ("O10.html" ("APPEND" . 889709) ("BUFSIZE" . 889712) ("COMPRESS" . 928372) ("DELETE" . 928370) ("ERROR" . 889720) ("F77_UNFORMATTED" . 889729) ("GET_LUN" . 889739) ("MORE" . 889747) ("NOEXPAND_PATH" . 929441) ("RAWIO" . 934244) ("STDIO" . 930929) ("SWAP_ENDIAN" . 889764) ("SWAP_IF_BIG_ENDIAN" . 889767) ("SWAP_IF_LITTLE_ENDIAN" . 889770) ("VAX_FLOAT" . 889773) ("WIDTH" . 889787) ("XDR" . 889796)))
    ("OPENW" pro nil (system) "%s, Unit, File" ("O10.html" ("APPEND" . 889709) ("BUFSIZE" . 889712) ("COMPRESS" . 928372) ("DELETE" . 928370) ("ERROR" . 889720) ("F77_UNFORMATTED" . 889729) ("GET_LUN" . 889739) ("MORE" . 889747) ("NOEXPAND_PATH" . 929441) ("RAWIO" . 934244) ("STDIO" . 930929) ("SWAP_ENDIAN" . 889764) ("SWAP_IF_BIG_ENDIAN" . 889767) ("SWAP_IF_LITTLE_ENDIAN" . 889770) ("VAX_FLOAT" . 889773) ("WIDTH" . 889787) ("XDR" . 889796)))
    ("OPLOT" pro nil (system) "%s, [X,] Y" ("O11.html" ("MAX_VALUE" . 889969) ("MIN_VALUE" . 889976) ("NSUM" . 889983) ("POLAR" . 889990) ("THICK" . 889995)) ("graphkeyw2.html" ("CLIP" . 315949) ("COLOR" . 315952) ("LINESTYLE" . 331728) ("NOCLIP" . 323508) ("PSYM" . 316038) ("SYMSIZE" . 316061) ("T3D" . 315956) ("ZVALUE" . 316102)))
    ("OPLOTERR" pro nil (system) "%s, [ X ,] Y , Err [, Psym]" ("O12.html"))
    ("PARTICLE_TRACE" pro nil (system) "%s, Data, Seeds, Verts, Conn [, Normals]" ("P2.html" ("ANISOTROPY" . 1071147) ("INTEGRATION" . 1071149) ("MAX_ITERATIONS" . 1071158) ("MAX_STEPSIZE" . 1071160) ("SEED_NORMAL" . 1071154) ("TOLERANCE" . 1071156) ("UNIFORM" . 1071162)))
    ("PLOT" pro nil (system) "%s, [X,] Y" ("P5.html" ("ISOTROPIC" . 948898) ("MAX_VALUE" . 678098) ("MIN_VALUE" . 47057) ("NSUM" . 678100) ("POLAR" . 678103) ("THICK" . 678106) ("XLOG" . 810411) ("YLOG" . 810463) ("YNOZERO" . 810415)) ("graphkeyw2.html" ("BACKGROUND" . 328424) ("CHARSIZE" . 266973) ("CHARTHICK" . 331668) ("CLIP" . 315949) ("COLOR" . 315952) ("DATA" . 315961) ("DEVICE" . 315977) ("FONT" . 331795) ("LINESTYLE" . 331728) ("NOCLIP" . 323508) ("NODATA" . 316018) ("NOERASE" . 316024) ("NORMAL" . 315963) ("POSITION" . 316026) ("PSYM" . 316038) ("SUBTITLE" . 316057) ("SYMSIZE" . 316061) ("T3D" . 315956) ("TICKLEN" . 332207) ("TITLE" . 332238) ("XCHARSIZE" . 331699) ("XGRIDSTYLE" . 332009) ("XMARGIN" . 332038) ("XMINOR" . 332061) ("XRANGE" . 332090) ("XSTYLE" . 332116) ("XTHICK" . 332298) ("XTICK_GET" . 332321) ("XTICKFORMAT" . 332347) ("XTICKINTERVAL" . 332463) ("XTICKLAYOUT" . 332488) ("XTICKLEN" . 332513) ("XTICKNAME" . 332536) ("XTICKS" . 332559) ("XTICKUNITS" . 332586) ("XTICKV" . 332628) ("XTITLE" . 316100) ("YCHARSIZE" . 331699) ("YGRIDSTYLE" . 332009) ("YMARGIN" . 332038) ("YMINOR" . 332061) ("YRANGE" . 332090) ("YSTYLE" . 332116) ("YTHICK" . 332298) ("YTICK_GET" . 332321) ("YTICKFORMAT" . 332347) ("YTICKINTERVAL" . 332463) ("YTICKLAYOUT" . 332488) ("YTICKLEN" . 332513) ("YTICKNAME" . 332536) ("YTICKS" . 332559) ("YTICKUNITS" . 332586) ("YTICKV" . 332628) ("YTITLE" . 316100) ("ZCHARSIZE" . 331699) ("ZGRIDSTYLE" . 332009) ("ZMARGIN" . 332038) ("ZMINOR" . 332061) ("ZRANGE" . 332090) ("ZSTYLE" . 332116) ("ZTHICK" . 332298) ("ZTICK_GET" . 332321) ("ZTICKFORMAT" . 332347) ("ZTICKINTERVAL" . 332463) ("ZTICKLAYOUT" . 332488) ("ZTICKLEN" . 332513) ("ZTICKNAME" . 332536) ("ZTICKS" . 332559) ("ZTICKUNITS" . 332586) ("ZTICKV" . 332628) ("ZTITLE" . 316100) ("ZVALUE" . 316102)))
    ("PLOT_3DBOX" pro nil (system) "%s, X, Y, Z" ("P6.html" ("GRIDSTYLE" . 137555) ("PSYM" . 137608) ("SOLID_WALLS" . 835291) ("XY_PLANE" . 137639) ("XYSTYLE" . 137642) ("XZ_PLANE" . 137637) ("XZSTYLE" . 137638) ("YZ_PLANE" . 137640) ("YZSTYLE" . 137643)) ("S72.html" ("AX" . 679220) ("AZ" . 679225) ("ZAXIS" . 679256)) ("graphkeyw2.html" ("BACKGROUND" . 328424) ("CHARSIZE" . 266973) ("CHARTHICK" . 331668) ("CLIP" . 315949) ("COLOR" . 315952) ("DATA" . 315961) ("DEVICE" . 315977) ("LINESTYLE" . 331728) ("NOCLIP" . 323508) ("NODATA" . 316018) ("NOERASE" . 316024) ("NORMAL" . 315963) ("POSITION" . 316026) ("SUBTITLE" . 316057) ("T3D" . 315956) ("TICKLEN" . 332207) ("TITLE" . 332238) ("XCHARSIZE" . 331699) ("XGRIDSTYLE" . 332009) ("XMARGIN" . 332038) ("XMINOR" . 332061) ("XRANGE" . 332090) ("XSTYLE" . 332116) ("XTHICK" . 332298) ("XTICKFORMAT" . 332347) ("XTICKINTERVAL" . 332463) ("XTICKLAYOUT" . 332488) ("XTICKLEN" . 332513) ("XTICKNAME" . 332536) ("XTICKS" . 332559) ("XTICKUNITS" . 332586) ("XTICKV" . 332628) ("XTITLE" . 316100) ("YCHARSIZE" . 331699) ("YGRIDSTYLE" . 332009) ("YMARGIN" . 332038) ("YMINOR" . 332061) ("YRANGE" . 332090) ("YSTYLE" . 332116) ("YTHICK" . 332298) ("YTICKFORMAT" . 332347) ("YTICKINTERVAL" . 332463) ("YTICKLAYOUT" . 332488) ("YTICKLEN" . 332513) ("YTICKNAME" . 332536) ("YTICKS" . 332559) ("YTICKUNITS" . 332586) ("YTICKV" . 332628) ("YTITLE" . 316100) ("ZCHARSIZE" . 331699) ("ZGRIDSTYLE" . 332009) ("ZMARGIN" . 332038) ("ZMINOR" . 332061) ("ZRANGE" . 332090) ("ZSTYLE" . 332116) ("ZTHICK" . 332298) ("ZTICKFORMAT" . 332347) ("ZTICKINTERVAL" . 332463) ("ZTICKLAYOUT" . 332488) ("ZTICKLEN" . 332513) ("ZTICKNAME" . 332536) ("ZTICKS" . 332559) ("ZTICKUNITS" . 332586) ("ZTICKV" . 332628) ("ZTITLE" . 316100)))
    ("PLOT_FIELD" pro nil (system) "%s, U, V" ("P7.html" ("ASPECT" . 757604) ("LENGTH" . 757607) ("N" . 757610) ("TITLE" . 757613)))
    ("PLOTERR" pro nil (system) "%s, [ X ,] Y , Err" ("P8.html" ("PSYM" . 757654) ("TYPE" . 757647)))
    ("PLOTS" pro nil (system) "%s, X [, Y [, Z]]" ("P9.html" ("CONTINUE" . 678168)) ("graphkeyw2.html" ("CLIP" . 315949) ("COLOR" . 315952) ("DATA" . 315961) ("DEVICE" . 315977) ("LINESTYLE" . 331728) ("NOCLIP" . 323508) ("NORMAL" . 315963) ("PSYM" . 316038) ("SYMSIZE" . 316061) ("T3D" . 315956) ("THICK" . 316006) ("Z" . 332658)))
    ("POINT_LUN" pro nil (system) "%s, Unit, Position" ("P11.html"))
    ("POLAR_CONTOUR" pro nil (system) "%s, Z, Theta, R" ("P12.html" ("SHOW_TRIANGULATION" . 128404)) ("C38.html" ("C_ANNOTATION" . 1023103) ("C_CHARSIZE" . 676279) ("C_CHARTHICK" . 905138) ("C_COLORS" . 676281) ("C_LINESTYLE" . 676292) ("C_ORIENTATION" . 676298) ("C_SPACING" . 676300) ("C_THICK" . 676302) ("CLOSED" . 676304) ("FILL" . 676308) ("IRREGULAR" . 879096) ("LEVELS" . 927695) ("MAX_VALUE" . 676323) ("MIN_VALUE" . 47033) ("NLEVELS" . 676325) ("OVERPLOT" . 861732) ("PATH_DATA_COORDS" . 879089) ("TRIANGULATION" . 746344) ("XLOG" . 158329) ("YLOG" . 158344) ("ZAXIS" . 676344)))
    ("POLYFILL" pro nil (system) "%s, X [, Y [, Z]]" ("P18.html" ("IMAGE_COORD" . 678254) ("IMAGE_INTERP" . 678256) ("LINE_FILL" . 678258) ("PATTERN" . 678260) ("SPACING" . 678269) ("TRANSPARENT" . 678271)) ("graphkeyw2.html" ("CLIP" . 315949) ("COLOR" . 315952) ("DATA" . 315961) ("DEVICE" . 315977) ("LINESTYLE" . 331728) ("NOCLIP" . 323508) ("NORMAL" . 315963) ("ORIENTATION" . 315964) ("T3D" . 315956) ("THICK" . 316006) ("Z" . 332658)))
    ("POLYWARP" pro nil (system) "%s, Xi, Yi, Xo, Yo, Degree, Kx, Ky" ("P21.html" ("DOUBLE" . 1075034) ("STATUS" . 1075060)))
    ("POPD" pro nil (system) "%s" ("P22.html"))
    ("POWELL" pro nil (system) "%s, P, Xi, Ftol, Fmin, Func" ("P23.html" ("DOUBLE" . 51467) ("ITER" . 51470) ("ITMAX" . 51473)))
    ("PRINT" pro nil (system) "%s [, Expr1, ..., Exprn]" ("P25.html" ("AM_PM" . 678362) ("DAYS_OF_WEEK" . 1015582) ("FORMAT" . 1015576) ("MONTHS" . 1015619) ("STDIO_NON_FINITE" . 1015513)))
    ("PRINTD" pro nil (system) "%s" ("P26.html"))
    ("PRINTF" pro nil (system) "%s [, Unit, Expr1, ..., Exprn]" ("P25.html" ("AM_PM" . 678362) ("DAYS_OF_WEEK" . 1015582) ("FORMAT" . 1015576) ("MONTHS" . 1015619) ("STDIO_NON_FINITE" . 1015513)))
    ("PROFILER" pro nil (system) "%s [, Module]" ("P30.html" ("CLEAR" . 900205) ("DATA" . 1088814) ("OUTPUT" . 900155) ("REPORT" . 900194) ("RESET" . 900195) ("SYSTEM" . 900159)))
    ("PROFILES" pro nil (system) "%s, Image" ("P31.html" ("ORDER" . 757719) ("SX" . 757722) ("SY" . 757725) ("WSIZE" . 757728)))
    ("PS_SHOW_FONTS" pro nil (system) "%s" ("P33.html" ("NOLATIN" . 762026)))
    ("PSAFM" pro nil (system) "%s, Input_Filename, Output_Filename" ("P34.html"))
    ("PSEUDO" pro nil (system) "%s, Litlo, Lithi, Satlo, Sathi, Hue, Loops [, Colr]" ("P35.html"))
    ("PTR_FREE" pro nil (system) "%s, P1, ... ..., Pn" ("P36.html"))
    ("PUSHD" pro nil (system) "%s, Dir" ("P40.html"))
    ("QHULL" pro nil (system) "%s, V, Tr or, QHULL, V0 , V1, [, V2 ... [, V6] ] , Tr" ("Q2.html" ("BOUNDS" . 1073465) ("CONNECTIVITY" . 1073467) ("DELAUNAY" . 1073473) ("SPHERE" . 1073475) ("VDIAGRAM" . 1073477) ("VNORMALS" . 1073481) ("VVERTICES" . 1073483)))
    ("RDPIX" pro nil (system) "%s, Image [, X0, Y0]" ("R7.html"))
    ("READ" pro nil (system) "%s, [Prompt,] Var1, ..., Varn" ("R8.html" ("AM_PM" . 1015647) ("DAYS_OF_WEEK" . 1015649) ("FORMAT" . 1015645) ("MONTHS" . 1015670) ("PROMPT" . 863855)))
    ("READ_INTERFILE" pro nil (system) "%s, File, Data" ("R14.html"))
    ("READ_JPEG" pro nil (system) "%s [, Filename]" ("R15.html" ("BUFFER" . 279694) ("COLORS" . 279696) ("DITHER" . 279697) ("GRAYSCALE" . 1064444) ("ORDER" . 868283) ("TRUE" . 279699) ("TWO_PASS_QUANTIZE" . 279700) ("UNIT" . 279701)))
    ("READ_PICT" pro nil (system) "%s, Filename, Image [, R, G, B]" ("R17.html"))
    ("READ_PPM" pro nil (system) "%s, Filename, Image" ("R19.html" ("MAXVAL" . 67809)))
    ("READ_SRF" pro nil (system) "%s, Filename, Image [, R, G, B]" ("R21.html"))
    ("READ_WAVE" pro nil (system) "%s, File, Variables, Names, Dimensions" ("R25.html" ("MESHNAMES" . 756240)))
    ("READ_X11_BITMAP" pro nil (system) "%s, File, Bitmap [, X, Y]" ("R26.html" ("EXPAND_TO_BYTES" . 756264)))
    ("READF" pro nil (system) "%s, [Prompt,] Unit, Var1, ..., Varn" ("R8.html" ("AM_PM" . 1015647) ("DAYS_OF_WEEK" . 1015649) ("FORMAT" . 1015645) ("MONTHS" . 1015670) ("PROMPT" . 863855)))
    ("READS" pro nil (system) "%s, Input, Var1, ..., Varn" ("R28.html" ("AM_PM" . 1015707) ("DAYS_OF_WEEK" . 1015709) ("FORMAT" . 678457) ("MONTHS" . 1015728)))
    ("READU" pro nil (system) "%s, Unit, Var1, ..., Varn" ("R29.html" ("TRANSFER_COUNT" . 678471)))
    ("REDUCE_COLORS" pro nil (system) "%s, Image, Values" ("R34.html"))
    ("REGISTER_CURSOR" pro nil (system) "%s, Name, Image" ("R37.html" ("HOTSPOT" . 1108842) ("MASK" . 1108840) ("OVERWRITE" . 1108844)))
    ("REPLICATE_INPLACE" pro nil (system) "%s, X, Value [, D1, Loc1 [, D2, Range]]" ("R41.html") ("tpoolkeyw2.html" ("TPOOL_MAX_ELTS" . 333417) ("TPOOL_MIN_ELTS" . 333286) ("TPOOL_NOTHREAD" . 333289)))
    ("RESOLVE_ALL" pro nil (system) "%s" ("R42.html" ("CONTINUE_ON_ERROR" . 1014993) ("QUIET" . 1014991)))
    ("RESOLVE_ROUTINE" pro nil (system) "%s, Name" ("R43.html" ("COMPILE_FULL_FILE" . 1069898) ("EITHER" . 1073138) ("IS_FUNCTION" . 1069896) ("NO_RECOMPILE" . 1069991)))
    ("RESTORE" pro nil (system) "%s [[, Filename]]" ("R44.html" ("FILENAME" . 678568) ("RELAXED_STRUCTURE_ASSIGNMENT" . 900571) ("RESTORED_OBJECTS" . 900564) ("VERBOSE" . 678570)))
    ("RETALL" pro nil (system) "%s" ("R45.html"))
    ("SAVE" pro nil (system) "%s [, Var1, ..., Varn]" ("S2.html" ("ALL" . 678631) ("COMM" . 678633) ("COMPRESS" . 1074405) ("FILENAME" . 678635) ("ROUTINES" . 678637) ("SYSTEM_VARIABLES" . 678639) ("VARIABLES" . 678642) ("VERBOSE" . 678644)))
    ("SCALE3" pro nil (system) "%s" ("S4.html" ("AX" . 787108) ("AZ" . 787111) ("XRANGE" . 787099) ("YRANGE" . 787102) ("ZRANGE" . 787105)))
    ("SCALE3D" pro nil (system) "%s" ("S5.html"))
    ("SET_PLOT" pro nil (system) "%s, Device" ("S8.html" ("COPY" . 862592) ("INTERPOLATE" . 862599)))
    ("SET_SHADING" pro nil (system) "%s" ("S9.html" ("GOURAUD" . 678682) ("LIGHT" . 678685) ("REJECT" . 678687) ("VALUES" . 678689)))
    ("SETENV" pro nil (system) "%s, Environment_Expression" ("S10.html"))
    ("SETUP_KEYS" pro nil (system) "%s" ("S11.html" ("ANSI" . 43203) ("APP_KEYPAD" . 43217) ("EIGHTBIT" . 1015422) ("HP9000" . 43209) ("IBM" . 1015421) ("MIPS" . 43211) ("NUM_KEYPAD" . 43219) ("PSTERM") ("SGI" . 43215) ("SUN" . 43205) ("VT200" . 43207)))
    ("SHADE_SURF" pro nil (system) "%s, Z [, X, Y]" ("S13.html" ("AX" . 678754) ("AZ" . 678759) ("IMAGE" . 678761) ("MAX_VALUE" . 678763) ("MIN_VALUE" . 47127) ("PIXELS" . 844042) ("SAVE" . 678765) ("SHADES" . 678767) ("XLOG" . 158361) ("YLOG" . 158393)) ("graphkeyw2.html" ("CHARSIZE" . 266973) ("CHARTHICK" . 331668) ("COLOR" . 315952) ("DATA" . 315961) ("DEVICE" . 315977) ("FONT" . 331795) ("NODATA" . 316018) ("NORMAL" . 315963) ("POSITION" . 316026) ("SUBTITLE" . 316057) ("T3D" . 315956) ("THICK" . 316006) ("TICKLEN" . 332207) ("TITLE" . 332238) ("XCHARSIZE" . 331699) ("XGRIDSTYLE" . 332009) ("XMARGIN" . 332038) ("XMINOR" . 332061) ("XRANGE" . 332090) ("XSTYLE" . 332116) ("XTHICK" . 332298) ("XTICK_GET" . 332321) ("XTICKFORMAT" . 332347) ("XTICKINTERVAL" . 332463) ("XTICKLAYOUT" . 332488) ("XTICKLEN" . 332513) ("XTICKNAME" . 332536) ("XTICKS" . 332559) ("XTICKUNITS" . 332586) ("XTICKV" . 332628) ("XTITLE" . 316100) ("YCHARSIZE" . 331699) ("YGRIDSTYLE" . 332009) ("YMARGIN" . 332038) ("YMINOR" . 332061) ("YRANGE" . 332090) ("YSTYLE" . 332116) ("YTHICK" . 332298) ("YTICK_GET" . 332321) ("YTICKFORMAT" . 332347) ("YTICKINTERVAL" . 332463) ("YTICKLAYOUT" . 332488) ("YTICKLEN" . 332513) ("YTICKNAME" . 332536) ("YTICKS" . 332559) ("YTICKUNITS" . 332586) ("YTICKV" . 332628) ("YTITLE" . 316100) ("ZCHARSIZE" . 331699) ("ZGRIDSTYLE" . 332009) ("ZMARGIN" . 332038) ("ZMINOR" . 332061) ("ZRANGE" . 332090) ("ZSTYLE" . 332116) ("ZTHICK" . 332298) ("ZTICK_GET" . 332321) ("ZTICKFORMAT" . 332347) ("ZTICKINTERVAL" . 332463) ("ZTICKLAYOUT" . 332488) ("ZTICKLEN" . 332513) ("ZTICKNAME" . 332536) ("ZTICKS" . 332559) ("ZTICKUNITS" . 332586) ("ZTICKV" . 332628) ("ZTITLE" . 316100) ("ZVALUE" . 316102)))
    ("SHADE_SURF_IRR" pro nil (system) "%s, Z, X, Y" ("S14.html" ("AX" . 787162) ("AZ" . 787165) ("IMAGE" . 787168) ("PLIST" . 787171) ("T3D" . 867401)))
    ("SHADE_VOLUME" pro nil (system) "%s, Volume, Value, Vertex, Poly" ("S15.html" ("LOW" . 678801) ("SHADES" . 678803) ("VERBOSE" . 678805) ("XRANGE" . 678807) ("YRANGE" . 678809) ("ZRANGE" . 678811)))
    ("SHMMAP" pro nil (system) "%s [, SegmentName] [, D1, ..., D8]" ("S18.html" ("BYTE" . 1143213) ("COMPLEX" . 1143215) ("DCOMPLEX" . 1143217) ("DESTROY_SEGMENT" . 1143219) ("DIMENSION" . 1143226) ("DOUBLE" . 1143228) ("FILENAME" . 1143230) ("FLOAT" . 1143234) ("GET_NAME" . 1143237) ("GET_OS_HANDLE" . 1143240) ("INTEGER" . 1143245) ("L64" . 1143247) ("LONG" . 1143252) ("OFFSET" . 1143254) ("OS_HANDLE" . 1143259) ("PRIVATE" . 1143277) ("SIZE" . 1143281) ("SYSV" . 1143286) ("TEMPLATE" . 1143291) ("TYPE" . 1143293) ("UINT" . 1143298) ("UL64" . 1143302) ("ULONG" . 1143300)))
    ("SHMUNMAP" pro nil (system) "%s, SegmentName" ("S19.html"))
    ("SHOW3" pro nil (system) "%s, Image [, X, Y]" ("S21.html" ("E_CONTOUR" . 863032) ("E_SURFACE" . 863036) ("INTERP" . 862964) ("SSCALE" . 787203)))
    ("SHOWFONT" pro nil (system) "%s, Font, Name" ("S22.html" ("ENCAPSULATED" . 762072) ("TT_FONT" . 901959)))
    ("SKIP_LUN" pro nil (system) "%s, FromUnit, [, Num]" ("S29.html" ("EOF" . 1143762) ("LINES" . 1143765) ("TRANSFER_COUNT" . 1143767)))
    ("SLICER3" pro nil (system) "%s [, hData3D]" ("S30.html" ("DATA_NAMES" . 914863) ("DETACH" . 914866) ("GROUP" . 914869) ("MODAL" . 914872)))
    ("SLIDE_IMAGE" pro nil (system) "%s [, Image]" ("S31.html" ("BLOCK" . 923990) ("CONGRID" . 787344) ("FULL_WINDOW" . 787347) ("GROUP" . 787350) ("ORDER" . 787353) ("REGISTER" . 787356) ("RETAIN" . 787360) ("SHOW_FULL" . 787366) ("SLIDE_WINDOW" . 787363) ("TITLE" . 900068) ("TOP_ID" . 787369) ("XSIZE" . 787374) ("XVISIBLE" . 787377) ("YSIZE" . 787380) ("YVISIBLE" . 787383)))
    ("SOCKET" pro nil (system) "%s, Unit, Host, Port" ("S34.html" ("CONNECT_TIMEOUT" . 1098145) ("ERROR" . 1098148) ("GET_LUN" . 1142975) ("RAWIO" . 1098160) ("READ_TIMEOUT" . 1098166) ("STDIO" . 1133828) ("SWAP_ENDIAN" . 1098168) ("SWAP_IF_BIG_ENDIAN" . 1098171) ("SWAP_IF_LITTLE_ENDIAN" . 1098175) ("WIDTH" . 1098179) ("WRITE_TIMEOUT" . 1098187)))
    ("SPAWN" pro nil (system) "%s [, Command [, Result] [, ErrResult]]" ("S36.html" ("COUNT" . 678969) ("EXIT_STATUS" . 678971) ("HIDE" . 1133996) ("LOG_OUTPUT" . 1134006) ("NOSHELL" . 1108410) ("NOTTYRESET" . 1134017) ("NOWAIT" . 1134051) ("NULL_STDIN" . 1134151) ("PID" . 1084167) ("SH" . 1133965) ("STDERR" . 1133968) ("UNIT" . 1133975)))
    ("SPH_4PNT" pro nil (system) "%s, X, Y, Z, Xc, Yc, Zc, R" ("S37.html" ("DOUBLE" . 1094107)))
    ("SPLINE_P" pro nil (system) "%s, X, Y, Xr, Yr" ("S43.html" ("INTERVAL" . 758561) ("TAN0" . 758564) ("TAN1" . 758567)))
    ("STOP" pro nil (system) "%s [, Expr1, ..., Exprn]" ("S51.html"))
    ("STREAMLINE" pro nil (system) "%s, Verts, Conn, Normals, Outverts, Outconn" ("S55.html" ("ANISOTROPY" . 1078861) ("PROFILE" . 1078865) ("SIZE" . 1078863)))
    ("STRETCH" pro nil (system) "%s [, Low, High [, Gamma]]" ("S57.html" ("CHOP" . 759533)))
    ("STRPUT" pro nil (system) "%s, Destination, Source [, Position]" ("S66.html"))
    ("STRUCT_ASSIGN" pro nil (system) "%s, Source, Destination" ("S69.html" ("NOZERO" . 1074356) ("VERBOSE" . 901018)))
    ("STRUCT_HIDE" pro nil (system) "%s, Arg1 [, Arg2, ..., Argn]" ("S70.html"))
    ("SURFACE" pro nil (system) "%s, Z [, X, Y]" ("S72.html" ("AX" . 679220) ("AZ" . 679225) ("BOTTOM" . 679227) ("HORIZONTAL" . 679229) ("LEGO" . 716839) ("LOWER_ONLY" . 679231) ("MAX_VALUE" . 679233) ("MIN_VALUE" . 47161) ("SAVE" . 679235) ("SHADES" . 679245) ("SKIRT" . 679247) ("UPPER_ONLY" . 679250) ("XLOG" . 158409) ("YLOG" . 158414) ("ZAXIS" . 679256) ("ZLOG" . 862016)) ("graphkeyw2.html" ("BACKGROUND" . 328424) ("CHARSIZE" . 266973) ("CHARTHICK" . 331668) ("CLIP" . 315949) ("COLOR" . 315952) ("DATA" . 315961) ("DEVICE" . 315977) ("FONT" . 331795) ("LINESTYLE" . 331728) ("NOCLIP" . 323508) ("NODATA" . 316018) ("NOERASE" . 316024) ("NORMAL" . 315963) ("POSITION" . 316026) ("SUBTITLE" . 316057) ("T3D" . 315956) ("TICKLEN" . 332207) ("TITLE" . 332238) ("XCHARSIZE" . 331699) ("XGRIDSTYLE" . 332009) ("XMARGIN" . 332038) ("XMINOR" . 332061) ("XRANGE" . 332090) ("XSTYLE" . 332116) ("XTHICK" . 332298) ("XTICK_GET" . 332321) ("XTICKFORMAT" . 332347) ("XTICKINTERVAL" . 332463) ("XTICKLAYOUT" . 332488) ("XTICKLEN" . 332513) ("XTICKNAME" . 332536) ("XTICKS" . 332559) ("XTICKUNITS" . 332586) ("XTICKV" . 332628) ("XTITLE" . 316100) ("YCHARSIZE" . 331699) ("YGRIDSTYLE" . 332009) ("YMARGIN" . 332038) ("YMINOR" . 332061) ("YRANGE" . 332090) ("YSTYLE" . 332116) ("YTHICK" . 332298) ("YTICK_GET" . 332321) ("YTICKFORMAT" . 332347) ("YTICKINTERVAL" . 332463) ("YTICKLAYOUT" . 332488) ("YTICKLEN" . 332513) ("YTICKNAME" . 332536) ("YTICKS" . 332559) ("YTICKUNITS" . 332586) ("YTICKV" . 332628) ("YTITLE" . 316100) ("ZCHARSIZE" . 331699) ("ZGRIDSTYLE" . 332009) ("ZMARGIN" . 332038) ("ZMINOR" . 332061) ("ZRANGE" . 332090) ("ZSTYLE" . 332116) ("ZTHICK" . 332298) ("ZTICK_GET" . 332321) ("ZTICKFORMAT" . 332347) ("ZTICKINTERVAL" . 332463) ("ZTICKLAYOUT" . 332488) ("ZTICKLEN" . 332513) ("ZTICKNAME" . 332536) ("ZTICKS" . 332559) ("ZTICKUNITS" . 332586) ("ZTICKV" . 332628) ("ZTITLE" . 316100) ("ZVALUE" . 316102)))
    ("SURFR" pro nil (system) "%s" ("S73.html" ("AX" . 787417) ("AZ" . 787420)))
    ("SVDC" pro nil (system) "%s, A, W, U, V" ("S74.html" ("COLUMN" . 58767) ("DOUBLE" . 52115) ("ITMAX" . 1095860)))
    ("SWAP_ENDIAN_INPLACE" pro nil (system) "%s, Variable" ("S78.html" ("SWAP_IF_BIG_ENDIAN" . 1143824) ("SWAP_IF_LITTLE_ENDIAN" . 1143826)))
    ("T3D" pro nil (system) "%s [, Array]" ("T3.html" ("MATRIX" . 787453) ("OBLIQUE" . 1076313) ("PERSPECTIVE" . 787459) ("RESET" . 787462) ("ROTATE" . 787465) ("SCALE" . 787468) ("TRANSLATE" . 787471) ("XYEXCH" . 787474) ("XZEXCH" . 787477) ("YZEXCH" . 787480)))
    ("TEK_COLOR" pro nil (system) "%s [, Start_Index, Colors]" ("T7.html"))
    ("THREED" pro nil (system) "%s, A [, Sp]" ("T13.html" ("TITLE" . 787515) ("XTITLE" . 787518) ("YTITLE" . 787521)))
    ("TIME_TEST2" pro nil (system) "%s [, Filename]" ("T14.html"))
    ("TRIANGULATE" pro nil (system) "%s, X, Y, Triangles [, B]" ("T21.html" ("CONNECTIVITY" . 679547) ("DEGREES" . 126686) ("FVALUE" . 126695) ("REPEATS" . 679555) ("SPHERE" . 126681)))
    ("TRIQL" pro nil (system) "%s, D, E, A" ("T23.html" ("DOUBLE" . 52221)))
    ("TRIRED" pro nil (system) "%s, A, D, E" ("T24.html" ("DOUBLE" . 52282)))
    ("TRUNCATE_LUN" pro nil (system) "%s, Unit1, ..., Unitn" ("T26.html"))
    ("TV" pro nil (system) "%s, Image [, Position] or Image [, X, Y [, Channel]]" ("T31.html" ("CENTIMETERS" . 679682) ("INCHES" . 679690) ("ORDER" . 679694) ("TRUE" . 679698) ("WORDS" . 679701) ("XSIZE" . 679703) ("YSIZE" . 679705)) ("graphkeyw2.html" ("CHANNEL" . 315931) ("DATA" . 315961) ("DEVICE" . 315977) ("NORMAL" . 315963) ("T3D" . 315956) ("Z" . 332658)))
    ("TVCRS" pro nil (system) "%s [, ON_OFF] or TVCRS [, X, Y]" ("T32.html" ("CENTIMETERS" . 679732) ("HIDE_CURSOR" . 817846) ("INCHES" . 817861)) ("graphkeyw2.html" ("DATA" . 315961) ("DEVICE" . 315977) ("NORMAL" . 315963) ("T3D" . 315956) ("Z" . 332658)))
    ("TVLCT" pro nil (system) "%s, V1, V2, V3 [, Start]" ("T33.html" ("GET" . 844142) ("HLS" . 679761) ("HSV" . 679763)))
    ("TVSCL" pro nil (system) "%s, Image [, Position] or Image [, X, Y [, Channel]]" ("T35.html" ("CENTIMETERS") ("INCHES") ("NAN" . 902069) ("ORDER") ("TOP" . 218988) ("TRUE") ("WORDS") ("XSIZE") ("YSIZE")) ("T31.html" ("CENTIMETERS" . 679682) ("INCHES" . 679690) ("ORDER" . 679694) ("TRUE" . 679698) ("WORDS" . 679701) ("XSIZE" . 679703) ("YSIZE" . 679705)) ("graphkeyw2.html" ("CHANNEL" . 315931) ("DATA" . 315961) ("DEVICE" . 315977) ("NORMAL" . 315963) ("T3D" . 315956) ("Z" . 332658)) ("tpoolkeyw2.html" ("TPOOL_MAX_ELTS" . 333417) ("TPOOL_MIN_ELTS" . 333286) ("TPOOL_NOTHREAD" . 333289)))
    ("USERSYM" pro nil (system) "%s, X [, Y]" ("U11.html" ("COLOR" . 886945) ("FILL" . 886948) ("THICK" . 886951)))
    ("VECTOR_FIELD" pro nil (system) "%s, Field, Outverts, Outconn" ("V3.html" ("ANISOTROPY" . 957083) ("SCALE" . 957085) ("VERTICES" . 957087)))
    ("VEL" pro nil (system) "%s, U, V" ("V4.html" ("LENGTH" . 956021) ("NSTEPS" . 956033) ("NVECS" . 787550) ("TITLE" . 956041) ("XMAX" . 787553)))
    ("VELOVECT" pro nil (system) "%s, U, V [, X, Y]" ("V5.html" ("COLOR" . 787592) ("DOTS" . 787595) ("LENGTH" . 787598) ("MISSING" . 787601) ("OVERPLOT" . 957555)))
    ("VORONOI" pro nil (system) "%s, X, Y, I0, C, Xp, Yp, Rect" ("V8.html"))
    ("WAIT" pro nil (system) "%s, Seconds" ("W.html"))
    ("WDELETE" pro nil (system) "%s [, Window_Index [, ...]]" ("W4.html"))
    ("WF_DRAW" pro nil (system) "%s, X, Y" ("W5.html" ("COLD" . 787681) ("COLOR" . 787684) ("CONVERGENCE" . 787687) ("DATA" . 787690) ("DEVICE" . 787693) ("FRONT_TYPE" . 787696) ("INTERVAL" . 787699) ("NORMAL" . 787702) ("OCCLUDED" . 787705) ("PSYM" . 787708) ("STATIONARY" . 787714) ("SYM_HT" . 787717) ("SYM_LEN" . 787720) ("THICK" . 787723) ("WARM" . 787726)))
    ("WIDGET_CONTROL" pro nil (system) "%s [, Widget_ID]" ("W12.html" ("ALIGNMENT" . 894840) ("ALL_TABLE_EVENTS" . 894849) ("ALL_TEXT_EVENTS" . 680079) ("AM_PM" . 949789) ("APPEND" . 886776) ("BAD_ID" . 680083) ("BASE_SET_TITLE" . 977104) ("BITMAP") ("CANCEL_BUTTON" . 910691) ("CLEAR_EVENTS" . 978647) ("COLUMN_LABELS" . 894928) ("COLUMN_WIDTHS" . 894930) ("COMBOBOX_ADDITEM" . 981369) ("COMBOBOX_DELETEITEM" . 981434) ("COMBOBOX_INDEX" . 981376) ("CONTEXT_EVENTS" . 949802) ("DAYS_OF_WEEK" . 970733) ("DEFAULT_BUTTON" . 909921) ("DEFAULT_FONT" . 680087) ("DELAY_DESTROY" . 680090) ("DELETE_COLUMNS" . 894963) ("DELETE_ROWS" . 919067) ("DESTROY" . 680094) ("DRAW_BUTTON_EVENTS" . 680097) ("DRAW_EXPOSE_EVENTS" . 907371) ("DRAW_KEYBOARD_EVENTS" . 985153) ("DRAW_MOTION_EVENTS" . 680099) ("DRAW_VIEWPORT_EVENTS" . 680101) ("DRAW_XSIZE" . 58243) ("DRAW_YSIZE" . 58244) ("DYNAMIC_RESIZE" . 192830) ("EDIT_CELL" . 895011) ("EDITABLE" . 889314) ("EVENT_FUNC" . 895036) ("EVENT_PRO" . 680108) ("FORMAT" . 895067) ("FUNC_GET_VALUE" . 680113) ("GET_DRAW_VIEW" . 680115) ("GET_UVALUE" . 680117) ("GET_VALUE" . 680122) ("GROUP_LEADER" . 933268) ("HOURGLASS" . 680134) ("ICONIFY" . 680136) ("INPUT_FOCUS" . 680138) ("INSERT_COLUMNS" . 895129) ("INSERT_ROWS" . 895131) ("KBRD_FOCUS_EVENTS" . 919052) ("KILL_NOTIFY" . 680140) ("MANAGED" . 680144) ("MAP" . 680146) ("MONTHS" . 949815) ("NO_COPY" . 680150) ("NO_NEWLINE" . 680152) ("NOTIFY_REALIZE" . 67586) ("PRO_SET_VALUE" . 680154) ("REALIZE" . 680156) ("RESET" . 680159) ("ROW_HEIGHTS" . 895150) ("ROW_LABELS" . 895148) ("SCR_XSIZE" . 58190) ("SCR_YSIZE" . 58191) ("SEND_EVENT" . 58210) ("SENSITIVE" . 680164) ("SET_BUTTON" . 680167) ("SET_COMBOBOX_SELECT" . 981513) ("SET_DRAW_VIEW" . 680169) ("SET_DROPLIST_SELECT" . 680172) ("SET_LIST_SELECT" . 58235) ("SET_LIST_TOP" . 680175) ("SET_SLIDER_MAX" . 680177) ("SET_SLIDER_MIN" . 680179) ("SET_TAB_CURRENT" . 977118) ("SET_TAB_MULTILINE" . 977124) ("SET_TABLE_SELECT" . 895216) ("SET_TABLE_VIEW" . 895208) ("SET_TEXT_SELECT" . 680181) ("SET_TEXT_TOP_LINE" . 680185) ("SET_TREE_BITMAP" . 978535) ("SET_TREE_EXPANDED" . 978542) ("SET_TREE_SELECT" . 978548) ("SET_TREE_VISIBLE" . 978561) ("SET_UNAME" . 680187) ("SET_UVALUE" . 949285) ("SET_VALUE" . 680190) ("SHOW" . 680199) ("TABLE_BLANK" . 991014) ("TABLE_DISJOINT_SELECTION" . 987414) ("TABLE_XSIZE" . 895238) ("TABLE_YSIZE" . 895244) ("TIMER" . 680201) ("TLB_GET_OFFSET" . 680204) ("TLB_GET_SIZE" . 680206) ("TLB_ICONIFY_EVENTS" . 984722) ("TLB_KILL_REQUEST_EVENTS" . 192837) ("TLB_MOVE_EVENTS" . 984735) ("TLB_SET_TITLE" . 680208) ("TLB_SET_XOFFSET" . 680210) ("TLB_SET_YOFFSET" . 680212) ("TLB_SIZE_EVENTS" . 984752) ("TOOLTIP" . 982093) ("TRACKING_EVENTS" . 58183) ("UNITS" . 895316) ("UPDATE" . 680214) ("USE_TABLE_SELECT" . 934621) ("USE_TEXT_SELECT" . 192856) ("X_BITMAP_EXTRA" . 680216) ("XOFFSET" . 58269) ("XSIZE" . 58220) ("YOFFSET" . 58279) ("YSIZE" . 58221)))
    ("WIDGET_DISPLAYCONTEXTMENU" pro nil (system) "%s, Parent, X, Y, ContextBase_ID" ("W13.html"))
    ("WINDOW" pro nil (system) "%s [, Window_Index]" ("W25.html" ("COLORS" . 896410) ("FREE" . 680620) ("PIXMAP" . 680622) ("RETAIN" . 680624) ("TITLE" . 680625) ("XPOS" . 680628) ("XSIZE" . 680635) ("YPOS" . 680633) ("YSIZE" . 680637)))
    ("WRITE_BMP" pro nil (system) "%s, Filename, Image[, R, G, B]" ("W26.html" ("FOUR_BIT" . 756441) ("HEADER_DEFINE" . 756447) ("IHDR" . 756444) ("RGB" . 964751)))
    ("WRITE_IMAGE" pro nil (system) "%s, Filename, Format, Data [, Red, Green, Blue]" ("W27.html" ("APPEND" . 961233)))
    ("WRITE_JPEG" pro nil (system) "%s [, Filename] , Image" ("W28.html" ("ORDER" . 279735) ("PROGRESSIVE" . 912025) ("QUALITY" . 279736) ("TRUE" . 279737) ("UNIT" . 896438)))
    ("WRITE_NRIF" pro nil (system) "%s, File, Image [, R, G, B]" ("W29.html"))
    ("WRITE_PICT" pro nil (system) "%s, Filename [, Image, R, G, B]" ("W30.html"))
    ("WRITE_PNG" pro nil (system) "%s, Filename, Image[, R, G, B]" ("W31.html" ("ORDER" . 950656) ("TRANSPARENT" . 950659) ("VERBOSE" . 964556)))
    ("WRITE_PPM" pro nil (system) "%s, Filename, Image" ("W32.html" ("ASCII" . 67923)))
    ("WRITE_SPR" pro nil (system) "%s, AS, Filename" ("W33.html"))
    ("WRITE_SRF" pro nil (system) "%s, Filename [, Image, R, G, B]" ("W34.html" ("ORDER" . 756556) ("WRITE_32" . 756559)))
    ("WRITE_TIFF" pro nil (system) "%s, Filename [, Image]" ("W36.html" ("APPEND" . 945440) ("BITS_PER_SAMPLE" . 945448) ("BLUE" . 960346) ("COMPRESSION" . 972526) ("FLOAT" . 945539) ("GEOTIFF" . 945456) ("GREEN" . 960346) ("LONG" . 945853) ("ORIENTATION" . 972561) ("PLANARCONFIG" . 896473) ("RED" . 960346) ("SHORT" . 945559) ("UNITS" . 960431) ("VERBOSE" . 972627) ("XRESOL" . 896478) ("YRESOL" . 917320)))
    ("WRITE_WAV" pro nil (system) "%s, Filename, Data, Rate" ("W37.html"))
    ("WRITE_WAVE" pro nil (system) "%s, File, Array" ("W38.html" ("BIN" . 756580) ("DATANAME" . 756583) ("MESHNAME" . 756586) ("NOMESHDEF" . 756589) ("VECTOR" . 756592)))
    ("WRITEU" pro nil (system) "%s, Unit, Expr1 ..., Exprn" ("W39.html" ("TRANSFER_COUNT" . 680669)))
    ("WSET" pro nil (system) "%s [, Window_Index]" ("W40.html"))
    ("WSHOW" pro nil (system) "%s [, Window_Index [, Show]]" ("W41.html" ("ICONIC" . 680709)))
    ("WV_APPLET" pro nil (system) "%s [, Input]" ("ref.html" ("ARRAY" . 1004583) ("GROUP_LEADER" . 1004841) ("NO_SPLASH" . 1004848) ("TOOLS" . 1004856) ("WAVELETS" . 1005269)))
    ("WV_IMPORT_DATA" pro nil (system) "%s, Data" ("ref13.html" ("MESSAGE_OUT" . 1006957) ("PARENT" . 1008033)))
    ("WV_IMPORT_WAVELET" pro nil (system) "%s [, Wavelet]" ("ref14.html" ("RESET" . 1007019)))
    ("XBM_EDIT" pro nil (system) "%s" ("X.html" ("BLOCK" . 937479) ("FILENAME" . 762711) ("GROUP" . 762714) ("XSIZE" . 762717) ("YSIZE" . 762720)))
    ("XDISPLAYFILE" pro nil (system) "%s, Filename" ("X2.html" ("BLOCK" . 937490) ("DONE_BUTTON" . 960338) ("EDITABLE" . 960341) ("FONT" . 960336) ("GROUP" . 762749) ("HEIGHT" . 762752) ("MODAL" . 933305) ("TEXT" . 762755) ("TITLE" . 762758) ("WIDTH" . 762761) ("WTEXT" . 960359)))
    ("XDXF" pro nil (system) "%s [, Filename]" ("X3.html" ("BLOCK" . 976345) ("GROUP" . 976354) ("SCALE" . 976358) ("TEST" . 976360)))
    ("XINTERANIMATE" pro nil (system) "%s [, Rate]" ("X5.html" ("BLOCK" . 964691) ("CLOSE" . 894369) ("CYCLE" . 894339) ("FRAME" . 894353) ("GROUP" . 964285) ("IMAGE" . 894356) ("KEEP_PIXMAPS" . 894375) ("MODAL" . 964292) ("MPEG_BITRATE" . 964699) ("MPEG_CLOSE" . 941497) ("MPEG_FILENAME" . 934000) ("MPEG_IFRAME_GAP" . 964723) ("MPEG_MOTION_VEC_LENGTH" . 964730) ("MPEG_OPEN" . 934051) ("MPEG_QUALITY" . 964762) ("ORDER" . 894359) ("SET" . 894336) ("SHOWLOAD" . 894342) ("TITLE" . 894348) ("TRACK" . 894345) ("WINDOW" . 894362) ("XOFFSET" . 894378) ("YOFFSET" . 894381)))
    ("XLOADCT" pro nil (system) "%s" ("X6.html" ("BLOCK" . 937520) ("BOTTOM" . 937526) ("FILE" . 937512) ("GROUP" . 959363) ("MODAL" . 930516) ("NCOLORS" . 930518) ("SILENT" . 761913) ("UPDATECALLBACK" . 950093) ("UPDATECBDATA" . 950095) ("USE_CURENT") ("USE_CURRENT" . 761916)))
    ("XMANAGER" pro nil (system) "%s [, Name, ID]" ("X7.html" ("BACKGROUND" . 762790) ("CATCH" . 919187) ("CLEANUP" . 762794) ("EVENT_HANDLER" . 762797) ("GROUP_LEADER" . 762800) ("JUST_REG" . 762804) ("NO_BLOCK" . 921241)))
    ("XMNG_TMPL" pro nil (system) "%s" ("X8.html" ("BLOCK" . 937533) ("GROUP" . 762854)))
    ("XMTOOL" pro nil (system) "%s" ("X9.html" ("BLOCK" . 937544) ("GROUP" . 762874)))
    ("XOBJVIEW" pro nil (system) "%s, Obj" ("X10.html" ("BACKGROUND" . 956927) ("BLOCK" . 964889) ("DOUBLE_VIEW" . 956930) ("GROUP" . 960389) ("JUST_REG" . 959168) ("MODAL" . 988927) ("REFRESH" . 959524) ("RENDERER" . 980622) ("SCALE" . 969430) ("STATIONARY" . 959520) ("TEST" . 959458) ("TITLE" . 959454) ("TLB" . 964851) ("XOFFSET" . 959432) ("XSIZE" . 1000024) ("YOFFSET" . 973883) ("YSIZE" . 1000026)))
    ("XOBJVIEW_ROTATE" pro nil (system) "%s, Axis, Angle" ("X11.html" ("PREMULTIPLY" . 984371)))
    ("XOBJVIEW_WRITE_IMAGE" pro nil (system) "%s, Filename, Format" ("X12.html" ("DIMENSIONS" . 984402)))
    ("XPALETTE" pro nil (system) "%s" ("X13.html" ("BLOCK" . 937555) ("GROUP" . 761941) ("UPDATECALLBACK" . 949914) ("UPDATECBDATA" . 949916)))
    ("XPCOLOR" pro nil (system) "%s" ("X14.html" ("GROUP" . 976510)))
    ("XPLOT3D" pro nil (system) "%s, X, Y, Z" ("X15.html" ("BLOCK" . 976543) ("COLOR" . 976552) ("DOUBLE_VIEW" . 976554) ("GROUP" . 976556) ("LINESTYLE" . 976558) ("MODAL" . 976571) ("NAME" . 976577) ("OVERPLOT" . 976579) ("SYMBOL" . 976581) ("TEST" . 976583) ("THICK" . 976585) ("TITLE" . 976587) ("XRANGE" . 976589) ("XTITLE" . 976595) ("YRANGE" . 976591) ("YTITLE" . 976597) ("ZRANGE" . 976593) ("ZTITLE" . 976599)))
    ("XROI" pro nil (system) "%s [, ImageData] [, R] [, G] [, B]" ("X17.html" ("BLOCK" . 984509) ("FLOATING" . 984515) ("GROUP" . 984518) ("MODAL" . 984520) ("REGIONS_IN" . 984522) ("REGIONS_OUT" . 984530) ("REJECTED" . 984535) ("RENDERER" . 984540) ("ROI_COLOR" . 984544) ("ROI_GEOMETRY" . 984546) ("ROI_SELECT_COLOR" . 984572) ("STATISTICS" . 984574) ("TITLE" . 984608) ("TOOLS" . 984610) ("X_SCROLL_SIZE" . 999474) ("Y_SCROLL_SIZE" . 999479)))
    ("XSURFACE" pro nil (system) "%s, Data" ("X19.html" ("BLOCK" . 937566) ("GROUP" . 787853)))
    ("XVAREDIT" pro nil (system) "%s, Var" ("X20.html" ("GROUP" . 759115) ("NAME" . 917618) ("X_SCROLL_SIZE" . 917623) ("Y_SCROLL_SIZE" . 917633)))
    ("XVOLUME" pro nil (system) "%s, Vol" ("X21.html" ("BLOCK" . 977093) ("GROUP" . 977102) ("INTERPOLATE" . 977104) ("MODAL" . 977106) ("RENDERER" . 977112) ("REPLACE" . 977116) ("SCALE" . 977121) ("TEST" . 977123) ("XSIZE" . 977128) ("YSIZE" . 977130)))
    ("XVOLUME_ROTATE" pro nil (system) "%s, Axis, Angle" ("X22.html" ("PREMULTIPLY" . 977322)))
    ("XVOLUME_WRITE_IMAGE" pro nil (system) "%s, Filename, Format" ("X23.html" ("DIMENSIONS" . 977402)))
    ("XYOUTS" pro nil (system) "%s, [X, Y,] String" ("X24.html" ("ALIGNMENT" . 680731) ("CHARSIZE" . 680733) ("CHARTHICK" . 680735) ("TEXT_AXES" . 680737) ("WIDTH" . 680739)) ("graphkeyw2.html" ("CLIP" . 315949) ("COLOR" . 315952) ("DATA" . 315961) ("DEVICE" . 315977) ("FONT" . 331795) ("NOCLIP" . 323508) ("NORMAL" . 315963) ("ORIENTATION" . 315964) ("T3D" . 315956) ("Z" . 332658)))
    ("ZOOM" pro nil (system) "%s" ("Z.html" ("CONTINUOUS" . 787879) ("FACT" . 787882) ("INTERP" . 787885) ("KEEP" . 787888) ("NEW_WINDOW" . 787891) ("XSIZE" . 787894) ("YSIZE" . 787897) ("ZOOM_WINDOW" . 787900)))
    ("ZOOM_24" pro nil (system) "%s" ("Z2.html" ("FACT" . 787920) ("RIGHT" . 787923) ("XSIZE" . 787926) ("YSIZE" . 787929)))
    ("A_CORRELATE" fun nil (system) "Result = %s(X, Lag)" ("A.html" ("COVARIANCE" . 54405) ("DOUBLE" . 826748)))
    ("ABS" fun nil (system) "Result = %s(X)" ("A2.html") ("tpoolkeyw2.html" ("TPOOL_MAX_ELTS" . 333417) ("TPOOL_MIN_ELTS" . 333286) ("TPOOL_NOTHREAD" . 333289)))
    ("ACOS" fun nil (system) "Result = %s(X)" ("A3.html") ("tpoolkeyw2.html" ("TPOOL_MAX_ELTS" . 333417) ("TPOOL_MIN_ELTS" . 333286) ("TPOOL_NOTHREAD" . 333289)))
    ("ADAPT_HIST_EQUAL" fun nil (system) "Result = %s (Image)" ("A4.html" ("CLIP" . 985045) ("FCN" . 987804) ("NREGIONS" . 985047) ("TOP" . 985049)))
    ("ALOG" fun nil (system) "Result = %s(X)" ("A5.html") ("tpoolkeyw2.html" ("TPOOL_MAX_ELTS" . 333417) ("TPOOL_MIN_ELTS" . 333286) ("TPOOL_NOTHREAD" . 333289)))
    ("ALOG10" fun nil (system) "Result = %s(X)" ("A6.html") ("tpoolkeyw2.html" ("TPOOL_MAX_ELTS" . 333417) ("TPOOL_MIN_ELTS" . 333286) ("TPOOL_NOTHREAD" . 333289)))
    ("AMOEBA" fun nil (system) "Result = %s( Ftol)" ("A7.html" ("FUNCTION_NAME" . 864079) ("FUNCTION_VALUE" . 864085) ("NCALLS" . 864089) ("NMAX" . 864091) ("P0" . 864094) ("SCALE" . 864103) ("SIMPLEX" . 864424)))
    ("ARG_PRESENT" fun nil (system) "Result = %s(Variable)" ("A9.html"))
    ("ARRAY_EQUAL" fun nil (system) "Result = %s( Op1 , Op2)" ("A10.html" ("NO_TYPECONV" . 987069)))
    ("ASCII_TEMPLATE" fun nil (system) "Result = %s( [Filename])" ("A12.html" ("BROWSE_LINES" . 871007) ("CANCEL" . 871139) ("GROUP" . 884032)))
    ("ASIN" fun nil (system) "Result = %s(X)" ("A13.html") ("tpoolkeyw2.html" ("TPOOL_MAX_ELTS" . 333417) ("TPOOL_MIN_ELTS" . 333286) ("TPOOL_NOTHREAD" . 333289)))
    ("ASSOC" fun nil (system) "Result = %s( Unit, Array_Structure [, Offset])" ("A14.html" ("PACKED" . 906241)))
    ("ATAN" fun nil (system) "Result = %s([Y,] X)" ("A15.html" ("PHASE" . 995606)) ("tpoolkeyw2.html" ("TPOOL_MAX_ELTS" . 333417) ("TPOOL_MIN_ELTS" . 333286) ("TPOOL_NOTHREAD" . 333289)))
    ("BESELI" fun nil (system) "Result = %s(X, N)" ("B3.html" ("DOUBLE" . 998579) ("ITER" . 998584)))
    ("BESELJ" fun nil (system) "Result = %s(X, N)" ("B4.html" ("DOUBLE" . 998704) ("ITER" . 998706)))
    ("BESELK" fun nil (system) "Result = %s( X, N)" ("B5.html" ("DOUBLE" . 998712) ("ITER" . 998714)))
    ("BESELY" fun nil (system) "Result = %s(X, N)" ("B6.html" ("DOUBLE" . 998720) ("ITER" . 998722)))
    ("BETA" fun nil (system) "Result = %s( Z, W)" ("B7.html" ("DOUBLE" . 50234)) ("tpoolkeyw2.html" ("TPOOL_MAX_ELTS" . 333417) ("TPOOL_MIN_ELTS" . 333286) ("TPOOL_NOTHREAD" . 333289)))
    ("BILINEAR" fun nil (system) "Result = %s(P, IX, JY)" ("B8.html"))
    ("BIN_DATE" fun nil (system) "Result = %s(Ascii_Time)" ("B9.html"))
    ("BINARY_TEMPLATE" fun nil (system) "Result = %s ( [Filename])" ("B10.html" ("CANCEL" . 985257) ("GROUP" . 985259) ("N_ROWS" . 985261) ("TEMPLATE" . 988405)))
    ("BINDGEN" fun nil (system) "Result = %s(D1 [, ...,D8])" ("B11.html") ("tpoolkeyw2.html" ("TPOOL_MAX_ELTS" . 333417) ("TPOOL_MIN_ELTS" . 333286) ("TPOOL_NOTHREAD" . 333289)))
    ("BINOMIAL" fun nil (system) "Result = %s(V, N, P)" ("B12.html" ("DOUBLE" . 988094) ("GAUSSIAN" . 988097)))
    ("BLK_CON" fun nil (system) "Result = %s( Filter, Signal)" ("B14.html" ("B_LENGTH" . 749505) ("DOUBLE" . 987871)))
    ("BROYDEN" fun nil (system) "Result = %s( X, Vecfunc)" ("B18.html" ("CHECK" . 50283) ("DOUBLE" . 50286) ("EPS" . 50289) ("ITMAX" . 989330) ("STEPMAX" . 50292) ("TOLF" . 50295) ("TOLMIN" . 50298) ("TOLX" . 50301)))
    ("BYTARR" fun nil (system) "Result = %s( D1[, ..., D8])" ("B19.html" ("NOZERO" . 675878)))
    ("BYTE" fun nil (system) "Result = %s( Expression[, Offset [, D1[, ..., D8]]] )" ("B20.html") ("tpoolkeyw2.html" ("TPOOL_MAX_ELTS" . 333417) ("TPOOL_MIN_ELTS" . 333286) ("TPOOL_NOTHREAD" . 333289)))
    ("BYTSCL" fun nil (system) "Result = %s( Array)" ("B22.html" ("MAX" . 675964) ("MIN" . 675966) ("NAN" . 47179) ("TOP" . 675968)) ("tpoolkeyw2.html" ("TPOOL_MAX_ELTS" . 333417) ("TPOOL_MIN_ELTS" . 333286) ("TPOOL_NOTHREAD" . 333289)))
    ("C_CORRELATE" fun nil (system) "Result = %s( X, Y, Lag)" ("C.html" ("COVARIANCE" . 54458) ("DOUBLE" . 826756)))
    ("CALL_EXTERNAL" fun nil (system) "Result = %s(Image, Entry [, P0, ..., PN-1])" ("C4.html" ("ALL_VALUE" . 905908) ("AUTO_GLUE" . 1025677) ("B_VALUE" . 951311) ("CC" . 1012394) ("CDECL" . 905911) ("COMPILE_DIRECTORY" . 1012398) ("D_VALUE" . 905920) ("EXTRA_CFLAGS" . 1012436) ("EXTRA_LFLAGS" . 1012440) ("F_VALUE" . 905923) ("I_VALUE" . 905926) ("IGNORE_EXISTING_GLUE" . 1012444) ("L64_VALUE" . 951332) ("LD" . 1012449) ("NOCLEANUP" . 1012453) ("RETURN_TYPE" . 1029187) ("S_VALUE" . 951354) ("SHOW_ALL_OUTPUT" . 1012458) ("UI_VALUE" . 951320) ("UL64_VALUE" . 965882) ("UL_VALUE" . 965879) ("UNLOAD" . 993357) ("VALUE" . 905936) ("VERBOSE" . 1012497) ("WRITE_WRAPPER" . 1029198)))
    ("CALL_FUNCTION" fun nil (system) "Result = %s(Name [, P1, ..., Pn])" ("C5.html"))
    ("CALL_METHOD" fun nil (system) "Result = %s, Name, ObjRef, [, P1, ..., Pn]" ("C6.html"))
    ("CDF_ATTCREATE" fun nil (system) "Result = %s( Id, Attribute_Name)" ("CDF-routines7.html" ("GLOBAL_SCOPE" . 996934) ("VARIABLE_SCOPE" . 996937)))
    ("CDF_ATTEXISTS" fun nil (system) "Result = %s( Id, Attribute [, EntryNum])" ("CDF-routines9.html" ("ZVARIABLE" . 1002462)))
    ("CDF_ATTNUM" fun nil (system) "Result = %s(Id, Attribute_Name)" ("CDF-routines12.html"))
    ("CDF_CREATE" fun nil (system) "Result = %s( Filename, [Dimensions])" ("CDF-routines18.html" ("ALPHAOSF1_DECODING" . 1017799) ("ALPHAOSF1_ENCODING" . 997337) ("ALPHAVMSD_DECODING" . 1017802) ("ALPHAVMSD_ENCODING" . 997340) ("ALPHAVMSG_DECODING" . 1017805) ("ALPHAVMSG_ENCODING" . 997343) ("CLOBBER" . 1017643) ("COL_MAJOR" . 1017646) ("DECSTATION_DECODING" . 1017808) ("DECSTATION_ENCODING" . 1017778) ("HOST_DECODING" . 1017811) ("HOST_ENCODING" . 997349) ("HP_DECODING" . 1017814) ("HP_ENCODING" . 997352) ("IBMPC_DECODING" . 1017817) ("IBMPC_ENCODING" . 1017767) ("IBMRS_DECODING" . 1017820) ("IBMRS_ENCODING" . 997355) ("MAC_DECODING" . 1017823) ("MAC_ENCODING" . 997367) ("MULTI_FILE" . 1017715) ("NETWORK_DECODING" . 1017826) ("NETWORK_ENCODING" . 997378) ("NEXT_DECODING" . 1017829) ("NEXT_ENCODING" . 997381) ("ROW_MAJOR" . 1017746) ("SGI_DECODING" . 1017832) ("SGI_ENCODING" . 1017789) ("SINGLE_FILE" . 1017749) ("SUN_DECODING" . 1017835) ("SUN_ENCODING" . 997390)))
    ("CDF_ENCODE_EPOCH" fun nil (system) "Result = %s(Epoch)" ("CDF-routines21.html" ("EPOCH" . 997448)))
    ("CDF_ERROR" fun nil (system) "Result = %s(Status)" ("CDF-routines23.html"))
    ("CDF_EXISTS" fun nil (system) "Result = %s( )" ("CDF-routines24.html"))
    ("CDF_INQUIRE" fun nil (system) "Result = %s(Id)" ("CDF-routines25.html"))
    ("CDF_OPEN" fun nil (system) "Result = %s(Filename)" ("CDF-routines27.html"))
    ("CDF_PARSE_EPOCH" fun nil (system) "Result = %s(Epoch_string)" ("CDF-routines28.html"))
    ("CDF_VARCREATE" fun nil (system) "Result = %s( Id, Name [, DimVary])" ("CDF-routines29.html" ("ALLOCATERECS" . 997736) ("CDF_BYTE") ("CDF_CHAR") ("CDF_DOUBLE") ("CDF_EPOCH") ("CDF_FLOAT") ("CDF_INT1") ("CDF_INT2") ("CDF_INT4") ("CDF_REAL4") ("CDF_REAL8") ("CDF_UCHAR") ("CDF_UINT1") ("CDF_UINT2") ("CDF_UINT4") ("DIMENSIONS" . 997739) ("NUMELEM" . 997744) ("REC_NOVARY" . 997747) ("REC_VARY" . 997750) ("ZVARIABLE" . 997753)))
    ("CDF_VARINQ" fun nil (system) "Result = %s( Id, Variable)" ("CDF-routines33.html" ("ZVARIABLE" . 997944)))
    ("CDF_VARNUM" fun nil (system) "Result = %s( Id, VarName [, IsZVar] )" ("CDF-routines34.html"))
    ("CEIL" fun nil (system) "Result = %s(X)" ("C11.html" ("L64" . 1015251)) ("tpoolkeyw2.html" ("TPOOL_MAX_ELTS" . 333417) ("TPOOL_MIN_ELTS" . 333286) ("TPOOL_NOTHREAD" . 333289)))
    ("CHEBYSHEV" fun nil (system) "Result = %s(D, N)" ("C12.html"))
    ("CHECK_MATH" fun nil (system) "Result = %s()" ("C13.html" ("MASK" . 993110) ("NOCLEAR" . 993190) ("PRINT" . 993188)))
    ("CHISQR_CVF" fun nil (system) "Result = %s(P, Df)" ("C14.html"))
    ("CHISQR_PDF" fun nil (system) "Result = %s(V, Df)" ("C15.html"))
    ("CHOLSOL" fun nil (system) "Result = %s( A, P, B)" ("C17.html" ("DOUBLE" . 50387)))
    ("CINDGEN" fun nil (system) "Result = %s(D1[, ..., D8])" ("C18.html") ("tpoolkeyw2.html" ("TPOOL_MAX_ELTS" . 333417) ("TPOOL_MIN_ELTS" . 333286) ("TPOOL_NOTHREAD" . 333289)))
    ("CLUST_WTS" fun nil (system) "Result = %s( Array)" ("C21.html" ("DOUBLE" . 862498) ("N_CLUSTERS" . 862487) ("N_ITERATIONS" . 862488) ("VARIABLE_WTS" . 862545)))
    ("CLUSTER" fun nil (system) "Result = %s( Array, Weights)" ("C22.html" ("DOUBLE" . 862580) ("N_CLUSTERS" . 862583)))
    ("COLOR_QUAN" fun nil (system) "Result = %s( Image_R, Image_G, Image_B, R, G, B) or Result = COLOR_QUAN( Image, Dim, R, G, B )" ("C24.html" ("COLORS" . 676177) ("CUBE" . 676179) ("DITHER" . 676181) ("ERROR" . 676183) ("GET_TRANSLATION" . 676185) ("MAP_ALL" . 676187) ("TRANSLATION" . 676189)))
    ("COLORMAP_APPLICABLE" fun nil (system) "Result = %s( redrawRequired )" ("C25.html"))
    ("COMFIT" fun nil (system) "Result = %s( X, Y, A)" ("C26.html" ("EXPONENTIAL" . 53208) ("GEOMETRIC" . 838932) ("GOMPERTZ" . 838937) ("HYPERBOLIC" . 838944) ("LOGISTIC" . 838961) ("LOGSQUARE" . 838970) ("SIGMA" . 838980) ("WEIGHTS" . 53265) ("YFIT" . 53268)))
    ("COMPLEX" fun nil (system) "Result = %s( Real [, Imaginary])" ("C29.html" ("DOUBLE" . 1041956)) ("tpoolkeyw2.html" ("TPOOL_MAX_ELTS" . 333417) ("TPOOL_MIN_ELTS" . 333286) ("TPOOL_NOTHREAD" . 333289)))
    ("COMPLEXARR" fun nil (system) "Result = %s( D1[, ..., D8])" ("C30.html" ("NOZERO" . 676236)))
    ("COMPLEXROUND" fun nil (system) "Result = %s(Input)" ("C31.html"))
    ("COMPUTE_MESH_NORMALS" fun nil (system) "Result = %s( fVerts[, iConn] )" ("C32.html"))
    ("COND" fun nil (system) "Result = %s( A)" ("C33.html" ("DOUBLE" . 749542) ("LNORM" . 1042001)))
    ("CONGRID" fun nil (system) "Result = %s( Array, X, Y, Z)" ("C34.html" ("CENTER" . 757848) ("CUBIC" . 1042041) ("INTERP" . 757851) ("MINUS_ONE" . 757854)))
    ("CONJ" fun nil (system) "Result = %s(X)" ("C35.html") ("tpoolkeyw2.html" ("TPOOL_MAX_ELTS" . 333417) ("TPOOL_MIN_ELTS" . 333286) ("TPOOL_NOTHREAD" . 333289)))
    ("CONVERT_COORD" fun nil (system) "Result = %s( X [, Y [, Z]])" ("C39.html" ("DATA" . 676377) ("DEVICE" . 676379) ("DOUBLE" . 1015017) ("NORMAL" . 676381) ("T3D" . 676383) ("TO_DATA" . 676385) ("TO_DEVICE" . 676387) ("TO_NORMAL" . 676389)))
    ("CONVOL" fun nil (system) "Result = %s( Array, Kernel [, Scale_Factor])" ("C40.html" ("CENTER" . 676409) ("EDGE_TRUNCATE" . 746326) ("EDGE_WRAP" . 228821) ("MISSING" . 1028668) ("NAN" . 1028683)) ("tpoolkeyw2.html" ("TPOOL_MAX_ELTS" . 333417) ("TPOOL_MIN_ELTS" . 333286) ("TPOOL_NOTHREAD" . 333289)))
    ("COORD2TO3" fun nil (system) "Result = %s( Mx, My, Dim, D0 [, PTI] )" ("C41.html"))
    ("CORRELATE" fun nil (system) "Result = %s( X [, Y])" ("C43.html" ("COVARIANCE" . 53307) ("DOUBLE" . 868819)))
    ("COS" fun nil (system) "Result = %s(X)" ("C44.html") ("tpoolkeyw2.html" ("TPOOL_MAX_ELTS" . 333417) ("TPOOL_MIN_ELTS" . 333286) ("TPOOL_NOTHREAD" . 333289)))
    ("COSH" fun nil (system) "Result = %s(X)" ("C45.html") ("tpoolkeyw2.html" ("TPOOL_MAX_ELTS" . 333417) ("TPOOL_MIN_ELTS" . 333286) ("TPOOL_NOTHREAD" . 333289)))
    ("CRAMER" fun nil (system) "Result = %s( A, B)" ("C47.html" ("DOUBLE" . 749607) ("ZERO" . 749609)))
    ("CREATE_STRUCT" fun nil (system) "Result = %s( [Tag1, Value1, ..., Tagn, Valuen] ) or Result = CREATE_STRUCT()" ("C48.html" ("NAME" . 279439)))
    ("CROSSP" fun nil (system) "Result = %s(V1, V2)" ("C50.html"))
    ("CRVLENGTH" fun nil (system) "Result = %s( X, Y)" ("C51.html" ("DOUBLE" . 862840)))
    ("CT_LUMINANCE" fun nil (system) "Result = %s( [R, G, B])" ("C52.html" ("BRIGHT" . 759145) ("DARK" . 759148) ("READ_TABLES" . 759151)))
    ("CTI_TEST" fun nil (system) "Result = %s( Obfreq)" ("C53.html" ("COEFF" . 53357) ("CORRECTED" . 53360) ("CRAMV" . 53363) ("DF" . 53366) ("EXFREQ" . 53369) ("RESIDUAL" . 53372)))
    ("CURVEFIT" fun nil (system) "Result = %s( X, Y, Weights, A [, Sigma])" ("C55.html" ("CHISQ" . 1024958) ("DOUBLE" . 1024093) ("FUNCTION_NAME" . 148399) ("ITER" . 150209) ("ITMAX" . 150211) ("NODERIVATIVE" . 150222) ("TOL" . 150213) ("YERROR" . 1053331)))
    ("CV_COORD" fun nil (system) "Result = %s()" ("C56.html" ("DEGREES" . 756965) ("DOUBLE" . 1025482) ("FROM_CYLIN" . 756968) ("FROM_POLAR" . 756971) ("FROM_RECT" . 756974) ("FROM_SPHERE" . 756977) ("TO_CYLIN" . 756980) ("TO_POLAR" . 756983) ("TO_RECT" . 756986) ("TO_SPHERE" . 756989)))
    ("CVTTOBM" fun nil (system) "Result = %s( Array)" ("C57.html" ("THRESHOLD" . 871509)))
    ("CW_ANIMATE" fun nil (system) "Result = %s( Parent, Sizex, Sizey, Nframes)" ("C58.html" ("NO_KILL" . 853861) ("OPEN_FUNC" . 853864) ("PIXMAPS" . 853868) ("TRACK" . 853871) ("UNAME" . 996617) ("UVALUE" . 853874)))
    ("CW_ARCBALL" fun nil (system) "Result = %s( Parent)" ("C62.html" ("COLORS" . 755064) ("FRAME" . 755074) ("LABEL" . 755077) ("RETAIN" . 755080) ("SIZE" . 755108) ("UNAME" . 996624) ("UPDATE" . 755111) ("UVALUE" . 755114) ("VALUE" . 755117)))
    ("CW_BGROUP" fun nil (system) "Result = %s( Parent, Names)" ("C63.html" ("BUTTON_UVALUE" . 755175) ("COLUMN" . 755178) ("EVENT_FUNC" . 755181) ("EXCLUSIVE" . 755184) ("FONT" . 755187) ("FRAME" . 755190) ("IDS" . 755193) ("LABEL_LEFT" . 755196) ("LABEL_TOP" . 755199) ("MAP" . 755202) ("NO_RELEASE" . 755208) ("NONEXCLUSIVE" . 755205) ("RETURN_ID" . 755211) ("RETURN_INDEX" . 755214) ("RETURN_NAME" . 755217) ("ROW" . 755220) ("SCROLL" . 755223) ("SET_VALUE" . 755226) ("SPACE" . 755230) ("UNAME" . 996707) ("UVALUE" . 755233) ("X_SCROLL_SIZE" . 755245) ("XOFFSET" . 755236) ("XPAD" . 755239) ("XSIZE" . 755242) ("Y_SCROLL_SIZE" . 755257) ("YOFFSET" . 755248) ("YPAD" . 755251) ("YSIZE" . 755254)))
    ("CW_CLR_INDEX" fun nil (system) "Result = %s( Parent)" ("C64.html" ("COLOR_VALUES" . 854099) ("EVENT_FUNC" . 854102) ("FRAME" . 854105) ("LABEL" . 854108) ("NCOLORS" . 854111) ("START_COLOR" . 854114) ("UNAME" . 996631) ("UVALUE" . 854117) ("VALUE" . 854120) ("XSIZE" . 1025090) ("YSIZE" . 854123)))
    ("CW_COLORSEL" fun nil (system) "Result = %s( Parent)" ("C65.html" ("FRAME" . 854194) ("UNAME" . 996638) ("UVALUE" . 854197) ("XOFFSET" . 854200) ("YOFFSET" . 854203)))
    ("CW_DEFROI" fun nil (system) "Result = %s( Draw)" ("C66.html" ("IMAGE_SIZE" . 755439) ("OFFSET" . 755442) ("ORDER" . 755445) ("RESTORE" . 755448) ("ZOOM" . 755451)))
    ("CW_FIELD" fun nil (system) "Result = %s( Parent)" ("C67.html" ("ALL_EVENTS" . 755508) ("COLUMN" . 755511) ("FIELDFONT" . 755514) ("FLOATING" . 755517) ("FONT" . 755520) ("FRAME" . 755523) ("INTEGER" . 755526) ("LONG" . 755529) ("NOEDIT" . 755532) ("RETURN_EVENTS" . 755535) ("ROW" . 755540) ("STRING" . 755543) ("TEXT_FRAME" . 755546) ("TITLE" . 1029040) ("UNAME" . 996600) ("UVALUE" . 755549) ("VALUE" . 755552) ("XSIZE" . 755555) ("YSIZE" . 755558)))
    ("CW_FILESEL" fun nil (system) "Result = %s ( Parent)" ("C68.html" ("FILENAME" . 1001063) ("FILTER" . 1001065) ("FIX_FILTER" . 1001072) ("FRAME" . 1001074) ("IMAGE_FILTER" . 1001076) ("MULTIPLE" . 1001078) ("PATH" . 1001080) ("SAVE" . 1024908) ("UNAME" . 1001082) ("UVALUE" . 1001085) ("WARN_EXIST" . 1024611)))
    ("CW_FORM" fun nil (system) "Result = %s( [Parent,] Desc)" ("C69.html" ("COLUMN" . 141396) ("IDS" . 141399) ("TITLE" . 141402) ("UNAME" . 996652) ("UVALUE" . 141405)))
    ("CW_FSLIDER" fun nil (system) "Result = %s( Parent)" ("C70.html" ("DOUBLE" . 755581) ("DRAG" . 1028998) ("EDIT" . 755584) ("FORMAT" . 755587) ("FRAME" . 755590) ("MAXIMUM" . 755593) ("MINIMUM" . 755596) ("SCROLL" . 218849) ("SUPPRESS_VALUE" . 755599) ("TITLE" . 755602) ("UNAME" . 996664) ("UVALUE" . 755605) ("VALUE" . 755608) ("VERTICAL" . 755611) ("XSIZE" . 755614) ("YSIZE" . 755617)))
    ("CW_LIGHT_EDITOR" fun nil (system) "Result = %s (Parent)" ("C71.html" ("DIRECTION_DISABLED" . 1001420) ("DRAG_EVENTS" . 1001422) ("FRAME" . 1001426) ("GET_VALUE" . 1001463) ("HIDE_DISABLED" . 1001428) ("LIGHT" . 1001430) ("LOCATION_DISABLED" . 1001432) ("SET_VALUE" . 1001465) ("TYPE_DISABLED" . 1001434) ("UNAME" . 1001436) ("UVALUE" . 1001439) ("XRANGE" . 1001441) ("XSIZE" . 1001443) ("YRANGE" . 1001445) ("YSIZE" . 1001447) ("ZRANGE" . 1001449)))
    ("CW_ORIENT" fun nil (system) "Result = %s( Parent)" ("C74.html" ("AX" . 755637) ("AZ" . 755640) ("FRAME" . 755643) ("TITLE" . 755646) ("UNAME" . 996671) ("UVALUE" . 755649) ("XSIZE" . 755652) ("YSIZE" . 755655)))
    ("CW_PALETTE_EDITOR" fun nil (system) "Result = %s (Parent)" ("C75.html" ("DATA" . 1001627) ("FRAME" . 1001629) ("GET_VALUE" . 1079669) ("HISTOGRAM" . 1001631) ("HORIZONTAL" . 1001633) ("SELECTION" . 1001635) ("SET_VALUE" . 1079672) ("UNAME" . 1001637) ("UVALUE" . 1001640) ("XSIZE" . 1001642) ("YSIZE" . 1001644)))
    ("CW_PDMENU" fun nil (system) "Result = %s( Parent, Desc)" ("C78.html" ("COLUMN" . 755708) ("CONTEXT_MENU" . 1025506) ("DELIMITER" . 1042113) ("FONT" . 67046) ("HELP" . 855550) ("IDS" . 860166) ("MBAR" . 855454) ("RETURN_FULL_NAME" . 755726) ("RETURN_ID" . 755717) ("RETURN_INDEX" . 755720) ("RETURN_NAME" . 755723) ("UNAME" . 996678) ("UVALUE" . 755731) ("XOFFSET" . 755734) ("YOFFSET" . 755737)))
    ("CW_RGBSLIDER" fun nil (system) "Result = %s( Parent)" ("C79.html" ("CMY" . 755795) ("COLOR_INDEX" . 755798) ("DRAG" . 755801) ("FRAME" . 755804) ("GRAPHICS_LEVEL" . 755807) ("HLS" . 755810) ("HSV" . 1025517) ("LENGTH" . 755813) ("RGB" . 755816) ("UNAME" . 996685) ("UVALUE" . 755819) ("VALUE" . 755822) ("VERTICAL" . 1025592)))
    ("CW_TMPL" fun nil (system) "Result = %s( Parent)" ("C80.html" ("UNAME" . 996692) ("UVALUE" . 137507)))
    ("CW_ZOOM" fun nil (system) "Result = %s( Parent)" ("C81.html" ("FRAME" . 755848) ("MAX" . 755851) ("MIN" . 755854) ("RETAIN" . 755857) ("SAMPLE" . 755885) ("SCALE" . 755888) ("TRACK" . 755891) ("UNAME" . 996700) ("UVALUE" . 755894) ("X_SCROLL_SIZE" . 755900) ("X_ZSIZE" . 755903) ("XSIZE" . 755897) ("Y_SCROLL_SIZE" . 755909) ("Y_ZSIZE" . 755912) ("YSIZE" . 755906)))
    ("DB_EXISTS" fun nil (system) "status = %s()" ("api2.html"))
    ("DBLARR" fun nil (system) "Result = %s( D1[, ..., D8])" ("D.html" ("NOZERO" . 676487)))
    ("DCINDGEN" fun nil (system) "Result = %s( D1 [, ..., D8 ])" ("D2.html") ("tpoolkeyw2.html" ("TPOOL_MAX_ELTS" . 333417) ("TPOOL_MIN_ELTS" . 333286) ("TPOOL_NOTHREAD" . 333289)))
    ("DCOMPLEX" fun nil (system) "Result = %s( Real [, Imaginary] ) or Result = DCOMPLEX( Expression, Offset [, D1 [, ..., D8]] )" ("D3.html") ("tpoolkeyw2.html" ("TPOOL_MAX_ELTS" . 333417) ("TPOOL_MIN_ELTS" . 333286) ("TPOOL_NOTHREAD" . 333289)))
    ("DCOMPLEXARR" fun nil (system) "Result = %s( D1 [, ..., D8])" ("D4.html" ("NOZERO" . 37699)))
    ("DEFROI" fun nil (system) "Result = %s( Sx, Sy [, Xverts, Yverts])" ("D8.html" ("NOFILL" . 757032) ("NOREGION" . 757029) ("RESTORE" . 757035) ("X0" . 757039) ("Y0" . 757039) ("ZOOM" . 757042)))
    ("DERIV" fun nil (system) "Result = %s([X,] Y)" ("D11.html"))
    ("DERIVSIG" fun nil (system) "Result = %s( [X, Y, Sigx,] Sigy )" ("D12.html"))
    ("DETERM" fun nil (system) "Result = %s( A)" ("D13.html" ("CHECK" . 749767) ("DOUBLE" . 37196) ("ZERO" . 749769)))
    ("DIAG_MATRIX" fun nil (system) "Result = %s(A [, Diag] )" ("D16.html"))
    ("DIALOG_DBCONNECT" fun nil (system) "status = %s(DBobj)" ("api.html" ("DATASOURCE" . 1007548) ("DIALOG_PARENT" . 1007555) ("PASSWORD" . 1007553) ("USER_ID" . 1007551)))
    ("DIALOG_MESSAGE" fun nil (system) "Result = %s( Message_Text)" ("D17.html" ("CANCEL" . 863012) ("DEFAULT_CANCEL" . 863015) ("DEFAULT_NO" . 863018) ("DIALOG_PARENT" . 863021) ("DISPLAY_NAME" . 871724) ("ERROR" . 863025) ("INFORMATION" . 863028) ("QUESTION" . 863031) ("RESOURCE_NAME" . 863035) ("TITLE" . 863041)))
    ("DIALOG_PICKFILE" fun nil (system) "Result = %s()" ("D18.html" ("DIALOG_PARENT" . 907482) ("DIRECTORY" . 951270) ("DISPLAY_NAME" . 907484) ("FILE" . 862313) ("FILTER" . 907329) ("FIX_FILTER" . 907334) ("GET_PATH" . 862316) ("GROUP" . 862319) ("MULTIPLE_FILES" . 907351) ("MUST_EXIST" . 951290) ("PATH" . 907343) ("READ" . 862322) ("RESOURCE_NAME" . 1006308) ("TITLE" . 907359) ("WRITE" . 862325)))
    ("DIALOG_PRINTERSETUP" fun nil (system) "Result = %s( [PrintDestination])" ("D19.html" ("DIALOG_PARENT" . 984460) ("DISPLAY_NAME" . 984463) ("RESOURCE_NAME" . 984466) ("TITLE" . 984469)))
    ("DIALOG_PRINTJOB" fun nil (system) "Result = %s( [PrintDestination])" ("D20.html" ("DIALOG_PARENT" . 863760) ("DISPLAY_NAME" . 870902) ("RESOURCE_NAME" . 870904) ("TITLE" . 870915)))
    ("DIALOG_READ_IMAGE" fun nil (system) "Result = %s ( [Filename])" ("D21.html" ("BLUE" . 986778) ("DIALOG_PARENT" . 986218) ("FILE" . 986220) ("FILTER_TYPE" . 986222) ("FIX_FILTER" . 986226) ("GET_PATH" . 986785) ("GREEN" . 990353) ("IMAGE" . 986228) ("PATH" . 986230) ("QUERY" . 986232) ("RED" . 986234) ("TITLE" . 986240)))
    ("DIALOG_WRITE_IMAGE" fun nil (system) "Result = %s ( Image [, R, G, B])" ("D22.html" ("DIALOG_PARENT" . 986258) ("FILE" . 986260) ("FIX_TYPE" . 986262) ("NOWRITE" . 986264) ("OPTIONS" . 986266) ("PATH" . 986268) ("TITLE" . 986270) ("TYPE" . 986272) ("WARN_EXIST" . 990326)))
    ("DIGITAL_FILTER" fun nil (system) "Result = %s( Flow, Fhigh, A, Nterms)" ("D23.html" ("DOUBLE" . 1002899)))
    ("DILATE" fun nil (system) "Result = %s( Image, Structure [, X0 [, Y0 [, Z0]]])" ("D24.html" ("BACKGROUND" . 984751) ("CONSTRAINED" . 984770) ("GRAY" . 984614) ("PRESERVE_TYPE" . 984778) ("UINT" . 984780) ("ULONG" . 984782) ("VALUES" . 984617)))
    ("DINDGEN" fun nil (system) "Result = %s(D1 [, ..., D8])" ("D25.html") ("tpoolkeyw2.html" ("TPOOL_MAX_ELTS" . 333417) ("TPOOL_MIN_ELTS" . 333286) ("TPOOL_NOTHREAD" . 333289)))
    ("DIST" fun nil (system) "Result = %s(N [, M])" ("D27.html"))
    ("DOUBLE" fun nil (system) "Result = %s(Expression[, Offset [, D1 [, ..., D8]]])" ("D31.html") ("tpoolkeyw2.html" ("TPOOL_MAX_ELTS" . 333417) ("TPOOL_MIN_ELTS" . 333286) ("TPOOL_NOTHREAD" . 333289)))
    ("EIGENQL" fun nil (system) "Result = %s( A)" ("E2.html" ("ABSOLUTE" . 870576) ("ASCENDING" . 862897) ("DOUBLE" . 862899) ("EIGENVECTORS" . 870583) ("OVERWRITE" . 862901) ("RESIDUAL" . 862903)))
    ("EIGENVEC" fun nil (system) "Result = %s( A, Eval)" ("E3.html" ("DOUBLE" . 47356) ("ITMAX" . 47358) ("RESIDUAL" . 47286)))
    ("ELMHES" fun nil (system) "Result = %s( A)" ("E4.html" ("COLUMN" . 983389) ("DOUBLE" . 50601) ("NO_BALANCE" . 50604)))
    ("EOF" fun nil (system) "Result = %s(Unit)" ("E7.html"))
    ("EOS_EH_CONVANG" fun nil (system) "Result = %s(inAngle, code)" ("EOS-routines7.html"))
    ("EOS_EH_GETVERSION" fun nil (system) "Result = %s(fid, version)" ("EOS-routines8.html"))
    ("EOS_EH_IDINFO" fun nil (system) "Result = %s(fid, HDFfid, sdInterfaceID)" ("EOS-routines9.html"))
    ("EOS_EXISTS" fun nil (system) "Result = %s( )" ("EOS-routines10.html"))
    ("EOS_GD_ATTACH" fun nil (system) "Result = %s(fid, gridname)" ("EOS-routines11.html"))
    ("EOS_GD_ATTRINFO" fun nil (system) "Result = %s(gridID, attrname, numbertype, count)" ("EOS-routines12.html"))
    ("EOS_GD_BLKSOMOFFSET" fun nil (system) "Result = %s(gridID, offset, code)" ("EOS-routines13.html"))
    ("EOS_GD_CLOSE" fun nil (system) "Result = %s(fid)" ("EOS-routines14.html"))
    ("EOS_GD_COMPINFO" fun nil (system) "Result = %s(gridID, fieldname, compcode, compparm)" ("EOS-routines15.html"))
    ("EOS_GD_CREATE" fun nil (system) "Result = %s(fid, gridname, xdimsize, ydimsize, upleftpt, lowrightpt)" ("EOS-routines16.html"))
    ("EOS_GD_DEFBOXREGION" fun nil (system) "Result = %s(gridID, cornerlon, cornerlat)" ("EOS-routines17.html"))
    ("EOS_GD_DEFCOMP" fun nil (system) "Result = %s(gridID, compcode [, compparm] )" ("EOS-routines18.html"))
    ("EOS_GD_DEFDIM" fun nil (system) "Result = %s(gridID, dimname, dim)" ("EOS-routines19.html"))
    ("EOS_GD_DEFFIELD" fun nil (system) "Result = %s(gridID, fieldname, dimlist, numbertype)" ("EOS-routines20.html" ("MERGE" . 1030256)))
    ("EOS_GD_DEFORIGIN" fun nil (system) "Result = %s(gridID, origincode)" ("EOS-routines21.html"))
    ("EOS_GD_DEFPIXREG" fun nil (system) "Result = %s(gridID, pixreg)" ("EOS-routines22.html"))
    ("EOS_GD_DEFPROJ" fun nil (system) "Result = %s(gridID, projcode, zonecode, spherecode, projparm)" ("EOS-routines23.html"))
    ("EOS_GD_DEFTILE" fun nil (system) "Result = %s( gridID, tilecode [, tilerank, tiledims] )" ("EOS-routines24.html"))
    ("EOS_GD_DEFVRTREGION" fun nil (system) "Result = %s(gridID, regionID, vertObj, range)" ("EOS-routines25.html"))
    ("EOS_GD_DETACH" fun nil (system) "Result = %s(gridID)" ("EOS-routines26.html"))
    ("EOS_GD_DIMINFO" fun nil (system) "Result = %s(gridID, dimname)" ("EOS-routines27.html"))
    ("EOS_GD_DUPREGION" fun nil (system) "Result = %s(regionID)" ("EOS-routines28.html"))
    ("EOS_GD_EXTRACTREGION" fun nil (system) "Result = %s(gridID, regionID, fieldname, buffer)" ("EOS-routines29.html"))
    ("EOS_GD_FIELDINFO" fun nil (system) "Result = %s(gridID, fieldname, rank, dims, numbertype, dimlist)" ("EOS-routines30.html"))
    ("EOS_GD_GETFILLVALUE" fun nil (system) "Result = %s(gridID, fieldname, fillvalue)" ("EOS-routines31.html"))
    ("EOS_GD_GETPIXELS" fun nil (system) "Result = %s(gridID, nLonLat, lonVal, latVal, pixRow, pixCol)" ("EOS-routines32.html"))
    ("EOS_GD_GETPIXVALUES" fun nil (system) "Result = %s(gridID, nPixels, pixCol, pixRow, fieldname, buffer)" ("EOS-routines33.html"))
    ("EOS_GD_GRIDINFO" fun nil (system) "Result = %s(gridID, xdimsize, ydimsize, upleft, lowright)" ("EOS-routines34.html"))
    ("EOS_GD_INQATTRS" fun nil (system) "Result = %s( gridID, attrlist)" ("EOS-routines35.html" ("LENGTH" . 1030732)))
    ("EOS_GD_INQDIMS" fun nil (system) "Result = %s(gridID, dimname, dims)" ("EOS-routines36.html"))
    ("EOS_GD_INQFIELDS" fun nil (system) "Result = %s(gridID, fieldlist, rank, numbertype)" ("EOS-routines37.html"))
    ("EOS_GD_INQGRID" fun nil (system) "Result = %s( filename, gridlist)" ("EOS-routines38.html" ("LENGTH" . 1030811)))
    ("EOS_GD_INTERPOLATE" fun nil (system) "Result = %s(gridID, Interp, lonVal, latVal, fieldname, interpVal)" ("EOS-routines39.html"))
    ("EOS_GD_NENTRIES" fun nil (system) "Result = %s( gridID, entrycode)" ("EOS-routines40.html" ("LENGTH" . 1030866)))
    ("EOS_GD_OPEN" fun nil (system) "Result = %s( filename, access)" ("EOS-routines41.html" ("CREATE" . 1030919) ("RDWR" . 1030921) ("READ" . 1030923)))
    ("EOS_GD_ORIGININFO" fun nil (system) "Result = %s(gridID, origincode)" ("EOS-routines42.html"))
    ("EOS_GD_PIXREGINFO" fun nil (system) "Result = %s(gridID, pixregcode)" ("EOS-routines43.html"))
    ("EOS_GD_PROJINFO" fun nil (system) "Result = %s(gridID, projcode, zonecode, spherecode, projparm)" ("EOS-routines44.html"))
    ("EOS_GD_QUERY" fun nil (system) "Result = %s( Filename, GridName, [Info])" ("EOS-routines45.html"))
    ("EOS_GD_READATTR" fun nil (system) "Result = %s(gridID, attrname, datbuf)" ("EOS-routines46.html"))
    ("EOS_GD_READFIELD" fun nil (system) "Result = %s( gridID, fieldname, buffer)" ("EOS-routines47.html" ("EDGE" . 1031035) ("START" . 1031037) ("STRIDE" . 1031039)))
    ("EOS_GD_READTILE" fun nil (system) "Result = %s(gridID, fieldname, tilecoords, buffer)" ("EOS-routines48.html"))
    ("EOS_GD_REGIONINFO" fun nil (system) "Result = %s(gridID, regionID, fieldname, ntype, rank, dims, size, upleftpt, lowrightpt)" ("EOS-routines49.html"))
    ("EOS_GD_SETFILLVALUE" fun nil (system) "Result = %s(gridID, fieldname, fillvalue)" ("EOS-routines50.html"))
    ("EOS_GD_SETTILECACHE" fun nil (system) "Result = %s(gridID, fieldname, maxcache, cachecode)" ("EOS-routines51.html"))
    ("EOS_GD_TILEINFO" fun nil (system) "Result = %s(gridID, fieldname, tilecode, tilerank, tiledims)" ("EOS-routines52.html"))
    ("EOS_GD_WRITEATTR" fun nil (system) "Result = %s( gridID, attrname, datbuf)" ("EOS-routines53.html" ("COUNT" . 1031201) ("HDF_TYPE" . 1031203)))
    ("EOS_GD_WRITEFIELD" fun nil (system) "Result = %s( gridID, fieldname, data)" ("EOS-routines54.html" ("EDGE" . 1031230) ("START" . 1031232) ("STRIDE" . 1031234)))
    ("EOS_GD_WRITEFIELDMETA" fun nil (system) "Result = %s(gridID, fieldname, dimlist, numbertype)" ("EOS-routines55.html"))
    ("EOS_GD_WRITETILE" fun nil (system) "Result = %s(gridID, fieldname, tilecoords, data)" ("EOS-routines56.html"))
    ("EOS_PT_ATTACH" fun nil (system) "Result = %s(fid, pointname)" ("EOS-routines57.html"))
    ("EOS_PT_ATTRINFO" fun nil (system) "Result = %s( pointID, attrname, numbertype, count)" ("EOS-routines58.html"))
    ("EOS_PT_BCKLINKINFO" fun nil (system) "Result = %s(pointID, level, linkfield)" ("EOS-routines59.html"))
    ("EOS_PT_CLOSE" fun nil (system) "Result = %s(fid)" ("EOS-routines60.html"))
    ("EOS_PT_CREATE" fun nil (system) "Result = %s(fid, pointname)" ("EOS-routines61.html"))
    ("EOS_PT_DEFBOXREGION" fun nil (system) "Result = %s(pointID, cornerlon, cornerlat)" ("EOS-routines62.html"))
    ("EOS_PT_DEFLEVEL" fun nil (system) "Result = %s(pointID, levelname, fieldlist, fieldtype, fieldorder)" ("EOS-routines63.html"))
    ("EOS_PT_DEFLINKAGE" fun nil (system) "Result = %s(pointID, parent, child, linkfield)" ("EOS-routines64.html"))
    ("EOS_PT_DEFTIMEPERIOD" fun nil (system) "Result = %s(pointID, starttime, stoptime)" ("EOS-routines65.html"))
    ("EOS_PT_DEFVRTREGION" fun nil (system) "Result = %s( pointID, regionID, vertObj, range)" ("EOS-routines66.html"))
    ("EOS_PT_DETACH" fun nil (system) "Result = %s(pointID)" ("EOS-routines67.html"))
    ("EOS_PT_EXTRACTPERIOD" fun nil (system) "Result = %s(pointID, periodID, level, fieldlist, buffer)" ("EOS-routines68.html"))
    ("EOS_PT_EXTRACTREGION" fun nil (system) "Result = %s( pointID, regionID, level, fieldlist, buffer)" ("EOS-routines69.html"))
    ("EOS_PT_FWDLINKINFO" fun nil (system) "Result = %s(pointID, level, linkfield)" ("EOS-routines70.html"))
    ("EOS_PT_GETLEVELNAME" fun nil (system) "Result = %s( pointID, level, levelname)" ("EOS-routines71.html" ("LENGTH" . 1017099)))
    ("EOS_PT_GETRECNUMS" fun nil (system) "Result = %s( pointID, inlevel, outlevel, inNrec, inRecs, outNrec, outRecs)" ("EOS-routines72.html"))
    ("EOS_PT_INQATTRS" fun nil (system) "Result = %s( pointID, attrlist)" ("EOS-routines73.html" ("LENGTH" . 1017172)))
    ("EOS_PT_INQPOINT" fun nil (system) "Result = %s( filename, pointlist)" ("EOS-routines74.html" ("LENGTH" . 1017203)))
    ("EOS_PT_LEVELINDX" fun nil (system) "Result = %s( pointID, levelname)" ("EOS-routines75.html"))
    ("EOS_PT_LEVELINFO" fun nil (system) "Result = %s(pointID, level, fieldlist, fldtype, fldorder)" ("EOS-routines76.html"))
    ("EOS_PT_NFIELDS" fun nil (system) "Result = %s( pointID, level)" ("EOS-routines77.html" ("LENGTH" . 1017295)))
    ("EOS_PT_NLEVELS" fun nil (system) "Result = %s(pointID)" ("EOS-routines78.html"))
    ("EOS_PT_NRECS" fun nil (system) "Result = %s( pointID, level)" ("EOS-routines79.html"))
    ("EOS_PT_OPEN" fun nil (system) "Result = %s( fieldname)" ("EOS-routines80.html" ("CREATE" . 1017375) ("RDWR" . 1024341) ("READ" . 1024343)))
    ("EOS_PT_PERIODINFO" fun nil (system) "Result = %s(pointID, periodID, level, fieldlist, size)" ("EOS-routines81.html"))
    ("EOS_PT_PERIODRECS" fun nil (system) "Result = %s(pointID, periodID, level, nrec, recs)" ("EOS-routines82.html"))
    ("EOS_PT_QUERY" fun nil (system) "Result = %s( Filename, PointName, [Info] )" ("EOS-routines83.html"))
    ("EOS_PT_READATTR" fun nil (system) "Result = %s(pointID, attrname, datbuf)" ("EOS-routines84.html"))
    ("EOS_PT_READLEVEL" fun nil (system) "Result = %s(pointID, level, fieldlist, nrec, recs, buffer)" ("EOS-routines85.html"))
    ("EOS_PT_REGIONINFO" fun nil (system) "Result = %s(pointID, regionID, level, fieldlist, size)" ("EOS-routines86.html"))
    ("EOS_PT_REGIONRECS" fun nil (system) "Result = %s(pointID, regionID, level, nrec, recs)" ("EOS-routines87.html"))
    ("EOS_PT_SIZEOF" fun nil (system) "Result = %s(pointID, fieldlist, fldlevel)" ("EOS-routines88.html"))
    ("EOS_PT_UPDATELEVEL" fun nil (system) "Result = %s(pointID, level, field, list, nrec, recs, data)" ("EOS-routines89.html"))
    ("EOS_PT_WRITEATTR" fun nil (system) "Result = %s( pointID, attrname, datbuf)" ("EOS-routines90.html" ("COUNT" . 1017685) ("HDF_TYPE" . 1024378)))
    ("EOS_PT_WRITELEVEL" fun nil (system) "Result = %s(pointID, level, nrec, data)" ("EOS-routines91.html"))
    ("EOS_QUERY" fun nil (system) "Result = %s( Filename, [Info] )" ("EOS-routines92.html"))
    ("EOS_SW_ATTACH" fun nil (system) "Result = %s(fid, swathname)" ("EOS-routines93.html"))
    ("EOS_SW_ATTRINFO" fun nil (system) "Result = %s(swathID, attrname, numbertype, count)" ("EOS-routines94.html"))
    ("EOS_SW_CLOSE" fun nil (system) "Result = %s(fid)" ("EOS-routines95.html"))
    ("EOS_SW_COMPINFO" fun nil (system) "Result = %s(swathID, fieldname, compcode, compparm)" ("EOS-routines96.html"))
    ("EOS_SW_CREATE" fun nil (system) "Result = %s(fid, swathname)" ("EOS-routines97.html"))
    ("EOS_SW_DEFBOXREGION" fun nil (system) "Result = %s(swathID, cornerlon, cornerlat, mode)" ("EOS-routines98.html"))
    ("EOS_SW_DEFCOMP" fun nil (system) "Result = %s( swathID, compcode, [, compparm] )" ("EOS-routines99.html"))
    ("EOS_SW_DEFDATAFIELD" fun nil (system) "Result = %s( swathID, fieldname, dimlist, numbertype)" ("EOS-routines100.html" ("MERGE" . 1017975)))
    ("EOS_SW_DEFDIM" fun nil (system) "Result = %s(swathID, fieldname, dim)" ("EOS-routines101.html"))
    ("EOS_SW_DEFDIMMAP" fun nil (system) "Result = %s(swathID, geodim, datadim, offset, increment)" ("EOS-routines102.html"))
    ("EOS_SW_DEFGEOFIELD" fun nil (system) "Result = %s( swathID, fieldname, dimlist, numbertype)" ("EOS-routines103.html" ("MERGE" . 1022830)))
    ("EOS_SW_DEFIDXMAP" fun nil (system) "Result = %s(swathID, geodim, datadim, index)" ("EOS-routines104.html"))
    ("EOS_SW_DEFTIMEPERIOD" fun nil (system) "Result = %s(swathID, starttime , stoptime, mode)" ("EOS-routines105.html"))
    ("EOS_SW_DEFVRTREGION" fun nil (system) "Result = %s(swathID, regionID, vertObj, range)" ("EOS-routines106.html"))
    ("EOS_SW_DETACH" fun nil (system) "Result = %s(swathID)" ("EOS-routines107.html"))
    ("EOS_SW_DIMINFO" fun nil (system) "Result = %s(swathID, dimname)" ("EOS-routines108.html"))
    ("EOS_SW_DUPREGION" fun nil (system) "Result = %s(regionID)" ("EOS-routines109.html"))
    ("EOS_SW_EXTRACTPERIOD" fun nil (system) "Result = %s(swathID, periodID, fieldname, external_mode, buffer)" ("EOS-routines110.html"))
    ("EOS_SW_EXTRACTREGION" fun nil (system) "Result = %s(swathID, regionID, fieldname, external_mode, buffer)" ("EOS-routines111.html"))
    ("EOS_SW_FIELDINFO" fun nil (system) "Result = %s(swathID, fieldname, rank, dims, numbertype, dimlist)" ("EOS-routines112.html"))
    ("EOS_SW_GETFILLVALUE" fun nil (system) "Result = %s(swathID, fieldname, fillvalue)" ("EOS-routines113.html"))
    ("EOS_SW_IDXMAPINFO" fun nil (system) "Result = %s(swathID, geodim, datadim, index)" ("EOS-routines114.html"))
    ("EOS_SW_INQATTRS" fun nil (system) "Result = %s( swathID, attrlist)" ("EOS-routines115.html" ("LENGTH" . 1018488)))
    ("EOS_SW_INQDATAFIELDS" fun nil (system) "Result = %s(swathID, fieldlist, rank, numbertype)" ("EOS-routines116.html"))
    ("EOS_SW_INQDIMS" fun nil (system) "Result = %s(swathID, dimname, dim)" ("EOS-routines117.html"))
    ("EOS_SW_INQGEOFIELDS" fun nil (system) "Result = %s(swathID, fieldlist, rank, numbertype)" ("EOS-routines118.html"))
    ("EOS_SW_INQIDXMAPS" fun nil (system) "Result = %s(swathID, idxmap, idxsizes)" ("EOS-routines119.html"))
    ("EOS_SW_INQMAPS" fun nil (system) "Result = %s(swathID, dimmap, offset, increment)" ("EOS-routines120.html"))
    ("EOS_SW_INQSWATH" fun nil (system) "Result = %s( filename, swathlist)" ("EOS-routines121.html" ("LENGTH" . 1018674)))
    ("EOS_SW_MAPINFO" fun nil (system) "Result = %s(swathID, geodim, datadim, offset, increment)" ("EOS-routines122.html"))
    ("EOS_SW_NENTRIES" fun nil (system) "Result = %s( swathID, entrycode)" ("EOS-routines123.html" ("LENGTH" . 1018745)))
    ("EOS_SW_OPEN" fun nil (system) "Result = %s( filename)" ("EOS-routines124.html" ("CREATE" . 1018776) ("RDWR" . 1024156) ("READ" . 1024157)))
    ("EOS_SW_PERIODINFO" fun nil (system) "Result = %s(swathID, periodID, fieldname, ntype, rank, dims, size)" ("EOS-routines125.html"))
    ("EOS_SW_QUERY" fun nil (system) "Result=%s(Filename, SwathName, [Info])" ("EOS-routines126.html"))
    ("EOS_SW_READATTR" fun nil (system) "Result = %s(swathID, attrname, datbuf)" ("EOS-routines127.html"))
    ("EOS_SW_READFIELD" fun nil (system) "Result = %s( swathID, fieldname, buffer)" ("EOS-routines128.html" ("EDGE" . 1018883) ("START" . 1024163) ("STRIDE" . 1024164)))
    ("EOS_SW_REGIONINFO" fun nil (system) "Result = %s(swathID, regionID, fieldname, ntype, rank, dims, size)" ("EOS-routines129.html"))
    ("EOS_SW_SETFILLVALUE" fun nil (system) "Result = %s(swathID, fieldname, fillvalue)" ("EOS-routines130.html"))
    ("EOS_SW_WRITEATTR" fun nil (system) "Result = %s( swathID, attrname, datbuf)" ("EOS-routines131.html" ("COUNT" . 1019002) ("HDF_TYPE" . 1024170)))
    ("EOS_SW_WRITEDATAMETA" fun nil (system) "Result = %s(swathID, fieldname, dimlist, numbertype)" ("EOS-routines132.html"))
    ("EOS_SW_WRITEFIELD" fun nil (system) "Result = %s( swathID, fieldname, data)" ("EOS-routines133.html" ("EDGE" . 1026788) ("START" . 1026786) ("STRIDE" . 1025378)))
    ("EOS_SW_WRITEGEOMETA" fun nil (system) "Result = %s(swathID, fieldname, dimlist, numbertype)" ("EOS-routines134.html"))
    ("ERF" fun nil (system) "Result = %s(Z)" ("E9.html") ("tpoolkeyw2.html" ("TPOOL_MAX_ELTS" . 333417) ("TPOOL_MIN_ELTS" . 333286) ("TPOOL_NOTHREAD" . 333289)))
    ("ERFC" fun nil (system) "Result = %s(Z)" ("E10.html") ("tpoolkeyw2.html" ("TPOOL_MAX_ELTS" . 333417) ("TPOOL_MIN_ELTS" . 333286) ("TPOOL_NOTHREAD" . 333289)))
    ("ERFCX" fun nil (system) "Result = %s(Z)" ("E11.html") ("tpoolkeyw2.html" ("TPOOL_MAX_ELTS" . 333417) ("TPOOL_MIN_ELTS" . 333286) ("TPOOL_NOTHREAD" . 333289)))
    ("ERODE" fun nil (system) "Result = %s( Image, Structure [, X0 [, Y0 [, Z0]]])" ("E12.html" ("GRAY" . 989437) ("PRESERVE_TYPE" . 989439) ("UINT" . 989441) ("ULONG" . 989443) ("VALUES" . 989445)))
    ("EXECUTE" fun nil (system) "Result = %s(String [, QuietCompile])" ("E14.html"))
    ("EXP" fun nil (system) "Result = %s(Expression)" ("E16.html") ("tpoolkeyw2.html" ("TPOOL_MAX_ELTS" . 333417) ("TPOOL_MIN_ELTS" . 333286) ("TPOOL_NOTHREAD" . 333289)))
    ("EXPAND_PATH" fun nil (system) "Result = %s( String)" ("E18.html" ("ALL_DIRS" . 987744) ("ARRAY" . 987739) ("COUNT" . 676819) ("DLM" . 987893) ("HELP" . 987895)))
    ("EXPINT" fun nil (system) "Result = %s( N, X)" ("E19.html" ("DOUBLE" . 50644) ("EPS" . 997966) ("ITER" . 997968) ("ITMAX" . 997920)) ("tpoolkeyw2.html" ("TPOOL_MAX_ELTS" . 333417) ("TPOOL_MIN_ELTS" . 333286) ("TPOOL_NOTHREAD" . 333289)))
    ("EXTRAC" fun nil (system) "Result = %s( Array, C1, C2, ..., Cn, S1, S2, ..., Sn )" ("E20.html"))
    ("EXTRACT_SLICE" fun nil (system) "Result = %s( Vol, Xsize, Ysize, Xcenter, Ycenter, Zcenter, Xrot, Yrot, Zrot)" ("E21.html" ("ANISOTROPY" . 985393) ("CUBIC") ("OUT_VAL" . 988206) ("RADIANS" . 758834) ("SAMPLE" . 758840) ("VERTICES" . 985402)))
    ("F_CVF" fun nil (system) "Result = %s(P, Dfn, Dfd)" ("F.html"))
    ("F_PDF" fun nil (system) "Result = %s(V, Dfn, Dfd)" ("F2.html"))
    ("FACTORIAL" fun nil (system) "Result = %s( N)" ("F3.html" ("STIRLING" . 54500) ("UL64" . 880257)))
    ("FFT" fun nil (system) "Result = %s( Array [, Direction])" ("F4.html" ("DIMENSION" . 37862) ("DOUBLE" . 882851) ("INVERSE" . 37868) ("OVERWRITE" . 676843)) ("tpoolkeyw2.html" ("TPOOL_MAX_ELTS" . 333417) ("TPOOL_MIN_ELTS" . 333286) ("TPOOL_NOTHREAD" . 333289)))
    ("FILE_EXPAND_PATH" fun nil (system) "Result = %s (Path)" ("F8.html"))
    ("FILE_INFO" fun nil (system) "Result = %s(Path)" ("F9.html" ("NOEXPAND_PATH" . 883815)))
    ("FILE_LINES" fun nil (system) "Result = %s(Path)" ("F10.html" ("NOEXPAND_PATH" . 906488)))
    ("FILE_READLINK" fun nil (system) "Result = %s(Path)" ("F14.html" ("ALLOW_NONEXISTENT" . 906651) ("ALLOW_NONSYMLINK" . 906653) ("NOEXPAND_PATH" . 906655)))
    ("FILE_SAME" fun nil (system) "Result = %s(Path1, Path2)" ("F15.html" ("NOEXPAND_PATH" . 906717)))
    ("FILE_SEARCH" fun nil (system) "Result = %s(Path_Specification) or Result = FILE_SEARCH(Dir_Specification, Recur_Pattern)" ("F16.html" ("COUNT" . 883932) ("EXPAND_ENVIRONMENT" . 883934) ("EXPAND_TILDE" . 883941) ("FOLD_CASE" . 883947) ("FULLY_QUALIFY_PATH" . 883949) ("ISSUE_ACCESS_ERROR" . 883957) ("MARK_DIRECTORY" . 883959) ("MATCH_ALL_INITIAL_DOT" . 883965) ("MATCH_INITIAL_DOT" . 883967) ("NOSORT" . 883969) ("QUOTE" . 883975) ("TEST_BLOCK_SPECIAL" . 900969) ("TEST_CHARACTER_SPECIAL" . 900971) ("TEST_DANGLING_SYMLINK" . 900973) ("TEST_DIRECTORY" . 883984) ("TEST_EXECUTABLE" . 883986) ("TEST_GROUP" . 900983) ("TEST_NAMED_PIPE" . 900993) ("TEST_READ" . 883991) ("TEST_REGULAR" . 883994) ("TEST_SETGID" . 901003) ("TEST_SETUID" . 901005) ("TEST_SOCKET" . 901015) ("TEST_STICKY_BIT" . 901017) ("TEST_SYMLINK" . 901019) ("TEST_USER" . 901021) ("TEST_WRITE" . 883996) ("TEST_ZERO_LENGTH" . 883999)))
    ("FILE_TEST" fun nil (system) "Result = %s( File)" ("F17.html" ("BLOCK_SPECIAL" . 901098) ("CHARACTER_SPECIAL" . 901108) ("DANGLING_SYMLINK" . 901110) ("DIRECTORY" . 882375) ("EXECUTABLE" . 882377) ("GET_MODE" . 882382) ("GROUP" . 901120) ("NAMED_PIPE" . 901122) ("NOEXPAND_PATH" . 883024) ("READ" . 882391) ("REGULAR" . 882393) ("SETGID" . 901132) ("SETUID" . 901134) ("SOCKET" . 901136) ("STICKY_BIT" . 901143) ("SYMLINK" . 901145) ("USER" . 901152) ("WRITE" . 882395) ("ZERO_LENGTH" . 882397)))
    ("FILE_WHICH" fun nil (system) "Result = %s( [Path, ] File)" ("F18.html" ("INCLUDE_CURRENT_DIR" . 882459)))
    ("FILEPATH" fun nil (system) "Result = %s( Filename)" ("F19.html" ("ROOT_DIR" . 762284) ("SUBDIRECTORY" . 762286) ("TERMINAL" . 762290) ("TMP" . 762292)))
    ("FINDFILE" fun nil (system) "Result = %s( File_Specification)" ("F20.html" ("COUNT" . 676868)))
    ("FINDGEN" fun nil (system) "Result = %s(D1 [, ..., D8])" ("F21.html") ("tpoolkeyw2.html" ("TPOOL_MAX_ELTS" . 333417) ("TPOOL_MIN_ELTS" . 333286) ("TPOOL_NOTHREAD" . 333289)))
    ("FINITE" fun nil (system) "Result = %s( X)" ("F22.html" ("INFINITY" . 862771) ("NAN" . 862772) ("SIGN" . 887616)) ("tpoolkeyw2.html" ("TPOOL_MAX_ELTS" . 333417) ("TPOOL_MIN_ELTS" . 333286) ("TPOOL_NOTHREAD" . 333289)))
    ("FIX" fun nil (system) "Result = %s( Expression [, Offset [, D1 [, ..., D8]]])" ("F23.html" ("PRINT" . 871518) ("TYPE" . 871524)) ("tpoolkeyw2.html" ("TPOOL_MAX_ELTS" . 333417) ("TPOOL_MIN_ELTS" . 333286) ("TPOOL_NOTHREAD" . 333289)))
    ("FLOAT" fun nil (system) "Result = %s( Expression [, Offset [, D1 [, ..., D8]]] )" ("F25.html") ("tpoolkeyw2.html" ("TPOOL_MAX_ELTS" . 333417) ("TPOOL_MIN_ELTS" . 333286) ("TPOOL_NOTHREAD" . 333289)))
    ("FLOOR" fun nil (system) "Result = %s(X)" ("F26.html" ("L64" . 875894)) ("tpoolkeyw2.html" ("TPOOL_MAX_ELTS" . 333417) ("TPOOL_MIN_ELTS" . 333286) ("TPOOL_NOTHREAD" . 333289)))
    ("FLTARR" fun nil (system) "Result = %s( D1 [, ..., D8])" ("F28.html" ("NOZERO" . 676947)))
    ("FORMAT_AXIS_VALUES" fun nil (system) "Result = %s( Values )" ("F31.html"))
    ("FSTAT" fun nil (system) "Result = %s(Unit)" ("F34.html"))
    ("FULSTR" fun nil (system) "Result = %s(A)" ("F35.html"))
    ("FV_TEST" fun nil (system) "Result = %s(X, Y)" ("F38.html"))
    ("FX_ROOT" fun nil (system) "Result = %s(X, Func)" ("F39.html" ("DOUBLE" . 749893) ("ITMAX" . 749897) ("STOP" . 749899) ("TOL" . 749901)))
    ("FZ_ROOTS" fun nil (system) "Result = %s(C)" ("F40.html" ("DOUBLE" . 52525) ("EPS" . 902541) ("NO_POLISH" . 902543)))
    ("GAMMA" fun nil (system) "Result = %s(Z)" ("G.html") ("tpoolkeyw2.html" ("TPOOL_MAX_ELTS" . 333417) ("TPOOL_MIN_ELTS" . 333286) ("TPOOL_NOTHREAD" . 333289)))
    ("GAUSS2DFIT" fun nil (system) "Result = %s( Z, A [, X, Y])" ("G5.html" ("NEGATIVE" . 199709) ("TILT" . 199711)))
    ("GAUSS_CVF" fun nil (system) "Result = %s(P)" ("G3.html"))
    ("GAUSS_PDF" fun nil (system) "Result = %s(V)" ("G4.html"))
    ("GAUSSFIT" fun nil (system) "Result = %s( X, Y [, A])" ("G6.html" ("CHISQ" . 881490) ("ESTIMATES" . 841704) ("NTERMS" . 841712) ("SIGMA" . 881498) ("YERROR" . 881500)))
    ("GAUSSINT" fun nil (system) "Result = %s(X)" ("G7.html") ("tpoolkeyw2.html" ("TPOOL_MAX_ELTS" . 333417) ("TPOOL_MIN_ELTS" . 333286) ("TPOOL_NOTHREAD" . 333289)))
    ("GET_DRIVE_LIST" fun nil (system) "Result = %s()" ("G8.html" ("CDROM" . 884482) ("COUNT" . 876351) ("FIXED" . 876358) ("REMOTE" . 878573) ("REMOVABLE" . 878575)))
    ("GET_KBRD" fun nil (system) "Result = %s(Wait)" ("G9.html"))
    ("GET_SCREEN_SIZE" fun nil (system) "Result = %s( [Display_name])" ("G11.html" ("DISPLAY_NAME" . 841676) ("RESOLUTION" . 853571)))
    ("GETENV" fun nil (system) "Result = %s( Name )" ("G12.html" ("ENVIRONMENT" . 887078)))
    ("GRID3" fun nil (system) "Result = %s( X, Y, Z, F, Gx, Gy, Gz)" ("G16.html" ("DELTA" . 677098) ("DTOL" . 168207) ("GRID" . 677100) ("NGRID" . 677102) ("START" . 677104)))
    ("GRID_TPS" fun nil (system) "Interp = %s (Xp, Yp, Values)" ("G15.html" ("COEFFICIENTS" . 871830) ("DELTA" . 871832) ("NGRID" . 871834) ("START" . 871836)))
    ("GRIDDATA" fun nil (system) "Result = %s( X, F ) Result = GRIDDATA( X, Y, F ) Result = GRIDDATA( X, Y, Z, F)" ("G17.html" ("ANISOTROPY" . 877568) ("DEGREES" . 877573) ("DELTA" . 877575) ("DIMENSION" . 877578) ("EMPTY_SECTORS" . 877581) ("FAULT_POLYGONS" . 877584) ("FAULT_XY" . 877588) ("FUNCTION_TYPE" . 877591) ("GRID" . 877652) ("INVERSE_DISTANCE" . 877655) ("KRIGING" . 877657) ("LINEAR" . 877659) ("MAX_PER_SECTOR" . 877661) ("METHOD" . 877664) ("MIN_CURVATURE" . 877713) ("MIN_POINTS" . 877715) ("MISSING" . 877719) ("NATURAL_NEIGHBOR" . 877723) ("NEAREST_NEIGHBOR" . 877726) ("NEIGHBORHOOD" . 877729) ("POLYNOMIAL_REGRESSION" . 877733) ("POWER" . 877749) ("QUINTIC" . 877752) ("RADIAL_BASIS_FUNCTION" . 877755) ("SEARCH_ELLIPSE" . 877757) ("SECTORS" . 877761) ("SHEPARDS" . 877763) ("SMOOTHING" . 877766) ("SPHERE" . 877769) ("START" . 877771) ("TRIANGLES" . 877774) ("VARIOGRAM" . 877778) ("XOUT" . 877781) ("YOUT" . 877784)))
    ("GS_ITER" fun nil (system) "Result = %s( A, B)" ("G18.html" ("CHECK" . 750095) ("DOUBLE" . 875451) ("LAMBDA" . 750097) ("MAX_ITER" . 750102) ("TOL" . 872926) ("X_0" . 750104)))
    ("H5_BROWSER" fun nil (system) "Result = %s([Files])" ("H3.html" ("DIALOG_READ" . 885865)))
    ("H5_GET_LIBVERSION" fun nil (system) "Result = %s( )" ("HDF5-routines10.html"))
    ("H5_PARSE" fun nil (system) "Result = %s (File)" ("HDF5-routines12.html" ("FILE" . 1148311) ("PATH" . 1148313) ("READ_DATA" . 1148315)))
    ("H5A_GET_NAME" fun nil (system) "Result = %s(Attribute_id)" ("HDF5-routines14.html"))
    ("H5A_GET_NUM_ATTRS" fun nil (system) "Result = %s(Loc_id)" ("HDF5-routines15.html"))
    ("H5A_GET_SPACE" fun nil (system) "Result = %s(Attribute_id)" ("HDF5-routines16.html"))
    ("H5A_GET_TYPE" fun nil (system) "Result = %s(Attribute_id)" ("HDF5-routines17.html"))
    ("H5A_OPEN_IDX" fun nil (system) "Result = %s(Loc_id, Index)" ("HDF5-routines18.html"))
    ("H5A_OPEN_NAME" fun nil (system) "Result = %s(Loc_id, Name)" ("HDF5-routines19.html"))
    ("H5A_READ" fun nil (system) "Result = %s(Attribute_id)" ("HDF5-routines20.html"))
    ("H5D_GET_SPACE" fun nil (system) "Result = %s(Dataset_id)" ("HDF5-routines22.html"))
    ("H5D_GET_STORAGE_SIZE" fun nil (system) "Result = %s(Dataset_id)" ("HDF5-routines23.html"))
    ("H5D_GET_TYPE" fun nil (system) "Result = %s(Dataset_id)" ("HDF5-routines24.html"))
    ("H5D_OPEN" fun nil (system) "Result = %s(Loc_id, Name)" ("HDF5-routines25.html"))
    ("H5D_READ" fun nil (system) "Result = %s(Dataset_id)" ("HDF5-routines26.html" ("FILE_SPACE" . 1148824) ("MEMORY_SPACE" . 1148826)))
    ("H5F_IS_HDF5" fun nil (system) "Result = %s(Filename)" ("HDF5-routines28.html"))
    ("H5F_OPEN" fun nil (system) "Result = %s(Filename)" ("HDF5-routines29.html"))
    ("H5G_GET_COMMENT" fun nil (system) "Result = %s(Loc_id, Name)" ("HDF5-routines31.html"))
    ("H5G_GET_LINKVAL" fun nil (system) "Result = %s(Loc_id, Name)" ("HDF5-routines32.html"))
    ("H5G_GET_MEMBER_NAME" fun nil (system) "Result = %s(Loc_id, Name, Index)" ("HDF5-routines33.html"))
    ("H5G_GET_NMEMBERS" fun nil (system) "Result = %s(Loc_id, Name)" ("HDF5-routines34.html"))
    ("H5G_GET_OBJINFO" fun nil (system) "Result = %s(Loc_id, Name)" ("HDF5-routines35.html" ("FOLLOW_LINK" . 1149214)))
    ("H5G_OPEN" fun nil (system) "Result = %s(Loc_id, Name)" ("HDF5-routines36.html"))
    ("H5I_GET_TYPE" fun nil (system) "Result = %s(Obj_id)" ("HDF5-routines37.html"))
    ("H5R_DEREFERENCE" fun nil (system) "Result = %s(Loc_id, Reference)" ("HDF5-routines38.html"))
    ("H5R_GET_OBJECT_TYPE" fun nil (system) "Result = %s(Loc_id, Reference)" ("HDF5-routines39.html"))
    ("H5S_COPY" fun nil (system) "Result = %s(Dataspace_id)" ("HDF5-routines41.html"))
    ("H5S_CREATE_SIMPLE" fun nil (system) "Result = %s(Dimensions)" ("HDF5-routines42.html" ("MAX_DIMENSIONS" . 1149414)))
    ("H5S_GET_SELECT_BOUNDS" fun nil (system) "Result = %s(Dataspace_id)" ("HDF5-routines43.html"))
    ("H5S_GET_SELECT_ELEM_NPOINTS" fun nil (system) "Result = %s(Dataspace_id)" ("HDF5-routines44.html"))
    ("H5S_GET_SELECT_ELEM_POINTLIST" fun nil (system) "Result = %s(Dataspace_id)" ("HDF5-routines45.html" ("NUMBER" . 1149508) ("START" . 1149506)))
    ("H5S_GET_SELECT_HYPER_BLOCKLIST" fun nil (system) "Result = %s(Dataspace_id)" ("HDF5-routines46.html" ("NUMBER" . 1149544) ("START" . 1149542)))
    ("H5S_GET_SELECT_HYPER_NBLOCKS" fun nil (system) "Result = %s(Dataspace_id)" ("HDF5-routines47.html"))
    ("H5S_GET_SELECT_NPOINTS" fun nil (system) "Result = %s(Dataspace_id)" ("HDF5-routines48.html"))
    ("H5S_GET_SIMPLE_EXTENT_DIMS" fun nil (system) "Result = %s(Dataspace_id)" ("HDF5-routines49.html" ("MAX_DIMENSIONS" . 1149642)))
    ("H5S_GET_SIMPLE_EXTENT_NDIMS" fun nil (system) "Result = %s(Dataspace_id)" ("HDF5-routines50.html"))
    ("H5S_GET_SIMPLE_EXTENT_NPOINTS" fun nil (system) "Result = %s(Dataspace_id)" ("HDF5-routines51.html"))
    ("H5S_GET_SIMPLE_EXTENT_TYPE" fun nil (system) "Result = %s(Dataspace_id)" ("HDF5-routines52.html"))
    ("H5S_IS_SIMPLE" fun nil (system) "Result = %s(Dataspace_id)" ("HDF5-routines53.html"))
    ("H5S_SELECT_VALID" fun nil (system) "Result = %s(Dataspace_id)" ("HDF5-routines59.html"))
    ("H5T_COMMITTED" fun nil (system) "Result = %s(Datatype_id)" ("HDF5-routines61.html"))
    ("H5T_COPY" fun nil (system) "Result = %s(Datatype_id)" ("HDF5-routines62.html"))
    ("H5T_EQUAL" fun nil (system) "Result = %s(Datatype_id1, Datatype_id2)" ("HDF5-routines63.html"))
    ("H5T_GET_ARRAY_DIMS" fun nil (system) "Result = %s(Datatype_id)" ("HDF5-routines64.html" ("PERMUTATIONS" . 1150077)))
    ("H5T_GET_ARRAY_NDIMS" fun nil (system) "Result = %s(Datatype_id)" ("HDF5-routines65.html"))
    ("H5T_GET_CLASS" fun nil (system) "Result = %s(Datatype_id)" ("HDF5-routines66.html"))
    ("H5T_GET_CSET" fun nil (system) "Result = %s(Datatype_id)" ("HDF5-routines67.html"))
    ("H5T_GET_EBIAS" fun nil (system) "Result = %s(Datatype_id)" ("HDF5-routines68.html"))
    ("H5T_GET_FIELDS" fun nil (system) "Result = %s(Datatype_id)" ("HDF5-routines69.html"))
    ("H5T_GET_INPAD" fun nil (system) "Result = %s(Datatype_id)" ("HDF5-routines70.html"))
    ("H5T_GET_MEMBER_CLASS" fun nil (system) "Result = %s(Datatype_id, Member)" ("HDF5-routines71.html"))
    ("H5T_GET_MEMBER_NAME" fun nil (system) "Result = %s(Datatype_id, Member)" ("HDF5-routines72.html"))
    ("H5T_GET_MEMBER_OFFSET" fun nil (system) "Result = %s(Datatype_id, Member)" ("HDF5-routines73.html"))
    ("H5T_GET_MEMBER_TYPE" fun nil (system) "Result = %s(Datatype_id, Member)" ("HDF5-routines74.html"))
    ("H5T_GET_NMEMBERS" fun nil (system) "Result = %s(Datatype_id)" ("HDF5-routines75.html"))
    ("H5T_GET_NORM" fun nil (system) "Result = %s(Datatype_id)" ("HDF5-routines76.html"))
    ("H5T_GET_OFFSET" fun nil (system) "Result = %s(Datatype_id)" ("HDF5-routines77.html"))
    ("H5T_GET_ORDER" fun nil (system) "Result = %s(Datatype_id)" ("HDF5-routines78.html"))
    ("H5T_GET_PAD" fun nil (system) "Result = %s(Datatype_id)" ("HDF5-routines79.html"))
    ("H5T_GET_PRECISION" fun nil (system) "Result = %s(Datatype_id)" ("HDF5-routines80.html"))
    ("H5T_GET_SIGN" fun nil (system) "Result = %s(Datatype_id)" ("HDF5-routines81.html"))
    ("H5T_GET_SIZE" fun nil (system) "Result = %s(Datatype_id)" ("HDF5-routines82.html"))
    ("H5T_GET_STRPAD" fun nil (system) "Result = %s(Datatype_id)" ("HDF5-routines83.html"))
    ("H5T_GET_SUPER" fun nil (system) "Result = %s(Datatype_id)" ("HDF5-routines84.html"))
    ("H5T_IDLTYPE" fun nil (system) "Result = %s(Datatype_id)" ("HDF5-routines85.html" ("ARRAY_DIMENSIONS" . 1150764) ("STRUCTURE" . 1150766)))
    ("H5T_MEMTYPE" fun nil (system) "Result = %s(Datatype_id)" ("HDF5-routines86.html"))
    ("H5T_OPEN" fun nil (system) "Result = %s(Loc_id, Name)" ("HDF5-routines87.html"))
    ("HANNING" fun nil (system) "Result = %s( N1 [, N2])" ("H4.html" ("ALPHA" . 758100) ("DOUBLE" . 874103)))
    ("HDF_" fun nil (system) "Result = %s VD _NATTRS( VData, FieldID )" ("HDF-routines135.html"))
    ("HDF_AN_ANNLEN" fun nil (system) "Result = %s(ann_id)" ("HDF-routines7.html"))
    ("HDF_AN_ANNLIST" fun nil (system) "Result = %s(an_id, annot_type, obj_tag, obj_ref, ann_list)" ("HDF-routines8.html"))
    ("HDF_AN_ATYPE2TAG" fun nil (system) "Result = %s(annot_type)" ("HDF-routines9.html"))
    ("HDF_AN_CREATE" fun nil (system) "Result = %s(an_id, obj_tag, obj_ref, annot_type)" ("HDF-routines10.html"))
    ("HDF_AN_CREATEF" fun nil (system) "Result = %s(an_id, annot_type)" ("HDF-routines11.html"))
    ("HDF_AN_FILEINFO" fun nil (system) "Result = %s(an_id, n_file_labels, n_file_descs, n_data_labels, n_data_descs)" ("HDF-routines14.html"))
    ("HDF_AN_GET_TAGREF" fun nil (system) "Result = %s(an_id, index, annot_type, ann_tag, ann_ref)" ("HDF-routines15.html"))
    ("HDF_AN_ID2TAGREF" fun nil (system) "Result = %s(ann_id, ann_tag, ann_ref)" ("HDF-routines16.html"))
    ("HDF_AN_NUMANN" fun nil (system) "Result = %s(an_id, annot_type, obj_tag, obj_ref)" ("HDF-routines17.html"))
    ("HDF_AN_READANN" fun nil (system) "Result = %s( ann_id, annotation)" ("HDF-routines18.html" ("LENGTH" . 1056839)))
    ("HDF_AN_SELECT" fun nil (system) "Result = %s(an_id, index, annot_type)" ("HDF-routines19.html"))
    ("HDF_AN_START" fun nil (system) "Result = %s(file_id)" ("HDF-routines20.html"))
    ("HDF_AN_TAG2ATYPE" fun nil (system) "Result = %s(ann_tag)" ("HDF-routines21.html"))
    ("HDF_AN_TAGREF2ID" fun nil (system) "Result = %s(an_id, ann_tag, ann_ref)" ("HDF-routines22.html"))
    ("HDF_AN_WRITEANN" fun nil (system) "Result = %s( ann_id, annotation)" ("HDF-routines23.html" ("LENGTH" . 1056941)))
    ("HDF_BROWSER" fun nil (system) "Template = %s([Filename])" ("H5.html" ("CANCEL" . 852206) ("GROUP" . 870963) ("PREFIX" . 852209)))
    ("HDF_DF24_LASTREF" fun nil (system) "Result = %s( )" ("HDF-routines29.html"))
    ("HDF_DF24_NIMAGES" fun nil (system) "Result = %s(Filename)" ("HDF-routines30.html"))
    ("HDF_DFAN_LABLIST" fun nil (system) "Result = %s( Filename, Tag, Reflist, Labellist)" ("HDF-routines39.html" ("LISTSIZE" . 997374) ("MAXLABEL" . 997377) ("STARTPOS" . 997380) ("STRING" . 997383)))
    ("HDF_DFAN_LASTREF" fun nil (system) "Result = %s( )" ("HDF-routines40.html"))
    ("HDF_DFP_LASTREF" fun nil (system) "Result = %s( )" ("HDF-routines45.html"))
    ("HDF_DFP_NPALS" fun nil (system) "Result = %s(Filename)" ("HDF-routines46.html"))
    ("HDF_DFR8_LASTREF" fun nil (system) "Result = %s( )" ("HDF-routines54.html"))
    ("HDF_DFR8_NIMAGES" fun nil (system) "Result = %s(Filename)" ("HDF-routines55.html"))
    ("HDF_EXISTS" fun nil (system) "Result = %s( )" ("HDF-routines61.html"))
    ("HDF_GR_ATTRINFO" fun nil (system) "Result = %s(obj_id, attr_index, name, data_type, count)" ("HDF-routines62.html"))
    ("HDF_GR_CREATE" fun nil (system) "Result = %s(gr_id, name, ncomp, data_type, interlace_mode, dim_sizes)" ("HDF-routines63.html"))
    ("HDF_GR_FILEINFO" fun nil (system) "Result = %s(gr_id, n_images, n_file_attrs)" ("HDF-routines66.html"))
    ("HDF_GR_FINDATTR" fun nil (system) "Result = %s(obj_id, attr_name)" ("HDF-routines67.html"))
    ("HDF_GR_GETATTR" fun nil (system) "Result = %s(obj_id, attr_index, values)" ("HDF-routines68.html"))
    ("HDF_GR_GETCHUNKINFO" fun nil (system) "Result = %s(ri_id, dim_length, flag)" ("HDF-routines69.html"))
    ("HDF_GR_GETIMINFO" fun nil (system) "Result = %s(ri_id, gr_name, ncomp, data_type, interlace_mode, dim_sizes, num_attrs)" ("HDF-routines70.html"))
    ("HDF_GR_GETLUTID" fun nil (system) "Result = %s(ri_id, pal_index)" ("HDF-routines71.html"))
    ("HDF_GR_GETLUTINFO" fun nil (system) "Result = %s(pal_id, ncomp, data_type, interlace_mode, num_entries)" ("HDF-routines72.html"))
    ("HDF_GR_IDTOREF" fun nil (system) "Result = %s(ri_id)" ("HDF-routines73.html"))
    ("HDF_GR_LUTTOREF" fun nil (system) "Result = %s(pal_id)" ("HDF-routines74.html"))
    ("HDF_GR_NAMETOINDEX" fun nil (system) "Result = %s(gr_id, gr_name)" ("HDF-routines75.html"))
    ("HDF_GR_READIMAGE" fun nil (system) "Result = %s( ri_id, data)" ("HDF-routines76.html" ("EDGE" . 1057619) ("INTERLACE" . 1057617) ("START" . 1057607) ("STRIDE" . 1057609)))
    ("HDF_GR_READLUT" fun nil (system) "Result = %s( pal_id, pal_data)" ("HDF-routines77.html" ("INTERLACE" . 1057387)))
    ("HDF_GR_REFTOINDEX" fun nil (system) "Result = %s(gr_id, gr_ref)" ("HDF-routines78.html"))
    ("HDF_GR_SELECT" fun nil (system) "Result = %s(gr_id, index)" ("HDF-routines79.html"))
    ("HDF_GR_SETATTR" fun nil (system) "Result = %s(obj_id, attr_name, data_type, count, values)" ("HDF-routines80.html"))
    ("HDF_GR_SETCHUNK" fun nil (system) "Result = %s(ri_id, dim_length, comp_type, comp_prm)" ("HDF-routines81.html"))
    ("HDF_GR_SETCHUNKCACHE" fun nil (system) "Result = %s(ri_id, maxcache, flags)" ("HDF-routines82.html"))
    ("HDF_GR_SETCOMPRESS" fun nil (system) "Result = %s(ri_id, comp_type, comp_prm)" ("HDF-routines83.html"))
    ("HDF_GR_SETEXTERNALFILE" fun nil (system) "Result = %s(ri_id, filename, offset)" ("HDF-routines84.html"))
    ("HDF_GR_START" fun nil (system) "Result = %s(file_id)" ("HDF-routines85.html"))
    ("HDF_GR_WRITEIMAGE" fun nil (system) "Result = %s( ri_id, data)" ("HDF-routines86.html" ("EDGE" . 1057693) ("INTERLACE" . 1057699) ("START" . 1057691) ("STRIDE" . 1057681)))
    ("HDF_GR_WRITELUT" fun nil (system) "Result = %s( pal_id, pal_data)" ("HDF-routines87.html" ("DATA_TYPE") ("INTERLACE_MODE") ("NENTRIES")))
    ("HDF_HDF2IDLTYPE" fun nil (system) "Result = %s( hdftypecode )" ("HDF-routines88.html"))
    ("HDF_IDL2HDFTYPE" fun nil (system) "Result = %s( idltypecode )" ("HDF-routines89.html"))
    ("HDF_ISHDF" fun nil (system) "Result = %s(Filename)" ("HDF-routines90.html"))
    ("HDF_NEWREF" fun nil (system) "Result = %s(FileHandle)" ("HDF-routines92.html"))
    ("HDF_NUMBER" fun nil (system) "Result = %s( FileHandle)" ("HDF-routines93.html" ("TAG" . 998362)))
    ("HDF_OPEN" fun nil (system) "Result = %s( Filename)" ("HDF-routines94.html" ("ALL" . 998379) ("CREATE" . 998383) ("NUM_DD" . 998386) ("RDWR" . 998390) ("READ" . 998394) ("WRITE" . 998397)))
    ("HDF_PACKDATA" fun nil (system) "Result = %s( data1 [, data2 [, data3 [, data4 [, data5 [, data6 [, data7 [, data8]]]]]]])" ("HDF-routines95.html" ("HDF_ORDER" . 1042936) ("HDF_TYPE" . 1042939) ("NREC" . 1042942)))
    ("HDF_READ" fun nil (system) "Result = %s( [Filename])" ("H6.html" ("DF24" . 852278) ("DFR8" . 852275) ("PREFIX" . 871657) ("TEMPLATE" . 852281)))
    ("HDF_SD_ATTRFIND" fun nil (system) "Result = %s(S_ID, Name)" ("HDF-routines97.html"))
    ("HDF_SD_CREATE" fun nil (system) "Result = %s( SD_ID, Name, Dims)" ("HDF-routines100.html" ("BYTE" . 1053869) ("DFNT_CHAR8" . 1053872) ("DFNT_FLOAT32" . 1053875) ("DFNT_FLOAT64" . 1053878) ("DFNT_INT16" . 1053884) ("DFNT_INT32" . 1053887) ("DFNT_INT8" . 1053881) ("DFNT_UINT16" . 1053893) ("DFNT_UINT32" . 1053896) ("DFNT_UINT8" . 1053890) ("DOUBLE" . 1053899) ("FLOAT" . 1053902) ("HDF_TYPE" . 1106175) ("INT" . 1106171) ("LONG" . 1053908) ("SHORT" . 1053911) ("STRING" . 1053914)))
    ("HDF_SD_DIMGETID" fun nil (system) "Result = %s(SDS_ID, Dimension_Number)" ("HDF-routines102.html"))
    ("HDF_SD_IDTOREF" fun nil (system) "Result = %s(SDS_ID)" ("HDF-routines109.html"))
    ("HDF_SD_ISCOORDVAR" fun nil (system) "Result = %s(SDS_ID)" ("HDF-routines110.html"))
    ("HDF_SD_NAMETOINDEX" fun nil (system) "Result = %s(SD_ID, SDS_Name)" ("HDF-routines111.html"))
    ("HDF_SD_REFTOINDEX" fun nil (system) "Result = %s(SD_ID, Refno)" ("HDF-routines112.html"))
    ("HDF_SD_SELECT" fun nil (system) "Result = %s(SD_ID, Number)" ("HDF-routines113.html"))
    ("HDF_SD_START" fun nil (system) "Result = %s( Filename)" ("HDF-routines117.html" ("CREATE" . 1054663) ("RDWR" . 1054661) ("READ" . 1054659)))
    ("HDF_VD_ATTACH" fun nil (system) "Result = %s( FileHandle, VDataId)" ("HDF-routines119.html" ("READ" . 999503) ("WRITE" . 999506)))
    ("HDF_VD_ATTRFIND" fun nil (system) "Result = %s(VData, FieldID, Name)" ("HDF-routines120.html"))
    ("HDF_VD_FEXIST" fun nil (system) "Result = %s(VData, Fieldnames)" ("HDF-routines125.html"))
    ("HDF_VD_FIND" fun nil (system) "Result = %s(FileHandle, Name)" ("HDF-routines126.html"))
    ("HDF_VD_GETID" fun nil (system) "Result = %s(FileHandle, VDataId)" ("HDF-routines128.html"))
    ("HDF_VD_ISATTR" fun nil (system) "Result = %s(VData)" ("HDF-routines131.html"))
    ("HDF_VD_ISVD" fun nil (system) "Result = %s(VGroup, Id)" ("HDF-routines132.html"))
    ("HDF_VD_LONE" fun nil (system) "Result = %s( FileHandle)" ("HDF-routines134.html" ("MAXSIZE" . 999761)))
    ("HDF_VD_READ" fun nil (system) "Result = %s( VData, Data)" ("HDF-routines136.html" ("FIELDS" . 999788) ("FULL_INTERLACE" . 999791) ("NO_INTERLACE" . 999794) ("NRECORDS" . 999797)))
    ("HDF_VG_ATTACH" fun nil (system) "Result = %s( FileHandle, VGroupId)" ("HDF-routines141.html" ("READ" . 999942) ("WRITE" . 999945)))
    ("HDF_VG_GETID" fun nil (system) "Result = %s(FileHandle, VGroupId)" ("HDF-routines143.html"))
    ("HDF_VG_GETNEXT" fun nil (system) "Result = %s(VGroup, Id)" ("HDF-routines145.html"))
    ("HDF_VG_INQTR" fun nil (system) "Result = %s(VGroup, Tag, Ref)" ("HDF-routines148.html"))
    ("HDF_VG_ISVD" fun nil (system) "Result = %s(VGroup, Id)" ("HDF-routines150.html"))
    ("HDF_VG_ISVG" fun nil (system) "Result = %s(VGroup, Id)" ("HDF-routines151.html"))
    ("HDF_VG_LONE" fun nil (system) "Result = %s( FileHandle)" ("HDF-routines152.html" ("MAXSIZE" . 1000150)))
    ("HDF_VG_NUMBER" fun nil (system) "Result = %s(VGroup)" ("HDF-routines153.html"))
    ("HILBERT" fun nil (system) "Result = %s(X [, D])" ("H10.html"))
    ("HIST_2D" fun nil (system) "Result = %s( V1, V2)" ("H11.html" ("BIN1" . 832830) ("BIN2" . 832832) ("MAX1" . 832284) ("MAX2" . 832345) ("MIN1" . 832837) ("MIN2" . 832839)))
    ("HIST_EQUAL" fun nil (system) "Result = %s( A)" ("H12.html" ("BINSIZE" . 871698) ("FCN" . 876498) ("HISTOGRAM_ONLY" . 874403) ("MAXV" . 874687) ("MINV" . 758160) ("OMAX" . 875087) ("OMIN" . 875100) ("PERCENT" . 874600) ("TOP" . 874602)))
    ("HISTOGRAM" fun nil (system) "Result = %s( Array)" ("H13.html" ("BINSIZE" . 677175) ("INPUT" . 677177) ("L64" . 677180) ("LOCATIONS" . 886107) ("MAX" . 886113) ("MIN" . 677182) ("NAN" . 197674) ("NBINS" . 677184) ("OMAX" . 873903) ("OMIN" . 677186) ("REVERSE_INDICES" . 677188)))
    ("HOUGH" fun nil (system) "Result = %s( Array)" ("H15.html" ("BACKPROJECT" . 875957) ("DOUBLE" . 875960) ("DRHO" . 875962) ("DX" . 875964) ("DY" . 875966) ("GRAY" . 875968) ("NRHO" . 875970) ("NTHETA" . 875972) ("NX" . 875974) ("NY" . 875976) ("RHO" . 875978) ("RMIN" . 875980) ("THETA" . 875982) ("XMIN" . 875984) ("YMIN" . 875986)))
    ("HQR" fun nil (system) "Result = %s( A)" ("H16.html" ("COLUMN" . 871729) ("DOUBLE" . 50748)))
    ("IBETA" fun nil (system) "Result = %s( A, B, Z)" ("I.html" ("DOUBLE" . 875616) ("EPS" . 875618) ("ITER" . 875967) ("ITMAX" . 875622)) ("tpoolkeyw2.html" ("TPOOL_MAX_ELTS" . 333417) ("TPOOL_MIN_ELTS" . 333286) ("TPOOL_NOTHREAD" . 333289)))
    ("IDENTITY" fun nil (system) "Result = %s( N)" ("I2.html" ("DOUBLE" . 832664)))
    ("IGAMMA" fun nil (system) "Result = %s( A, Z)" ("I4.html" ("DOUBLE" . 875550) ("EPS" . 875548) ("ITER" . 875581) ("ITMAX" . 875579) ("METHOD" . 875520)) ("tpoolkeyw2.html" ("TPOOL_MAX_ELTS" . 333417) ("TPOOL_MIN_ELTS" . 333286) ("TPOOL_NOTHREAD" . 333289)))
    ("IMAGINARY" fun nil (system) "Result = %s(Complex_Expression)" ("I7.html") ("tpoolkeyw2.html" ("TPOOL_MAX_ELTS" . 333417) ("TPOOL_MIN_ELTS" . 333286) ("TPOOL_NOTHREAD" . 333289)))
    ("INDGEN" fun nil (system) "Result = %s(D1 [, ..., D8])" ("I8.html" ("BYTE" . 862684) ("COMPLEX" . 862699) ("DCOMPLEX" . 862701) ("DOUBLE" . 862705) ("FLOAT" . 862707) ("L64" . 862711) ("LONG" . 862927) ("STRING" . 862930) ("TYPE" . 862752) ("UINT" . 862746) ("UL64" . 862748) ("ULONG" . 862750)) ("tpoolkeyw2.html" ("TPOOL_MAX_ELTS" . 333417) ("TPOOL_MIN_ELTS" . 333286) ("TPOOL_NOTHREAD" . 333289)))
    ("INT_2D" fun nil (system) "Result = %s( Fxy, AB_Limits, PQ_Limits, Pts)" ("I9.html" ("DOUBLE" . 832191) ("ORDER" . 813280)))
    ("INT_3D" fun nil (system) "Result = %s( Fxyz, AB_Limits, PQ_Limits, UV_Limits, Pts)" ("I10.html" ("DOUBLE" . 813293)))
    ("INT_TABULATED" fun nil (system) "Result = %s( X, F)" ("I11.html" ("DOUBLE" . 875649) ("SORT" . 750310)))
    ("INTARR" fun nil (system) "Result = %s( D1 [, ..., D8])" ("I12.html" ("NOZERO" . 677253)))
    ("INTERPOL" fun nil (system) "Result = %s( V, N)" ("I13.html" ("LSQUADRATIC" . 872067) ("QUADRATIC" . 872072) ("SPLINE" . 872076)))
    ("INTERPOLATE" fun nil (system) "Result = %s( P, X [, Y [, Z]])" ("I14.html" ("CUBIC" . 680782) ("GRID" . 680781) ("MISSING" . 677276)) ("tpoolkeyw2.html" ("TPOOL_MAX_ELTS" . 333417) ("TPOOL_MIN_ELTS" . 333286) ("TPOOL_NOTHREAD" . 333289)))
    ("INVERT" fun nil (system) "Result = %s( Array [, Status])" ("I16.html" ("DOUBLE" . 50809)))
    ("IOCTL" fun nil (system) "Result = %s( File_Unit [, Request, Arg])" ("I17.html" ("BY_VALUE" . 677325) ("MT_OFFLINE" . 677327) ("MT_REWIND" . 677329) ("MT_SKIP_FILE" . 677331) ("MT_SKIP_RECORD" . 677333) ("MT_WEOF" . 677335) ("SUPPRESS_ERROR" . 677337)))
    ("ISHFT" fun nil (system) "Result = %s(P1, P2)" ("I18.html") ("tpoolkeyw2.html" ("TPOOL_MAX_ELTS" . 333417) ("TPOOL_MIN_ELTS" . 333286) ("TPOOL_NOTHREAD" . 333289)))
    ("JULDAY" fun nil (system) "Result = %s(Month, Day, Year, Hour, Minute, Second)" ("J2.html"))
    ("KEYWORD_SET" fun nil (system) "Result = %s(Expression)" ("K.html"))
    ("KRIG2D" fun nil (system) "Result = %s( Z [, X, Y])" ("K2.html" ("BOUNDS" . 750620) ("EXPONENTIAL" . 750596) ("GS" . 930292) ("NX" . 750622) ("NY" . 750624) ("REGULAR" . 750607) ("SPHERICAL" . 750598) ("XGRID" . 750609) ("XVALUES" . 750611) ("YGRID" . 750613) ("YVALUES" . 750615)))
    ("KURTOSIS" fun nil (system) "Result = %s(X)" ("K3.html" ("DOUBLE" . 859078) ("NAN" . 860892)))
    ("KW_TEST" fun nil (system) "Result = %s( X)" ("K4.html" ("DF" . 53675) ("MISSING" . 53678)))
    ("L64INDGEN" fun nil (system) "Result = %s(D1 [, ..., D8])" ("L.html") ("tpoolkeyw2.html" ("TPOOL_MAX_ELTS" . 333417) ("TPOOL_MIN_ELTS" . 333286) ("TPOOL_NOTHREAD" . 333289)))
    ("LA_CHOLMPROVE" fun nil (system) "Result = %s( Array, Achol, B, X)" ("L3.html" ("BACKWARD_ERROR" . 969194) ("DOUBLE" . 969196) ("FORWARD_ERROR" . 969198) ("UPPER" . 969200)))
    ("LA_CHOLSOL" fun nil (system) "Result = %s( A, B)" ("L4.html" ("DOUBLE" . 969317) ("UPPER" . 969319)))
    ("LA_DETERM" fun nil (system) "Result = %s( A)" ("L5.html" ("CHECK" . 969400) ("DOUBLE" . 969402) ("ZERO" . 969404)))
    ("LA_EIGENPROBLEM" fun nil (system) "Result = %s( A [, B])" ("L6.html" ("ALPHA" . 969502) ("BALANCE" . 969505) ("BETA" . 969512) ("DOUBLE" . 969515) ("EIGENVECTORS" . 969517) ("LEFT_EIGENVECTORS" . 969520) ("NORM_BALANCE" . 969523) ("PERMUTE_RESULT" . 969525) ("RCOND_VALUE" . 969527) ("RCOND_VECTOR" . 969529) ("SCALE_RESULT" . 969531) ("STATUS" . 969533)))
    ("LA_EIGENQL" fun nil (system) "Result = %s( A [, B])" ("L7.html" ("DOUBLE" . 969688) ("EIGENVECTORS" . 969690) ("FAILED" . 969692) ("GENERALIZED" . 969695) ("METHOD" . 969701) ("RANGE" . 969707) ("SEARCH_RANGE" . 969709) ("STATUS" . 969712) ("TOLERANCE" . 969723)))
    ("LA_EIGENVEC" fun nil (system) "Result = %s( T, QZ)" ("L8.html" ("BALANCE" . 969898) ("DOUBLE" . 969901) ("EIGENINDEX" . 969903) ("LEFT_EIGENVECTORS" . 969906) ("PERMUTE_RESULT" . 969908) ("RCOND_VALUE" . 969910) ("RCOND_VECTOR" . 969912) ("SCALE_RESULT" . 969914) ("SELECT" . 969916)))
    ("LA_ELMHES" fun nil (system) "Result = %s( Array [, Q])" ("L9.html" ("BALANCE" . 970060) ("DOUBLE" . 970067) ("NORM_BALANCE" . 970069) ("PERMUTE_RESULT" . 970071) ("SCALE_RESULT" . 970073)))
    ("LA_GM_LINEAR_MODEL" fun nil (system) "Result = %s( A, B, D, Y)" ("L10.html" ("DOUBLE" . 970161)))
    ("LA_HQR" fun nil (system) "Result = %s(H [, Q])" ("L11.html" ("DOUBLE" . 970266) ("PERMUTE_RESULT" . 970268) ("STATUS" . 970270)))
    ("LA_INVERT" fun nil (system) "Result = %s( A)" ("L12.html" ("DOUBLE" . 970351) ("STATUS" . 970353)))
    ("LA_LEAST_SQUARE_EQUALITY" fun nil (system) "Result = %s( A, B, C, D)" ("L13.html" ("DOUBLE" . 970448) ("RESIDUAL" . 970450)))
    ("LA_LEAST_SQUARES" fun nil (system) "Result = %s( A, B)" ("L14.html" ("DOUBLE" . 970563) ("METHOD" . 970565) ("RANK" . 970571) ("RCONDITION" . 970573) ("RESIDUAL" . 970575) ("STATUS" . 970577)))
    ("LA_LINEAR_EQUATION" fun nil (system) "Result = %s( Array, B)" ("L15.html" ("BACKWARD_ERROR" . 970657) ("DOUBLE" . 970659) ("FORWARD_ERROR" . 970661) ("STATUS" . 970663)))
    ("LA_LUMPROVE" fun nil (system) "Result = %s( Array, Aludc, Index, B, X)" ("L17.html" ("BACKWARD_ERROR" . 970892) ("DOUBLE" . 970894) ("FORWARD_ERROR" . 970896)))
    ("LA_LUSOL" fun nil (system) "Result = %s( A, Index, B)" ("L18.html" ("DOUBLE" . 971007)))
    ("LA_TRIMPROVE" fun nil (system) "Result = %s( AL, A, AU, DAL, DA, DAU, DU2, Index, B, X)" ("L21.html" ("BACKWARD_ERROR" . 971423) ("DOUBLE" . 971425) ("FORWARD_ERROR" . 971427)))
    ("LA_TRISOL" fun nil (system) "Result = %s( AL, A, AU, U2, Index, B)" ("L24.html" ("DOUBLE" . 971725)))
    ("LABEL_DATE" fun nil (system) "Result = %s()" ("L25.html" ("AM_PM" . 939222) ("DATE_FORMAT" . 939215) ("DAYS_OF_WEEK" . 939285) ("MONTHS" . 939288) ("OFFSET" . 939291) ("ROUND_UP" . 940951)))
    ("LABEL_REGION" fun nil (system) "Result = %s( Data)" ("L26.html" ("ALL_NEIGHBORS" . 930484) ("EIGHT" . 828027) ("ULONG" . 677395)))
    ("LADFIT" fun nil (system) "Result = %s( X, Y)" ("L27.html" ("ABSDEV" . 53730) ("DOUBLE" . 837069)))
    ("LAGUERRE" fun nil (system) "Result = %s( X, N [, K])" ("L28.html" ("COEFFICIENTS" . 942495) ("DOUBLE" . 942497)))
    ("LEEFILT" fun nil (system) "Result = %s( A [, N [, Sig]])" ("L29.html" ("DOUBLE" . 939800) ("EXACT" . 833703)))
    ("LEGENDRE" fun nil (system) "Result = %s( X, L [, M])" ("L30.html" ("DOUBLE" . 942590)))
    ("LINBCG" fun nil (system) "Result = %s( A, B, X)" ("L31.html" ("DOUBLE" . 50883) ("ITER" . 50896) ("ITMAX" . 50899) ("ITOL" . 50886) ("TOL" . 50893)))
    ("LINDGEN" fun nil (system) "Result = %s(D1 [, ..., D8])" ("L32.html") ("tpoolkeyw2.html" ("TPOOL_MAX_ELTS" . 333417) ("TPOOL_MIN_ELTS" . 333286) ("TPOOL_NOTHREAD" . 333289)))
    ("LINFIT" fun nil (system) "Result = %s( X, Y)" ("L33.html" ("CHISQ" . 53778) ("COVAR" . 940616) ("DOUBLE" . 837073) ("MEASURE_ERRORS" . 53781) ("PROB" . 941301) ("SDEV" . 941420) ("SIGMA" . 941423) ("YFIT" . 941298)))
    ("LIVE_STYLE" fun nil (system) "Style = %s ({ 'contour' | 'image' | 'plot' | 'surface'})" ("L48.html" ("BASE_STYLE" . 870318) ("COLORBAR_PROPERTIES" . 874454) ("ERROR") ("GRAPHIC_PROPERTIES" . 870655) ("GROUP" . 870985) ("LEGEND_PROPERTIES" . 858236) ("NAME" . 875121) ("SAVE" . 870893) ("TEMPLATE_FILE") ("VISUALIZATION_PROPERTIES" . 858488) ("XAXIS_PROPERTIES" . 938787) ("YAXIS_PROPERTIES" . 938787) ("ZAXIS_PROPERTIES" . 938787)))
    ("LL_ARC_DISTANCE" fun nil (system) "Result = %s( Lon_lat0, Arc_Dist, Az)" ("L51.html" ("DEGREES" . 758227)))
    ("LMFIT" fun nil (system) "Result = %s( X, Y, A)" ("L52.html" ("ALPHA" . 849263) ("CHISQ" . 831462) ("CONVERGENCE" . 831464) ("COVAR" . 831689) ("DOUBLE" . 831466) ("FITA" . 831077) ("FUNCTION_NAME" . 831083) ("ITER" . 831471) ("ITMAX" . 831092) ("ITMIN" . 831094) ("MEASURE_ERRORS" . 941497) ("SIGMA" . 940586) ("TOL" . 940573) ("WEIGHTS" . 940578)))
    ("LMGR" fun nil (system) "Result = %s()" ("L53.html" ("CLIENTSERVER" . 879327) ("DEMO" . 856060) ("EMBEDDED" . 856064) ("EXPIRE_DATE" . 932522) ("FORCE_DEMO" . 856072) ("INSTALL_NUM" . 932505) ("LMHOSTID" . 856081) ("RUNTIME" . 856085) ("SITE_NOTICE" . 932539) ("STUDENT" . 856089) ("TRIAL" . 856094)))
    ("LNGAMMA" fun nil (system) "Result = %s(Z)" ("L54.html") ("tpoolkeyw2.html" ("TPOOL_MAX_ELTS" . 333417) ("TPOOL_MIN_ELTS" . 333286) ("TPOOL_NOTHREAD" . 333289)))
    ("LNP_TEST" fun nil (system) "Result = %s( X, Y)" ("L55.html" ("DOUBLE" . 54544) ("HIFAC" . 941916) ("JMAX" . 54547) ("OFAC" . 54550) ("WK1" . 54553) ("WK2" . 54556)))
    ("LOCALE_GET" fun nil (system) "Result = %s( )" ("L57.html"))
    ("LON64ARR" fun nil (system) "Result = %s( D1 [, ..., D8])" ("L58.html" ("NOZERO" . 918880)))
    ("LONARR" fun nil (system) "Result = %s( D1 [, ..., D8])" ("L59.html" ("NOZERO" . 916558)))
    ("LONG" fun nil (system) "Result = %s( Expression[, Offset [, D1 [, ..., D8]]] )" ("L60.html") ("tpoolkeyw2.html" ("TPOOL_MAX_ELTS" . 333417) ("TPOOL_MIN_ELTS" . 333286) ("TPOOL_NOTHREAD" . 333289)))
    ("LONG64" fun nil (system) "Result = %s( Expression[, Offset [, D1 [, ..., D8]]] )" ("L61.html") ("tpoolkeyw2.html" ("TPOOL_MAX_ELTS" . 333417) ("TPOOL_MIN_ELTS" . 333286) ("TPOOL_NOTHREAD" . 333289)))
    ("LSODE" fun nil (system) "Result = %s( Y, X, H, Derivs[, Status])" ("L62.html" ("ATOL" . 904984) ("RTOL" . 905036)))
    ("LU_COMPLEX" fun nil (system) "Result = %s( A, B)" ("L63.html" ("DOUBLE" . 750791) ("INVERSE" . 48859) ("SPARSE" . 37275)))
    ("LUMPROVE" fun nil (system) "Result = %s( A, Alud, Index, B, X)" ("L65.html" ("COLUMN" . 58736) ("DOUBLE" . 51323)))
    ("LUSOL" fun nil (system) "Result = %s(A, Index, B)" ("L66.html" ("COLUMN" . 58727) ("DOUBLE" . 50997)))
    ("M_CORRELATE" fun nil (system) "Result = %s( X, Y)" ("M.html" ("DOUBLE" . 956112)))
    ("MACHAR" fun nil (system) "Result = %s()" ("M2.html" ("DOUBLE" . 928847)))
    ("MAKE_ARRAY" fun nil (system) "Result = %s ( [D1 [, ..., D8]])" ("M3.html" ("BYTE" . 887432) ("COMPLEX" . 887435) ("DCOMPLEX" . 887438) ("DIMENSION" . 887441) ("DOUBLE" . 887444) ("FLOAT" . 887447) ("INDEX" . 887450) ("INTEGER" . 887453) ("L64" . 916074) ("LONG" . 887456) ("NOZERO" . 887459) ("OBJ" . 887462) ("PTR" . 887465) ("SIZE" . 887468) ("STRING" . 887471) ("TYPE" . 887474) ("UINT" . 918501) ("UL64" . 918504) ("ULONG" . 916082) ("VALUE" . 887480)) ("tpoolkeyw2.html" ("TPOOL_MAX_ELTS" . 333417) ("TPOOL_MIN_ELTS" . 333286) ("TPOOL_NOTHREAD" . 333289)))
    ("MAP_2POINTS" fun nil (system) "Result = %s( lon0, lat0, lon1, lat1)" ("M5.html" ("DPATH" . 960572) ("METERS" . 960574) ("MILES" . 960576) ("NPATH" . 960578) ("PARAMETERS" . 960581) ("RADIANS" . 960583) ("RADIUS" . 960585) ("RHUMB" . 960587)))
    ("MAP_IMAGE" fun nil (system) "Result = %s( Image [, Startx, Starty [, Xsize, Ysize]])" ("M8.html" ("BILINEAR" . 903532) ("COMPRESS" . 887760) ("LATMAX" . 887748) ("LATMIN" . 887745) ("LONMAX" . 887754) ("LONMIN" . 887751) ("MAX_VALUE" . 887766) ("MIN_VALUE" . 887770) ("MISSING" . 887774) ("SCALE" . 887763)))
    ("MAP_PATCH" fun nil (system) "Result = %s( Image_Orig [, Lons, Lats])" ("M9.html" ("LAT0" . 958167) ("LAT1" . 887838) ("LON0" . 887841) ("LON1" . 887844) ("MAX_VALUE" . 928019) ("MISSING" . 887847) ("TRIANGULATE" . 887853) ("XSIZE" . 887856) ("XSTART" . 887859) ("YSIZE" . 887862) ("YSTART" . 887865)))
    ("MAP_PROJ_FORWARD" fun nil (system) "Result = %s(Longitude [, Latitude])" ("M10.html" ("CONNECTIVITY" . 999199) ("MAP_STRUCTURE" . 999209) ("POLYGONS" . 999214) ("POLYLINES" . 999218) ("RADIANS" . 999222)))
    ("MAP_PROJ_INIT" fun nil (system) "Result = %s(Projection)" ("M12.html" ("CENTER_AZIMUTH" . 999986) ("CENTER_LATITUDE" . 999988) ("CENTER_LONGITUDE" . 999990) ("DATUM" . 999770) ("FALSE_EASTING" . 999992) ("FALSE_NORTHING" . 999994) ("GCTP" . 999952) ("HEIGHT" . 999996) ("HOM_AZIM_ANGLE" . 1000000) ("HOM_AZIM_LONGITUDE" . 999998) ("HOM_LATITUDE1" . 1000002) ("HOM_LATITUDE2" . 1000004) ("HOM_LONGITUDE1" . 1000006) ("HOM_LONGITUDE2" . 1000008) ("IS_JUSTIFY" . 1000012) ("IS_ZONES" . 1000010) ("LIMIT" . 999954) ("MERCATOR_SCALE" . 1000036) ("OEA_ANGLE" . 1000038) ("OEA_SHAPEM" . 1000040) ("OEA_SHAPEN" . 1000042) ("RADIANS" . 999959) ("RELAXED" . 999961) ("ROTATION" . 1000045) ("SAT_TILT" . 1000074) ("SEMIMAJOR_AXIS" . 1000048) ("SEMIMINOR_AXIS" . 1000050) ("SEMIMINORAXIS") ("SOM_FLAG" . 1000060) ("SOM_INCLINATION" . 1000052) ("SOM_LANDSAT_NUMBER" . 1000062) ("SOM_LANDSAT_PATH" . 1000064) ("SOM_LONGITUDE" . 1000054) ("SOM_PERIOD" . 1000056) ("SOM_RATIO" . 1000058) ("SPHERE_RADIUS" . 1000066) ("STANDARD_PAR1" . 1000070) ("STANDARD_PAR2" . 1000072) ("STANDARD_PARALLEL" . 1000068) ("TRUE_SCALE_LATITUDE" . 1000076) ("ZONE" . 1000078)))
    ("MAP_PROJ_INVERSE" fun nil (system) "Result = %s (X [, Y])" ("M13.html" ("MAP_STRUCTURE" . 1000165) ("RADIANS" . 1000170)))
    ("MATRIX_MULTIPLY" fun nil (system) "Result = %s( A, B)" ("M15.html" ("ATRANSPOSE" . 960661) ("BTRANSPOSE" . 960663)) ("tpoolkeyw2.html" ("TPOOL_MAX_ELTS" . 333417) ("TPOOL_MIN_ELTS" . 333286) ("TPOOL_NOTHREAD" . 333289)))
    ("MATRIX_POWER" fun nil (system) "Result = %s(Array, N)" ("M16.html" ("DOUBLE" . 1000204) ("STATUS" . 1000207)))
    ("MAX" fun nil (system) "Result = %s( Array [, Max_Subscript])" ("M17.html" ("DIMENSION" . 888204) ("MIN" . 963501) ("NAN" . 888207) ("SUBSCRIPT_MIN" . 929038)) ("tpoolkeyw2.html" ("TPOOL_MAX_ELTS" . 333417) ("TPOOL_MIN_ELTS" . 333286) ("TPOOL_NOTHREAD" . 333289)))
    ("MD_TEST" fun nil (system) "Result = %s( X)" ("M18.html" ("ABOVE" . 888251) ("BELOW" . 888254) ("MDC" . 888257)))
    ("MEAN" fun nil (system) "Result = %s( X)" ("M19.html" ("DOUBLE" . 888313) ("NAN" . 888316)))
    ("MEANABSDEV" fun nil (system) "Result = %s( X)" ("M20.html" ("DOUBLE" . 888362) ("MEDIAN" . 888365) ("NAN" . 888368)))
    ("MEDIAN" fun nil (system) "Result = %s( Array [, Width])" ("M21.html" ("DIMENSION" . 978207) ("EVEN" . 978204)))
    ("MEMORY" fun nil (system) "Result = %s()" ("M22.html" ("CURRENT" . 960747) ("HIGHWATER" . 960749) ("L64" . 960751) ("NUM_ALLOC" . 960754) ("NUM_FREE" . 960756) ("STRUCTURE" . 960758)))
    ("MESH_CLIP" fun nil (system) "Result = %s (Plane, Vertsin, Connin, Vertsout, Connout)" ("M23.html" ("AUXDATA_IN" . 948402) ("AUXDATA_OUT" . 948404) ("CUT_VERTS" . 948406)))
    ("MESH_DECIMATE" fun nil (system) "Result = %s (Verts, Conn, Connout)" ("M24.html" ("PERCENT_POLYGONS" . 948433) ("PERCENT_VERTICES" . 948431) ("VERTICES" . 948436)))
    ("MESH_ISSOLID" fun nil (system) "Result = %s (Conn)" ("M25.html"))
    ("MESH_MERGE" fun nil (system) "Result = %s (Verts, Conn, Verts1, Conn1)" ("M26.html" ("COMBINE_VERTICES" . 948474) ("TOLERANCE" . 948480)))
    ("MESH_NUMTRIANGLES" fun nil (system) "Result = %s (Conn)" ("M27.html"))
    ("MESH_SMOOTH" fun nil (system) "Result = %s (Verts, Conn)" ("M29.html" ("FIXED_EDGE_VERTICES" . 948537) ("FIXED_VERTICES" . 948535) ("ITERATIONS" . 948533) ("LAMBDA" . 948539)))
    ("MESH_SURFACEAREA" fun nil (system) "Result = %s ( Verts, Conn)" ("M30.html" ("AUXDATA" . 948575) ("MOMENT" . 948577)))
    ("MESH_VALIDATE" fun nil (system) "Result = %s ( Verts, Conn)" ("M31.html" ("COMBINE_VERTICES" . 948607) ("PACK_VERTICES" . 949513) ("REMOVE_NAN" . 948611) ("TOLERANCE" . 948613)))
    ("MESH_VOLUME" fun nil (system) "Result = %s ( Verts, Conn)" ("M32.html" ("SIGNED" . 948632)))
    ("MIN" fun nil (system) "Result = %s( Array [, Min_Subscript])" ("M34.html" ("DIMENSION" . 965599) ("MAX" . 963567) ("NAN" . 888740) ("SUBSCRIPT_MAX" . 965815)) ("tpoolkeyw2.html" ("TPOOL_MAX_ELTS" . 333417) ("TPOOL_MIN_ELTS" . 333286) ("TPOOL_NOTHREAD" . 333289)))
    ("MIN_CURVE_SURF" fun nil (system) "Result = %s(Z [, X, Y])" ("M35.html" ("BOUNDS" . 888798) ("CONST" . 956696) ("DOUBLE" . 929725) ("GS" . 888796) ("NX" . 888800) ("NY" . 888802) ("REGULAR" . 888785) ("SPHERE" . 956689) ("TPS" . 888782) ("XGRID" . 888787) ("XOUT" . 888804) ("XPOUT" . 888808) ("XVALUES" . 888789) ("YGRID" . 888791) ("YOUT" . 888806) ("YPOUT" . 888808) ("YVALUES" . 888793)))
    ("MOMENT" fun nil (system) "Result = %s( X)" ("M38.html" ("DOUBLE" . 888958) ("MDEV" . 888961) ("NAN" . 888964) ("SDEV" . 888970)))
    ("MORPH_CLOSE" fun nil (system) "Result = %s (Image, Structure)" ("M39.html" ("GRAY" . 948649) ("PRESERVE_TYPE" . 948651) ("UINT" . 948653) ("ULONG" . 948655) ("VALUES" . 948657)))
    ("MORPH_DISTANCE" fun nil (system) "Result = %s (Data)" ("M40.html" ("BACKGROUND" . 948898) ("NEIGHBOR_SAMPLING" . 948900) ("NO_COPY" . 948943)))
    ("MORPH_GRADIENT" fun nil (system) "Result = %s (Image, Structure)" ("M41.html" ("PRESERVE_TYPE" . 948983) ("UINT" . 948985) ("ULONG" . 948987) ("VALUES" . 948989)))
    ("MORPH_HITORMISS" fun nil (system) "Result = %s (Image, HitStructure, MissStructure)" ("M42.html"))
    ("MORPH_OPEN" fun nil (system) "Result = %s (Image, Structure)" ("M43.html" ("GRAY" . 949085) ("PRESERVE_TYPE" . 949087) ("UINT" . 949089) ("ULONG" . 949091) ("VALUES" . 949093)))
    ("MORPH_THIN" fun nil (system) "Result = %s ( Image, HitStructure, MissStructure )" ("M44.html"))
    ("MORPH_TOPHAT" fun nil (system) "Result = %s ( Image, Structure)" ("M45.html" ("PRESERVE_TYPE" . 949148) ("UINT" . 949150) ("ULONG" . 949152) ("VALUES" . 949154)))
    ("MPEG_OPEN" fun nil (system) "mpegID = %s( Dimensions)" ("M47.html" ("BITRATE" . 958969) ("FILENAME" . 958930) ("IFRAME_GAP" . 958935) ("MOTION_VEC_LENGTH" . 958939) ("QUALITY" . 958887)))
    ("MSG_CAT_OPEN" fun nil (system) "Result = %s( application)" ("M52.html" ("DEFAULT_FILENAME" . 931071) ("FILENAME" . 931074) ("FOUND" . 931077) ("LOCALE" . 931080) ("PATH" . 931083) ("SUB_QUERY" . 931086)))
    ("N_ELEMENTS" fun nil (system) "Result = %s(Expression)" ("N.html"))
    ("N_PARAMS" fun nil (system) "Result = %s()" ("N2.html"))
    ("N_TAGS" fun nil (system) "Result = %s( Expression)" ("N3.html" ("DATA_LENGTH" . 889267) ("LENGTH" . 928988)))
    ("NCDF_ATTCOPY" fun nil (system) "Result = %s( Incdf [, Invar])" ("NetCDF-routines10.html" ("IN_GLOBAL" . 996938) ("OUT_GLOBAL" . 996942)))
    ("NCDF_ATTINQ" fun nil (system) "Result = %s( Cdfid [, Varid])" ("NetCDF-routines13.html" ("GLOBAL" . 997032)))
    ("NCDF_ATTNAME" fun nil (system) "Result = %s( Cdfid [, Varid])" ("NetCDF-routines14.html" ("GLOBAL" . 997094)))
    ("NCDF_CREATE" fun nil (system) "Result = %s( Filename)" ("NetCDF-routines19.html" ("CLOBBER" . 997292) ("NOCLOBBER" . 997295)))
    ("NCDF_DIMDEF" fun nil (system) "Result = %s( Cdfid, DimName, Size)" ("NetCDF-routines20.html" ("UNLIMITED" . 997333)))
    ("NCDF_DIMID" fun nil (system) "Result = %s( Cdfid, DimName )" ("NetCDF-routines21.html"))
    ("NCDF_EXISTS" fun nil (system) "Result = %s( )" ("NetCDF-routines24.html"))
    ("NCDF_INQUIRE" fun nil (system) "Result = %s(Cdfid)" ("NetCDF-routines25.html"))
    ("NCDF_OPEN" fun nil (system) "Result = %s( Filename)" ("NetCDF-routines26.html" ("NOWRITE" . 997434) ("WRITE" . 997437)))
    ("NCDF_VARDEF" fun nil (system) "Result = %s( Cdfid, Name [, Dim])" ("NetCDF-routines27.html" ("BYTE" . 997458) ("CHAR" . 997461) ("DOUBLE" . 997464) ("FLOAT" . 997467) ("LONG" . 997470) ("SHORT" . 997473)))
    ("NCDF_VARID" fun nil (system) "Result = %s(Cdfid, Name)" ("NetCDF-routines30.html"))
    ("NCDF_VARINQ" fun nil (system) "Result = %s(Cdfid, Varid)" ("NetCDF-routines31.html"))
    ("NEWTON" fun nil (system) "Result = %s( X, Vecfunc)" ("N4.html" ("CHECK" . 889318) ("DOUBLE" . 889321) ("ITMAX" . 928608) ("STEPMAX" . 889327) ("TOLF" . 889330) ("TOLMIN" . 889334) ("TOLX" . 889337)))
    ("NORM" fun nil (system) "Result = %s( A)" ("N5.html" ("DOUBLE" . 889381) ("LNORM" . 929047)))
    ("OBJ" fun nil (system) "array = %s -> [IDLffDICOM]GetElement( [Group [, Element]])" ("objects49.html" ("REFERENCE" . 1334779)))
    ("OBJ_CLASS" fun nil (system) "Result = %s( [Arg])" ("O.html" ("COUNT" . 889415) ("SUPERCLASS" . 889418)))
    ("OBJ_ISA" fun nil (system) "Result = %s(ObjectInstance, ClassName)" ("O3.html"))
    ("OBJ_NEW" fun nil (system) "Result = %s( [ObjectClassName [, Arg1......Argn]] )" ("O4.html"))
    ("OBJ_VALID" fun nil (system) "Result = %s( [Arg])" ("O5.html" ("CAST" . 889505) ("COUNT" . 889508)))
    ("OBJARR" fun nil (system) "Result = %s( D1 [, ..., D8])" ("O6.html" ("NOZERO" . 889547)))
    ("P_CORRELATE" fun nil (system) "Result = %s( X, Y, C)" ("P.html" ("DOUBLE" . 1073021)))
    ("PATH_SEP" fun nil (system) "Result = %s()" ("P3.html" ("PARENT_DIRECTORY" . 1076856) ("SEARCH_PATH" . 1076858)))
    ("PCOMP" fun nil (system) "Result = %s( A)" ("P4.html" ("COEFFICIENTS" . 844766) ("COVARIANCE" . 844768) ("DOUBLE" . 844770) ("EIGENVALUES" . 844772) ("NVARIABLES" . 844774) ("STANDARDIZE" . 844776) ("VARIANCES" . 844778)))
    ("PNT_LINE" fun nil (system) "Result = %s( P0, L0, L1 [, Pl])" ("P10.html" ("INTERVAL" . 758337)))
    ("POLAR_SURFACE" fun nil (system) "Result = %s( Z, R, Theta)" ("P13.html" ("BOUNDS" . 753641) ("GRID" . 753637) ("MISSING" . 753645) ("QUINTIC" . 753643) ("SPACING" . 753639)))
    ("POLY" fun nil (system) "Result = %s(X, C)" ("P14.html"))
    ("POLY_2D" fun nil (system) "Result = %s( Array, P, Q [, Interp [, Dimx, Dimy]])" ("P15.html" ("CUBIC" . 678217) ("MISSING" . 680892)) ("tpoolkeyw2.html" ("TPOOL_MAX_ELTS" . 333417) ("TPOOL_MIN_ELTS" . 333286) ("TPOOL_NOTHREAD" . 333289)))
    ("POLY_AREA" fun nil (system) "Result = %s( X, Y)" ("P16.html" ("DOUBLE" . 1074988) ("SIGNED" . 1074986)))
    ("POLY_FIT" fun nil (system) "Result = %s( X, Y, Degree)" ("P17.html" ("CHISQ" . 1073859) ("COVAR" . 1073862) ("DOUBLE" . 837040) ("MEASURE_ERRORS" . 1074498) ("SIGMA" . 1074050) ("STATUS" . 1073417) ("YBAND" . 1074058) ("YERROR" . 1074060) ("YFIT" . 1074062)))
    ("POLYFILLV" fun nil (system) "Result = %s( X, Y, Sx, Sy [, Run_Length] )" ("P19.html"))
    ("POLYSHADE" fun nil (system) "Result = %s( Vertices, Polygons) or Result = POLYSHADE(X, Y, Z, Polygons)" ("P20.html" ("DATA" . 678323) ("NORMAL" . 678325) ("POLY_SHADES" . 678327) ("SHADES" . 678329) ("T3D" . 678331) ("TOP" . 678333) ("XSIZE" . 678335) ("YSIZE" . 678338)))
    ("PRIMES" fun nil (system) "Result = %s(K)" ("P24.html"))
    ("PRODUCT" fun nil (system) "Result = %s(Array [, Dimension])" ("P28.html" ("CUMULATIVE" . 1088999) ("NAN" . 1089001)) ("tpoolkeyw2.html" ("TPOOL_MAX_ELTS" . 333417) ("TPOOL_MIN_ELTS" . 333286) ("TPOOL_NOTHREAD" . 333289)))
    ("PROFILE" fun nil (system) "Result = %s( Image [, XX, YY])" ("P29.html" ("NOMARK" . 757684) ("XSTART" . 757687) ("YSTART" . 757690)))
    ("PROJECT_VOL" fun nil (system) "Return = %s( Vol, X_Sample, Y_Sample, Z_Sample)" ("P32.html" ("DEPTH_Q" . 786865) ("OPAQUE" . 786868) ("TRANS" . 786871)))
    ("PTR_NEW" fun nil (system) "Result = %s( [InitExpr])" ("P37.html" ("ALLOCATE_HEAP" . 845063) ("NO_COPY" . 845065)))
    ("PTR_VALID" fun nil (system) "Result = %s( [Arg])" ("P38.html" ("CAST" . 863586) ("COUNT" . 863622)))
    ("PTRARR" fun nil (system) "Result = %s( D1, ... ..., D8)" ("P39.html" ("ALLOCATE_HEAP" . 845095) ("NOZERO" . 845097)))
    ("QGRID3" fun nil (system) "Result = %s( XYZ, F, Tetrahedra)" ("Q.html" ("DELTA" . 1073303) ("DIMENSION" . 1073305) ("MISSING" . 1073307) ("START" . 1073309)))
    ("QROMB" fun nil (system) "Result = %s( Func, A, B)" ("Q3.html" ("DOUBLE" . 51533) ("EPS" . 51536) ("JMAX" . 51539) ("K" . 51542)))
    ("QROMO" fun nil (system) "Result = %s(Func, A [, B])" ("Q4.html" ("DOUBLE" . 51594) ("EPS" . 51597) ("JMAX" . 51600) ("K" . 51603) ("MIDEXP" . 51606) ("MIDINF" . 51609) ("MIDPNT" . 51612) ("MIDSQL" . 51615) ("MIDSQU" . 51618)))
    ("QSIMP" fun nil (system) "Result = %s( Func, A, B)" ("Q5.html" ("DOUBLE" . 51671) ("EPS" . 51674) ("JMAX" . 51677)))
    ("QUERY_BMP" fun nil (system) "Result = %s ( Filename [, Info] )" ("Q7.html"))
    ("QUERY_DICOM" fun nil (system) "Result = %s( Filename [, Info])" ("Q8.html" ("IMAGE_INDEX" . 1045358)))
    ("QUERY_IMAGE" fun nil (system) "Result = %s ( Filename[, Info])" ("Q9.html" ("CHANNELS" . 1070109) ("DIMENSIONS" . 1070111) ("HAS_PALETTE" . 1070113) ("IMAGE_INDEX" . 1070115) ("NUM_IMAGES" . 1070117) ("PIXEL_TYPE" . 1070119) ("SUPPORTED_READ" . 1070131) ("SUPPORTED_WRITE" . 1070133) ("TYPE" . 1070135)))
    ("QUERY_JPEG" fun nil (system) "Result = %s ( Filename [, Info] )" ("Q10.html"))
    ("QUERY_MRSID" fun nil (system) "Result = %s( Filename [, Info])" ("Q11.html" ("LEVEL" . 1073601)))
    ("QUERY_PICT" fun nil (system) "Result = %s ( Filename [, Info] )" ("Q12.html"))
    ("QUERY_PNG" fun nil (system) "Result = %s ( Filename [, Info] )" ("Q13.html"))
    ("QUERY_PPM" fun nil (system) "Result = %s ( Filename [, Info])" ("Q14.html" ("MAXVAL" . 1045715)))
    ("QUERY_SRF" fun nil (system) "Result = %s (Filename [, Info] )" ("Q15.html"))
    ("QUERY_TIFF" fun nil (system) "Result = %s ( Filename [, Info])" ("Q16.html" ("IMAGE_INDEX" . 1045788)))
    ("QUERY_WAV" fun nil (system) "Result = %s ( Filename[, Info] )" ("Q17.html"))
    ("R_CORRELATE" fun nil (system) "Result = %s( X, Y)" ("R.html" ("D" . 54014) ("KENDALL" . 54017) ("PROBD" . 54020) ("ZD" . 54023)))
    ("R_TEST" fun nil (system) "Result = %s( X)" ("R2.html" ("N0" . 54060) ("N1" . 54063) ("R" . 54066)))
    ("RADON" fun nil (system) "Result = %s( Array)" ("R3.html" ("BACKPROJECT" . 1081929) ("DOUBLE" . 1081932) ("DRHO" . 1081934) ("DX" . 1081936) ("DY" . 1081938) ("GRAY" . 1081940) ("LINEAR" . 1081942) ("NRHO" . 1081944) ("NTHETA" . 1081946) ("NX" . 1081948) ("NY" . 1081950) ("RHO" . 1081952) ("RMIN" . 1081954) ("THETA" . 1081956) ("XMIN" . 1081958) ("YMIN" . 1081960)))
    ("RANDOMN" fun nil (system) "Result = %s( Seed [, D1 [, ..., D8]])" ("R4.html" ("BINOMIAL" . 867947) ("DOUBLE" . 867736) ("GAMMA" . 1080709) ("LONG" . 1080819) ("NORMAL" . 867741) ("POISSON" . 867743) ("UNIFORM" . 867744)))
    ("RANDOMU" fun nil (system) "Result = %s( Seed [, D1 [, ..., D8]])" ("R5.html" ("BINOMIAL" . 868252) ("DOUBLE" . 1080874) ("GAMMA" . 868213) ("LONG" . 1080854) ("NORMAL" . 868216) ("POISSON" . 868219) ("UNIFORM" . 868222)))
    ("RANKS" fun nil (system) "Result = %s(X)" ("R6.html"))
    ("READ_ASCII" fun nil (system) "Result = %s( [Filename])" ("R9.html" ("COMMENT_SYMBOL" . 864824) ("COUNT" . 864541) ("DATA_START" . 864606) ("DELIMITER" . 865250) ("HEADER" . 865253) ("MISSING_VALUE" . 864515) ("NUM_RECORDS" . 864373) ("RECORD_START" . 678426) ("TEMPLATE" . 863940) ("VERBOSE" . 863965)))
    ("READ_BINARY" fun nil (system) "Result = %s ([Filename] | FileUnit)" ("R10.html" ("DATA_DIMS" . 1071927) ("DATA_START" . 1071929) ("DATA_TYPE" . 1071931) ("ENDIAN" . 1071933) ("TEMPLATE" . 1071937)))
    ("READ_BMP" fun nil (system) "Result = %s( Filename, [, R, G, B] [, Ihdr])" ("R11.html" ("RGB" . 867600)))
    ("READ_DICOM" fun nil (system) "Result = %s (Filename [, Red, Green, Blue])" ("R12.html" ("IMAGE_INDEX" . 1045423)))
    ("READ_IMAGE" fun nil (system) "Result = %s (Filename [, Red, Green, Blue])" ("R13.html" ("IMAGE_INDEX" . 1071963)))
    ("READ_MRSID" fun nil (system) "Result = %s ( Filename)" ("R16.html" ("LEVEL" . 1086317) ("SUB_RECT" . 1086319)))
    ("READ_PNG" fun nil (system) "Result = %s ( Filename [, R, G, B])" ("R18.html" ("ORDER" . 1045842) ("TRANSPARENT" . 1045845) ("VERBOSE" . 1075225)))
    ("READ_SPR" fun nil (system) "Result = %s(Filename)" ("R20.html"))
    ("READ_SYLK" fun nil (system) "Result = %s( File)" ("R22.html" ("ARRAY" . 67837) ("COLMAJOR" . 67840) ("NCOLS" . 67844) ("NROWS" . 67847) ("STARTCOL" . 67850) ("STARTROW" . 67853) ("USEDOUBLES" . 67856) ("USELONGS" . 67859)))
    ("READ_TIFF" fun nil (system) "Result = %s( Filename [, R, G, B])" ("R23.html" ("CHANNELS" . 1078044) ("GEOTIFF" . 966463) ("IMAGE_INDEX" . 966504) ("INTERLEAVE" . 1077871) ("ORIENTATION" . 948922) ("PLANARCONFIG" . 1086578) ("SUB_RECT" . 966525) ("VERBOSE" . 966492)))
    ("READ_WAV" fun nil (system) "Result = %s ( Filename [, Rate] )" ("R24.html"))
    ("READ_XWD" fun nil (system) "Result = %s( Filename[, R, G, B] )" ("R27.html"))
    ("REAL_PART" fun nil (system) "Result = %s(Z)" ("R30.html"))
    ("REBIN" fun nil (system) "Result = %s( Array, D1 [, ..., D8])" ("R31.html" ("SAMPLE" . 678500)))
    ("RECALL_COMMANDS" fun nil (system) "Result = %s()" ("R32.html"))
    ("RECON3" fun nil (system) "Result = %s( Images, Obj_Rot, Obj_Pos, Focal, Dist,Vol_Pos, Img_Ref, Img_Mag, Vol_Size)" ("R33.html" ("CUBIC" . 1079063) ("MISSING" . 787003) ("MODE" . 787006) ("QUIET" . 1086709)))
    ("REFORM" fun nil (system) "Result = %s( Array, D1 [, ..., D8])" ("R35.html" ("OVERWRITE" . 678529)))
    ("REGION_GROW" fun nil (system) "Result = %s(Array, ROIPixels)" ("R36.html" ("ALL_NEIGHBORS" . 1086463) ("STDDEV_MULTIPLIER" . 1086465) ("THRESHOLD" . 1086469)))
    ("REGRESS" fun nil (system) "Result = %s( X, Y)" ("R38.html" ("CHISQ" . 1078522) ("CONST" . 1078527) ("CORRELATION" . 1078530) ("DOUBLE" . 1078533) ("FTEST" . 1078535) ("MCORRELATION" . 1078538) ("MEASURE_ERRORS" . 1080427) ("RELATIVE_WEIGHT" . 1080465) ("SIGMA" . 1080460) ("STATUS" . 1078543) ("YFIT" . 1078803)))
    ("REPLICATE" fun nil (system) "Result = %s( Value, D1 [, ..., D8] )" ("R40.html") ("tpoolkeyw2.html" ("TPOOL_MAX_ELTS" . 333417) ("TPOOL_MIN_ELTS" . 333286) ("TPOOL_NOTHREAD" . 333289)))
    ("REVERSE" fun nil (system) "Result = %s( Array [, Subscript_Index])" ("R47.html" ("OVERWRITE" . 1077839)))
    ("RK4" fun nil (system) "Result = %s( Y, Dydx, X, H, Derivs)" ("R48.html" ("DOUBLE" . 51771)))
    ("ROBERTS" fun nil (system) "Result = %s(Image)" ("R49.html"))
    ("ROT" fun nil (system) "Result = %s( A, Angle, [Mag, X0, Y0])" ("R50.html" ("CUBIC" . 758912) ("INTERP" . 758909) ("MISSING" . 758915) ("PIVOT" . 758918)))
    ("ROTATE" fun nil (system) "Result = %s(Array, Direction)" ("R51.html"))
    ("ROUND" fun nil (system) "Result = %s(X)" ("R52.html" ("L64" . 1073244)) ("tpoolkeyw2.html" ("TPOOL_MAX_ELTS" . 333417) ("TPOOL_MIN_ELTS" . 333286) ("TPOOL_NOTHREAD" . 333289)))
    ("ROUTINE_INFO" fun nil (system) "Result = %s( [Routine])" ("R53.html" ("DISABLED" . 1068792) ("ENABLED" . 1068823) ("FUNCTIONS" . 1068790) ("PARAMETERS" . 845189) ("SOURCE" . 845200) ("SYSTEM" . 845207) ("UNRESOLVED" . 845209) ("VARIABLES" . 845211)))
    ("RS_TEST" fun nil (system) "Result = %s( X, Y)" ("R54.html" ("UX" . 54144) ("UY" . 54147)))
    ("S_TEST" fun nil (system) "Result = %s( X, Y)" ("S.html" ("ZDIFF" . 54194)))
    ("SAVGOL" fun nil (system) "Result = %s( Nleft, Nright, Order, Degree)" ("S3.html" ("DOUBLE" . 1098051)))
    ("SEARCH2D" fun nil (system) "Result = %s( Array, Xpos, Ypos, Min_Val, Max_Val)" ("S6.html" ("DECREASE" . 758963) ("DIAGONAL" . 758972) ("INCREASE" . 758966) ("LPF_BAND" . 758969)))
    ("SEARCH3D" fun nil (system) "Result = %s( Array, Xpos, Ypos, Zpos, Min_Val, Max_Val)" ("S7.html" ("DECREASE" . 759017) ("DIAGONAL" . 759026) ("INCREASE" . 759020) ("LPF_BAND" . 759023)))
    ("SFIT" fun nil (system) "Result = %s( Data, Degree)" ("S12.html" ("KX" . 754097)))
    ("SHIFT" fun nil (system) "Result = %s(Array, S1, ..., Sn)" ("S16.html"))
    ("SHMDEBUG" fun nil (system) "Result = %s(Enable)" ("S17.html"))
    ("SHMVAR" fun nil (system) "Result = %s(SegmentName [, D1, ..., D8])" ("S20.html" ("BYTE" . 1143650) ("COMPLEX" . 1143652) ("DCOMPLEX" . 1143654) ("DIMENSION" . 1143656) ("DOUBLE" . 1143658) ("FLOAT" . 1143660) ("INTEGER" . 1143662) ("L64" . 1143664) ("LONG" . 1143666) ("SIZE" . 1143668) ("TEMPLATE" . 1143673) ("TYPE" . 1143675) ("UINT" . 1143680) ("UL64" . 1143684) ("ULONG" . 1143682)))
    ("SIMPLEX" fun nil (system) "Result = %s( Zequation, Constraints, M1, M2, M3 [, Tableau [, Izrov [, Iposv]]])" ("S23.html" ("DOUBLE" . 1103779) ("EPS" . 1103781) ("STATUS" . 1103783)))
    ("SIN" fun nil (system) "Result = %s(X)" ("S24.html") ("tpoolkeyw2.html" ("TPOOL_MAX_ELTS" . 333417) ("TPOOL_MIN_ELTS" . 333286) ("TPOOL_NOTHREAD" . 333289)))
    ("SINDGEN" fun nil (system) "Result = %s(D1 [, ..., D8])" ("S25.html"))
    ("SINH" fun nil (system) "Result = %s(X)" ("S26.html") ("tpoolkeyw2.html" ("TPOOL_MAX_ELTS" . 333417) ("TPOOL_MIN_ELTS" . 333286) ("TPOOL_NOTHREAD" . 333289)))
    ("SIZE" fun nil (system) "Result = %s( Expression)" ("S27.html" ("DIMENSIONS" . 901281) ("FILE_LUN" . 901288) ("L64" . 1082592) ("N_DIMENSIONS" . 1082662) ("N_ELEMENTS" . 901298) ("STRUCTURE" . 901301) ("TNAME" . 901328) ("TYPE" . 901331)))
    ("SKEWNESS" fun nil (system) "Result = %s( X)" ("S28.html" ("DOUBLE" . 901912) ("NAN" . 903224)))
    ("SMOOTH" fun nil (system) "Result = %s( Array, Width)" ("S32.html" ("EDGE_TRUNCATE" . 113915) ("MISSING" . 1101098) ("NAN" . 1101095)))
    ("SOBEL" fun nil (system) "Result = %s(Image)" ("S33.html"))
    ("SORT" fun nil (system) "Result = %s(Array)" ("S35.html" ("L64" . 1082892)))
    ("SPH_SCAT" fun nil (system) "Result = %s( Lon, Lat, F)" ("S38.html" ("BOUNDS" . 126851) ("BOUT" . 126868) ("GOUT" . 126871) ("GS" . 126862) ("NLAT" . 126875) ("NLON" . 126858)))
    ("SPHER_HARM" fun nil (system) "Result = %s( Theta, Phi, L, M)" ("S39.html" ("DOUBLE" . 1098257)))
    ("SPL_INIT" fun nil (system) "Result = %s( X, Y)" ("S40.html" ("DOUBLE" . 51818) ("YP0" . 51822) ("YPN_1" . 1095878)))
    ("SPL_INTERP" fun nil (system) "Result = %s( X, Y, Y2, X2)" ("S41.html" ("DOUBLE" . 51859)))
    ("SPLINE" fun nil (system) "Result = %s( X, Y, T [, Sigma] )" ("S42.html"))
    ("SPRSAB" fun nil (system) "Result = %s( A, B)" ("S44.html" ("DOUBLE" . 51917) ("THRESHOLD" . 51920)))
    ("SPRSAX" fun nil (system) "Result = %s( A, X)" ("S45.html" ("DOUBLE" . 51985)))
    ("SPRSIN" fun nil (system) "Result = %s( A)" ("S46.html" ("COLUMN" . 58754) ("DOUBLE" . 52033) ("THRESHOLD" . 52036)))
    ("SPRSTP" fun nil (system) "Result = %s(A)" ("S47.html"))
    ("SQRT" fun nil (system) "Result = %s(X)" ("S48.html") ("tpoolkeyw2.html" ("TPOOL_MAX_ELTS" . 333417) ("TPOOL_MIN_ELTS" . 333286) ("TPOOL_NOTHREAD" . 333289)))
    ("STANDARDIZE" fun nil (system) "Result = %s( A)" ("S49.html" ("DOUBLE" . 844918)))
    ("STDDEV" fun nil (system) "Result = %s( X)" ("S50.html" ("DOUBLE" . 901885) ("NAN" . 903234)))
    ("STRARR" fun nil (system) "Result = %s(D1 [, ..., D8])" ("S52.html"))
    ("STRCMP" fun nil (system) "Result = %s( String1, String2 [, N])" ("S53.html" ("FOLD_CASE" . 1069071)))
    ("STRCOMPRESS" fun nil (system) "Result = %s( String)" ("S54.html" ("REMOVE_ALL" . 679044)))
    ("STREGEX" fun nil (system) "Result = %s( StringExpression, RegularExpression)" ("S56.html" ("BOOLEAN" . 1069164) ("EXTRACT" . 1069170) ("FOLD_CASE" . 1069177) ("LENGTH" . 1069182) ("SUBEXPR" . 1069190)))
    ("STRING" fun nil (system) "Result = %s( Expression1, ..., Expressionn)" ("S58.html" ("AM_PM" . 1015738) ("DAYS_OF_WEEK" . 1015740) ("FORMAT" . 1015736) ("MONTHS" . 1015759) ("PRINT" . 679063)))
    ("STRJOIN" fun nil (system) "Result = %s( String [, Delimiter])" ("S59.html" ("SINGLE" . 1070986)))
    ("STRLEN" fun nil (system) "Result = %s(Expression)" ("S60.html"))
    ("STRLOWCASE" fun nil (system) "Result = %s(String)" ("S61.html"))
    ("STRMATCH" fun nil (system) "Result = %s( String, SearchString)" ("S62.html" ("FOLD_CASE" . 1071246)))
    ("STRMESSAGE" fun nil (system) "Result = %s( Err)" ("S63.html" ("BLOCK" . 923971) ("CODE" . 923974) ("NAME" . 923979)))
    ("STRMID" fun nil (system) "Result = %s(Expression, First_Character [, Length])" ("S64.html" ("REVERSE_OFFSET" . 1074174)))
    ("STRPOS" fun nil (system) "Result = %s( Expression, Search String [, Pos])" ("S65.html" ("REVERSE_OFFSET" . 1074185) ("REVERSE_SEARCH" . 1074254)))
    ("STRSPLIT" fun nil (system) "Result = %s( String [, Pattern])" ("S67.html" ("ESCAPE" . 1071730) ("EXTRACT" . 1071749) ("FOLD_CASE" . 1071757) ("LENGTH" . 1071761) ("PRESERVE_NULL" . 1071767) ("REGEX" . 1071772)))
    ("STRTRIM" fun nil (system) "Result = %s( String [, Flag] )" ("S68.html"))
    ("STRUPCASE" fun nil (system) "Result = %s(String)" ("S71.html"))
    ("SVDFIT" fun nil (system) "Result = %s( X, Y [, M])" ("S75.html" ("A" . 845481) ("CHISQ" . 845501) ("COVAR" . 845503) ("DOUBLE" . 845488) ("FUNCTION_NAME" . 754160) ("LEGENDRE" . 1093586) ("MEASURE_ERRORS" . 1094756) ("SIGMA" . 1093549) ("SING_VALUES" . 1144017) ("SINGULAR" . 845513) ("STATUS" . 1143910) ("TOL" . 1144024) ("VARIANCE" . 845515) ("WEIGHTS" . 1093555) ("YFIT" . 754165)))
    ("SVSOL" fun nil (system) "Result = %s( U, W, V, B)" ("S76.html" ("COLUMN" . 58776) ("DOUBLE" . 52150)))
    ("SWAP_ENDIAN" fun nil (system) "Result = %s(Variable)" ("S77.html" ("SWAP_IF_BIG_ENDIAN" . 1110629) ("SWAP_IF_LITTLE_ENDIAN" . 1110632)))
    ("SYSTIME" fun nil (system) "String = %s( [0 [, ElaspedSeconds]])" ("S80.html" ("JULIAN" . 1015505) ("SECONDS" . 1015507) ("UTC" . 1083080)))
    ("T_CVF" fun nil (system) "Result = %s(P, Df)" ("T.html"))
    ("T_PDF" fun nil (system) "Result = %s(V, Df)" ("T2.html"))
    ("TAG_NAMES" fun nil (system) "Result = %s( Expression)" ("T4.html" ("STRUCTURE_NAME" . 679363)))
    ("TAN" fun nil (system) "Result = %s(X)" ("T5.html") ("tpoolkeyw2.html" ("TPOOL_MAX_ELTS" . 333417) ("TPOOL_MIN_ELTS" . 333286) ("TPOOL_NOTHREAD" . 333289)))
    ("TANH" fun nil (system) "Result = %s(X)" ("T6.html") ("tpoolkeyw2.html" ("TPOOL_MAX_ELTS" . 333417) ("TPOOL_MIN_ELTS" . 333286) ("TPOOL_NOTHREAD" . 333289)))
    ("TEMPORARY" fun nil (system) "Result = %s(Variable)" ("T8.html"))
    ("TETRA_CLIP" fun nil (system) "Result = %s ( Plane, Vertsin, Connin, Vertsout, Connout)" ("T9.html" ("AUXDATA_IN" . 1071827) ("AUXDATA_OUT" . 1071829) ("CUT_VERTS" . 1071831)))
    ("TETRA_SURFACE" fun nil (system) "Result = %s (Verts, Connin)" ("T10.html"))
    ("TETRA_VOLUME" fun nil (system) "Result = %s ( Verts, Conn)" ("T11.html" ("AUXDATA" . 1071864) ("MOMENT" . 1071866)))
    ("THIN" fun nil (system) "Result = %s( Image)" ("T12.html" ("NEIGHBOR_COUNT" . 1069698) ("PRUNE" . 1069716)))
    ("TIMEGEN" fun nil (system) "Result = %s( [D1,...,D8])" ("T15.html" ("DAYS" . 1077148) ("FINAL" . 1077151) ("HOURS" . 1077154) ("MINUTES" . 1077156) ("MONTHS" . 1077158) ("SECONDS" . 1077160) ("START" . 1077162) ("STEP_SIZE" . 1077166) ("UNITS" . 1077168) ("YEAR" . 1077211)))
    ("TM_TEST" fun nil (system) "Result = %s( X, Y)" ("T16.html" ("PAIRED" . 54299) ("UNEQUAL" . 54302)))
    ("TOTAL" fun nil (system) "Result = %s( Array [, Dimension])" ("T17.html" ("CUMULATIVE" . 1070565) ("DOUBLE" . 1070569) ("NAN" . 47220)) ("tpoolkeyw2.html" ("TPOOL_MAX_ELTS" . 333417) ("TPOOL_MIN_ELTS" . 333286) ("TPOOL_NOTHREAD" . 333289)))
    ("TRACE" fun nil (system) "Result = %s( A)" ("T18.html" ("DOUBLE" . 845005)))
    ("TRANSPOSE" fun nil (system) "Result = %s( Array [, P] )" ("T19.html"))
    ("TRI_SURF" fun nil (system) "Result = %s( Z [, X, Y])" ("T20.html" ("BOUNDS" . 758634) ("EXTRAPOLATE" . 758607) ("GS" . 758631) ("LINEAR" . 758610) ("MISSING" . 949473) ("NX" . 758637) ("NY" . 758640) ("REGULAR" . 851712) ("XGRID" . 758617) ("XVALUES" . 758620) ("YGRID" . 758623) ("YVALUES" . 758626)))
    ("TRIGRID" fun nil (system) "Result = %s( X, Y, Z, Triangles [, GS, Limits] ) or Result = TRIGRID( F , GS, Limits)" ("T22.html" ("DEGREES" . 679620) ("EXTRAPOLATE" . 126730) ("INPUT" . 128106) ("MAX_VALUE" . 128088) ("MIN_VALUE" . 128089) ("MISSING" . 679622) ("NX" . 1076987) ("NY" . 1076989) ("QUINTIC" . 679624) ("SPHERE" . 126737) ("XGRID" . 837019) ("XOUT" . 1075935) ("YGRID" . 837021) ("YOUT" . 1075879)))
    ("TRISOL" fun nil (system) "Result = %s( A, B, C, R)" ("T25.html" ("DOUBLE" . 52330)))
    ("TS_COEF" fun nil (system) "Result = %s( X, P)" ("T27.html" ("DOUBLE" . 1076434) ("MSE" . 54734)))
    ("TS_DIFF" fun nil (system) "Result = %s( X, K)" ("T28.html" ("DOUBLE" . 861958)))
    ("TS_FCAST" fun nil (system) "Result = %s( X, P, Nvalues)" ("T29.html" ("BACKCAST" . 223046) ("DOUBLE" . 223055)))
    ("TS_SMOOTH" fun nil (system) "Result = %s( X, Nvalues)" ("T30.html" ("BACKWARD" . 223123) ("DOUBLE" . 223168) ("FORWARD" . 223093) ("ORDER" . 223094)))
    ("TVRD" fun nil (system) "Result = %s( [X0 [, Y0 [, Nx [, Ny [, Channel]]]]])" ("T34.html" ("CHANNEL" . 679790) ("ORDER" . 679793) ("TRUE" . 679795) ("WORDS" . 679797)))
    ("UINDGEN" fun nil (system) "Result = %s(D1 [, ..., D8])" ("U.html") ("tpoolkeyw2.html" ("TPOOL_MAX_ELTS" . 333417) ("TPOOL_MIN_ELTS" . 333286) ("TPOOL_NOTHREAD" . 333289)))
    ("UINT" fun nil (system) "Result = %s( Expression[, Offset [, D1 [, ..., D8]]] )" ("U2.html") ("tpoolkeyw2.html" ("TPOOL_MAX_ELTS" . 333417) ("TPOOL_MIN_ELTS" . 333286) ("TPOOL_NOTHREAD" . 333289)))
    ("UINTARR" fun nil (system) "Result = %s( D1 [, ..., D8])" ("U3.html" ("NOZERO" . 950261)))
    ("UL64INDGEN" fun nil (system) "Result = %s(D1 [, ..., D8])" ("U4.html") ("tpoolkeyw2.html" ("TPOOL_MAX_ELTS" . 333417) ("TPOOL_MIN_ELTS" . 333286) ("TPOOL_NOTHREAD" . 333289)))
    ("ULINDGEN" fun nil (system) "Result = %s(D1 [, ..., D8])" ("U5.html") ("tpoolkeyw2.html" ("TPOOL_MAX_ELTS" . 333417) ("TPOOL_MIN_ELTS" . 333286) ("TPOOL_NOTHREAD" . 333289)))
    ("ULON64ARR" fun nil (system) "Result = %s( D1 [, ..., D8])" ("U6.html" ("NOZERO" . 950420)))
    ("ULONARR" fun nil (system) "Result = %s( D1 [, ..., D8])" ("U7.html" ("NOZERO" . 950477)))
    ("ULONG" fun nil (system) "Result = %s( Expression[, Offset [, D1 [, ..., D8]]] )" ("U8.html") ("tpoolkeyw2.html" ("TPOOL_MAX_ELTS" . 333417) ("TPOOL_MIN_ELTS" . 333286) ("TPOOL_NOTHREAD" . 333289)))
    ("ULONG64" fun nil (system) "Result = %s( Expression[, Offset [, D1 [, ..., D8]]] )" ("U9.html") ("tpoolkeyw2.html" ("TPOOL_MAX_ELTS" . 333417) ("TPOOL_MIN_ELTS" . 333286) ("TPOOL_NOTHREAD" . 333289)))
    ("UNIQ" fun nil (system) "Result = %s( Array [, Index] )" ("U10.html"))
    ("VALUE_LOCATE" fun nil (system) "Result = %s ( Vector, Value)" ("V.html" ("L64" . 957054)))
    ("VARIANCE" fun nil (system) "Result = %s( X)" ("V2.html" ("DOUBLE" . 938748) ("NAN" . 938858)))
    ("VERT_T3D" fun nil (system) "Result = %s( Vertex_List)" ("V6.html" ("DOUBLE" . 787625) ("MATRIX" . 957551) ("NO_COPY" . 787628) ("NO_DIVIDE" . 787631) ("SAVE_DIVIDE" . 787634)))
    ("VOIGT" fun nil (system) "Result = %s(A, U)" ("V7.html") ("tpoolkeyw2.html" ("TPOOL_MAX_ELTS" . 333417) ("TPOOL_MIN_ELTS" . 333286) ("TPOOL_NOTHREAD" . 333289)))
    ("VOXEL_PROJ" fun nil (system) "Result = %s( V [, RGBO])" ("V9.html" ("BACKGROUND" . 677308) ("CUTTING_PLANE" . 680823) ("INTERPOLATE" . 680824) ("MAXIMUM_INTENSITY" . 680825) ("STEP" . 680826) ("XSIZE" . 680827) ("YSIZE" . 680828) ("ZBUFFER" . 680829) ("ZPIXELS" . 680830)))
    ("WARP_TRI" fun nil (system) "Result = %s( Xo, Yo, Xi, Yi, Image)" ("W2.html" ("EXTRAPOLATE" . 758734) ("OUTPUT_SIZE" . 758728) ("QUINTIC" . 758731) ("TPS" . 967342)))
    ("WATERSHED" fun nil (system) "Result = %s ( Image)" ("W3.html" ("CONNECTIVITY" . 961172)))
    ("WHERE" fun nil (system) "Result = %s( Array_Expression [, Count])" ("W6.html" ("COMPLEMENT" . 964874) ("L64" . 964006) ("NCOMPLEMENT" . 964887)) ("tpoolkeyw2.html" ("TPOOL_MAX_ELTS" . 333417) ("TPOOL_MIN_ELTS" . 333286) ("TPOOL_NOTHREAD" . 333289)))
    ("WIDGET_ACTIVEX" fun nil (system) "Result = %s( Parent, COM_ID)" ("W8.html" ("ALIGN_BOTTOM" . 970441) ("ALIGN_CENTER" . 970444) ("ALIGN_LEFT" . 970446) ("ALIGN_RIGHT" . 970448) ("ALIGN_TOP" . 970450) ("EVENT_FUNC" . 970453) ("EVENT_PRO" . 970455) ("FUNC_GET_VALUE" . 970458) ("ID_TYPE" . 970461) ("KILL_NOTIFY" . 970465) ("NO_COPY" . 970471) ("NOTIFY_REALIZE" . 970475) ("PRO_SET_VALUE" . 970479) ("SCR_XSIZE" . 970483) ("SCR_YSIZE" . 970486) ("SENSITIVE" . 970488) ("UNAME" . 1003671) ("UNITS" . 970503) ("UVALUE" . 970505) ("XOFFSET" . 970510) ("XSIZE" . 970513) ("YOFFSET" . 970515) ("YSIZE" . 970518)))
    ("WIDGET_BASE" fun nil (system) "Result = %s( [Parent])" ("W9.html" ("ALIGN_BOTTOM" . 679920) ("ALIGN_CENTER" . 107036) ("ALIGN_LEFT" . 107030) ("ALIGN_RIGHT" . 107035) ("ALIGN_TOP" . 107037) ("BASE_ALIGN_BOTTOM" . 107046) ("BASE_ALIGN_CENTER" . 107047) ("BASE_ALIGN_LEFT" . 107048) ("BASE_ALIGN_RIGHT" . 107049) ("BASE_ALIGN_TOP" . 107050) ("COLUMN" . 107029) ("CONTEXT_EVENTS" . 917417) ("CONTEXT_MENU" . 970908) ("DISPLAY_NAME" . 970988) ("EVENT_FUNC" . 679923) ("EVENT_PRO" . 679925) ("EXCLUSIVE" . 679927) ("FLOATING" . 911154) ("FRAME" . 679931) ("FUNC_GET_VALUE" . 679933) ("GRID_LAYOUT" . 679935) ("GROUP_LEADER" . 895915) ("KBRD_FOCUS_EVENTS" . 912183) ("KILL_NOTIFY" . 679938) ("MAP" . 108526) ("MBAR" . 934563) ("MODAL" . 910174) ("NO_COPY" . 106818) ("NONEXCLUSIVE" . 679946) ("NOTIFY_REALIZE" . 67508) ("PRO_SET_VALUE" . 679949) ("RESOURCE_NAME" . 281150) ("RNAME_MBAR" . 72437) ("ROW" . 679951) ("SCR_XSIZE" . 948019) ("SCR_YSIZE" . 58070) ("SCROLL" . 679954) ("SENSITIVE" . 948204) ("SPACE" . 679957) ("TITLE" . 679959) ("TLB_FRAME_ATTR" . 977197) ("TLB_ICONIFY_EVENTS" . 984484) ("TLB_KILL_REQUEST_EVENTS" . 192742) ("TLB_MOVE_EVENTS" . 984511) ("TLB_SIZE_EVENTS" . 679965) ("TOOLBAR" . 978753) ("TRACKING_EVENTS" . 58059) ("UNAME" . 949220) ("UNITS" . 895507) ("UVALUE" . 679967) ("X_SCROLL_SIZE" . 679980) ("XOFFSET" . 679972) ("XPAD" . 679975) ("XSIZE" . 679977) ("Y_SCROLL_SIZE" . 679991) ("YOFFSET" . 679983) ("YPAD" . 679986) ("YSIZE" . 679988)))
    ("WIDGET_BUTTON" fun nil (system) "Result = %s( Parent)" ("W10.html" ("ALIGN_CENTER" . 680015) ("ALIGN_LEFT" . 57956) ("ALIGN_RIGHT" . 57957) ("BITMAP" . 192775) ("CHECKED_MENU" . 978512) ("DYNAMIC_RESIZE" . 978508) ("EVENT_FUNC" . 106419) ("EVENT_PRO" . 680017) ("FONT" . 680019) ("FRAME" . 680021) ("FUNC_GET_VALUE" . 108837) ("GROUP_LEADER" . 680025) ("HELP" . 57994) ("KILL_NOTIFY" . 680028) ("MENU" . 680031) ("NO_COPY" . 109087) ("NO_RELEASE" . 680036) ("NOTIFY_REALIZE" . 67569) ("PRO_SET_VALUE" . 680038) ("RESOURCE_NAME" . 724023) ("SCR_XSIZE" . 67277) ("SCR_YSIZE" . 67280) ("SENSITIVE" . 948118) ("SEPARATOR" . 58000) ("TOOLTIP" . 982062) ("TRACKING_EVENTS" . 982064) ("UNAME" . 949273) ("UNITS" . 895525) ("UVALUE" . 680040) ("VALUE" . 680044) ("X_BITMAP_EXTRA" . 680046) ("XOFFSET" . 680048) ("XSIZE" . 680051) ("YOFFSET" . 680054) ("YSIZE" . 680057)))
    ("WIDGET_COMBOBOX" fun nil (system) "Result = %s( Parent)" ("W11.html" ("DYNAMIC_RESIZE" . 1011945) ("EDITABLE" . 1011949) ("EVENT_FUNC" . 1011951) ("EVENT_PRO" . 1011953) ("FONT" . 1011955) ("FRAME" . 1011964) ("FUNC_GET_VALUE" . 1011967) ("GROUP_LEADER" . 1011969) ("KILL_NOTIFY" . 1011972) ("NO_COPY" . 1011975) ("NOTIFY_REALIZE" . 1011978) ("PRO_SET_VALUE" . 1011980) ("RESOURCE_NAME" . 1011983) ("SCR_XSIZE" . 1011991) ("SCR_YSIZE" . 1011993) ("SENSITIVE" . 1011995) ("TRACKING_EVENTS" . 1012005) ("UNAME" . 1012013) ("UNITS" . 1012019) ("UVALUE" . 1012021) ("VALUE" . 1012025) ("XOFFSET" . 1012027) ("XSIZE" . 1012030) ("YOFFSET" . 1012032) ("YSIZE" . 1012035)))
    ("WIDGET_DRAW" fun nil (system) "Result = %s(Parent)" ("W14.html" ("APP_SCROLL" . 680227) ("BUTTON_EVENTS" . 941808) ("COLOR_MODEL" . 930114) ("COLORS" . 896380) ("EVENT_FUNC" . 680234) ("EVENT_PRO" . 680236) ("EXPOSE_EVENTS" . 907355) ("FRAME" . 680238) ("FUNC_GET_VALUE" . 680240) ("GRAPHICS_LEVEL" . 914743) ("GROUP_LEADER" . 680242) ("KEYBOARD_EVENTS" . 985071) ("KILL_NOTIFY" . 680245) ("MOTION_EVENTS" . 153791) ("NO_COPY" . 680251) ("NOTIFY_REALIZE" . 67601) ("PRO_SET_VALUE" . 680253) ("RENDERER" . 930656) ("RESOURCE_NAME" . 947866) ("RETAIN" . 680255) ("SCR_XSIZE" . 67289) ("SCR_YSIZE" . 67292) ("SCROLL" . 67286) ("SENSITIVE" . 948221) ("TOOLTIP" . 982084) ("TRACKING_EVENTS" . 67368) ("UNAME" . 949316) ("UNITS" . 895543) ("UVALUE" . 680259) ("VALUE" . 680263) ("VIEWPORT_EVENTS" . 279483) ("X_SCROLL_SIZE" . 680274) ("XOFFSET" . 680268) ("XSIZE" . 680271) ("Y_SCROLL_SIZE" . 680283) ("YOFFSET" . 680277) ("YSIZE" . 680280)))
    ("WIDGET_DROPLIST" fun nil (system) "Result = %s( Parent)" ("W15.html" ("DYNAMIC_RESIZE" . 192790) ("EVENT_FUNC" . 192787) ("EVENT_PRO" . 58393) ("FONT" . 963245) ("FRAME" . 58399) ("FUNC_GET_VALUE" . 58404) ("GROUP_LEADER" . 58412) ("KILL_NOTIFY" . 58424) ("NO_COPY" . 67153) ("NOTIFY_REALIZE" . 67614) ("PRO_SET_VALUE" . 67133) ("RESOURCE_NAME" . 67140) ("SCR_XSIZE" . 67120) ("SCR_YSIZE" . 67123) ("SENSITIVE" . 948234) ("TITLE" . 888903) ("TRACKING_EVENTS" . 58334) ("UNAME" . 949326) ("UNITS" . 895561) ("UVALUE" . 67166) ("VALUE" . 67174) ("XOFFSET" . 67194) ("XSIZE" . 67198) ("YOFFSET" . 67201) ("YSIZE" . 67205)))
    ("WIDGET_EVENT" fun nil (system) "Result = %s([Widget_ID])" ("W16.html" ("BAD_ID" . 680307) ("NOWAIT" . 680311) ("SAVE_HOURGLASS" . 680313) ("YIELD_TO_TTY" . 675439)))
    ("WIDGET_INFO" fun nil (system) "Result = %s( [Widget_ID] )" ("W17.html" ("ACTIVE" . 680342) ("BUTTON_SET" . 978692) ("CHILD" . 978690) ("COLUMN_WIDTHS" . 895941) ("COMBOBOX_GETTEXT" . 981639) ("COMBOBOX_NUMBER" . 981602) ("CONTEXT_EVENTS" . 680346) ("DRAW_BUTTON_EVENTS" . 971032) ("DRAW_EXPOSE_EVENTS" . 909787) ("DRAW_KEYBOARD_EVENTS" . 985204) ("DRAW_MOTION_EVENTS" . 985200) ("DRAW_VIEWPORT_EVENTS" . 680350) ("DROPLIST_NUMBER" . 58164) ("DROPLIST_SELECT" . 58165) ("DYNAMIC_RESIZE" . 192872) ("EVENT_FUNC" . 680352) ("EVENT_PRO" . 680354) ("FIND_BY_UNAME" . 58144) ("FONTNAME" . 980336) ("GEOMETRY" . 980339) ("KBRD_FOCUS_EVENTS" . 1012790) ("LIST_MULTIPLE" . 934733) ("LIST_NUM_VISIBLE" . 680358) ("LIST_NUMBER" . 911616) ("LIST_SELECT" . 680360) ("LIST_TOP" . 680362) ("MANAGED" . 907337) ("MAP" . 982652) ("MODAL" . 910752) ("NAME" . 58076) ("PARENT" . 680364) ("REALIZED" . 680366) ("ROW_HEIGHTS" . 895972) ("SENSITIVE" . 982686) ("SIBLING" . 680368) ("SLIDER_MIN_MAX" . 680889) ("SYSTEM_COLORS" . 895977) ("TAB_CURRENT" . 976997) ("TAB_MULTILINE" . 977009) ("TAB_NUMBER" . 977045) ("TABLE_ALL_EVENTS" . 971069) ("TABLE_DISJOINT_SELECTION" . 987431) ("TABLE_EDIT_CELL" . 895981) ("TABLE_EDITABLE" . 895979) ("TABLE_SELECT" . 895983) ("TABLE_VIEW" . 895985) ("TEXT_ALL_EVENTS" . 680895) ("TEXT_EDITABLE" . 680899) ("TEXT_NUMBER" . 680370) ("TEXT_OFFSET_TO_XY" . 680903) ("TEXT_SELECT" . 680906) ("TEXT_TOP_LINE" . 680913) ("TEXT_XY_TO_OFFSET" . 899965) ("TLB_ICONIFY_EVENTS" . 984875) ("TLB_KILL_REQUEST_EVENTS" . 192881) ("TLB_MOVE_EVENTS" . 984854) ("TLB_SIZE_EVENTS" . 984889) ("TOOLTIP" . 982130) ("TRACKING_EVENTS" . 58086) ("TREE_EXPANDED" . 978324) ("TREE_ROOT" . 986723) ("TREE_SELECT" . 978331) ("TYPE" . 680072) ("UNAME" . 949465) ("UNITS" . 949467) ("UPDATE" . 680371) ("USE_TABLE_SELECT" . 896009) ("VALID_ID" . 891030) ("VERSION" . 680373) ("VISIBLE" . 984410)))
    ("WIDGET_LABEL" fun nil (system) "Result = %s( Parent)" ("W18.html" ("ALIGN_CENTER" . 57967) ("ALIGN_LEFT" . 57970) ("ALIGN_RIGHT" . 57973) ("DYNAMIC_RESIZE" . 192801) ("FONT" . 680390) ("FRAME" . 680392) ("FUNC_GET_VALUE" . 680394) ("GROUP_LEADER" . 680396) ("KILL_NOTIFY" . 680399) ("NO_COPY" . 680402) ("NOTIFY_REALIZE" . 67628) ("PRO_SET_VALUE" . 680404) ("RESOURCE_NAME" . 724047) ("SCR_XSIZE" . 67301) ("SCR_YSIZE" . 67304) ("SENSITIVE" . 948248) ("SUNKEN_FRAME" . 978731) ("TRACKING_EVENTS" . 67390) ("UNAME" . 949494) ("UNITS" . 949487) ("UVALUE" . 680406) ("VALUE" . 680410) ("XOFFSET" . 680412) ("XSIZE" . 680415) ("YOFFSET" . 680418) ("YSIZE" . 680421)))
    ("WIDGET_LIST" fun nil (system) "Result = %s( Parent)" ("W19.html" ("CONTEXT_EVENTS" . 970955) ("EVENT_FUNC" . 680433) ("EVENT_PRO" . 680435) ("FONT" . 680437) ("FRAME" . 680439) ("FUNC_GET_VALUE" . 680441) ("GROUP_LEADER" . 680443) ("KILL_NOTIFY" . 680446) ("MULTIPLE" . 934705) ("NO_COPY" . 680449) ("NOTIFY_REALIZE" . 67642) ("PRO_SET_VALUE" . 680451) ("RESOURCE_NAME" . 724057) ("SCR_XSIZE" . 67319) ("SCR_YSIZE" . 1001133) ("SENSITIVE" . 948262) ("TRACKING_EVENTS" . 67404) ("UNAME" . 949504) ("UNITS" . 895619) ("UVALUE" . 680453) ("VALUE" . 680457) ("XOFFSET" . 680460) ("XSIZE" . 680463) ("YOFFSET" . 680466) ("YSIZE" . 58021)))
    ("WIDGET_SLIDER" fun nil (system) "Result = %s( Parent)" ("W20.html" ("DRAG" . 680487) ("EVENT_FUNC" . 680490) ("EVENT_PRO" . 680492) ("FONT" . 680494) ("FRAME" . 680496) ("FUNC_GET_VALUE" . 680498) ("GROUP_LEADER" . 680500) ("KILL_NOTIFY" . 680503) ("MAXIMUM" . 680506) ("MINIMUM" . 680508) ("NO_COPY" . 680510) ("NOTIFY_REALIZE" . 67656) ("PRO_SET_VALUE" . 680512) ("RESOURCE_NAME" . 724067) ("SCR_XSIZE" . 67331) ("SCR_YSIZE" . 67334) ("SCROLL" . 680514) ("SENSITIVE" . 948276) ("SUPPRESS_VALUE" . 680516) ("TITLE" . 910787) ("TRACKING_EVENTS" . 67418) ("UNAME" . 949514) ("UNITS" . 895638) ("UVALUE" . 680519) ("VALUE" . 680523) ("VERTICAL" . 680527) ("XOFFSET" . 680529) ("XSIZE" . 680532) ("YOFFSET" . 680535) ("YSIZE" . 680538)))
    ("WIDGET_TAB" fun nil (system) "Result = %s( Parent)" ("W21.html" ("ALIGN_BOTTOM" . 1012200) ("ALIGN_CENTER" . 1012202) ("ALIGN_LEFT" . 1012204) ("ALIGN_RIGHT" . 1012206) ("ALIGN_TOP" . 1012208) ("EVENT_FUNC" . 1012210) ("EVENT_PRO" . 1012212) ("FUNC_GET_VALUE" . 1012214) ("GROUP_LEADER" . 1012216) ("KILL_NOTIFY" . 1012219) ("LOCATION" . 1012223) ("MULTILINE" . 1012253) ("NO_COPY" . 1012263) ("NOTIFY_REALIZE" . 1012266) ("PRO_SET_VALUE" . 1012268) ("SCR_XSIZE" . 1012270) ("SCR_YSIZE" . 1012272) ("SENSITIVE" . 1012274) ("UNAME" . 1012284) ("UNITS" . 1012290) ("UVALUE" . 1012292) ("XOFFSET" . 1012296) ("XSIZE" . 1012299) ("YOFFSET" . 1012301) ("YSIZE" . 1012304)))
    ("WIDGET_TABLE" fun nil (system) "Result = %s( Parent)" ("W22.html" ("ALIGNMENT" . 896042) ("ALL_EVENTS" . 941688) ("AM_PM" . 949832) ("COLUMN_LABELS" . 911360) ("COLUMN_MAJOR" . 909845) ("COLUMN_WIDTHS" . 896114) ("DAYS_OF_WEEK" . 949838) ("DISJOINT_SELECTION" . 987345) ("EDITABLE" . 987346) ("EVENT_FUNC" . 896120) ("EVENT_PRO" . 896123) ("FONT" . 896126) ("FORMAT" . 896130) ("FRAME" . 896133) ("FUNC_GET_VALUE" . 896136) ("GROUP_LEADER" . 896151) ("KBRD_FOCUS_EVENTS" . 911525) ("KILL_NOTIFY" . 896155) ("MONTHS" . 949844) ("NO_COPY" . 896163) ("NO_HEADERS" . 909873) ("NOTIFY_REALIZE" . 896166) ("PRO_SET_VALUE" . 896169) ("RESIZEABLE_COLUMNS" . 896172) ("RESIZEABLE_ROWS" . 901244) ("RESOURCE_NAME" . 896175) ("ROW_HEIGHTS" . 909879) ("ROW_LABELS" . 896181) ("ROW_MAJOR" . 909886) ("SCR_XSIZE" . 896187) ("SCR_YSIZE" . 896190) ("SCROLL" . 896193) ("SENSITIVE" . 948291) ("TRACKING_EVENTS" . 896200) ("UNAME" . 949524) ("UNITS" . 896203) ("UVALUE" . 896207) ("VALUE" . 896212) ("X_SCROLL_SIZE" . 896223) ("XOFFSET" . 896215) ("XSIZE" . 896219) ("Y_SCROLL_SIZE" . 896235) ("YOFFSET" . 896227) ("YSIZE" . 896231)))
    ("WIDGET_TEXT" fun nil (system) "Result = %s( Parent)" ("W23.html" ("ALL_EVENTS" . 680556) ("CONTEXT_EVENTS" . 970972) ("EDITABLE" . 886884) ("EVENT_FUNC" . 680561) ("EVENT_PRO" . 680563) ("FONT" . 680565) ("FRAME" . 680567) ("FUNC_GET_VALUE" . 680569) ("GROUP_LEADER" . 680571) ("KBRD_FOCUS_EVENTS" . 911545) ("KILL_NOTIFY" . 680574) ("NO_COPY" . 680577) ("NO_NEWLINE" . 680579) ("NOTIFY_REALIZE" . 67670) ("PRO_SET_VALUE" . 680581) ("RESOURCE_NAME" . 724077) ("SCR_XSIZE" . 67343) ("SCR_YSIZE" . 67346) ("SCROLL" . 680583) ("SENSITIVE" . 948305) ("TRACKING_EVENTS" . 67432) ("UNAME" . 949534) ("UNITS" . 895656) ("UVALUE" . 680586) ("VALUE" . 680590) ("WRAP" . 58056) ("XOFFSET" . 680592) ("XSIZE" . 680595) ("YOFFSET" . 680598) ("YSIZE" . 680601)))
    ("WIDGET_TREE" fun nil (system) "Result = %s( Parent)" ("W24.html" ("ALIGN_BOTTOM" . 1012440) ("ALIGN_CENTER" . 1012442) ("ALIGN_LEFT" . 1012444) ("ALIGN_RIGHT" . 1012446) ("ALIGN_TOP" . 1012448) ("BITMAP" . 1012450) ("CONTEXT_EVENTS" . 1012452) ("EVENT_FUNC" . 1012461) ("EVENT_PRO" . 1012463) ("EXPANDED" . 1012465) ("FOLDER" . 1012468) ("FUNC_GET_VALUE" . 1012472) ("GROUP_LEADER" . 1012474) ("KILL_NOTIFY" . 1012477) ("MULTIPLE" . 1012481) ("NO_COPY" . 1012484) ("NOTIFY_REALIZE" . 1012487) ("PRO_SET_VALUE" . 1012489) ("SCR_XSIZE" . 1012491) ("SCR_YSIZE" . 1012493) ("SENSITIVE" . 1012495) ("TOP" . 1012505) ("UNAME" . 1012508) ("UNITS" . 1012514) ("UVALUE" . 1012516) ("VALUE" . 1012520) ("XOFFSET" . 1012523) ("XSIZE" . 1012526) ("YOFFSET" . 1012528) ("YSIZE" . 1012531)))
    ("WRITE_SYLK" fun nil (system) "Result = %s( File, Data)" ("W35.html" ("STARTCOL" . 67955) ("STARTROW" . 67958)))
    ("WTN" fun nil (system) "Result = %s( A, Coef)" ("W42.html" ("COLUMN" . 58787) ("DOUBLE" . 52415) ("INVERSE" . 52418) ("OVERWRITE" . 52421)))
    ("WV_CW_WAVELET" fun nil (system) "Result = %s( [Parent])" ("ref2.html" ("DISCRETE" . 1003928) ("NO_COLOR" . 1015397) ("NO_DRAW_WINDOW" . 1015435) ("TITLE" . 1015385) ("UNAME" . 1004532) ("UVALUE" . 1003932) ("VALUE" . 1015413) ("WAVELETS" . 1008397)))
    ("WV_CWT" fun nil (system) "Result = %s(Array, Family, Order)" ("ref3.html" ("DOUBLE" . 1009356) ("DSCALE" . 1009358) ("NSCALE" . 1009484) ("PAD" . 1009489) ("SCALE" . 1009494) ("START_SCALE" . 1009568)))
    ("WV_DENOISE" fun nil (system) "Result = %s(Array [, Family, Order])" ("ref4.html" ("COEFFICIENTS" . 1010533) ("CUTOFF" . 1010481) ("DENOISE_STATE" . 1010485) ("DOUBLE" . 1010505) ("DWT_FILTERED" . 1010508) ("PERCENT" . 1010511) ("THRESHOLD" . 1010517) ("WPS_FILTERED" . 1010522)))
    ("WV_DWT" fun nil (system) "Result = %s(Array, Scaling, Wavelet, Ioff, Joff)" ("ref5.html" ("DOUBLE" . 1003349) ("INVERSE" . 1003353)))
    ("WV_FN_COIFLET" fun nil (system) "Result = %s( [Order, Scaling, Wavelet, Ioff, Joff] )" ("ref6.html"))
    ("WV_FN_DAUBECHIES" fun nil (system) "Result = %s( [Order, Scaling, Wavelet, Ioff, Joff] )" ("ref7.html"))
    ("WV_FN_GAUSSIAN" fun nil (system) "Result = %s( [Order] [, Scale, N])" ("ref8.html" ("DOUBLE" . 1018338) ("FREQUENCY" . 1018340) ("SPATIAL" . 1018342) ("WAVELET" . 1018344)))
    ("WV_FN_HAAR" fun nil (system) "Result = %s( [Order, Scaling, Wavelet, Ioff, Joff] )" ("ref9.html"))
    ("WV_FN_MORLET" fun nil (system) "Result = %s( [Order] [, Scale, N])" ("ref10.html" ("DOUBLE" . 1009779) ("FREQUENCY" . 1015564) ("SPATIAL" . 1015558) ("WAVELET" . 1009789)))
    ("WV_FN_PAUL" fun nil (system) "Result = %s( [Order] [, Scale, N])" ("ref11.html" ("DOUBLE" . 1010078) ("FREQUENCY" . 1015576) ("SPATIAL" . 1010080) ("WAVELET" . 1010082)))
    ("WV_FN_SYMLET" fun nil (system) "Result = %s( [Order, Scaling, Wavelet, Ioff, Joff] )" ("ref12.html"))
    ("WV_PLOT3D_WPS" fun nil (system) "Result = %s( Array [, X] [, Y])" ("ref15.html" ("GROUP_LEADER" . 1006236) ("SURFACE_STYLE" . 1015696) ("TITLE" . 1006239) ("UNITS" . 1006241) ("XTITLE" . 1006243) ("XUNITS" . 1006245) ("YTITLE" . 1006247) ("YUNITS" . 1006249)))
    ("WV_PLOT_MULTIRES" fun nil (system) "Result = %s( Array [, X] [, Y])" ("ref16.html" ("GROUP_LEADER" . 1008291) ("TITLE" . 1008295) ("UNITS" . 1008298) ("XTITLE" . 1008301) ("XUNITS" . 1008304) ("YTITLE" . 1008307) ("YUNITS" . 1008310)))
    ("WV_PWT" fun nil (system) "Result = %s( A, Scaling, Wavelet, Ioff, Joff)" ("ref17.html" ("DOUBLE" . 1006192) ("INVERSE" . 1006194)))
    ("WV_TOOL_DENOISE" fun nil (system) "Result = %s( Array [, X] [, Y])" ("ref18.html" ("GROUP_LEADER" . 1008330) ("TITLE" . 1008334) ("UNITS" . 1008337) ("XTITLE" . 1008340) ("XUNITS" . 1008343) ("YTITLE" . 1008346) ("YUNITS" . 1008349)))
    ("XFONT" fun nil (system) "Result = %s()" ("X4.html" ("GROUP" . 762100) ("PRESERVE_FONT_INFO" . 762103)))
    ("XREGISTERED" fun nil (system) "Result = %s(Name)" ("X16.html" ("NOSHOW" . 762898)))
    ("XSQ_TEST" fun nil (system) "Result = %s( Obfreq, Exfreq)" ("X18.html" ("EXCELL" . 137437) ("OBCELL" . 137440) ("RESIDUAL" . 137443)))
    ("Add" pro "IDL_Container" (system) "Obj -> [%s::]%s, Objects" ("objects5.html" ("POSITION" . 1056058)))
    ("Cleanup" pro "IDL_Container" (system) "Obj-> [%s::]%s" ("objects6.html"))
    ("Move" pro "IDL_Container" (system) "Obj -> [%s::]%s, Source, Destination" ("objects11.html"))
    ("Remove" pro "IDL_Container" (system) "Obj -> [%s::]%s [, Child_object]" ("objects12.html" ("ALL" . 1056165) ("POSITION" . 1069134)))
    ("Count" fun "IDL_Container" (system) "Result = Obj -> [%s::]%s()" ("objects7.html"))
    ("Get" fun "IDL_Container" (system) "Result = Obj -> [%s::]%s ()" ("objects8.html" ("ALL" . 1069508) ("COUNT" . 1069532) ("ISA" . 1069548) ("POSITION" . 1069550)))
    ("Init" fun "IDL_Container" (system) "Result = Obj -> [%s::]%s()" ("objects9.html"))
    ("IsContained" fun "IDL_Container" (system) "Result = Obj -> [%s::]%s( Object)" ("objects10.html" ("POSITION" . 1346888)))
    ("AppendData" pro "IDLanROI" (system) "Obj -> [%s::]%s, X [, Y] [, Z]" ("objects14.html" ("XRANGE" . 1355063) ("YRANGE" . 1364460) ("ZRANGE" . 1355067)))
    ("Cleanup" pro "IDLanROI" (system) "Obj -> [%s::]%s" ("objects15.html"))
    ("GetProperty" pro "IDLanROI" (system) "Obj -> [%s::]%s" ("objects19.html" ("ALL" . 1355232) ("N_VERTS" . 1372799) ("ROI_XRANGE" . 1372797) ("ROI_YRANGE" . 1355237) ("ROI_ZRANGE" . 1355239)) ("objects20.html" ("BLOCKSIZE") ("DATA" . 1355264) ("DOUBLE" . 1364582) ("INTERIOR" . 1355266) ("TYPE" . 1355268)))
    ("RemoveData" pro "IDLanROI" (system) "Obj -> [%s::]%s" ("objects21.html" ("COUNT" . 1355294) ("START" . 1355296) ("XRANGE" . 1355298) ("YRANGE" . 1355300) ("ZRANGE" . 1355302)))
    ("ReplaceData" pro "IDLanROI" (system) "Obj -> [%s::]%s, X[, Y[, Z]]" ("objects22.html" ("FINISH" . 1355320) ("START" . 1355327) ("XRANGE" . 1364681) ("YRANGE" . 1364683) ("ZRANGE" . 1364685)))
    ("Rotate" pro "IDLanROI" (system) "Obj -> [%s::]%s, Axis, Angle" ("objects23.html" ("CENTER" . 1364705)))
    ("Scale" pro "IDLanROI" (system) "Obj -> [%s::]%s, Sx[, Sy[, Sz]]" ("objects24.html"))
    ("SetProperty" pro "IDLanROI" (system) "Obj -> [%s::]%s" ("objects25.html") ("objects20.html" ("BLOCKSIZE") ("DATA" . 1355264) ("DOUBLE" . 1364582) ("INTERIOR" . 1355266)))
    ("Translate" pro "IDLanROI" (system) "Obj -> [%s::]%s, Tx[, Ty[, Tz]]" ("objects26.html"))
    ("ComputeGeometry" fun "IDLanROI" (system) "Result = Obj -> [%s::]%s()" ("objects16.html" ("AREA" . 1355099) ("CENTROID" . 1355101) ("PERIMETER" . 1355103) ("SPATIAL_OFFSET" . 1355105) ("SPATIAL_SCALE" . 1355107)))
    ("ComputeMask" fun "IDLanROI" (system) "Result = Obj -> [%s::]%s()" ("objects17.html" ("DIMENSIONS" . 1355128) ("INITIALIZE" . 1355130) ("LOCATION" . 1355145) ("MASK_IN" . 1355147) ("MASK_RULE" . 1355149) ("PLANE_NORMAL" . 1355168) ("PLANE_XAXIS" . 1355170) ("RUN_LENGTH" . 1435215)))
    ("ContainsPoints" fun "IDLanROI" (system) "Result = Obj -> [%s::]%s( X [, Y [, Z]] )" ("objects18.html"))
    ("Init" fun "IDLanROI" (system) "Result = Obj -> [%s::]%s([, X [, Y [, Z]]])" ("objects20.html" ("BLOCK_SIZE" . 1355262) ("BLOCKSIZE") ("DATA" . 1355264) ("DOUBLE" . 1364582) ("INTERIOR" . 1355266) ("TYPE" . 1355268)))
    ("Add" pro "IDLanROIGroup" (system) "Obj -> [%s::]%s, ROI" ("objects28.html"))
    ("Cleanup" pro "IDLanROIGroup" (system) "Obj -> [%s::]%s" ("objects29.html"))
    ("GetProperty" pro "IDLanROIGroup" (system) "Obj -> [%s::]%s" ("objects33.html" ("ALL" . 1398204) ("ROIGROUP_XRANGE" . 1364796) ("ROIGROUP_YRANGE" . 1364798) ("ROIGROUP_ZRANGE" . 1364800)))
    ("Rotate" pro "IDLanROIGroup" (system) "Obj -> [%s::]%s, Axis, Angle" ("objects35.html" ("CENTER" . 1355859)))
    ("Scale" pro "IDLanROIGroup" (system) "Obj -> [%s::]%s, Sx[, Sy[, Sz]]" ("objects36.html"))
    ("Translate" pro "IDLanROIGroup" (system) "Obj -> [%s::]%s, Tx[, Ty[, Tz]]" ("objects37.html"))
    ("ComputeMask" fun "IDLanROIGroup" (system) "Result = Obj -> [%s::]%s()" ("objects30.html" ("DIMENSIONS" . 1355712) ("INITIALIZE" . 1355714) ("LOCATION" . 1355729) ("MASK_IN" . 1355731) ("MASK_RULE" . 1355733) ("PLANE_NORMAL" . 1355752) ("PLANE_XAXIS" . 1355754) ("RUN_LENGTH" . 1435239)))
    ("ComputeMesh" fun "IDLanROIGroup" (system) "Result = Obj->[%s::]%s( Vertices, Conn)" ("objects31.html" ("CAPPED" . 1355778) ("SURFACE_AREA" . 1355797)))
    ("ContainsPoints" fun "IDLanROIGroup" (system) "Result = Obj -> [%s::]%s( X[, Y[, Z]] )" ("objects32.html"))
    ("Init" fun "IDLanROIGroup" (system) "Result = Obj -> [%s::]%s()" ("objects34.html"))
    ("GetProperty" pro "IDLcomIDispatch" (system) "Obj -> [%s::]%s" ("objects41.html" ("KEYWORD")))
    ("SetProperty" pro "IDLcomIDispatch" (system) "Obj -> [%s::]%s" ("objects42.html" ("KEYWORD")))
    ("Init" fun "IDLcomIDispatchCLSID" (system) "Result = Obj -> [%s::]%s()" ("objects40.html"))
    ("Init" fun "IDLcomIDispatchPROGID" (system) "Result = Obj -> [%s::]%s()" ("objects40.html"))
    ("Connect" pro "IDLdbDatabase" (system) "DBobj -> [%s::]%s" ("api4.html" ("CONNECTION" . 998610) ("DATASOURCE" . 998682) ("PASSWORD" . 998786) ("USER_ID" . 998733)))
    ("ExecuteSQL" pro "IDLdbDatabase" (system) "DBobj -> [%s::]%s, strSQL" ("api5.html"))
    ("GetProperty" pro "IDLdbDatabase" (system) "DBobj -> [%s::]%s" ("api7.html" ("CAN_GET_TABLES" . 999916) ("DBMS_NAME" . 1012793) ("DBMS_VERSION" . 1012798) ("DRIVER_ODBC_LEVEL" . 999967) ("DRIVER_VERSION" . 1000012) ("IS_CONNECTED" . 1012788) ("IS_READONLY" . 1021830) ("MAX_CONNECTIONS" . 1000057) ("MAX_RECORDSETS" . 1000102) ("ODBC_LEVEL" . 1000147) ("SQL_LEVEL" . 1000196) ("SQL_SERVER_NAME" . 1000241) ("USE_CURSOR_LIB" . 1012806) ("USER_NAME" . 1000292)))
    ("SetProperty" pro "IDLdbDatabase" (system) "DBobj -> [%s::]%s" ("api9.html" ("USE_CURSOR_LIB" . 1012815) ("VERBOSE" . 1012836)))
    ("GetDatasources" fun "IDLdbDatabase" (system) "Datasources = DBobj -> [%s::]%s()" ("api6.html"))
    ("GetTables" fun "IDLdbDatabase" (system) "Tables = DBobj -> [%s::]%s()" ("api8.html"))
    ("AddRecord" pro "IDLdbRecordset" (system) "RSobj -> [%s::]%s[, field1[, field2[, ...[, fieldn]]]]" ("api11.html" ("SET_AUTOINCREMENT" . 1014791)))
    ("DeleteRecord" pro "IDLdbRecordset" (system) "RSobj -> [%s::]%s" ("api13.html"))
    ("GetProperty" pro "IDLdbRecordset" (system) "RSobj -> [%s::]%s" ("api15.html" ("CAN_MOVE_ABSOLUTE" . 1012650) ("CAN_MOVE_FIRST" . 1012652) ("CAN_MOVE_LAST" . 1012654) ("CAN_MOVE_NEXT" . 1012656) ("CAN_MOVE_PRIOR" . 1012658) ("CAN_MOVE_RELATIVE" . 1012660) ("FIELD_INFO" . 1007795) ("GET_DATABASE" . 1012848) ("IS_READONLY" . 1013248) ("N_BUFFERS" . 1014134) ("RECORDSET_SOURCE" . 1007809)))
    ("SetField" pro "IDLdbRecordset" (system) "RSobj -> [%s::]%s, iFieldNumber, Value" ("api19.html" ("NULL" . 1014812)))
    ("CurrentRecord" fun "IDLdbRecordset" (system) "number = RSobj -> [%s::]%s()" ("api12.html"))
    ("GetField" fun "IDLdbRecordset" (system) "value = RSobj -> [%s::]%s(iFieldNumber)" ("api14.html" ("IS_NULL" . 1013507) ("NULL_VALUE" . 1013559)))
    ("GetRecord" fun "IDLdbRecordset" (system) "Result = RSobj -> [%s::]%s()" ("api16.html"))
    ("MoveCursor" fun "IDLdbRecordset" (system) "Result = RSobj -> [%s::]%s()" ("api17.html" ("ABSOLUTE" . 1001009) ("FIRST" . 1001067) ("LAST" . 1001125) ("NEXT" . 1001187) ("PRIOR" . 1001255) ("RELATIVE" . 1001313)))
    ("NFields" fun "IDLdbRecordset" (system) "status = RSobj -> [%s::]%s()" ("api18.html"))
    ("Cleanup" pro "IDLffDICOM" (system) "Obj -> [%s::]%s" ("objects45.html"))
    ("DumpElements" pro "IDLffDICOM" (system) "Obj -> [%s::]%s [, Filename]" ("objects46.html"))
    ("Reset" pro "IDLffDICOM" (system) "Obj -> [%s::]%s" ("objects59.html"))
    ("GetChildren" fun "IDLffDICOM" (system) "array = Obj -> [%s::]%s( Reference )" ("objects47.html"))
    ("GetDescription" fun "IDLffDICOM" (system) "array = Obj -> [%s::]%s( [Group [, Element]])" ("objects48.html" ("REFERENCE" . 1334749)))
    ("GetGroup" fun "IDLffDICOM" (system) "array = Obj -> [%s::]%s( [Group[, Element]])" ("objects50.html" ("REFERENCE" . 1334812)))
    ("GetLength" fun "IDLffDICOM" (system) "array = Obj -> [%s::]%s( [Group [, Element]])" ("objects51.html" ("REFERENCE" . 1334845)))
    ("GetParent" fun "IDLffDICOM" (system) "array = Obj ->[%s::]%s( ReferenceList )" ("objects52.html"))
    ("GetPreamble" fun "IDLffDICOM" (system) "array = Obj -> [%s::]%s( )" ("objects53.html"))
    ("GetReference" fun "IDLffDICOM" (system) "array = Obj -> [%s::]%s( [Group [, Element]])" ("objects54.html" ("DESCRIPTION" . 1334927) ("VR" . 1334929)))
    ("GetValue" fun "IDLffDICOM" (system) "ptrArray = Obj -> [%s::]%s( [Group [, Element]])" ("objects55.html" ("NO_COPY" . 1334970) ("REFERENCE" . 1334968)))
    ("GetVR" fun "IDLffDICOM" (system) "array = Obj -> [%s::]%s( [Group [, Element]])" ("objects56.html" ("REFERENCE" . 1335058)))
    ("Init" fun "IDLffDICOM" (system) "Result = Obj -> [%s::]%s([, Filename])" ("objects57.html" ("VERBOSE" . 1335083)))
    ("Read" fun "IDLffDICOM" (system) "Result = Obj -> [%s::]%s( Filename)" ("objects58.html" ("ENDIAN" . 1335107)))
    ("Cleanup" pro "IDLffDXF" (system) "Obj -> [%s::]%s" ("objects61.html"))
    ("GetPalette" pro "IDLffDXF" (system) "Obj-> [%s::]%s, Red, Green, Blue" ("objects64.html"))
    ("PutEntity" pro "IDLffDXF" (system) "Obj -> [%s::]%s, Data" ("objects66.html"))
    ("RemoveEntity" pro "IDLffDXF" (system) "Obj -> [%s::]%s[, Type]" ("objects68.html" ("INDEX" . 1236688)))
    ("Reset" pro "IDLffDXF" (system) "Obj-> [%s::]%s" ("objects69.html"))
    ("SetPalette" pro "IDLffDXF" (system) "Obj-> [%s::]%s, Red, Green, Blue" ("objects70.html"))
    ("GetContents" fun "IDLffDXF" (system) "Result = Obj-> [%s::]%s( [Filter])" ("objects62.html" ("BLOCK" . 1236439) ("COUNT" . 1236442) ("LAYER" . 1236445)))
    ("GetEntity" fun "IDLffDXF" (system) "Result = Obj-> [%s::]%s( Type)" ("objects63.html" ("BLOCK" . 1336301) ("INDEX" . 1336304) ("LAYER" . 1336307)))
    ("Init" fun "IDLffDXF" (system) "Result = Obj -> [%s::]%s([, Filename] )" ("objects65.html"))
    ("Read" fun "IDLffDXF" (system) "Result = Obj-> [%s::]%s( Filename )" ("objects67.html"))
    ("Write" fun "IDLffDXF" (system) "Result = Obj-> [%s::]%s( Filename )" ("objects71.html"))
    ("IsValid" fun "IDLffLanguageCat" (system) "Result = Obj ->[%s::]%s( )" ("objects73.html"))
    ("Query" fun "IDLffLanguageCat" (system) "Result = Obj ->[%s::]%s( key)" ("objects74.html" ("DEFAULT_STRING" . 1349178)))
    ("SetCatalog" fun "IDLffLanguageCat" (system) "Result = Obj ->[%s::]%s( application)" ("objects75.html" ("FILENAME" . 1349199) ("LOCALE" . 1349202) ("PATH" . 1349205)))
    ("Cleanup" pro "IDLffMrSID" (system) "Obj -> [%s::]%s" ("objects77.html"))
    ("GetProperty" pro "IDLffMrSID" (system) "Obj->[%s::]%s" ("objects80.html" ("CHANNELS" . 1385508) ("DIMENSIONS" . 1385510) ("GEO_ORIGIN" . 1385531) ("GEO_PROJTYPE" . 1385526) ("GEO_RESOLUTION" . 1385533) ("GEO_VALID" . 1385521) ("LEVELS" . 1385512) ("PIXEL_TYPE" . 1385514) ("TYPE" . 1424312)))
    ("GetDimsAtLevel" fun "IDLffMrSID" (system) "Dims = Obj -> [%s::]%s ( Level )" ("objects78.html"))
    ("GetImageData" fun "IDLffMrSID" (system) "ImageData = Obj->[%s::]%s ()" ("objects79.html" ("LEVEL" . 1385446) ("SUB_RECT" . 1385449)))
    ("Init" fun "IDLffMrSID" (system) "Result = Obj -> [%s::]%s(, Filename)" ("objects81.html" ("QUIET" . 1385580)))
    ("AddAttribute" pro "IDLffShape" (system) "Obj->[%s::]%s, Name, Type, Width" ("objects83.html" ("PRECISION" . 1375556)))
    ("Cleanup" pro "IDLffShape" (system) "Obj -> [%s::]%s" ("objects84.html"))
    ("Close" pro "IDLffShape" (system) "Obj->[%s::]%s" ("objects85.html"))
    ("DestroyEntity" pro "IDLffShape" (system) "Obj->[%s::]%s, Entity" ("objects86.html"))
    ("GetProperty" pro "IDLffShape" (system) "Obj->[%s::]%s" ("objects89.html" ("ATTRIBUTE_INFO" . 1375673) ("ATTRIBUTE_NAMES" . 1375671) ("ENTITY_TYPE" . 1375664) ("FILENAME" . 1375724) ("IS_OPEN" . 1375701) ("N_ATTRIBUTES" . 1375669) ("N_ENTITIES" . 1375662) ("N_RECORDS" . 1435295)))
    ("PutEntity" pro "IDLffShape" (system) "Obj->[%s::]%s, Data" ("objects92.html"))
    ("SetAttributes" pro "IDLffShape" (system) "Obj->[%s::]%s, Index, Attribute_Num, Value or Obj->[IDLffShape::]SetAttributes, Index, Attributes" ("objects93.html"))
    ("GetAttributes" fun "IDLffShape" (system) "Result = Obj->[%s::]%s([Index])" ("objects87.html" ("ALL" . 1375612) ("ATTRIBUTE_STRUCTURE") ("ATTRIBUTE_STUCTURE" . 1375614)))
    ("GetEntity" fun "IDLffShape" (system) "Result = Obj->[%s::]%s( [Index])" ("objects88.html" ("ALL" . 1375643) ("ATTRIBUTES" . 1375645)))
    ("Init" fun "IDLffShape" (system) "Result = Obj -> [%s::]%s([, Filename])" ("objects90.html" ("DBF_ONLY" . 1375738) ("ENTITY_TYPE" . 1375740) ("UPDATE" . 1435244)))
    ("Open" fun "IDLffShape" (system) "Result = Obj->[%s::]%s( 'Filename')" ("objects91.html" ("DBF_ONLY" . 1375756) ("ENTITY_TYPE" . 1375758) ("UPDATE" . 1435299)))
    ("AttributeDecl" pro "IDLffXMLSAX" (system) "Obj -> [%s::]%s, eName, aName, Type, Mode, Value" ("objects95.html"))
    ("Characters" pro "IDLffXMLSAX" (system) "Obj -> [%s::]%s, Chars" ("objects96.html"))
    ("Cleanup" pro "IDLffXMLSAX" (system) "Obj -> [%s::]%s" ("objects97.html"))
    ("Comment" pro "IDLffXMLSAX" (system) "Obj -> [%s::]%s, Comment" ("objects98.html"))
    ("ElementDecl" pro "IDLffXMLSAX" (system) "Obj -> [%s::]%s, Name, Model" ("objects99.html"))
    ("EndCDATA" pro "IDLffXMLSAX" (system) "Obj -> [%s::]%s" ("objects100.html"))
    ("EndDocument" pro "IDLffXMLSAX" (system) "Obj -> [%s::]%s" ("objects101.html"))
    ("EndDTD" pro "IDLffXMLSAX" (system) "Obj -> [%s::]%s" ("objects102.html"))
    ("EndElement" pro "IDLffXMLSAX" (system) "Obj -> [%s::]%s, URI, Local, qName" ("objects103.html"))
    ("EndEntity" pro "IDLffXMLSAX" (system) "Obj -> [%s::]%s, Name" ("objects104.html"))
    ("EndPrefixMapping" pro "IDLffXMLSAX" (system) "Obj -> [%s::]%s, Prefix" ("objects105.html"))
    ("Error" pro "IDLffXMLSAX" (system) "Obj -> [%s::]%s, SystemID, LineNumber, ColumnNumber, Message" ("objects106.html"))
    ("ExternalEntityDecl" pro "IDLffXMLSAX" (system) "Obj -> [%s::]%s, Name, PublicID, SystemID" ("objects107.html"))
    ("FatalError" pro "IDLffXMLSAX" (system) "Obj -> [%s::]%s, SystemID, LineNumber, ColumnNumber, Message" ("objects108.html"))
    ("GetProperty" pro "IDLffXMLSAX" (system) "Obj -> [%s::]%s" ("objects109.html" ("FILENAME" . 1432500) ("PARSER_LOCATION" . 1432502) ("PARSER_PUBLICID" . 1432504) ("PARSER_URI" . 1432506)))
    ("IgnorableWhitespace" pro "IDLffXMLSAX" (system) "Obj -> [%s::]%s, Chars" ("objects110.html"))
    ("InternalEntityDecl" pro "IDLffXMLSAX" (system) "Obj -> [%s::]%s, Name, Value" ("objects112.html"))
    ("NotationDecl" pro "IDLffXMLSAX" (system) "Obj -> [%s::]%s, Name, PublicID, SystemID" ("objects113.html"))
    ("ParseFile" pro "IDLffXMLSAX" (system) "Obj -> [%s::]%s, Filename" ("objects114.html"))
    ("ProcessingInstruction" pro "IDLffXMLSAX" (system) "Obj -> [%s::]%s, Target, Data" ("objects115.html"))
    ("SetProperty" pro "IDLffXMLSAX" (system) "Obj -> [%s::]%s" ("objects116.html" ("NAMESPACE_PREFIXES") ("SCHEMA_CHECKING") ("VALIDATION_MODE")))
    ("SkippedEntity" pro "IDLffXMLSAX" (system) "Obj -> [%s::]%s, Name" ("objects117.html"))
    ("StartCDATA" pro "IDLffXMLSAX" (system) "Obj -> [%s::]%s" ("objects118.html"))
    ("StartDocument" pro "IDLffXMLSAX" (system) "Obj -> [%s::]%s" ("objects119.html"))
    ("StartDTD" pro "IDLffXMLSAX" (system) "Obj -> [%s::]%s, Name, PublicID, SystemID" ("objects120.html"))
    ("StartElement" pro "IDLffXMLSAX" (system) "Obj -> [%s::]%s, URI, Local, qName [, attName, attValue]" ("objects121.html"))
    ("StartEntity" pro "IDLffXMLSAX" (system) "Obj -> [%s::]%s, Name" ("objects122.html"))
    ("StartPrefixmapping" pro "IDLffXMLSAX" (system) "Obj -> [%s::]%s, Prefix, URI" ("objects123.html"))
    ("StopParsing" pro "IDLffXMLSAX" (system) "Obj -> [%s::]%s" ("objects124.html"))
    ("UnparsedEntityDecl" pro "IDLffXMLSAX" (system) "Obj -> [%s::]%s, Name, PublicID, SystemID, Notation" ("objects125.html"))
    ("Warning" pro "IDLffXMLSAX" (system) "Obj -> [%s::]%s, SystemID, LineNumber, ColumnNumber, Message" ("objects126.html"))
    ("Init" fun "IDLffXMLSAX" (system) "Result = Obj -> [%s::]%s()" ("objects111.html" ("NAMESPACE_PREFIXES" . 1432566) ("SCHEMA_CHECKING" . 1432569) ("VALIDATION_MODE" . 1432593)))
    ("Cleanup" pro "IDLgrAxis" (system) "Obj -> [%s::]%s" ("objects128.html"))
    ("GetProperty" pro "IDLgrAxis" (system) "Obj -> [%s::]%s" ("objects130.html" ("ALL" . 1022143) ("CRANGE" . 1068590) ("PARENT" . 1038594) ("XRANGE" . 1047353) ("YRANGE" . 1038598) ("ZRANGE" . 1038602)) ("objects131.html" ("AM_PM" . 1039204) ("CLIP_PLANES" . 1403190) ("COLOR" . 1304560) ("DAYS_OF_WEEK" . 1304567) ("DIRECTION" . 1363544) ("EXACT" . 1024743) ("EXTEND" . 996947) ("GRIDSTYLE" . 996949) ("HIDE" . 1047392) ("LOCATION" . 1047377) ("LOG" . 996951) ("MAJOR" . 996953) ("MINOR" . 996955) ("MONTHS" . 1039269) ("NAME" . 1304572) ("NOTEXT" . 996957) ("PALETTE" . 1049402) ("RANGE" . 1346564) ("SUBTICKLEN" . 1049431) ("TEXTALIGNMENTS" . 1356847) ("TEXTBASELINE" . 1356868) ("TEXTPOS" . 1142964) ("TEXTUPDIR" . 1356940) ("THICK" . 1356917) ("TICKDIR" . 996961) ("TICKFORMAT" . 996963) ("TICKFRMTDATA" . 1373913) ("TICKINTERVAL" . 1372486) ("TICKLAYOUT" . 1373756) ("TICKLEN" . 996965) ("TICKTEXT" . 996967) ("TICKUNITS" . 1373791) ("TICKVALUES" . 1022700) ("TITLE" . 1011384) ("USE_TEXT_COLOR" . 1142995) ("UVALUE" . 1049238) ("XCOORD_CONV" . 1039283) ("YCOORD_CONV" . 1039290) ("ZCOORD_CONV" . 1039297)))
    ("SetProperty" pro "IDLgrAxis" (system) "Obj -> [%s::]%s" ("objects132.html") ("objects131.html" ("AM_PM" . 1039204) ("CLIP_PLANES" . 1403190) ("COLOR" . 1304560) ("DAYS_OF_WEEK" . 1304567) ("DIRECTION" . 1363544) ("EXACT" . 1024743) ("EXTEND" . 996947) ("GRIDSTYLE" . 996949) ("HIDE" . 1047392) ("LOCATION" . 1047377) ("LOG" . 996951) ("MAJOR" . 996953) ("MINOR" . 996955) ("MONTHS" . 1039269) ("NAME" . 1304572) ("NOTEXT" . 996957) ("PALETTE" . 1049402) ("RANGE" . 1346564) ("SUBTICKLEN" . 1049431) ("TEXTALIGNMENTS" . 1356847) ("TEXTBASELINE" . 1356868) ("TEXTPOS" . 1142964) ("TEXTUPDIR" . 1356940) ("THICK" . 1356917) ("TICKDIR" . 996961) ("TICKFORMAT" . 996963) ("TICKFRMTDATA" . 1373913) ("TICKINTERVAL" . 1372486) ("TICKLAYOUT" . 1373756) ("TICKLEN" . 996965) ("TICKTEXT" . 996967) ("TICKUNITS" . 1373791) ("TICKVALUES" . 1022700) ("TITLE" . 1011384) ("USE_TEXT_COLOR" . 1142995) ("UVALUE" . 1049238) ("XCOORD_CONV" . 1039283) ("YCOORD_CONV" . 1039290) ("ZCOORD_CONV" . 1039297)))
    ("GetCTM" fun "IDLgrAxis" (system) "Result = Obj -> [%s::]%s()" ("objects129.html" ("DESTINATION" . 1038630) ("PATH" . 1328819) ("TOP" . 1038633)))
    ("Init" fun "IDLgrAxis" (system) "Result = Obj -> [%s::]%s([, Direction])" ("objects131.html" ("AM_PM" . 1039204) ("CLIP_PLANES" . 1403190) ("COLOR" . 1304560) ("DAYS_OF_WEEK" . 1304567) ("DIRECTION" . 1363544) ("EXACT" . 1024743) ("EXTEND" . 996947) ("GRIDSTYLE" . 996949) ("HIDE" . 1047392) ("LOCATION" . 1047377) ("LOG" . 996951) ("MAJOR" . 996953) ("MINOR" . 996955) ("MONTHS" . 1039269) ("NAME" . 1304572) ("NOTEXT" . 996957) ("PALETTE" . 1049402) ("RANGE" . 1346564) ("SUBTICKLEN" . 1049431) ("TEXTALIGNMENTS" . 1356847) ("TEXTBASELINE" . 1356868) ("TEXTPOS" . 1142964) ("TEXTUPDIR" . 1356940) ("THICK" . 1356917) ("TICKDIR" . 996961) ("TICKFORMAT" . 996963) ("TICKFRMTDATA" . 1373913) ("TICKINTERVAL" . 1372486) ("TICKLAYOUT" . 1373756) ("TICKLEN" . 996965) ("TICKTEXT" . 996967) ("TICKUNITS" . 1373791) ("TICKVALUES" . 1022700) ("TITLE" . 1011384) ("USE_TEXT_COLOR" . 1142995) ("UVALUE" . 1049238) ("XCOORD_CONV" . 1039283) ("YCOORD_CONV" . 1039290) ("ZCOORD_CONV" . 1039297)))
    ("Cleanup" pro "IDLgrBuffer" (system) "Obj -> [%s::]%s" ("objects134.html"))
    ("Draw" pro "IDLgrBuffer" (system) "Obj -> [%s::]%s [, Picture]" ("objects135.html" ("CREATE_INSTANCE" . 1143535) ("DRAW_INSTANCE" . 1143538)))
    ("Erase" pro "IDLgrBuffer" (system) "Obj -> [%s::]%s" ("objects136.html" ("COLOR" . 1143558)))
    ("GetDeviceInfo" pro "IDLgrBuffer" (system) "Obj -> [%s::]%s" ("objects138.html" ("ALL" . 1354806) ("MAX_NUM_CLIP_PLANES" . 1403421) ("MAX_TEXTURE_DIMENSIONS" . 1354808) ("MAX_VIEWPORT_DIMENSIONS" . 1354810) ("NAME" . 1354812) ("NUM_CPUS" . 1354814) ("VENDOR" . 1354817) ("VERSION" . 1354819)))
    ("GetProperty" pro "IDLgrBuffer" (system) "Obj -> [%s::]%s" ("objects140.html" ("ALL" . 1143583) ("IMAGE_DATA" . 1143586) ("SCREEN_DIMENSIONS" . 1155936) ("ZBUFFER_DATA" . 1430373)) ("objects142.html" ("COLOR_MODEL" . 1143644) ("DIMENSIONS" . 1143649) ("GRAPHICS_TREE" . 1143652) ("N_COLORS" . 1143655) ("PALETTE" . 1346695) ("QUALITY" . 1346690) ("RESOLUTION" . 1143667) ("UNITS" . 1373543) ("UVALUE" . 1143678)))
    ("SetProperty" pro "IDLgrBuffer" (system) "Obj -> [%s::]%s" ("objects146.html") ("objects142.html" ("DIMENSIONS" . 1143649) ("GRAPHICS_TREE" . 1143652) ("PALETTE" . 1346695) ("QUALITY" . 1346690) ("RESOLUTION" . 1143667) ("UNITS" . 1373543) ("UVALUE" . 1143678)))
    ("GetContiguousPixels" fun "IDLgrBuffer" (system) "Return = Obj -> [%s::]%s()" ("objects137.html"))
    ("GetFontnames" fun "IDLgrBuffer" (system) "Return = Obj -> [%s::]%s( FamilyName)" ("objects139.html" ("IDL_FONTS" . 1229042) ("STYLES" . 1229043)))
    ("GetTextDimensions" fun "IDLgrBuffer" (system) "Result = Obj ->[%s::]%s( TextObj)" ("objects141.html" ("DESCENT" . 1143609) ("PATH" . 1295711)))
    ("Init" fun "IDLgrBuffer" (system) "Result = Obj -> [%s::]%s()" ("objects142.html" ("COLOR_MODEL" . 1143644) ("DIMENSIONS" . 1143649) ("GRAPHICS_TREE" . 1143652) ("N_COLORS" . 1143655) ("PALETTE" . 1346695) ("QUALITY" . 1346690) ("RESOLUTION" . 1143667) ("UNITS" . 1373543) ("UVALUE" . 1143678)))
    ("PickData" fun "IDLgrBuffer" (system) "Result = Obj -> [%s::]%s( View, Object, Location, XYZLocation)" ("objects143.html" ("DIMENSIONS" . 1386590) ("PATH" . 1386575) ("PICK_STATUS" . 1413928)))
    ("Read" fun "IDLgrBuffer" (system) "Result = Obj -> [%s::]%s()" ("objects144.html"))
    ("Select" fun "IDLgrBuffer" (system) "Result = Obj -> [%s::]%s(Picture, XY)" ("objects145.html" ("DIMENSIONS" . 1143755) ("UNITS" . 1143760)))
    ("Cleanup" pro "IDLgrClipboard" (system) "Obj-> [%s::]%s" ("objects148.html"))
    ("Draw" pro "IDLgrClipboard" (system) "Obj -> [%s::]%s [, Picture]" ("objects149.html" ("FILENAME" . 1143949) ("POSTSCRIPT" . 1356705) ("VECTOR" . 1356727)))
    ("GetDeviceInfo" pro "IDLgrClipboard" (system) "Obj -> [%s::]%s" ("objects151.html" ("ALL" . 1354847) ("MAX_NUM_CLIP_PLANES" . 1403444) ("MAX_TEXTURE_DIMENSIONS" . 1354849) ("MAX_VIEWPORT_DIMENSIONS" . 1354851) ("NAME" . 1354853) ("NUM_CPUS" . 1354855) ("VENDOR" . 1354858) ("VERSION" . 1354860)))
    ("GetProperty" pro "IDLgrClipboard" (system) "Obj -> [%s::]%s" ("objects153.html" ("ALL" . 1143975) ("SCREEN_DIMENSIONS" . 1156045)) ("objects155.html" ("COLOR_MODEL" . 1144030) ("DIMENSIONS" . 1144035) ("GRAPHICS_TREE" . 1144038) ("N_COLORS" . 1144041) ("PALETTE" . 1144044) ("QUALITY" . 1144047) ("RESOLUTION" . 1144053) ("UNITS" . 1144056) ("UVALUE" . 1144064)))
    ("SetProperty" pro "IDLgrClipboard" (system) "Obj -> [%s::]%s" ("objects156.html") ("objects155.html" ("DIMENSIONS" . 1144035) ("GRAPHICS_TREE" . 1144038) ("PALETTE" . 1144044) ("QUALITY" . 1144047) ("RESOLUTION" . 1144053) ("UNITS" . 1144056) ("UVALUE" . 1144064)))
    ("GetContiguousPixels" fun "IDLgrClipboard" (system) "Return = Obj ->[%s::]%s()" ("objects150.html"))
    ("GetFontnames" fun "IDLgrClipboard" (system) "Return = Obj -> [%s::]%s( FamilyName)" ("objects152.html" ("IDL_FONTS" . 1235781) ("STYLES" . 1235784)))
    ("GetTextDimensions" fun "IDLgrClipboard" (system) "Result = Obj ->[%s::]%s( TextObj)" ("objects154.html" ("DESCENT" . 1155985) ("PATH" . 1295717)))
    ("Init" fun "IDLgrClipboard" (system) "Result = Obj -> [%s::]%s()" ("objects155.html" ("COLOR_MODEL" . 1144030) ("DIMENSIONS" . 1144035) ("GRAPHICS_TREE" . 1144038) ("N_COLORS" . 1144041) ("PALETTE" . 1144044) ("QUALITY" . 1144047) ("RESOLUTION" . 1144053) ("UNITS" . 1144056) ("UVALUE" . 1144064)))
    ("Cleanup" pro "IDLgrColorbar" (system) "Obj -> [%s::]%s" ("objects158.html"))
    ("GetProperty" pro "IDLgrColorbar" (system) "Obj -> [%s::]%s" ("objects160.html" ("ALL" . 1144214) ("PARENT" . 1144217) ("XRANGE" . 1363748) ("YRANGE" . 1144223) ("ZRANGE" . 1144226)) ("objects161.html" ("BLUE_VALUES" . 1144267) ("COLOR" . 1144270) ("DIMENSIONS" . 1377414) ("GREEN_VALUES" . 1144276) ("HIDE" . 1144282) ("MAJOR" . 1144287) ("MINOR" . 1144290) ("NAME" . 1144293) ("PALETTE" . 1296111) ("RED_VALUES" . 1296114) ("SHOW_AXIS" . 1144296) ("SHOW_OUTLINE" . 1144302) ("SUBTICKLEN" . 1144307) ("THICK" . 1144310) ("THREED" . 1236295) ("TICKFORMAT" . 1236291) ("TICKFRMTDATA" . 1144316) ("TICKLEN" . 1144319) ("TICKTEXT" . 1144322) ("TICKVALUES" . 1144325) ("TITLE" . 1144328) ("UVALUE" . 1144331) ("XCOORD_CONV" . 1366619) ("YCOORD_CONV" . 1144341) ("ZCOORD_CONV" . 1144348)))
    ("SetProperty" pro "IDLgrColorbar" (system) "Obj -> [%s::]%s" ("objects162.html") ("objects161.html" ("BLUE_VALUES" . 1144267) ("COLOR" . 1144270) ("DIMENSIONS" . 1377414) ("GREEN_VALUES" . 1144276) ("HIDE" . 1144282) ("MAJOR" . 1144287) ("MINOR" . 1144290) ("NAME" . 1144293) ("PALETTE" . 1296111) ("RED_VALUES" . 1296114) ("SHOW_AXIS" . 1144296) ("SHOW_OUTLINE" . 1144302) ("SUBTICKLEN" . 1144307) ("THICK" . 1144310) ("TICKFORMAT" . 1236291) ("TICKFRMTDATA" . 1144316) ("TICKLEN" . 1144319) ("TICKTEXT" . 1144322) ("TICKVALUES" . 1144325) ("TITLE" . 1144328) ("UVALUE" . 1144331) ("XCOORD_CONV" . 1366619) ("YCOORD_CONV" . 1144341) ("ZCOORD_CONV" . 1144348)))
    ("ComputeDimensions" fun "IDLgrColorbar" (system) "Result = Obj ->[%s::]%s( DestinationObj)" ("objects159.html" ("PATH" . 1295841)))
    ("Init" fun "IDLgrColorbar" (system) "Result = Obj -> [%s::]%s([, aRed, aGreen, aBlue])" ("objects161.html" ("BLUE_VALUES" . 1144267) ("COLOR" . 1144270) ("DIMENSIONS" . 1377414) ("GREEN_VALUES" . 1144276) ("HIDE" . 1144282) ("MAJOR" . 1144287) ("MINOR" . 1144290) ("NAME" . 1144293) ("PALETTE" . 1296111) ("RED_VALUES" . 1296114) ("SHOW_AXIS" . 1144296) ("SHOW_OUTLINE" . 1144302) ("SUBTICKLEN" . 1144307) ("THICK" . 1144310) ("THREED" . 1236295) ("TICKFORMAT" . 1236291) ("TICKFRMTDATA" . 1144316) ("TICKLEN" . 1144319) ("TICKTEXT" . 1144322) ("TICKVALUES" . 1144325) ("TITLE" . 1144328) ("UVALUE" . 1144331) ("XCOORD_CONV" . 1366619) ("YCOORD_CONV" . 1144341) ("ZCOORD_CONV" . 1144348)))
    ("AdjustLabelOffsets" pro "IDLgrContour" (system) "Obj->[%s::]%s, LevelIndex, LabelOffsets" ("objects164.html"))
    ("Cleanup" pro "IDLgrContour" (system) "Obj -> [%s::]%s" ("objects165.html"))
    ("GetLabelInfo" pro "IDLgrContour" (system) "Obj->[%s::]%s, Destination, LevelIndex" ("objects167.html" ("LABEL_OBJECTS" . 1432968) ("LABEL_OFFSETS" . 1432964) ("LABEL_POLYLINES" . 1432966) ("LABEL_POLYS")))
    ("GetProperty" pro "IDLgrContour" (system) "Obj -> [%s::]%s" ("objects168.html" ("ALL" . 1398278) ("GEOM" . 1386608) ("PARENT" . 1144513) ("XRANGE" . 1363800) ("YRANGE" . 1144519) ("ZRANGE" . 1144522)) ("objects169.html" ("AM_PM" . 1166555) ("ANISOTROPY" . 1402012) ("C_COLOR" . 1144559) ("C_FILL_PATTERN" . 1144562) ("C_LABEL_INTERVAL" . 1144565) ("C_LABEL_NOGAPS" . 1402024) ("C_LABEL_OBJECTS" . 1402065) ("C_LABEL_SHOW" . 1402038) ("C_LINESTYLE" . 1402079) ("C_THICK" . 1144568) ("C_USE_LABEL_COLOR" . 1144571) ("C_USE_LABEL_ORIENTATION" . 1402101) ("C_VALUE" . 1402132) ("CLIP_PLANES" . 1403225) ("COLOR" . 1144574) ("DATA_VALUES" . 1144577) ("DAYS_OF_WEEK" . 1402144) ("DEPTH_OFFSET" . 1402143) ("DOUBLE_DATA" . 1363858) ("DOUBLE_GEOM" . 1363860) ("DOWNHILL" . 1363875) ("FILL" . 1144583) ("HIDE" . 1144600) ("LABEL_FONT" . 1436226) ("LABEL_FORMAT" . 1436227) ("LABEL_UNITS" . 1402202) ("MAX_VALUE" . 1402222) ("MIN_VALUE" . 1402265) ("MONTHS" . 1370076) ("N_LEVELS" . 1144614) ("NAME" . 1144611) ("PALETTE" . 1356774) ("PLANAR" . 1144617) ("POLYGONS" . 1144620) ("SHADE_RANGE" . 1156129) ("SHADING" . 1346958) ("TICKINTERVAL" . 1346949) ("TICKLEN" . 1366637) ("USE_TEXT_ALIGNMENTS" . 1366639) ("UVALUE" . 1402282) ("XCOORD_CONV" . 1144627) ("YCOORD_CONV" . 1144634) ("ZCOORD_CONV" . 1144641)))
    ("SetProperty" pro "IDLgrContour" (system) "Obj -> [%s::]%s" ("objects170.html") ("objects169.html" ("AM_PM" . 1166555) ("ANISOTROPY" . 1402012) ("C_COLOR" . 1144559) ("C_FILL_PATTERN" . 1144562) ("C_LABEL_INTERVAL" . 1144565) ("C_LABEL_NOGAPS" . 1402024) ("C_LABEL_OBJECTS" . 1402065) ("C_LABEL_SHOW" . 1402038) ("C_LINESTYLE" . 1402079) ("C_THICK" . 1144568) ("C_USE_LABEL_COLOR" . 1144571) ("C_USE_LABEL_ORIENTATION" . 1402101) ("C_VALUE" . 1402132) ("CLIP_PLANES" . 1403225) ("COLOR" . 1144574) ("DATA_VALUES" . 1144577) ("DAYS_OF_WEEK" . 1402144) ("DEPTH_OFFSET" . 1402143) ("DOUBLE_DATA" . 1363858) ("DOUBLE_GEOM" . 1363860) ("DOWNHILL" . 1363875) ("FILL" . 1144583) ("GEOMX" . 1144586) ("GEOMY" . 1144589) ("GEOMZ" . 1377454) ("HIDE" . 1144600) ("LABEL_FONT" . 1436226) ("LABEL_FORMAT" . 1436227) ("LABEL_UNITS" . 1402202) ("MAX_VALUE" . 1402222) ("MIN_VALUE" . 1402265) ("MONTHS" . 1370076) ("N_LEVELS" . 1144614) ("NAME" . 1144611) ("PALETTE" . 1356774) ("PLANAR" . 1144617) ("POLYGONS" . 1144620) ("SHADE_RANGE" . 1156129) ("SHADING" . 1346958) ("TICKINTERVAL" . 1346949) ("TICKLEN" . 1366637) ("USE_TEXT_ALIGNMENTS" . 1366639) ("UVALUE" . 1402282) ("XCOORD_CONV" . 1144627) ("YCOORD_CONV" . 1144634) ("ZCOORD_CONV" . 1144641)))
    ("GetCTM" fun "IDLgrContour" (system) "Result = Obj -> [%s::]%s()" ("objects166.html" ("DESTINATION" . 1144474) ("PATH" . 1328828) ("TOP" . 1144477)))
    ("Init" fun "IDLgrContour" (system) "Result = Obj -> [%s::]%s([, Values])" ("objects169.html" ("AM_PM" . 1166555) ("ANISOTROPY" . 1402012) ("C_COLOR" . 1144559) ("C_FILL_PATTERN" . 1144562) ("C_LABEL_INTERVAL" . 1144565) ("C_LABEL_NOGAPS" . 1402024) ("C_LABEL_OBJECTS" . 1402065) ("C_LABEL_SHOW" . 1402038) ("C_LINESTYLE" . 1402079) ("C_THICK" . 1144568) ("C_USE_LABEL_COLOR" . 1144571) ("C_USE_LABEL_ORIENTATION" . 1402101) ("C_VALUE" . 1402132) ("CLIP_PLANES" . 1403225) ("COLOR" . 1144574) ("DATA_VALUES" . 1144577) ("DAYS_OF_WEEK" . 1402144) ("DEPTH_OFFSET" . 1402143) ("DOUBLE_DATA" . 1363858) ("DOUBLE_GEOM" . 1363860) ("DOWNHILL" . 1363875) ("FILL" . 1144583) ("GEOMX" . 1144586) ("GEOMY" . 1144589) ("GEOMZ" . 1377454) ("HIDE" . 1144600) ("LABEL_FONT" . 1436226) ("LABEL_FORMAT" . 1436227) ("LABEL_FRMTDATA" . 1402164) ("LABEL_UNITS" . 1402202) ("MAX_VALUE" . 1402222) ("MIN_VALUE" . 1402265) ("MONTHS" . 1370076) ("N_LEVELS" . 1144614) ("NAME" . 1144611) ("PALETTE" . 1356774) ("PLANAR" . 1144617) ("POLYGONS" . 1144620) ("SHADE_RANGE" . 1156129) ("SHADING" . 1346958) ("TICKINTERVAL" . 1346949) ("TICKLEN" . 1366637) ("USE_TEXT_ALIGNMENTS" . 1366639) ("UVALUE" . 1402282) ("XCOORD_CONV" . 1144627) ("YCOORD_CONV" . 1144634) ("ZCOORD_CONV" . 1144641)))
    ("Cleanup" pro "IDLgrFont" (system) "Obj -> [%s::]%s" ("objects172.html"))
    ("GetProperty" pro "IDLgrFont" (system) "" ("") ("objects174.html" ("NAME" . 1012603) ("SIZE" . 1049468) ("SUBSTITUTE" . 1012605) ("THICK" . 1017971) ("UVALUE" . 1173773)))
    ("SetProperty" pro "IDLgrFont" (system) "" ("") ("objects174.html" ("NAME" . 1012603) ("SIZE" . 1049468) ("SUBSTITUTE" . 1012605) ("THICK" . 1017971) ("UVALUE" . 1173773)))
    ("Init" fun "IDLgrFont" (system) "Result = Obj -> [%s::]%s([, Fontname])" ("objects174.html" ("NAME" . 1012603) ("SIZE" . 1049468) ("SUBSTITUTE" . 1012605) ("THICK" . 1017971) ("UVALUE" . 1173773)))
    ("Cleanup" pro "IDLgrImage" (system) "Obj -> [%s::]%s" ("objects177.html"))
    ("GetProperty" pro "IDLgrImage" (system) "Obj -> [%s::]%s" ("objects179.html" ("ALL" . 997288) ("PARENT" . 1048860) ("XRANGE" . 1363953) ("YRANGE" . 1039033) ("ZRANGE" . 1039037)) ("objects180.html" ("BLEND_FUNCTION" . 1025046) ("CHANNEL" . 1369597) ("CLIP_PLANES" . 1403249) ("DATA" . 1028023) ("DIMENSIONS" . 1028026) ("GREYSCALE" . 1054721) ("HIDE" . 1049499) ("INTERLEAVE" . 1028440) ("INTERPOLATE" . 1285296) ("LOCATION" . 1285294) ("NAME" . 1049027) ("NO_COPY" . 1025083) ("ORDER" . 1049513) ("PALETTE" . 1012695) ("SUB_RECT" . 1356674) ("UVALUE" . 1049519) ("XCOORD_CONV" . 1039398) ("YCOORD_CONV" . 1039405) ("ZCOORD_CONV" . 1039412)))
    ("SetProperty" pro "IDLgrImage" (system) "Obj -> [%s::]%s" ("objects181.html") ("objects180.html" ("BLEND_FUNCTION" . 1025046) ("CHANNEL" . 1369597) ("CLIP_PLANES" . 1403249) ("DATA" . 1028023) ("DIMENSIONS" . 1028026) ("GREYSCALE" . 1054721) ("HIDE" . 1049499) ("INTERLEAVE" . 1028440) ("INTERPOLATE" . 1285296) ("LOCATION" . 1285294) ("NAME" . 1049027) ("NO_COPY" . 1025083) ("ORDER" . 1049513) ("PALETTE" . 1012695) ("RESET_DATA" . 1060509) ("SHARE_DATA" . 1028455) ("SUB_RECT" . 1356674) ("UVALUE" . 1049519) ("XCOORD_CONV" . 1039398) ("YCOORD_CONV" . 1039405) ("ZCOORD_CONV" . 1039412)))
    ("GetCTM" fun "IDLgrImage" (system) "Result = Obj -> [%s::]%s()" ("objects178.html" ("DESTINATION" . 1038670) ("PATH" . 1328835) ("TOP" . 1047274)))
    ("Init" fun "IDLgrImage" (system) "Result = Obj -> [%s::]%s([, ImageData])" ("objects180.html" ("BLEND_FUNCTION" . 1025046) ("CHANNEL" . 1369597) ("CLIP_PLANES" . 1403249) ("DATA" . 1028023) ("DIMENSIONS" . 1028026) ("GREYSCALE" . 1054721) ("HIDE" . 1049499) ("INTERLEAVE" . 1028440) ("INTERPOLATE" . 1285296) ("LOCATION" . 1285294) ("NAME" . 1049027) ("NO_COPY" . 1025083) ("ORDER" . 1049513) ("PALETTE" . 1012695) ("RESET_DATA" . 1060509) ("SHARE_DATA" . 1028455) ("SUB_RECT" . 1356674) ("UVALUE" . 1049519) ("XCOORD_CONV" . 1039398) ("YCOORD_CONV" . 1039405) ("ZCOORD_CONV" . 1039412)))
    ("Cleanup" pro "IDLgrLegend" (system) "Obj -> [%s::]%s" ("objects183.html"))
    ("GetProperty" pro "IDLgrLegend" (system) "Obj -> [%s::]%s" ("objects185.html" ("ALL" . 1144894) ("PARENT" . 1144897) ("XRANGE" . 1363995) ("YRANGE" . 1144903) ("ZRANGE" . 1144906)) ("objects186.html" ("BORDER_GAP" . 1144943) ("COLUMNS" . 1144946) ("FILL_COLOR" . 1144949) ("FONT" . 1144952) ("GAP" . 1144956) ("GLYPH_WIDTH" . 1144959) ("HIDE" . 1144962) ("ITEM_COLOR" . 1144967) ("ITEM_LINESTYLE" . 1144970) ("ITEM_NAME" . 1338273) ("ITEM_OBJECT" . 1144984) ("ITEM_THICK" . 1144988) ("ITEM_TYPE" . 1144991) ("NAME" . 1144996) ("OUTLINE_COLOR" . 1144999) ("OUTLINE_THICK" . 1145002) ("SHOW_FILL" . 1145005) ("SHOW_OUTLINE" . 1145010) ("TEXT_COLOR" . 1145015) ("TITLE" . 1145018) ("UVALUE" . 1145021) ("XCOORD_CONV" . 1145024) ("YCOORD_CONV" . 1145031) ("ZCOORD_CONV" . 1145038)))
    ("SetProperty" pro "IDLgrLegend" (system) "Obj-> [%s::]%s" ("objects187.html" ("RECOMPUTE" . 1329025)) ("objects186.html" ("BORDER_GAP" . 1144943) ("COLUMNS" . 1144946) ("FILL_COLOR" . 1144949) ("FONT" . 1144952) ("GAP" . 1144956) ("GLYPH_WIDTH" . 1144959) ("HIDE" . 1144962) ("ITEM_COLOR" . 1144967) ("ITEM_LINESTYLE" . 1144970) ("ITEM_NAME" . 1338273) ("ITEM_OBJECT" . 1144984) ("ITEM_THICK" . 1144988) ("ITEM_TYPE" . 1144991) ("NAME" . 1144996) ("OUTLINE_COLOR" . 1144999) ("OUTLINE_THICK" . 1145002) ("SHOW_FILL" . 1145005) ("SHOW_OUTLINE" . 1145010) ("TEXT_COLOR" . 1145015) ("TITLE" . 1145018) ("UVALUE" . 1145021) ("XCOORD_CONV" . 1145024) ("YCOORD_CONV" . 1145031) ("ZCOORD_CONV" . 1145038)))
    ("ComputeDimensions" fun "IDLgrLegend" (system) "Result = Obj ->[%s::]%s( DestinationObject)" ("objects184.html" ("PATH" . 1295831)))
    ("Init" fun "IDLgrLegend" (system) "Result = Obj -> [%s::]%s([, aItemNames])" ("objects186.html" ("BORDER_GAP" . 1144943) ("COLUMNS" . 1144946) ("FILL_COLOR" . 1144949) ("FONT" . 1144952) ("GAP" . 1144956) ("GLYPH_WIDTH" . 1144959) ("HIDE" . 1144962) ("ITEM_COLOR" . 1144967) ("ITEM_LINESTYLE" . 1144970) ("ITEM_NAME" . 1338273) ("ITEM_OBJECT" . 1144984) ("ITEM_THICK" . 1144988) ("ITEM_TYPE" . 1144991) ("NAME" . 1144996) ("OUTLINE_COLOR" . 1144999) ("OUTLINE_THICK" . 1145002) ("SHOW_FILL" . 1145005) ("SHOW_OUTLINE" . 1145010) ("TEXT_COLOR" . 1145015) ("TITLE" . 1145018) ("UVALUE" . 1145021) ("XCOORD_CONV" . 1145024) ("YCOORD_CONV" . 1145031) ("ZCOORD_CONV" . 1145038)))
    ("Cleanup" pro "IDLgrLight" (system) "Obj -> [%s::]%s" ("objects189.html"))
    ("GetProperty" pro "IDLgrLight" (system) "Obj -> [%s::]%s" ("objects191.html" ("ALL" . 997380) ("PARENT" . 1048865)) ("objects192.html" ("ATTENUATION" . 1012823) ("COLOR" . 1012827) ("CONEANGLE" . 1012829) ("DIRECTION" . 1012831) ("FOCUS" . 1058634) ("HIDE" . 1049149) ("INTENSITY" . 1012835) ("LOCATION" . 1012837) ("NAME" . 1049032) ("TYPE" . 1012839) ("UVALUE" . 1049626) ("XCOORD_CONV" . 1039449) ("YCOORD_CONV" . 1039456) ("ZCOORD_CONV" . 1039463)))
    ("SetProperty" pro "IDLgrLight" (system) "Obj -> [%s::]%s" ("objects193.html") ("objects192.html" ("ATTENUATION" . 1012823) ("COLOR" . 1012827) ("CONEANGLE" . 1012829) ("DIRECTION" . 1012831) ("FOCUS" . 1058634) ("HIDE" . 1049149) ("INTENSITY" . 1012835) ("LOCATION" . 1012837) ("NAME" . 1049032) ("TYPE" . 1012839) ("UVALUE" . 1049626) ("XCOORD_CONV" . 1039449) ("YCOORD_CONV" . 1039456) ("ZCOORD_CONV" . 1039463)))
    ("GetCTM" fun "IDLgrLight" (system) "Result = Obj -> [%s::]%s()" ("objects190.html" ("DESTINATION" . 1038712) ("PATH" . 1328842) ("TOP" . 1047282)))
    ("Init" fun "IDLgrLight" (system) "Result = Obj -> [%s::]%s()" ("objects192.html" ("ATTENUATION" . 1012823) ("COLOR" . 1012827) ("CONEANGLE" . 1012829) ("DIRECTION" . 1012831) ("FOCUS" . 1058634) ("HIDE" . 1049149) ("INTENSITY" . 1012835) ("LOCATION" . 1012837) ("NAME" . 1049032) ("TYPE" . 1012839) ("UVALUE" . 1049626) ("XCOORD_CONV" . 1039449) ("YCOORD_CONV" . 1039456) ("ZCOORD_CONV" . 1039463)))
    ("Add" pro "IDLgrModel" (system) "Obj -> [%s::]%s, Object" ("objects195.html" ("ALIAS" . 1285327) ("POSITION" . 1069115)))
    ("Cleanup" pro "IDLgrModel" (system) "Obj -> [%s::]%s" ("objects196.html"))
    ("Draw" pro "IDLgrModel" (system) "Obj -> [%s::]%s, Destination, Picture" ("objects197.html"))
    ("GetProperty" pro "IDLgrModel" (system) "Obj -> [%s::]%s" ("objects200.html" ("ALL" . 1016914) ("PARENT" . 1048870)) ("objects201.html" ("CLIP_PLANES" . 1403290) ("HIDE" . 1403287) ("LIGHTING" . 1143002) ("NAME" . 997500) ("SELECT_TARGET" . 997506) ("TRANSFORM" . 1029507) ("UVALUE" . 997508)))
    ("Reset" pro "IDLgrModel" (system) "Obj -> [%s::]%s" ("objects202.html"))
    ("Rotate" pro "IDLgrModel" (system) "Obj -> [%s::]%s, Axis, Angle" ("objects203.html" ("PREMULTIPLY" . 1143114)))
    ("Scale" pro "IDLgrModel" (system) "Obj -> [%s::]%s, Sx, Sy, Sz" ("objects204.html" ("PREMULTIPLY" . 997570)))
    ("SetProperty" pro "IDLgrModel" (system) "Obj -> [%s::]%s" ("objects205.html") ("objects201.html" ("CLIP_PLANES" . 1403290) ("HIDE" . 1403287) ("LIGHTING" . 1143002) ("NAME" . 997500) ("SELECT_TARGET" . 997506) ("TRANSFORM" . 1029507) ("UVALUE" . 997508)))
    ("Translate" pro "IDLgrModel" (system) "Obj -> [%s::]%s, Tx, Ty, Tz" ("objects206.html" ("PREMULTIPLY" . 997579)))
    ("GetByName" fun "IDLgrModel" (system) "Result = Obj -> [%s::]%s(Name)" ("objects198.html"))
    ("GetCTM" fun "IDLgrModel" (system) "Result = Obj -> [%s::]%s()" ("objects199.html" ("DESTINATION" . 1049686) ("PATH" . 1049689) ("TOP" . 1295511)))
    ("Init" fun "IDLgrModel" (system) "Result = Obj -> [%s::]%s()" ("objects201.html" ("CLIP_PLANES" . 1403290) ("HIDE" . 1403287) ("LIGHTING" . 1143002) ("NAME" . 997500) ("SELECT_TARGET" . 997506) ("TRANSFORM" . 1029507) ("UVALUE" . 997508)))
    ("Cleanup" pro "IDLgrMPEG" (system) "Obj -> [%s::]%s" ("objects208.html"))
    ("GetProperty" pro "IDLgrMPEG" (system) "Obj -> [%s::]%s" ("objects209.html" ("ALL" . 1145180)) ("objects210.html" ("BITRATE" . 1145216) ("DIMENSIONS" . 1374264) ("FILENAME" . 1145219) ("FORMAT" . 1145222) ("FRAME_RATE" . 1145227) ("IFRAME_GAP" . 1145238) ("INTERLACED" . 1372668) ("MOTION_VEC_LENGTH" . 1372635) ("QUALITY" . 1372684) ("SCALE" . 1145244) ("STATISTICS" . 1156300)))
    ("Put" pro "IDLgrMPEG" (system) "Obj -> [%s::]%s, Image[, Frame]" ("objects211.html"))
    ("Save" pro "IDLgrMPEG" (system) "Obj -> [%s::]%s" ("objects212.html" ("FILENAME" . 1145291)))
    ("SetProperty" pro "IDLgrMPEG" (system) "Obj -> [%s::]%s" ("objects213.html") ("objects210.html" ("BITRATE" . 1145216) ("DIMENSIONS" . 1374264) ("FILENAME" . 1145219) ("FORMAT" . 1145222) ("FRAME_RATE" . 1145227) ("IFRAME_GAP" . 1145238) ("INTERLACED" . 1372668) ("MOTION_VEC_LENGTH" . 1372635) ("QUALITY" . 1372684) ("SCALE" . 1145244) ("STATISTICS" . 1156300)))
    ("Init" fun "IDLgrMPEG" (system) "Result = Obj -> [%s::]%s()" ("objects210.html" ("BITRATE" . 1145216) ("DIMENSIONS" . 1374264) ("FILENAME" . 1145219) ("FORMAT" . 1145222) ("FRAME_RATE" . 1145227) ("IFRAME_GAP" . 1145238) ("INTERLACED" . 1372668) ("MOTION_VEC_LENGTH" . 1372635) ("QUALITY" . 1372684) ("SCALE" . 1145244) ("STATISTICS" . 1156300) ("TEMP_DIRECTORY" . 1145247)))
    ("Cleanup" pro "IDLgrPalette" (system) "Obj -> [%s::]%s" ("objects215.html"))
    ("GetProperty" pro "IDLgrPalette" (system) "Obj -> [%s::]%s" ("objects217.html" ("ALL" . 997647) ("N_COLORS" . 1048891)) ("objects218.html" ("BLUE_VALUES" . 1049750) ("BOTTOM_STRETCH" . 1049746) ("GAMMA" . 1029564) ("GREEN_VALUES" . 1049766) ("NAME" . 1173731) ("RED_VALUES" . 1049758) ("TOP_STRETCH" . 1029572) ("UVALUE" . 1173754)))
    ("LoadCT" pro "IDLgrPalette" (system) "Obj -> [%s::]%s, TableNum" ("objects219.html" ("FILE" . 1143191) ("FILENAME")))
    ("SetProperty" pro "IDLgrPalette" (system) "Obj -> [%s::]%s" ("objects222.html") ("objects218.html" ("BLUE_VALUES" . 1049750) ("BOTTOM_STRETCH" . 1049746) ("GAMMA" . 1029564) ("GREEN_VALUES" . 1049766) ("NAME" . 1173731) ("RED_VALUES" . 1049758) ("TOP_STRETCH" . 1029572) ("UVALUE" . 1173754)))
    ("SetRGB" pro "IDLgrPalette" (system) "Obj -> [%s::]%s, Index, Red, Green, Blue" ("objects221.html"))
    ("GetRGB" fun "IDLgrPalette" (system) "Result = Obj -> [%s::]%s(Index)" ("objects216.html"))
    ("Init" fun "IDLgrPalette" (system) "Result=Obj-> [%s::]%s(, aRed, aGreen, aBlue)" ("objects218.html" ("BLUE_VALUES" . 1049750) ("BOTTOM_STRETCH" . 1049746) ("GAMMA" . 1029564) ("GREEN_VALUES" . 1049766) ("NAME" . 1173731) ("RED_VALUES" . 1049758) ("TOP_STRETCH" . 1029572) ("UVALUE" . 1173754)))
    ("NearestColor" fun "IDLgrPalette" (system) "Result = Obj-> [%s::]%s(Red, Green, Blue)" ("objects220.html"))
    ("Cleanup" pro "IDLgrPattern" (system) "Obj -> [%s::]%s" ("objects224.html"))
    ("GetProperty" pro "IDLgrPattern" (system) "Obj -> [%s::]%s" ("objects225.html" ("ALL" . 997699)) ("objects226.html" ("NAME" . 1173741) ("ORIENTATION" . 1013039) ("PATTERN" . 1013041) ("SPACING" . 1013043) ("STYLE" . 1049841) ("UVALUE" . 1173761)))
    ("SetProperty" pro "IDLgrPattern" (system) "Obj -> [%s::]%s" ("objects227.html") ("objects226.html" ("NAME" . 1173741) ("ORIENTATION" . 1013039) ("PATTERN" . 1013041) ("SPACING" . 1013043) ("STYLE" . 1049841) ("UVALUE" . 1173761)))
    ("Init" fun "IDLgrPattern" (system) "Result = Obj -> [%s::]%s([, Style])" ("objects226.html" ("NAME" . 1173741) ("ORIENTATION" . 1013039) ("PATTERN" . 1013041) ("SPACING" . 1013043) ("STYLE" . 1049841) ("THICK" . 1025143) ("UVALUE" . 1173761)))
    ("Cleanup" pro "IDLgrPlot" (system) "Obj -> [%s::]%s" ("objects229.html"))
    ("GetProperty" pro "IDLgrPlot" (system) "Obj -> [%s::]%s" ("objects231.html" ("ALL" . 997782) ("DATA" . 1029627) ("PARENT" . 1048928) ("ZRANGE" . 1068611)) ("objects232.html" ("CLIP_PLANES" . 1403306) ("COLOR" . 1403303) ("DOUBLE" . 1371435) ("HIDE" . 1371437) ("HISTOGRAM" . 1025160) ("LINESTYLE" . 1013141) ("MAX_VALUE" . 1013146) ("MIN_VALUE" . 1013148) ("NAME" . 1049038) ("NSUM" . 1013150) ("PALETTE" . 1346617) ("POLAR" . 1013152) ("SYMBOL" . 1013156) ("THICK" . 1013161) ("UVALUE" . 1050030) ("VERT_COLORS" . 1029602) ("XCOORD_CONV" . 1039537) ("XRANGE" . 1058800) ("YCOORD_CONV" . 1039544) ("YRANGE" . 1058812) ("ZCOORD_CONV" . 1058824) ("ZVALUE" . 1058845)))
    ("SetProperty" pro "IDLgrPlot" (system) "Obj -> [%s::]%s" ("objects233.html") ("objects232.html" ("CLIP_PLANES" . 1403306) ("COLOR" . 1403303) ("DATAX" . 1058186) ("DATAY" . 1050022) ("DOUBLE" . 1371435) ("HIDE" . 1371437) ("HISTOGRAM" . 1025160) ("LINESTYLE" . 1013141) ("MAX_VALUE" . 1013146) ("MIN_VALUE" . 1013148) ("NAME" . 1049038) ("NSUM" . 1013150) ("PALETTE" . 1346617) ("POLAR" . 1013152) ("RESET_DATA" . 1060489) ("SHARE_DATA" . 1013154) ("SYMBOL" . 1013156) ("THICK" . 1013161) ("UVALUE" . 1050030) ("VERT_COLORS" . 1029602) ("XCOORD_CONV" . 1039537) ("XRANGE" . 1058800) ("YCOORD_CONV" . 1039544) ("YRANGE" . 1058812) ("ZCOORD_CONV" . 1058824) ("ZVALUE" . 1058845)))
    ("GetCTM" fun "IDLgrPlot" (system) "Result = Obj -> [%s::]%s()" ("objects230.html" ("DESTINATION" . 1038766) ("PATH" . 1328849) ("TOP" . 1047305)))
    ("Init" fun "IDLgrPlot" (system) "Result = Obj -> [%s::]%s([, [X,] Y])" ("objects232.html" ("CLIP_PLANES" . 1403306) ("COLOR" . 1403303) ("DATAX" . 1058186) ("DATAY" . 1050022) ("DOUBLE" . 1371435) ("HIDE" . 1371437) ("HISTOGRAM" . 1025160) ("LINESTYLE" . 1013141) ("MAX_VALUE" . 1013146) ("MIN_VALUE" . 1013148) ("NAME" . 1049038) ("NSUM" . 1013150) ("PALETTE" . 1346617) ("POLAR" . 1013152) ("RESET_DATA" . 1060489) ("SHARE_DATA" . 1013154) ("SYMBOL" . 1013156) ("THICK" . 1013161) ("USE_ZVALUE" . 1013168) ("UVALUE" . 1050030) ("VERT_COLORS" . 1029602) ("XCOORD_CONV" . 1039537) ("XRANGE" . 1058800) ("YCOORD_CONV" . 1039544) ("YRANGE" . 1058812) ("ZCOORD_CONV" . 1058824) ("ZVALUE" . 1058845)))
    ("Cleanup" pro "IDLgrPolygon" (system) "Obj -> [%s::]%s" ("objects235.html"))
    ("GetProperty" pro "IDLgrPolygon" (system) "Obj -> [%s::]%s" ("objects237.html" ("ALL" . 997880) ("PARENT" . 1048933) ("XRANGE" . 1364259) ("YRANGE" . 1039090) ("ZRANGE" . 1039094)) ("objects238.html" ("BOTTOM" . 1013239) ("CLIP_PLANES" . 1403321) ("COLOR" . 1029638) ("DATA" . 1013241) ("DEPTH_OFFSET" . 1386687) ("DOUBLE" . 1371489) ("FILL_PATTERN" . 1371491) ("HIDE" . 1049182) ("LINESTYLE" . 1029670) ("NAME" . 1049043) ("NORMALS" . 1029924) ("POLYGONS" . 1029862) ("REJECT" . 1013248) ("SHADE_RANGE" . 1060480) ("SHADING" . 1050052) ("STYLE" . 1013256) ("TEXTURE_COORD" . 1029981) ("TEXTURE_INTERP" . 1013258) ("TEXTURE_MAP" . 1013260) ("THICK" . 1013262) ("VERT_COLORS" . 1013267) ("XCOORD_CONV" . 1039637) ("YCOORD_CONV" . 1039644) ("ZCOORD_CONV" . 1039651) ("ZERO_OPACITY_SKIP" . 1296140)))
    ("SetProperty" pro "IDLgrPolygon" (system) "Obj -> [%s::]%s" ("objects239.html") ("objects238.html" ("BOTTOM" . 1013239) ("CLIP_PLANES" . 1403321) ("COLOR" . 1029638) ("DATA" . 1013241) ("DEPTH_OFFSET" . 1386687) ("DOUBLE" . 1371489) ("FILL_PATTERN" . 1371491) ("HIDE" . 1049182) ("LINESTYLE" . 1029670) ("NAME" . 1049043) ("NORMALS" . 1029924) ("POLYGONS" . 1029862) ("REJECT" . 1013248) ("RESET_DATA" . 1060483) ("SHADE_RANGE" . 1060480) ("SHADING" . 1050052) ("SHARE_DATA" . 1013254) ("STYLE" . 1013256) ("TEXTURE_COORD" . 1029981) ("TEXTURE_INTERP" . 1013258) ("TEXTURE_MAP" . 1013260) ("THICK" . 1013262) ("VERT_COLORS" . 1013267) ("XCOORD_CONV" . 1039637) ("YCOORD_CONV" . 1039644) ("ZCOORD_CONV" . 1039651) ("ZERO_OPACITY_SKIP" . 1296140)))
    ("GetCTM" fun "IDLgrPolygon" (system) "Result = Obj -> [%s::]%s()" ("objects236.html" ("DESTINATION" . 1038804) ("PATH" . 1328860) ("TOP" . 1047313)))
    ("Init" fun "IDLgrPolygon" (system) "Result = Obj -> [%s::]%s([, X [, Y[, Z]]])" ("objects238.html" ("BOTTOM" . 1013239) ("CLIP_PLANES" . 1403321) ("COLOR" . 1029638) ("DATA" . 1013241) ("DEPTH_OFFSET" . 1386687) ("DOUBLE" . 1371489) ("FILL_PATTERN" . 1371491) ("HIDDEN_LINES" . 1013246) ("HIDE" . 1049182) ("LINESTYLE" . 1029670) ("NAME" . 1049043) ("NORMALS" . 1029924) ("PALETTE" . 1327638) ("POLYGONS" . 1029862) ("REJECT" . 1013248) ("RESET_DATA" . 1060483) ("SHADE_RANGE" . 1060480) ("SHADING" . 1050052) ("SHARE_DATA" . 1013254) ("STYLE" . 1013256) ("TEXTURE_COORD" . 1029981) ("TEXTURE_INTERP" . 1013258) ("TEXTURE_MAP" . 1013260) ("THICK" . 1013262) ("VERT_COLORS" . 1013267) ("XCOORD_CONV" . 1039637) ("YCOORD_CONV" . 1039644) ("ZCOORD_CONV" . 1039651) ("ZERO_OPACITY_SKIP" . 1296140)))
    ("Cleanup" pro "IDLgrPolyline" (system) "Obj -> [%s::]%s" ("objects241.html"))
    ("GetProperty" pro "IDLgrPolyline" (system) "Obj -> [%s::]%s" ("objects243.html" ("ALL" . 1006363) ("PARENT" . 1048938) ("XRANGE" . 1039106) ("YRANGE" . 1039110) ("ZRANGE" . 1039114)) ("objects244.html" ("CLIP_PLANES" . 1403348) ("COLOR" . 1030002) ("DATA" . 1029996) ("DOUBLE" . 1364405) ("HIDE" . 1049191) ("LABEL_NOGAPS" . 1029989) ("LABEL_OBJECTS" . 1436934) ("LABEL_OFFSETS" . 1436920) ("LABEL_POLYLINES" . 1436854) ("LABEL_USE_VERTEX_COLOR" . 1436959) ("LINESTYLE" . 1436955) ("NAME" . 1049048) ("PALETTE" . 1346626) ("POLYLINES" . 1028660) ("SHADING" . 1030029) ("SYMBOL" . 1013305) ("THICK" . 1013310) ("USE_LABEL_COLOR" . 1050064) ("USE_LABEL_ORIENTATION" . 1436997) ("USE_TEXT_ALIGNMENTS" . 1437018) ("UVALUE" . 1437032) ("VERT_COLORS" . 1030043) ("XCOORD_CONV" . 1039714) ("YCOORD_CONV" . 1039721) ("ZCOORD_CONV" . 1039728)))
    ("SetProperty" pro "IDLgrPolyline" (system) "Obj -> [%s::]%s" ("objects245.html") ("objects244.html" ("CLIP_PLANES" . 1403348) ("COLOR" . 1030002) ("DATA" . 1029996) ("DOUBLE" . 1364405) ("HIDE" . 1049191) ("LABEL_NOGAPS" . 1029989) ("LABEL_OBJECTS" . 1436934) ("LABEL_OFFSETS" . 1436920) ("LABEL_POLYLINES" . 1436854) ("LABEL_USE_VERTEX_COLOR" . 1436959) ("LINESTYLE" . 1436955) ("NAME" . 1049048) ("PALETTE" . 1346626) ("POLYLINES" . 1028660) ("RESET_DATA" . 1060465) ("SHADING" . 1030029) ("SHARE_DATA" . 1018260) ("SYMBOL" . 1013305) ("THICK" . 1013310) ("USE_LABEL_COLOR" . 1050064) ("USE_LABEL_ORIENTATION" . 1436997) ("USE_TEXT_ALIGNMENTS" . 1437018) ("UVALUE" . 1437032) ("VERT_COLORS" . 1030043) ("XCOORD_CONV" . 1039714) ("YCOORD_CONV" . 1039721) ("ZCOORD_CONV" . 1039728)))
    ("GetCTM" fun "IDLgrPolyline" (system) "Result = Obj -> [%s::]%s()" ("objects242.html" ("DESTINATION" . 1038842) ("PATH" . 1328867) ("TOP" . 1047321)))
    ("Init" fun "IDLgrPolyline" (system) "Result = Obj -> [%s::]%s([, X [, Y[, Z]]])" ("objects244.html" ("CLIP_PLANES" . 1403348) ("COLOR" . 1030002) ("DATA" . 1029996) ("DOUBLE" . 1364405) ("HIDE" . 1049191) ("LABEL_NOGAPS" . 1029989) ("LABEL_OBJECTS" . 1436934) ("LABEL_OFFSETS" . 1436920) ("LABEL_POLYLINES" . 1436854) ("LABEL_USE_VERTEX_COLOR" . 1436959) ("LINESTYLE" . 1436955) ("NAME" . 1049048) ("PALETTE" . 1346626) ("POLYLINES" . 1028660) ("RESET_DATA" . 1060465) ("SHADING" . 1030029) ("SHARE_DATA" . 1018260) ("SYMBOL" . 1013305) ("THICK" . 1013310) ("USE_LABEL_COLOR" . 1050064) ("USE_LABEL_ORIENTATION" . 1436997) ("USE_TEXT_ALIGNMENTS" . 1437018) ("UVALUE" . 1437032) ("VERT_COLORS" . 1030043) ("XCOORD_CONV" . 1039714) ("YCOORD_CONV" . 1039721) ("ZCOORD_CONV" . 1039728)))
    ("Cleanup" pro "IDLgrPrinter" (system) "Obj -> [%s::]%s" ("objects247.html"))
    ("Draw" pro "IDLgrPrinter" (system) "Obj -> [%s::]%s [, Picture]" ("objects248.html" ("VECTOR" . 1059857)))
    ("GetProperty" pro "IDLgrPrinter" (system) "Obj -> [%s::]%s" ("objects251.html" ("ALL" . 1014221) ("DIMENSIONS" . 1014225) ("NAME" . 1014344) ("RESOLUTION" . 1014350)) ("objects253.html" ("COLOR_MODEL" . 1030161) ("GRAPHICS_TREE" . 1143268) ("LANDSCAPE" . 1060943) ("N_COLORS" . 1018390) ("N_COPIES" . 1014162) ("PALETTE" . 1014164) ("PRINT_QUALITY" . 1068743) ("QUALITY" . 1014175) ("UNITS" . 1173784) ("UVALUE" . 1050248)))
    ("NewDocument" pro "IDLgrPrinter" (system) "Obj -> [%s::]%s" ("objects254.html"))
    ("NewPage" pro "IDLgrPrinter" (system) "Obj -> [%s::]%s" ("objects255.html"))
    ("SetProperty" pro "IDLgrPrinter" (system) "Obj -> [%s::]%s" ("objects256.html") ("objects253.html" ("GRAPHICS_TREE" . 1143268) ("LANDSCAPE" . 1060943) ("N_COPIES" . 1014162) ("PALETTE" . 1014164) ("PRINT_QUALITY" . 1068743) ("QUALITY" . 1014175) ("UNITS" . 1173784) ("UVALUE" . 1050248)))
    ("GetContiguousPixels" fun "IDLgrPrinter" (system) "Return = Obj -> [%s::]%s()" ("objects249.html"))
    ("GetFontnames" fun "IDLgrPrinter" (system) "Return = Obj -> [%s::]%s( FamilyName)" ("objects250.html" ("IDL_FONTS" . 1235902) ("STYLES" . 1235905)))
    ("GetTextDimensions" fun "IDLgrPrinter" (system) "Result = Obj ->[%s::]%s( TextObj)" ("objects252.html" ("DESCENT" . 1155994) ("PATH" . 1295723)))
    ("Init" fun "IDLgrPrinter" (system) "Result = Obj -> [%s::]%s()" ("objects253.html" ("COLOR_MODEL" . 1030161) ("GRAPHICS_TREE" . 1143268) ("LANDSCAPE" . 1060943) ("N_COLORS" . 1018390) ("N_COPIES" . 1014162) ("PALETTE" . 1014164) ("PRINT_QUALITY" . 1068743) ("QUALITY" . 1014175) ("UNITS" . 1173784) ("UVALUE" . 1050248)))
    ("Cleanup" pro "IDLgrROI" (system) "Obj -> [%s::]%s" ("objects258.html"))
    ("GetProperty" pro "IDLgrROI" (system) "Obj -> [%s::]%s" ("objects259.html" ("ALL" . 1368688) ("XRANGE" . 1370629) ("YRANGE" . 1370631) ("ZRANGE" . 1370633)) ("objects260.html" ("CLIP_PLANES" . 1414129) ("COLOR" . 1356254) ("DOUBLE" . 1364930) ("HIDE" . 1356256) ("LINESTYLE" . 1356267) ("NAME" . 1356299) ("PALETTE" . 1356301) ("STYLE" . 1356306) ("SYMBOL" . 1356321) ("THICK" . 1356326) ("UVALUE" . 1356328) ("XCOORD_CONV" . 1356330) ("YCOORD_CONV" . 1356335) ("ZCOORD_CONV" . 1356340)))
    ("SetProperty" pro "IDLgrROI" (system) "Obj -> [%s::]%s" ("objects262.html") ("objects260.html" ("CLIP_PLANES" . 1414129) ("COLOR" . 1356254) ("DOUBLE" . 1364930) ("HIDE" . 1356256) ("LINESTYLE" . 1356267) ("NAME" . 1356299) ("PALETTE" . 1356301) ("STYLE" . 1356306) ("SYMBOL" . 1356321) ("THICK" . 1356326) ("UVALUE" . 1356328) ("XCOORD_CONV" . 1356330) ("YCOORD_CONV" . 1356335) ("ZCOORD_CONV" . 1356340)))
    ("Init" fun "IDLgrROI" (system) "Result = Obj -> [%s::]%s([, X[, Y[, Z]]])" ("objects260.html" ("CLIP_PLANES" . 1414129) ("COLOR" . 1356254) ("DOUBLE" . 1364930) ("HIDE" . 1356256) ("LINESTYLE" . 1356267) ("NAME" . 1356299) ("PALETTE" . 1356301) ("STYLE" . 1356306) ("SYMBOL" . 1356321) ("THICK" . 1356326) ("UVALUE" . 1356328) ("XCOORD_CONV" . 1356330) ("YCOORD_CONV" . 1356335) ("ZCOORD_CONV" . 1356340)))
    ("PickVertex" fun "IDLgrROI" (system) "Result = Obj -> [%s::]%s( Dest, View, Point)" ("objects261.html" ("PATH" . 1356373)))
    ("Add" pro "IDLgrROIGroup" (system) "Obj -> [%s::]%s, ROI" ("objects264.html"))
    ("Cleanup" pro "IDLgrROIGroup" (system) "Obj -> [%s::]%s" ("objects265.html"))
    ("GetProperty" pro "IDLgrROIGroup" (system) "Obj -> [%s::]%s" ("objects266.html" ("ALL" . 1370467) ("PARENT" . 1370518) ("XRANGE" . 1370551) ("YRANGE" . 1370553) ("ZRANGE" . 1370555)) ("objects267.html" ("CLIP_PLANES" . 1414139) ("COLOR" . 1370428) ("HIDE" . 1370422) ("NAME" . 1370405) ("XCOORD_CONV" . 1370380) ("YCOORD_CONV" . 1370386) ("ZCOORD_CONV" . 1370392)))
    ("SetProperty" pro "IDLgrROIGroup" (system) "Obj -> [%s::]%s" ("objects269.html") ("objects267.html" ("CLIP_PLANES" . 1414139) ("COLOR" . 1370428) ("HIDE" . 1370422) ("NAME" . 1370405) ("XCOORD_CONV" . 1370380) ("YCOORD_CONV" . 1370386) ("ZCOORD_CONV" . 1370392)))
    ("Init" fun "IDLgrROIGroup" (system) "Result = Obj -> [%s::]%s()" ("objects267.html" ("CLIP_PLANES" . 1414139) ("COLOR" . 1370428) ("HIDE" . 1370422) ("NAME" . 1370405) ("XCOORD_CONV" . 1370380) ("YCOORD_CONV" . 1370386) ("ZCOORD_CONV" . 1370392)))
    ("PickRegion" fun "IDLgrROIGroup" (system) "Result = Obj -> [%s::]%s( Dest, View, Point)" ("objects268.html" ("PATH" . 1356600)))
    ("Add" pro "IDLgrScene" (system) "Obj -> [%s::]%s, View" ("objects271.html" ("POSITION" . 1069120)))
    ("Cleanup" pro "IDLgrScene" (system) "Obj -> [%s::]%s" ("objects272.html"))
    ("GetProperty" pro "IDLgrScene" (system) "Obj -> [%s::]%s" ("objects274.html" ("ALL" . 1032255)) ("objects275.html" ("COLOR" . 1347046) ("HIDE" . 1032700) ("NAME" . 1143235) ("TRANSPARENT" . 1347048) ("UVALUE" . 1049074)))
    ("SetProperty" pro "IDLgrScene" (system) "Obj -> [%s::]%s" ("objects276.html") ("objects275.html" ("COLOR" . 1347046) ("HIDE" . 1032700) ("NAME" . 1143235) ("TRANSPARENT" . 1347048) ("UVALUE" . 1049074)))
    ("GetByName" fun "IDLgrScene" (system) "Result = Obj -> [%s::]%s(Name)" ("objects273.html"))
    ("Init" fun "IDLgrScene" (system) "Result = Obj -> [%s::]%s()" ("objects275.html" ("COLOR" . 1347046) ("HIDE" . 1032700) ("NAME" . 1143235) ("TRANSPARENT" . 1347048) ("UVALUE" . 1049074)))
    ("Cleanup" pro "IDLgrSurface" (system) "Obj -> [%s::]%s" ("objects278.html"))
    ("GetProperty" pro "IDLgrSurface" (system) "Obj -> [%s::]%s" ("objects280.html" ("ALL" . 1014504) ("DATA" . 1137760) ("PARENT" . 1048953) ("XRANGE" . 1370539) ("YRANGE" . 1370541) ("ZRANGE" . 1370543)) ("objects281.html" ("BOTTOM" . 998396) ("CLIP_PLANES" . 1403361) ("COLOR" . 1039830) ("DEPTH_OFFSET" . 1386706) ("DOUBLE" . 1365021) ("EXTENDED_LEGO" . 1365025) ("HIDDEN_LINES" . 1296205) ("HIDE" . 1049200) ("LINESTYLE" . 1030226) ("MAX_VALUE" . 1365062) ("MIN_VALUE" . 1365064) ("NAME" . 1049054) ("PALETTE" . 1346641) ("SHADE_RANGE" . 1060449) ("SHADING" . 1050392) ("SHOW_SKIRT" . 1050420) ("SKIRT" . 998412) ("STYLE" . 998414) ("TEXTURE_COORD" . 998416) ("TEXTURE_HIGHRES" . 1381109) ("TEXTURE_INTERP" . 998418) ("TEXTURE_MAP" . 998420) ("THICK" . 998422) ("USE_TRIANGLES" . 1296198) ("UVALUE" . 1049079) ("VERT_COLORS" . 1296181) ("XCOORD_CONV" . 1039797) ("YCOORD_CONV" . 1039804) ("ZCOORD_CONV" . 1039811) ("ZERO_OPACITY_SKIP" . 1315860)))
    ("SetProperty" pro "IDLgrSurface" (system) "Obj -> [%s::]%s" ("objects282.html") ("objects281.html" ("BOTTOM" . 998396) ("CLIP_PLANES" . 1403361) ("COLOR" . 1039830) ("DATAX" . 1365015) ("DATAY" . 1365017) ("DATAZ" . 1365019) ("DEPTH_OFFSET" . 1386706) ("DOUBLE" . 1365021) ("EXTENDED_LEGO" . 1365025) ("HIDDEN_LINES" . 1296205) ("HIDE" . 1049200) ("LINESTYLE" . 1030226) ("MAX_VALUE" . 1365062) ("MIN_VALUE" . 1365064) ("NAME" . 1049054) ("PALETTE" . 1346641) ("RESET_DATA" . 998406) ("SHADE_RANGE" . 1060449) ("SHADING" . 1050392) ("SHARE_DATA" . 998408) ("SHOW_SKIRT" . 1050420) ("SKIRT" . 998412) ("STYLE" . 998414) ("TEXTURE_COORD" . 998416) ("TEXTURE_HIGHRES" . 1381109) ("TEXTURE_INTERP" . 998418) ("TEXTURE_MAP" . 998420) ("THICK" . 998422) ("USE_TRIANGLES" . 1296198) ("UVALUE" . 1049079) ("VERT_COLORS" . 1296181) ("XCOORD_CONV" . 1039797) ("YCOORD_CONV" . 1039804) ("ZCOORD_CONV" . 1039811) ("ZERO_OPACITY_SKIP" . 1315860)))
    ("GetCTM" fun "IDLgrSurface" (system) "Result = Obj -> [%s::]%s()" ("objects279.html" ("DESTINATION" . 1038883) ("PATH" . 1328874) ("TOP" . 1047329)))
    ("Init" fun "IDLgrSurface" (system) "Result = Obj -> [%s::]%s([, Z [, X, Y]])" ("objects281.html" ("BOTTOM" . 998396) ("CLIP_PLANES" . 1403361) ("COLOR" . 1039830) ("DATAX" . 1365015) ("DATAY" . 1365017) ("DATAZ" . 1365019) ("DEPTH_OFFSET" . 1386706) ("DOUBLE" . 1365021) ("EXTENDED_LEGO" . 1365025) ("HIDDEN_LINES" . 1296205) ("HIDE" . 1049200) ("LINESTYLE" . 1030226) ("MAX_VALUE" . 1365062) ("MIN_VALUE" . 1365064) ("NAME" . 1049054) ("PALETTE" . 1346641) ("RESET_DATA" . 998406) ("SHADE_RANGE" . 1060449) ("SHADING" . 1050392) ("SHARE_DATA" . 998408) ("SHOW_SKIRT" . 1050420) ("SKIRT" . 998412) ("STYLE" . 998414) ("TEXTURE_COORD" . 998416) ("TEXTURE_HIGHRES" . 1381109) ("TEXTURE_INTERP" . 998418) ("TEXTURE_MAP" . 998420) ("THICK" . 998422) ("USE_TRIANGLES" . 1296198) ("UVALUE" . 1049079) ("VERT_COLORS" . 1296181) ("XCOORD_CONV" . 1039797) ("YCOORD_CONV" . 1039804) ("ZCOORD_CONV" . 1039811) ("ZERO_OPACITY_SKIP" . 1315860)))
    ("Cleanup" pro "IDLgrSymbol" (system) "Obj -> [%s::]%s" ("objects284.html"))
    ("GetProperty" pro "IDLgrSymbol" (system) "Obj -> [%s::]%s" ("objects285.html" ("ALL" . 1014532)) ("objects286.html" ("COLOR" . 998454) ("DATA" . 998456) ("NAME" . 1173747) ("SIZE" . 998458) ("THICK" . 998462) ("UVALUE" . 1049084)))
    ("SetProperty" pro "IDLgrSymbol" (system) "Obj -> [%s::]%s" ("objects287.html") ("objects286.html" ("COLOR" . 998454) ("DATA" . 998456) ("NAME" . 1173747) ("SIZE" . 998458) ("THICK" . 998462) ("UVALUE" . 1049084)))
    ("Init" fun "IDLgrSymbol" (system) "Result = Obj -> [%s::]%s([, Data])" ("objects286.html" ("COLOR" . 998454) ("DATA" . 998456) ("NAME" . 1173747) ("SIZE" . 998458) ("THICK" . 998462) ("UVALUE" . 1049084)))
    ("AddPolygon" pro "IDLgrTessellator" (system) "Obj -> [%s::]%s, X [, Y[, Z]]" ("objects289.html" ("AUXDATA" . 1395268) ("INTERIOR" . 1033500) ("POLYGON" . 1395265)))
    ("Cleanup" pro "IDLgrTessellator" (system) "Obj -> [%s::]%s" ("objects290.html"))
    ("Reset" pro "IDLgrTessellator" (system) "Obj -> [%s::]%s" ("objects292.html"))
    ("Init" fun "IDLgrTessellator" (system) "Result = Obj -> [%s::]%s()" ("objects291.html"))
    ("Tessellate" fun "IDLgrTessellator" (system) "Result = Obj -> [%s::]%s( Vertices, Poly)" ("objects293.html" ("AUXDATA" . 1395296) ("QUIET" . 1395293)))
    ("Cleanup" pro "IDLgrText" (system) "Obj -> [%s::]%s" ("objects295.html"))
    ("GetProperty" pro "IDLgrText" (system) "Obj -> [%s::]%s" ("objects297.html" ("ALL" . 1014560) ("PARENT" . 1050476) ("XRANGE" . 1060544) ("YRANGE" . 1166470) ("ZRANGE" . 1039174)) ("objects298.html" ("ALIGNMENT" . 998494) ("BASELINE" . 998496) ("CHAR_DIMENSIONS" . 1061001) ("CLIP_PLANES" . 1403374) ("COLOR" . 1039917) ("ENABLE_FORMATTING" . 1143278) ("FONT" . 998500) ("HIDE" . 1049209) ("LOCATIONS" . 1050518) ("NAME" . 1049059) ("ONGLASS" . 1050487) ("PALETTE" . 1346652) ("RECOMPUTE_DIMENSIONS" . 1143284) ("STRINGS" . 1050506) ("UPDIR" . 998504) ("UVALUE" . 1049100) ("VERTICAL_ALIGNMENT" . 1143292) ("XCOORD_CONV" . 1039884) ("YCOORD_CONV" . 1039891) ("ZCOORD_CONV" . 1039898)))
    ("SetProperty" pro "IDLgrText" (system) "Obj -> [%s::]%s" ("objects299.html") ("objects298.html" ("ALIGNMENT" . 998494) ("BASELINE" . 998496) ("CHAR_DIMENSIONS" . 1061001) ("CLIP_PLANES" . 1403374) ("COLOR" . 1039917) ("ENABLE_FORMATTING" . 1143278) ("FONT" . 998500) ("HIDE" . 1049209) ("LOCATIONS" . 1050518) ("NAME" . 1049059) ("ONGLASS" . 1050487) ("PALETTE" . 1346652) ("RECOMPUTE_DIMENSIONS" . 1143284) ("STRINGS" . 1050506) ("UPDIR" . 998504) ("UVALUE" . 1049100) ("VERTICAL_ALIGNMENT" . 1143292) ("XCOORD_CONV" . 1039884) ("YCOORD_CONV" . 1039891) ("ZCOORD_CONV" . 1039898)))
    ("GetCTM" fun "IDLgrText" (system) "Result = Obj -> [%s::]%s()" ("objects296.html" ("DESTINATION" . 1038925) ("PATH" . 1328881) ("TOP" . 1047337)))
    ("Init" fun "IDLgrText" (system) "Result = Obj -> [%s::]%s([, String or vector of strings])" ("objects298.html" ("ALIGNMENT" . 998494) ("BASELINE" . 998496) ("CHAR_DIMENSIONS" . 1061001) ("CLIP_PLANES" . 1403374) ("COLOR" . 1039917) ("ENABLE_FORMATTING" . 1143278) ("FONT" . 998500) ("HIDE" . 1049209) ("LOCATIONS" . 1050518) ("NAME" . 1049059) ("ONGLASS" . 1050487) ("PALETTE" . 1346652) ("RECOMPUTE_DIMENSIONS" . 1143284) ("STRINGS" . 1050506) ("UPDIR" . 998504) ("UVALUE" . 1049100) ("VERTICAL_ALIGNMENT" . 1143292) ("XCOORD_CONV" . 1039884) ("YCOORD_CONV" . 1039891) ("ZCOORD_CONV" . 1039898)))
    ("Add" pro "IDLgrView" (system) "Obj -> [%s::]%s, Model" ("objects301.html" ("POSITION" . 1069127)))
    ("Cleanup" pro "IDLgrView" (system) "Obj -> [%s::]%s" ("objects302.html"))
    ("GetProperty" pro "IDLgrView" (system) "Obj -> [%s::]%s" ("objects304.html" ("ALL" . 1015279) ("PARENT" . 1048974)) ("objects305.html" ("COLOR" . 1025300) ("DEPTH_CUE" . 1346822) ("DIMENSIONS" . 1030414) ("DOUBLE" . 1365152) ("EYE" . 1015302) ("LOCATION" . 1030408) ("PROJECTION" . 1015306) ("TRANSPARENT" . 1021485) ("UNITS" . 1030411) ("UVALUE" . 1049105) ("VIEWPLANE_RECT" . 1025384) ("ZCLIP" . 1025386)))
    ("SetProperty" pro "IDLgrView" (system) "Obj -> [%s::]%s" ("objects306.html") ("objects305.html" ("COLOR" . 1025300) ("DEPTH_CUE" . 1346822) ("DIMENSIONS" . 1030414) ("DOUBLE" . 1365152) ("EYE" . 1015302) ("LOCATION" . 1030408) ("PROJECTION" . 1015306) ("TRANSPARENT" . 1021485) ("UNITS" . 1030411) ("UVALUE" . 1049105) ("VIEWPLANE_RECT" . 1025384) ("ZCLIP" . 1025386)))
    ("GetByName" fun "IDLgrView" (system) "Result = Obj -> [%s::]%s(Name)" ("objects303.html"))
    ("Init" fun "IDLgrView" (system) "Result = Obj -> [%s::]%s()" ("objects305.html" ("COLOR" . 1025300) ("DEPTH_CUE" . 1346822) ("DIMENSIONS" . 1030414) ("DOUBLE" . 1365152) ("EYE" . 1015302) ("LOCATION" . 1030408) ("PROJECTION" . 1015306) ("TRANSPARENT" . 1021485) ("UNITS" . 1030411) ("UVALUE" . 1049105) ("VIEWPLANE_RECT" . 1025384) ("ZCLIP" . 1025386)))
    ("Add" pro "IDLgrViewgroup" (system) "Obj -> [%s::]%s, Object" ("objects308.html" ("POSITION" . 1145444)))
    ("Cleanup" pro "IDLgrViewgroup" (system) "Obj -> [%s::]%s" ("objects309.html"))
    ("GetProperty" pro "IDLgrViewgroup" (system) "Obj -> [%s::]%s" ("objects311.html" ("ALL" . 1145581) ("PARENT" . 1145584)) ("objects312.html" ("HIDE" . 1145620) ("NAME" . 1145625) ("UVALUE" . 1145628)))
    ("SetProperty" pro "IDLgrViewgroup" (system) "Obj -> [%s::]%s" ("objects313.html") ("objects312.html" ("HIDE" . 1145620) ("NAME" . 1145625) ("UVALUE" . 1145628)))
    ("GetByName" fun "IDLgrViewgroup" (system) "Result = Obj -> [%s::]%s(Name)" ("objects310.html"))
    ("Init" fun "IDLgrViewgroup" (system) "Result = Obj -> [%s::]%s()" ("objects312.html" ("HIDE" . 1145620) ("NAME" . 1145625) ("UVALUE" . 1145628)))
    ("Cleanup" pro "IDLgrVolume" (system) "Obj -> [%s::]%s" ("objects315.html"))
    ("ComputeBounds" pro "IDLgrVolume" (system) "Obj -> [%s::]%s" ("objects316.html" ("OPACITY" . 1019319) ("RESET" . 1019346) ("VOLUMES" . 1143333)))
    ("GetProperty" pro "IDLgrVolume" (system) "Obj -> [%s::]%s" ("objects318.html" ("ALL" . 1014641) ("PARENT" . 1048982) ("VALID_DATA" . 1143339) ("XRANGE" . 1039183) ("YRANGE" . 1039187) ("ZRANGE" . 1039191)) ("objects319.html" ("AMBIENT" . 998577) ("BOUNDS" . 1018886) ("CLIP_PLANES" . 1403387) ("COMPOSITE_FUNCTION" . 1019037) ("CUTTING_PLANES" . 1019037) ("DATA0" . 1018964) ("DATA1" . 1143320) ("DATA2" . 1319526) ("DATA3" . 1319532) ("DEPTH_CUE" . 1018965) ("HIDE" . 1296707) ("HINTS" . 1296713) ("INTERPOLATE" . 1296696) ("LIGHTING_MODEL" . 998581) ("NAME" . 1049064) ("NO_COPY" . 1019143) ("OPACITY_TABLE0" . 1019150) ("OPACITY_TABLE1" . 1143326) ("RENDER_STEP" . 998583) ("RGB_TABLE0" . 1019175) ("RGB_TABLE1" . 1183194) ("TWO_SIDED" . 1019165) ("UVALUE" . 1049119) ("VOLUME_SELECT" . 1143312) ("XCOORD_CONV" . 1039970) ("YCOORD_CONV" . 1039977) ("ZBUFFER" . 1040040) ("ZCOORD_CONV" . 1366902) ("ZERO_OPACITY_SKIP" . 1040034)))
    ("SetProperty" pro "IDLgrVolume" (system) "Obj -> [%s::]%s" ("objects321.html") ("objects319.html" ("AMBIENT" . 998577) ("BOUNDS" . 1018886) ("CLIP_PLANES" . 1403387) ("COMPOSITE_FUNCTION" . 1019037) ("CUTTING_PLANES" . 1019037) ("DATA0" . 1018964) ("DATA1" . 1143320) ("DATA2" . 1319526) ("DATA3" . 1319532) ("DEPTH_CUE" . 1018965) ("HIDE" . 1296707) ("HINTS" . 1296713) ("INTERPOLATE" . 1296696) ("LIGHTING_MODEL" . 998581) ("NAME" . 1049064) ("NO_COPY" . 1019143) ("OPACITY_TABLE0" . 1019150) ("OPACITY_TABLE1" . 1143326) ("RENDER_STEP" . 998583) ("RGB_TABLE0" . 1019175) ("RGB_TABLE1" . 1183194) ("TWO_SIDED" . 1019165) ("UVALUE" . 1049119) ("VOLUME_SELECT" . 1143312) ("XCOORD_CONV" . 1039970) ("YCOORD_CONV" . 1039977) ("ZBUFFER" . 1040040) ("ZCOORD_CONV" . 1366902) ("ZERO_OPACITY_SKIP" . 1040034)))
    ("GetCTM" fun "IDLgrVolume" (system) "Result = Obj -> [%s::]%s()" ("objects317.html" ("DESTINATION" . 1038991) ("PATH" . 1328888) ("TOP" . 1047345)))
    ("Init" fun "IDLgrVolume" (system) "Result = Obj -> [%s::]%s([, vol0 [, vol1 [, vol2 [, vol3]]]])" ("objects319.html" ("AMBIENT" . 998577) ("BOUNDS" . 1018886) ("CLIP_PLANES" . 1403387) ("COMPOSITE_FUNCTION" . 1019037) ("CUTTING_PLANES" . 1019037) ("DATA0" . 1018964) ("DATA1" . 1143320) ("DATA2" . 1319526) ("DATA3" . 1319532) ("DEPTH_CUE" . 1018965) ("HIDE" . 1296707) ("HINTS" . 1296713) ("INTERPOLATE" . 1296696) ("LIGHTING_MODEL" . 998581) ("NAME" . 1049064) ("NO_COPY" . 1019143) ("OPACITY_TABLE0" . 1019150) ("OPACITY_TABLE1" . 1143326) ("RENDER_STEP" . 998583) ("RGB_TABLE0" . 1019175) ("RGB_TABLE1" . 1183194) ("TWO_SIDED" . 1019165) ("UVALUE" . 1049119) ("VOLUME_SELECT" . 1143312) ("XCOORD_CONV" . 1039970) ("YCOORD_CONV" . 1039977) ("ZBUFFER" . 1040040) ("ZCOORD_CONV" . 1366902) ("ZERO_OPACITY_SKIP" . 1040034)))
    ("PickVoxel" fun "IDLgrVolume" (system) "Result = Obj -> [%s::]%s ( Win, View, Point)" ("objects320.html" ("PATH" . 1295672)))
    ("Cleanup" pro "IDLgrVRML" (system) "Obj -> [%s::]%s" ("objects323.html"))
    ("Draw" pro "IDLgrVRML" (system) "Obj -> [%s::]%s [, Picture]" ("objects324.html"))
    ("GetDeviceInfo" pro "IDLgrVRML" (system) "Obj -> [%s::]%s" ("objects325.html" ("ALL" . 1354892) ("MAX_NUM_CLIP_PLANES" . 1403459) ("MAX_TEXTURE_DIMENSIONS" . 1354894) ("MAX_VIEWPORT_DIMENSIONS" . 1354896) ("NAME" . 1354898) ("NUM_CPUS" . 1354900) ("VENDOR" . 1354903) ("VERSION" . 1354905)))
    ("GetProperty" pro "IDLgrVRML" (system) "Obj -> [%s::]%s" ("objects327.html" ("ALL" . 1145916) ("SCREEN_DIMENSIONS" . 1347804)) ("objects329.html" ("COLOR_MODEL" . 1145971) ("DIMENSIONS" . 1145976) ("FILENAME" . 1145980) ("GRAPHICS_TREE" . 1156018) ("N_COLORS" . 1145983) ("PALETTE" . 1145986) ("QUALITY" . 1145989) ("RESOLUTION" . 1145995) ("UNITS" . 1145999) ("UVALUE" . 1146006)))
    ("SetProperty" pro "IDLgrVRML" (system) "Obj -> [%s::]%s" ("objects330.html") ("objects329.html" ("DIMENSIONS" . 1145976) ("FILENAME" . 1145980) ("GRAPHICS_TREE" . 1156018) ("PALETTE" . 1145986) ("QUALITY" . 1145989) ("RESOLUTION" . 1145995) ("UNITS" . 1145999) ("UVALUE" . 1146006)))
    ("GetFontnames" fun "IDLgrVRML" (system) "Return = Obj ->[%s::]%s( FamilyName)" ("objects326.html" ("IDL_FONTS" . 1236154) ("STYLES" . 1236157)))
    ("GetTextDimensions" fun "IDLgrVRML" (system) "Result = Obj ->[%s::]%s( TextObj)" ("objects328.html" ("DESCENT" . 1156003) ("PATH" . 1295771)))
    ("Init" fun "IDLgrVRML" (system) "Result = Obj -> [%s::]%s()" ("objects329.html" ("COLOR_MODEL" . 1145971) ("DIMENSIONS" . 1145976) ("FILENAME" . 1145980) ("GRAPHICS_TREE" . 1156018) ("N_COLORS" . 1145983) ("PALETTE" . 1145986) ("QUALITY" . 1145989) ("RESOLUTION" . 1145995) ("UNITS" . 1145999) ("UVALUE" . 1146006) ("WORLDINFO" . 1146009) ("WORLDTITLE" . 1146012)))
    ("Cleanup" pro "IDLgrWindow" (system) "Obj -> [%s::]%s" ("objects332.html"))
    ("Draw" pro "IDLgrWindow" (system) "Obj -> [%s::]%s [, Picture]" ("objects333.html" ("CREATE_INSTANCE" . 1143359) ("DRAW_INSTANCE" . 1030595)))
    ("Erase" pro "IDLgrWindow" (system) "Obj -> [%s::]%s" ("objects334.html" ("COLOR" . 1025735)))
    ("GetDeviceInfo" pro "IDLgrWindow" (system) "Obj -> [%s::]%s" ("objects336.html" ("ALL" . 1354933) ("MAX_NUM_CLIP_PLANES" . 1403470) ("MAX_TEXTURE_DIMENSIONS" . 1354935) ("MAX_VIEWPORT_DIMENSIONS" . 1354937) ("NAME" . 1354939) ("NUM_CPUS" . 1354941) ("VENDOR" . 1354944) ("VERSION" . 1354946)))
    ("GetProperty" pro "IDLgrWindow" (system) "Obj -> [%s::]%s" ("objects338.html" ("ALL" . 1015047) ("IMAGE_DATA" . 1015169) ("RESOLUTION" . 1030634) ("SCREEN_DIMENSIONS" . 1015171) ("ZBUFFER_DATA" . 1347818)))
    ("Iconify" pro "IDLgrWindow" (system) "Obj -> [%s::]%s, IconFlag" ("objects340.html"))
    ("SetCurrentCursor" pro "IDLgrWindow" (system) "Obj-> [%s::]%s [, CursorName]" ("objects345.html" ("HOTSPOT" . 1026029) ("IMAGE" . 1025981) ("MASK" . 1026018) ("STANDARD" . 1060384)))
    ("SetProperty" pro "IDLgrWindow" (system) "Obj -> [%s::]%s" ("objects346.html"))
    ("Show" pro "IDLgrWindow" (system) "Obj -> [%s::]%s, Position" ("objects347.html"))
    ("GetContiguousPixels" fun "IDLgrWindow" (system) "Return = Obj -> [%s::]%s()" ("objects335.html"))
    ("GetFontnames" fun "IDLgrWindow" (system) "Return = Obj -> [%s::]%s(FamilyName)" ("objects337.html" ("IDL_FONTS" . 1236010) ("STYLES" . 1236013)))
    ("GetTextDimensions" fun "IDLgrWindow" (system) "Result = Obj ->[%s::]%s( TextObj)" ("objects339.html" ("DESCENT" . 1143244) ("PATH" . 1295729)))
    ("PickData" fun "IDLgrWindow" (system) "Result = Obj -> [%s::]%s( View, Object, Location, XYZLocation)" ("objects342.html" ("DIMENSIONS" . 1386751) ("PATH" . 1296024) ("PICK_STATUS" . 1414067)))
    ("Read" fun "IDLgrWindow" (system) "Result = Obj -> [%s::]%s()" ("objects343.html"))
    ("Select" fun "IDLgrWindow" (system) "Result = Obj -> [%s::]%s( Picture, XY)" ("objects344.html" ("DIMENSIONS" . 1014776) ("UNITS" . 1014780)))
    ("Reset" pro "TrackBall" (system) "Obj -> [%s::]%s, Center, Radius" ("objects350.html" ("AXIS" . 1164884) ("CONSTRAIN" . 1164890) ("MOUSE" . 1164893)))
    ("Init" fun "TrackBall" (system) "Result = Obj -> [%s::]%s(, Center, Radius)" ("objects349.html" ("AXIS" . 1164854) ("CONSTRAIN" . 1164860) ("MOUSE" . 1164863)))
    ("Update" fun "TrackBall" (system) "Result = Obj -> [%s::]%s( sEvent)" ("objects351.html" ("MOUSE" . 1164912) ("TRANSFORM" . 1164915) ("TRANSLATE" . 1164918)))
   )
  "1460 builtin routines with 6586 keywords for IDL version 5.6.")

(setq idlwave-system-variables-alist
  '(
    ("C" (link "sysvars7.html#997337"))
    ("CPU" (tags ("HW_VECTOR") ("VECTOR_ENABLE") ("HW_NCPU") ("TPOOL_NTHREADS") ("TPOOL_MIN_ELTS") ("TPOOL_MAX_ELTS")) (link "sysvars6.html#1014201"))
    ("D" (tags ("NAME" . 997486) ("X_SIZE" . 997529) ("Y_SIZE" . 997529) ("X_VSIZE" . 997534) ("Y_VSIZE" . 997534) ("X_CH_SIZE" . 997518) ("Y_CH_SIZE" . 997518) ("X_PX_CM" . 997524) ("Y_PX_CM" . 997524) ("N_COLORS" . 997482) ("TABLE_SIZE" . 997494) ("FILL_DIST" . 997350) ("WINDOW" . 997514) ("UNIT" . 1008156) ("FLAGS" . 997354) ("ORIGIN" . 997490) ("ZOOM" . 997538)) (link "sysvars7.html#997347"))
    ("DIR" (link "sysvars6.html#997072"))
    ("DLM_PATH" (link "sysvars6.html#1004032"))
    ("DPI" (link "sysvars4.html#996942"))
    ("DTOR" (link "sysvars4.html#996946"))
    ("EDIT_INPUT" (link "sysvars6.html#1004047"))
    ("ERROR_STATE" (tags ("NAME") ("BLOCK") ("CODE") ("SYS_CODE") ("SYS_CODE_TYPE") ("MSG") ("SYS_MSG") ("MSG_PREFIX")) (link "sysvars5.html#1003013"))
    ("EXCEPT" (link "sysvars5.html#1002623"))
    ("HELP_PATH" (link "sysvars6.html#1000204"))
    ("JOURNAL" (link "sysvars6.html#997085"))
    ("MAKE_DLL" (tags ("COMPILE_DIRECTORY") ("COMPILER_NAME") ("CC") ("LD")) (link "sysvars6.html#1009307"))
    ("MAP" (tags ("PROJECTION") ("SIMPLE") ("FILL_METHOD") ("UP_FLAGS") ("UP_NAME") ("P0LON") ("P0LAT") ("U0") ("V0") ("SINO") ("COSO") ("ROTATION") ("SINR") ("COSR") ("A") ("E2") ("UV") ("POLE") ("UV_BOX") ("LL_BOX") ("SEGMENT_LENGTH") ("P") ("PIPELINE")) (link "sysvars4.html#996950"))
    ("MORE" (link "sysvars6.html#997090"))
    ("MOUSE" (tags ("X") ("Y") ("BUTTON") ("TIME")) (link "sysvars5.html#1000051"))
    ("ORDER" (link "sysvars7.html#997544"))
    ("P" (tags ("BACKGROUND" . 997554) ("CHARSIZE" . 997560) ("CHARTHICK" . 997563) ("CLIP" . 997566) ("COLOR" . 997569) ("FONT" . 997572) ("LINESTYLE" . 997575) ("MULTI" . 1004014) ("NOCLIP" . 997613) ("NOERASE" . 997616) ("NSUM" . 997619) ("POSITION" . 1006945) ("PSYM" . 997627) ("REGION" . 997633) ("SUBTITLE" . 997636) ("SYMSIZE") ("T" . 997639) ("T3D" . 997642) ("THICK" . 997645) ("TITLE" . 997648) ("TICKLEN" . 997651) ("CHANNEL" . 997557)) (link "sysvars7.html#997551"))
    ("PATH" (link "sysvars6.html#997094"))
    ("PI" (link "sysvars4.html#996954"))
    ("PROMPT" (link "sysvars6.html#997101"))
    ("QUIET" (link "sysvars6.html#997106"))
    ("RADEG" (link "sysvars4.html#996958"))
    ("VALUES" (tags ("F_INFINITY") ("F_NAN") ("D_INFINITY") ("D_NAN")) (link "sysvars4.html#996962"))
    ("VERSION" (tags ("ARCH") ("OS") ("OS_FAMILY") ("OS_NAME") ("RELEASE") ("BUILD_DATE") ("MEMORY_BITS") ("FILE_OFFSET_BITS")) (link "sysvars6.html#997111"))
    ("WARN" (tags ("OBS_ROUTINES") ("OBS_SYSVARS") ("PARENS")) (link "sysvars5.html#1000387"))
    ("X" (tags ("TITLE" . 997839) ("TYPE" . 997842) ("STYLE" . 997742) ("TICKS" . 999577) ("TICKLEN" . 1012793) ("THICK" . 997798) ("RANGE" . 997713) ("CRANGE" . 997670) ("S" . 997736) ("MARGIN" . 997689) ("OMARGIN" . 997702) ("WINDOW" . 997845) ("REGION" . 997724) ("CHARSIZE" . 1012787) ("MINOR" . 997699) ("TICKV" . 997833) ("TICKNAME" . 997811) ("GRIDSTYLE" . 998134) ("TICKFORMAT" . 997801) ("TICKINTERVAL" . 997808) ("TICKLAYOUT" . 1012924) ("TICKUNITS" . 1012962)) (link "sysvars7.html#997657"))
    ("Y" (tags ("TITLE" . 997839) ("TYPE" . 997842) ("STYLE" . 997742) ("TICKS" . 999577) ("TICKLEN" . 1012793) ("THICK" . 997798) ("RANGE" . 997713) ("CRANGE" . 997670) ("S" . 997736) ("MARGIN" . 997689) ("OMARGIN" . 997702) ("WINDOW" . 997845) ("REGION" . 997724) ("CHARSIZE" . 1012787) ("MINOR" . 997699) ("TICKV" . 997833) ("TICKNAME" . 997811) ("GRIDSTYLE" . 998134) ("TICKFORMAT" . 997801) ("TICKINTERVAL" . 997808) ("TICKLAYOUT" . 1012924) ("TICKUNITS" . 1012962)) (link "sysvars7.html#997657"))
    ("Z" (tags ("TITLE" . 997839) ("TYPE" . 997842) ("STYLE" . 997742) ("TICKS" . 999577) ("TICKLEN" . 1012793) ("THICK" . 997798) ("RANGE" . 997713) ("CRANGE" . 997670) ("S" . 997736) ("MARGIN" . 997689) ("OMARGIN" . 997702) ("WINDOW" . 997845) ("REGION" . 997724) ("CHARSIZE" . 1012787) ("MINOR" . 997699) ("TICKV" . 997833) ("TICKNAME" . 997811) ("GRIDSTYLE" . 998134) ("TICKFORMAT" . 997801) ("TICKINTERVAL" . 997808) ("TICKLAYOUT" . 1012924) ("TICKUNITS" . 1012962)) (link "sysvars7.html#997657"))))


(setq idlwave-system-class-info
  '(
    ("IDLgrContour" (tags "IDLITCOMPONENT_TOP" "IDLITCOMPONENTVERSION" "DESCRIPTION" "NAME" "ICON_TYPE" "IDENTIFIER" "UVALUE" "_PARENT" "PROPERTYDESCRIPTORS" "IDLITCOMPONENT_BOTTOM" "IDLGRCOMPONENT_TOP" "IDLGRCOMPONENTVERSION" "HIDE" "PARENT" "IDLGRCOMPONENT_BOTTOM" "IDLGRGRAPHIC_TOP" "IDLGRGRAPHICVERSION" "CLIP_PLANES" "COLOR" "GRAPHICFLAGS" "PALETTE" "XCOORD_CONV" "YCOORD_CONV" "ZCOORD_CONV" "XRANGE" "YRANGE" "ZRANGE" "GRAPHIC_DATA_OBJECT" "IDLGRGRAPHIC_BOTTOM" "IDLGRCONTOUR_TOP" "IDLGRCONTOURVERSION" "AM_PM" "ANISOTROPY" "DATA_FORMAT" "DATA" "DAYS_OF_WEEK" "GEOM_FORMAT" "GEOM" "CONTOURFLAGS" "C_COLOR" "C_FILLPATTERN" "C_LABEL_INTERVAL" "C_LABEL_NOGAPS" "C_LABEL_OBJECTS" "C_LABEL_SHOW" "C_LINESTYLE" "C_THICK" "C_USE_LABEL_COLOR" "C_USE_LABEL_ORIENTATION" "C_VALUE" "LABEL_DEFAULTS" "LABEL_FONT" "LABEL_FORMAT" "LABEL_FRMTDATA" "LABEL_UNITS" "LABEL_UNIT_CODE" "MAXVAL" "MINVAL" "MONTHS" "NLEVELS" "POLYGONS" "SHADERANGE" "SHADING" "TICKINTERVAL" "TICKLEN" "PRECISIONDATA" "PRECISIONGEOM" "PRECISIONGRAPH" "LEVELINFO" "CFILL1" "DEPTHOFFSET" "IDLGRCONTOUR_BOTTOM") (link "objects163.html"))
    ("IDLgrAxis" (tags "IDLITCOMPONENT_TOP" "IDLITCOMPONENTVERSION" "DESCRIPTION" "NAME" "ICON_TYPE" "IDENTIFIER" "UVALUE" "_PARENT" "PROPERTYDESCRIPTORS" "IDLITCOMPONENT_BOTTOM" "IDLGRCOMPONENT_TOP" "IDLGRCOMPONENTVERSION" "HIDE" "PARENT" "IDLGRCOMPONENT_BOTTOM" "IDLGRGRAPHIC_TOP" "IDLGRGRAPHICVERSION" "CLIP_PLANES" "COLOR" "GRAPHICFLAGS" "PALETTE" "XCOORD_CONV" "YCOORD_CONV" "ZCOORD_CONV" "XRANGE" "YRANGE" "ZRANGE" "GRAPHIC_DATA_OBJECT" "IDLGRGRAPHIC_BOTTOM" "IDLGRAXIS_TOP" "IDLGRAXISVERSION" "AM_PM" "AXIS_TYPE" "CALCFLAGS" "DAYS_OF_WEEK" "DIRECTION" "AXISFLAGS" "GRIDSTYLE" "LOCATION" "MAJOR" "MINOR" "MONTHS" "OUTRANGE" "RANGE" "SUBTICKLEN" "TEXTALIGNMENTS" "TEXTBASELINE" "TEXTUPDIR" "THICK" "TICKDIR" "TICKFORMAT" "ARRAY_TICKFORMAT" "TICKFRMTDATA" "TICKINTERVAL" "TICKLAYOUT" "TICKLEN" "TICKTEXT" "TICKUNITCODES" "TICKUNITS" "TICKVALUES" "TITLE" "CURRENT_LEVEL" "LEVEL_DATA" "STEPRANGEUNITS" "STEPRANGE" "IDLGRAXIS_BOTTOM") (link "objects127.html"))
    ("IDLgrLegend" (tags "OSCALENODE" "BORDER_GAP" "COLUMNS" "OOUTLINE" "OFILL" "OFONT" "GAP" "GLYPHWIDTH" "PITEM_COLOR" "PITEM_LINESTYLE" "PITEM_NAME" "PITEM_OBJECT" "PITEM_THICK" "PITEM_TYPE" "OTITLE" "PTEXT_COLOR" "BRECOMPUTE" "PGLYPHS" "PTEXTS" "HGLYPHWIDTH" "VGLYPHWIDTH" "COLORMODE" "CLEANLEAVE" "CLEANGLYPHS" "IDLGRLEGENDVERSION") (inherits "IDLgrModel") (link "objects182.html"))
    ("IDLgrROI" (tags "IDLITCOMPONENT_TOP" "IDLITCOMPONENTVERSION" "DESCRIPTION" "NAME" "ICON_TYPE" "IDENTIFIER" "UVALUE" "_PARENT" "PROPERTYDESCRIPTORS" "IDLITCOMPONENT_BOTTOM" "IDLGRCOMPONENT_TOP" "IDLGRCOMPONENTVERSION" "HIDE" "PARENT" "IDLGRCOMPONENT_BOTTOM" "IDLGRGRAPHIC_TOP" "IDLGRGRAPHICVERSION" "CLIP_PLANES" "COLOR" "GRAPHICFLAGS" "PALETTE" "XCOORD_CONV" "YCOORD_CONV" "ZCOORD_CONV" "XRANGE" "YRANGE" "ZRANGE" "GRAPHIC_DATA_OBJECT" "IDLGRGRAPHIC_BOTTOM" "IDLGRROI_TOP" "IDLGRROIVERSION" "LINESTYLE" "STYLE" "SYMBOL" "THICK" "IDLGRROI_BOTTOM") (inherits "IDLanROI") (link "objects257.html"))
    ("IDLgrPolyline" (tags "IDLITCOMPONENT_TOP" "IDLITCOMPONENTVERSION" "DESCRIPTION" "NAME" "ICON_TYPE" "IDENTIFIER" "UVALUE" "_PARENT" "PROPERTYDESCRIPTORS" "IDLITCOMPONENT_BOTTOM" "IDLGRCOMPONENT_TOP" "IDLGRCOMPONENTVERSION" "HIDE" "PARENT" "IDLGRCOMPONENT_BOTTOM" "IDLGRGRAPHIC_TOP" "IDLGRGRAPHICVERSION" "CLIP_PLANES" "COLOR" "GRAPHICFLAGS" "PALETTE" "XCOORD_CONV" "YCOORD_CONV" "ZCOORD_CONV" "XRANGE" "YRANGE" "ZRANGE" "GRAPHIC_DATA_OBJECT" "IDLGRGRAPHIC_BOTTOM" "IDLGRPOLYLINE_TOP" "IDLGRPOLYLINEVERSION" "POLYLINEFLAGS" "DATA" "PRECISION" "LABEL_NOGAPS" "LABEL_OBJECTS" "LABEL_OFFSETS" "LABEL_POLYLINES" "LINESTYLE" "POLYLINES" "SYMBOL" "PSYMBOL" "THICK" "SHADING" "USE_LABEL_COLOR" "USE_LABEL_ORIENTATION" "VERTCOLORS" "LABEL_INFO" "FILL1" "IDLGRPOLYLINE_BOTTOM") (link "objects240.html"))
    ("IDLgrSurface" (tags "IDLITCOMPONENT_TOP" "IDLITCOMPONENTVERSION" "DESCRIPTION" "NAME" "ICON_TYPE" "IDENTIFIER" "UVALUE" "_PARENT" "PROPERTYDESCRIPTORS" "IDLITCOMPONENT_BOTTOM" "IDLGRCOMPONENT_TOP" "IDLGRCOMPONENTVERSION" "HIDE" "PARENT" "IDLGRCOMPONENT_BOTTOM" "IDLGRGRAPHIC_TOP" "IDLGRGRAPHICVERSION" "CLIP_PLANES" "COLOR" "GRAPHICFLAGS" "PALETTE" "XCOORD_CONV" "YCOORD_CONV" "ZCOORD_CONV" "XRANGE" "YRANGE" "ZRANGE" "GRAPHIC_DATA_OBJECT" "IDLGRGRAPHIC_BOTTOM" "IDLGRSURFACE_TOP" "IDLGRSURFACEVERSION" "DATA" "PRECISION" "SKIRT" "VERTCOLORS" "BTMCOLOR" "SURFACEFLAGS" "LINESTYLE" "MAXVALUE" "MINVALUE" "SHADING" "SHADERANGE" "STYLE" "NORMALS" "TXTRCOORD" "TXTRMAP" "THICK" "DEPTHOFFSET" "IDLGRSURFACE_BOTTOM") (link "objects277.html"))
    ("IDLgrPolygon" (tags "IDLITCOMPONENT_TOP" "IDLITCOMPONENTVERSION" "DESCRIPTION" "NAME" "ICON_TYPE" "IDENTIFIER" "UVALUE" "_PARENT" "PROPERTYDESCRIPTORS" "IDLITCOMPONENT_BOTTOM" "IDLGRCOMPONENT_TOP" "IDLGRCOMPONENTVERSION" "HIDE" "PARENT" "IDLGRCOMPONENT_BOTTOM" "IDLGRGRAPHIC_TOP" "IDLGRGRAPHICVERSION" "CLIP_PLANES" "COLOR" "GRAPHICFLAGS" "PALETTE" "XCOORD_CONV" "YCOORD_CONV" "ZCOORD_CONV" "XRANGE" "YRANGE" "ZRANGE" "GRAPHIC_DATA_OBJECT" "IDLGRGRAPHIC_BOTTOM" "IDLGRPOLYGON_TOP" "IDLGRPOLYGONVERSION" "DATA" "PRECISION" "FILLPATTERN" "POLYGONS" "NORMALS" "POLYGONFLAGS" "SHADING" "SHADERANGE" "STYLE" "TXTRCOORD" "TXTRMAP" "VERTCOLORS" "BTMCOLOR" "LINESTYLE" "THICK" "DEPTHOFFSET" "IDLGRPOLYGON_BOTTOM") (link "objects234.html"))
    ("IDLgrWindow" (tags "IDLITCOMPONENT_TOP" "IDLITCOMPONENTVERSION" "DESCRIPTION" "NAME" "ICON_TYPE" "IDENTIFIER" "UVALUE" "_PARENT" "PROPERTYDESCRIPTORS" "IDLITCOMPONENT_BOTTOM" "IDLGRSRCDEST_TOP" "IDLGRSRCDESTVERSION" "CLIENTDIMENSIONS" "COLORMODEL" "SRCDESTFLAGS" "GRAPHICS_TREE" "NCOLORS" "PALETTE" "QUALITY" "RESOLUTION" "DIST" "FILL1" "DEV" "FILL2" "ATTRS" "FILL3" "CACHES" "FILL4" "IDLGRSRCDEST_BOTTOM" "IDLGRWINDOW_TOP" "IDLGRWINDOWVERSION" "WINDOWFLAGS" "DIMENSIONS" "DISPLAYNAME" "INDEX" "LOCATION" "RENDERER" "RETAIN" "SCREENDIMENSIONS" "SELF" "TITLE" "UNITS" "NEXT" "WFILL1" "PARENT" "WFILL2" "IDLGRWINDOW_BOTTOM") (link "objects331.html"))
    ("IDLgrVolume" (tags "IDLITCOMPONENT_TOP" "IDLITCOMPONENTVERSION" "DESCRIPTION" "NAME" "ICON_TYPE" "IDENTIFIER" "UVALUE" "_PARENT" "PROPERTYDESCRIPTORS" "IDLITCOMPONENT_BOTTOM" "IDLGRCOMPONENT_TOP" "IDLGRCOMPONENTVERSION" "HIDE" "PARENT" "IDLGRCOMPONENT_BOTTOM" "IDLGRGRAPHIC_TOP" "IDLGRGRAPHICVERSION" "CLIP_PLANES" "COLOR" "GRAPHICFLAGS" "PALETTE" "XCOORD_CONV" "YCOORD_CONV" "ZCOORD_CONV" "XRANGE" "YRANGE" "ZRANGE" "GRAPHIC_DATA_OBJECT" "IDLGRGRAPHIC_BOTTOM" "IDLGRVOLUME_TOP" "IDLGRVOLUMEVERSION" "AMBIENT" "BOUNDS" "LIMITS" "DIMENSIONS" "COLORTABLE" "COMPOSITEFUNC" "CUTPLANES" "NUMCUTPLANES" "DEPTH_CUE" "OPACITYTABLE" "RENDERSTEP" "DATA" "EDM_VOLUME" "VOLUMEFLAGS" "IDLGRVOLUME_BOTTOM") (link "objects314.html"))
    ("IDLgrPlot" (tags "IDLITCOMPONENT_TOP" "IDLITCOMPONENTVERSION" "DESCRIPTION" "NAME" "ICON_TYPE" "IDENTIFIER" "UVALUE" "_PARENT" "PROPERTYDESCRIPTORS" "IDLITCOMPONENT_BOTTOM" "IDLGRCOMPONENT_TOP" "IDLGRCOMPONENTVERSION" "HIDE" "PARENT" "IDLGRCOMPONENT_BOTTOM" "IDLGRGRAPHIC_TOP" "IDLGRGRAPHICVERSION" "CLIP_PLANES" "COLOR" "GRAPHICFLAGS" "PALETTE" "XCOORD_CONV" "YCOORD_CONV" "ZCOORD_CONV" "XRANGE" "YRANGE" "ZRANGE" "GRAPHIC_DATA_OBJECT" "IDLGRGRAPHIC_BOTTOM" "IDLGRPLOT_TOP" "IDLGRPLOTVERSION" "DATA" "PLOTFLAGS" "LINESTYLE" "PRECISION" "MAXVAL" "MINVAL" "NSUM" "SYMBOL" "PSYMBOL" "THICK" "VERTCOLORS" "ZVALUE" "LINEDATA" "PFILL1" "IDLGRPLOT_BOTTOM") (link "objects228.html"))
    ("IDLgrROIGroup" (tags "IDLITCOMPONENT_TOP" "IDLITCOMPONENTVERSION" "DESCRIPTION" "NAME" "ICON_TYPE" "IDENTIFIER" "UVALUE" "_PARENT" "PROPERTYDESCRIPTORS" "IDLITCOMPONENT_BOTTOM" "IDLGRCOMPONENT_TOP" "IDLGRCOMPONENTVERSION" "HIDE" "PARENT" "IDLGRCOMPONENT_BOTTOM" "IDLGRGRAPHIC_TOP" "IDLGRGRAPHICVERSION" "CLIP_PLANES" "COLOR" "GRAPHICFLAGS" "PALETTE" "XCOORD_CONV" "YCOORD_CONV" "ZCOORD_CONV" "XRANGE" "YRANGE" "ZRANGE" "GRAPHIC_DATA_OBJECT" "IDLGRGRAPHIC_BOTTOM" "IDLGRROIGROUP_TOP" "IDLGRROIGROUPVERSION" "IDLGRROIGROUP_BOTTOM") (inherits "IDLanROIGroup") (link "objects263.html"))
    ("IDLgrText" (tags "IDLITCOMPONENT_TOP" "IDLITCOMPONENTVERSION" "DESCRIPTION" "NAME" "ICON_TYPE" "IDENTIFIER" "UVALUE" "_PARENT" "PROPERTYDESCRIPTORS" "IDLITCOMPONENT_BOTTOM" "IDLGRCOMPONENT_TOP" "IDLGRCOMPONENTVERSION" "HIDE" "PARENT" "IDLGRCOMPONENT_BOTTOM" "IDLGRGRAPHIC_TOP" "IDLGRGRAPHICVERSION" "CLIP_PLANES" "COLOR" "GRAPHICFLAGS" "PALETTE" "XCOORD_CONV" "YCOORD_CONV" "ZCOORD_CONV" "XRANGE" "YRANGE" "ZRANGE" "GRAPHIC_DATA_OBJECT" "IDLGRGRAPHIC_BOTTOM" "IDLGRTEXT_TOP" "IDLGRTEXTVERSION" "TEXTFLAGS" "ALIGNMENT" "BASELINE" "CHAR_DIMENSIONS" "RECOMP_CTM" "FONT" "LOCATIONS" "STRINGS" "SUBPARENT" "UPDIR" "VERTICAL_ALIGNMENT" "IDLGRTEXT_BOTTOM") (link "objects294.html"))
    ("IDLgrColorbar" (tags "OCOORDCONVNODE" "OSCALENODE" "MAXDIM" "DIMENSIONS" "OAXIS" "OPOLY" "OSURF" "OIMAGE" "OPALETTE" "FREE_PALETTE" "SHOW_AXIS" "IDLGRCOLORBARVERSION") (inherits "IDLgrModel") (link "objects157.html"))
    ("IDLgrImage" (tags "IDLITCOMPONENT_TOP" "IDLITCOMPONENTVERSION" "DESCRIPTION" "NAME" "ICON_TYPE" "IDENTIFIER" "UVALUE" "_PARENT" "PROPERTYDESCRIPTORS" "IDLITCOMPONENT_BOTTOM" "IDLGRCOMPONENT_TOP" "IDLGRCOMPONENTVERSION" "HIDE" "PARENT" "IDLGRCOMPONENT_BOTTOM" "IDLGRGRAPHIC_TOP" "IDLGRGRAPHICVERSION" "CLIP_PLANES" "COLOR" "GRAPHICFLAGS" "PALETTE" "XCOORD_CONV" "YCOORD_CONV" "ZCOORD_CONV" "XRANGE" "YRANGE" "ZRANGE" "GRAPHIC_DATA_OBJECT" "IDLGRGRAPHIC_BOTTOM" "IDLGRIMAGE_TOP" "IDLGRIMAGEVERSION" "CHANNEL" "DATA" "DIMENSIONS" "SUB_RECT" "IMAGEFLAGS" "LOCATION" "INTERLEAVE" "INTERPOLATE" "BLEND_FUNCTIONS" "IDLGRIMAGE_BOTTOM") (link "objects176.html"))
    ("IDLgrView" (tags "IDLITCOMPONENT_TOP" "IDLITCOMPONENTVERSION" "DESCRIPTION" "NAME" "ICON_TYPE" "IDENTIFIER" "UVALUE" "_PARENT" "PROPERTYDESCRIPTORS" "IDLITCOMPONENT_BOTTOM" "IDLGRCOMPONENT_TOP" "IDLGRCOMPONENTVERSION" "HIDE" "PARENT" "IDLGRCOMPONENT_BOTTOM" "IDLGRCONTAINER_TOP" "IDLGRCONTAINERVERSION" "ISDYING" "IDLGRCONTAINER_BOTTOM" "IDLGRVIEW_TOP" "IDLGRVIEWVERSION" "COLOR" "DEPTH_CUE" "DIMENSIONS" "PRECISION" "EYE" "LOCATION" "OBLIQUE" "PROJECTION" "TRANSPARENT" "UNITS" "VIEW" "ZCLIP" "IDLGRVIEW_BOTTOM") (inherits "IDL_Container") (link "objects300.html"))
    ("IDLgrLight" (tags "IDLITCOMPONENT_TOP" "IDLITCOMPONENTVERSION" "DESCRIPTION" "NAME" "ICON_TYPE" "IDENTIFIER" "UVALUE" "_PARENT" "PROPERTYDESCRIPTORS" "IDLITCOMPONENT_BOTTOM" "IDLGRCOMPONENT_TOP" "IDLGRCOMPONENTVERSION" "HIDE" "PARENT" "IDLGRCOMPONENT_BOTTOM" "IDLGRGRAPHIC_TOP" "IDLGRGRAPHICVERSION" "CLIP_PLANES" "COLOR" "GRAPHICFLAGS" "PALETTE" "XCOORD_CONV" "YCOORD_CONV" "ZCOORD_CONV" "XRANGE" "YRANGE" "ZRANGE" "GRAPHIC_DATA_OBJECT" "IDLGRGRAPHIC_BOTTOM" "IDLGRLIGHT_TOP" "IDLGRLIGHTVERSION" "ATTENUATION" "CONEANGLE" "DIRECTION" "FOCUS" "INTENSITY" "LOCATION" "TYPE" "IDLGRLIGHT_BOTTOM") (link "objects188.html"))
    ("IDLgrClipboard" (tags "IDLITCOMPONENT_TOP" "IDLITCOMPONENTVERSION" "DESCRIPTION" "NAME" "ICON_TYPE" "IDENTIFIER" "UVALUE" "_PARENT" "PROPERTYDESCRIPTORS" "IDLITCOMPONENT_BOTTOM" "IDLGRSRCDEST_TOP" "IDLGRSRCDESTVERSION" "CLIENTDIMENSIONS" "COLORMODEL" "SRCDESTFLAGS" "GRAPHICS_TREE" "NCOLORS" "PALETTE" "QUALITY" "RESOLUTION" "DIST" "FILL1" "DEV" "FILL2" "ATTRS" "FILL3" "CACHES" "FILL4" "IDLGRSRCDEST_BOTTOM" "IDLGRCLIPBOARD_TOP" "IDLGRCLIPBOARDVERSION" "UNITS" "DIMENSIONS" "FILENAME" "VECTOR" "POSTSCRIPT" "IDLGRCLIPBOARD_BOTTOM") (link "objects147.html"))
    ("IDLgrVRML" (tags "IDLITCOMPONENT_TOP" "IDLITCOMPONENTVERSION" "DESCRIPTION" "NAME" "ICON_TYPE" "IDENTIFIER" "UVALUE" "_PARENT" "PROPERTYDESCRIPTORS" "IDLITCOMPONENT_BOTTOM" "IDLGRSRCDEST_TOP" "IDLGRSRCDESTVERSION" "CLIENTDIMENSIONS" "COLORMODEL" "SRCDESTFLAGS" "GRAPHICS_TREE" "NCOLORS" "PALETTE" "QUALITY" "RESOLUTION" "DIST" "FILL1" "DEV" "FILL2" "ATTRS" "FILL3" "CACHES" "FILL4" "IDLGRSRCDEST_BOTTOM" "IDLGRVRML_TOP" "IDLGRVRMLVERSION" "UNITS" "DIMENSIONS" "FILENAME" "WORLDINFO" "WORLDTITLE" "IDLGRVRML_BOTTOM") (link "objects322.html"))
    ("IDLgrPrinter" (tags "IDLITCOMPONENT_TOP" "IDLITCOMPONENTVERSION" "DESCRIPTION" "NAME" "ICON_TYPE" "IDENTIFIER" "UVALUE" "_PARENT" "PROPERTYDESCRIPTORS" "IDLITCOMPONENT_BOTTOM" "IDLGRSRCDEST_TOP" "IDLGRSRCDESTVERSION" "CLIENTDIMENSIONS" "COLORMODEL" "SRCDESTFLAGS" "GRAPHICS_TREE" "NCOLORS" "PALETTE" "QUALITY" "RESOLUTION" "DIST" "FILL1" "DEV" "FILL2" "ATTRS" "FILL3" "CACHES" "FILL4" "IDLGRSRCDEST_BOTTOM" "IDLGRPRINTER_TOP" "IDLGRPRINTERVERSION" "PRINTERFLAGS" "NCOPIES" "UNITS" "GAMMA" "IDLGRPRINTER_BOTTOM") (link "objects246.html"))
    ("IDLgrBuffer" (tags "IDLITCOMPONENT_TOP" "IDLITCOMPONENTVERSION" "DESCRIPTION" "NAME" "ICON_TYPE" "IDENTIFIER" "UVALUE" "_PARENT" "PROPERTYDESCRIPTORS" "IDLITCOMPONENT_BOTTOM" "IDLGRSRCDEST_TOP" "IDLGRSRCDESTVERSION" "CLIENTDIMENSIONS" "COLORMODEL" "SRCDESTFLAGS" "GRAPHICS_TREE" "NCOLORS" "PALETTE" "QUALITY" "RESOLUTION" "DIST" "FILL1" "DEV" "FILL2" "ATTRS" "FILL3" "CACHES" "FILL4" "IDLGRSRCDEST_BOTTOM" "IDLGRBUFFER_TOP" "IDLGRBUFFERVERSION" "UNITS" "DIMENSIONS" "IDLGRBUFFER_BOTTOM") (link "objects133.html"))
    ("IDLgrModel" (tags "IDLITCOMPONENT_TOP" "IDLITCOMPONENTVERSION" "DESCRIPTION" "NAME" "ICON_TYPE" "IDENTIFIER" "UVALUE" "_PARENT" "PROPERTYDESCRIPTORS" "IDLITCOMPONENT_BOTTOM" "IDLGRCOMPONENT_TOP" "IDLGRCOMPONENTVERSION" "HIDE" "PARENT" "IDLGRCOMPONENT_BOTTOM" "IDLGRCONTAINER_TOP" "IDLGRCONTAINERVERSION" "ISDYING" "IDLGRCONTAINER_BOTTOM" "IDLGRMODEL_TOP" "IDLGRMODELVERSION" "MODELFLAGS" "CLIP_PLANES" "TRANSFORM" "IDLGRMODEL_BOTTOM") (inherits "IDL_Container") (link "objects194.html"))
    ("IDLgrScene" (tags "IDLITCOMPONENT_TOP" "IDLITCOMPONENTVERSION" "DESCRIPTION" "NAME" "ICON_TYPE" "IDENTIFIER" "UVALUE" "_PARENT" "PROPERTYDESCRIPTORS" "IDLITCOMPONENT_BOTTOM" "IDLGRCOMPONENT_TOP" "IDLGRCOMPONENTVERSION" "HIDE" "PARENT" "IDLGRCOMPONENT_BOTTOM" "IDLGRCONTAINER_TOP" "IDLGRCONTAINERVERSION" "ISDYING" "IDLGRCONTAINER_BOTTOM" "IDLGRSCENE_TOP" "IDLGRSCENEVERSION" "COLOR" "TRANSPARENT" "IDLGRSCENE_BOTTOM") (inherits "IDL_Container") (link "objects270.html"))
    ("IDLgrViewgroup" (tags "IDLITCOMPONENT_TOP" "IDLITCOMPONENTVERSION" "DESCRIPTION" "NAME" "ICON_TYPE" "IDENTIFIER" "UVALUE" "_PARENT" "PROPERTYDESCRIPTORS" "IDLITCOMPONENT_BOTTOM" "IDLGRCOMPONENT_TOP" "IDLGRCOMPONENTVERSION" "HIDE" "PARENT" "IDLGRCOMPONENT_BOTTOM" "IDLGRCONTAINER_TOP" "IDLGRCONTAINERVERSION" "ISDYING" "IDLGRCONTAINER_BOTTOM" "IDLGRVIEWGROUP_TOP" "IDLGRVIEWGROUPVERSION" "IDLGRVIEWGROUP_BOTTOM") (inherits "IDL_Container") (link "objects307.html"))
    ("IDLgrMPEG" (tags "IDLGRMPEG_TOP" "IDLGRMPEGVERSION" "DIMENSIONS" "FILENAME" "FORMAT" "FRAMERATE" "INTERLACED" "QUALITY" "SCALE" "STATISTICS" "DISPLAYDIMS" "FIRSTFRAME" "LASTFRAME" "MPEGID" "TEMPNODE" "TEMPNODEFILLER" "TEMP_DIRECTORY" "BITRATE" "IFRAME_GAP" "MOTION_LENGTH" "FLAGS" "IDLGRMPEG_BOTTOM") (link "objects207.html"))
    ("IDLdbRecordset" (tags "IDLDBRECORDSET_TOP" "IDLDBRECORDSETVERSION" "ISTABLE" "PDBOBJ" "ISREADONLY" "NFIELDS" "CURROW" "SOURCE" "CURSORTYPE" "PFIELDS" "PSDEF" "ROWSTATUS" "ROWSET" "ROWPOS" "HSTMT" "HDBC" "IDLDBRECORDSET_BOTTOM") (link "api10.html"))
    ("IDLdbDatabase" (tags "IDLDBDATABASE_TOP" "IDLDBDATABASEVERSION" "READONLY" "ISCONNECTED" "FETCHDIR" "POSOPS" "POSSTATEMENTS" "SCROLLCONCUR" "SCROLLOPTIONS" "STATICSENSE" "GETDATAEXT" "USINGCURSOR" "NSTATEMENTS" "P_RECOBJS" "HDBC" "IDLDBDATABASE_BOTTOM") (link "api3.html"))
    ("IDLanROI" (tags "IDLANROI_TOP" "IDLANROIVERSION" "IDLANROIFLAGS" "NALLOCVERTS" "NUSEDVERTS" "BLOCKSIZE" "DATA" "TYPE" "PRECISION" "PLANE" "ROI_XRANGE" "ROI_YRANGE" "ROI_ZRANGE" "IDLANROI_BOTTOM") (link "objects13.html"))
    ("IDLanROIGroup" (tags "IDLANROIGROUP_TOP" "IDLANROIGROUPVERSION" "IDLANROIGROUPFLAGS" "ROIGROUP_XRANGE" "ROIGROUP_YRANGE" "ROIGROUP_ZRANGE" "IDLANROIGROUP_BOTTOM") (inherits "IDL_Container") (link "objects27.html"))
    ("IDLgrPalette" (tags "IDLGRPALETTE_TOP" "IDLGRPALETTE_SERIALNUM" "IDLGRPALETTEVERSION" "GAMMA" "BOTTOMSTRETCH" "TOPSTRETCH" "NENTRIES" "ORIGLUT" "CURRLUT" "INVTABLE" "UVALUE" "NAME" "IDLGRPALETTE_BOTTOM") (link "objects214.html"))
    ("IDLgrFont" (tags "IDLGRFONT_TOP" "IDLGRFONTVERSION" "FONTFLAGS" "HERSHEY" "NAME" "SIZE" "SUBSTITUTE" "THICK" "ID" "UVALUE" "IDLGRFONT_BOTTOM") (link "objects171.html"))
    ("IDLgrPattern" (tags "IDLGRPATTERN_TOP" "IDLGRPATTERNVERSION" "ORIENTATION" "PATTERN" "SPACING" "STYLE" "THICK" "UVALUE" "NAME" "IDLGRPATTERN_BOTTOM") (link "objects223.html"))
    ("IDLgrSymbol" (tags "IDLGRSYMBOL_TOP" "IDLGRSYMBOLVERSION" "COLOR" "DATA" "SIZE" "THICK" "FLAGS" "UVALUE" "NAME" "IDLGRSYMBOL_BOTTOM") (link "objects283.html"))
    ("IDLffDXF" (tags "IDLFFDXF_TOP" "IDLFFDXFVERSION" "DXFREADVALID" "DXFHANDLEVALID" "DXFLUT" "SERIAL" "DXFHANDLE" "DXFHANDLEFILLER" "IDLFFDXF_BOTTOM") (link "objects60.html"))
    ("IDLffShape" (tags "IDLFFSHAPE_TOP" "IDLFFSHAPEVERSION" "FILENAME" "ISOPEN" "SHPTYPE" "PATTRIBUTE" "SHAPEHANDLE" "DBFHANDLE" "IDLFFSHAPE_BOTTOM") (link "objects82.html"))
    ("IDLffXMLSAX" (tags "IDLFFXMLSAX_TOP" "IDLFFXMLSAXVERSION" "VALIDATION_MODE" "HALT_PROCESSING" "FILENAME" "_XML_PARSER" "_XML_LOCATOR" "IDLFFXMLSAX_BOTTOM") (link "objects94.html"))
    ("IDLgrTessellator" (tags "IDLGRTESSELLATOR_TOP" "IDLGRTESSELLATORVERSION" "ITESSFLAGS" "IVERTS" "HVIDLIST" "IAUXSIZE" "IAUXTYPE" "IDLGRTESSELLATOR_BOTTOM") (link "objects288.html"))
    ("IDLffDICOM" (tags "IDLFFDICOM_TOP" "IDLFFDICOMVERSION" "DICOMFLAGS" "DICOMELEMENTS" "DICOMPREAMBLE" "DICOMHANDLE" "DICOMHANDLEFILLER" "IDLFFDICOM_BOTTOM") (link "objects43.html"))
    ("TrackBall" (tags "BTNDOWN" "AXIS" "CONSTRAIN" "MOUSE" "CENTER" "RADIUS" "PT0" "PT1") (link "objects348.html"))
    ("IDL_Container" (tags "IDL_CONTAINER_TOP" "IDLCONTAINERVERSION" "PHEAD" "PTAIL" "NLIST" "IDL_CONTAINER_BOTTOM") (link "objects4.html"))
    ("IDLffMrSID" (link "objects76.html"))
    ("IDLffLanguageCat" (link "objects72.html"))
    ("IDLcomIDispatch" (link "objects39.html"))))


(setq idlwave-executive-commands-alist '(
    (".SKIP" . "symbols11.html")
    (".STEP" . "symbols12.html")
    (".RNEW" . "symbols9.html")
    (".EDIT" . "symbols3.html")
    (".RETURN" . "symbols8.html")
    (".CONTINUE" . "symbols2.html")
    (".COMPILE" . "symbols.html")
    (".TRACE" . "symbols14.html")
    (".OUT" . "symbols6.html")
    (".GO" . "symbols5.html")
    (".RUN" . "symbols10.html")
    (".STEPOVER" . "symbols13.html")
))

;; Special words with associated help topic files
(defconst idlwave-help-special-topic-words
  '(
    ("begin" . "B2.html")
    ("case" . "C8.html")
    ("endcase" . "C8.html")
    ("of" . "C8.html")
    ("common" . "C27.html")
    ("compile_opt" . "C28.html")
    ("continue" . "C37.html")
    ("endfor" . "F30.html")
    ("for" . "F30.html")
    ("else" . "I3.html")
    ("endelse" . "I3.html")
    ("endif" . "I3.html")
    ("if" . "I3.html")
    ("then" . "I3.html")
    ("end" . "P27.html")
    ("pro" . "P27.html")
    ("endrep" . "R39.html")
    ("repeat" . "R39.html")
    ("until" . "R39.html")
    ("return" . "R46.html")
    ("endswitch" . "S79.html")
    ("switch" . "S79.html")
    ("do" . "W7.html")
    ("endwhile" . "W7.html")
    ("while" . "W7.html")
)
  "Association list of help files for special context words.")

(provide 'idlw-rinfo)
(provide 'idlwave-rinfo)

;;; idlw-rinfo.el ends here
