<?php

declare(strict_types=1);

/*
 * Copyright (c) 2017-2022 François Kooman <fkooman@tuxed.net>
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

namespace fkooman\SeCookie;

use DateInterval;

class SessionOptions
{
    public const SESSION_EXPIRY_DEFAULT = 'PT30M';
    private string $sessionName = 'SID';
    private DateInterval $expiresIn;

    public function __construct()
    {
        $this->expiresIn = new DateInterval(self::SESSION_EXPIRY_DEFAULT);
    }

    public static function init(): self
    {
        return new self();
    }

    public function withName(string $sessionName): self
    {
        $objCopy = clone $this;
        $objCopy->sessionName = $sessionName;

        return $objCopy;
    }

    public function getName(): string
    {
        return $this->sessionName;
    }

    public function withExpiresIn(DateInterval $expiresIn): self
    {
        $objCopy = clone $this;
        $objCopy->expiresIn = $expiresIn;

        return $objCopy;
    }

    public function getExpiresIn(): DateInterval
    {
        return $this->expiresIn;
    }
}
