/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt;

import com.hivemq.client.internal.mqtt.MqttAsyncClient;
import com.hivemq.client.internal.mqtt.MqttClientConfig;
import com.hivemq.client.internal.mqtt.MqttRxClient;
import com.hivemq.client.internal.mqtt.exceptions.MqttClientStateExceptions;
import com.hivemq.client.internal.mqtt.message.connect.MqttConnect;
import com.hivemq.client.internal.mqtt.message.connect.MqttConnectBuilder;
import com.hivemq.client.internal.mqtt.message.disconnect.MqttDisconnect;
import com.hivemq.client.internal.mqtt.message.disconnect.MqttDisconnectBuilder;
import com.hivemq.client.internal.mqtt.message.publish.MqttPublish;
import com.hivemq.client.internal.mqtt.message.publish.MqttPublishBuilder;
import com.hivemq.client.internal.mqtt.message.subscribe.MqttSubscribe;
import com.hivemq.client.internal.mqtt.message.subscribe.MqttSubscribeBuilder;
import com.hivemq.client.internal.mqtt.message.unsubscribe.MqttUnsubscribe;
import com.hivemq.client.internal.mqtt.message.unsubscribe.MqttUnsubscribeBuilder;
import com.hivemq.client.internal.mqtt.util.MqttChecks;
import com.hivemq.client.internal.util.AsyncRuntimeException;
import com.hivemq.client.internal.util.Checks;
import com.hivemq.client.internal.util.collections.NodeList;
import com.hivemq.client.mqtt.MqttGlobalPublishFilter;
import com.hivemq.client.mqtt.mqtt5.Mqtt5BlockingClient;
import com.hivemq.client.mqtt.mqtt5.exceptions.Mqtt5SubAckException;
import com.hivemq.client.mqtt.mqtt5.exceptions.Mqtt5UnsubAckException;
import com.hivemq.client.mqtt.mqtt5.message.Mqtt5ReasonCode;
import com.hivemq.client.mqtt.mqtt5.message.connect.Mqtt5Connect;
import com.hivemq.client.mqtt.mqtt5.message.connect.connack.Mqtt5ConnAck;
import com.hivemq.client.mqtt.mqtt5.message.disconnect.Mqtt5Disconnect;
import com.hivemq.client.mqtt.mqtt5.message.publish.Mqtt5Publish;
import com.hivemq.client.mqtt.mqtt5.message.publish.Mqtt5PublishResult;
import com.hivemq.client.mqtt.mqtt5.message.subscribe.Mqtt5Subscribe;
import com.hivemq.client.mqtt.mqtt5.message.subscribe.suback.Mqtt5SubAck;
import com.hivemq.client.mqtt.mqtt5.message.unsubscribe.Mqtt5Unsubscribe;
import com.hivemq.client.mqtt.mqtt5.message.unsubscribe.unsuback.Mqtt5UnsubAck;
import io.reactivex.Flowable;
import io.reactivex.FlowableSubscriber;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import java.util.Optional;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.reactivestreams.Subscription;

public class MqttBlockingClient
implements Mqtt5BlockingClient {
    @NotNull
    private final MqttRxClient delegate;

    @NotNull
    static Mqtt5SubAck handleSubAck(@NotNull Mqtt5SubAck subAck) {
        for (Mqtt5ReasonCode mqtt5ReasonCode : subAck.getReasonCodes()) {
            if (!mqtt5ReasonCode.isError()) continue;
            throw new Mqtt5SubAckException(subAck, "SUBACK contains at least one error code.");
        }
        return subAck;
    }

    @NotNull
    static Mqtt5UnsubAck handleUnsubAck(@NotNull Mqtt5UnsubAck unsubAck) {
        for (Mqtt5ReasonCode mqtt5ReasonCode : unsubAck.getReasonCodes()) {
            if (!mqtt5ReasonCode.isError()) continue;
            throw new Mqtt5UnsubAckException(unsubAck, "UNSUBACK contains at least one error code.");
        }
        return unsubAck;
    }

    MqttBlockingClient(@NotNull MqttRxClient delegate) {
        this.delegate = delegate;
    }

    @Override
    @NotNull
    public Mqtt5ConnAck connect() {
        return this.connect(MqttConnect.DEFAULT);
    }

    @Override
    @NotNull
    public Mqtt5ConnAck connect(@Nullable Mqtt5Connect connect) {
        MqttConnect mqttConnect = MqttChecks.connect(connect);
        try {
            return (Mqtt5ConnAck)this.delegate.connectUnsafe(mqttConnect).blockingGet();
        }
        catch (RuntimeException e) {
            throw AsyncRuntimeException.fillInStackTrace(e);
        }
    }

    public  @NotNull MqttConnectBuilder.Send<Mqtt5ConnAck> connectWith() {
        return new MqttConnectBuilder.Send<Mqtt5ConnAck>(this::connect);
    }

    @Override
    @NotNull
    public Mqtt5SubAck subscribe(@Nullable Mqtt5Subscribe subscribe) {
        MqttSubscribe mqttSubscribe = MqttChecks.subscribe(subscribe);
        try {
            if (!this.getState().isConnectedOrReconnect()) {
                throw MqttClientStateExceptions.notConnected();
            }
            return MqttBlockingClient.handleSubAck((Mqtt5SubAck)this.delegate.subscribeUnsafe(mqttSubscribe).blockingGet());
        }
        catch (RuntimeException e) {
            throw AsyncRuntimeException.fillInStackTrace(e);
        }
    }

    public  @NotNull MqttSubscribeBuilder.Send<Mqtt5SubAck> subscribeWith() {
        return new MqttSubscribeBuilder.Send<Mqtt5SubAck>(this::subscribe);
    }

    @Override
    @NotNull
    public Mqtt5BlockingClient.Mqtt5Publishes publishes(@Nullable MqttGlobalPublishFilter filter) {
        return this.publishes(filter, false);
    }

    @Override
    @NotNull
    public Mqtt5BlockingClient.Mqtt5Publishes publishes(@Nullable MqttGlobalPublishFilter filter, boolean manualAcknowledgement) {
        Checks.notNull(filter, "Global publish filter");
        return new MqttPublishes(this.delegate.publishesUnsafe(filter, manualAcknowledgement));
    }

    @Override
    @NotNull
    public Mqtt5UnsubAck unsubscribe(@Nullable Mqtt5Unsubscribe unsubscribe) {
        MqttUnsubscribe mqttUnsubscribe = MqttChecks.unsubscribe(unsubscribe);
        try {
            if (!this.getState().isConnectedOrReconnect()) {
                throw MqttClientStateExceptions.notConnected();
            }
            return MqttBlockingClient.handleUnsubAck((Mqtt5UnsubAck)this.delegate.unsubscribeUnsafe(mqttUnsubscribe).blockingGet());
        }
        catch (RuntimeException e) {
            throw AsyncRuntimeException.fillInStackTrace(e);
        }
    }

    public  @NotNull MqttUnsubscribeBuilder.Send<Mqtt5UnsubAck> unsubscribeWith() {
        return new MqttUnsubscribeBuilder.Send<Mqtt5UnsubAck>(this::unsubscribe);
    }

    @Override
    @NotNull
    public Mqtt5PublishResult publish(@Nullable Mqtt5Publish publish) {
        MqttPublish mqttPublish = MqttChecks.publish(publish);
        try {
            return (Mqtt5PublishResult)this.delegate.publishUnsafe(mqttPublish).blockingGet();
        }
        catch (RuntimeException e) {
            throw AsyncRuntimeException.fillInStackTrace(e);
        }
    }

    public  @NotNull MqttPublishBuilder.Send<Mqtt5PublishResult> publishWith() {
        return new MqttPublishBuilder.Send<Mqtt5PublishResult>(this::publish);
    }

    @Override
    public void reauth() {
        try {
            this.delegate.reauthUnsafe().blockingAwait();
        }
        catch (RuntimeException e) {
            throw AsyncRuntimeException.fillInStackTrace(e);
        }
    }

    @Override
    public void disconnect() {
        this.disconnect(MqttDisconnect.DEFAULT);
    }

    @Override
    public void disconnect(@NotNull Mqtt5Disconnect disconnect) {
        MqttDisconnect mqttDisconnect = MqttChecks.disconnect(disconnect);
        try {
            this.delegate.disconnectUnsafe(mqttDisconnect).blockingAwait();
        }
        catch (RuntimeException e) {
            throw AsyncRuntimeException.fillInStackTrace(e);
        }
    }

    @Override
    public  @NotNull MqttDisconnectBuilder.SendVoid disconnectWith() {
        return new MqttDisconnectBuilder.SendVoid(this::disconnect);
    }

    @Override
    @NotNull
    public MqttClientConfig getConfig() {
        return this.delegate.getConfig();
    }

    @Override
    @NotNull
    public MqttRxClient toRx() {
        return this.delegate;
    }

    @Override
    @NotNull
    public MqttAsyncClient toAsync() {
        return this.delegate.toAsync();
    }

    private static class MqttPublishes
    implements Mqtt5BlockingClient.Mqtt5Publishes,
    FlowableSubscriber<Mqtt5Publish> {
        private final @NotNull AtomicReference<@Nullable Subscription> subscription = new AtomicReference();
        @NotNull
        private final NodeList<Entry> entries = new NodeList();
        @Nullable
        private Mqtt5Publish queuedPublish;
        @Nullable
        private Throwable error;

        MqttPublishes(@NotNull Flowable<Mqtt5Publish> publishes) {
            publishes.subscribe((FlowableSubscriber)this);
        }

        public void onSubscribe(@NotNull Subscription subscription) {
            if (this.subscription.compareAndSet(null, subscription)) {
                subscription.request(1L);
            } else {
                subscription.cancel();
            }
        }

        private void request() {
            Subscription subscription = this.subscription.get();
            assert (subscription != null);
            subscription.request(1L);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onNext(@NotNull Mqtt5Publish publish) {
            NodeList<Entry> nodeList = this.entries;
            synchronized (nodeList) {
                if (this.error != null) {
                    return;
                }
                Entry entry = this.entries.getFirst();
                if (entry == null) {
                    this.queuedPublish = publish;
                } else {
                    this.entries.remove(entry);
                    entry.result = publish;
                    entry.latch.countDown();
                    this.request();
                }
            }
        }

        public void onComplete() {
            this.onError(new IllegalStateException());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onError(@NotNull Throwable t) {
            NodeList<Entry> nodeList = this.entries;
            synchronized (nodeList) {
                if (this.error != null) {
                    return;
                }
                this.error = t;
                for (Entry entry = this.entries.getFirst(); entry != null; entry = (Entry)entry.getNext()) {
                    this.entries.remove(entry);
                    entry.result = t;
                    entry.latch.countDown();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        public Mqtt5Publish receive() throws InterruptedException {
            Object result;
            Entry entry;
            NodeList<Entry> nodeList = this.entries;
            synchronized (nodeList) {
                if (this.error != null) {
                    throw this.handleError(this.error);
                }
                Mqtt5Publish publish = this.receiveNowUnsafe();
                if (publish != null) {
                    return publish;
                }
                entry = new Entry();
                this.entries.add(entry);
            }
            try {
                entry.latch.await();
                result = entry.result;
                assert (result instanceof Mqtt5Publish || result instanceof Throwable);
            }
            catch (InterruptedException e) {
                result = this.tryCancel(entry, e);
            }
            if (result instanceof Mqtt5Publish) {
                return (Mqtt5Publish)result;
            }
            if (result instanceof Throwable) {
                if (result instanceof InterruptedException) {
                    throw (InterruptedException)result;
                }
                throw this.handleError((Throwable)result);
            }
            throw new IllegalStateException("This must not happen and is a bug.");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        public Optional<Mqtt5Publish> receive(long timeout, @Nullable TimeUnit timeUnit) throws InterruptedException {
            Object result;
            Entry entry;
            if (timeout < 0L) {
                throw new IllegalArgumentException("Timeout must be greater than 0.");
            }
            Checks.notNull(timeUnit, "Time unit");
            NodeList<Entry> nodeList = this.entries;
            synchronized (nodeList) {
                if (this.error != null) {
                    throw this.handleError(this.error);
                }
                Mqtt5Publish publish = this.receiveNowUnsafe();
                if (publish != null) {
                    return Optional.of(publish);
                }
                entry = new Entry();
                this.entries.add(entry);
            }
            try {
                if (entry.latch.await(timeout, timeUnit)) {
                    result = entry.result;
                    assert (result instanceof Mqtt5Publish || result instanceof Throwable);
                } else {
                    result = this.tryCancel(entry, null);
                }
            }
            catch (InterruptedException e) {
                result = this.tryCancel(entry, e);
            }
            if (result instanceof Mqtt5Publish) {
                return Optional.of((Mqtt5Publish)result);
            }
            if (result instanceof Throwable) {
                if (result instanceof InterruptedException) {
                    throw (InterruptedException)result;
                }
                throw this.handleError((Throwable)result);
            }
            return Optional.empty();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        public Optional<Mqtt5Publish> receiveNow() {
            Mqtt5Publish publish;
            NodeList<Entry> nodeList = this.entries;
            synchronized (nodeList) {
                if (this.error != null) {
                    throw this.handleError(this.error);
                }
                publish = this.receiveNowUnsafe();
            }
            return Optional.ofNullable(publish);
        }

        @Nullable
        private Mqtt5Publish receiveNowUnsafe() {
            Mqtt5Publish queuedPublish = this.queuedPublish;
            if (queuedPublish != null) {
                this.queuedPublish = null;
                this.request();
            }
            return queuedPublish;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        private Object tryCancel(@NotNull Entry entry, @Nullable Object resultOnCancel) {
            NodeList<Entry> nodeList = this.entries;
            synchronized (nodeList) {
                Object result = entry.result;
                if (result == null) {
                    this.entries.remove(entry);
                    return resultOnCancel;
                }
                assert (result instanceof Mqtt5Publish || result instanceof Throwable);
                return result;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            Subscription subscription = this.subscription.getAndSet((Subscription)SubscriptionHelper.CANCELLED);
            if (subscription != null) {
                subscription.cancel();
            }
            NodeList<Entry> nodeList = this.entries;
            synchronized (nodeList) {
                if (this.error != null) {
                    return;
                }
                this.error = new CancellationException();
                for (Entry entry = this.entries.getFirst(); entry != null; entry = (Entry)entry.getNext()) {
                    this.entries.remove(entry);
                    entry.result = this.error;
                    entry.latch.countDown();
                }
            }
        }

        @NotNull
        private RuntimeException handleError(@NotNull Throwable t) {
            if (t instanceof RuntimeException) {
                return AsyncRuntimeException.fillInStackTrace((RuntimeException)t);
            }
            throw new RuntimeException(t);
        }

        private static class Entry
        extends NodeList.Node<Entry> {
            @NotNull
            final CountDownLatch latch = new CountDownLatch(1);
            @Nullable
            Object result = null;

            private Entry() {
            }
        }
    }
}

