# pylint:disable=line-too-long
import logging

from ...sim_type import SimTypeFunction,     SimTypeShort, SimTypeInt, SimTypeLong, SimTypeLongLong, SimTypeDouble, SimTypeFloat,     SimTypePointer,     SimTypeChar,     SimStruct,     SimTypeFixedSizeArray,     SimTypeBottom,     SimUnion,     SimTypeBool
from ...calling_conventions import SimCCStdcall, SimCCMicrosoftAMD64
from .. import SIM_PROCEDURES as P
from . import SimLibrary


_l = logging.getLogger(name=__name__)


lib = SimLibrary()
lib.set_default_cc('X86', SimCCStdcall)
lib.set_default_cc('AMD64', SimCCMicrosoftAMD64)
lib.set_library_names("uxtheme.dll")
prototypes = \
    {
        #
        'GetThemeAnimationProperty': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=False, label="TA_PROPERTY"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hTheme", "iStoryboardId", "iTargetId", "eProperty", "pvProperty", "cbSize", "pcbSizeOut"]),
        #
        'GetThemeAnimationTransform': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"eTransformType": SimTypeInt(signed=False, label="TA_TRANSFORM_TYPE"), "dwTimingFunctionId": SimTypeInt(signed=False, label="UInt32"), "dwStartTime": SimTypeInt(signed=False, label="UInt32"), "dwDurationTime": SimTypeInt(signed=False, label="UInt32"), "eFlags": SimTypeInt(signed=False, label="TA_TRANSFORM_FLAG")}, name="TA_TRANSFORM", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hTheme", "iStoryboardId", "iTargetId", "dwTransformIndex", "pTransform", "cbSize", "pcbSizeOut"]),
        #
        'GetThemeTimingFunction': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimStruct({"eTimingFunctionType": SimTypeInt(signed=False, label="TA_TIMINGFUNCTION_TYPE")}, name="TA_TIMINGFUNCTION", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hTheme", "iTimingFunctionId", "pTimingFunction", "cbSize", "pcbSizeOut"]),
        #
        'OpenThemeData': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["hwnd", "pszClassList"]),
        #
        'OpenThemeDataEx': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="OPEN_THEME_DATA_FLAGS")], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["hwnd", "pszClassList", "dwFlags"]),
        #
        'CloseThemeData': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hTheme"]),
        #
        'DrawThemeBackground': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimStruct({"left": SimTypeInt(signed=True, label="Int32"), "top": SimTypeInt(signed=True, label="Int32"), "right": SimTypeInt(signed=True, label="Int32"), "bottom": SimTypeInt(signed=True, label="Int32")}, name="RECT", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"left": SimTypeInt(signed=True, label="Int32"), "top": SimTypeInt(signed=True, label="Int32"), "right": SimTypeInt(signed=True, label="Int32"), "bottom": SimTypeInt(signed=True, label="Int32")}, name="RECT", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hTheme", "hdc", "iPartId", "iStateId", "pRect", "pClipRect"]),
        #
        'DrawThemeBackgroundEx': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimStruct({"left": SimTypeInt(signed=True, label="Int32"), "top": SimTypeInt(signed=True, label="Int32"), "right": SimTypeInt(signed=True, label="Int32"), "bottom": SimTypeInt(signed=True, label="Int32")}, name="RECT", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"dwSize": SimTypeInt(signed=False, label="UInt32"), "dwFlags": SimTypeInt(signed=False, label="UInt32"), "rcClip": SimStruct({"left": SimTypeInt(signed=True, label="Int32"), "top": SimTypeInt(signed=True, label="Int32"), "right": SimTypeInt(signed=True, label="Int32"), "bottom": SimTypeInt(signed=True, label="Int32")}, name="RECT", pack=False, align=None)}, name="DTBGOPTS", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hTheme", "hdc", "iPartId", "iStateId", "pRect", "pOptions"]),
        #
        'DrawThemeText': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"left": SimTypeInt(signed=True, label="Int32"), "top": SimTypeInt(signed=True, label="Int32"), "right": SimTypeInt(signed=True, label="Int32"), "bottom": SimTypeInt(signed=True, label="Int32")}, name="RECT", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hTheme", "hdc", "iPartId", "iStateId", "pszText", "cchText", "dwTextFlags", "dwTextFlags2", "pRect"]),
        #
        'GetThemeBackgroundContentRect': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimStruct({"left": SimTypeInt(signed=True, label="Int32"), "top": SimTypeInt(signed=True, label="Int32"), "right": SimTypeInt(signed=True, label="Int32"), "bottom": SimTypeInt(signed=True, label="Int32")}, name="RECT", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"left": SimTypeInt(signed=True, label="Int32"), "top": SimTypeInt(signed=True, label="Int32"), "right": SimTypeInt(signed=True, label="Int32"), "bottom": SimTypeInt(signed=True, label="Int32")}, name="RECT", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hTheme", "hdc", "iPartId", "iStateId", "pBoundingRect", "pContentRect"]),
        #
        'GetThemeBackgroundExtent': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimStruct({"left": SimTypeInt(signed=True, label="Int32"), "top": SimTypeInt(signed=True, label="Int32"), "right": SimTypeInt(signed=True, label="Int32"), "bottom": SimTypeInt(signed=True, label="Int32")}, name="RECT", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"left": SimTypeInt(signed=True, label="Int32"), "top": SimTypeInt(signed=True, label="Int32"), "right": SimTypeInt(signed=True, label="Int32"), "bottom": SimTypeInt(signed=True, label="Int32")}, name="RECT", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hTheme", "hdc", "iPartId", "iStateId", "pContentRect", "pExtentRect"]),
        #
        'GetThemeBackgroundRegion': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimStruct({"left": SimTypeInt(signed=True, label="Int32"), "top": SimTypeInt(signed=True, label="Int32"), "right": SimTypeInt(signed=True, label="Int32"), "bottom": SimTypeInt(signed=True, label="Int32")}, name="RECT", pack=False, align=None), offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hTheme", "hdc", "iPartId", "iStateId", "pRect", "pRegion"]),
        #
        'GetThemePartSize': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimStruct({"left": SimTypeInt(signed=True, label="Int32"), "top": SimTypeInt(signed=True, label="Int32"), "right": SimTypeInt(signed=True, label="Int32"), "bottom": SimTypeInt(signed=True, label="Int32")}, name="RECT", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="THEMESIZE"), SimTypePointer(SimStruct({"cx": SimTypeInt(signed=True, label="Int32"), "cy": SimTypeInt(signed=True, label="Int32")}, name="SIZE", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hTheme", "hdc", "iPartId", "iStateId", "prc", "eSize", "psz"]),
        #
        'GetThemeTextExtent': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"left": SimTypeInt(signed=True, label="Int32"), "top": SimTypeInt(signed=True, label="Int32"), "right": SimTypeInt(signed=True, label="Int32"), "bottom": SimTypeInt(signed=True, label="Int32")}, name="RECT", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"left": SimTypeInt(signed=True, label="Int32"), "top": SimTypeInt(signed=True, label="Int32"), "right": SimTypeInt(signed=True, label="Int32"), "bottom": SimTypeInt(signed=True, label="Int32")}, name="RECT", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hTheme", "hdc", "iPartId", "iStateId", "pszText", "cchCharCount", "dwTextFlags", "pBoundingRect", "pExtentRect"]),
        #
        'GetThemeTextMetrics': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimStruct({"tmHeight": SimTypeInt(signed=True, label="Int32"), "tmAscent": SimTypeInt(signed=True, label="Int32"), "tmDescent": SimTypeInt(signed=True, label="Int32"), "tmInternalLeading": SimTypeInt(signed=True, label="Int32"), "tmExternalLeading": SimTypeInt(signed=True, label="Int32"), "tmAveCharWidth": SimTypeInt(signed=True, label="Int32"), "tmMaxCharWidth": SimTypeInt(signed=True, label="Int32"), "tmWeight": SimTypeInt(signed=True, label="Int32"), "tmOverhang": SimTypeInt(signed=True, label="Int32"), "tmDigitizedAspectX": SimTypeInt(signed=True, label="Int32"), "tmDigitizedAspectY": SimTypeInt(signed=True, label="Int32"), "tmFirstChar": SimTypeChar(label="Char"), "tmLastChar": SimTypeChar(label="Char"), "tmDefaultChar": SimTypeChar(label="Char"), "tmBreakChar": SimTypeChar(label="Char"), "tmItalic": SimTypeChar(label="Byte"), "tmUnderlined": SimTypeChar(label="Byte"), "tmStruckOut": SimTypeChar(label="Byte"), "tmPitchAndFamily": SimTypeChar(label="Byte"), "tmCharSet": SimTypeChar(label="Byte")}, name="TEXTMETRICW", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hTheme", "hdc", "iPartId", "iStateId", "ptm"]),
        #
        'HitTestThemeBackground': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"left": SimTypeInt(signed=True, label="Int32"), "top": SimTypeInt(signed=True, label="Int32"), "right": SimTypeInt(signed=True, label="Int32"), "bottom": SimTypeInt(signed=True, label="Int32")}, name="RECT", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimStruct({"x": SimTypeInt(signed=True, label="Int32"), "y": SimTypeInt(signed=True, label="Int32")}, name="POINT", pack=False, align=None), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hTheme", "hdc", "iPartId", "iStateId", "dwOptions", "pRect", "hrgn", "ptTest", "pwHitTestCode"]),
        #
        'DrawThemeEdge': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimStruct({"left": SimTypeInt(signed=True, label="Int32"), "top": SimTypeInt(signed=True, label="Int32"), "right": SimTypeInt(signed=True, label="Int32"), "bottom": SimTypeInt(signed=True, label="Int32")}, name="RECT", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"left": SimTypeInt(signed=True, label="Int32"), "top": SimTypeInt(signed=True, label="Int32"), "right": SimTypeInt(signed=True, label="Int32"), "bottom": SimTypeInt(signed=True, label="Int32")}, name="RECT", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hTheme", "hdc", "iPartId", "iStateId", "pDestRect", "uEdge", "uFlags", "pContentRect"]),
        #
        'DrawThemeIcon': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimStruct({"left": SimTypeInt(signed=True, label="Int32"), "top": SimTypeInt(signed=True, label="Int32"), "right": SimTypeInt(signed=True, label="Int32"), "bottom": SimTypeInt(signed=True, label="Int32")}, name="RECT", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hTheme", "hdc", "iPartId", "iStateId", "pRect", "himl", "iImageIndex"]),
        #
        'IsThemePartDefined': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hTheme", "iPartId", "iStateId"]),
        #
        'IsThemeBackgroundPartiallyTransparent': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hTheme", "iPartId", "iStateId"]),
        #
        'GetThemeColor': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hTheme", "iPartId", "iStateId", "iPropId", "pColor"]),
        #
        'GetThemeMetric': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=False, label="THEME_PROPERTY_SYMBOL_ID"), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hTheme", "hdc", "iPartId", "iStateId", "iPropId", "piVal"]),
        #
        'GetThemeString': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hTheme", "iPartId", "iStateId", "iPropId", "pszBuff", "cchMaxBuffChars"]),
        #
        'GetThemeBool': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=False, label="THEME_PROPERTY_SYMBOL_ID"), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hTheme", "iPartId", "iStateId", "iPropId", "pfVal"]),
        #
        'GetThemeInt': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hTheme", "iPartId", "iStateId", "iPropId", "piVal"]),
        #
        'GetThemeEnumValue': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hTheme", "iPartId", "iStateId", "iPropId", "piVal"]),
        #
        'GetThemePosition': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimStruct({"x": SimTypeInt(signed=True, label="Int32"), "y": SimTypeInt(signed=True, label="Int32")}, name="POINT", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hTheme", "iPartId", "iStateId", "iPropId", "pPoint"]),
        #
        'GetThemeFont': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimStruct({"lfHeight": SimTypeInt(signed=True, label="Int32"), "lfWidth": SimTypeInt(signed=True, label="Int32"), "lfEscapement": SimTypeInt(signed=True, label="Int32"), "lfOrientation": SimTypeInt(signed=True, label="Int32"), "lfWeight": SimTypeInt(signed=True, label="Int32"), "lfItalic": SimTypeChar(label="Byte"), "lfUnderline": SimTypeChar(label="Byte"), "lfStrikeOut": SimTypeChar(label="Byte"), "lfCharSet": SimTypeChar(label="Byte"), "lfOutPrecision": SimTypeChar(label="Byte"), "lfClipPrecision": SimTypeChar(label="Byte"), "lfQuality": SimTypeChar(label="Byte"), "lfPitchAndFamily": SimTypeChar(label="Byte"), "lfFaceName": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 32)}, name="LOGFONTW", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hTheme", "hdc", "iPartId", "iStateId", "iPropId", "pFont"]),
        #
        'GetThemeRect': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimStruct({"left": SimTypeInt(signed=True, label="Int32"), "top": SimTypeInt(signed=True, label="Int32"), "right": SimTypeInt(signed=True, label="Int32"), "bottom": SimTypeInt(signed=True, label="Int32")}, name="RECT", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hTheme", "iPartId", "iStateId", "iPropId", "pRect"]),
        #
        'GetThemeMargins': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimStruct({"left": SimTypeInt(signed=True, label="Int32"), "top": SimTypeInt(signed=True, label="Int32"), "right": SimTypeInt(signed=True, label="Int32"), "bottom": SimTypeInt(signed=True, label="Int32")}, name="RECT", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"cxLeftWidth": SimTypeInt(signed=True, label="Int32"), "cxRightWidth": SimTypeInt(signed=True, label="Int32"), "cyTopHeight": SimTypeInt(signed=True, label="Int32"), "cyBottomHeight": SimTypeInt(signed=True, label="Int32")}, name="MARGINS", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hTheme", "hdc", "iPartId", "iStateId", "iPropId", "prc", "pMargins"]),
        #
        'GetThemeIntList': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimStruct({"iValueCount": SimTypeInt(signed=True, label="Int32"), "iValues": SimTypeFixedSizeArray(SimTypeInt(signed=True, label="Int32"), 402)}, name="INTLIST", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hTheme", "iPartId", "iStateId", "iPropId", "pIntList"]),
        #
        'GetThemePropertyOrigin': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeInt(signed=False, label="PROPERTYORIGIN"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hTheme", "iPartId", "iStateId", "iPropId", "pOrigin"]),
        #
        'SetWindowTheme': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hwnd", "pszSubAppName", "pszSubIdList"]),
        #
        'GetThemeFilename': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hTheme", "iPartId", "iStateId", "iPropId", "pszThemeFileName", "cchMaxBuffChars"]),
        #
        'GetThemeSysColor': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["hTheme", "iColorId"]),
        #
        'GetThemeSysColorBrush': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="THEME_PROPERTY_SYMBOL_ID")], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["hTheme", "iColorId"]),
        #
        'GetThemeSysBool': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hTheme", "iBoolId"]),
        #
        'GetThemeSysSize': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hTheme", "iSizeId"]),
        #
        'GetThemeSysFont': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="THEME_PROPERTY_SYMBOL_ID"), SimTypePointer(SimStruct({"lfHeight": SimTypeInt(signed=True, label="Int32"), "lfWidth": SimTypeInt(signed=True, label="Int32"), "lfEscapement": SimTypeInt(signed=True, label="Int32"), "lfOrientation": SimTypeInt(signed=True, label="Int32"), "lfWeight": SimTypeInt(signed=True, label="Int32"), "lfItalic": SimTypeChar(label="Byte"), "lfUnderline": SimTypeChar(label="Byte"), "lfStrikeOut": SimTypeChar(label="Byte"), "lfCharSet": SimTypeChar(label="Byte"), "lfOutPrecision": SimTypeChar(label="Byte"), "lfClipPrecision": SimTypeChar(label="Byte"), "lfQuality": SimTypeChar(label="Byte"), "lfPitchAndFamily": SimTypeChar(label="Byte"), "lfFaceName": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 32)}, name="LOGFONTW", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hTheme", "iFontId", "plf"]),
        #
        'GetThemeSysString': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="THEME_PROPERTY_SYMBOL_ID"), SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hTheme", "iStringId", "pszStringBuff", "cchMaxStringChars"]),
        #
        'GetThemeSysInt': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hTheme", "iIntId", "piValue"]),
        #
        'IsThemeActive': SimTypeFunction([], SimTypeInt(signed=True, label="Int32")),
        #
        'IsAppThemed': SimTypeFunction([], SimTypeInt(signed=True, label="Int32")),
        #
        'GetWindowTheme': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["hwnd"]),
        #
        'EnableThemeDialogTexture': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hwnd", "dwFlags"]),
        #
        'IsThemeDialogTextureEnabled': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hwnd"]),
        #
        'GetThemeAppProperties': SimTypeFunction([], SimTypeInt(signed=False, label="UInt32")),
        #
        'SetThemeAppProperties': SimTypeFunction([SimTypeInt(signed=False, label="UInt32")], SimTypeBottom(label="Void"), arg_names=["dwFlags"]),
        #
        'GetCurrentThemeName': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=True, label="Int32"), arg_names=["pszThemeFileName", "cchMaxNameChars", "pszColorBuff", "cchMaxColorChars", "pszSizeBuff", "cchMaxSizeChars"]),
        #
        'GetThemeDocumentationProperty': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=True, label="Int32"), arg_names=["pszThemeName", "pszPropertyName", "pszValueBuff", "cchMaxValChars"]),
        #
        'DrawThemeParentBackground': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"left": SimTypeInt(signed=True, label="Int32"), "top": SimTypeInt(signed=True, label="Int32"), "right": SimTypeInt(signed=True, label="Int32"), "bottom": SimTypeInt(signed=True, label="Int32")}, name="RECT", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hwnd", "hdc", "prc"]),
        #
        'EnableTheming': SimTypeFunction([SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=True, label="Int32"), arg_names=["fEnable"]),
        #
        'DrawThemeParentBackgroundEx': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="DRAW_THEME_PARENT_BACKGROUND_FLAGS"), SimTypePointer(SimStruct({"left": SimTypeInt(signed=True, label="Int32"), "top": SimTypeInt(signed=True, label="Int32"), "right": SimTypeInt(signed=True, label="Int32"), "bottom": SimTypeInt(signed=True, label="Int32")}, name="RECT", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hwnd", "hdc", "dwFlags", "prc"]),
        #
        'SetWindowThemeAttribute': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="WINDOWTHEMEATTRIBUTETYPE"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hwnd", "eAttribute", "pvAttribute", "cbAttribute"]),
        #
        'DrawThemeTextEx': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"left": SimTypeInt(signed=True, label="Int32"), "top": SimTypeInt(signed=True, label="Int32"), "right": SimTypeInt(signed=True, label="Int32"), "bottom": SimTypeInt(signed=True, label="Int32")}, name="RECT", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"dwSize": SimTypeInt(signed=False, label="UInt32"), "dwFlags": SimTypeInt(signed=False, label="UInt32"), "crText": SimTypeInt(signed=False, label="UInt32"), "crBorder": SimTypeInt(signed=False, label="UInt32"), "crShadow": SimTypeInt(signed=False, label="UInt32"), "iTextShadowType": SimTypeInt(signed=True, label="Int32"), "ptShadowOffset": SimStruct({"x": SimTypeInt(signed=True, label="Int32"), "y": SimTypeInt(signed=True, label="Int32")}, name="POINT", pack=False, align=None), "iBorderSize": SimTypeInt(signed=True, label="Int32"), "iFontPropId": SimTypeInt(signed=True, label="Int32"), "iColorPropId": SimTypeInt(signed=True, label="Int32"), "iStateId": SimTypeInt(signed=True, label="Int32"), "fApplyOverlay": SimTypeInt(signed=True, label="Int32"), "iGlowSize": SimTypeInt(signed=True, label="Int32"), "pfnDrawTextCallback": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimStruct({"left": SimTypeInt(signed=True, label="Int32"), "top": SimTypeInt(signed=True, label="Int32"), "right": SimTypeInt(signed=True, label="Int32"), "bottom": SimTypeInt(signed=True, label="Int32")}, name="RECT", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc", "pszText", "cchText", "prc", "dwFlags", "lParam"]), offset=0), "lParam": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="DTTOPTS", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hTheme", "hdc", "iPartId", "iStateId", "pszText", "cchText", "dwTextFlags", "pRect", "pOptions"]),
        #
        'GetThemeBitmap': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=False, label="THEME_PROPERTY_SYMBOL_ID"), SimTypeInt(signed=False, label="GET_THEME_BITMAP_FLAGS"), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hTheme", "iPartId", "iStateId", "iPropId", "dwFlags", "phBitmap"]),
        #
        'GetThemeStream': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hTheme", "iPartId", "iStateId", "iPropId", "ppvStream", "pcbStream", "hInst"]),
        #
        'BufferedPaintInit': SimTypeFunction([], SimTypeInt(signed=True, label="Int32")),
        #
        'BufferedPaintUnInit': SimTypeFunction([], SimTypeInt(signed=True, label="Int32")),
        #
        'BeginBufferedPaint': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"left": SimTypeInt(signed=True, label="Int32"), "top": SimTypeInt(signed=True, label="Int32"), "right": SimTypeInt(signed=True, label="Int32"), "bottom": SimTypeInt(signed=True, label="Int32")}, name="RECT", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="BP_BUFFERFORMAT"), SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "dwFlags": SimTypeInt(signed=False, label="BP_PAINTPARAMS_FLAGS"), "prcExclude": SimTypePointer(SimStruct({"left": SimTypeInt(signed=True, label="Int32"), "top": SimTypeInt(signed=True, label="Int32"), "right": SimTypeInt(signed=True, label="Int32"), "bottom": SimTypeInt(signed=True, label="Int32")}, name="RECT", pack=False, align=None), offset=0), "pBlendFunction": SimTypePointer(SimStruct({"BlendOp": SimTypeChar(label="Byte"), "BlendFlags": SimTypeChar(label="Byte"), "SourceConstantAlpha": SimTypeChar(label="Byte"), "AlphaFormat": SimTypeChar(label="Byte")}, name="BLENDFUNCTION", pack=False, align=None), offset=0)}, name="BP_PAINTPARAMS", pack=False, align=None), offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0)], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["hdcTarget", "prcTarget", "dwFormat", "pPaintParams", "phdc"]),
        #
        'EndBufferedPaint': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hBufferedPaint", "fUpdateTarget"]),
        #
        'GetBufferedPaintTargetRect': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"left": SimTypeInt(signed=True, label="Int32"), "top": SimTypeInt(signed=True, label="Int32"), "right": SimTypeInt(signed=True, label="Int32"), "bottom": SimTypeInt(signed=True, label="Int32")}, name="RECT", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hBufferedPaint", "prc"]),
        #
        'GetBufferedPaintTargetDC': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["hBufferedPaint"]),
        #
        'GetBufferedPaintDC': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["hBufferedPaint"]),
        #
        'GetBufferedPaintBits': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypePointer(SimStruct({"rgbBlue": SimTypeChar(label="Byte"), "rgbGreen": SimTypeChar(label="Byte"), "rgbRed": SimTypeChar(label="Byte"), "rgbReserved": SimTypeChar(label="Byte")}, name="RGBQUAD", pack=False, align=None), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hBufferedPaint", "ppbBuffer", "pcxRow"]),
        #
        'BufferedPaintClear': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"left": SimTypeInt(signed=True, label="Int32"), "top": SimTypeInt(signed=True, label="Int32"), "right": SimTypeInt(signed=True, label="Int32"), "bottom": SimTypeInt(signed=True, label="Int32")}, name="RECT", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hBufferedPaint", "prc"]),
        #
        'BufferedPaintSetAlpha': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"left": SimTypeInt(signed=True, label="Int32"), "top": SimTypeInt(signed=True, label="Int32"), "right": SimTypeInt(signed=True, label="Int32"), "bottom": SimTypeInt(signed=True, label="Int32")}, name="RECT", pack=False, align=None), offset=0), SimTypeChar(label="Byte")], SimTypeInt(signed=True, label="Int32"), arg_names=["hBufferedPaint", "prc", "alpha"]),
        #
        'BufferedPaintStopAllAnimations': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hwnd"]),
        #
        'BeginBufferedAnimation': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"left": SimTypeInt(signed=True, label="Int32"), "top": SimTypeInt(signed=True, label="Int32"), "right": SimTypeInt(signed=True, label="Int32"), "bottom": SimTypeInt(signed=True, label="Int32")}, name="RECT", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="BP_BUFFERFORMAT"), SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "dwFlags": SimTypeInt(signed=False, label="BP_PAINTPARAMS_FLAGS"), "prcExclude": SimTypePointer(SimStruct({"left": SimTypeInt(signed=True, label="Int32"), "top": SimTypeInt(signed=True, label="Int32"), "right": SimTypeInt(signed=True, label="Int32"), "bottom": SimTypeInt(signed=True, label="Int32")}, name="RECT", pack=False, align=None), offset=0), "pBlendFunction": SimTypePointer(SimStruct({"BlendOp": SimTypeChar(label="Byte"), "BlendFlags": SimTypeChar(label="Byte"), "SourceConstantAlpha": SimTypeChar(label="Byte"), "AlphaFormat": SimTypeChar(label="Byte")}, name="BLENDFUNCTION", pack=False, align=None), offset=0)}, name="BP_PAINTPARAMS", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "dwFlags": SimTypeInt(signed=False, label="UInt32"), "style": SimTypeInt(signed=False, label="BP_ANIMATIONSTYLE"), "dwDuration": SimTypeInt(signed=False, label="UInt32")}, name="BP_ANIMATIONPARAMS", pack=False, align=None), offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0)], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["hwnd", "hdcTarget", "prcTarget", "dwFormat", "pPaintParams", "pAnimationParams", "phdcFrom", "phdcTo"]),
        #
        'EndBufferedAnimation': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hbpAnimation", "fUpdateTarget"]),
        #
        'BufferedPaintRenderAnimation': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hwnd", "hdcTarget"]),
        #
        'IsCompositionActive': SimTypeFunction([], SimTypeInt(signed=True, label="Int32")),
        #
        'GetThemeTransitionDuration': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hTheme", "iPartId", "iStateIdFrom", "iStateIdTo", "iPropId", "pdwDuration"]),
        #
        'OpenThemeDataForDpi': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["hwnd", "pszClassList", "dpi"]),
    }

lib.set_prototypes(prototypes)
