/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.asta;

import java.util.HashMap;
import java.util.List;
import net.sf.mpxj.MPXJException;
import net.sf.mpxj.asta.AstaDataType;
import net.sf.mpxj.asta.ColumnDefinition;
import net.sf.mpxj.asta.MapRow;
import net.sf.mpxj.asta.TableDefinition;

class TextFileRow
extends MapRow {
    public TextFileRow(TableDefinition tableDefinition, List<String> list, boolean bl) throws MPXJException {
        super(new HashMap<String, Object>());
        ColumnDefinition[] columnDefinitionArray = tableDefinition.getColumns();
        for (int i = 0; i < columnDefinitionArray.length; ++i) {
            ColumnDefinition columnDefinition = columnDefinitionArray[i];
            if (i >= list.size() || columnDefinition == null) continue;
            this.m_map.put(columnDefinition.getName(), this.getColumnValue(tableDefinition.getName(), columnDefinition.getName(), list.get(i), columnDefinition.getType(), bl));
        }
    }

    private Object getColumnValue(String string, String string2, String string3, int n, boolean bl) throws MPXJException {
        try {
            Object object = null;
            switch (n) {
                case -7: {
                    object = AstaDataType.parseBoolean(string3);
                    break;
                }
                case -1: 
                case 12: {
                    object = AstaDataType.parseString(string3);
                    break;
                }
                case 92: {
                    object = AstaDataType.parseBasicTime(string3);
                    break;
                }
                case 93: {
                    if (bl) {
                        object = AstaDataType.parseEpochTimestamp(string3);
                        break;
                    }
                    object = AstaDataType.parseBasicTimestamp(string3);
                    break;
                }
                case 8: {
                    object = AstaDataType.parseDouble(string3);
                    break;
                }
                case 4: {
                    object = AstaDataType.parseInteger(string3);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported SQL type: " + n);
                }
            }
            return object;
        }
        catch (Exception exception) {
            throw new MPXJException("Failed to parse " + string + "." + string2 + " (data=" + string3 + ", type=" + n + ")", exception);
        }
    }
}

